/*
 * Copyright (c) 2003, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: netaccept.c,v 1.4 2005/03/24 19:55:21 ca Exp $")
#include "sm/assert.h"
#include "sm/error.h"
#include "sm/memops.h"
#include "sm/fcntl.h"
#include "sm/net.h"

/*
**  NET_SERVER_ACCEPT -- Accept an incoming network connection.
**
**	Sets the SO_KEEPALIVE sockopt.
**	Similiar to accept(2)
**
**	Parameters:
**		listenfd -- fd that we are listening on.
**		addr -- client address that is connecting.
**		addrlen -- length of addr
**	Returns:
**		New socket fd or <0 on error.
*/

sm_ret_T
net_server_accept(int listenfd, struct sockaddr *addr, sockaddr_len_T *addrlen)
{
	int connfd;
	int sockopt;

	SM_REQUIRE(listenfd >= 0);
	SM_REQUIRE(addr != NULL);
	SM_REQUIRE(addrlen != NULL);

	sockopt = 1;
	connfd = accept(listenfd, addr, addrlen);
	if (connfd == -1)
	{
		if (errno != EAGAIN)
			return sm_error_perm(SM_EM_NET, errno);
	}
	else
	{
		if (setsockopt(connfd, SOL_SOCKET, SO_KEEPALIVE,
			       (void *) &sockopt, sizeof(sockopt)) == -1)
			return sm_error_perm(SM_EM_NET, errno);
	}
	return connfd;
}
