/*
 * Copyright (c) 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: greyctl.h,v 1.3 2005/08/05 20:52:30 ca Exp $
 */

#ifndef GREYCTL_H
#define GREYCTL_H 1
#include "sm/generic.h"
#include "sm/types.h"
#include "sm/net.h"
#include "sm/greyctl.h"
#include "sm/bdb.h"
#if SM_USE_PTHREADS
#include "sm/pthread.h"
#endif
#include "sm/greycnf.h"

enum grey_type_E
{
	GREY_TYPE_NONE	= 0,
	GREY_TYPE_GREY	= 1,
	GREY_TYPE_WHITE	= 2
};
typedef enum grey_type_E grey_type_T;

struct greyentry_S
{
	ipv4_T		ge_addr;	/* IPv4 address XXX IPv6 */
	time_t		ge_time;	/* timestamp */
	time_t		ge_expire;	/* expiration timestamp */
	grey_type_T	ge_type;
};

typedef struct greyentry_S	greyentry_T, *greyentry_P;

struct greyctx_S
{
#if SM_GREYCTL_CHECK
	sm_magic_T	 sm_magic;
#endif
	greycnf_T	 greyc_cnf;

	uint		 greyc_used;	/* current # of entries */
	DB		*greyc_grey_db;
	DB		*greyc_grey_sdb;
#if SM_USE_PTHREADS
	pthread_mutex_t	 greyc_mutex;
#endif
};

sm_ret_T sm_grey_rm(DB *_db, ipv4_T _addr);

#define SM_IS_GREYCTX(greyctx)	SM_REQUIRE((greyctx) != NULL)

#endif /* GREYCTL_H */
