/*
 * Copyright (c) 2002 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: fputint.c,v 1.2 2002/05/09 16:35:30 ca Exp $")
#include "sm/error.h"
#include "sm/types.h"
#include "sm/io.h"
#include "sm/assert.h"
#include "io-int.h"
#include "fvwrite.h"

/*
**  SM_IO_FPUTUINT32 -- add an 32bit integer to the buffer for the file pointer
**
**	Parameters:
**		fp -- the file pointer for the buffer to be written to
**		n -- int to be placed in the buffer
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
sm_io_fputuint32(sm_file_T *fp, uint32_t n)
{
	sm_uio_T uio;
	sm_iov_T iov;

	SM_REQUIRE_ISA(fp, SM_FILE_MAGIC);
	iov.iov_base = (void *) &n;
	iov.iov_len = uio.uio_resid = sizeof(uint32_t);
	uio.uio_iov = &iov;
	uio.uio_iovcnt = 1;
	return sm_fvwrite(fp, &uio);
}
