/*
 * Copyright (c) 2002 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: cstreq.c,v 1.2 2002/08/27 00:04:32 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/memops.h"
#include "sm/heap.h"
#include "sm/cstr.h"

#if SM_CSTR_CHECK
/*
**  SM_CSTR_EQ -- Compare two cstrings
**
**	Parameters:
**		s1 -- first cstring
**		s2 -- second cstring
**
**	Returns:
**		whether cstrings are equal
*/

bool
sm_cstr_eq(const sm_cstr_P s1, const sm_cstr_P s2)
{
	SM_IS_CSTR(s1);
	SM_IS_CSTR(s2);
	if (s1->sm_cstr_len != s2->sm_cstr_len)
		return false;
	return sm_memeq(s1->sm_cstr_base, s2->sm_cstr_base, s1->sm_cstr_len);
}
#endif /* SM_CSTR_CHECK */
