/*
 * Copyright (c) 2003, 2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 * $Id: t-edbc.h,v 1.7 2004/12/26 04:08:59 ca Exp $
 */


#include <stdio.h>

#include "sm/assert.h"
#include "sm/string.h"
#include "sm/test.h"
#include "sm/edbc.h"
#include "edbc.h"

#define MAX_KEYS	16
#if MAX_KEYS < 16
# error MAX_KEYS_ must be 16
#endif /* MAX_KEYS < 16 */

static int Entries = 0;
uint qm_debug = 0;
static time_T next_try[MAX_KEYS];
static bool added[MAX_KEYS];
static edbc_ctx_P edbc_ctx;
static edbc_tnode_T edbc_tnode;
static edbc_node_T edbc_node_search;
static edbc_tnode_P edbc_tnode_ret;

/*
**  PRINT_TREE2 -- check and print EDB cache
**
**	Parameters:
**		edbc_ctx -- EDB cache context
**
**	Returns:
**		none
*/

static void
print_tree(edbc_ctx_P edbc_ctx)
{
	edbc_node_P edbc_node;
	time_T previous_time;
	int entries;

	edbc_node = edbc_first(edbc_ctx);
	previous_time = 0;
	entries = 0;
	while (edbc_node != NULL)
	{
		if (SmTestVerbose)
		{
			printf("tree: edbc_node=%p, time=%6ld, rcpt_id=%s\n",
				edbc_node,
				(long) edbc_node->ecn_next_try,
				edbc_node->ecn_rcpt_id);
			fflush(stdout);
		}
		SM_TEST(previous_time <= edbc_node->ecn_next_try);
		++entries;
		previous_time = edbc_node->ecn_next_try;
		edbc_node = edbc_next(edbc_ctx, edbc_node);
	}
	SM_TEST(entries == Entries);
	if (SmTestVerbose)
		printf("expected=%d, got=%d\n\n", Entries, entries);
}

/*
**  PRINT_TREE2 -- check and print EDB cache and remove every entry
**
**	Parameters:
**		edbc_ctx -- EDB cache context
**
**	Returns:
**		none
*/

static void
print_tree2(edbc_ctx_P edbc_ctx)
{
	sm_ret_T ret;
	edbc_node_P edbc_node, edbc_node_nxt;
	time_T previous_time;
	int entries;

	edbc_node = edbc_first(edbc_ctx);
	previous_time = 0;
	entries = 0;
	while (edbc_node != NULL)
	{
		edbc_node_nxt = edbc_next(edbc_ctx, edbc_node);
		if (SmTestVerbose)
		{
			printf("tree2: edbc_node=%p, time=%6ld, rcpt_id=%s\n",
				edbc_node,
				(long) edbc_node->ecn_next_try,
				edbc_node->ecn_rcpt_id);
			fflush(stdout);
		}
		SM_TEST(previous_time <= edbc_node->ecn_next_try);
		++entries;
		previous_time = edbc_node->ecn_next_try;
		ret = edbc_rm(edbc_ctx, edbc_node);
		SM_TEST(ret == SM_SUCCESS);
		edbc_node = edbc_node_nxt;
	}
	SM_TEST(entries == Entries);
}

#define TINS(i)	do { \
	ret = edbc_add(edbc_ctx, rcpt_ids[i], next_try[i], false);	\
	SM_TEST(ret == SM_SUCCESS);					\
	if (ret != SM_SUCCESS)						\
		goto error;						\
	++Entries;							\
	SM_ASSERT(next_try[i] < MAX_KEYS);				\
	added[next_try[i]] = true;					\
	edbc_node_search.ecn_next_try = next_try[i];			\
	edbc_tnode_ret = RB_FIND(edbc_tree_S, &(edbc_ctx->edbc_root),	\
				&edbc_tnode);				\
	SM_TEST(edbc_tnode_ret != NULL);				\
	intree();							\
	} while (0)

#define INTREE(i)	do { \
	edbc_node_search.ecn_next_try = next_try[i];			\
	edbc_tnode_ret = RB_FIND(edbc_tree_S, &(edbc_ctx->edbc_root),	\
				&edbc_tnode);				\
	SM_ASSERT(next_try[i] < MAX_KEYS);				\
	if (added[next_try[i]])						\
	{								\
		SM_TEST(edbc_tnode_ret != NULL);			\
		if (edbc_tnode_ret == NULL && SmTestVerbose)		\
			printf("i=%d, edbc_tnode_ret=%p\n", i, edbc_tnode_ret);\
	}								\
	else								\
	{								\
		SM_TEST(edbc_tnode_ret == NULL);			\
		if (edbc_tnode_ret != NULL && SmTestVerbose)		\
			printf("i=%d, edbc_tnode_ret=%p\n", i, edbc_tnode_ret);\
	}								\
	} while (0)

static void
intree(void)
{
	int a;

	for (a = 0; a < MAX_KEYS; a++)
		INTREE(a);
}

