/*
 * Copyright (c) 2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-dns-1.c,v 1.6 2004/12/28 05:54:25 ca Exp $")

/*
**  Test list insert algorithm used in dns_tsk_wr()
*/

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/error.h"
#include "sm/memops.h"
#include "sm/test.h"
#include "sm/dns.h"
#include "sm/dnstsk.h"
#include "sm/dns-int.h"
#include <stdio.h>

static int Verbose;

static void
test(uint n)
{
	uint i, steps;
	dns_req_P dns_req, dns_reqh;
	dns_mgr_ctx_P dns_mgr_ctx;

	dns_mgr_ctx = (dns_mgr_ctx_P) sm_zalloc(sizeof(*dns_mgr_ctx));
	if (dns_mgr_ctx == NULL)
		return;
	DNSIRQL_INIT(dns_mgr_ctx);
	DNSWRQL_INIT(dns_mgr_ctx);

	steps = 0;
	for (i = 0; i < n; i++)
	{
		dns_req = (dns_req_P) sm_zalloc(sizeof(*dns_req));
		SM_TEST(dns_req != NULL);
		if (dns_req == NULL)
			return;
		dns_req->dnsreq_endt = time(NULLT) + rand();

/*
**  NOTE: This is an exact copy of the code used in dnstsk.c: dns_tsk_wr()
**  It is used to test the simple insert algorithm.
*/

		if (DNSWRQL_EMPTY(dns_mgr_ctx))
		{
			DNSWRQL_INSERT_TAIL(dns_mgr_ctx, dns_req);
		}
		else
		{
			/*
			**  Insert dns_req at the right place in the list:
			**  start from the back and go to the front until
			**  an entry is reached whose "end time" is not
			**  greater than the one of the entry to be inserted.
			*/

			dns_reqh = DNSWRQL_LAST(dns_mgr_ctx);
			while (dns_reqh != DNSWRQL_FIRST(dns_mgr_ctx) &&
			       dns_req->dnsreq_endt < dns_reqh->dnsreq_endt)
			{
				dns_reqh = DNSWRQL_PREV(dns_reqh);
				++steps;
			}
#if SM_LIBDNS_DEBUG
			fprintf(stderr,
				"dns_tsk_wr: req=%p, reqh=%p, req->endt=%ld, reqh->ednt=%ld\n"
				, dns_req, dns_reqh, (long) dns_req->dnsreq_endt
				, (long) dns_reqh->dnsreq_endt);
#endif
			if  (dns_req->dnsreq_endt >= dns_reqh->dnsreq_endt)
				DNSWRQL_INSERT_AFTER(dns_mgr_ctx, dns_reqh,
							dns_req);
			else
				DNSWRQL_INSERT_BEFORE(dns_mgr_ctx, dns_reqh,
							dns_req);
		}
	}

	if (Verbose > 0)
		fprintf(stderr, "steps=%u, steps/n=%u\n", steps, steps/n);

	for (dns_req = DNSWRQL_FIRST(dns_mgr_ctx);
	     dns_req != DNSWRQL_END(dns_mgr_ctx);
	     dns_req = dns_reqh)
	{
		dns_reqh = DNSWRQL_NEXT(dns_req);
		if (dns_reqh == DNSWRQL_END(dns_mgr_ctx))
			break;
		SM_TEST(dns_req->dnsreq_endt <= dns_reqh->dnsreq_endt);
	}
	return;
}

int
main(int argc, char *argv[])
{
	int c;
	uint n;

	n = 10;
	Verbose = 0;
	while ((c = getopt(argc, argv, "i:n:V")) != -1)
	{
		switch (c)
		{
		  case 'i':
			srand((uint) atoi(optarg));
			break;
		  case 'n':
			n = (uint) atoi(optarg);
			break;
		  case 'V':
			++Verbose;
			break;
		  default:
/*
			usage(argv[0]);
*/
			return 1;
		}
	}

	sm_test_begin(argc, argv, "test dns_req sort");
	test(n);
	return sm_test_end();
}
