/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: occp.c,v 1.5 2005/09/29 17:17:50 ca Exp $")
#include "sm/types.h"
#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/error.h"
#include "sm/heap.h"
#include "sm/memops.h"
#include "sm/time.h"
#include "sm/mta.h"
#include "sm/occ.h"
#include "sm/qmgrdbg.h"
#include "occ.h"

#include "sm/io.h"
#define LOCK_DPRINTF(x)

#if DA_OCC_RSC
/*
**  OCC_PRINT_RSC -- print OCC context (callback for "walk" function)
**
**	Parameters:
**		key -- key (IPv4 address)
**		value -- value
**		ctx -- rsc_context (ignored)
**		walk_ctx -- fp
**
**	Returns:
**		none
**
**	Last code review: 2005-03-17 05:15:51
**	Last code change:
*/

static void
occ_print_rsc(const char *key, const void *value, void *ctx, void *walk_ctx)
{
	sm_file_T *fp;
	occ_entry_P occ_entry;

	SM_ASSERT(walk_ctx != NULL);
	fp = (sm_file_T *) walk_ctx;
	if (key == NULL || value == NULL)
		return;
	occ_entry = (occ_entry_P) value;
	sm_io_fprintf(fp,
		"occ_ipv4=%A, flags=%x, init_conc=%u, cur_conc=%u, max_conc=%u,"
		" open_se=%u, open_ta=%u, last_upd=%ld"
#if 0
		" last_conn=%ld\n"
#endif
		"\n"
		, *((ipv4_T *) key)
		, occ_entry->occe_flags
		, occ_entry->occe_init_conc
		, occ_entry->occe_cur_conc
		, occ_entry->occe_max_conc
		, occ_entry->occe_open_se
		, occ_entry->occe_open_ta
		, (long) occ_entry->occe_last_upd
#if 0
		, (long) occ_entry->occe_last_conn
#endif
		);
}
#endif /* DA_OCC_RSC */

/*
**   OCC_PRINT -- print OCC content
**
**	Parameters:
**		occ_ctx -- OCC context
**		fp -- fp for output
**		locktype -- kind of locking
**
**	Returns:
**		usual sm_error code
**
**	Locking: locks occ_ctx if requested
**
**	Last code review: 2005-03-17 05:17:20
**	Last code change:
*/

sm_ret_T
occ_print(occ_ctx_P occ_ctx, sm_file_T *fp, thr_lock_T locktype)
{
	int r;
	sm_ret_T ret;

	SM_IS_OCCX(occ_ctx);
	if (thr_lock_it(locktype))
	{
		r = smthread_mutex_lock(&(occ_ctx->occx_mutex));
		SM_LOCK_OK(r);
		if (r != 0)
			return sm_error_perm(SM_EM_OCC, r);
	}
	ret = SM_SUCCESS;

#if DA_OCC_RSC
	ret = rsc_walk(occ_ctx->occx_ht, occ_print_rsc, (void *)fp,
			THR_NO_LOCK);
#else
	ret = bht_walk(occ_ctx->occx_ht, occ_print_bht, (void *)fp);
#endif

	if ((!sm_is_err(ret) && thr_unl_no_err(locktype))
	    || (sm_is_err(ret) && thr_unl_if_err(locktype)))
	{
		r = smthread_mutex_unlock(&(occ_ctx->occx_mutex));
		SM_ASSERT(r == 0);
		if (r != 0 && sm_is_success(ret))
			ret = sm_error_perm(SM_EM_OCC, r);
	}
	return ret;
}
