/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: cdbctx.c,v 1.7 2005/04/07 17:49:27 ca Exp $
 */

#include "sm/generic.h"
#include "sm/magic.h"
#include "sm/cdb.h"
#include "cdb.h"

/*
**  CDB_START -- create a CDB context
**
**	Parameters:
**		base -- base name of CDB
**		pcdb_ctx -- (pointer to) CDB context (output)
**
**	Returns:
**		usual sm_error code; ENOMEM
**
**	Last code review: 2005-03-17 18:26:53
**	Last code change:
*/

sm_ret_T
cdb_start(const char *base, cdb_ctx_P *pcdb_ctx)
{
	size_t l;
	sm_ret_T ret;
	cdb_ctx_P cdb_ctx;

	SM_REQUIRE(base != NULL);
	SM_REQUIRE(pcdb_ctx != NULL);

	cdb_ctx = (cdb_ctx_P) sm_zalloc(sizeof(*cdb_ctx));
	if (cdb_ctx == NULL)
		goto enomem;

	if (base != NULL && *base != '\0')
	{
		l = strlen(base) + 1;
		cdb_ctx->cdbx_base = (char *) sm_malloc(l);
		if (cdb_ctx->cdbx_base == NULL)
			goto enomem;
		strlcpy(cdb_ctx->cdbx_base, base, l);
	}
	cdb_ctx->sm_magic = SM_CDB_MAGIC;
	*pcdb_ctx = cdb_ctx;
	return SM_SUCCESS;

  enomem:
	ret = sm_error_temp(SM_EM_CDB, ENOMEM);
	if (cdb_ctx != NULL)
	{
		if (cdb_ctx->cdbx_base != NULL)
			sm_free(cdb_ctx->cdbx_base);
		sm_free_size(cdb_ctx, sizeof(*cdb_ctx));
	}
	return ret;
}

/*
**  CDB_END -- free a CDB context
**
**	Parameters:
**		cdb_ctx -- CDB context
**
**	Returns:
**		SM_SUCCESS
**
**	Last code review: 2005-03-17 18:26:37
**	Last code change:
*/

sm_ret_T
cdb_end(cdb_ctx_P cdb_ctx)
{
	if (cdb_ctx == NULL)
		return SM_SUCCESS;
	if (cdb_ctx->cdbx_base != NULL)
		sm_free(cdb_ctx->cdbx_base);
	cdb_ctx->sm_magic = SM_MAGIC_NULL;
	sm_free_size(cdb_ctx, sizeof(*cdb_ctx));
	return SM_SUCCESS;
}
