/*
 * Copyright (c) 2000-2003 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: rpool.h,v 1.26 2005/06/16 00:09:34 ca Exp $
 */

/*
**  Resource pools
**  See rpool.html for documentation.
*/

#ifndef SM_RPOOL_H
#define SM_RPOOL_H 1

#include "sm/generic.h"
#include "sm/magic.h"
#include "sm/string.h"
#include "sm/heap.h"

typedef void (*sm_rp_rsrcfree_T)(void *_rcontext);
typedef sm_rp_rsrcfree_T	*sm_rpool_attach_T;
typedef struct sm_rpool_S	*sm_rpool_P;
typedef struct sm_rpool_S	 sm_rpool_T;

/* only free non-rpool allocated memory */
#define sm_rpool_free(rpool, ptr) do		\
	{					\
		if ((rpool) == NULL)		\
			sm_free(ptr);		\
	} while (0)

#define sm_rpool_free_size(rpool, ptr, size) do		\
	{						\
		if ((rpool) == NULL)			\
			sm_free_size((ptr), (size));	\
	} while (0)

#define SM_RPOOL_FREE(rpool, ptr) do			\
	{						\
		if ((ptr) != NULL)			\
		{					\
			if ((rpool) == NULL)		\
				sm_free(ptr);		\
			(ptr) = NULL;			\
		}					\
	} while (0)

#define SM_RPOOL_FREE_SIZE(rpool, ptr, size) do		\
	{						\
		if ((ptr) != NULL)			\
		{					\
			if ((rpool) == NULL)		\
				sm_free_size((ptr), (size));	\
			(ptr) = NULL;			\
		}					\
	} while (0)

/* function declarations */

sm_rpool_P	sm_rpool_new(sm_rpool_P _parent);

void		sm_rpool_delete(sm_rpool_P _rpool);

#if SM_HEAP_CHECK
void		*sm_rpool_malloc_tagged(sm_rpool_P _rpool,
				size_t _size,
				char *_file,
				int _line,
				int _group);
# define sm_rpool_malloc(rpool, size) \
	sm_rpool_malloc_tagged(rpool, size, __FILE__, __LINE__, SmHeapGroup)

void		*sm_rpool_zalloc_tagged(sm_rpool_P _rpool,
				size_t _size,
				char *_file,
				int _line,
				int _group);
# define sm_rpool_zalloc(rpool, size) \
	sm_rpool_zalloc_tagged(rpool, size, __FILE__, __LINE__, SmHeapGroup)


void		*sm_rpool_realloc_tagged(sm_rpool_P _rpool,
				void *_oldptr, size_t _oldsize, size_t _newsize,
				char *_file, int _line, int _group);
# define sm_rpool_realloc(rpool, oldptr, oldsize, newsize) \
	sm_rpool_realloc_tagged(rpool, oldptr, oldsize, newsize, \
				__FILE__, __LINE__, SmHeapGroup)

#else /* SM_HEAP_CHECK */

# define sm_rpool_malloc_tagged(rpool, size, file, line, grp)	\
	sm_rpool_malloc(rpool, size)
# define sm_rpool_zalloc_tagged(rpool, size, file, line, grp)	\
	sm_rpool_zalloc(rpool, size)
# define sm_rpool_realloc_tagged(rpool, ptr, size, file, line, grp)	\
	sm_rpool_realloc(rpool, ptr, size)

void	*sm_rpool_malloc(sm_rpool_P _rpool, size_t _size);
void	*sm_rpool_zalloc(sm_rpool_P _rpool, size_t _size);
void	*sm_rpool_realloc(sm_rpool_P _rpool, void *_oldptr,
				size_t _oldsize, size_t _newsize);
#endif /* SM_HEAP_CHECK */

char	*sm_rpool_strdup(sm_rpool_P _rpool, const char *_str);
void	*sm_rpool_memdup(sm_rpool_P _rpool, const void *_ptr, size_t _l);

#if 0
/* allow str to be NULL */
#define SM_RPOOL_STRDUP_NULL_X(rpool, str)	\
		((str) == NULL)	? NULL : sm_rpool_strdup_x((rpool), (str))
#endif

sm_rpool_attach_T	sm_rpool_attach(sm_rpool_P _rpool,
					sm_rp_rsrcfree_T _rfree,
					void *_rcontext);

#define sm_rpool_detach(a) ((void)(*(a) = NULL))

void	sm_rpool_setsizes(sm_rpool_P _rpool,
				size_t _poolsize,
				size_t _bigobjectsize,
				size_t _maxsize);

#endif /* ! SM_RPOOL_H */
