/*
 * Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: rdibdb.h,v 1.12 2005/06/16 00:09:34 ca Exp $
 */

#ifndef SM_RDIBDB_H
#define SM_RDIBDB_H 1

/* context for *_action() calls (and probably others later on) */
typedef struct ri_ctx_S	ri_ctx_T, *ri_ctx_P;

struct ri_ctx_S
{
	qmgr_ctx_P	 rix_qmgr_ctx;	/* QMGR context */
	ibdbr_ctx_P	 rix_ibdbrc;	/* IBDB recovery context */
	aq_ta_P		 rix_aq_ta;	/* AQ TA */
	aq_rcpt_P	 rix_aq_rcpt;	/* AQ RCPT */
	edb_req_hd_T	 rix_edb_req_hd; /* EDB request list */
	edb_req_P	 rix_edb_req;	/* EDB request */
	bht_P		 rix_bht_ta;	/* bhtable TA */
	bht_P		 rix_bht_rcpt;	/* bhtable RCPT */
	time_T		 rix_time;	/* timestamp */
	uint		 rix_ntas;	/* number of TAs */
	uint		 rix_nrcpts;	/* number of RCPTs */
	id_count_T	 rix_last_id;	/* last used SMTPS id counter */
};

/* IDBR */
sm_ret_T qm_rdibdb(qmgr_ctx_P _qmgr_ctx);

sm_ret_T qm_ri_ctx_free(ri_ctx_P _ri_ctx);
sm_ret_T qm_ri_ctx_new(qmgr_ctx_P qmgr_ctx, ri_ctx_P *_pri_ctx);

sm_ret_T qm_ribdb(ri_ctx_P _ri_ctx);

#endif /* SM_RDIBDB_H */
