/*
 * Copyright (c) 2002, 2003 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: thread.h,v 1.4 2003/04/29 17:00:03 ca Exp $
 */

#ifndef ISC_THREAD_H
#define ISC_THREAD_H

#include "sm/generic.h"

#if SM_USE_PTHREADS

#include "sm/pthread.h"

/* XXX Need to check results of lock/unlock at least! */
#define LOCK(x)		pthread_mutex_lock(x)
#define UNLOCK(x)	pthread_mutex_unlock(x)
#define DESTROYLOCK(x)	pthread_mutex_destroy(x)

#define isc_mutex_init(x)	pthread_mutex_init(x, NULL)

#define isc_mutex_t	pthread_mutex_t

#else /* SM_USE_PTHREADS */

/* XXX HACK XXX */

#define LOCK(x)		0
#define UNLOCK(x)	0
#define DESTROYLOCK(x)	0

#define isc_mutex_init(x)	0

#endif /* SM_USE_PTHREADS */

#endif /* ISC_THREAD_H */
