#!/bin/sh
# $Id: t-smtpf.sh,v 1.38 2005/10/21 18:02:20 ca Exp $
# Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test error handling from different components
# run smtp1.sh with different parameters
# ----------------------------------------
#
test -s stop && exit 1
#

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh
I=""
ERRS=0
EDBROK="../qmgr/t-smtpf-edbr.ok"
SKIP=""

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# cd to right directory (where the programs will be executed).
cd ../qmgr || exit 1
rm -f ${MTMAP}

# run some test programs

# Note: the test programs which rely on failures from SMAR work only if
# SMAR has been compiled with -DSMAR_TEST!
SMAR_TEST=false
../smar/smar -D | ${GREP} "SMAR_TEST" >/dev/null && SMAR_TEST=true

TEST=1
# ----------------------------------------
# permanent failure from SMTP sink
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
if ${SHELL} ${SD}/smtp1.sh $@ -E 2 -S"a1@b.c" -R"550@y.z"
then
    :
else
    ERRS=`expr ${ERRS} + 1 `
    echo "$0: test ${TEST} failed"
    test X"${SM_STOPONERROR}" != X && exit 1
fi
fi

TEST=2
# ----------------------------------------
# permanent failure from SMAR
if ${SMAR_TEST}
then
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
if ${SHELL} ${SD}/smtp1.sh $@ -E 1 -S"a2@b.c" -R"smarp@p.z"
then
    :
else
    ERRS=`expr ${ERRS} + 1 `
    echo "$0: test ${TEST} failed"
    test X"${SM_STOPONERROR}" != X && exit 1
fi
fi
fi

TEST=3
# ----------------------------------------
# temporary failure from SMAR

${CAT} > ${EDBROK} <<EOF
got transaction
	mail=<a3@b.c>
	rcpts_tot=1
	rcpts_left=1
	rcpts_temp=1
	rcpts_perm=0
	state=481
	aqt_rcpts_ar=0
got recipient
	rcpt=<smart@t.z>
	aqr_rcpt_idx=0
	aqr_da_idx=0
	aqr_status=481
EOF
if ${SMAR_TEST}
then
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
if ${SHELL} ${SD}/smtp1.sh $@ -O ${EDBROK} -E 0 -A 1 -X 0 -S"a3@b.c" -R"smart@t.z"
then
    :
else
    ERRS=`expr ${ERRS} + 1 `
    echo "$0: test ${TEST} failed"
    test X"${SM_STOPONERROR}" != X && exit 1
fi
fi
fi

TEST=4
# ----------------------------------------
# temporary failure from SMTP sink for recipient
${CAT} > ${EDBROK} <<EOF
got transaction
	mail=<ts@b.c>
	rcpts_tot=1
	rcpts_left=1
	rcpts_temp=1
	rcpts_perm=0
	state=450
	aqt_rcpts_ar=0
got recipient
	rcpt=<450@y.z>
	aqr_rcpt_idx=0
	aqr_da_idx=0
	aqr_status=450
EOF

if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
if ${SHELL} ${SD}/smtp1.sh $@ -O ${EDBROK} -S"ts@b.c" -R"450@y.z"
then
    :
else
    ERRS=`expr ${ERRS} + 1 `
    echo "$0: test ${TEST} failed"
    test X"${SM_STOPONERROR}" != X && exit 1
fi
fi

TEST=5
# ----------------------------------------
# both failures from SMAR
${CAT} > ${EDBROK} <<EOF
got transaction
	mail=<a5@b.c>
	rcpts_tot=3
	rcpts_left=1
	rcpts_temp=1
	rcpts_perm=0
	state=0
	aqt_rcpts_ar=0
got recipient
	rcpt=<smart@t.z>
	aqr_rcpt_idx=0
	aqr_da_idx=0
	aqr_status=481
EOF

if ${SMAR_TEST}
then
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
if ${SHELL} ${SD}/smtp1.sh $@ -O ${EDBROK} -E 1 -A 1 -S"a5@b.c" -R"smart@t.z  -Rsmarp@p.z"
then
    :
else
    ERRS=`expr ${ERRS} + 1 `
    echo "$0: test ${TEST} failed"
    test X"${SM_STOPONERROR}" != X && exit 1
fi
fi
fi

TEST=6
# ----------------------------------------
# failures from SMAR and SMTP sink (recipient)
${CAT} > ${EDBROK} <<EOF
got transaction
	mail=<tp@b.c>
	rcpts_tot=5
	rcpts_left=2
	rcpts_temp=2
	rcpts_perm=0
	state=0
	aqt_rcpts_ar=0
got recipient
	rcpt=<smart@t.z>
	aqr_rcpt_idx=0
	aqr_da_idx=0
	aqr_status=481
got recipient
	rcpt=<451@y.z>
	aqr_rcpt_idx=3
	aqr_da_idx=0
	aqr_status=451
EOF

if ${SMAR_TEST}
then
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
if ${SHELL} ${SD}/smtp1.sh $@ -Q '-s 2' -s 12 -O ${EDBROK} -E 3 -S"tp@b.c" -R"smart@t.z  -Rsmarp@p.z -R550@y.z -R451@y.z"
then
    :
else
    ERRS=`expr ${ERRS} + 1 `
    echo "$0: test ${TEST} failed"
    test X"${SM_STOPONERROR}" != X && exit 1
fi
fi
fi

TEST=7
# ----------------------------------------
# failure/success from SMTP sink (recipients)
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
if ${SHELL} ${SD}/smtp1.sh $@ -E 4 -S"a7@b.c" -R"550@y.z -Rok@y.z -R551@y.z"
then
    :
else
    ERRS=`expr ${ERRS} + 1 `
    echo "$0: test ${TEST} failed"
    test X"${SM_STOPONERROR}" != X && exit 1
fi
fi


TEST=8
# ----------------------------------------
# failure/success from SMAR and SMTP sink (recipients)
if ${SMAR_TEST}
then
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
if ${SHELL} ${SD}/smtp1.sh $@ -s 12 -E '(3|4)' -S"a8@b.c" -R"550@y.z -Rok@y.z -Rsmarp@p.z"
then
    :
else
    ERRS=`expr ${ERRS} + 1 `
    echo "$0: test ${TEST} failed"
    test X"${SM_STOPONERROR}" != X && exit 1
fi
fi
fi

TEST=9
# ----------------------------------------
# multiple deliveries to multiple destinations
# this is test to make sure that multiple destinations are tried
# even after the data is stored in DEFEDB
if ${SMAR_TEST}
then
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
if ${SHELL} ${SD}/smtp1.sh $@ -i 30 -o 25 -s 90 -E 2 -C '-O 5' -S"a9@b.c" -R451@m.x.y
then
    :
else
    ERRS=`expr ${ERRS} + 1 `
    echo "$0: test ${TEST} failed"
    test X"${SM_STOPONERROR}" != X && exit 1
fi
fi
fi


TEST=10
# ----------------------------------------
# multiple recipients to a destination with multiple IP addresses
if ${SMAR_TEST}
then
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
if ${SHELL} ${SD}/smtp1.sh $@ -s 10 -E 4 -C '-O 5' -S"a10@b.c" -R"r1@m.x.y -Rr2@m.x.y -Rr3@m.x.y -Rr4@m.x.y"
then
    :
else
    echo "$0: test ${TEST} failed"
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit 1
fi
fi
fi

# ----------------------------------------
# end
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
