#!/bin/sh
# $Id: t-smtpe-0.sh,v 1.10 2005/10/21 18:02:20 ca Exp $
# Copyright (c) 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test permanent failure from SMTP sink for all recipients;
# trigger a recoverable error in bounce handling
# uses smtp1.sh
# ----------------------------------------
#
test -s stop && exit 1
#

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh

I=""
ERRS=0
SKIP=""
VERBOSE=false

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# cd to right directory (where the programs will be executed).
cd ../qmgr || exit 1

if ./qmgr -VVV 2>/dev/null | ${GREP} QMGR_TEST >/dev/null
then
  :
else
  echo "$0: qmgr not compiled with QMGR_TEST; test SKIPPED"
  exit 0
fi

# create aliases
${CAT} > ${ALI} <<EOF
abuse:	local:
postmaster:	local:
user:	local:
sender: local:
EOF
# create map
rm -f ${ALIMAP}
${MM} < ${ALI}
rm -f ${MTMAP}

# run some test programs

TEST=1
# ----------------------------------------
# permanent failure from SMTP for all recipients
# trigger error in bounce handling: "overflow" error message string,
# hence a second bounce messages must be generated.

if echo " ${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false
if ${SHELL} ${SD}/smtp1.sh -i 4 -s 10 -3 lmtpsock -E 2 -Q '-t 1' -Ssender@local.dom -R"550@local.host -R551@local.host"
then
    test -s ${B1} || ERR=true
    test -s ${B2} || ERR=true
else
    ERR=true
fi

if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
fi
fi

# ----------------------------------------
# end
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
