#!/bin/sh
# $Id: t-alias-3.sh,v 1.6 2005/10/21 18:02:19 ca Exp $
# Copyright (c) 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test alias expansion flag: replace_macros, preserve_domain
# uses smtpcnf.sh
# ----------------------------------------
#
test -s stop && exit 1
#

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh

I=""
OUT="t-alias-1.out"

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# cd to working directory for alias file!
cd ../qmgr || exit 1

# create aliases
${CAT} > ${ALI} <<EOF
abuse:	local:
postmaster:	local:
sender: local:
user:	local:
user+*:	local:
comm++: user+\${detail}
rewrite: user+rewrite
star*: user\${extension}
EOF
# create map
rm -f ${ALIMAP}
${MM} < ${ALI}

# create mailertable (save old version?)
${CAT} > ${MT} <<EOF
local.dom	lmtp:
alsolocal.dom	lmtp:
some.dom	[127.0.0.1]
EOF

# ----------------------------------------
${CAT} > ${SMXCNF} <<EOF
qmgr { Log_Level = 12; wait_for_server=4; wait_for_client=4;
}
smar {
aliases { flags = {replace_macros, preserve_domain} }
#debug_level=7;
Log_Level = 12;
nameserver = ${NS};
DNS_timeout = 5;
}
smtpc { Log_Level = 12; remote_port=${SNKPORT}; wait_for_server=4; }
smtps {
Log_Level = 14;
daemon_address = localhost:${SRVPORT};
wait_for_server=4;
}
EOF


# ----------------------------------------
# test: send mail to local address

TEST=1
if echo " ${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false

if ${SHELL} ${SD}/smtpcnf.sh -a '-d 8' -3 lmtpsock -Ssender@local.dom -Rcomm+detail1@local.dom -E 0 -X 0 -A 1
then
  if test -s ${B1}
  then
    :
  else
    ERR=true
  fi
else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
fi
rm -f ${B1}
else
  ${VERBOSE} && echo "$0: test ${TEST} SKIPPED"
fi

# ----------------------------------------
# test: send mail to local alias which is rewritten

TEST=2
if echo " ${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false

if ${SHELL} ${SD}/smtpcnf.sh -B '-d 1' -3 lmtpsock -Ssender@local.dom -Rrewrite@local.dom -E 0 -X 0 -A 1
then
  if test -s ${B1}
  then
    if ${GREP} 'RCPT To:<user+rewrite@local.dom>' ${LMTPL} >/dev/null
    then
      :
    else
      ${VERBOSE} && echo "$0: test ${TEST}: address not rewritten"
      ERR=true
    fi
  else
    ERR=true
  fi
else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
fi
rm -f ${B1}
else
  ${VERBOSE} && echo "$0: test ${TEST} SKIPPED"
fi


# ----------------------------------------
# test: send mail to local alias which is rewritten

TEST=3
if echo " ${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false

if ${SHELL} ${SD}/smtpcnf.sh -a '-d 7' -B '-d 1' -3 lmtpsock -Ssender@local.dom -Rstar@local.dom -E 0 -X 0 -A 1
then
  if test -s ${B1}
  then
    if ${GREP} 'RCPT To:<user@local.dom>' ${LMTPL} >/dev/null
    then
      :
    else
      ${VERBOSE} && echo "$0: test ${TEST}: address not rewritten"
      ERR=true
    fi
  else
    ERR=true
  fi
else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
fi
rm -f ${B1}
else
  ${VERBOSE} && echo "$0: test ${TEST} SKIPPED"
fi

# ----------------------------------------
# test: send mail to local alias which is rewritten

TEST=4
if echo " ${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false

if ${SHELL} ${SD}/smtpcnf.sh -B '-d 1' -3 lmtpsock -Ssender@local.dom -Rstar+@local.dom -E 0 -X 0 -A 1
then
  if test -s ${B1}
  then
    if ${GREP} 'RCPT To:<user+@local.dom>' ${LMTPL} >/dev/null
    then
      :
    else
      echo "$0: test ${TEST}: address not rewritten"
      ERR=true
    fi
  else
    ERR=true
  fi
else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
fi
rm -f ${B1}
else
  ${VERBOSE} && echo "$0: test ${TEST} SKIPPED"
fi


# ----------------------------------------
# test: send mail to local alias which is rewritten

TEST=5
if echo " ${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false

if ${SHELL} ${SD}/smtpcnf.sh -B '-d 1' -3 lmtpsock -Ssender@local.dom -Rstar+stardetail@local.dom -E 0 -X 0 -A 1
then
  if test -s ${B1}
  then
    if ${GREP} 'RCPT To:<user+stardetail@local.dom>' ${LMTPL} >/dev/null
    then
      :
    else
      echo "$0: test ${TEST}: address not rewritten"
      ERR=true
    fi
  else
    ERR=true
  fi
else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
fi
rm -f ${B1}
else
  ${VERBOSE} && echo "$0: test ${TEST} SKIPPED"
fi


rm -f ${MTMAP} ${ALIMAP}
# ----------------------------------------
# end
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
