/*
 * Copyright (c) 2002, 2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-str0.c,v 1.4 2004/12/29 23:47:29 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/error.h"
#include "sm/rpool.h"
#include "sm/test.h"
#include "sm/str.h"

#include <stdio.h>

#define SMAXLEN	256

static void
test_harness(sm_rpool_P a)
{
	int i;
	sm_str_P s;
	sm_str_T save;

	/* XXX last character of the string is tested below! */
	char *magic = "magic buf";

	s = sm_str_scpy0(a, magic, SMAXLEN);
	SM_TEST(s != NULL);
	SM_TEST(sm_str_getlen(s) == strlen(magic));
	SM_TEST(SM_STR_LAST(s) == magic[strlen(magic) - 1]);
	SM_TEST(SM_STR_LAST(s) == 'f');
	sm_str_free(s);

	s = sm_str_scpyn0(a, magic, strlen(magic) + 1, SMAXLEN);
	SM_TEST(s != NULL);
	SM_TEST(sm_str_getlen(s) == strlen(magic));
	SM_TEST(strcmp((char *) sm_str_data(s), magic) == 0);
	SM_TEST(SM_STR_LAST(s) == magic[strlen(magic) - 1]);
	SM_TEST(SM_STR_LAST(s) == 'f');
	SM_TEST(sm_str_scat0(s, magic) == SM_SUCCESS);
	SM_TEST(sm_str_getlen(s) == 2 * strlen(magic));
	sm_str_clr(s);
	SM_TEST(sm_str_getlen(s) == 0);
	SM_TEST(sm_str_scatn0(s, magic, strlen(magic) + 1) == SM_SUCCESS);
	SM_TEST(sm_str_getlen(s) == strlen(magic));
	SM_TEST(strcmp(magic, (char *)  sm_str_data(s)) == 0);

	sm_str_free(s);

	s = sm_str_new(NULL, 10, 100);
	SM_TEST(s != NULL);
	for (i = 0; i < 99; i++)
		SM_TEST(SM_STR_PUT(s, ':') == SM_SUCCESS);
	SM_STR_SAVE(*s, save);
	SM_TEST(sm_str_getlen(s) == 99);
	SM_TEST(SM_STR_PUT(s, ':') == SM_SUCCESS);
	SM_TEST(SM_STR_PUT(s, ':') != SM_SUCCESS);
	SM_TEST(sm_str_getlen(s) == 100);
	SM_STR_RESTORE(*s, save);
	SM_TEST(sm_str_getlen(s) == 99);
	sm_str_free(s);

}

int
main(int argc, char *argv[])
{
	sm_rpool_P a;

	sm_test_begin(argc, argv, "test str_s*0()");

	/* create an rpool for entire test */
	a = sm_rpool_new(NULL);
	SM_TEST(a != NULL);
	test_harness(a);
	sm_rpool_delete(a);

	/* test without rpool */
	test_harness(NULL);
	return sm_test_end();
}
