/*
 * Copyright (c) 2002, 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_IDSTR(id, "@(#)$Id: t-filecat.c,v 1.10 2005/05/31 21:00:28 ca Exp $")
#include "sm/error.h"
#include "sm/io.h"
#include "sm/test.h"
#include <stdio.h>

#define SM_BUFSIZE	8192

static void
prterr(char *msg, sm_ret_T res)
{
	if (res != SM_IO_EOF)
	{
		fprintf(stderr, "%s: res=%x, type=%d, value=%d\n", msg,
			res, sm_error_type(res), sm_error_value(res));
#if HAVE_STRERROR
		fprintf(stderr, "%s: %s\n", msg, strerror(sm_error_value(res)));
#endif /* HAVE_STRERROR */
	}
	else
		fprintf(stderr, "%s: EOF\n", msg);
}

static void
filecopy(sm_file_T *inf, sm_file_T *outf)
{
	size_t l;
	ssize_t rr, rw;
	sm_ret_T res;
	uchar buf[SM_BUFSIZE];

	for (;;)
	{
		l = sizeof(buf);
		res = sm_io_read(inf, buf, l, &rr);
		if (sm_is_err(res))
		{
			prterr("read", res);
			return;
		}
		SM_TEST((size_t) rr == l);
		l = rr;
		res = sm_io_write(outf, buf, rr, &rw);
		if (sm_is_err(res))
		{
			prterr("write", res);
			return;
		}
		SM_TEST((size_t) rw == l);
	}
}

int
main(int argc, char *argv[])
{
	sm_ret_T res;
	int timeout;

	timeout = 1;
	sm_test_begin(argc, argv, "test file read/write");
	res = sm_io_setinfo(smioin, SM_IO_WHAT_TIMEOUT, &timeout);
	SM_TEST(sm_is_success(res));
	res = sm_fp_nonblock(smioin, true);
	SM_TEST(sm_is_success(res));
	res = sm_fp_nonblock(smioout, true);
	SM_TEST(sm_is_success(res));
	res = sm_io_setinfo(smioout, SM_IO_WHAT_TIMEOUT, &timeout);
	SM_TEST(sm_is_success(res));
	filecopy(smioin, smioout);
	res = sm_io_flush(smioout);
	SM_TEST(sm_is_success(res));
	res = sm_io_close(smioout);
	SM_TEST(sm_is_success(res));
	res = sm_io_close(smioin);
	SM_TEST(sm_is_success(res));
	return sm_test_end();
}
