#!/bin/sh
# $Id: t-stthreadssignal.sh,v 1.2 2005/01/10 21:33:04 ca Exp $
# Copyright (c) 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
#
test -s stop && exit 1
R=0
# 
# program used in these tests
PRG=t-stthreadssignal
OUT=t-stthreadssignal.out
OK=t-stthreadssignal.ok

rm -f ${OUT}

./${PRG} > ${OUT} 2>/dev/null &
P=$!
# wait a bit
sleep 2
# send USR1
kill -USR1 ${P} || R=`expr ${R} + 1 `
sleep 1
kill -USR2 ${P} || R=`expr ${R} + 1 `
sleep 1
kill -USR1 ${P} || R=`expr ${R} + 1 `
sleep 1
kill -TERM ${P} || R=`expr ${R} + 1 `
sleep 1
# process should be gone by now
kill -USR1 ${P} 2>/dev/null && R=`expr ${R} + 1 `

# expected output
cat > ${OK} <<EOF
got=USR1
got=USR2
got=USR1
got=TERM
EOF

diff ${OK} ${OUT} || R=`expr ${R} + 1 `

exit ${R}
