#!/bin/sh
# $Id: t-grey-0.sh,v 1.6 2005/10/05 23:17:47 ca Exp $
# Copyright (c) 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ------------------------------------------------------------
# Description:
# Script to test greylisting
# Uses smar, t-access-0, access map, t-mm, startsmar.sh
# ------------------------------------------------------------
# Note: smar and t-access-0 are running asynchronous, hence
# there must be no expected order in the output file.
#
# don't run if stop is "set".
test -s stop && exit 1

# this is a "slow" test?
if test X"${SM_NO_SLOW_TEST}" != "X"
then
  echo "$0: SKIPPED {SM_NO_SLOW_TEST}"
  exit 0
fi

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../smar
fi
. ${SD}/common.sh

OUT=grey-0.out
IP=grey-0.ip
OK=grey-0.ok
TPRG=./t-access-0
SKIP=""
VERBOSE=false
CONF=grey.conf

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

rm -f ${ALIMAP} ${ACCMAP} ${SOCK} ${PIDS}

# create access map for tests
#cltaddr:127.0.0.1	ok
${CAT} >${ACC} <<EOF
cltaddr:127	ok
EOF
${VALGRIND} ${MM} -t'	' -F ${ACCMAP} < ${ACC}
if test $? -ne 0
then
  echo t-mm failed
  exit 1
fi

# 
${CAT} > ${CONF} <<EOF
smar {
greylisting { grey_wait=10s; grey_expire=30s; }
}
EOF

killit()
{
if test -s ${PIDS}
then
  # stop SMAR
  for i in `${CAT} ${PIDS}`
  do
    kill ${i}
  done
fi
# ----------------
# thanks kids for not following the POSIX standard...
if test X"`uname`" = "XLinux"
then
  killall smar
fi
exit 1
}
trap killit 2

rm -f grey_grey_m.db grey_grey_s.db

# start SMAR
${SHELL} ${SD}/startsmar.sh -f ${CONF} || exit 1
rm -f ${OUT} ${IP} ${OK}

# 
TEST=1
# ----------------------------------------
if echo "${SKIP} X" | grep -v '\<'${TEST}'\>' > /dev/null
then
${VALGRIND} ${TPRG} -g '127.0.0.1' '10.1.2.3' '10.2.3.4' > ${OUT} 2>&1 || ERRS=`expr ${ERRS} + 1 `
grep '^react=' ${OUT} | sort > ${IP}
sort > ${OK} <<EOF
react=no_match
react=statt, ret=0, statt='421 4.7.0 Come back later.
react=statt, ret=0, statt='421 4.7.0 Come back later.
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi

${VALGRIND} ${TPRG} -g '10.1.2.3' > ${OUT} 2>&1 || ERRS=`expr ${ERRS} + 1 `
grep '^react=' ${OUT} > ${IP}
${CAT} > ${OK} <<EOF
react=statt, ret=0, statt='421 4.7.0 Come back later.
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi

sleep 11

${VALGRIND} ${TPRG} -g '10.1.2.3' > ${OUT} 2>&1 || ERRS=`expr ${ERRS} + 1 `
grep '^react=' ${OUT} > ${IP}
${CAT} > ${OK} <<EOF
react=no_match
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi

sleep 20

# grey record expired, start over
${VALGRIND} ${TPRG} -g '10.2.3.4' > ${OUT} 2>&1 || ERRS=`expr ${ERRS} + 1 `
grep '^react=' ${OUT} > ${IP}
${CAT} > ${OK} <<EOF
react=statt, ret=0, statt='421 4.7.0 Come back later.
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi


fi

# ----------------
# stop SMAR
for i in `${CAT} ${PIDS}`
do
  kill ${i}
done
# ----------------
# thanks kids for not following the POSIX standard...
if test X"`uname`" = "XLinux"
then
  killall smar
fi
sleep 3

exit ${ERRS}
