#!/bin/sh
# $Id: t-access-2.sh,v 1.14 2005/10/05 23:17:47 ca Exp $
# Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ------------------------------------------------------------
# Description:
# Script to test access map restrictions for RFC2821 addresses
# including MX lookups.
# Uses smar, t-access-0, access map, t-mm, startsmar.sh
# ------------------------------------------------------------
# Note: smar and t-access-0 are running asynchronous, hence
# there must be no expected order in the output file.
#
# don't run if stop is "set".
test -s stop && exit 1
#

if test X"${SM_NO_DNS_TEST}" != "X"
then
  echo "SKIPPED: $0"
  exit 0
fi

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../smar
fi
. ${SD}/common.sh

OUT=access-1.out
IP=access-1.ip
OK=access-1.ok
TPRG=./t-access-0
VERBOSE=false

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

rm -f ${ACCMAP} ${SOCK} ${PIDS}

# create access map for tests
${VALGRIND} ${MM} -t'	' -F ${ACCMAP} <<EOF
mxbadip:127.0.0.1	error:550 5.7.0 127.0.0.1 not allowed
EOF

killit()
{
if test -s ${PIDS}
then
  # stop SMAR
  for i in `cat ${PIDS}`
  do
    kill ${i}
  done
fi
# thanks kids for not following the POSIX standard...
if test X"`uname`" = "XLinux"
then
  killall smar
fi
exit 1
}
trap killit 2


# start SMAR
${SHELL} ${SD}/startsmar.sh || exit 1
rm -f ${OUT} ${IP} ${OK}

# run tests ----------------

TEST=1
# ----------------------------------------
${VALGRIND} ${TPRG} -M '<553@domain.invalid>' > ${OUT} 2>&1
grep '^react=' ${OUT} > ${IP}
cat > ${OK} <<EOF
react=statt, ret=0, statt='553 5.1.8 Sender address does not exist
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi

TEST=2
# ----------------------------------------
${VALGRIND} ${TPRG} -M '<ok@sendmail.org>' > ${OUT} 2>&1
grep '^react=' ${OUT} > ${IP}
cat > ${OK} <<EOF
react=no_match
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi

TEST=3
# ----------------------------------------
${VALGRIND} ${TPRG} -M '<mxnonexist-553@mxnonexistent.sm9.org>' > ${OUT} 2>&1
grep '^react=' ${OUT} > ${IP}
cat > ${OK} <<EOF
react=statt, ret=0, statt='553 5.1.8 Sender address does not exist
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi

# # test: how to test for tempfail?
# ${TPRG} -M '<451@mxbogus.sm9.org>' > ${OUT} 2>&1
# grep '^react=' ${OUT} > ${IP}
# cat > ${OK} <<EOF
# react=statt, ret=0, statt='451 4.1.8 Sender address does not resolve
# EOF
# if diff ${OK} ${IP}
# then
#   :
# else
#   ERRS=`expr ${ERRS} + 1 `
#   echo "$0: test ${TEST} failed."
#   test X"${SM_STOPONERROR}" != X && exit ${ERRS}
# fi

TEST=4
# ----------------------------------------
${VALGRIND} ${TPRG} -MX '<mx10-1270001@mxlocal.sm9.org>' > ${OUT} 2>&1
grep '^react=' ${OUT} > ${IP}
cat > ${OK} <<EOF
react=statt, ret=0, statt='550 5.7.0 127.0.0.1 not allowed
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi

TEST=5
# ----------------------------------------
${VALGRIND} ${TPRG} -MX '<mx20-1270001@mxlocal.sm9.org>' > ${OUT} 2>&1
grep '^react=' ${OUT} > ${IP}
cat > ${OK} <<EOF
react=statt, ret=0, statt='550 5.7.0 127.0.0.1 not allowed
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi

TEST=6
# ----------------------------------------
${VALGRIND} ${TPRG} -MX '<mxip@mxip.sm9.org>' > ${OUT} 2>&1
grep '^react=' ${OUT} > ${IP}
cat > ${OK} <<EOF
react=statt, ret=0, statt='553 5.1.8 Sender address does not exist
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi

TEST=7
# ----------------------------------------
${VALGRIND} ${TPRG} -MX '<ip@[127.0.0.1]>' > ${OUT} 2>&1
grep '^react=' ${OUT} > ${IP}
cat > ${OK} <<EOF
react=statt, ret=0, statt='550 5.7.0 127.0.0.1 not allowed
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi

# end tests ----------------

# stop SMAR
for i in `cat ${PIDS}`
do
  kill ${i}
done
# ----------------
# thanks kids for not following the POSIX standard...
if test X"`uname`" = "XLinux"
then
  killall smar
fi
sleep 3

exit ${ERRS}
