#!/bin/sh
# $Id: t-smconf-1.sh,v 1.6 2005/10/13 19:00:02 ca Exp $
# Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#

# read configuration file and print it;
# uses the various modules *prtcnf.c
# causes various errors

test -s stop && exit 1

# source directory of this (and other) shell script
SD=`dirname $0`

ERRS=0

CNF=sm1.conf
OUT=sm1.out
OK=sm1.ok

PRG=./smconf

cat > ${CNF} <<EOF
qmgr {
  queue_return_timeout= 3d 4x;
  min_disk_space = 1 MB 1 bit;
  start_action = wait;
  user = smxq;
  path = "/var/spool/smx-0.0.15/libexec/qmgr";
  arguments = "qmgr -f smx.conf";
}
EOF
cat > ${OK} <<EOF
sm1.conf: invalid value
sm1.conf:2: unexpected trailing characters in '3d 4x'
sm1.conf:3: unexpected trailing characters in '1 MB 1 bit'
EOF
${PRG} ${CNF} >${OUT} 2>&1
if diff ${OK} ${OUT}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  test X"${SM_STOPONERROR}" != X && exit 1
fi

cat > ${CNF} <<EOF
qmgr {
  min_disk_spacer = 1 MB 1 bit;
  mcp_typ = wait;
  users = smxq;
  path = "/var/spool/smx-0.0.15/libexec/qmgr";
  arguments = "qmgr -f smx.conf";
}
EOF
cat > ${OK} <<EOF
sm1.conf: invalid value
sm1.conf:2: min_disk_spacer: unexpected option
sm1.conf:3: mcp_typ: unexpected option
sm1.conf:4: users: unexpected option
EOF
${PRG} ${CNF} >${OUT} 2>&1
if diff ${OK} ${OUT}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  test X"${SM_STOPONERROR}" != X && exit 1
fi

# ----------------
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
