/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: strlower.c,v 1.4 2005/06/09 00:43:40 ca Exp $")

#include "sm/assert.h"
#include "sm/ctype.h"
#include "sm/str-int.h"

/*
**  SM_STR2LOWER -- Convert string to lower case.
**
**	Parameters:
**		str -- string.
**
**	Returns:
**		true iff a character was converted.
*/

bool
sm_str2lower(sm_str_P str)
{
	uint i, l;
	uchar ch;
	bool wasupper;

	SM_IS_BUF(str);
	l = str->sm_str_len;
	wasupper = false;
	for (i = 0; i < l; i++)
	{
		ch = str->sm_str_base[i];
		if (isupper(ch))
		{
			str->sm_str_base[i] = tolower(ch);
			wasupper = true;
		}
	}
	return wasupper;
}
