/*
 * Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: smiotord.c,v 1.5 2005/03/15 19:56:07 ca Exp $")
#include "sm/error.h"
#include "sm/io.h"
#include "sm/assert.h"
#include "io-int.h"

/*
**  SM_IOTORD -- Switch file to read mode
**
**	Parameters:
**		fp -- file pointer to switch
**
**	Returns:
**		usual return type (including EOF).
*/

sm_ret_T
sm_iotord(sm_file_T *fp)
{
	if ((f_flags(*fp) & SMRD) != 0)
		return SM_SUCCESS;
	if ((f_flags(*fp) & SMRW) == 0)
	{
		f_flags(*fp) |= SMERR;
#if SM_IO_ERR_VAL
		f_error(*fp) = sm_error_perm(SM_EM_IO, EBADF);
#endif
		return sm_error_perm(SM_EM_IO, EBADF);
	}

	/* switch to reading */
	if (f_flags(*fp) & SMWR)
	{
		if (!sm_io_double(fp) ||
		    sm_io_getinfo(fp, SM_IO_IS_READABLE, NULL) <= 0)
		{
			sm_ret_T ret;

			ret = sm_flush(fp);
			if (sm_is_err(ret))
				return SM_IO_EOF;	/* XXX ret? */
		}
		f_flags(*fp) &= ~SMWR;
		SM_IO_TO_RD(fp);
	}
	f_flags(*fp) |= SMRD;
	return SM_SUCCESS;
}
