/*
 * Copyright (c) 2002-2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: rcbefree.c,v 1.7 2005/05/31 21:03:57 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/rpool.h"
#include "sm/rcb.h"
#include "sm/rcbl.h"

/*
**  SM_RCBE_FREE -- Free a RCB list element.
**
**	Parameters:
**		rcbe -- RCB entry to free.
**
**	Returns:
**		none.
**
**	Last code review: 2005-03-22 17:46:20
**	Last code change:
*/

void
sm_rcbe_free(sm_rcbe_P rcbe)
{
	if (rcbe == NULL)
		return;
	SM_IS_RCBE(rcbe);
	if (rcbe->rcbe_rcb.sm_rcb_base != NULL)
		sm_rpool_free_size(rcbe->rcbe_rcb.sm_rcb_rpool,
				rcbe->rcbe_rcb.sm_rcb_base,
				rcbe->rcbe_rcb.sm_rcb_size);
	sm_rpool_free_size(rcbe->rcbe_rcb.sm_rcb_rpool, rcbe, sizeof(*rcbe));
}
