/*
 * Copyright (c) 2002 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: memdup.c,v 1.2 2002/02/15 18:37:57 ca Exp $")

#include "sm/assert.h"
#include "sm/memops.h"
#include "sm/heap.h"

void *
sm_memdup(const void *ptr, size_t size)
{
	void *new;

	if (ptr == NULL)
		return NULL;
	new = sm_malloc(size);
	if (new == NULL)
		return NULL;
	return sm_memcpy(new, ptr, size);
}
