/*
 * Copyright (c) 2002, 2003, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: cstrcrt.c,v 1.8 2005/06/02 19:00:36 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/heap.h"
#include "sm/cstr.h"

/*
**  SM_CSTR_CRT -- Create a cstring with preallocated memory
**
**	Parameters:
**		buf -- Allocated memory to use
**		len -- size of buf
**
**	Returns:
**		New buf object
**		NULL on error
*/

sm_cstr_P
sm_cstr_crt(uchar *buf, uint len)
{
	sm_cstr_P cstr;
#if SM_USE_PTHREADS
	int r;
#endif

	cstr = sm_malloc(sizeof(*cstr));
	if (cstr == NULL)
		return NULL;
#if SM_USE_PTHREADS
	r = pthread_mutex_init(&(cstr->sm_cstr_mutex), NULL);
	if (r != 0)
	{
		sm_free_size(cstr, sizeof(*cstr));
		return NULL;
	}
#endif /* SM_USE_PTHREADS */
	cstr->sm_cstr_base = buf;
	cstr->sm_cstr_len = len;
	cstr->sm_cstr_refcnt = 1;
	cstr->sm_magic = SM_CSTR_MAGIC;
	return cstr;
}
