/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: evthropts.c,v 1.5 2005/01/05 18:16:01 ca Exp $")
#include "sm/error.h"
#include "sm/assert.h"
#include "sm/memops.h"
#include "sm/evthr.h"

/*
**  EVTHR_SET_MAX_H -- set hard limit for maximum number of threads
**
**	Parameters:
**		evthr_ctx -- evthr context
**		maxthr_h -- maximum number of threads (hard limit)
**
**	Returns:
**		usual sm_error code
**
**	Locking: currently does NOT lock access to variable!
*/

sm_ret_T
evthr_set_max_h(sm_evthr_ctx_P evthr_ctx, uint maxthr_h)
{
	SM_IS_EVTHR_CTX(evthr_ctx);
	if (evthr_ctx->evthr_c_max_s > maxthr_h)
		return sm_error_perm(SM_EM_EVTHR, EINVAL);
	evthr_ctx->evthr_c_max_h = maxthr_h;
	return SM_SUCCESS;
}

/*
**  EVTHR_SET_MAX_S -- set soft limit for maximum number of threads
**
**	Parameters:
**		evthr_ctx -- evthr context
**		maxthr_s -- maximum number of threads (soft limit)
**
**	Returns:
**		usual sm_error code
**
**	Locking: currently does NOT lock access to variable!
*/

sm_ret_T
evthr_set_max_s(sm_evthr_ctx_P evthr_ctx, uint maxthr_s)
{
	SM_IS_EVTHR_CTX(evthr_ctx);
	if (evthr_ctx->evthr_c_max_h < maxthr_s)
		return sm_error_perm(SM_EM_EVTHR, EINVAL);
	evthr_ctx->evthr_c_max_s = maxthr_s;
	return SM_SUCCESS;
}

/*
**  EVTHR_SET_DBGLVL -- set debug level
**
**	Parameters:
**		evthr_ctx -- evthr context
**		dbglvl -- debug level
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
evthr_set_dbglvl(sm_evthr_ctx_P evthr_ctx, uint dbglvl)
{
	SM_IS_EVTHR_CTX(evthr_ctx);
#if EVTHR_DEBUG
	evthr_ctx->evthr_c_dbglvl = dbglvl;
#endif /* EVTHR_DEBUG */
	return SM_SUCCESS;
}
