/*
 * Copyright (c) 2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-edbc-2.c,v 1.2 2004/09/08 23:01:49 ca Exp $")

#include "t-edbc.h"

/*
**  test edbc_mv()
*/

static void
test(void)
{
	int a;
	edbc_node_P edbc_node;
	rcpt_id_T rcpt_ids[MAX_KEYS];
	sm_ret_T ret;

	sm_memzero(&edbc_node_search, sizeof(edbc_node_search));
	sm_memzero(&edbc_tnode, sizeof(edbc_tnode));
	ECNL_INIT(&(edbc_tnode.ectn_hd));
	ECNL_APP(&(edbc_tnode.ectn_hd), &edbc_node_search);

	ret = edbc_open(&edbc_ctx, 0, 0);
	SM_TEST(ret == SM_SUCCESS);
	if (ret != SM_SUCCESS)
		return;

	for (a = 0; a < MAX_KEYS; a++)
	{
		next_try[a] = a;
		added[a] = false;
		sm_snprintf(rcpt_ids[a], sizeof(rcpt_ids[a]),
			SMTP_RCPTID_FORMAT, "rcpt-id-filler-text", a);
	}

	next_try[1] = 9;
	next_try[6] = 5;
	next_try[7] = 5;
	next_try[9] = 5;
	next_try[10] = 11;
	next_try[12] = 10;

	intree();
	TINS(3);
	TINS(5);
	TINS(1);
	TINS(10);
	TINS(4);
	TINS(12);
	TINS(2);
	TINS(9);
	TINS(8);
	TINS(7);
	TINS(11);
	TINS(6);

	print_tree(edbc_ctx);

	/* finds time == 11, 2 entries */
	edbc_tnode_ret = edbct_last(edbc_ctx);
	SM_TEST(edbc_tnode_ret != NULL);
	SM_TEST(ECNL_FIRST(&(edbc_tnode_ret->ectn_hd))->ecn_next_try == 11);
	ret = edbct_rm(edbc_ctx, edbc_tnode_ret);
	SM_TEST(ret == SM_SUCCESS);
	Entries -= 2;
	added[11] = false;
	INTREE(11);
	intree();
	print_tree(edbc_ctx);

	edbc_node = edbc_first(edbc_ctx);
	SM_TEST(edbc_node != NULL);
	ret = edbc_mv(edbc_ctx, edbc_node, 4);
	SM_TEST(ret == SM_SUCCESS);
	print_tree(edbc_ctx);

	edbc_node = edbc_first(edbc_ctx);
	SM_TEST(edbc_node != NULL);
	ret = edbc_mv(edbc_ctx, edbc_node, 11);
	SM_TEST(ret == SM_SUCCESS);
	print_tree(edbc_ctx);

	edbc_node = edbc_first(edbc_ctx);
	SM_TEST(edbc_node != NULL);
	ret = edbc_mv(edbc_ctx, edbc_node, 6);
	SM_TEST(ret == SM_SUCCESS);
	print_tree(edbc_ctx);

	print_tree2(edbc_ctx);

  error:
	edbc_close(edbc_ctx);
	return;
}

int
main(int argc, char *argv[])
{
	sm_test_begin(argc, argv, "test edbc 2");
	test();
	return sm_test_end();
}
