/*
 * Copyright (c) 2003 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: smtls.h,v 1.4 2005/06/16 00:09:35 ca Exp $
 */

#ifndef SM_SMTLS_H
#define SM_SMTLS_H 1
#include "sm/generic.h"
#include "sm/io.h"

struct sm_tls_ctx_S
{
	int		 stc_peer_verified;
	char		*stc_peer_subject;
	char		*stc_peer_issuer;
	char		*stc_peer_fingerprint;
	char		*stc_peer_CN;
	char		*stc_issuer_CN;
	const char	*stc_protocol;
	const char	*stc_cipher_name;
	int		 stc_cipher_usebits;
	int		 stc_cipher_algbits;
};

typedef struct sm_tls_ctx_S	sm_tls_ctx_T, *sm_tls_ctx_P;

extern const sm_tls_ctx_T tls_info_zero;

#if SM_USE_TLS
extern int smtls_serverengine;
int     smtls_init_serverengine(int verifydepth, int askcert);
int     smtls_start_servertls(sm_file_T *stream, int timeout,
				const char *peername, const char *peeraddr,
				sm_tls_ctx_P tls_info, int require_cert);
int     smtls_stop_servertls(sm_file_T *stream, int timeout, int failure,
			       sm_tls_ctx_P tls_info);

extern int smtls_clientengine;
int     smtls_init_clientengine(int verifydepth);
int     smtls_start_clienttls(sm_file_T *stream, int timeout,
				int enforce_peername,
				const char *peername,
				sm_tls_ctx_P tls_info);
int     smtls_stop_clienttls(sm_file_T *stream, int timeout, int failure,
			       sm_tls_ctx_P tls_info);
#endif /* SM_USE_TLS */

#endif /* SM_SMTLS_H */
