/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: mcpcnfs.h,v 1.17 2005/10/04 18:44:37 ca Exp $
 */

/* #ifndef SM_MCPCNFS_H */
#define SM_MCPCNFS_H 1

#include "sm/generic.h"
#include "sm/mcpdef.h"
#include "sm/sm-conf.h"
#include "sm/net.h"
#include "sm/sockcnf.h"

/*
**  NOTE: This is almost a copy of mcpcnfdef.h and sockcnfdef.h
**  Is there a way to generate the latter from this?
**  However, see also below!
*/

#if SM_NOMCPDEFS

#define MCP_DEFS(strct, sn)
#define MCP_SRV_DEFS(strct, sn)
#define MCP_SOCKET_DEFS(strct, sn)
#define MCP_STRUCTS(strct, sn)
#define MCP_UNIX_SOCK_DEFS(strct, sn)
#define MCP_INET_SOCK_DEFS(strct, sn)

#else /* SM_NOMCPDEFS */

#if 0
#define MCP_UNIX_SOCK_DEFS(strct, sn)	\
{ SM_CONF_DEF_MAGIC,	\
  "type",	sm_conf_type_choice,	\
	offsetof(strct, sn##_sckspc_type), sizeof(strct),	\
	NULL, SM_CONF_FLAG_PARSE_ONLY, sock_types,	\
	NULL, NULL, "socket type" },	\
{ SM_CONF_DEF_MAGIC,	\
  "path",	sm_conf_type_string,	\
	offsetof(strct, sock_unix.unixsckspc_path), 0,	\
	NULL, SM_CONF_FLAG_PARSE_ONLY, NULL, NULL, NULL,	\
	"pathname of Unix domain socket" },	\
{ SM_CONF_DEF_MAGIC,	\
  "umask",	sm_conf_type_u32,	\
	offsetof(strct, sock_unix.unixsckspc_umask), sizeof(mode_t), \
	"007",	SM_CONF_FLAG_PARSE_ONLY, NULL,	NULL,	NULL,	\
	"umask to set before bind(2) and to set socket permissions" },	\
{ SM_CONF_DEF_MAGIC,	\
  "user",	sm_conf_type_string,	\
	offsetof(strct, sock_unix.unixsckspc_user),	0,	\
	"",	SM_CONF_FLAG_PARSE_ONLY, NULL,	NULL,	NULL,	\
	"owner of socket"	},	\
{ SM_CONF_DEF_MAGIC,	\
  "group",	sm_conf_type_string,	\
	offsetof(strct, sock_unix.unixsckspc_group),	0,	\
	"", SM_CONF_FLAG_PARSE_ONLY,	NULL,	NULL,	NULL,	\
	"group of socket"	}

#define MCP_INET_SOCK_DEFS(strct, sn)	\
{ SM_CONF_DEF_MAGIC,	\
  "type",	sm_conf_type_choice,	\
	offsetof(strct, sn##_sckspc_type), sizeof(sock_type_T),	\
	NULL, SM_CONF_FLAG_PARSE_ONLY, sock_types,	\
	NULL, NULL, "socket type" },	\
{ SM_CONF_DEF_MAGIC,	\
  "port",	sm_conf_type_u32,	\
	offsetof(strct, sock_inet.inetsckspc_port), sizeof(int),	\
	NULL, SM_CONF_FLAG_PARSE_ONLY,	NULL, NULL, NULL,	\
	"port to listen on"	},	\
{ SM_CONF_DEF_MAGIC,	\
  "address",	sm_conf_type_ipv4,	\
	offsetof(strct, sock_inet.inetsckspc_addr),	sizeof(ipv4_T),	\
	"0.0.0.0", SM_CONF_FLAG_PARSE_ONLY, NULL, NULL, NULL,	\
	"bind to this IPv4 address" }

#define MCP_SOCK_DEFS(strct, sn)	\
{ SM_CONF_DEF_MAGIC,	\
  "",	sm_conf_type_union_type,	\
	offsetof(strct, sn##_sckspc_type), sizeof(sock_type_T), NULL, \
	SM_CONF_FLAG_PARSE_ONLY,	NULL,	NULL,	NULL,	\
	NULL	},	\
{ SM_CONF_DEF_MAGIC,	\
  "type",	sm_conf_type_union_choice,	\
	SOCK_TYPE_UNIX,	sizeof(strct),	"unix",	\
	SM_CONF_FLAG_PARSE_ONLY, unix_sock_spec_defs,	\
	NULL, NULL, NULL, NULL },	\
{ SM_CONF_DEF_MAGIC,	\
  "type",	sm_conf_type_union_choice,	\
	SOCK_TYPE_INET,	sizeof(strct),	"inet",	\
	SM_CONF_FLAG_PARSE_ONLY, inet_sock_spec_defs,	\
	NULL, NULL, NULL, NULL }
#endif /* 0 */

/* required for smtps (anything that acts as server) */
#define MCP_SRV_DEFS(strct, sn)	\
{ SM_CONF_DEF_MAGIC,	\
  "listen_socket",	sm_conf_type_union,	\
	offsetof(strct, sn##_mcp_socket.sckspc_type),	\
	sizeof(sockspec_T),	\
	"inet", SM_CONF_FLAG_KEEP_DEFAULT, sock_spec_definitions,	\
	NULL, NULL, NULL }

/* generic definitions for services */
#define MCP_DEFS(strct, sn)	\
{ SM_CONF_DEF_MAGIC,	\
  "min_processes",	sm_conf_type_u32,	\
	offsetof(strct, sn##_mcp_minchild),	sizeof(int),	"1",	\
	SM_CONF_FLAG_PARSE_ONLY,	NULL,	NULL,	NULL,	\
	"minimum number of processes"	},	\
{ SM_CONF_DEF_MAGIC,	\
  "max_processes",	sm_conf_type_u32,	\
	offsetof(strct, sn##_mcp_maxchild),	sizeof(int),	"1",	\
	SM_CONF_FLAG_PARSE_ONLY,	NULL,	NULL,	NULL,	\
	"maximum number of processes"	},	\
{ SM_CONF_DEF_MAGIC,	\
  "user",		sm_conf_type_string,	\
	offsetof(strct, sn##_mcp_user),		0,		 "",	\
	SM_CONF_FLAG_PARSE_ONLY,	NULL,	NULL,	NULL,	\
	"run process as user"	},	\
{ SM_CONF_DEF_MAGIC,	\
  "group",		sm_conf_type_string,	\
	offsetof(strct, sn##_mcp_group),	0,		 "",	\
	SM_CONF_FLAG_PARSE_ONLY,	NULL,	NULL,	NULL,	\
	"run process as group"	},	\
{ SM_CONF_DEF_MAGIC,	\
  "restart_dependencies",	sm_conf_type_argv,	\
	offsetof(strct, sn##_mcp_restartdep), SM_MCP_MAXRESTARTDEP,	NULL,	\
	SM_CONF_FLAG_PARSE_ONLY,	NULL,	NULL,	NULL,	\
	"list of services to restart in case of failure"	},	\
{ SM_CONF_DEF_MAGIC,	\
  "pass_id",		sm_conf_type_string,	\
	offsetof(strct, sn##_mcp_pass_id),	0,		 NULL,	\
	SM_CONF_FLAG_PARSE_ONLY,	NULL,	NULL,	NULL,	\
	"pass id to process in argument list with this option"	},	\
{ SM_CONF_DEF_MAGIC,	\
  "use_id_in_logfile_name",		sm_conf_type_bool,	\
	offsetof(strct, sn##_mcp_logf_id),	sizeof(bool),	 "0",	\
	SM_CONF_FLAG_PARSE_ONLY,	NULL,	NULL,	NULL,	\
	"use id to create name of logfile: Logdir name id . log"	}, \
{ SM_CONF_DEF_MAGIC,	\
  "path",		sm_conf_type_string,	\
	offsetof(strct, sn##_mcp_server),	0,		 "",	\
	SM_CONF_FLAG_PARSE_ONLY,	NULL,	NULL,	NULL,	\
	"path to program"	},	\
{ SM_CONF_DEF_MAGIC,	\
  "arguments",		sm_conf_type_string,	\
	offsetof(strct, sn##_mcp_args),		0,		 "",	\
	SM_CONF_FLAG_PARSE_ONLY,	NULL,	NULL,	NULL,	\
	"arguments for program"	},	\
{ SM_CONF_DEF_MAGIC,	\
  "working_directory",		sm_conf_type_string,	\
	offsetof(strct, sn##_mcp_workdir),	0,		 NULL,	\
	0,	NULL,	NULL,	NULL,	\
	"working directory (chdir(2))"	},	\
{ SM_CONF_DEF_MAGIC,	\
  "start_action",		sm_conf_type_string,	\
	offsetof(strct, sn##_mcp_flags),		0,	\
	"wait",	\
	SM_CONF_FLAG_PARSE_ONLY,	NULL,	NULL,	NULL,	\
	"how to handle program"	},
/* last entry is a hack to avoid including wait definition */

#define MCP_STRUCTS(strct, sn)	\
	char const	*sn##_mcp_prg;	\
	sockspec_T	 sn##_mcp_socket;	\
	int		 sn##_mcp_minchild;	\
	int		 sn##_mcp_maxchild;	\
	char		*sn##_mcp_pass_id;	\
	char		*sn##_mcp_exsock;	\
	char		*sn##_mcp_user;	\
	char		*sn##_mcp_group;	\
	int		 sn##_mcp_nrestartdep;	\
	char		*sn##_mcp_restartdep[SM_MCP_MAXRESTARTDEP + 1];	\
	char		*sn##_mcp_restartdeps;	\
	char		*sn##_mcp_server;	\
	char		*sn##_mcp_server_name;	\
	char		*sn##_mcp_args;	\
	char		*sn##_mcp_workdir;	\
	uint		 sn##_mcp_flags;	\
	bool		 sn##_mcp_logf_id;

#if 0

/*
This entry overlaps with the same data in ss_defs[]
It is not needed in any other module, so we can just remove it.

{ SM_CONF_DEF_MAGIC,	\
  "pass_fd_socket",	sm_conf_type_string,	\
	offsetof(strct, sn##_string),		0,		 "",	\
	SM_CONF_FLAG_PARSE_ONLY,	NULL,	NULL,	NULL,	\
	"path of Unix domain socket to exchange file descriptor"	}, \

*/

#endif

#endif /* SM_NOMCPDEFS */

/* #endif * SM_MCPCNFS_H */
