/*
 * Copyright (c) 2001-2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: heap.h,v 1.24 2005/06/16 00:09:34 ca Exp $
 */

#ifndef SM_HEAP_H
#define SM_HEAP_H 1

#include "sm/generic.h"
#include "sm/debug.h"

#ifndef SM_HEAP_CHECK
# define SM_HEAP_CHECK	0
#endif

#ifndef DMALLOC
# define DMALLOC	0
#endif

#if SM_HEAP_CHECK
# include "sm/iostub.h"
# define sm_malloc(size) sm_malloc_tagged(size, __FILE__, __LINE__, SmHeapGroup)
# define sm_free(ptr) sm_free_tagged(ptr, __FILE__, __LINE__)
# define sm_free_size(ptr, size) sm_free_size_tagged(ptr, size, __FILE__, __LINE__)
# define sm_zalloc(size) sm_zalloc_tagged(size, __FILE__, __LINE__, SmHeapGroup)

void *sm_malloc_tagged(size_t _size, char *_tag, int _num, int _group);
void *sm_zalloc_tagged(size_t _size, char *_tag, int _num, int _group);
void  sm_free_tagged(void *_ptr, char *_tag, int _num);
void  sm_free_size_tagged(void *_ptr, size_t _size, char *_tag, int _num);
bool  sm_heap_register(void *_ptr, size_t _size, char *_tag, int _num, int _group);
void  sm_heap_checkptr_tagged(void *_ptr, char *_tag, int _num);
void  sm_heap_report(sm_file_T *_stream, int _verbosity);
void *sm_realloc(void *_tmp, size_t _size);

#else /* SM_HEAP_CHECK */

# define sm_malloc_tagged(size, file, line, grp)	sm_malloc(size)
# define sm_zalloc_tagged(size, file, line, grp)	sm_zalloc(size)
# define sm_realloc_tagged(ptr, size, file, line, grp)	sm_realloc(ptr, size)
# define sm_free_tagged(ptr, file, line)		sm_free(ptr)
# define sm_free_size_tagged(ptr, size, file, line)	sm_free_size(ptr, size)
# define sm_heap_register(ptr, size, file, line, grp)	(true)
# define sm_heap_checkptr_tagged(ptr, tag, num)		SM_NOOP
# define sm_heap_report(file, verbose)			SM_NOOP

# if HAVE_MALLOC
#  define sm_malloc(size)	malloc(size)
#  define sm_realloc(ptr, size)	realloc(ptr, size)
# else /* HAVE_MALLOC */
void	*sm_malloc(size_t _size);
void	*sm_realloc(void *_ptr, size_t _size);
# endif /* HAVE_MALLOC */
void	*sm_zalloc(size_t _size);
# if SM_FREE_NULL
#  define sm_free(ptr)	free(ptr)
# else /* SM_FREE_NULL */
void	 sm_free(void *_ptr);
# endif /* SM_FREE_NULL */
void	 sm_free_size(void *_ptr, size_t _size);
#endif /* SM_HEAP_CHECK */

#define sm_heap_checkptr(ptr) sm_heap_checkptr_tagged(ptr, __FILE__, __LINE__)

#if 0
/*
**  sm_f[mc]alloc are plug in replacements for malloc and calloc
**  which can be used in a context requiring a function pointer,
**  and which are compatible with sm_free.  Warning: sm_heap_report
**  cannot report where storage leaked by sm_f[mc]alloc was allocated.
*/

/* XXX unused right now */

void	*sm_fmalloc(size_t);
void	*sm_fcalloc(size_t, size_t);
#endif /* 0 */

/*
**  Allocate 'permanent' storage that can be freed but may still be
**  allocated when the process exits.  sm_heap_report will not complain
**  about a storage leak originating from a call to sm_pmalloc.
*/

#define sm_pmalloc(size)   sm_malloc_tagged(size, __FILE__, __LINE__, 0)

#define sm_heap_group()	SmHeapGroup
#define sm_heap_setgroup(g)	(SmHeapGroup = (g))
#define sm_heap_newgroup()	(SmHeapGroup = ++SmHeapMaxGroup)

#if SM_HEAP_CHECK
extern int SmHeapGroup;
extern int SmHeapMaxGroup;

extern SM_DEBUG_T SmHeapTrace;
extern SM_DEBUG_T SmHeapCheck;
#endif /* SM_HEAP_CHECK */

__BEGIN_DECLS
void *sm_memdup(const void *_ptr, size_t _size);
__END_DECLS

#define SM_FREE(ptr) do			\
	{				\
		if ((ptr) != NULL)	\
		{			\
			sm_free(ptr);	\
			(ptr) = NULL;	\
		}			\
	} while (0)

#define SM_FREE_SIZE(ptr, size) do	\
	{				\
		if ((ptr) != NULL)	\
		{			\
			sm_free_size((ptr), (size));	\
			(ptr) = NULL;	\
		}			\
	} while (0)

#if DMALLOC
# include "dmalloc.h"
#endif

#endif /* ! SM_HEAP_H */
