/*
 * Copyright (c) 2002-2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: dadb.h,v 1.28 2005/06/16 00:09:34 ca Exp $
 */

#ifndef SM_DADB_H
#define SM_DADB_H 1

#include "sm/generic.h"
#include "sm/magic.h"
#include "sm/types.h"
#include "sm/pthread.h"
#include "sm/net.h"
#include "sm/bhtable.h"
#include "sm/ring.h"
#include "sm/dadbstr.h"
#include "sm/occ.h"

#if 0
/* DA index, used to access multiple DA, currently only 1 (unused) */
typedef uint	da_idx_T;
#endif /* 0 */

/* DA entry flags */
#define DADBE_FL_FREE	0x0000	/* DA entry is free (not really a flag) */
#define DADBE_FL_BUSY	0x0001	/* busy (transaction active)	*/
#define DADBE_FL_IDLE	0x0002	/* session is open, no TA active */
#define DADBE_FL_SE_CL	0x0010	/* session must be closed	*/
#define DADBE_FL_TA_CL	0x0020	/* TA must be closed	*/

/* this must be coordinated with OCC entry flags! */
#define DADBE_FL_AVAIL	0x0100	/* a DA entry became available again */

#define DADBE_SET_FLAG(dadb_entry, fl)	(dadb_entry)->dadbe_flags |= (fl)
#define DADBE_CLR_FLAG(dadb_entry, fl)	(dadb_entry)->dadbe_flags &= ~(fl)
#define DADBE_IS_FLAG(dadb_entry, fl)	(((dadb_entry)->dadbe_flags & (fl)) != 0)

#define DADBE_IS_FREE(dadb_entry)	((dadb_entry)->dadbe_flags == 0)

/* DA is active: session open (and maybe transaction) */
#define DADBE_IS_ACTIVE(dadb_entry)	DADBE_IS_FLAG(dadb_entry, DADBE_FL_BUSY|DADBE_FL_IDLE)
#define DADBE_SET_SE_OPEN(dadb_entry)	do {	\
		DADBE_SET_FLAG(dadb_entry, DADBE_FL_BUSY);	\
		DADBE_CLR_FLAG(dadb_entry, DADBE_FL_IDLE);	\
	} while (0)

/* DA is connected: session open but not in transaction */
#define DADBE_IS_CONN(dadb_entry)	DADBE_IS_FLAG((dadb_entry), DADBE_FL_IDLE)
#define DADBE_SET_CONN(dadb_entry)	do {	\
		DADBE_SET_FLAG(dadb_entry, DADBE_FL_IDLE);	\
		DADBE_CLR_FLAG(dadb_entry, DADBE_FL_BUSY);	\
	} while (0)

sm_ret_T	 dadb_new(dadb_ctx_P *_dadb_ctx, uint _size);
sm_ret_T	 dadb_destroy(dadb_ctx_P _dadb_ctx);
sm_ret_T	 dadb_close(qmgr_ctx_P _qmgr_ctx, dadb_ctx_P _dadb_ctx, thr_lock_T _locktype);
sm_ret_T	 dadb_sess_open(qsc_ctx_P _qsc_ctx, dadb_ctx_P _dadb_ctx,
			sessta_id_P _ta_id_ss, ipv4_T _srv_ipv4,
			dadb_entry_P *_pdadb_entry);
sm_ret_T	 dadb_sess_reuse(qsc_ctx_P _qsc_ctx, dadb_ctx_P _dadb_ctx,
			sessta_id_P _ss_ta_id, dadb_entry_P _dadb_entry
			, occ_entry_P occ_entry
			);
sm_ret_T	 dadb_sess_close_entry(qmgr_ctx_P _qmgr_ctx, dadb_ctx_P _dadb_ctx, dadb_entry_P _dadb_entry, bool _ok, uint32_t *_pflags, thr_lock_T _locktype);
#if 0
// extern sm_ret_T	 dadb_sess_close(dadb_ctx_P _dadb_ctx, sessta_id_P _sess_id);
// extern sm_ret_T	 dadb_ta_close(dadb_ctx_P _dadb_ctx, sessta_id_P _ta_id);
#endif /* 0 */
sm_ret_T	 dadb_ta_close_entry(qmgr_ctx_P qmgr_ctx, dadb_ctx_P _dadb_ctx, dadb_entry_P _dadb_entry, uint32_t *_pflags, thr_lock_T _locktype);
sm_ret_T	 dadb_se_find(dadb_ctx_P _dadb_ctx, sessta_id_P _da_se_id, dadb_entry_P *_pdadb_entry);
sm_ret_T	 dadb_se_find_by_ipv4(dadb_ctx_P _dadb_ctx, ipv4_T _ipv4, dadb_entry_P *_pdadb_entry);
sm_ret_T	 dadb_ta_find(dadb_ctx_P _dadb_ctx, sessta_id_P _da_ta_id, dadb_entry_P *_pdadb_entry);
sm_ret_T	 dadb_entry_avail(dadb_ctx_P _dadb_ctx, bool *_pavail, thr_lock_T _locktype);
sm_ret_T	 dadb_set_limit(dadb_ctx_P _dadb_ctx, size_t _entries_lim, thr_lock_T _locktype);

#endif /* SM_DADB_H */
