/*
 * Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 * $Id: da.h,v 1.20 2005/06/16 00:09:34 ca Exp $
 */

#ifndef SM_DA_H
#define SM_DA_H 1
#include "sm/generic.h"
#include "sm/error.h"

/*
**  This file includes some flags/information that is shared between
**  qmgr and smtpc (or other "Deliver Agents").
**  1. Flags (requests by qmgr to a DA how to behave)
**  2. Error codes (sent back from a DA to qmgr)
*/

/*
**  Flags.
**  Note: if changes are made here check whether that requires changes
**	in smtpc/smtpc.h too (e.g., SCTA_FL_*)
*/

#define DA_FL_HDR_ONLY	0x00000001	/* send bounce with headers only */
#define DA_FL_DSN_MIME	0x00000002	/* DSN in MIME format (not yet impl) */

/*
**  Error codes.
*/

#define DA_ERR_NONE		0	/* none... */

/*
**  Error states in DA:
**  I: internal
**  W: during write
**  S: SMTP reply code
**  R: during read of reply
**
**  NOTE: if entries are added here, add a textual representation to
**	qmgr/bounce.c!
*/

#define da_err_cmd(err)	((err) & 0x0ff0)


/*
**  What's the purpose of distinguishing between DA_TA_ERR_x and DA_SE_ERR_x?
**  As long as the values are the same: seemingly none... hence the next macros
**  are ok, otherwise they must be split into TA/SE.
*/

#define DA_SET_ERR_I(err)	((err)|DA_TA_ERR_I)
#define DA_SET_ERR_W(err)	((err)|DA_TA_ERR_W)
#define DA_SET_ERR_S(err)	((err)|DA_TA_ERR_S)
#define DA_SET_ERR_R(err)	((err)|DA_TA_ERR_R)

#define DA_TA_ERR_I		0x1
#define DA_TA_ERR_W		0x2
#define DA_TA_ERR_S		0x4
#define DA_TA_ERR_R		0x8
#define da_ta_err_type(err)	((err) & 0x000f)
#define da_ta_err_cmd(err)	((err) & 0x00f0)

#define DA_SE_ERR_I		0x1
#define DA_SE_ERR_W		0x2
#define DA_SE_ERR_S		0x4
#define DA_SE_ERR_R		0x8
#define da_se_err_type(err)	((err) & 0x000f)
#define da_se_err_cmd(err)	((err) & 0x0ff0)

/* write/read or SMTP reply code error? */
#define DA_SET_ERR_WS(err, ret)	((err)|(sm_is_err(ret)?DA_TA_ERR_W:DA_TA_ERR_S))
#define DA_SET_ERR_RS(err, ret)	((err)|(sm_is_err(ret)?DA_TA_ERR_R:DA_TA_ERR_S))

/* MAIL command */
#define DA_TA_ERR_MAIL		0x10
#define DA_TA_ERR_MAIL_I	(DA_TA_ERR_MAIL|DA_TA_ERR_I)
#define DA_TA_ERR_MAIL_W	(DA_TA_ERR_MAIL|DA_TA_ERR_W)
#define DA_TA_ERR_MAIL_S	(DA_TA_ERR_MAIL|DA_TA_ERR_S)
#define DA_TA_ERR_MAIL_R	(DA_TA_ERR_MAIL|DA_TA_ERR_R)

/* RCPT command */
#define DA_TA_ERR_RCPT		0x20
#define DA_TA_ERR_RCPT_I	(DA_TA_ERR_RCPT|DA_TA_ERR_I)
#define DA_TA_ERR_RCPT_W	(DA_TA_ERR_RCPT|DA_TA_ERR_W)
#define DA_TA_ERR_RCPT_S	(DA_TA_ERR_RCPT|DA_TA_ERR_S)
#define DA_TA_ERR_RCPT_R	(DA_TA_ERR_RCPT|DA_TA_ERR_R)

/* DATA command */
#define DA_TA_ERR_DATA		0x30
#define DA_TA_ERR_DATA_I	(DA_TA_ERR_DATA|DA_TA_ERR_I)
#define DA_TA_ERR_DATA_W	(DA_TA_ERR_DATA|DA_TA_ERR_W)
#define DA_TA_ERR_DATA_S	(DA_TA_ERR_DATA|DA_TA_ERR_S)
#define DA_TA_ERR_DATA_R	(DA_TA_ERR_DATA|DA_TA_ERR_R)

/* CDB errors, e.g., cdb entry can't be opened */
#define DA_TA_ERR_CDB		0x40
#define DA_TA_ERR_CDB_I		(DA_TA_ERR_CDB|DA_TA_ERR_I)
#define DA_TA_ERR_CDB_W		(DA_TA_ERR_CDB|DA_TA_ERR_W)
/* unused, no SMTP command */
/* #define DA_TA_ERR_CDB_S	(DA_TA_ERR_CDB|DA_TA_ERR_S)	*/
#define DA_TA_ERR_CDB_R		(DA_TA_ERR_CDB|DA_TA_ERR_R)

/* Transmission of body */
#define DA_TA_ERR_BODY		0x50
#define DA_TA_ERR_BODY_I	(DA_TA_ERR_BODY|DA_TA_ERR_I)
#define DA_TA_ERR_BODY_W	(DA_TA_ERR_BODY|DA_TA_ERR_W)
/* unused, no SMTP command */
/* #define DA_TA_ERR_BODY_S	(DA_TA_ERR_BODY|DA_TA_ERR_S)	*/
#define DA_TA_ERR_BODY_R	(DA_TA_ERR_BODY|DA_TA_ERR_R)

/* Final dot */
#define DA_TA_ERR_DOT		0x60
#define DA_TA_ERR_DOT_I		(DA_TA_ERR_DOT|DA_TA_ERR_I)
#define DA_TA_ERR_DOT_W		(DA_TA_ERR_DOT|DA_TA_ERR_W)
#define DA_TA_ERR_DOT_S		(DA_TA_ERR_DOT|DA_TA_ERR_S)
#define DA_TA_ERR_DOT_R		(DA_TA_ERR_DOT|DA_TA_ERR_R)

/* LMTP RCPT replies after dot */
#define DA_TA_ERR_L_RCPT	0x70
#define DA_TA_ERR_L_RCPT_I	(DA_TA_ERR_L_RCPT|DA_TA_ERR_I)
#define DA_TA_ERR_L_RCPT_W	(DA_TA_ERR_L_RCPT|DA_TA_ERR_W)
#define DA_TA_ERR_L_RCPT_S	(DA_TA_ERR_L_RCPT|DA_TA_ERR_S)
#define DA_TA_ERR_L_RCPT_R	(DA_TA_ERR_L_RCPT|DA_TA_ERR_R)

/* RSET command (transaction or session?) */
#define DA_TA_ERR_RSET		0x80
#define DA_TA_ERR_RSET_I	(DA_TA_ERR_RSET|DA_TA_ERR_I)
#define DA_TA_ERR_RSET_W	(DA_TA_ERR_RSET|DA_TA_ERR_W)
#define DA_TA_ERR_RSET_S	(DA_TA_ERR_RSET|DA_TA_ERR_S)
#define DA_TA_ERR_RSET_R	(DA_TA_ERR_RSET|DA_TA_ERR_R)

/* "SIZE" command */
#define DA_TA_ERR_SIZE		0x90
#define DA_TA_ERR_SIZE_I	(DA_TA_ERR_SIZE|DA_TA_ERR_I)
#define DA_TA_ERR_SIZE_W	(DA_TA_ERR_SIZE|DA_TA_ERR_W)
#define DA_TA_ERR_SIZE_S	(DA_TA_ERR_SIZE|DA_TA_ERR_S)
#define DA_TA_ERR_SIZE_R	(DA_TA_ERR_SIZE|DA_TA_ERR_R)

/* Errors for session */

/* session can't be created */
#define DA_SE_ERR_CRT		0x00f0
#define DA_SE_ERR_CRT_I		(DA_SE_ERR_CRT|DA_SE_ERR_I)
/* #define DA_SE_ERR_CRT_W		(DA_SE_ERR_CRT|DA_SE_ERR_W) */
/* #define DA_SE_ERR_CRT_S		(DA_SE_ERR_CRT|DA_SE_ERR_S) */
/* #define DA_SE_ERR_CRT_R		(DA_SE_ERR_OPEN|DA_SE_ERR_R) */

/* socket/connect/open */
#define DA_SE_ERR_OPEN		0x0100
#define DA_SE_ERR_OPEN_I	(DA_SE_ERR_OPEN|DA_SE_ERR_I)
#define DA_SE_ERR_OPEN_W	(DA_SE_ERR_OPEN|DA_SE_ERR_W)
#define DA_SE_ERR_OPEN_S	(DA_SE_ERR_OPEN|DA_SE_ERR_S)
#define DA_SE_ERR_OPEN_R	(DA_SE_ERR_OPEN|DA_SE_ERR_R)

/* Greeting from server */
#define DA_SE_ERR_GRET		0x0110
#define DA_SE_ERR_GRET_I	(DA_SE_ERR_GRET|DA_SE_ERR_I)
#define DA_SE_ERR_GRET_W	(DA_SE_ERR_GRET|DA_SE_ERR_W)
#define DA_SE_ERR_GRET_S	(DA_SE_ERR_GRET|DA_SE_ERR_S)
#define DA_SE_ERR_GRET_R	(DA_SE_ERR_GRET|DA_SE_ERR_R)

/* EHLO */
#define DA_SE_ERR_EHLO		0x0120
#define DA_SE_ERR_EHLO_I	(DA_SE_ERR_EHLO|DA_SE_ERR_I)
#define DA_SE_ERR_EHLO_W	(DA_SE_ERR_EHLO|DA_SE_ERR_W)
#define DA_SE_ERR_EHLO_S	(DA_SE_ERR_EHLO|DA_SE_ERR_S)
#define DA_SE_ERR_EHLO_R	(DA_SE_ERR_EHLO|DA_SE_ERR_R)

/* HELO */
#define DA_SE_ERR_HELO		0x0130
#define DA_SE_ERR_HELO_I	(DA_SE_ERR_HELO|DA_SE_ERR_I)
#define DA_SE_ERR_HELO_W	(DA_SE_ERR_HELO|DA_SE_ERR_W)
#define DA_SE_ERR_HELO_S	(DA_SE_ERR_HELO|DA_SE_ERR_S)
#define DA_SE_ERR_HELO_R	(DA_SE_ERR_HELO|DA_SE_ERR_R)

/* LHLO */
#define DA_SE_ERR_LHLO		0x0140
#define DA_SE_ERR_LHLO_I	(DA_SE_ERR_LHLO|DA_SE_ERR_I)
#define DA_SE_ERR_LHLO_W	(DA_SE_ERR_LHLO|DA_SE_ERR_W)
#define DA_SE_ERR_LHLO_S	(DA_SE_ERR_LHLO|DA_SE_ERR_S)
#define DA_SE_ERR_LHLO_R	(DA_SE_ERR_LHLO|DA_SE_ERR_R)

/* STARTTLS */
#define DA_SE_ERR_STLS		0x0150
#define DA_SE_ERR_STLS_I	(DA_SE_ERR_STLS|DA_SE_ERR_I)
#define DA_SE_ERR_STLS_W	(DA_SE_ERR_STLS|DA_SE_ERR_W)
#define DA_SE_ERR_STLS_S	(DA_SE_ERR_STLS|DA_SE_ERR_S)
#define DA_SE_ERR_STLS_R	(DA_SE_ERR_STLS|DA_SE_ERR_R)

/* EHLO */
#define DA_SE_ERR_TTMYSLEF	0x0160
#define DA_SE_ERR_TTMYSLEF_S	(DA_SE_ERR_TTMYSLEF|DA_SE_ERR_S)

/* AUTH, ... */

/* Errors for address resolver; more specific? */
#define DA_AR_ERR		0x0200

/* Timeout error in AQ */
#define DA_AQ_TMO_ERR		0x0210

/* Timeout error in DEFEDB */
#define DA_DQ_TMO_ERR		0x0220

/* DA terminated */
#define DA_TERMINATED		0x0230

#endif /* SM_DA_H */
