/*
 * Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: cdbfs.h,v 1.7 2005/06/16 00:09:34 ca Exp $
 */

#ifndef SM_CDBFS_H
#define SM_CDBFS_H 1

#include "sm/generic.h"
#include "sm/fs.h"

typedef struct cdb_fsctx_S	cdb_fsctx_T, *cdb_fsctx_P;

sm_ret_T	 cdb_fsctx_open(fs_ctx_P fs_ctx, cdb_fsctx_P *_pcdb_fsctx, ulong *pkbfree);
sm_ret_T	 cdb_fsctx_close(cdb_fsctx_P _cdb_fsctx);
sm_ret_T	 cdb_sz_chg(cdb_fsctx_P _cdb_fsctx, char *_cdb_id, long _size, ulong *_pkbfree);
sm_ret_T	 cdb_fs_getfree(cdb_fsctx_P _cdb_fsctx, ulong *_pkbfree);

#define cdb_sz_add(cdb_fsctx, trans_id, size, pkbfree)	\
		cdb_sz_chg(cdb_fsctx, trans_id, (0 - (size)), pkbfree)

#define cdb_sz_rm(cdb_fsctx, trans_id, size, pkbfree)	\
		cdb_sz_chg(cdb_fsctx, trans_id, size, pkbfree)

#define SM_B2KB(bytes)	(((bytes) <= ONEKB) ? 1 : (bytes / ONEKB))

#endif /* SM_CDBFS_H */
