#!/bin/sh
# $Id: t-pmilter-13.sh,v 1.2 2005/10/19 18:33:41 ca Exp $
# Copyright (c) 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test pmilter restart
# uses smtpcnf.sh.
# ----------------------------------------
#
test -s stop && exit 1
#

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh
V=0

SCRIPTS=`cd ${SD} && pwd`

if ../smtps/smtps -VVV | ${GREP} SM_USE_PMILTER >/dev/null
then
  :
else
  echo "$0: smtps not compiled with SM_USE_PMILTER (--enable-pmilter); test SKIPPED"
  exit 0
fi

if test X"`uname`" = "XLinux"
then
  echo "$0: SKIPPED on Linux, needs POSIX conformant pthread implementation"
  exit 0
fi
if test X"`uname`" = "XOSF1"
then
  echo "$0: SKIPPED on OSF1, causes ksh core dump"
  exit 0
fi

OUT="t-pmilter-13.out"
PMPRG="-p ../libpmilter/t-pmilter-1"
PMOPT=""

if test X"`uname`" != "XOSF1"
then
while getopts O:p:s:V FLAG
do
  case "${FLAG}" in
    O) PMOPT="${PMOPT} ${OPTARG}";;
    p) PMPRG="-p ${OPTARG}";;
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# cd to right directory (where the programs will be executed).
cd ../qmgr || exit 1
rm -f ${MTMAP}

${CAT} > ${SMXCNF} <<EOF
qmgr { Log_Level = 12; wait_for_server=4; wait_for_client=4; }
smar { Log_Level = 12; nameserver = ${NS}; }
smtpc { Log_Level = 12; remote_port=${SNKPORT}; wait_for_server=4; }
smtps {
Log_Level = 14;
daemon_address = localhost:${SRVPORT};
wait_for_server=4;
policy_milter { socket {type=unix; path="pmilter.sock";} timeout=20;
 flags=accept_but_reconnect;}
}
EOF

# ----------------------------------------
# reject first MAIL command in pmilter
# wait in pmilter 10s during MAIL, kill pmilter while waiting (TIMING)
# send two more mails:
# the first one goes through because the MTA didn't reconnect yet,
# the second one is blocked because the MTA reconnected.
TEST=1
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
RCPT=x@y.z
rm -f ${PMIDS}
PMOPTS="-r m=550"
if ${SHELL} ${SCRIPTS}/smtpcnf.sh -V '-d 8' -z ${PMPRG} ${PMOPT} -P "${PMOPTS}" -Z 'smtpc2' -c '-E' -E 0 -A 0 -X 0 $@ -Sa0@b.c -R${RCPT}
then
  ERR=false

  # first mail rejected
  if ${GREP} 'MAIL=error' ${CLTL} >/dev/null
  then
    if ${GREP} -i 'err' ${PML} >/dev/null
    then
      echo "$0: test ${TEST} failed: err not found in ${PML}"
      ERR=true
    fi
  else
    echo "$0: test ${TEST} failed: MAIL=error not found in ${CLTL}"
    ERR=true
  fi

  if test -s ${PMIDS}
  then
    # kill pmilter and start new one with 10s delay in MAIL
    kill -HUP `${CAT} ${PMIDS}`
    PMOPTSW="${PMOPTS} -w m=10"
    ../libpmilter/t-pmilter-1 ${PMOPT} ${PMOPTSW} > m${V}.log 2>&1 &
    PMID=$!
    echo ${PMID} >> ${PIDS}
    echo ${PMID} >> ${PMIDS}

    # message should go through, not yet reconnected to pmilter
    if ${STE}/smtpc2 -E -r ${H}:${SRVPORT} -fa2@b.c ${RCPT} > ${CLTL} 2>&1
    then
      if ${GREP} "total=1 " ${CLTL} >/dev/null
      then
       :
      else
        ERR=true
        echo "$0: test ${TEST} failed: total!=1"
      fi
    else
      ERR=true
      echo "$0: test ${TEST} failed: smtpc2:1"
    fi

    sleep 1
    # reconnected to pmilter but will kill it while waiting, hence accepted
    ${STE}/smtpc2 -E -r ${H}:${SRVPORT} -fa3@b.c ${RCPT} > ${CLTL} 2>&1 &
    SRCID=$!
    sleep 1
    # kill pmilter while in MAIL (hopefully)
    kill -HUP ${PMID}
    wait ${PMID}
    # start new pmilter
    ../libpmilter/t-pmilter-1 ${PMOPT} ${PMOPTS} > m${V}.log 2>&1 &
    PMID=$!
    echo ${PMID} >> ${PIDS}
    echo ${PMID} >> ${PMIDS}
    sleep 1

    # send another mail, this one should be accepted: not yet reconnected
    ${STE}/smtpc2 -E -r ${H}:${SRVPORT} -fa4@b.c ${RCPT} > ${CLTL2} 2>&1 &
    SRC2ID=$!

    # send another mail, this one should be blocked
    sleep 3
    ${STE}/smtpc2 -E -r ${H}:${SRVPORT} -fa5@b.c ${RCPT} > ${CLTL3} 2>&1 &
    SRC3ID=$!

    # check first source: should go through (pmilter killed in MAIL)
    wait ${SRCID}
    if ${GREP} "total=1 " ${CLTL} >/dev/null
    then
     :
    else
      ERR=true
      echo "$0: test ${TEST} failed: total!=1"
    fi

    # check second source: should go through (not yet reconnected)
    wait ${SRC2ID}
    if ${GREP} "total=1 " ${CLTL2} >/dev/null
    then
     :
    else
      ERR=true
      echo "$0: test ${TEST} failed: total!=1 in ${CLTL2}"
    fi

    # check third source: should be blocked by pmilter in MAIL
    wait ${SRC3ID}
    if ${GREP} 'MAIL=error' ${CLTL3} >/dev/null
    then
      if ${GREP} -i 'err' ${PML} >/dev/null
      then
        echo "$0: test ${TEST} failed: err not found in ${PML}"
        ERR=true
      fi
    else
      echo "$0: test ${TEST} failed: MAIL=error not found in ${CLTL3}"
      ERR=true
    fi

  else
    echo "$0: cannot find pmilter pid"
  fi
else
    ERR=true
    echo "$0: test ${TEST} failed"
    test X"${SM_STOPONERROR}" != X && exit 1
fi
rm -f ${PMIDS}

if ${ERR}
then
    echo "$0: test ${TEST} check failed"
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit 1
else
    ${VERBOSE} && echo "test ${TEST} succeeded"
fi
${SD}/stopmts.sh
fi


# ----------------------------------------
# end
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
