#!/bin/sh
# $Id: t-mts-mxchk-0.sh,v 1.5 2005/10/21 18:02:20 ca Exp $
# Copyright (c) 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test sender MX checks restrictions.
# uses smtp1.sh.
# ----------------------------------------
#
test -s stop && exit 1
#

if test X"${SM_NO_DNS_TEST}" != "X"
then
  echo "SKIPPED: $0"
  exit 0
fi

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh

SCRIPTS=`cd ${SD} && pwd`

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# cd to right directory (where the programs will be executed).
cd ../qmgr || exit 1

rm -f ${ACCMAP}

# run some test programs

# ----------------------------------------
# reject sender address because it points to a bogus MX record
TEST=1
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
if ${SHELL} ${SCRIPTS}/smtp1.sh -Z 'smtpc2' -c '-E' -E 0 -A 0 -X 0 $@ -S"sender1@mxnull.sm9.org" -R"rcpt1@y.z"
then
    ERR=false
    ${VERBOSE} && echo "test ${TEST} succeeded"
else
    echo "$0: test ${TEST} failed"
    ERR=true
    test X"${SM_STOPONERROR}" != X && exit 1
fi
if ${GREP} 'MAIL=error' ${CLTL} >/dev/null
then
  :
else
  ERR=true
fi
if ${ERR}
then
    echo "$0: test ${TEST} check failed"
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit 1
fi
fi


rm -f ${ACCMAP}

# ----------------------------------------
# end
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
