#!/bin/sh
# $Id: smtpm.sh,v 1.31 2005/10/21 18:02:19 ca Exp $
# Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# test program running the full system:
# qmgr, smar, smtpc, smtps
# using smtps and smtpc from statethreads/examples as source/sink
#
# This program tests multiple destinations, i.e., it tries to
# connect to m.x.y which is "mapped" via mt to 127.1.1.0 and 127.0.0.1
# (see mta-setup.sh).
# The first connection attempt should fail, the second succeed.
#
test -s stop && exit 1
#
# source directory of this (and other) shell script
SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
#
EDBOUT=edbr.out
EDBOK=edbr.ok
# default settings
TAS=1
THREADS=1
RCPTS=1
TOTAL=1
TR=1
INIT=true
RCPTADDR=""
# debug flags
D="-d 5"
SLEEP=20
# server options
SRVOPTS=${SM_SERVER_OPTIONS}

# works only with ksh on OSF/1
if test X"`uname`" != "XOSF1"
then
while getopts d:Dn:R:s:T:t:V: FLAG
do
  case "${FLAG}" in
    d)
       D="-d ${OPTARG}"
       ;;
    D) INIT=false;;
    n)
       # RCPTS="${OPTARG}"
       ;;
    R)
       RCPTADDR="${RCPTADDR} -R${OPTARG}"
       ;;
    s)
       SLEEP="${OPTARG}"
       ;;
    T)
       # TAS="${OPTARG}"
       ;;
    t)
       # THREADS="${OPTARG}"
       ;;
    V)
       SRVOPTS="${OPTARG}"
       ;;
    ?)
       echo "$0: unknown option ${FLAG}"
       echo "$0: options:"
       echo "-n n	n recipients per transaction"
       echo "-T n	n transactions"
       echo "-t n	n threads"
       echo "-V opts	additional SMTP server options"
       exit 1
       ;;
  esac
done
shift `expr ${OPTIND} - 1`
TOTAL=`expr ${TAS} \* ${THREADS}`
TR=`expr ${RCPTS} \* ${TOTAL}`
fi
#
# setup/initialize system
. ${SD}/mta-setup.sh
#

killit()
{
if test -s ${PIDS}
then
  # stop MTA components
  for i in `cat ${PIDS}`
  do
    kill ${i}
  done
fi
# ----------------
# thanks kids for not following the POSIX standard...
if test X"`uname`" = "XLinux"
then
  killall qmgr smar
fi
if test X"${SRVPID}" != "X"
then
  kill -TERM ${SRVPID}
fi
exit 1
}

SRVPID=""
# store the PIDs for the started programs
rm -f ${PIDS}
trap killit 2

# start SMTP sink
${STE}/smtps2 ${PIPELINING} -i -l . -b ${H}:${SNKPORT} > ${SRVL} 2>&1 &
status=$?
SRVPID=$!
if test "x${status}" != "x0"
then
  echo "$0: FAIL: cannot start server ${status}"
  exit ${status}
fi
sleep 1

# version of output files
V=0
# path to programs
P=..
# file to override settings
# test -f options && . ./options
# go for it
${P}/smar/smar ${D} $@ > a${V}.log 2>&1 &
echo $! >> ${PIDS}
#${CHKD}/qmgr-running.sh "${SMARSOCK}" || killit
${P}/qmgr/qmgr -w ${W4S} -W ${W4C} ${D} $@ > q${V}.log 2>&1 &
echo $! >> ${PIDS}
# wait a bit for startup such that the sockets are created
#export SMTPCSOCK
#${CHKD}/qmgr-running.sh || killit

${P}/smtpc/smtpc -O 5 -w ${W4S} -l . -P ${SNKPORT} ${D}  $@ > c${V}.log 2>&1 &
echo $! >> ${PIDS}
${P}/smtps/smtps -w ${W4S} ${SRVOPTS} -l . ${D} -b localhost:${SRVPORT} $@ > s${V}.log 2>&1 &
echo $! >> ${PIDS}

# check that the MTA is running
export SRVPORT P
${CHKD}/mta-running.sh || killit

if ${STE}/smtpc -r ${H}:${SRVPORT} -fa@b.c -Rr@m.x.y -n "${RCPTS}" -T "${TAS}" -t "${THREADS}" > ${CLTL} 2>&1
then
  :
else
  cat ${CLTL}
  ERRS=`expr ${ERRS} + 1 `
fi

sleep ${SLEEP}

# stop MTA components
for i in `cat pids`
do
  kill ${i}
done
# ----------------
# thanks kids for not following the POSIX standard...
if test X"`uname`" = "XLinux"
then
  killall qmgr smar
fi

# send SMTP server a signal to dump its state
if kill -USR1 ${SRVPID}
then
  :
else
  echo "kill -USR1 failed: $?"
  exit 1
fi
sleep 2

# check state of SMTP server
if ${GREP} "^Address *${H}:${P}" ${SRVL} > /dev/null
then
  :
else
  echo "failed to listen on ${H}:${P}"
  ERRS=`expr ${ERRS} + 1 `
fi
if ${GREP} "^Thread.* 8/" ${SRVL} > /dev/null
then
  :
else
  echo "failed to start threads"
  ERRS=`expr ${ERRS} + 1 `
fi
# the number of requests can vary based on the scheduler...
RQS=`${GREP} "^Requests served *" ${SRVL} | sed -e 's/^Requests served *//'`
if test "${RQS}" -lt "${TOTAL}"
then
  echo "wrong number of requests: expected=${TOTAL} got=${RQS}"
  ERRS=`expr ${ERRS} + 1 `
fi
if ${GREP} "^Recipients *${TR}$" ${SRVL} > /dev/null
then
  :
else
  echo "wrong number of recipients: expected=${TR}"
  ${GREP} "^Recipients" ${SRVL}
  ERRS=`expr ${ERRS} + 1 `
fi
if ${GREP} "total=${TOTAL} " ${CLTL} > /dev/null
then
  :
else
  echo "wrong number of mails sent: expected=${TOTAL}"
  ${GREP} "total=" ${CLTL}
  ERRS=`expr ${ERRS} + 1 `
fi

# ----------------
kill -TERM ${SRVPID}

# ----------------
if ${IDBR0} >/dev/null
then
  if test "${ERRS}" = "0"
  then
    rm -f ibdd/ibd00000000*
  fi
else
  echo "t-idbr-0 failed"
  ERRS=`expr ${ERRS} + 1 `
fi

# ----------------
cat > ${EDBOK} <<EOF
tests completed successfully
EOF

if ${EDBR} 2>&1 | sed -e 's;^.* tests;tests;' > ${EDBOUT}
then
  if diff ${EDBOUT} ${EDBOK}
  then
    :
  else
    ERRS=`expr ${ERRS} + 1 `
  fi
else
  echo "${EDBR} failed"
  ERRS=`expr ${ERRS} + 1 `
fi

# ----------------
for i in a c q s
do
  if egrep "${ERRORPAT}" ${i}${V}.log
  then
    ERRS=`expr ${ERRS} + 1 `
  fi
done

# ----------------
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
