#!/bin/sh
# $Id: t-tls.sh,v 1.6 2005/05/31 21:00:28 ca Exp $
# Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ------------------------------------------
# test TLS (currently not activated as test)
# ------------------------------------------
#
test -s stop && exit 1
# source directory of this (and other) shell script
SD=`dirname $0`
#
SRV="error.srv"
CLT="error.clt"
# NOTICE: this must be larger than the size of the TCP buffer...
L=1000000
# verbose?
VERBOSE=false
PRG=./t-tls-0
#
OPT="-V"

for i in CAcert.pem smcert.pem smkey.pem
do
  cp ${SD}/${i} .
done
mkdir certs

rm -f ${SRV} ${CLT}
${VERBOSE} && echo "TLS server/client: basic test"
${PRG} -s 100 2> ${SRV} &
sleep 1
${PRG} -c 100 2> ${CLT}
wait
sleep 1

grep "completed successfully" ${SRV} || exit 1
grep "completed successfully" ${CLT} || exit 2

${VERBOSE} || rm -f ${SRV} ${CLT}
exit 0
