/*
 * Copyright (c) 2002, 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_IDSTR(id, "@(#)$Id: t-t2822-0.c,v 1.10 2005/01/24 06:18:11 ca Exp $")

#include "sm/debug.h"
#include "sm/heap.h"
#include "sm/memops.h"
#include "sm/test.h"
#include "sm/rfc2822.h"

#include <stdio.h>

#if SM_HEAP_CHECK
# include "sm/io.h"
extern SM_DEBUG_T SmHeapCheck;
# define HEAP_CHECK (SmHeapCheck > 0)
#else /* SM_HEAP_CHECK */
# define HEAP_CHECK 0
#endif /* SM_HEAP_CHECK */

#define BUFLEN	512
#define MAXLEN	1024

static void
stripcr(char *buf)
{
	int n;

	n = strlen(buf);
	while (n > 0 && buf[n - 1] == '\n') {
	    buf[n - 1] = '\0';
	   --n;
	}
}

int
main(int argc, char **argv)
{
	int n;
	int c;
	sm_ret_T r;
	sm_2822_a_T list;
	sm_str_P vp;
	sm_str_P out;
	char *buf;

#if SM_HEAP_CHECK
	SmHeapCheck = 0;
#endif
	while ((c = getopt(argc, argv, "H:")) != -1)
	{
		switch (c)
		{
#if SM_HEAP_CHECK
		  case 'H':
			SmHeapCheck = atoi(optarg);
			break;
#endif
#if 0
		  default:
			usage(argv[0]);
			return(1);
#endif /* 0 */
		}
	}

	vp = NULL;
	buf = sm_malloc(BUFLEN);
	SM_TEST(buf != NULL);
	while (fgets(buf, BUFLEN, stdin))
	{
		sm_memzero(&list, sizeof(list));
		n = getc(stdin);
		ungetc(n, stdin);
		if (n == ' ' || n == '\t')
		{
			n = strlen(buf);
			fgets(buf + n, BUFLEN - n, stdin);
		}
		stripcr(buf);

		vp = sm_str_scpy(NULL, buf, MAXLEN);
		SM_TEST(vp != NULL);
		if (!isatty(STDIN_FILENO))
		{
			printf(">>>%s<<<\n", buf);
			fflush(stdout);
		}
		r = t2822_parse(&list, vp);
		SM_TEST(r == 1);
		if (r == 1)
		{
			out = sm_str_new(NULL, BUFLEN, MAXLEN);
			SM_TEST(vp != NULL);
			r = t2822_unparse(out, &list);
			SM_TEST(r == 1);
			printf("%s\n", (char *)sm_str_getdata(out));
		}
		else
		{
			printf(">>>%s<<<	FAILED\n", buf);
			fflush(stdout);
		}
/*
		printf("Parse tree:\n");
		tok822_print(list, 0);
		printf("\n");
		fflush(stdout);
*/
		if (vp != NULL)
		{
			sm_str_free(vp);
			vp = NULL;
		}
	}
	if (vp != NULL)
		sm_str_free(vp);
	if (buf != NULL)
		sm_free(buf);
#if SM_HEAP_CHECK
	if (HEAP_CHECK)
	{
		sm_io_fprintf(smioout,
			"heap should be empty except for makebuf:\n");
		sm_heap_report(smioout, 3);
	}
#endif /* SM_HEAP_CHECK */
	return 0;
}
