/*
 * Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-strsan.c,v 1.6 2005/04/04 23:09:48 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/error.h"
#include "sm/rpool.h"
#include "sm/test.h"
#include "sm/ctype.h"
#include "sm/str.h"

#include <stdio.h>

#define SMAXLEN	256

static void
test_harness(sm_rpool_P a)
{
	sm_str_P s;
	uint i, np;
	uchar buf[SMAXLEN];

	np = 0;
	for (i = 0; i < sizeof(buf); i++)
	{
		buf[i] = (uchar) i;
		if (!ISPRINT(i))
			++np;
	}
	s = sm_str_crt(a, buf, sizeof(buf), sizeof(buf) + 2);
	SM_TEST(s != NULL);
	if (s == NULL)
		return;
	i = sm_str_sanitize(s);
	SM_TEST(i > 0);
	SM_TEST(i == np);
	for (i = 0; i < sm_str_getlen(s); i++)
	{
		SM_TEST(ISPRINT(sm_str_rd_elem(s, i)));
	}
	sm_free(s);
}

int
main(int argc, char *argv[])
{
	sm_test_begin(argc, argv, "test string sanitize");

	/* test without rpool */
	test_harness(NULL);
	return sm_test_end();
}
