/*
 * Copyright (c) 2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 * $Id: t-rcb-chk.c,v 1.2 2004/12/26 04:08:54 ca Exp $
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-rcb-chk.c,v 1.2 2004/12/26 04:08:54 ca Exp $")
#include "sm/assert.h"
#include "sm/error.h"
#include "sm/test.h"
#include "sm/memops.h"
#include "sm/types.h"
#include "sm/rcb.h"
#include "t-rcb.h"

#include <stdio.h>

/*
**  FILLRCB -- fill rcb data
**
**	Parameters:
**		rcb -- RCB
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
fillrcb(sm_rcb_P rcb, uint elems, uint32_t rt)
{
	uint i;
	sm_ret_T ret;

	ret = sm_rcb_open_enc(rcb, -1);
	SM_TEST(sm_is_success(ret));

	/* just a place holder for the size */
	ret = sm_rcb_putuint32(rcb, 0);
	SM_TEST(sm_is_success(ret));

	for (i = 0; i < elems; i++)
	{
		ret = sm_rcb_put3uint32(rcb, rt, 4, i);
		SM_TEST(ret == SM_SUCCESS);
		if (ret != SM_SUCCESS)
		{
			fprintf(stderr, "ret=%x\n", ret);
			break;
		}
		rt += 2;
	}
	sm_rcb_close_enc(rcb);
	return ret;
}

/*
**  CHECKRCB -- check rcb data
**
**	Parameters:
**		rcb -- RCB
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
checkrcb(sm_rcb_P rcb, uint elems, uint32_t rti)
{
	uint i;
	uint32_t rt, l, v, tl;
	sm_ret_T ret;

	ret = sm_rcb_open_dec(rcb);
	SM_TEST(sm_is_success(ret));

	/* just a place holder for the size */
	ret = sm_rcb_getuint32(rcb, &tl);
	SM_TEST(sm_is_success(ret));

	l = elems * 3 * sizeof(uint32_t) + sizeof(uint32_t);
	SM_TEST(tl == l);
	if (!(tl == l))
		fprintf(stderr, "tl=%u, got=%u\n", tl, l);

	for (i = 0; i < elems; i++)
	{
		ret = sm_rcb_get3uint32(rcb, &rt, &l, &v);
		SM_TEST(ret == SM_SUCCESS);
		if (ret != SM_SUCCESS)
			break;
		SM_TEST(rt == rti);
		SM_TEST(l == 4);
		SM_TEST(v == i);
		if (!((rt == rti) && (l == 4) && (v == i)))
			break;
		rti += 2;
	}
	sm_rcb_close_dec(rcb);
	return ret;
}
