/*
**  Copyright (c) 2006 Sendmail, Inc. and its suppliers.
**	All rights reserved.
**
**  $Id: nesting-filter.h,v 1.14 2006/06/12 23:29:45 msk Exp $
*/

#ifndef _NESTING_FILTER_H_
#define _NESTING_FILTER_H_

#ifndef lint
static char nesting_filter_h_id[] = "@(#)$Id: nesting-filter.h,v 1.14 2006/06/12 23:29:45 msk Exp $";
#endif /* !lint */

#include <sys/param.h>

#define	NESTING_PRODUCT		"Sendmail MIME Nesting Filter"
#define	NESTING_VERSION		"1.0.0"

/* make sure we have TRUE and FALSE */
#ifndef FALSE
# define FALSE			0
#endif /* !FALSE */
#ifndef TRUE
# define TRUE			1
#endif /* !TRUE */

/* and some other things */
#ifndef MAXHOSTNAMELEN
# define MAXHOSTNAMELEN		256
#endif /* ! MAXHOSTNAMELEN */

#ifndef MAX
# define MAX(x,y)		((x) > (y) ? (x) : (y))
#endif /* ! MAX */

/* defaults, limits, etc. */
#define	BUFRSZ			256
#define	CMDLINEOPTS		"a:fhlm:p:u:V"
#define	DEFBLOCKACTION		"reject"
#define	DEFREJECTMSG		"too much MIME recursion"
#define	DEFMAXMIMEDEPTH		20
#define	MAXADDRESS		256
#define	MAXARGV			65536
#define	MAXHEADER		1024
#define	MAXMIMEARGS		20
#define	MAXMIMELINE		32768
#define	MAXSMTPLINE		1000

#define	FROMUNKNOWN		"(no From: header)"
#define	HOSTUNKNOWN		"unknown-host"
#define	MSGIDUNKNOWN		"<unknown-msgid>"
#define	XHEADERNAME		"X-Nesting-Filter"

#define	CTHEADER		"Content-Type"
#define	FROMHEADER		"From"
#define	MVHEADER		"MIME-Version"

#define	MIME_SPECIALS		"/;="
#define	MIME_COMMENTS		"()"

/* actions */
#define	NF_ACTION_REJECT	0
#define	NF_ACTION_TEMPFAIL	1
#define	NF_ACTION_DISCARD	2
#define	NF_ACTION_QUARANTINE	3

#endif /* _NESTING_FILTER_H_ */
