.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "UNLISTEN" "" "2011-12-01" "SQL - Language Statements" "SQL Commands"
.SH NAME
UNLISTEN \- stop listening for a notification

.SH SYNOPSIS
.sp
.nf
UNLISTEN { \fIname\fR | * }
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBUNLISTEN\fR is used to remove an existing
registration for \fBNOTIFY\fR events.
\fBUNLISTEN\fR cancels any existing registration of
the current PostgreSQL session as a
listener on the notification \fIname\fR. The special wildcard
* cancels all listener registrations for the
current session.
.PP
NOTIFY [\fBnotify\fR(l)]
contains a more extensive
discussion of the use of \fBLISTEN\fR and
\fBNOTIFY\fR.
.SH "PARAMETERS"
.TP
\fB\fIname\fB\fR
Name of a notification (any identifier).
.TP
\fB*\fR
All current listen registrations for this session are cleared.
.SH "NOTES"
.PP
You may unlisten something you were not listening for; no warning or error
will appear.
.PP
At the end of each session, \fBUNLISTEN *\fR is
automatically executed.
.SH "EXAMPLES"
.PP
To make a registration:
.sp
.nf
LISTEN virtual;
NOTIFY virtual;
Asynchronous notification "virtual" received from server process with PID 8448.
.sp
.fi
.PP
Once \fBUNLISTEN\fR has been executed, further \fBNOTIFY\fR
commands will be ignored:
.sp
.nf
UNLISTEN virtual;
NOTIFY virtual;
-- no NOTIFY event is received
.sp
.fi
.SH "COMPATIBILITY"
.PP
There is no \fBUNLISTEN\fR command in the SQL standard.
.SH "SEE ALSO"
LISTEN [\fBlisten\fR(l)], NOTIFY [\fBnotify\fR(l)]
