.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "SELECT" "" "2009-03-12" "SQL - Language Statements" "SQL Commands"
.SH NAME
SELECT \- retrieve rows from a table or view

.SH SYNOPSIS
.sp
.nf
SELECT [ ALL | DISTINCT [ ON ( \fIexpression\fR [, ...] ) ] ]
    * | \fIexpression\fR [ AS \fIoutput_name\fR ] [, ...]
    [ FROM \fIfrom_item\fR [, ...] ]
    [ WHERE \fIcondition\fR ]
    [ GROUP BY \fIexpression\fR [, ...] ]
    [ HAVING \fIcondition\fR [, ...] ]
    [ { UNION | INTERSECT | EXCEPT } [ ALL ] \fIselect\fR ]
    [ ORDER BY \fIexpression\fR [ ASC | DESC | USING \fIoperator\fR ] [, ...] ]
    [ LIMIT { \fIcount\fR | ALL } ]
    [ OFFSET \fIstart\fR ]
    [ FOR { UPDATE | SHARE } [ OF \fItable_name\fR [, ...] ] [ NOWAIT ] [...] ]

where \fIfrom_item\fR can be one of:

    [ ONLY ] \fItable_name\fR [ * ] [ [ AS ] \fIalias\fR [ ( \fIcolumn_alias\fR [, ...] ) ] ]
    ( \fIselect\fR ) [ AS ] \fIalias\fR [ ( \fIcolumn_alias\fR [, ...] ) ]
    \fIfunction_name\fR ( [ \fIargument\fR [, ...] ] ) [ AS ] \fIalias\fR [ ( \fIcolumn_alias\fR [, ...] | \fIcolumn_definition\fR [, ...] ) ]
    \fIfunction_name\fR ( [ \fIargument\fR [, ...] ] ) AS ( \fIcolumn_definition\fR [, ...] )
    \fIfrom_item\fR [ NATURAL ] \fIjoin_type\fR \fIfrom_item\fR [ ON \fIjoin_condition\fR | USING ( \fIjoin_column\fR [, ...] ) ]
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBSELECT\fR retrieves rows from zero or more tables.
The general processing of \fBSELECT\fR is as follows:
.IP 1. 
All elements in the FROM list are computed.
(Each element in the FROM list is a real or
virtual table.) If more than one element is specified in the
FROM list, they are cross-joined together.
(See FROM Clause [\fBselect\fR(l)] below.)
.IP 2. 
If the WHERE clause is specified, all rows
that do not satisfy the condition are eliminated from the
output. (See WHERE Clause [\fBselect\fR(l)] below.)
.IP 3. 
If the GROUP BY clause is specified, the
output is divided into groups of rows that match on one or more
values. If the HAVING clause is present, it
eliminates groups that do not satisfy the given condition. (See
GROUP BY Clause [\fBselect\fR(l)] and
HAVING Clause [\fBselect\fR(l)] below.)
.IP 4. 
The actual output rows are computed using the
\fBSELECT\fR output expressions for each selected
row. (See
SELECT List [\fBselect\fR(l)]
below.)
.IP 5. 
Using the operators UNION,
INTERSECT, and EXCEPT, the
output of more than one \fBSELECT\fR statement can
be combined to form a single result set. The
UNION operator returns all rows that are in
one or both of the result sets. The
INTERSECT operator returns all rows that are
strictly in both result sets. The EXCEPT
operator returns the rows that are in the first result set but
not in the second. In all three cases, duplicate rows are
eliminated unless ALL is specified. (See
UNION Clause [\fBselect\fR(l)], INTERSECT Clause [\fBselect\fR(l)], and
EXCEPT Clause [\fBselect\fR(l)] below.)
.IP 6. 
If the ORDER BY clause is specified, the
returned rows are sorted in the specified order. If
ORDER BY is not given, the rows are returned
in whatever order the system finds fastest to produce. (See
ORDER BY Clause [\fBselect\fR(l)] below.)
.IP 7. 
DISTINCT eliminates duplicate rows from the
result. DISTINCT ON eliminates rows that
match on all the specified expressions. ALL
(the default) will return all candidate rows, including
duplicates. (See DISTINCT Clause [\fBselect\fR(l)] below.)
.IP 8. 
If the LIMIT or OFFSET
clause is specified, the \fBSELECT\fR statement
only returns a subset of the result rows. (See LIMIT Clause [\fBselect\fR(l)] below.)
.IP 9. 
If FOR UPDATE or FOR SHARE
is specified, the
\fBSELECT\fR statement locks the selected rows
against concurrent updates. (See FOR UPDATE/FOR SHARE Clause [\fBselect\fR(l)] below.)
.PP
.PP
You must have SELECT privilege on a table to
read its values. The use of FOR UPDATE or
FOR SHARE requires
UPDATE privilege as well.
.SH "PARAMETERS"
.SS "FROM CLAUSE"
.PP
The FROM clause specifies one or more source
tables for the \fBSELECT\fR. If multiple sources are
specified, the result is the Cartesian product (cross join) of all
the sources. But usually qualification conditions
are added to restrict the returned rows to a small subset of the
Cartesian product.
.PP
The FROM clause can contain the following
elements:
.TP
\fB\fItable_name\fB\fR
The name (optionally schema-qualified) of an existing table or
view. If ONLY is specified, only that table is
scanned. If ONLY is not specified, the table and
all its descendant tables (if any) are scanned. *
can be appended to the table name to indicate that descendant
tables are to be scanned, but in the current version, this is
the default behavior. (In releases before 7.1,
ONLY was the default behavior.) The default
behavior can be modified by changing the sql_inheritance configuration option.
.TP
\fB\fIalias\fB\fR
A substitute name for the FROM item containing the
alias. An alias is used for brevity or to eliminate ambiguity
for self-joins (where the same table is scanned multiple
times). When an alias is provided, it completely hides the
actual name of the table or function; for example given
FROM foo AS f, the remainder of the
\fBSELECT\fR must refer to this FROM
item as f not foo. If an alias is
written, a column alias list can also be written to provide
substitute names for one or more columns of the table.
.TP
\fB\fIselect\fB\fR
A sub-\fBSELECT\fR can appear in the
FROM clause. This acts as though its
output were created as a temporary table for the duration of
this single \fBSELECT\fR command. Note that the
sub-\fBSELECT\fR must be surrounded by
parentheses, and an alias \fBmust\fR be
provided for it. A
VALUES [\fBvalues\fR(l)] command
can also be used here.
.TP
\fB\fIfunction_name\fB\fR
Function calls can appear in the FROM
clause. (This is especially useful for functions that return
result sets, but any function can be used.) This acts as
though its output were created as a temporary table for the
duration of this single \fBSELECT\fR command. An
alias may also be used. If an alias is written, a column alias
list can also be written to provide substitute names for one
or more attributes of the function's composite return type. If
the function has been defined as returning the \fBrecord\fR
data type, then an alias or the key word AS must
be present, followed by a column definition list in the form
( \fIcolumn_name\fR \fIdata_type\fR [, ... ]
). The column definition list must match the actual
number and types of columns returned by the function.
.TP
\fB\fIjoin_type\fB\fR
One of
.RS
.TP 0.2i
\(bu
[ INNER ] JOIN
.TP 0.2i
\(bu
LEFT [ OUTER ] JOIN
.TP 0.2i
\(bu
RIGHT [ OUTER ] JOIN
.TP 0.2i
\(bu
FULL [ OUTER ] JOIN
.TP 0.2i
\(bu
CROSS JOIN
.RE
.PP
For the INNER and OUTER join types, a
join condition must be specified, namely exactly one of
NATURAL, ON \fIjoin_condition\fR, or
USING (\fIjoin_column\fR [, ...]).
See below for the meaning. For CROSS JOIN,
none of these clauses may appear.

A JOIN clause combines two
FROM items. Use parentheses if necessary to
determine the order of nesting. In the absence of parentheses,
JOINs nest left-to-right. In any case
JOIN binds more tightly than the commas
separating FROM items.

CROSS JOIN and INNER JOIN
produce a simple Cartesian product, the same result as you get from
listing the two items at the top level of FROM,
but restricted by the join condition (if any).
CROSS JOIN is equivalent to INNER JOIN ON
(TRUE), that is, no rows are removed by qualification.
These join types are just a notational convenience, since they
do nothing you couldn't do with plain FROM and
WHERE.

LEFT OUTER JOIN returns all rows in the qualified
Cartesian product (i.e., all combined rows that pass its join
condition), plus one copy of each row in the left-hand table
for which there was no right-hand row that passed the join
condition. This left-hand row is extended to the full width
of the joined table by inserting null values for the
right-hand columns. Note that only the JOIN
clause's own condition is considered while deciding which rows
have matches. Outer conditions are applied afterwards.

Conversely, RIGHT OUTER JOIN returns all the
joined rows, plus one row for each unmatched right-hand row
(extended with nulls on the left). This is just a notational
convenience, since you could convert it to a LEFT
OUTER JOIN by switching the left and right inputs.

FULL OUTER JOIN returns all the joined rows, plus
one row for each unmatched left-hand row (extended with nulls
on the right), plus one row for each unmatched right-hand row
(extended with nulls on the left).
.TP
\fBON \fIjoin_condition\fB\fR
\fIjoin_condition\fR is
an expression resulting in a value of type
\fBboolean\fR (similar to a WHERE
clause) that specifies which rows in a join are considered to
match.
.TP
\fBUSING (\fIjoin_column\fB [, ...])\fR
A clause of the form USING ( a, b, ... ) is
shorthand for ON left_table.a = right_table.a AND
left_table.b = right_table.b .... Also,
USING implies that only one of each pair of
equivalent columns will be included in the join output, not
both.
.TP
\fBNATURAL\fR
NATURAL is shorthand for a
USING list that mentions all columns in the two
tables that have the same names.
.PP
.SS "WHERE CLAUSE"
.PP
The optional WHERE clause has the general form
.sp
.nf
WHERE \fIcondition\fR
.sp
.fi
where \fIcondition\fR is
any expression that evaluates to a result of type
\fBboolean\fR. Any row that does not satisfy this
condition will be eliminated from the output. A row satisfies the
condition if it returns true when the actual row values are
substituted for any variable references.
.SS "GROUP BY CLAUSE"
.PP
The optional GROUP BY clause has the general form
.sp
.nf
GROUP BY \fIexpression\fR [, ...]
.sp
.fi
.PP
GROUP BY will condense into a single row all
selected rows that share the same values for the grouped
expressions. \fIexpression\fR can be an input column
name, or the name or ordinal number of an output column
(\fBSELECT\fR list item), or an arbitrary
expression formed from input-column values. In case of ambiguity,
a GROUP BY name will be interpreted as an
input-column name rather than an output column name.
.PP
Aggregate functions, if any are used, are computed across all rows
making up each group, producing a separate value for each group
(whereas without GROUP BY, an aggregate
produces a single value computed across all the selected rows).
When GROUP BY is present, it is not valid for
the \fBSELECT\fR list expressions to refer to
ungrouped columns except within aggregate functions, since there
would be more than one possible value to return for an ungrouped
column.
.SS "HAVING CLAUSE"
.PP
The optional HAVING clause has the general form
.sp
.nf
HAVING \fIcondition\fR
.sp
.fi
where \fIcondition\fR is
the same as specified for the WHERE clause.
.PP
HAVING eliminates group rows that do not
satisfy the condition. HAVING is different
from WHERE: WHERE filters
individual rows before the application of GROUP
BY, while HAVING filters group rows
created by GROUP BY. Each column referenced in
\fIcondition\fR must
unambiguously reference a grouping column, unless the reference
appears within an aggregate function.
.PP
The presence of HAVING turns a query into a grouped
query even if there is no GROUP BY clause. This is the
same as what happens when the query contains aggregate functions but
no GROUP BY clause. All the selected rows are considered to
form a single group, and the \fBSELECT\fR list and
HAVING clause can only reference table columns from
within aggregate functions. Such a query will emit a single row if the
HAVING condition is true, zero rows if it is not true.
.SS "SELECT LIST"
.PP
The \fBSELECT\fR list (between the key words
SELECT and FROM) specifies expressions
that form the output rows of the \fBSELECT\fR
statement. The expressions can (and usually do) refer to columns
computed in the FROM clause. Using the clause
AS \fIoutput_name\fR, another
name can be specified for an output column. This name is
primarily used to label the column for display. It can also be
used to refer to the column's value in ORDER BY and
GROUP BY clauses, but not in the WHERE or
HAVING clauses; there you must write out the
expression instead.
.PP
Instead of an expression, * can be written in
the output list as a shorthand for all the columns of the selected
rows. Also, one can write \fItable_name\fR.* as a
shorthand for the columns coming from just that table.
.SS "UNION CLAUSE"
.PP
The UNION clause has this general form:
.sp
.nf
\fIselect_statement\fR UNION [ ALL ] \fIselect_statement\fR
.sp
.fi
\fIselect_statement\fR is
any \fBSELECT\fR statement without an ORDER
BY, LIMIT, FOR UPDATE, or
FOR SHARE clause.
(ORDER BY and LIMIT can be attached to a
subexpression if it is enclosed in parentheses. Without
parentheses, these clauses will be taken to apply to the result of
the UNION, not to its right-hand input
expression.)
.PP
The UNION operator computes the set union of
the rows returned by the involved \fBSELECT\fR
statements. A row is in the set union of two result sets if it
appears in at least one of the result sets. The two
\fBSELECT\fR statements that represent the direct
operands of the UNION must produce the same
number of columns, and corresponding columns must be of compatible
data types.
.PP
The result of UNION does not contain any duplicate
rows unless the ALL option is specified.
ALL prevents elimination of duplicates. (Therefore,
UNION ALL is usually significantly quicker than
UNION; use ALL when you can.)
.PP
Multiple UNION operators in the same
\fBSELECT\fR statement are evaluated left to right,
unless otherwise indicated by parentheses.
.PP
Currently, FOR UPDATE and FOR SHARE may not be
specified either for a UNION result or for any input of a
UNION.
.SS "INTERSECT CLAUSE"
.PP
The INTERSECT clause has this general form:
.sp
.nf
\fIselect_statement\fR INTERSECT [ ALL ] \fIselect_statement\fR
.sp
.fi
\fIselect_statement\fR is
any \fBSELECT\fR statement without an ORDER
BY, LIMIT, FOR UPDATE, or
FOR SHARE clause.
.PP
The INTERSECT operator computes the set
intersection of the rows returned by the involved
\fBSELECT\fR statements. A row is in the
intersection of two result sets if it appears in both result sets.
.PP
The result of INTERSECT does not contain any
duplicate rows unless the ALL option is specified.
With ALL, a row that has \fIm\fR duplicates in the
left table and \fIn\fR duplicates in the right table will appear
min(\fIm\fR,\fIn\fR) times in the result set.
.PP
Multiple INTERSECT operators in the same
\fBSELECT\fR statement are evaluated left to right,
unless parentheses dictate otherwise.
INTERSECT binds more tightly than
UNION. That is, A UNION B INTERSECT
C will be read as A UNION (B INTERSECT
C).
.PP
Currently, FOR UPDATE and FOR SHARE may not be
specified either for an INTERSECT result or for any input of
an INTERSECT.
.SS "EXCEPT CLAUSE"
.PP
The EXCEPT clause has this general form:
.sp
.nf
\fIselect_statement\fR EXCEPT [ ALL ] \fIselect_statement\fR
.sp
.fi
\fIselect_statement\fR is
any \fBSELECT\fR statement without an ORDER
BY, LIMIT, FOR UPDATE, or
FOR SHARE clause.
.PP
The EXCEPT operator computes the set of rows
that are in the result of the left \fBSELECT\fR
statement but not in the result of the right one.
.PP
The result of EXCEPT does not contain any
duplicate rows unless the ALL option is specified.
With ALL, a row that has \fIm\fR duplicates in the
left table and \fIn\fR duplicates in the right table will appear
max(\fIm\fR-\fIn\fR,0) times in the result set.
.PP
Multiple EXCEPT operators in the same
\fBSELECT\fR statement are evaluated left to right,
unless parentheses dictate otherwise. EXCEPT binds at
the same level as UNION.
.PP
Currently, FOR UPDATE and FOR SHARE may not be
specified either for an EXCEPT result or for any input of
an EXCEPT.
.SS "ORDER BY CLAUSE"
.PP
The optional ORDER BY clause has this general form:
.sp
.nf
ORDER BY \fIexpression\fR [ ASC | DESC | USING \fIoperator\fR ] [, ...]
.sp
.fi
\fIexpression\fR can be the
name or ordinal number of an output column
(\fBSELECT\fR list item), or it can be an arbitrary
expression formed from input-column values.
.PP
The ORDER BY clause causes the result rows to
be sorted according to the specified expressions. If two rows are
equal according to the leftmost expression, the are compared
according to the next expression and so on. If they are equal
according to all specified expressions, they are returned in
an implementation-dependent order.
.PP
The ordinal number refers to the ordinal (left-to-right) position
of the result column. This feature makes it possible to define an
ordering on the basis of a column that does not have a unique
name. This is never absolutely necessary because it is always
possible to assign a name to a result column using the
AS clause.
.PP
It is also possible to use arbitrary expressions in the
ORDER BY clause, including columns that do not
appear in the \fBSELECT\fR result list. Thus the
following statement is valid:
.sp
.nf
SELECT name FROM distributors ORDER BY code;
.sp
.fi
A limitation of this feature is that an ORDER BY
clause applying to the result of a UNION,
INTERSECT, or EXCEPT clause may only
specify an output column name or number, not an expression.
.PP
If an ORDER BY expression is a simple name that
matches both a result column name and an input column name,
ORDER BY will interpret it as the result column name.
This is the opposite of the choice that GROUP BY will
make in the same situation. This inconsistency is made to be
compatible with the SQL standard.
.PP
Optionally one may add the key word ASC (ascending) or
DESC (descending) after any expression in the
ORDER BY clause. If not specified, ASC is
assumed by default. Alternatively, a specific ordering operator
name may be specified in the USING clause.
ASC is usually equivalent to USING < and
DESC is usually equivalent to USING >.
(But the creator of a user-defined data type can define exactly what the
default sort ordering is, and it might correspond to operators with other
names.)
.PP
The null value sorts higher than any other value. In other words,
with ascending sort order, null values sort at the end, and with
descending sort order, null values sort at the beginning.
.PP
Character-string data is sorted according to the locale-specific
collation order that was established when the database cluster
was initialized.
.SS "DISTINCT CLAUSE"
.PP
If DISTINCT is specified, all duplicate rows are
removed from the result set (one row is kept from each group of
duplicates). ALL specifies the opposite: all rows are
kept; that is the default.
.PP
DISTINCT ON ( \fIexpression\fR [, ...] )
keeps only the first row of each set of rows where the given
expressions evaluate to equal. The DISTINCT ON
expressions are interpreted using the same rules as for
ORDER BY (see above). Note that the ``first
row'' of each set is unpredictable unless ORDER
BY is used to ensure that the desired row appears first. For
example,
.sp
.nf
SELECT DISTINCT ON (location) location, time, report
    FROM weather_reports
    ORDER BY location, time DESC;
.sp
.fi
retrieves the most recent weather report for each location. But
if we had not used ORDER BY to force descending order
of time values for each location, we'd have gotten a report from
an unpredictable time for each location.
.PP
The DISTINCT ON expression(s) must match the leftmost
ORDER BY expression(s). The ORDER BY clause
will normally contain additional expression(s) that determine the
desired precedence of rows within each DISTINCT ON group.
.SS "LIMIT CLAUSE"
.PP
The LIMIT clause consists of two independent
sub-clauses:
.sp
.nf
LIMIT { \fIcount\fR | ALL }
OFFSET \fIstart\fR
.sp
.fi
\fIcount\fR specifies the
maximum number of rows to return, while \fIstart\fR specifies the number of rows
to skip before starting to return rows. When both are specified,
\fIstart\fR rows are skipped
before starting to count the \fIcount\fR rows to be returned.
.PP
When using LIMIT, it is a good idea to use an
ORDER BY clause that constrains the result rows into a
unique order. Otherwise you will get an unpredictable subset of
the query's rows \(em you may be asking for the tenth through
twentieth rows, but tenth through twentieth in what ordering? You
don't know what ordering unless you specify ORDER BY.
.PP
The query planner takes LIMIT into account when
generating a query plan, so you are very likely to get different
plans (yielding different row orders) depending on what you use
for LIMIT and OFFSET. Thus, using
different LIMIT/OFFSET values to select
different subsets of a query result \fBwill give
inconsistent results\fR unless you enforce a predictable
result ordering with ORDER BY. This is not a bug; it
is an inherent consequence of the fact that SQL does not promise
to deliver the results of a query in any particular order unless
ORDER BY is used to constrain the order.
.SS "FOR UPDATE/FOR SHARE CLAUSE"
.PP
The FOR UPDATE clause has this form:
.sp
.nf
FOR UPDATE [ OF \fItable_name\fR [, ...] ] [ NOWAIT ]
.sp
.fi
.PP
The closely related FOR SHARE clause has this form:
.sp
.nf
FOR SHARE [ OF \fItable_name\fR [, ...] ] [ NOWAIT ]
.sp
.fi
.PP
FOR UPDATE causes the rows retrieved by the
\fBSELECT\fR statement to be locked as though for
update. This prevents them from being modified or deleted by
other transactions until the current transaction ends. That is,
other transactions that attempt \fBUPDATE\fR,
\fBDELETE\fR, or \fBSELECT FOR UPDATE\fR
of these rows will be blocked until the current transaction ends.
Also, if an \fBUPDATE\fR, \fBDELETE\fR,
or \fBSELECT FOR UPDATE\fR from another transaction
has already locked a selected row or rows, \fBSELECT FOR
UPDATE\fR will wait for the other transaction to complete,
and will then lock and return the updated row (or no row, if the
row was deleted). For further discussion see in the documentation.
.PP
To prevent the operation from waiting for other transactions to commit,
use the NOWAIT option. \fBSELECT FOR UPDATE
NOWAIT\fR reports an error, rather than waiting, if a selected row
cannot be locked immediately. Note that NOWAIT applies only
to the row-level lock(s) \(em the required ROW SHARE
table-level lock is still taken in the ordinary way (see
in the documentation). You can use the NOWAIT option of
LOCK [\fBlock\fR(l)]
if you need to acquire the table-level lock without waiting.
.PP
FOR SHARE behaves similarly, except that it
acquires a shared rather than exclusive lock on each retrieved
row. A shared lock blocks other transactions from performing
\fBUPDATE\fR, \fBDELETE\fR, or \fBSELECT
FOR UPDATE\fR on these rows, but it does not prevent them
from performing \fBSELECT FOR SHARE\fR.
.PP
If specific tables are named in FOR UPDATE
or FOR SHARE,
then only rows coming from those tables are locked; any other
tables used in the \fBSELECT\fR are simply read as
usual. A FOR UPDATE or FOR SHARE
clause without a table list affects all tables used in the command.
If FOR UPDATE or FOR SHARE is
applied to a view or sub-query, it affects all tables used in
the view or sub-query.
.PP
Multiple FOR UPDATE and FOR SHARE
clauses can be written if it is necessary to specify different locking
behavior for different tables. If the same table is mentioned (or
implicitly affected) by both FOR UPDATE and
FOR SHARE clauses, then it is processed as
FOR UPDATE. Similarly, a table is processed
as NOWAIT if that is specified in any of the clauses
affecting it.
.PP
FOR UPDATE and FOR SHARE cannot be
used in contexts where returned rows can't be clearly identified with
individual table rows; for example they can't be used with aggregation.
.sp
.RS
.B "Caution:"
Avoid locking a row and then modifying it within a later savepoint or
\fBPL/pgSQL\fR exception block. A subsequent
rollback would cause the lock to be lost. For example,
.sp
.nf
BEGIN;
SELECT * FROM mytable WHERE key = 1 FOR UPDATE;
SAVEPOINT s;
UPDATE mytable SET ... WHERE key = 1;
ROLLBACK TO s;
.sp
.fi
After the \fBROLLBACK\fR, the row is effectively unlocked, rather
than returned to its pre-savepoint state of being locked but not modified.
This hazard occurs if a row locked in the current transaction is updated
or deleted, or if a shared lock is upgraded to exclusive: in all these
cases, the former lock state is forgotten. If the transaction is then
rolled back to a state between the original locking command and the
subsequent change, the row will appear not to be locked at all. This is
an implementation deficiency which will be addressed in a future release
of PostgreSQL.
.RE
.sp
.sp
.RS
.B "Caution:"
It is possible for a \fBSELECT\fR command using both
LIMIT and FOR UPDATE/SHARE
clauses to return fewer rows than specified by LIMIT.
This is because LIMIT is applied first. The command
selects the specified number of rows,
but might then block trying to obtain lock on one or more of them.
Once the SELECT unblocks, the row might have been deleted
or updated so that it does not meet the query WHERE condition
anymore, in which case it will not be returned.
.RE
.sp
.SH "EXAMPLES"
.PP
To join the table films with the table
distributors:
.sp
.nf
SELECT f.title, f.did, d.name, f.date_prod, f.kind
    FROM distributors d, films f
    WHERE f.did = d.did

       title       | did |     name     | date_prod  |   kind
-------------------+-----+--------------+------------+----------
 The Third Man     | 101 | British Lion | 1949-12-23 | Drama
 The African Queen | 101 | British Lion | 1951-08-11 | Romantic
 ...
.sp
.fi
.PP
To sum the column len of all films and group
the results by kind:
.sp
.nf
SELECT kind, sum(len) AS total FROM films GROUP BY kind;

   kind   | total
----------+-------
 Action   | 07:34
 Comedy   | 02:58
 Drama    | 14:28
 Musical  | 06:42
 Romantic | 04:38
.sp
.fi
.PP
To sum the column len of all films, group
the results by kind and show those group totals
that are less than 5 hours:
.sp
.nf
SELECT kind, sum(len) AS total
    FROM films
    GROUP BY kind
    HAVING sum(len) < interval '5 hours';

   kind   | total
----------+-------
 Comedy   | 02:58
 Romantic | 04:38
.sp
.fi
.PP
The following two examples are identical ways of sorting the individual
results according to the contents of the second column
(name):
.sp
.nf
SELECT * FROM distributors ORDER BY name;
SELECT * FROM distributors ORDER BY 2;

 did |       name
-----+------------------
 109 | 20th Century Fox
 110 | Bavaria Atelier
 101 | British Lion
 107 | Columbia
 102 | Jean Luc Godard
 113 | Luso films
 104 | Mosfilm
 103 | Paramount
 106 | Toho
 105 | United Artists
 111 | Walt Disney
 112 | Warner Bros.
 108 | Westward
.sp
.fi
.PP
The next example shows how to obtain the union of the tables
distributors and
actors, restricting the results to those that begin
with the letter W in each table. Only distinct rows are wanted, so the
key word ALL is omitted.
.sp
.nf
distributors:               actors:
 did |     name              id |     name
-----+--------------        ----+----------------
 108 | Westward               1 | Woody Allen
 111 | Walt Disney            2 | Warren Beatty
 112 | Warner Bros.           3 | Walter Matthau
 ...                         ...

SELECT distributors.name
    FROM distributors
    WHERE distributors.name LIKE 'W%'
UNION
SELECT actors.name
    FROM actors
    WHERE actors.name LIKE 'W%';

      name
----------------
 Walt Disney
 Walter Matthau
 Warner Bros.
 Warren Beatty
 Westward
 Woody Allen
.sp
.fi
.PP
This example shows how to use a function in the FROM
clause, both with and without a column definition list:
.sp
.nf
CREATE FUNCTION distributors(int) RETURNS SETOF distributors AS $$
    SELECT * FROM distributors WHERE did = $1;
$$ LANGUAGE SQL;

SELECT * FROM distributors(111);
 did |    name
-----+-------------
 111 | Walt Disney

CREATE FUNCTION distributors_2(int) RETURNS SETOF record AS $$
    SELECT * FROM distributors WHERE did = $1;
$$ LANGUAGE SQL;

SELECT * FROM distributors_2(111) AS (f1 int, f2 text);
 f1  |     f2
-----+-------------
 111 | Walt Disney
.sp
.fi
.SH "COMPATIBILITY"
.PP
Of course, the \fBSELECT\fR statement is compatible
with the SQL standard. But there are some extensions and some
missing features.
.SS "OMITTED FROM CLAUSES"
.PP
PostgreSQL allows one to omit the
FROM clause. It has a straightforward use to
compute the results of simple expressions:
.sp
.nf
SELECT 2+2;

 ?column?
----------
        4
.sp
.fi
Some other SQL databases cannot do this except
by introducing a dummy one-row table from which to do the
\fBSELECT\fR.
.PP
Note that if a FROM clause is not specified,
the query cannot reference any database tables. For example, the
following query is invalid:
.sp
.nf
SELECT distributors.* WHERE distributors.name = 'Westward';
.sp
.fi
PostgreSQL releases prior to
8.1 would accept queries of this form, and add an implicit entry
to the query's FROM clause for each table
referenced by the query. This is no longer the default behavior,
because it does not comply with the SQL standard, and is
considered by many to be error-prone. For compatibility with
applications that rely on this behavior the add_missing_from configuration variable can be
enabled.
.SS "THE AS KEY WORD"
.PP
In the SQL standard, the optional key word AS is just
noise and can be omitted without affecting the meaning. The
PostgreSQL parser requires this key
word when renaming output columns because the type extensibility
features lead to parsing ambiguities without it.
AS is optional in FROM
items, however.
.SS "NAMESPACE AVAILABLE TO GROUP BY AND ORDER BY"
.PP
In the SQL-92 standard, an ORDER BY clause may
only use result column names or numbers, while a GROUP
BY clause may only use expressions based on input column
names. PostgreSQL extends each of
these clauses to allow the other choice as well (but it uses the
standard's interpretation if there is ambiguity).
PostgreSQL also allows both clauses to
specify arbitrary expressions. Note that names appearing in an
expression will always be taken as input-column names, not as
result-column names.
.PP
SQL:1999 and later use a slightly different definition which is not
entirely upward compatible with SQL-92. 
In most cases, however, PostgreSQL
will interpret an ORDER BY or GROUP
BY expression the same way SQL:1999 does.
.SS "NONSTANDARD CLAUSES"
.PP
The clauses DISTINCT ON,
LIMIT, and OFFSET are not
defined in the SQL standard.
