/* A Bison parser, made by GNU Bison 1.875.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     SQL_ALLOCATE = 258,
     SQL_AUTOCOMMIT = 259,
     SQL_BOOL = 260,
     SQL_BREAK = 261,
     SQL_CALL = 262,
     SQL_CARDINALITY = 263,
     SQL_CONNECT = 264,
     SQL_CONNECTION = 265,
     SQL_CONTINUE = 266,
     SQL_COUNT = 267,
     SQL_CURRENT = 268,
     SQL_DATA = 269,
     SQL_DATETIME_INTERVAL_CODE = 270,
     SQL_DATETIME_INTERVAL_PRECISION = 271,
     SQL_DESCRIBE = 272,
     SQL_DESCRIPTOR = 273,
     SQL_DISCONNECT = 274,
     SQL_ENUM = 275,
     SQL_FOUND = 276,
     SQL_FREE = 277,
     SQL_GO = 278,
     SQL_GOTO = 279,
     SQL_IDENTIFIED = 280,
     SQL_INDICATOR = 281,
     SQL_KEY_MEMBER = 282,
     SQL_LENGTH = 283,
     SQL_LONG = 284,
     SQL_NAME = 285,
     SQL_NULLABLE = 286,
     SQL_OCTET_LENGTH = 287,
     SQL_OPEN = 288,
     SQL_OUTPUT = 289,
     SQL_RELEASE = 290,
     SQL_REFERENCE = 291,
     SQL_RETURNED_LENGTH = 292,
     SQL_RETURNED_OCTET_LENGTH = 293,
     SQL_SCALE = 294,
     SQL_SECTION = 295,
     SQL_SHORT = 296,
     SQL_SIGNED = 297,
     SQL_SQL = 298,
     SQL_SQLERROR = 299,
     SQL_SQLPRINT = 300,
     SQL_SQLWARNING = 301,
     SQL_START = 302,
     SQL_STOP = 303,
     SQL_STRUCT = 304,
     SQL_UNSIGNED = 305,
     SQL_VALUE = 306,
     SQL_VAR = 307,
     SQL_WHENEVER = 308,
     S_ADD = 309,
     S_AND = 310,
     S_ANYTHING = 311,
     S_AUTO = 312,
     S_CONST = 313,
     S_DEC = 314,
     S_DIV = 315,
     S_DOTPOINT = 316,
     S_EQUAL = 317,
     S_EXTERN = 318,
     S_INC = 319,
     S_LSHIFT = 320,
     S_MEMPOINT = 321,
     S_MEMBER = 322,
     S_MOD = 323,
     S_MUL = 324,
     S_NEQUAL = 325,
     S_OR = 326,
     S_REGISTER = 327,
     S_RSHIFT = 328,
     S_STATIC = 329,
     S_SUB = 330,
     S_VOLATILE = 331,
     S_TYPEDEF = 332,
     TYPECAST = 333,
     ABORT_P = 334,
     ABSOLUTE_P = 335,
     ACCESS = 336,
     ACTION = 337,
     ADD = 338,
     AFTER = 339,
     AGGREGATE = 340,
     ALL = 341,
     ALTER = 342,
     ANALYSE = 343,
     ANALYZE = 344,
     AND = 345,
     ANY = 346,
     ARRAY = 347,
     AS = 348,
     ASC = 349,
     ASSERTION = 350,
     ASSIGNMENT = 351,
     AT = 352,
     AUTHORIZATION = 353,
     BACKWARD = 354,
     BEFORE = 355,
     BEGIN_P = 356,
     BETWEEN = 357,
     BIGINT = 358,
     BINARY = 359,
     BIT = 360,
     BOOLEAN_P = 361,
     BOTH = 362,
     BY = 363,
     CACHE = 364,
     CALLED = 365,
     CASCADE = 366,
     CASE = 367,
     CAST = 368,
     CHAIN = 369,
     CHAR_P = 370,
     CHARACTER = 371,
     CHARACTERISTICS = 372,
     CHECK = 373,
     CHECKPOINT = 374,
     CLASS = 375,
     CLOSE = 376,
     CLUSTER = 377,
     COALESCE = 378,
     COLLATE = 379,
     COLUMN = 380,
     COMMENT = 381,
     COMMIT = 382,
     COMMITTED = 383,
     CONSTRAINT = 384,
     CONSTRAINTS = 385,
     CONVERSION_P = 386,
     CONVERT = 387,
     COPY = 388,
     CREATE = 389,
     CREATEDB = 390,
     CREATEUSER = 391,
     CROSS = 392,
     CURRENT_DATE = 393,
     CURRENT_TIME = 394,
     CURRENT_TIMESTAMP = 395,
     CURRENT_USER = 396,
     CURSOR = 397,
     CYCLE = 398,
     DATABASE = 399,
     DAY_P = 400,
     DEALLOCATE = 401,
     DEC = 402,
     DECIMAL_P = 403,
     DECLARE = 404,
     DEFAULT = 405,
     DEFAULTS = 406,
     DEFERRABLE = 407,
     DEFERRED = 408,
     DEFINER = 409,
     DELETE_P = 410,
     DELIMITER = 411,
     DELIMITERS = 412,
     DESC = 413,
     DISTINCT = 414,
     DO = 415,
     DOMAIN_P = 416,
     DOUBLE_P = 417,
     DROP = 418,
     EACH = 419,
     ELSE = 420,
     ENCODING = 421,
     ENCRYPTED = 422,
     END_P = 423,
     ESCAPE = 424,
     EXCEPT = 425,
     EXCLUSIVE = 426,
     EXCLUDING = 427,
     EXECUTE = 428,
     EXISTS = 429,
     EXPLAIN = 430,
     EXTERNAL = 431,
     EXTRACT = 432,
     FALSE_P = 433,
     FETCH = 434,
     FIRST_P = 435,
     FLOAT_P = 436,
     FOR = 437,
     FORCE = 438,
     FOREIGN = 439,
     FORWARD = 440,
     FREEZE = 441,
     FROM = 442,
     FULL = 443,
     FUNCTION = 444,
     GET = 445,
     GLOBAL = 446,
     GRANT = 447,
     GROUP_P = 448,
     HANDLER = 449,
     HAVING = 450,
     HOLD = 451,
     HOUR_P = 452,
     ILIKE = 453,
     IMMEDIATE = 454,
     IMMUTABLE = 455,
     IMPLICIT_P = 456,
     IN_P = 457,
     INCLUDING = 458,
     INCREMENT = 459,
     INDEX = 460,
     INHERITS = 461,
     INITIALLY = 462,
     INNER_P = 463,
     INOUT = 464,
     INPUT_P = 465,
     INSENSITIVE = 466,
     INSERT = 467,
     INSTEAD = 468,
     INT_P = 469,
     INTEGER = 470,
     INTERSECT = 471,
     INTERVAL = 472,
     INTO = 473,
     INVOKER = 474,
     IS = 475,
     ISNULL = 476,
     ISOLATION = 477,
     JOIN = 478,
     KEY = 479,
     LANCOMPILER = 480,
     LANGUAGE = 481,
     LAST_P = 482,
     LEADING = 483,
     LEFT = 484,
     LEVEL = 485,
     LIKE = 486,
     LIMIT = 487,
     LISTEN = 488,
     LOAD = 489,
     LOCAL = 490,
     LOCATION = 491,
     LOCK_P = 492,
     MATCH = 493,
     MAXVALUE = 494,
     MINUTE_P = 495,
     MINVALUE = 496,
     MODE = 497,
     MONTH_P = 498,
     MOVE = 499,
     NAMES = 500,
     NATIONAL = 501,
     NATURAL = 502,
     NCHAR = 503,
     NEW = 504,
     NEXT = 505,
     NO = 506,
     NOCREATEDB = 507,
     NOCREATEUSER = 508,
     NONE = 509,
     NOT = 510,
     NOTHING = 511,
     NOTIFY = 512,
     NOTNULL = 513,
     NULL_P = 514,
     NULLIF = 515,
     NUMERIC = 516,
     OF = 517,
     OFF = 518,
     OFFSET = 519,
     OIDS = 520,
     OLD = 521,
     ON = 522,
     ONLY = 523,
     OPERATOR = 524,
     OPTION = 525,
     OR = 526,
     ORDER = 527,
     OUT_P = 528,
     OUTER_P = 529,
     OVERLAPS = 530,
     OVERLAY = 531,
     OWNER = 532,
     PARTIAL = 533,
     PASSWORD = 534,
     PATH_P = 535,
     PENDANT = 536,
     PLACING = 537,
     POSITION = 538,
     PRECISION = 539,
     PRESERVE = 540,
     PREPARE = 541,
     PRIMARY = 542,
     PRIOR = 543,
     PRIVILEGES = 544,
     PROCEDURAL = 545,
     PROCEDURE = 546,
     READ = 547,
     REAL = 548,
     RECHECK = 549,
     REFERENCES = 550,
     REINDEX = 551,
     RELATIVE_P = 552,
     RENAME = 553,
     REPLACE = 554,
     RESET = 555,
     RESTART = 556,
     RESTRICT = 557,
     RETURNS = 558,
     REVOKE = 559,
     RIGHT = 560,
     ROLLBACK = 561,
     ROW = 562,
     ROWS = 563,
     RULE = 564,
     SCHEMA = 565,
     SCROLL = 566,
     SECOND_P = 567,
     SECURITY = 568,
     SELECT = 569,
     SEQUENCE = 570,
     SERIALIZABLE = 571,
     SESSION = 572,
     SESSION_USER = 573,
     SET = 574,
     SETOF = 575,
     SHARE = 576,
     SHOW = 577,
     SIMILAR = 578,
     SIMPLE = 579,
     SMALLINT = 580,
     SOME = 581,
     STABLE = 582,
     START = 583,
     STATEMENT = 584,
     STATISTICS = 585,
     STDIN = 586,
     STDOUT = 587,
     STORAGE = 588,
     STRICT_P = 589,
     SUBSTRING = 590,
     SYSID = 591,
     TABLE = 592,
     TEMP = 593,
     TEMPLATE = 594,
     TEMPORARY = 595,
     THEN = 596,
     TIME = 597,
     TIMESTAMP = 598,
     TO = 599,
     TOAST = 600,
     TRAILING = 601,
     TRANSACTION = 602,
     TREAT = 603,
     TRIGGER = 604,
     TRIM = 605,
     TRUE_P = 606,
     TRUNCATE = 607,
     TRUSTED = 608,
     TYPE_P = 609,
     UNENCRYPTED = 610,
     UNION = 611,
     UNIQUE = 612,
     UNKNOWN = 613,
     UNLISTEN = 614,
     UNTIL = 615,
     UPDATE = 616,
     USAGE = 617,
     USER = 618,
     USING = 619,
     VACUUM = 620,
     VALID = 621,
     VALUES = 622,
     VARCHAR = 623,
     VARYING = 624,
     VERBOSE = 625,
     VERSION = 626,
     VIEW = 627,
     VOLATILE = 628,
     WHEN = 629,
     WHERE = 630,
     WITH = 631,
     WITHOUT = 632,
     WORK = 633,
     WRITE = 634,
     YEAR_P = 635,
     ZONE = 636,
     UNIONJOIN = 637,
     IDENT = 638,
     SCONST = 639,
     Op = 640,
     CSTRING = 641,
     CVARIABLE = 642,
     CPP_LINE = 643,
     IP = 644,
     BCONST = 645,
     XCONST = 646,
     ICONST = 647,
     PARAM = 648,
     FCONST = 649,
     POSTFIXOP = 650,
     UMINUS = 651
   };
#endif
#define SQL_ALLOCATE 258
#define SQL_AUTOCOMMIT 259
#define SQL_BOOL 260
#define SQL_BREAK 261
#define SQL_CALL 262
#define SQL_CARDINALITY 263
#define SQL_CONNECT 264
#define SQL_CONNECTION 265
#define SQL_CONTINUE 266
#define SQL_COUNT 267
#define SQL_CURRENT 268
#define SQL_DATA 269
#define SQL_DATETIME_INTERVAL_CODE 270
#define SQL_DATETIME_INTERVAL_PRECISION 271
#define SQL_DESCRIBE 272
#define SQL_DESCRIPTOR 273
#define SQL_DISCONNECT 274
#define SQL_ENUM 275
#define SQL_FOUND 276
#define SQL_FREE 277
#define SQL_GO 278
#define SQL_GOTO 279
#define SQL_IDENTIFIED 280
#define SQL_INDICATOR 281
#define SQL_KEY_MEMBER 282
#define SQL_LENGTH 283
#define SQL_LONG 284
#define SQL_NAME 285
#define SQL_NULLABLE 286
#define SQL_OCTET_LENGTH 287
#define SQL_OPEN 288
#define SQL_OUTPUT 289
#define SQL_RELEASE 290
#define SQL_REFERENCE 291
#define SQL_RETURNED_LENGTH 292
#define SQL_RETURNED_OCTET_LENGTH 293
#define SQL_SCALE 294
#define SQL_SECTION 295
#define SQL_SHORT 296
#define SQL_SIGNED 297
#define SQL_SQL 298
#define SQL_SQLERROR 299
#define SQL_SQLPRINT 300
#define SQL_SQLWARNING 301
#define SQL_START 302
#define SQL_STOP 303
#define SQL_STRUCT 304
#define SQL_UNSIGNED 305
#define SQL_VALUE 306
#define SQL_VAR 307
#define SQL_WHENEVER 308
#define S_ADD 309
#define S_AND 310
#define S_ANYTHING 311
#define S_AUTO 312
#define S_CONST 313
#define S_DEC 314
#define S_DIV 315
#define S_DOTPOINT 316
#define S_EQUAL 317
#define S_EXTERN 318
#define S_INC 319
#define S_LSHIFT 320
#define S_MEMPOINT 321
#define S_MEMBER 322
#define S_MOD 323
#define S_MUL 324
#define S_NEQUAL 325
#define S_OR 326
#define S_REGISTER 327
#define S_RSHIFT 328
#define S_STATIC 329
#define S_SUB 330
#define S_VOLATILE 331
#define S_TYPEDEF 332
#define TYPECAST 333
#define ABORT_P 334
#define ABSOLUTE_P 335
#define ACCESS 336
#define ACTION 337
#define ADD 338
#define AFTER 339
#define AGGREGATE 340
#define ALL 341
#define ALTER 342
#define ANALYSE 343
#define ANALYZE 344
#define AND 345
#define ANY 346
#define ARRAY 347
#define AS 348
#define ASC 349
#define ASSERTION 350
#define ASSIGNMENT 351
#define AT 352
#define AUTHORIZATION 353
#define BACKWARD 354
#define BEFORE 355
#define BEGIN_P 356
#define BETWEEN 357
#define BIGINT 358
#define BINARY 359
#define BIT 360
#define BOOLEAN_P 361
#define BOTH 362
#define BY 363
#define CACHE 364
#define CALLED 365
#define CASCADE 366
#define CASE 367
#define CAST 368
#define CHAIN 369
#define CHAR_P 370
#define CHARACTER 371
#define CHARACTERISTICS 372
#define CHECK 373
#define CHECKPOINT 374
#define CLASS 375
#define CLOSE 376
#define CLUSTER 377
#define COALESCE 378
#define COLLATE 379
#define COLUMN 380
#define COMMENT 381
#define COMMIT 382
#define COMMITTED 383
#define CONSTRAINT 384
#define CONSTRAINTS 385
#define CONVERSION_P 386
#define CONVERT 387
#define COPY 388
#define CREATE 389
#define CREATEDB 390
#define CREATEUSER 391
#define CROSS 392
#define CURRENT_DATE 393
#define CURRENT_TIME 394
#define CURRENT_TIMESTAMP 395
#define CURRENT_USER 396
#define CURSOR 397
#define CYCLE 398
#define DATABASE 399
#define DAY_P 400
#define DEALLOCATE 401
#define DEC 402
#define DECIMAL_P 403
#define DECLARE 404
#define DEFAULT 405
#define DEFAULTS 406
#define DEFERRABLE 407
#define DEFERRED 408
#define DEFINER 409
#define DELETE_P 410
#define DELIMITER 411
#define DELIMITERS 412
#define DESC 413
#define DISTINCT 414
#define DO 415
#define DOMAIN_P 416
#define DOUBLE_P 417
#define DROP 418
#define EACH 419
#define ELSE 420
#define ENCODING 421
#define ENCRYPTED 422
#define END_P 423
#define ESCAPE 424
#define EXCEPT 425
#define EXCLUSIVE 426
#define EXCLUDING 427
#define EXECUTE 428
#define EXISTS 429
#define EXPLAIN 430
#define EXTERNAL 431
#define EXTRACT 432
#define FALSE_P 433
#define FETCH 434
#define FIRST_P 435
#define FLOAT_P 436
#define FOR 437
#define FORCE 438
#define FOREIGN 439
#define FORWARD 440
#define FREEZE 441
#define FROM 442
#define FULL 443
#define FUNCTION 444
#define GET 445
#define GLOBAL 446
#define GRANT 447
#define GROUP_P 448
#define HANDLER 449
#define HAVING 450
#define HOLD 451
#define HOUR_P 452
#define ILIKE 453
#define IMMEDIATE 454
#define IMMUTABLE 455
#define IMPLICIT_P 456
#define IN_P 457
#define INCLUDING 458
#define INCREMENT 459
#define INDEX 460
#define INHERITS 461
#define INITIALLY 462
#define INNER_P 463
#define INOUT 464
#define INPUT_P 465
#define INSENSITIVE 466
#define INSERT 467
#define INSTEAD 468
#define INT_P 469
#define INTEGER 470
#define INTERSECT 471
#define INTERVAL 472
#define INTO 473
#define INVOKER 474
#define IS 475
#define ISNULL 476
#define ISOLATION 477
#define JOIN 478
#define KEY 479
#define LANCOMPILER 480
#define LANGUAGE 481
#define LAST_P 482
#define LEADING 483
#define LEFT 484
#define LEVEL 485
#define LIKE 486
#define LIMIT 487
#define LISTEN 488
#define LOAD 489
#define LOCAL 490
#define LOCATION 491
#define LOCK_P 492
#define MATCH 493
#define MAXVALUE 494
#define MINUTE_P 495
#define MINVALUE 496
#define MODE 497
#define MONTH_P 498
#define MOVE 499
#define NAMES 500
#define NATIONAL 501
#define NATURAL 502
#define NCHAR 503
#define NEW 504
#define NEXT 505
#define NO 506
#define NOCREATEDB 507
#define NOCREATEUSER 508
#define NONE 509
#define NOT 510
#define NOTHING 511
#define NOTIFY 512
#define NOTNULL 513
#define NULL_P 514
#define NULLIF 515
#define NUMERIC 516
#define OF 517
#define OFF 518
#define OFFSET 519
#define OIDS 520
#define OLD 521
#define ON 522
#define ONLY 523
#define OPERATOR 524
#define OPTION 525
#define OR 526
#define ORDER 527
#define OUT_P 528
#define OUTER_P 529
#define OVERLAPS 530
#define OVERLAY 531
#define OWNER 532
#define PARTIAL 533
#define PASSWORD 534
#define PATH_P 535
#define PENDANT 536
#define PLACING 537
#define POSITION 538
#define PRECISION 539
#define PRESERVE 540
#define PREPARE 541
#define PRIMARY 542
#define PRIOR 543
#define PRIVILEGES 544
#define PROCEDURAL 545
#define PROCEDURE 546
#define READ 547
#define REAL 548
#define RECHECK 549
#define REFERENCES 550
#define REINDEX 551
#define RELATIVE_P 552
#define RENAME 553
#define REPLACE 554
#define RESET 555
#define RESTART 556
#define RESTRICT 557
#define RETURNS 558
#define REVOKE 559
#define RIGHT 560
#define ROLLBACK 561
#define ROW 562
#define ROWS 563
#define RULE 564
#define SCHEMA 565
#define SCROLL 566
#define SECOND_P 567
#define SECURITY 568
#define SELECT 569
#define SEQUENCE 570
#define SERIALIZABLE 571
#define SESSION 572
#define SESSION_USER 573
#define SET 574
#define SETOF 575
#define SHARE 576
#define SHOW 577
#define SIMILAR 578
#define SIMPLE 579
#define SMALLINT 580
#define SOME 581
#define STABLE 582
#define START 583
#define STATEMENT 584
#define STATISTICS 585
#define STDIN 586
#define STDOUT 587
#define STORAGE 588
#define STRICT_P 589
#define SUBSTRING 590
#define SYSID 591
#define TABLE 592
#define TEMP 593
#define TEMPLATE 594
#define TEMPORARY 595
#define THEN 596
#define TIME 597
#define TIMESTAMP 598
#define TO 599
#define TOAST 600
#define TRAILING 601
#define TRANSACTION 602
#define TREAT 603
#define TRIGGER 604
#define TRIM 605
#define TRUE_P 606
#define TRUNCATE 607
#define TRUSTED 608
#define TYPE_P 609
#define UNENCRYPTED 610
#define UNION 611
#define UNIQUE 612
#define UNKNOWN 613
#define UNLISTEN 614
#define UNTIL 615
#define UPDATE 616
#define USAGE 617
#define USER 618
#define USING 619
#define VACUUM 620
#define VALID 621
#define VALUES 622
#define VARCHAR 623
#define VARYING 624
#define VERBOSE 625
#define VERSION 626
#define VIEW 627
#define VOLATILE 628
#define WHEN 629
#define WHERE 630
#define WITH 631
#define WITHOUT 632
#define WORK 633
#define WRITE 634
#define YEAR_P 635
#define ZONE 636
#define UNIONJOIN 637
#define IDENT 638
#define SCONST 639
#define Op 640
#define CSTRING 641
#define CVARIABLE 642
#define CPP_LINE 643
#define IP 644
#define BCONST 645
#define XCONST 646
#define ICONST 647
#define PARAM 648
#define FCONST 649
#define POSTFIXOP 650
#define UMINUS 651




/* Copy the first part of user declarations.  */
#line 4 "preproc.y"

#include "postgres_fe.h"

#include "extern.h"

/*
 * Variables containing simple states.
 */
int struct_level = 0;
int braces_open; /* brace level counter */
int ecpg_informix_var = 0;
char	errortext[128];
char	*connection = NULL;
char	*input_filename = NULL;

static int	QueryIsRule = 0, FoundInto = 0;
static int	initializer = 0;
static struct this_type actual_type[STRUCT_DEPTH];
static char *actual_startline[STRUCT_DEPTH];

/* temporarily store struct members while creating the data structure */
struct ECPGstruct_member *struct_member_list[STRUCT_DEPTH] = { NULL };

/* also store struct type so we can do a sizeof() later */
static char *ECPGstruct_sizeof = NULL;

/* for forward declarations we have to store some data as well */
static char *forward_name = NULL;

struct ECPGtype ecpg_no_indicator = {ECPGt_NO_INDICATOR, 0L, NULL, {NULL}};
struct variable no_indicator = {"no_indicator", &ecpg_no_indicator, 0, NULL};

struct ECPGtype ecpg_query = {ECPGt_char_variable, 0L, NULL, {NULL}};

static struct inf_compat_col
{
	char *name;
	char *indirection;
	struct inf_compat_col *next;
} *informix_col;

static struct inf_compat_val
{
	char *val;
	struct inf_compat_val *next;
} *informix_val;

/*
 * Handle parsing errors and warnings
 */
void
mmerror(int error_code, enum errortype type, char * error)
{
	switch(type)
	{
		case ET_WARNING:
			fprintf(stderr, "%s:%d: WARNING: %s\n", input_filename, yylineno, error);
			break;
		case ET_ERROR:
			fprintf(stderr, "%s:%d: ERROR: %s\n", input_filename, yylineno, error);
			ret_value = error_code;
			break;
		case ET_FATAL:
			fprintf(stderr, "%s:%d: ERROR: %s\n", input_filename, yylineno, error);
			exit(error_code);
	}
}

/*
 * string concatenation
 */

static char *
cat2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 2);

	strcpy(res_str, str1);
	strcat(res_str, " ");
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
cat_str(int count, ...)
{
	va_list		args;
	int			i;
	char		*res_str;

	va_start(args, count);

	res_str = va_arg(args, char *);

	/* now add all other strings */
	for (i = 1; i < count; i++)
		res_str = cat2_str(res_str, va_arg(args, char *));

	va_end(args);

	return(res_str);
}

char *
make_str(const char *str)
{
	char * res_str = (char *)mm_alloc(strlen(str) + 1);

	strcpy(res_str, str);
	return res_str;
}

static char *
make2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
make3_str(char *str1, char *str2, char *str3)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) +strlen(str3) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	strcat(res_str, str3);
	free(str1);
	free(str2);
	free(str3);
	return(res_str);
}

/* and the rest */
static char *
make_name(void)
{
	char * name = (char *)mm_alloc(yyleng + 1);

	strncpy(name, yytext, yyleng);
	name[yyleng] = '\0';
	return(name);
}

static char *
create_questionmarks(char *name, bool array)
{
	struct variable *p = find_variable(name);
	int count;
	char *result = EMPTY;

	/* In case we have a struct, we have to print as many "?" as there are attributes in the struct 
	 * An array is only allowed together with an element argument 
	 * This is essantially only used for inserts, but using a struct as input parameter is an error anywhere else 
	 * so we don't have to worry here. */
	
	if (p->type->type == ECPGt_struct || (array && p->type->type == ECPGt_array && p->type->u.element->type == ECPGt_struct))
	{
		struct ECPGstruct_member *m;

		if (p->type->type == ECPGt_struct)
			m = p->type->u.members;
		else
			m = p->type->u.element->u.members;

		for (count = 0; m != NULL; m=m->next, count++);
	}
	else
		count = 1;

	for (; count > 0; count --)
		result = cat2_str(result, make_str("? , "));

	/* removed the trailing " ," */

	result[strlen(result)-3] = '\0';
	return(result);
}

static char *
adjust_informix(struct arguments *list)
{
	/* Informix accepts DECLARE with variables that are out of scope when OPEN is called.
	 * This breaks standard and leads to some very dangerous programming. 
	 * Since they do, we have to work around and accept their syntax as well.
	 * But we will do so ONLY in Informix mode.
	 * We have to change the variables to our own struct and just store the pointer instead of the variable */

	 struct arguments *ptr;
	 char *result = make_str("");

	 for (ptr = list; ptr != NULL; ptr = ptr->next)
	 {
	 	char temp[20]; /* this should be sufficient unless you have 8 byte integers */
		char *original_var;
		
	 	/* change variable name to "ECPG_informix_get_var(<counter>)" */
		original_var = ptr->variable->name;
		sprintf(temp, "%d))", ecpg_informix_var);
		
		if ((ptr->variable->type->type != ECPGt_char && ptr->variable->type->type != ECPGt_unsigned_char) && atoi(ptr->variable->type->size) > 1)
		{
			ptr->variable = new_variable(cat_str(4, make_str("("), mm_strdup(ECPGtype_name(ptr->variable->type->u.element->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type, make_str("1")), ptr->variable->type->size), 0);
			sprintf(temp, "%d, (", ecpg_informix_var++);
		}
		else
		{
			ptr->variable = new_variable(cat_str(4, make_str("*("), mm_strdup(ECPGtype_name(ptr->variable->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size), 0);
			sprintf(temp, "%d, &(", ecpg_informix_var++);
		}
		
		/* create call to "ECPG_informix_set_var(<counter>, <pointer>. <linen number>)" */
		result = cat_str(5, result, make_str("ECPG_informix_set_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));
		
		/* now the indicator if there is one */
		if (ptr->indicator->type->type != ECPGt_NO_INDICATOR)
		{
			/* change variable name to "ECPG_informix_get_var(<counter>)" */
			original_var = ptr->indicator->name;
			sprintf(temp, "%d))", ecpg_informix_var);
			
			/* create call to "ECPG_informix_set_var(<counter>, <pointer>. <linen number>)" */
			if (atoi(ptr->indicator->type->size) > 1)
			{
				ptr->indicator = new_variable(cat_str(4, make_str("("), mm_strdup(ECPGtype_name(ptr->indicator->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size), 0);
				sprintf(temp, "%d, (", ecpg_informix_var++);
			}
			else
			{
				ptr->indicator = new_variable(cat_str(4, make_str("*("), mm_strdup(ECPGtype_name(ptr->indicator->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size), 0);
				sprintf(temp, "%d, &(", ecpg_informix_var++);
			}
			result = cat_str(5, result, make_str("ECPG_informix_set_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));
		}
	 }

	 return result;
}

static struct cursor *
add_additional_variables(char *name, bool insert)
{
	struct cursor *ptr;
	struct arguments *p;

	for (ptr = cur; ptr != NULL; ptr=ptr->next)
	{
		if (strcmp(ptr->name, name) == 0)
			break;
	}

	if (ptr == NULL)
	{
		snprintf(errortext, sizeof(errortext), "trying to access an undeclared cursor %s\n", name);
		mmerror(PARSE_ERROR, ET_ERROR, errortext);
		return NULL;
	}
	if (insert)
	{
		/* add all those input variables that were given earlier 
		 * note that we have to append here but have to keep the existing order */
		for (p = ptr->argsinsert; p; p = p->next)
			add_variable_to_tail(&argsinsert, p->variable, p->indicator);
	}

	/* add all those output variables that were given earlier */
	for (p = ptr->argsresult; p; p = p->next)
		add_variable_to_tail(&argsresult, p->variable, p->indicator);
	
	return ptr;
}


/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 284 "preproc.y"
typedef union YYSTYPE {
	double	dval;
	char	*str;
	int     ival;
	struct	when		action;
	struct	index		index;
	int		tagname;
	struct	this_type	type;
	enum	ECPGttype	type_enum;
	enum	ECPGdtype	dtype_enum;
	struct	fetch_desc	descriptor;
	struct  su_symbol	struct_union;
} YYSTYPE;
/* Line 191 of yacc.c.  */
#line 1161 "y.tab.c"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 1173 "y.tab.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   49921

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  417
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  493
/* YYNRULES -- Number of rules. */
#define YYNRULES  1859
/* YYNRULES -- Number of states. */
#define YYNSTATES  3032

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   652

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned short yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,   403,     2,     2,
     408,   409,   401,   399,   414,   400,   410,   402,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   416,   411,
     396,   395,   397,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   406,     2,   407,   404,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   412,     2,   413,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     398,   405,   415
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short yyprhs[] =
{
       0,     0,     3,     5,     6,     9,    14,    18,    21,    23,
      25,    27,    29,    31,    34,    36,    38,    40,    42,    44,
      46,    48,    50,    52,    54,    56,    58,    60,    62,    64,
      66,    68,    70,    72,    74,    76,    78,    80,    82,    84,
      86,    88,    90,    92,    94,    96,    98,   100,   102,   104,
     106,   108,   110,   112,   114,   116,   118,   120,   122,   124,
     126,   128,   130,   132,   134,   136,   138,   140,   142,   144,
     146,   148,   150,   152,   154,   156,   158,   160,   162,   164,
     166,   168,   170,   172,   174,   176,   178,   180,   182,   184,
     186,   188,   190,   192,   194,   196,   198,   200,   202,   204,
     206,   208,   210,   216,   218,   219,   224,   230,   236,   241,
     245,   248,   249,   252,   255,   257,   259,   261,   263,   267,
     271,   275,   277,   282,   288,   291,   292,   295,   298,   305,
     312,   316,   324,   329,   331,   332,   335,   336,   338,   340,
     342,   345,   349,   353,   357,   361,   365,   368,   374,   377,
     381,   385,   387,   389,   391,   395,   398,   400,   402,   404,
     406,   408,   410,   412,   414,   416,   418,   422,   429,   431,
     433,   435,   437,   438,   440,   442,   445,   449,   454,   458,
     461,   464,   468,   473,   477,   480,   485,   487,   489,   491,
     493,   495,   502,   510,   520,   530,   540,   550,   558,   564,
     572,   579,   586,   593,   600,   604,   607,   609,   611,   612,
     615,   625,   627,   629,   631,   633,   635,   638,   639,   641,
     643,   647,   651,   653,   654,   657,   658,   662,   663,   665,
     666,   677,   689,   691,   693,   696,   699,   702,   705,   706,
     708,   709,   711,   715,   717,   719,   721,   725,   728,   729,
     733,   735,   737,   740,   742,   744,   747,   752,   755,   761,
     763,   766,   769,   772,   776,   779,   782,   783,   787,   789,
     794,   799,   805,   817,   821,   822,   826,   828,   830,   833,
     836,   837,   839,   841,   844,   847,   848,   852,   856,   859,
     861,   863,   866,   869,   874,   875,   878,   881,   882,   886,
     891,   896,   897,   898,   907,   911,   912,   916,   918,   920,
     926,   931,   934,   935,   938,   940,   943,   947,   950,   953,
     956,   959,   963,   967,   969,   970,   979,   981,   982,   984,
     986,   989,   990,   996,   998,   999,  1014,  1034,  1036,  1038,
    1040,  1044,  1050,  1052,  1054,  1056,  1060,  1061,  1063,  1064,
    1066,  1068,  1070,  1074,  1075,  1077,  1079,  1080,  1083,  1085,
    1088,  1090,  1093,  1096,  1098,  1101,  1104,  1111,  1120,  1124,
    1129,  1134,  1139,  1145,  1149,  1153,  1155,  1159,  1163,  1165,
    1167,  1169,  1171,  1184,  1186,  1190,  1195,  1203,  1208,  1211,
    1213,  1214,  1216,  1217,  1225,  1230,  1232,  1234,  1236,  1238,
    1240,  1242,  1244,  1246,  1248,  1252,  1254,  1256,  1260,  1266,
    1271,  1276,  1280,  1285,  1289,  1293,  1296,  1301,  1304,  1306,
    1308,  1310,  1312,  1315,  1318,  1320,  1322,  1324,  1327,  1330,
    1332,  1335,  1338,  1340,  1342,  1344,  1351,  1361,  1369,  1379,
    1388,  1397,  1404,  1406,  1408,  1410,  1412,  1414,  1416,  1418,
    1420,  1422,  1424,  1426,  1434,  1443,  1446,  1448,  1450,  1452,
    1456,  1458,  1460,  1462,  1464,  1466,  1468,  1470,  1472,  1474,
    1476,  1478,  1480,  1482,  1485,  1488,  1491,  1494,  1497,  1499,
    1503,  1505,  1508,  1512,  1513,  1517,  1518,  1520,  1524,  1527,
    1539,  1541,  1542,  1545,  1546,  1548,  1552,  1555,  1561,  1566,
    1568,  1571,  1572,  1582,  1585,  1586,  1590,  1593,  1595,  1599,
    1602,  1604,  1606,  1608,  1610,  1612,  1616,  1618,  1620,  1625,
    1627,  1630,  1633,  1636,  1638,  1640,  1642,  1647,  1653,  1655,
    1659,  1663,  1666,  1669,  1672,  1673,  1679,  1687,  1689,  1691,
    1699,  1701,  1705,  1709,  1713,  1715,  1719,  1731,  1742,  1745,
    1746,  1755,  1760,  1765,  1767,  1769,  1771,  1772,  1782,  1789,
    1796,  1804,  1811,  1818,  1828,  1835,  1844,  1853,  1860,  1862,
    1863,  1865,  1866,  1867,  1882,  1884,  1886,  1890,  1894,  1896,
    1898,  1900,  1902,  1904,  1906,  1908,  1909,  1911,  1913,  1915,
    1917,  1919,  1920,  1927,  1930,  1933,  1936,  1939,  1942,  1945,
    1949,  1952,  1955,  1958,  1960,  1962,  1963,  1967,  1969,  1974,
    1979,  1981,  1982,  1985,  1988,  1996,  1999,  2005,  2009,  2011,
    2014,  2018,  2022,  2026,  2030,  2034,  2038,  2042,  2046,  2048,
    2049,  2055,  2060,  2064,  2071,  2076,  2083,  2090,  2096,  2104,
    2111,  2113,  2114,  2125,  2130,  2133,  2135,  2140,  2146,  2152,
    2155,  2160,  2162,  2164,  2166,  2167,  2169,  2170,  2172,  2173,
    2177,  2178,  2183,  2185,  2187,  2189,  2191,  2193,  2195,  2196,
    2201,  2206,  2209,  2211,  2219,  2224,  2228,  2230,  2233,  2238,
    2243,  2247,  2248,  2251,  2254,  2257,  2261,  2263,  2267,  2269,
    2272,  2279,  2287,  2288,  2291,  2294,  2297,  2301,  2302,  2305,
    2308,  2310,  2312,  2316,  2320,  2322,  2325,  2330,  2335,  2337,
    2339,  2348,  2353,  2358,  2363,  2366,  2368,  2369,  2373,  2377,
    2382,  2387,  2392,  2397,  2400,  2402,  2404,  2405,  2407,  2408,
    2410,  2416,  2418,  2419,  2421,  2422,  2426,  2428,  2432,  2436,
    2439,  2442,  2444,  2449,  2454,  2457,  2460,  2465,  2467,  2468,
    2470,  2472,  2474,  2478,  2479,  2482,  2483,  2487,  2491,  2493,
    2494,  2497,  2498,  2501,  2502,  2506,  2508,  2510,  2513,  2515,
    2518,  2524,  2531,  2537,  2539,  2542,  2544,  2549,  2553,  2558,
    2562,  2568,  2573,  2579,  2584,  2590,  2593,  2598,  2600,  2603,
    2606,  2609,  2611,  2613,  2614,  2619,  2622,  2624,  2627,  2630,
    2635,  2639,  2644,  2647,  2648,  2650,  2654,  2657,  2660,  2664,
    2670,  2677,  2681,  2686,  2687,  2689,  2693,  2697,  2701,  2705,
    2709,  2713,  2715,  2717,  2719,  2721,  2723,  2725,  2727,  2730,
    2736,  2739,  2741,  2743,  2745,  2747,  2749,  2751,  2753,  2755,
    2757,  2759,  2761,  2764,  2767,  2770,  2773,  2776,  2778,  2782,
    2783,  2789,  2793,  2794,  2800,  2804,  2805,  2807,  2809,  2811,
    2813,  2819,  2822,  2824,  2826,  2828,  2830,  2836,  2839,  2842,
    2845,  2847,  2851,  2855,  2858,  2860,  2861,  2865,  2866,  2872,
    2875,  2881,  2884,  2886,  2890,  2894,  2895,  2897,  2899,  2901,
    2903,  2905,  2907,  2911,  2915,  2919,  2923,  2927,  2931,  2935,
    2936,  2940,  2945,  2950,  2954,  2958,  2962,  2967,  2971,  2977,
    2982,  2987,  2991,  2995,  2999,  3001,  3003,  3005,  3007,  3009,
    3011,  3013,  3015,  3017,  3019,  3021,  3023,  3025,  3027,  3029,
    3034,  3036,  3041,  3043,  3047,  3053,  3056,  3059,  3062,  3065,
    3068,  3071,  3075,  3079,  3083,  3087,  3091,  3095,  3099,  3103,
    3107,  3111,  3114,  3117,  3121,  3125,  3128,  3132,  3138,  3143,
    3150,  3154,  3160,  3165,  3172,  3177,  3184,  3190,  3198,  3201,
    3205,  3208,  3213,  3217,  3222,  3226,  3231,  3235,  3240,  3246,
    3253,  3261,  3267,  3274,  3278,  3283,  3288,  3295,  3298,  3300,
    3302,  3306,  3309,  3312,  3315,  3318,  3321,  3325,  3329,  3333,
    3337,  3341,  3345,  3349,  3353,  3357,  3361,  3364,  3367,  3373,
    3380,  3388,  3390,  3392,  3396,  3402,  3407,  3409,  3413,  3418,
    3424,  3430,  3435,  3437,  3440,  3445,  3448,  3453,  3456,  3459,
    3462,  3469,  3474,  3479,  3484,  3489,  3496,  3502,  3508,  3514,
    3519,  3526,  3531,  3533,  3536,  3539,  3542,  3547,  3554,  3555,
    3557,  3561,  3565,  3566,  3570,  3572,  3574,  3578,  3582,  3586,
    3588,  3590,  3592,  3594,  3596,  3598,  3600,  3602,  3607,  3611,
    3614,  3618,  3619,  3623,  3627,  3630,  3633,  3635,  3636,  3639,
    3642,  3646,  3649,  3651,  3653,  3657,  3663,  3670,  3675,  3678,
    3680,  3685,  3688,  3689,  3691,  3692,  3695,  3698,  3701,  3704,
    3707,  3711,  3714,  3715,  3719,  3721,  3725,  3727,  3729,  3733,
    3741,  3743,  3746,  3751,  3753,  3757,  3762,  3767,  3771,  3773,
    3775,  3777,  3779,  3781,  3783,  3787,  3789,  3791,  3793,  3797,
    3799,  3801,  3803,  3805,  3807,  3809,  3811,  3813,  3815,  3818,
    3822,  3829,  3832,  3834,  3836,  3838,  3840,  3842,  3844,  3846,
    3848,  3850,  3852,  3854,  3856,  3859,  3861,  3863,  3865,  3867,
    3869,  3871,  3873,  3876,  3879,  3881,  3883,  3885,  3887,  3889,
    3891,  3893,  3895,  3897,  3899,  3901,  3903,  3909,  3913,  3916,
    3919,  3923,  3931,  3933,  3936,  3939,  3941,  3942,  3944,  3948,
    3950,  3953,  3954,  3957,  3958,  3961,  3962,  3964,  3968,  3973,
    3977,  3979,  3981,  3983,  3986,  3987,  3995,  3999,  4002,  4004,
    4006,  4008,  4009,  4015,  4016,  4021,  4024,  4026,  4029,  4030,
    4032,  4036,  4040,  4044,  4048,  4050,  4052,  4055,  4057,  4058,
    4063,  4069,  4075,  4076,  4078,  4080,  4082,  4085,  4088,  4090,
    4093,  4094,  4102,  4103,  4109,  4110,  4115,  4118,  4121,  4123,
    4125,  4127,  4129,  4131,  4133,  4135,  4137,  4139,  4141,  4143,
    4149,  4151,  4154,  4156,  4160,  4163,  4166,  4170,  4171,  4177,
    4179,  4180,  4186,  4189,  4192,  4194,  4196,  4198,  4201,  4204,
    4208,  4210,  4213,  4216,  4220,  4224,  4229,  4232,  4234,  4237,
    4239,  4241,  4244,  4247,  4251,  4253,  4255,  4257,  4258,  4260,
    4264,  4269,  4270,  4273,  4274,  4276,  4279,  4283,  4286,  4288,
    4290,  4292,  4293,  4295,  4297,  4301,  4302,  4307,  4310,  4313,
    4315,  4317,  4318,  4320,  4322,  4324,  4326,  4329,  4333,  4334,
    4336,  4339,  4344,  4349,  4350,  4352,  4354,  4356,  4359,  4361,
    4363,  4367,  4369,  4371,  4376,  4381,  4386,  4391,  4393,  4394,
    4398,  4402,  4406,  4408,  4412,  4414,  4416,  4418,  4420,  4422,
    4424,  4426,  4428,  4430,  4432,  4434,  4436,  4438,  4440,  4442,
    4444,  4448,  4450,  4454,  4459,  4466,  4473,  4476,  4481,  4486,
    4488,  4490,  4495,  4500,  4504,  4505,  4513,  4515,  4516,  4517,
    4525,  4529,  4534,  4538,  4540,  4542,  4544,  4547,  4551,  4557,
    4560,  4566,  4569,  4571,  4573,  4575,  4577,  4579,  4581,  4583,
    4585,  4587,  4589,  4591,  4593,  4595,  4597,  4599,  4601,  4603,
    4605,  4607,  4609,  4611,  4613,  4615,  4617,  4619,  4621,  4623,
    4625,  4627,  4629,  4631,  4633,  4635,  4637,  4639,  4641,  4643,
    4645,  4647,  4649,  4651,  4653,  4655,  4657,  4659,  4661,  4663,
    4665,  4667,  4669,  4671,  4673,  4675,  4677,  4679,  4681,  4683,
    4685,  4687,  4689,  4691,  4693,  4695,  4697,  4699,  4701,  4703,
    4705,  4707,  4709,  4711,  4713,  4715,  4717,  4719,  4721,  4723,
    4725,  4727,  4729,  4731,  4733,  4735,  4737,  4739,  4741,  4743,
    4745,  4747,  4749,  4751,  4753,  4755,  4757,  4759,  4761,  4763,
    4765,  4767,  4769,  4771,  4773,  4775,  4777,  4779,  4781,  4783,
    4785,  4787,  4789,  4791,  4793,  4795,  4797,  4799,  4801,  4803,
    4805,  4807,  4809,  4811,  4813,  4815,  4817,  4819,  4821,  4823,
    4825,  4827,  4829,  4831,  4833,  4835,  4837,  4839,  4841,  4843,
    4845,  4847,  4849,  4851,  4853,  4855,  4857,  4859,  4861,  4863,
    4865,  4867,  4869,  4871,  4873,  4875,  4877,  4879,  4881,  4883,
    4885,  4887,  4889,  4891,  4893,  4895,  4897,  4899,  4901,  4903,
    4905,  4907,  4909,  4911,  4913,  4915,  4917,  4919,  4921,  4923,
    4925,  4927,  4929,  4931,  4933,  4935,  4937,  4939,  4941,  4943,
    4945,  4947,  4949,  4951,  4953,  4955,  4957,  4959,  4961,  4963,
    4965,  4967,  4969,  4971,  4973,  4975,  4977,  4979,  4981,  4983,
    4985,  4987,  4989,  4991,  4993,  4995,  4997,  4999,  5001,  5003,
    5005,  5007,  5009,  5011,  5013,  5015,  5017,  5019,  5021,  5023,
    5025,  5027,  5029,  5031,  5033,  5035,  5037,  5039,  5041,  5043,
    5045,  5047,  5049,  5051,  5053,  5055,  5057,  5059,  5061,  5063,
    5065,  5067,  5069,  5071,  5073,  5075,  5077,  5079,  5081,  5083,
    5085,  5087,  5089,  5091,  5093,  5095,  5097,  5099,  5101,  5103,
    5105,  5107,  5109,  5111,  5113,  5115,  5117,  5119,  5121,  5123,
    5125,  5127,  5129,  5131,  5133,  5135,  5137,  5139,  5141,  5143,
    5145,  5147,  5149,  5151,  5153,  5155,  5157,  5159,  5161,  5163,
    5165,  5167,  5169,  5171,  5173,  5175,  5177,  5179,  5181,  5183,
    5185,  5187,  5189,  5191,  5193,  5195,  5197,  5199,  5201,  5203,
    5205,  5207,  5209,  5211,  5213,  5215,  5217,  5219,  5221,  5223,
    5225,  5227,  5229,  5231,  5233,  5235,  5237,  5239,  5241,  5243,
    5245,  5247,  5249,  5251,  5253,  5255,  5257,  5259,  5261,  5263,
    5265,  5267,  5269,  5271,  5273,  5275,  5277,  5279,  5281,  5283,
    5285,  5287,  5289,  5291,  5293,  5295,  5297,  5299,  5301,  5303,
    5305,  5307,  5309,  5311,  5313,  5317,  5319,  5320,  5322,  5325,
    5327,  5330,  5332,  5334,  5337,  5340,  5342,  5344,  5346,  5348,
    5350,  5352,  5355,  5359,  5361,  5364,  5366,  5370,  5372,  5376,
    5378,  5380,  5382,  5384,  5386,  5388,  5390,  5392,  5394,  5396,
    5398,  5400,  5402,  5404,  5406,  5408,  5410,  5412,  5414,  5416,
    5418,  5420,  5422,  5424,  5426,  5428,  5430,  5432,  5434,  5436,
    5438,  5440,  5442,  5444,  5446,  5448,  5450,  5452,  5454,  5456,
    5458,  5460,  5462,  5464,  5466,  5468,  5470,  5472,  5474,  5476,
    5478,  5480,  5482,  5484,  5486,  5488,  5490,  5492,  5494,  5496
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short yyrhs[] =
{
     418,     0,    -1,   419,    -1,    -1,   419,   420,    -1,   895,
     421,   422,   411,    -1,   895,   422,   411,    -1,   895,   792,
      -1,   801,    -1,   908,    -1,   388,    -1,   412,    -1,   413,
      -1,    97,   778,    -1,   618,    -1,   621,    -1,   434,    -1,
     500,    -1,   456,    -1,   426,    -1,   425,    -1,   626,    -1,
     455,    -1,   459,    -1,   624,    -1,   547,    -1,   452,    -1,
     460,    -1,   494,    -1,   524,    -1,   586,    -1,   623,    -1,
     620,    -1,   568,    -1,   431,    -1,   504,    -1,   532,    -1,
     436,    -1,   499,    -1,   469,    -1,   510,    -1,   423,    -1,
     614,    -1,   644,    -1,   526,    -1,   639,    -1,   525,    -1,
     588,    -1,   435,    -1,   537,    -1,   508,    -1,   603,    -1,
     538,    -1,   523,    -1,   427,    -1,   619,    -1,   632,    -1,
     543,    -1,   550,    -1,   562,    -1,   635,    -1,   605,    -1,
     613,    -1,   640,    -1,   604,    -1,   589,    -1,   581,    -1,
     583,    -1,   580,    -1,   592,    -1,   551,    -1,   595,    -1,
     647,    -1,   607,    -1,   542,    -1,   606,    -1,   643,    -1,
     625,    -1,   440,    -1,   450,    -1,   451,    -1,   612,    -1,
     858,    -1,   777,    -1,   790,    -1,   791,    -1,   857,    -1,
     834,    -1,   855,    -1,   835,    -1,   838,    -1,   843,    -1,
     866,    -1,   865,    -1,   844,    -1,   854,    -1,   867,    -1,
     868,    -1,   870,    -1,   871,    -1,   874,    -1,   876,    -1,
     134,   363,   775,   424,   428,    -1,   376,    -1,    -1,    87,
     363,   775,   428,    -1,    87,   363,   775,   376,   428,    -1,
      87,   363,   775,   319,   441,    -1,    87,   363,   775,   451,
      -1,   163,   363,   430,    -1,   428,   429,    -1,    -1,   279,
     767,    -1,   336,   768,    -1,   135,    -1,   252,    -1,   136,
      -1,   253,    -1,   202,   193,   430,    -1,   366,   360,   767,
      -1,   430,   414,   775,    -1,   775,    -1,   134,   193,   775,
     432,    -1,   134,   193,   775,   376,   432,    -1,   432,   433,
      -1,    -1,   363,   430,    -1,   336,   768,    -1,    87,   193,
     775,    83,   363,   430,    -1,    87,   193,   775,   163,   363,
     430,    -1,   163,   193,   775,    -1,   134,   310,   775,   437,
      98,   775,   438,    -1,   134,   310,   883,   438,    -1,   883,
      -1,    -1,   438,   439,    -1,    -1,   469,    -1,   550,    -1,
     612,    -1,   319,   441,    -1,   319,   235,   441,    -1,   319,
     317,   441,    -1,   883,   344,   442,    -1,   883,   415,   442,
      -1,   342,   381,   447,    -1,   347,   609,    -1,   317,   117,
      93,   347,   609,    -1,   245,   448,    -1,   317,    98,   449,
      -1,   317,    98,   150,    -1,   443,    -1,   150,    -1,   445,
      -1,   443,   414,   445,    -1,   292,   128,    -1,   316,    -1,
     446,    -1,   773,    -1,   883,    -1,   351,    -1,   178,    -1,
     267,    -1,   263,    -1,   773,    -1,   902,    -1,   705,   770,
     707,    -1,   705,   408,   768,   409,   770,   707,    -1,   150,
      -1,   235,    -1,   770,    -1,   150,    -1,    -1,   883,    -1,
     770,    -1,   322,   883,    -1,   322,   342,   381,    -1,   322,
     347,   222,   230,    -1,   322,   317,    98,    -1,   322,    86,
      -1,   300,   883,    -1,   300,   342,   381,    -1,   300,   347,
     222,   230,    -1,   300,   317,    98,    -1,   300,    86,    -1,
     319,   130,   453,   454,    -1,    86,    -1,   754,    -1,   153,
      -1,   199,    -1,   119,    -1,    87,   337,   678,    83,   594,
     474,    -1,    87,   337,   678,    87,   594,   883,   457,    -1,
      87,   337,   678,    87,   594,   883,   163,   255,   259,    -1,
      87,   337,   678,    87,   594,   883,   319,   255,   259,    -1,
      87,   337,   678,    87,   594,   883,   319,   330,   768,    -1,
      87,   337,   678,    87,   594,   883,   319,   333,   883,    -1,
      87,   337,   678,   163,   594,   883,   458,    -1,    87,   337,
     678,    83,   481,    -1,    87,   337,   678,   163,   129,   755,
     458,    -1,    87,   337,   678,   319,   377,   265,    -1,    87,
     337,   753,   134,   345,   337,    -1,    87,   337,   753,   277,
     344,   775,    -1,    87,   337,   753,   122,   267,   755,    -1,
     319,   150,   716,    -1,   163,   150,    -1,   111,    -1,   302,
      -1,    -1,   121,   755,    -1,   133,   465,   753,   466,   461,
     462,   467,   424,   463,    -1,   344,    -1,   187,    -1,   770,
      -1,   331,    -1,   332,    -1,   463,   464,    -1,    -1,   104,
      -1,   265,    -1,   156,   622,   770,    -1,   259,   622,   770,
      -1,   104,    -1,    -1,   376,   265,    -1,    -1,   468,   157,
     770,    -1,    -1,   364,    -1,    -1,   134,   470,   337,   753,
     408,   471,   409,   491,   492,   493,    -1,   134,   470,   337,
     753,   262,   753,   408,   471,   409,   492,   493,    -1,   340,
      -1,   338,    -1,   235,   340,    -1,   235,   338,    -1,   191,
     340,    -1,   191,   338,    -1,    -1,   472,    -1,    -1,   473,
      -1,   472,   414,   473,    -1,   474,    -1,   479,    -1,   481,
      -1,   883,   683,   475,    -1,   475,   476,    -1,    -1,   129,
     755,   477,    -1,   477,    -1,   478,    -1,   255,   259,    -1,
     259,    -1,   357,    -1,   287,   224,    -1,   118,   408,   716,
     409,    -1,   150,   717,    -1,   295,   753,   483,   486,   487,
      -1,   152,    -1,   255,   152,    -1,   207,   153,    -1,   207,
     199,    -1,   231,   753,   480,    -1,   203,   151,    -1,   172,
     151,    -1,    -1,   129,   755,   482,    -1,   482,    -1,   118,
     408,   716,   409,    -1,   357,   408,   484,   409,    -1,   287,
     224,   408,   484,   409,    -1,   184,   224,   408,   484,   409,
     295,   753,   483,   486,   487,   520,    -1,   408,   484,   409,
      -1,    -1,   484,   414,   485,    -1,   485,    -1,   883,    -1,
     238,   188,    -1,   238,   278,    -1,    -1,   488,    -1,   489,
      -1,   488,   489,    -1,   489,   488,    -1,    -1,   267,   155,
     490,    -1,   267,   361,   490,    -1,   251,    82,    -1,   302,
      -1,   111,    -1,   319,   150,    -1,   319,   259,    -1,   206,
     408,   752,   409,    -1,    -1,   376,   265,    -1,   377,   265,
      -1,    -1,   267,   127,   163,    -1,   267,   127,   155,   308,
      -1,   267,   127,   285,   308,    -1,    -1,    -1,   134,   470,
     337,   753,   496,    93,   495,   647,    -1,   408,   497,   409,
      -1,    -1,   497,   414,   498,    -1,   498,    -1,   883,    -1,
     134,   470,   315,   753,   501,    -1,    87,   315,   753,   501,
      -1,   501,   502,    -1,    -1,   109,   772,    -1,   143,    -1,
     251,   143,    -1,   204,   503,   772,    -1,   239,   772,    -1,
     241,   772,    -1,   251,   239,    -1,   251,   241,    -1,   328,
     424,   772,    -1,   301,   424,   772,    -1,   108,    -1,    -1,
     134,   505,   509,   226,   449,   194,   506,   507,    -1,   353,
      -1,    -1,   755,    -1,   740,    -1,   225,   770,    -1,    -1,
     163,   509,   226,   770,   458,    -1,   290,    -1,    -1,   134,
     349,   755,   511,   512,   267,   753,   514,   173,   291,   755,
     408,   517,   409,    -1,   134,   129,   349,   755,    84,   512,
     267,   753,   519,   520,   182,   164,   307,   173,   291,   761,
     408,   517,   409,    -1,   100,    -1,    84,    -1,   513,    -1,
     513,   271,   513,    -1,   513,   271,   513,   271,   513,    -1,
     212,    -1,   155,    -1,   361,    -1,   182,   515,   516,    -1,
      -1,   164,    -1,    -1,   307,    -1,   329,    -1,   518,    -1,
     517,   414,   518,    -1,    -1,   774,    -1,   883,    -1,    -1,
     187,   753,    -1,   521,    -1,   521,   522,    -1,   522,    -1,
     522,   521,    -1,   255,   152,    -1,   152,    -1,   207,   199,
      -1,   207,   153,    -1,   163,   349,   755,   267,   753,   458,
      -1,   134,    95,   755,   118,   408,   716,   409,   520,    -1,
     163,    95,   755,    -1,   134,    85,   761,   528,    -1,   134,
     269,   712,   528,    -1,   134,   354,   541,   528,    -1,   134,
     354,   541,    93,   527,    -1,   408,   681,   409,    -1,   408,
     529,   409,    -1,   530,    -1,   529,   414,   530,    -1,   886,
     395,   531,    -1,   886,    -1,   575,    -1,   715,    -1,   773,
      -1,   134,   269,   120,   541,   535,   182,   354,   683,   364,
     757,    93,   533,    -1,   534,    -1,   533,   414,   534,    -1,
     269,   768,   585,   536,    -1,   269,   768,   585,   408,   584,
     409,   536,    -1,   189,   768,   761,   570,    -1,   333,   683,
      -1,   150,    -1,    -1,   294,    -1,    -1,   163,   269,   120,
     541,   364,   757,   458,    -1,   163,   539,   540,   458,    -1,
     337,    -1,   315,    -1,   372,    -1,   205,    -1,   354,    -1,
     161,    -1,   131,    -1,   310,    -1,   541,    -1,   540,   414,
     541,    -1,   883,    -1,   740,    -1,   352,   654,   753,    -1,
     179,   544,   546,   755,   850,    -1,   179,   544,   755,   850,
      -1,   179,   546,   755,   850,    -1,   179,   755,   850,    -1,
     179,   544,   546,   755,    -1,   179,   544,   755,    -1,   179,
     546,   755,    -1,   179,   755,    -1,   244,   544,   546,   755,
      -1,   244,   755,    -1,   250,    -1,   288,    -1,   180,    -1,
     227,    -1,    80,   545,    -1,   297,   545,    -1,   545,    -1,
      86,    -1,   185,    -1,   185,   545,    -1,   185,    86,    -1,
      99,    -1,    99,   545,    -1,    99,    86,    -1,   769,    -1,
     202,    -1,   187,    -1,   126,   267,   548,   755,   220,   549,
      -1,   126,   267,    85,   761,   408,   582,   409,   220,   549,
      -1,   126,   267,   189,   761,   570,   220,   549,    -1,   126,
     267,   269,   712,   408,   584,   409,   220,   549,    -1,   126,
     267,   349,   755,   267,   541,   220,   549,    -1,   126,   267,
     309,   755,   267,   541,   220,   549,    -1,   126,   267,   309,
     755,   220,   549,    -1,   125,    -1,   144,    -1,   310,    -1,
     205,    -1,   315,    -1,   337,    -1,   161,    -1,   354,    -1,
     372,    -1,   770,    -1,   259,    -1,   192,   552,   267,   555,
     344,   556,   558,    -1,   304,   559,   552,   267,   555,   187,
     556,   458,    -1,    86,   289,    -1,    86,    -1,   553,    -1,
     554,    -1,   553,   414,   554,    -1,   314,    -1,   212,    -1,
     361,    -1,   155,    -1,   309,    -1,   295,    -1,   349,    -1,
     173,    -1,   362,    -1,   134,    -1,   340,    -1,   338,    -1,
     752,    -1,   337,   752,    -1,   189,   560,    -1,   144,   754,
      -1,   226,   754,    -1,   310,   754,    -1,   557,    -1,   556,
     414,   557,    -1,   883,    -1,   193,   883,    -1,   376,   192,
     270,    -1,    -1,   192,   270,   182,    -1,    -1,   561,    -1,
     560,   414,   561,    -1,   761,   570,    -1,   134,   563,   205,
     759,   267,   753,   564,   408,   565,   409,   680,    -1,   357,
      -1,    -1,   364,   757,    -1,    -1,   566,    -1,   565,   414,
     566,    -1,   758,   567,    -1,   761,   408,   720,   409,   567,
      -1,   408,   716,   409,   567,    -1,   541,    -1,   364,   541,
      -1,    -1,   134,   569,   189,   761,   570,   303,   575,   577,
     579,    -1,   271,   299,    -1,    -1,   408,   571,   409,    -1,
     408,   409,    -1,   572,    -1,   571,   414,   572,    -1,   573,
     576,    -1,   576,    -1,   202,    -1,   273,    -1,   209,    -1,
     770,    -1,   770,   414,   770,    -1,   576,    -1,   683,    -1,
     884,   741,   403,   354,    -1,   578,    -1,   577,   578,    -1,
      93,   574,    -1,   226,   449,    -1,   200,    -1,   327,    -1,
     373,    -1,   110,   267,   259,   210,    -1,   303,   259,   267,
     259,   210,    -1,   334,    -1,   176,   313,   154,    -1,   176,
     313,   219,    -1,   313,   154,    -1,   313,   219,    -1,   376,
     528,    -1,    -1,   163,   189,   761,   570,   458,    -1,   163,
      85,   761,   408,   582,   409,   458,    -1,   683,    -1,   401,
      -1,   163,   269,   712,   408,   584,   409,   458,    -1,   683,
      -1,   683,   414,   683,    -1,   254,   414,   683,    -1,   683,
     414,   254,    -1,   712,    -1,   883,   410,   585,    -1,   134,
     113,   408,   683,    93,   683,   409,   376,   189,   561,   587,
      -1,   134,   113,   408,   683,    93,   683,   409,   377,   189,
     587,    -1,    93,    96,    -1,    -1,   163,   113,   408,   683,
      93,   683,   409,   458,    -1,   296,   590,   753,   591,    -1,
     296,   144,   755,   591,    -1,   205,    -1,   337,    -1,   183,
      -1,    -1,    87,    85,   761,   408,   582,   409,   298,   344,
     755,    -1,    87,   131,   541,   298,   344,   755,    -1,    87,
     144,   756,   298,   344,   756,    -1,    87,   189,   761,   570,
     298,   344,   755,    -1,    87,   193,   775,   298,   344,   775,
      -1,    87,   226,   755,   298,   344,   755,    -1,    87,   269,
     120,   541,   364,   757,   298,   344,   755,    -1,    87,   310,
     755,   298,   344,   755,    -1,    87,   337,   678,   298,   594,
     593,   344,   755,    -1,    87,   349,   755,   267,   678,   298,
     344,   755,    -1,    87,   363,   775,   298,   344,   775,    -1,
     755,    -1,    -1,   125,    -1,    -1,    -1,   134,   569,   309,
     755,    93,   596,   267,   601,   344,   753,   680,   160,   602,
     597,    -1,   256,    -1,   599,    -1,   408,   598,   409,    -1,
     598,   411,   600,    -1,   600,    -1,   647,    -1,   635,    -1,
     643,    -1,   639,    -1,   604,    -1,   599,    -1,    -1,   314,
      -1,   361,    -1,   155,    -1,   212,    -1,   213,    -1,    -1,
     163,   309,   755,   267,   753,   458,    -1,   257,   753,    -1,
     233,   753,    -1,   359,   753,    -1,   359,   401,    -1,    79,
     608,    -1,   101,   608,    -1,   328,   347,   610,    -1,   127,
     608,    -1,   168,   608,    -1,   306,   608,    -1,   378,    -1,
     347,    -1,    -1,   222,   230,   444,    -1,   611,    -1,   222,
     230,   444,   611,    -1,   611,   222,   230,   444,    -1,   609,
      -1,    -1,   292,   268,    -1,   292,   379,    -1,   134,   569,
     372,   753,   483,    93,   647,    -1,   234,   760,    -1,   134,
     144,   756,   376,   615,    -1,   134,   144,   756,    -1,   616,
      -1,   615,   616,    -1,   236,   617,   770,    -1,   236,   617,
     150,    -1,   339,   617,   755,    -1,   339,   617,   150,    -1,
     166,   617,   771,    -1,   166,   617,   150,    -1,   277,   617,
     755,    -1,   277,   617,   150,    -1,   395,    -1,    -1,    87,
     144,   756,   319,   441,    -1,    87,   144,   756,   451,    -1,
     163,   144,   756,    -1,   134,   161,   541,   622,   683,   475,
      -1,    87,   161,   541,   457,    -1,    87,   161,   541,   163,
     255,   259,    -1,    87,   161,   541,   319,   255,   259,    -1,
      87,   161,   541,    83,   481,    -1,    87,   161,   541,   163,
     129,   755,   458,    -1,    87,   161,   541,   277,   344,   775,
      -1,    93,    -1,    -1,   134,   535,   131,   541,   182,   770,
     344,   770,   187,   541,    -1,   122,   759,   267,   753,    -1,
     122,   753,    -1,   122,    -1,   365,   629,   630,   628,    -1,
     365,   629,   630,   628,   753,    -1,   365,   629,   630,   628,
     626,    -1,   627,   628,    -1,   627,   628,   753,   631,    -1,
      89,    -1,    88,    -1,   370,    -1,    -1,   188,    -1,    -1,
     186,    -1,    -1,   408,   754,   409,    -1,    -1,   175,   634,
     628,   633,    -1,   647,    -1,   635,    -1,   643,    -1,   639,
      -1,   644,    -1,   627,    -1,    -1,   212,   218,   753,   636,
      -1,   367,   408,   749,   409,    -1,   150,   367,    -1,   647,
      -1,   408,   637,   409,   367,   408,   749,   409,    -1,   408,
     637,   409,   647,    -1,   637,   414,   638,    -1,   638,    -1,
     883,   719,    -1,   155,   187,   678,   680,    -1,   237,   654,
     752,   641,    -1,   202,   642,   242,    -1,    -1,    81,   321,
      -1,   307,   321,    -1,   307,   171,    -1,   321,   361,   171,
      -1,   321,    -1,   321,   307,   171,    -1,   171,    -1,    81,
     171,    -1,   361,   678,   319,   745,   670,   680,    -1,   149,
     755,   645,   142,   646,   182,   647,    -1,    -1,   645,   104,
      -1,   645,   211,    -1,   645,   311,    -1,   645,   251,   311,
      -1,    -1,   376,   196,    -1,   377,   196,    -1,   649,    -1,
     648,    -1,   408,   649,   409,    -1,   408,   648,   409,    -1,
     651,    -1,   650,   658,    -1,   650,   657,   667,   662,    -1,
     650,   657,   661,   668,    -1,   651,    -1,   648,    -1,   314,
     656,   743,   652,   670,   680,   665,   666,    -1,   650,   356,
     655,   650,    -1,   650,   216,   655,   650,    -1,   650,   170,
     655,   650,    -1,   218,   653,    -1,   850,    -1,    -1,   340,
     654,   753,    -1,   338,   654,   753,    -1,   235,   340,   654,
     753,    -1,   235,   338,   654,   753,    -1,   191,   340,   654,
     753,    -1,   191,   338,   654,   753,    -1,   337,   753,    -1,
     753,    -1,   337,    -1,    -1,    86,    -1,    -1,   159,    -1,
     159,   267,   408,   720,   409,    -1,    86,    -1,    -1,   658,
      -1,    -1,   272,   108,   659,    -1,   660,    -1,   659,   414,
     660,    -1,   716,   364,   715,    -1,   716,    94,    -1,   716,
     158,    -1,   716,    -1,   232,   663,   264,   664,    -1,   264,
     664,   232,   663,    -1,   232,   663,    -1,   264,   664,    -1,
     232,   663,   414,   664,    -1,   661,    -1,    -1,   716,    -1,
      86,    -1,   716,    -1,   193,   108,   720,    -1,    -1,   195,
     716,    -1,    -1,   182,   361,   669,    -1,   182,   292,   268,
      -1,   667,    -1,    -1,   262,   754,    -1,    -1,   187,   671,
      -1,    -1,   671,   414,   672,    -1,   672,    -1,   678,    -1,
     678,   674,    -1,   679,    -1,   679,   674,    -1,   679,    93,
     408,   681,   409,    -1,   679,    93,   883,   408,   681,   409,
      -1,   679,   883,   408,   681,   409,    -1,   648,    -1,   648,
     674,    -1,   673,    -1,   408,   673,   409,   674,    -1,   408,
     673,   409,    -1,   672,   137,   223,   672,    -1,   672,   382,
     672,    -1,   672,   675,   223,   672,   677,    -1,   672,   223,
     672,   677,    -1,   672,   247,   675,   223,   672,    -1,   672,
     247,   223,   672,    -1,    93,   883,   408,   754,   409,    -1,
      93,   883,    -1,   883,   408,   754,   409,    -1,   883,    -1,
     188,   676,    -1,   229,   676,    -1,   305,   676,    -1,   208,
      -1,   274,    -1,    -1,   364,   408,   754,   409,    -1,   267,
     716,    -1,   753,    -1,   753,   401,    -1,   268,   753,    -1,
     268,   408,   753,   409,    -1,   761,   408,   409,    -1,   761,
     408,   720,   409,    -1,   375,   716,    -1,    -1,   682,    -1,
     681,   414,   682,    -1,   883,   683,    -1,   686,   684,    -1,
     320,   686,   684,    -1,   686,    92,   406,   768,   407,    -1,
     320,   686,    92,   406,   768,   407,    -1,   406,   407,   684,
      -1,   406,   685,   407,   684,    -1,    -1,   768,    -1,   408,
     685,   409,    -1,   685,   399,   685,    -1,   685,   400,   685,
      -1,   685,   401,   685,    -1,   685,   402,   685,    -1,   685,
     403,   685,    -1,   767,    -1,   883,    -1,   688,    -1,   704,
      -1,   689,    -1,   693,    -1,   697,    -1,   705,   707,    -1,
     705,   408,   768,   409,   707,    -1,   884,   741,    -1,   688,
      -1,   704,    -1,   689,    -1,   694,    -1,   698,    -1,   884,
      -1,   214,    -1,   215,    -1,   325,    -1,   103,    -1,   293,
      -1,   181,   690,    -1,   162,   284,    -1,   148,   692,    -1,
     147,   692,    -1,   261,   691,    -1,   106,    -1,   408,   768,
     409,    -1,    -1,   408,   768,   414,   768,   409,    -1,   408,
     768,   409,    -1,    -1,   408,   768,   414,   768,   409,    -1,
     408,   768,   409,    -1,    -1,   695,    -1,   696,    -1,   695,
      -1,   696,    -1,   105,   702,   408,   768,   409,    -1,   105,
     702,    -1,   699,    -1,   700,    -1,   699,    -1,   700,    -1,
     701,   408,   768,   409,   703,    -1,   701,   703,    -1,   116,
     702,    -1,   115,   702,    -1,   368,    -1,   246,   116,   702,
      -1,   246,   115,   702,    -1,   248,   702,    -1,   369,    -1,
      -1,   116,   319,   883,    -1,    -1,   343,   408,   768,   409,
     706,    -1,   343,   706,    -1,   342,   408,   768,   409,   706,
      -1,   342,   706,    -1,   217,    -1,   376,   342,   381,    -1,
     377,   342,   381,    -1,    -1,   380,    -1,   243,    -1,   145,
      -1,   197,    -1,   240,    -1,   312,    -1,   380,   344,   243,
      -1,   145,   344,   197,    -1,   145,   344,   240,    -1,   145,
     344,   312,    -1,   197,   344,   240,    -1,   240,   344,   312,
      -1,   197,   344,   312,    -1,    -1,   709,   202,   648,    -1,
     709,   255,   202,   648,    -1,   709,   715,   711,   648,    -1,
     709,   715,   648,    -1,   709,   715,   709,    -1,   709,   220,
     259,    -1,   709,   220,   255,   259,    -1,   709,   275,   709,
      -1,   709,   220,   159,   187,   709,    -1,   307,   408,   710,
     409,    -1,   307,   408,   716,   409,    -1,   307,   408,   409,
      -1,   408,   710,   409,    -1,   720,   414,   716,    -1,    91,
      -1,   326,    -1,    86,    -1,   385,    -1,   713,    -1,   399,
      -1,   400,    -1,   401,    -1,   403,    -1,   404,    -1,   402,
      -1,   396,    -1,   397,    -1,   395,    -1,   385,    -1,   269,
     408,   585,   409,    -1,   712,    -1,   269,   408,   585,   409,
      -1,   718,    -1,   716,    78,   683,    -1,   716,    97,   342,
     381,   718,    -1,   399,   716,    -1,   400,   716,    -1,   403,
     716,    -1,   404,   716,    -1,   716,   403,    -1,   716,   404,
      -1,   716,   399,   716,    -1,   716,   400,   716,    -1,   716,
     401,   716,    -1,   716,   402,   716,    -1,   716,   403,   716,
      -1,   716,   404,   716,    -1,   716,   396,   716,    -1,   716,
     397,   716,    -1,   716,   395,   716,    -1,   716,   714,   716,
      -1,   714,   716,    -1,   716,   714,    -1,   716,    90,   716,
      -1,   716,   271,   716,    -1,   255,   716,    -1,   716,   231,
     716,    -1,   716,   231,   716,   169,   716,    -1,   716,   255,
     231,   716,    -1,   716,   255,   231,   716,   169,   716,    -1,
     716,   198,   716,    -1,   716,   198,   716,   169,   716,    -1,
     716,   255,   198,   716,    -1,   716,   255,   198,   716,   169,
     716,    -1,   716,   323,   344,   716,    -1,   716,   323,   344,
     716,   169,   716,    -1,   716,   255,   323,   344,   716,    -1,
     716,   255,   323,   344,   716,   169,   716,    -1,   716,   221,
      -1,   716,   220,   259,    -1,   716,   258,    -1,   716,   220,
     255,   259,    -1,   716,   220,   351,    -1,   716,   220,   255,
     351,    -1,   716,   220,   178,    -1,   716,   220,   255,   178,
      -1,   716,   220,   358,    -1,   716,   220,   255,   358,    -1,
     716,   220,   159,   187,   716,    -1,   716,   220,   262,   408,
     722,   409,    -1,   716,   220,   255,   262,   408,   722,   409,
      -1,   716,   102,   717,    90,   717,    -1,   716,   255,   102,
     717,    90,   717,    -1,   716,   202,   733,    -1,   716,   255,
     202,   733,    -1,   716,   715,   711,   648,    -1,   716,   715,
     711,   408,   716,   409,    -1,   357,   648,    -1,   708,    -1,
     718,    -1,   717,    78,   683,    -1,   400,   717,    -1,   403,
     717,    -1,   404,   717,    -1,   717,   403,    -1,   717,   404,
      -1,   717,   399,   717,    -1,   717,   400,   717,    -1,   717,
     401,   717,    -1,   717,   402,   717,    -1,   717,   403,   717,
      -1,   717,   404,   717,    -1,   717,   396,   717,    -1,   717,
     397,   717,    -1,   717,   395,   717,    -1,   717,   385,   717,
      -1,   714,   717,    -1,   717,   714,    -1,   717,   220,   159,
     187,   717,    -1,   717,   220,   262,   408,   717,   409,    -1,
     717,   220,   255,   262,   408,   717,   409,    -1,   739,    -1,
     762,    -1,   393,   741,   719,    -1,   408,   716,   409,   741,
     719,    -1,   408,   716,   409,   719,    -1,   734,    -1,   761,
     408,   409,    -1,   761,   408,   720,   409,    -1,   761,   408,
      86,   720,   409,    -1,   761,   408,   159,   720,   409,    -1,
     761,   408,   401,   409,    -1,   138,    -1,   139,   742,    -1,
     139,   408,   768,   409,    -1,   140,   742,    -1,   140,   408,
     768,   409,    -1,   141,   742,    -1,   318,   742,    -1,   363,
     742,    -1,   113,   408,   716,    93,   683,   409,    -1,   177,
     408,   721,   409,    -1,   276,   408,   726,   409,    -1,   283,
     408,   728,   409,    -1,   335,   408,   729,   409,    -1,   348,
     408,   716,    93,   683,   409,    -1,   350,   408,   107,   732,
     409,    -1,   350,   408,   228,   732,   409,    -1,   350,   408,
     346,   732,   409,    -1,   350,   408,   732,   409,    -1,   132,
     408,   716,   364,   541,   409,    -1,   132,   408,   720,   409,
      -1,   648,    -1,   174,   648,    -1,    92,   648,    -1,    92,
     724,    -1,   406,   716,   407,   719,    -1,   406,   716,   416,
     716,   407,   719,    -1,    -1,   716,    -1,   720,   414,   716,
      -1,   725,   187,   716,    -1,    -1,   722,   414,   683,    -1,
     683,    -1,   724,    -1,   723,   414,   724,    -1,   406,   720,
     407,    -1,   406,   723,   407,    -1,   902,    -1,   380,    -1,
     243,    -1,   145,    -1,   197,    -1,   240,    -1,   312,    -1,
     770,    -1,   716,   727,   730,   731,    -1,   716,   727,   730,
      -1,   282,   716,    -1,   717,   202,   717,    -1,    -1,   716,
     730,   731,    -1,   716,   731,   730,    -1,   716,   730,    -1,
     716,   731,    -1,   720,    -1,    -1,   187,   716,    -1,   182,
     716,    -1,   716,   187,   720,    -1,   187,   720,    -1,   720,
      -1,   648,    -1,   408,   720,   409,    -1,   112,   738,   735,
     737,   168,    -1,   260,   408,   716,   414,   716,   409,    -1,
     123,   408,   720,   409,    -1,   735,   736,    -1,   736,    -1,
     374,   716,   341,   716,    -1,   165,   716,    -1,    -1,   716,
      -1,    -1,   751,   719,    -1,   740,   719,    -1,   751,   741,
      -1,   410,   758,    -1,   410,   401,    -1,   410,   758,   741,
      -1,   408,   409,    -1,    -1,   743,   414,   744,    -1,   744,
      -1,   716,    93,   886,    -1,   716,    -1,   401,    -1,   745,
     414,   748,    -1,   408,   746,   409,   395,   408,   747,   409,
      -1,   748,    -1,   883,   719,    -1,   883,   719,   414,   746,
      -1,   716,    -1,   716,   414,   747,    -1,   883,   719,   395,
     716,    -1,   883,   719,   395,   150,    -1,   749,   414,   750,
      -1,   750,    -1,   744,    -1,   150,    -1,   776,    -1,   883,
      -1,   753,    -1,   752,   414,   753,    -1,   751,    -1,   740,
      -1,   755,    -1,   754,   414,   755,    -1,   883,    -1,   883,
      -1,   883,    -1,   883,    -1,   883,    -1,   770,    -1,   885,
      -1,   740,    -1,   774,    -1,   687,   770,    -1,   705,   770,
     707,    -1,   705,   408,   768,   409,   770,   707,    -1,   393,
     719,    -1,   351,    -1,   178,    -1,   259,    -1,   898,    -1,
     392,    -1,   394,    -1,   390,    -1,   391,    -1,   384,    -1,
     763,    -1,   899,    -1,   768,    -1,   400,   768,    -1,   767,
      -1,   899,    -1,   763,    -1,   767,    -1,   899,    -1,   764,
      -1,   763,    -1,   400,   764,    -1,   400,   763,    -1,   899,
      -1,   767,    -1,   772,    -1,   767,    -1,   764,    -1,   763,
      -1,   765,    -1,   766,    -1,   899,    -1,   883,    -1,   266,
      -1,   249,    -1,     9,   344,   778,   784,   785,    -1,     9,
     344,   150,    -1,     9,   786,    -1,   144,   778,    -1,   756,
     781,   783,    -1,   779,   416,   780,   783,   402,   756,   789,
      -1,   770,    -1,   902,   901,    -1,   385,   782,    -1,   780,
      -1,    -1,   883,    -1,   883,   410,   782,    -1,   389,    -1,
     416,   768,    -1,    -1,    93,   778,    -1,    -1,   363,   786,
      -1,    -1,   787,    -1,   787,   402,   787,    -1,   787,    25,
     108,   787,    -1,   787,   364,   787,    -1,   775,    -1,   770,
      -1,   901,    -1,   385,   883,    -1,    -1,   149,   755,   645,
     142,   646,   182,   842,    -1,   146,   286,   842,    -1,   146,
     842,    -1,   793,    -1,   808,    -1,   794,    -1,    -1,   813,
     800,   795,   830,   411,    -1,    -1,   800,   796,   830,   411,
      -1,   820,   411,    -1,   772,    -1,   414,   772,    -1,    -1,
     707,    -1,   380,   344,   240,    -1,   380,   344,   312,    -1,
     145,   344,   145,    -1,   243,   344,   243,    -1,   816,    -1,
     162,    -1,   887,   799,    -1,   824,    -1,    -1,   803,   802,
     805,   804,    -1,   895,   101,   149,    40,   411,    -1,   895,
     168,   149,    40,   411,    -1,    -1,   806,    -1,   810,    -1,
     808,    -1,   806,   810,    -1,   806,   808,    -1,   810,    -1,
     807,   810,    -1,    -1,    77,   809,   817,   833,   887,   684,
     411,    -1,    -1,   813,   817,   811,   830,   411,    -1,    -1,
     817,   812,   830,   411,    -1,   820,   411,    -1,   814,   815,
      -1,   814,    -1,   815,    -1,    63,    -1,    74,    -1,    72,
      -1,    57,    -1,    58,    -1,    76,    -1,   826,    -1,   822,
      -1,   818,    -1,   887,   408,   797,   798,   409,    -1,   816,
      -1,   888,   799,    -1,   824,    -1,    20,   882,   819,    -1,
      20,   819,    -1,    20,   882,    -1,   412,   906,   413,    -1,
      -1,   824,   821,   412,   807,   413,    -1,   820,    -1,    -1,
     825,   823,   412,   807,   413,    -1,    49,   882,    -1,   356,
     882,    -1,    49,    -1,   356,    -1,   827,    -1,   829,   828,
      -1,    50,    41,    -1,    50,    41,   214,    -1,    50,    -1,
      50,   214,    -1,    50,    29,    -1,    50,    29,   214,    -1,
      50,    29,    29,    -1,    50,    29,    29,   214,    -1,    50,
     115,    -1,    41,    -1,    41,   214,    -1,   214,    -1,    29,
      -1,    29,   214,    -1,    29,    29,    -1,    29,    29,   214,
      -1,     5,    -1,   115,    -1,    42,    -1,    -1,   831,    -1,
     830,   414,   831,    -1,   833,   887,   684,   832,    -1,    -1,
     395,   907,    -1,    -1,   401,    -1,   401,   401,    -1,   149,
     329,   902,    -1,    19,   836,    -1,   837,    -1,    13,    -1,
      86,    -1,    -1,   778,    -1,   150,    -1,   173,   199,   841,
      -1,    -1,   173,   842,   839,   840,    -1,   846,   851,    -1,
     851,   846,    -1,   846,    -1,   851,    -1,    -1,   788,    -1,
     386,    -1,   755,    -1,   788,    -1,    22,   755,    -1,    33,
     755,   845,    -1,    -1,   846,    -1,   364,   852,    -1,   364,
     849,    18,   903,    -1,   218,   849,    18,   903,    -1,    -1,
      43,    -1,   851,    -1,   847,    -1,   218,   894,    -1,   848,
      -1,   853,    -1,   853,   414,   852,    -1,   773,    -1,   898,
      -1,   286,   842,   187,   841,    -1,    17,   210,   755,   847,
      -1,    17,   856,   755,   847,    -1,    17,   856,   755,   848,
      -1,    34,    -1,    -1,   146,    18,   903,    -1,     3,    18,
     903,    -1,   901,   395,   860,    -1,    12,    -1,   901,   395,
     862,    -1,     8,    -1,    14,    -1,    15,    -1,    16,    -1,
      26,    -1,    27,    -1,    28,    -1,    30,    -1,    31,    -1,
      32,    -1,   284,    -1,    37,    -1,    38,    -1,    39,    -1,
     354,    -1,   859,    -1,   863,   414,   859,    -1,   861,    -1,
     864,   414,   861,    -1,   190,    18,   903,   863,    -1,   190,
      18,   903,    51,   901,   864,    -1,   190,    18,   903,    51,
     763,   864,    -1,   607,    35,    -1,   319,     4,   395,   869,
      -1,   319,     4,   344,   869,    -1,   267,    -1,   263,    -1,
     319,    10,   344,   837,    -1,   319,    10,   395,   837,    -1,
     319,    10,   837,    -1,    -1,   354,   872,   886,   220,   817,
     684,   873,    -1,    36,    -1,    -1,    -1,    52,   875,   886,
     220,   817,   684,   873,    -1,    53,    44,   877,    -1,    53,
     255,    21,   877,    -1,    53,    46,   877,    -1,    11,    -1,
      45,    -1,    48,    -1,    24,   755,    -1,    23,   344,   755,
      -1,   160,   755,   408,   896,   409,    -1,   160,     6,    -1,
       7,   755,   408,   896,   409,    -1,     7,   755,    -1,   879,
      -1,   880,    -1,     6,    -1,     7,    -1,     8,    -1,    11,
      -1,    12,    -1,    14,    -1,    15,    -1,    16,    -1,    21,
      -1,    23,    -1,    24,    -1,    25,    -1,    26,    -1,    27,
      -1,    28,    -1,    30,    -1,    31,    -1,    32,    -1,    35,
      -1,    37,    -1,    38,    -1,    39,    -1,    40,    -1,    44,
      -1,    45,    -1,    46,    -1,    48,    -1,    51,    -1,     9,
      -1,    17,    -1,    19,    -1,    33,    -1,    52,    -1,    53,
      -1,     5,    -1,    29,    -1,    34,    -1,    41,    -1,    49,
      -1,    42,    -1,    50,    -1,   886,    -1,   902,    -1,   890,
      -1,   891,    -1,   878,    -1,   889,    -1,   115,    -1,   902,
      -1,   890,    -1,   878,    -1,   881,    -1,   889,    -1,   902,
      -1,   890,    -1,   892,    -1,   878,    -1,   889,    -1,   888,
      -1,   881,    -1,   115,    -1,   210,    -1,   214,    -1,   356,
      -1,   889,    -1,   902,    -1,   891,    -1,   892,    -1,   879,
      -1,   887,    -1,   890,    -1,   893,    -1,   880,    -1,    57,
      -1,    58,    -1,    63,    -1,    72,    -1,    74,    -1,    77,
      -1,    76,    -1,    79,    -1,    80,    -1,    81,    -1,    82,
      -1,    83,    -1,    84,    -1,    85,    -1,    87,    -1,    95,
      -1,    96,    -1,    97,    -1,    99,    -1,   100,    -1,   101,
      -1,   108,    -1,   109,    -1,   111,    -1,   114,    -1,   117,
      -1,   119,    -1,   120,    -1,   121,    -1,   122,    -1,   126,
      -1,   127,    -1,   128,    -1,   130,    -1,   131,    -1,   133,
      -1,   135,    -1,   136,    -1,   142,    -1,   143,    -1,   144,
      -1,   145,    -1,   146,    -1,   149,    -1,   151,    -1,   153,
      -1,   155,    -1,   156,    -1,   157,    -1,   161,    -1,   162,
      -1,   163,    -1,   164,    -1,   166,    -1,   167,    -1,   169,
      -1,   172,    -1,   171,    -1,   173,    -1,   175,    -1,   179,
      -1,   180,    -1,   183,    -1,   185,    -1,   189,    -1,   191,
      -1,   194,    -1,   196,    -1,   197,    -1,   199,    -1,   200,
      -1,   201,    -1,   203,    -1,   204,    -1,   205,    -1,   206,
      -1,   209,    -1,   211,    -1,   212,    -1,   213,    -1,   222,
      -1,   224,    -1,   225,    -1,   226,    -1,   227,    -1,   230,
      -1,   233,    -1,   234,    -1,   235,    -1,   236,    -1,   237,
      -1,   238,    -1,   239,    -1,   240,    -1,   241,    -1,   242,
      -1,   243,    -1,   244,    -1,   245,    -1,   246,    -1,   250,
      -1,   251,    -1,   252,    -1,   253,    -1,   256,    -1,   257,
      -1,   262,    -1,   265,    -1,   269,    -1,   270,    -1,   273,
      -1,   277,    -1,   278,    -1,   279,    -1,   280,    -1,   281,
      -1,   284,    -1,   286,    -1,   285,    -1,   288,    -1,   289,
      -1,   290,    -1,   291,    -1,   292,    -1,   294,    -1,   296,
      -1,   297,    -1,   298,    -1,   299,    -1,   300,    -1,   301,
      -1,   302,    -1,   303,    -1,   304,    -1,   306,    -1,   308,
      -1,   309,    -1,   310,    -1,   311,    -1,   312,    -1,   315,
      -1,   316,    -1,   317,    -1,   319,    -1,   321,    -1,   322,
      -1,   324,    -1,   327,    -1,   328,    -1,   329,    -1,   330,
      -1,   331,    -1,   332,    -1,   333,    -1,   334,    -1,   336,
      -1,   338,    -1,   339,    -1,   340,    -1,   345,    -1,   347,
      -1,   349,    -1,   352,    -1,   353,    -1,   354,    -1,   355,
      -1,   358,    -1,   359,    -1,   360,    -1,   361,    -1,   362,
      -1,   365,    -1,   366,    -1,   367,    -1,   369,    -1,   371,
      -1,   372,    -1,   376,    -1,   377,    -1,   378,    -1,   379,
      -1,   380,    -1,   381,    -1,   103,    -1,   105,    -1,   116,
      -1,   123,    -1,   132,    -1,   147,    -1,   148,    -1,   174,
      -1,   177,    -1,   181,    -1,   215,    -1,   217,    -1,   248,
      -1,   254,    -1,   260,    -1,   261,    -1,   283,    -1,   293,
      -1,   307,    -1,   320,    -1,   325,    -1,   335,    -1,   342,
      -1,   343,    -1,   348,    -1,   350,    -1,   368,    -1,    98,
      -1,   102,    -1,   104,    -1,   137,    -1,   186,    -1,   188,
      -1,   198,    -1,   202,    -1,   208,    -1,   220,    -1,   221,
      -1,   223,    -1,   229,    -1,   231,    -1,   247,    -1,   258,
      -1,   274,    -1,   275,    -1,   305,    -1,   323,    -1,   370,
      -1,    86,    -1,    88,    -1,    89,    -1,    90,    -1,    91,
      -1,    92,    -1,    93,    -1,    94,    -1,   107,    -1,   112,
      -1,   113,    -1,   118,    -1,   124,    -1,   125,    -1,   129,
      -1,   134,    -1,   138,    -1,   139,    -1,   140,    -1,   141,
      -1,   150,    -1,   152,    -1,   158,    -1,   159,    -1,   160,
      -1,   165,    -1,   168,    -1,   170,    -1,   178,    -1,   182,
      -1,   184,    -1,   187,    -1,   192,    -1,   193,    -1,   195,
      -1,   207,    -1,   216,    -1,   218,    -1,   228,    -1,   232,
      -1,   249,    -1,   255,    -1,   259,    -1,   263,    -1,   264,
      -1,   266,    -1,   267,    -1,   268,    -1,   271,    -1,   272,
      -1,   287,    -1,   295,    -1,   314,    -1,   318,    -1,   326,
      -1,   337,    -1,   341,    -1,   344,    -1,   346,    -1,   351,
      -1,   357,    -1,   363,    -1,   364,    -1,   374,    -1,   375,
      -1,   897,    -1,   894,   414,   897,    -1,    47,    -1,    -1,
     906,    -1,   901,   900,    -1,   901,    -1,   901,   900,    -1,
     901,    -1,   901,    -1,    26,   901,    -1,    26,   755,    -1,
     387,    -1,   383,    -1,   386,    -1,   755,    -1,   788,    -1,
     909,    -1,   408,   409,    -1,   408,   905,   409,    -1,   904,
      -1,   905,   904,    -1,   907,    -1,   906,   414,   907,    -1,
     905,    -1,   412,   906,   413,    -1,   909,    -1,   408,    -1,
     409,    -1,   414,    -1,   411,    -1,   383,    -1,   386,    -1,
     763,    -1,   764,    -1,   767,    -1,   401,    -1,   399,    -1,
     400,    -1,   402,    -1,   403,    -1,   259,    -1,    54,    -1,
      55,    -1,    56,    -1,    57,    -1,    58,    -1,    59,    -1,
      60,    -1,    61,    -1,    62,    -1,    63,    -1,    64,    -1,
      65,    -1,    67,    -1,    66,    -1,    68,    -1,    69,    -1,
      70,    -1,    71,    -1,    72,    -1,    73,    -1,    74,    -1,
      75,    -1,    77,    -1,    76,    -1,     5,    -1,    20,    -1,
     197,    -1,   214,    -1,    29,    -1,   240,    -1,   243,    -1,
     312,    -1,    41,    -1,    42,    -1,    49,    -1,    50,    -1,
     380,    -1,   115,    -1,   181,    -1,   344,    -1,   356,    -1,
     368,    -1,   406,    -1,   407,    -1,   395,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,   560,   560,   562,   563,   566,   567,   568,   574,   575,
     576,   577,   578,   581,   593,   594,   595,   596,   597,   598,
     599,   600,   601,   602,   624,   625,   626,   627,   628,   629,
     630,   631,   632,   633,   634,   635,   636,   637,   638,   639,
     640,   641,   642,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   654,   655,   656,   657,   659,   660,   661,
     662,   663,   664,   665,   666,   668,   669,   670,   671,   672,
     673,   674,   675,   676,   682,   683,   684,   685,   686,   687,
     688,   689,   690,   696,   706,   710,   718,   726,   730,   741,
     751,   755,   762,   769,   775,   782,   791,   792,   798,   807,
     816,   823,   844,   848,   849,   860,   862,   866,   868,   878,
     885,   886,   889,   891,   893,   895,   897,   899,   901,   903,
     907,   909,   919,   921,   928,   929,   932,   934,   945,   947,
     957,   968,   970,   974,   975,   978,   979,   986,   987,   988,
    1001,  1003,  1005,  1009,  1011,  1013,  1015,  1017,  1019,  1021,
    1023,  1027,  1029,  1033,  1035,  1039,  1040,  1043,  1044,  1045,
    1048,  1049,  1050,  1051,  1061,  1062,  1063,  1065,  1067,  1069,
    1073,  1074,  1075,  1078,  1079,  1082,  1084,  1086,  1088,  1090,
    1094,  1096,  1098,  1100,  1102,  1106,  1110,  1112,  1116,  1117,
    1123,  1135,  1138,  1141,  1144,  1147,  1150,  1153,  1156,  1159,
    1162,  1165,  1168,  1171,  1176,  1177,  1180,  1181,  1182,  1192,
    1206,  1211,  1212,  1220,  1221,  1222,  1225,  1226,  1229,  1230,
    1231,  1233,  1237,  1238,  1241,  1242,  1249,  1252,  1255,  1256,
    1266,  1269,  1279,  1280,  1281,  1282,  1283,  1284,  1285,  1289,
    1292,  1294,  1296,  1300,  1301,  1302,  1305,  1311,  1312,  1315,
    1317,  1318,  1332,  1334,  1336,  1338,  1340,  1342,  1344,  1359,
    1360,  1361,  1362,  1365,  1372,  1373,  1374,  1381,  1383,  1387,
    1389,  1391,  1393,  1398,  1399,  1402,  1404,  1408,  1411,  1413,
    1419,  1422,  1423,  1424,  1425,  1426,  1429,  1433,  1437,  1438,
    1439,  1440,  1441,  1444,  1447,  1450,  1451,  1452,  1455,  1456,
    1457,  1458,  1468,  1467,  1478,  1481,  1484,  1486,  1490,  1501,
    1505,  1509,  1510,  1513,  1515,  1517,  1519,  1521,  1523,  1525,
    1527,  1529,  1531,  1535,  1536,  1547,  1552,  1553,  1560,  1562,
    1566,  1569,  1572,  1576,  1577,  1588,  1593,  1601,  1602,  1605,
    1607,  1609,  1613,  1614,  1615,  1618,  1621,  1624,  1625,  1628,
    1629,  1632,  1634,  1637,  1640,  1641,  1644,  1645,  1648,  1649,
    1656,  1657,  1666,  1668,  1672,  1674,  1678,  1689,  1697,  1712,
    1714,  1716,  1718,  1722,  1726,  1730,  1731,  1734,  1735,  1739,
    1740,  1741,  1744,  1751,  1752,  1755,  1757,  1759,  1761,  1765,
    1766,  1769,  1770,  1773,  1785,  1789,  1790,  1791,  1792,  1793,
    1794,  1795,  1796,  1799,  1801,  1805,  1807,  1816,  1831,  1836,
    1841,  1846,  1851,  1856,  1861,  1866,  1871,  1873,  1877,  1878,
    1879,  1880,  1881,  1882,  1883,  1884,  1885,  1886,  1887,  1888,
    1889,  1890,  1893,  1896,  1897,  1912,  1914,  1916,  1918,  1920,
    1922,  1924,  1928,  1929,  1930,  1931,  1932,  1933,  1934,  1935,
    1936,  1939,  1940,  1950,  1954,  1961,  1962,  1963,  1966,  1968,
    1972,  1973,  1974,  1975,  1976,  1977,  1978,  1979,  1980,  1981,
    1982,  1983,  1986,  1988,  1990,  1992,  1994,  1996,  2000,  2002,
    2006,  2007,  2010,  2015,  2018,  2023,  2026,  2028,  2032,  2043,
    2048,  2049,  2052,  2055,  2058,  2059,  2062,  2064,  2066,  2070,
    2071,  2072,  2075,  2080,  2081,  2084,  2086,  2090,  2092,  2096,
    2104,  2107,  2108,  2114,  2122,  2124,  2128,  2138,  2140,  2145,
    2147,  2151,  2153,  2155,  2157,  2159,  2161,  2163,  2165,  2167,
    2169,  2171,  2173,  2177,  2178,  2191,  2195,  2199,  2200,  2204,
    2208,  2210,  2212,  2214,  2219,  2221,  2225,  2228,  2233,  2234,
    2238,  2249,  2251,  2255,  2256,  2259,  2260,  2271,  2273,  2275,
    2277,  2279,  2281,  2283,  2285,  2287,  2289,  2291,  2295,  2296,
    2299,  2300,  2311,  2310,  2320,  2321,  2322,  2326,  2328,  2332,
    2333,  2334,  2335,  2336,  2339,  2340,  2344,  2345,  2346,  2347,
    2350,  2351,  2354,  2366,  2370,  2374,  2376,  2389,  2390,  2391,
    2392,  2393,  2394,  2397,  2398,  2399,  2403,  2405,  2407,  2409,
    2414,  2415,  2419,  2420,  2430,  2442,  2454,  2456,  2460,  2462,
    2466,  2468,  2470,  2472,  2474,  2476,  2478,  2480,  2484,  2485,
    2496,  2498,  2509,  2520,  2527,  2529,  2531,  2533,  2535,  2537,
    2541,  2542,  2546,  2560,  2562,  2564,  2577,  2579,  2581,  2585,
    2587,  2591,  2592,  2595,  2596,  2599,  2600,  2603,  2604,  2607,
    2610,  2621,  2626,  2627,  2628,  2629,  2630,  2634,  2635,  2684,
    2688,  2690,  2692,  2694,  2696,  2700,  2702,  2706,  2718,  2722,
    2726,  2729,  2732,  2733,  2734,  2735,  2736,  2737,  2738,  2739,
    2749,  2763,  2796,  2797,  2798,  2799,  2800,  2803,  2807,  2808,
    2818,  2820,  2824,  2826,  2830,  2832,  2834,  2836,  2840,  2841,
    2844,  2848,  2850,  2852,  2856,  2861,  2862,  2872,  2874,  2876,
    2878,  2880,  2882,  2884,  2886,  2890,  2891,  2894,  2895,  2898,
    2900,  2902,  2905,  2908,  2909,  2912,  2916,  2917,  2920,  2922,
    2924,  2926,  2930,  2932,  2934,  2936,  2938,  2942,  2943,  2946,
    2947,  2950,  2960,  2963,  2966,  2969,  2972,  2974,  2978,  2979,
    2982,  2983,  2994,  2995,  2998,  2999,  3009,  3011,  3013,  3015,
    3017,  3019,  3021,  3023,  3025,  3027,  3029,  3050,  3052,  3054,
    3056,  3058,  3060,  3062,  3066,  3068,  3070,  3072,  3076,  3077,
    3078,  3079,  3083,  3084,  3094,  3096,  3100,  3102,  3104,  3106,
    3110,  3112,  3116,  3117,  3120,  3122,  3126,  3139,  3141,  3143,
    3145,  3150,  3156,  3163,  3170,  3171,  3172,  3173,  3174,  3175,
    3176,  3177,  3178,  3181,  3182,  3183,  3184,  3185,  3186,  3188,
    3190,  3194,  3195,  3196,  3197,  3198,  3201,  3209,  3211,  3213,
    3215,  3217,  3219,  3221,  3223,  3225,  3227,  3229,  3233,  3236,
    3239,  3241,  3244,  3247,  3249,  3252,  3260,  3261,  3264,  3265,
    3268,  3272,  3281,  3282,  3285,  3286,  3289,  3293,  3297,  3299,
    3301,  3303,  3305,  3307,  3311,  3314,  3317,  3320,  3323,  3325,
    3327,  3329,  3333,  3337,  3339,  3342,  3345,  3346,  3347,  3348,
    3349,  3350,  3351,  3352,  3353,  3354,  3355,  3356,  3357,  3358,
    3372,  3374,  3376,  3378,  3380,  3382,  3384,  3386,  3388,  3392,
    3394,  3396,  3398,  3402,  3406,  3407,  3408,  3411,  3412,  3415,
    3416,  3417,  3418,  3419,  3420,  3421,  3422,  3423,  3426,  3427,
    3430,  3431,  3450,  3452,  3454,  3465,  3467,  3469,  3471,  3473,
    3475,  3477,  3479,  3481,  3483,  3485,  3487,  3489,  3491,  3493,
    3495,  3497,  3499,  3501,  3503,  3505,  3507,  3509,  3511,  3513,
    3515,  3517,  3519,  3521,  3523,  3525,  3527,  3529,  3531,  3533,
    3535,  3537,  3548,  3550,  3552,  3554,  3556,  3558,  3560,  3562,
    3564,  3566,  3568,  3570,  3572,  3574,  3576,  3578,  3580,  3592,
    3594,  3596,  3598,  3600,  3602,  3604,  3606,  3608,  3610,  3612,
    3614,  3616,  3618,  3620,  3622,  3624,  3626,  3628,  3630,  3632,
    3634,  3646,  3648,  3650,  3652,  3654,  3656,  3658,  3660,  3662,
    3664,  3666,  3668,  3670,  3672,  3674,  3676,  3678,  3680,  3682,
    3684,  3686,  3688,  3690,  3692,  3694,  3697,  3699,  3701,  3703,
    3705,  3707,  3709,  3711,  3713,  3715,  3722,  3724,  3727,  3730,
    3732,  3736,  3739,  3742,  3744,  3748,  3749,  3753,  3754,  3760,
    3761,  3762,  3763,  3764,  3765,  3766,  3767,  3771,  3773,  3778,
    3782,  3785,  3788,  3790,  3792,  3794,  3796,  3799,  3802,  3806,
    3810,  3812,  3814,  3818,  3820,  3839,  3841,  3843,  3847,  3849,
    3853,  3857,  3860,  3863,  3864,  3867,  3869,  3873,  3877,  3879,
    3881,  3885,  3886,  3897,  3899,  3904,  3906,  3908,  3913,  3915,
    3939,  3943,  3952,  3963,  3971,  3981,  3983,  3987,  3989,  3993,
    3994,  4004,  4005,  4008,  4010,  4014,  4016,  4020,  4022,  4027,
    4028,  4029,  4030,  4031,  4033,  4043,  4045,  4053,  4055,  4057,
    4059,  4061,  4063,  4065,  4067,  4069,  4073,  4074,  4075,  4076,
    4077,  4088,  4089,  4092,  4093,  4096,  4097,  4100,  4101,  4102,
    4105,  4106,  4107,  4108,  4109,  4112,  4113,  4116,  4117,  4118,
    4119,  4120,  4121,  4124,  4126,  4133,  4149,  4151,  4154,  4156,
    4160,  4172,  4197,  4220,  4238,  4250,  4251,  4254,  4255,  4256,
    4259,  4260,  4263,  4264,  4267,  4268,  4271,  4273,  4275,  4277,
    4281,  4288,  4311,  4337,  4350,  4357,  4400,  4402,  4409,  4411,
    4412,  4417,  4415,  4430,  4429,  4442,  4448,  4450,  4451,  4454,
    4455,  4456,  4457,  4458,  4461,  4462,  4470,  4556,  4594,  4593,
    4603,  4605,  4607,  4608,  4611,  4612,  4613,  4614,  4617,  4618,
    4622,  4621,  4685,  4683,  4698,  4697,  4710,  4716,  4720,  4724,
    4730,  4731,  4732,  4733,  4736,  4737,  4740,  4748,  4765,  4773,
    4798,  4799,  4893,  4927,  4929,  4931,  4935,  4939,  4938,  4992,
    4994,  4993,  5008,  5014,  5021,  5026,  5029,  5030,  5033,  5034,
    5035,  5036,  5037,  5038,  5039,  5047,  5055,  5058,  5059,  5060,
    5061,  5062,  5063,  5071,  5079,  5080,  5083,  5084,  5087,  5089,
    5093,  5164,  5165,  5172,  5173,  5174,  5180,  5189,  5192,  5193,
    5194,  5195,  5198,  5199,  5205,  5219,  5218,  5236,  5237,  5238,
    5239,  5240,  5243,  5245,  5249,  5250,  5257,  5262,  5264,  5265,
    5268,  5271,  5278,  5285,  5285,  5287,  5288,  5291,  5292,  5295,
    5295,  5297,  5307,  5316,  5322,  5328,  5334,  5342,  5343,  5354,
    5364,  5374,  5378,  5381,  5383,  5384,  5385,  5386,  5387,  5388,
    5389,  5390,  5391,  5392,  5393,  5394,  5395,  5396,  5397,  5400,
    5401,  5404,  5405,  5408,  5413,  5415,  5424,  5443,  5444,  5447,
    5448,  5455,  5456,  5457,  5464,  5463,  5525,  5526,  5533,  5532,
    5601,  5607,  5613,  5621,  5627,  5633,  5639,  5645,  5651,  5657,
    5663,  5669,  5680,  5681,  5684,  5685,  5686,  5687,  5688,  5689,
    5690,  5691,  5692,  5693,  5694,  5695,  5696,  5697,  5698,  5699,
    5700,  5701,  5702,  5703,  5704,  5705,  5706,  5707,  5708,  5709,
    5710,  5711,  5714,  5715,  5716,  5717,  5718,  5719,  5723,  5724,
    5725,  5726,  5727,  5728,  5729,  5732,  5748,  5749,  5750,  5751,
    5752,  5753,  5758,  5759,  5760,  5761,  5762,  5767,  5768,  5769,
    5770,  5771,  5777,  5778,  5779,  5780,  5781,  5782,  5783,  5786,
    5787,  5788,  5789,  5792,  5793,  5794,  5795,  5798,  5799,  5800,
    5801,  5802,  5803,  5804,  5819,  5820,  5821,  5822,  5823,  5824,
    5825,  5826,  5827,  5828,  5829,  5830,  5831,  5832,  5833,  5834,
    5835,  5836,  5837,  5838,  5839,  5840,  5841,  5842,  5843,  5844,
    5845,  5846,  5847,  5848,  5849,  5850,  5851,  5852,  5853,  5854,
    5855,  5856,  5857,  5858,  5859,  5860,  5861,  5862,  5863,  5864,
    5865,  5866,  5867,  5868,  5869,  5870,  5871,  5872,  5873,  5874,
    5875,  5876,  5877,  5878,  5879,  5880,  5881,  5882,  5883,  5884,
    5885,  5886,  5887,  5888,  5889,  5890,  5891,  5892,  5893,  5894,
    5895,  5896,  5897,  5898,  5899,  5900,  5901,  5902,  5903,  5904,
    5905,  5906,  5907,  5908,  5909,  5910,  5911,  5912,  5913,  5914,
    5915,  5916,  5917,  5918,  5919,  5920,  5921,  5922,  5923,  5924,
    5925,  5926,  5927,  5928,  5929,  5930,  5931,  5932,  5933,  5934,
    5935,  5936,  5937,  5938,  5939,  5940,  5941,  5942,  5943,  5944,
    5945,  5946,  5947,  5948,  5949,  5950,  5951,  5952,  5953,  5954,
    5955,  5956,  5957,  5958,  5959,  5960,  5961,  5962,  5963,  5964,
    5965,  5966,  5967,  5968,  5969,  5970,  5971,  5972,  5973,  5974,
    5975,  5976,  5977,  5978,  5979,  5980,  5981,  5982,  5983,  5984,
    5985,  5986,  5987,  5988,  5989,  5990,  5991,  5992,  5993,  5994,
    6008,  6009,  6013,  6014,  6015,  6016,  6017,  6018,  6019,  6020,
    6024,  6025,  6026,  6027,  6028,  6029,  6030,  6031,  6032,  6033,
    6034,  6035,  6036,  6037,  6038,  6039,  6040,  6054,  6055,  6056,
    6057,  6058,  6059,  6060,  6061,  6062,  6063,  6064,  6065,  6066,
    6067,  6068,  6069,  6070,  6071,  6072,  6073,  6074,  6084,  6085,
    6086,  6087,  6088,  6089,  6090,  6091,  6092,  6093,  6094,  6095,
    6096,  6097,  6098,  6099,  6100,  6101,  6102,  6103,  6104,  6105,
    6106,  6107,  6108,  6109,  6110,  6111,  6112,  6113,  6114,  6115,
    6116,  6117,  6118,  6119,  6120,  6121,  6122,  6123,  6124,  6125,
    6126,  6127,  6128,  6129,  6130,  6131,  6132,  6133,  6134,  6135,
    6136,  6137,  6138,  6139,  6140,  6141,  6142,  6143,  6147,  6148,
    6149,  6150,  6151,  6155,  6155,  6158,  6161,  6162,  6165,  6167,
    6172,  6182,  6189,  6190,  6191,  6194,  6224,  6225,  6228,  6230,
    6238,  6239,  6240,  6244,  6245,  6249,  6250,  6253,  6254,  6257,
    6258,  6259,  6260,  6261,  6264,  6265,  6266,  6267,  6268,  6269,
    6270,  6271,  6272,  6273,  6274,  6275,  6276,  6277,  6278,  6279,
    6280,  6281,  6282,  6283,  6284,  6285,  6286,  6287,  6288,  6289,
    6290,  6291,  6292,  6293,  6294,  6295,  6296,  6297,  6298,  6299,
    6300,  6301,  6302,  6303,  6304,  6305,  6306,  6307,  6308,  6309,
    6310,  6311,  6312,  6313,  6314,  6315,  6316,  6317,  6318,  6319
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "SQL_ALLOCATE", "SQL_AUTOCOMMIT", 
  "SQL_BOOL", "SQL_BREAK", "SQL_CALL", "SQL_CARDINALITY", "SQL_CONNECT", 
  "SQL_CONNECTION", "SQL_CONTINUE", "SQL_COUNT", "SQL_CURRENT", 
  "SQL_DATA", "SQL_DATETIME_INTERVAL_CODE", 
  "SQL_DATETIME_INTERVAL_PRECISION", "SQL_DESCRIBE", "SQL_DESCRIPTOR", 
  "SQL_DISCONNECT", "SQL_ENUM", "SQL_FOUND", "SQL_FREE", "SQL_GO", 
  "SQL_GOTO", "SQL_IDENTIFIED", "SQL_INDICATOR", "SQL_KEY_MEMBER", 
  "SQL_LENGTH", "SQL_LONG", "SQL_NAME", "SQL_NULLABLE", 
  "SQL_OCTET_LENGTH", "SQL_OPEN", "SQL_OUTPUT", "SQL_RELEASE", 
  "SQL_REFERENCE", "SQL_RETURNED_LENGTH", "SQL_RETURNED_OCTET_LENGTH", 
  "SQL_SCALE", "SQL_SECTION", "SQL_SHORT", "SQL_SIGNED", "SQL_SQL", 
  "SQL_SQLERROR", "SQL_SQLPRINT", "SQL_SQLWARNING", "SQL_START", 
  "SQL_STOP", "SQL_STRUCT", "SQL_UNSIGNED", "SQL_VALUE", "SQL_VAR", 
  "SQL_WHENEVER", "S_ADD", "S_AND", "S_ANYTHING", "S_AUTO", "S_CONST", 
  "S_DEC", "S_DIV", "S_DOTPOINT", "S_EQUAL", "S_EXTERN", "S_INC", 
  "S_LSHIFT", "S_MEMPOINT", "S_MEMBER", "S_MOD", "S_MUL", "S_NEQUAL", 
  "S_OR", "S_REGISTER", "S_RSHIFT", "S_STATIC", "S_SUB", "S_VOLATILE", 
  "S_TYPEDEF", "TYPECAST", "ABORT_P", "ABSOLUTE_P", "ACCESS", "ACTION", 
  "ADD", "AFTER", "AGGREGATE", "ALL", "ALTER", "ANALYSE", "ANALYZE", 
  "AND", "ANY", "ARRAY", "AS", "ASC", "ASSERTION", "ASSIGNMENT", "AT", 
  "AUTHORIZATION", "BACKWARD", "BEFORE", "BEGIN_P", "BETWEEN", "BIGINT", 
  "BINARY", "BIT", "BOOLEAN_P", "BOTH", "BY", "CACHE", "CALLED", 
  "CASCADE", "CASE", "CAST", "CHAIN", "CHAR_P", "CHARACTER", 
  "CHARACTERISTICS", "CHECK", "CHECKPOINT", "CLASS", "CLOSE", "CLUSTER", 
  "COALESCE", "COLLATE", "COLUMN", "COMMENT", "COMMIT", "COMMITTED", 
  "CONSTRAINT", "CONSTRAINTS", "CONVERSION_P", "CONVERT", "COPY", 
  "CREATE", "CREATEDB", "CREATEUSER", "CROSS", "CURRENT_DATE", 
  "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "CYCLE", 
  "DATABASE", "DAY_P", "DEALLOCATE", "DEC", "DECIMAL_P", "DECLARE", 
  "DEFAULT", "DEFAULTS", "DEFERRABLE", "DEFERRED", "DEFINER", "DELETE_P", 
  "DELIMITER", "DELIMITERS", "DESC", "DISTINCT", "DO", "DOMAIN_P", 
  "DOUBLE_P", "DROP", "EACH", "ELSE", "ENCODING", "ENCRYPTED", "END_P", 
  "ESCAPE", "EXCEPT", "EXCLUSIVE", "EXCLUDING", "EXECUTE", "EXISTS", 
  "EXPLAIN", "EXTERNAL", "EXTRACT", "FALSE_P", "FETCH", "FIRST_P", 
  "FLOAT_P", "FOR", "FORCE", "FOREIGN", "FORWARD", "FREEZE", "FROM", 
  "FULL", "FUNCTION", "GET", "GLOBAL", "GRANT", "GROUP_P", "HANDLER", 
  "HAVING", "HOLD", "HOUR_P", "ILIKE", "IMMEDIATE", "IMMUTABLE", 
  "IMPLICIT_P", "IN_P", "INCLUDING", "INCREMENT", "INDEX", "INHERITS", 
  "INITIALLY", "INNER_P", "INOUT", "INPUT_P", "INSENSITIVE", "INSERT", 
  "INSTEAD", "INT_P", "INTEGER", "INTERSECT", "INTERVAL", "INTO", 
  "INVOKER", "IS", "ISNULL", "ISOLATION", "JOIN", "KEY", "LANCOMPILER", 
  "LANGUAGE", "LAST_P", "LEADING", "LEFT", "LEVEL", "LIKE", "LIMIT", 
  "LISTEN", "LOAD", "LOCAL", "LOCATION", "LOCK_P", "MATCH", "MAXVALUE", 
  "MINUTE_P", "MINVALUE", "MODE", "MONTH_P", "MOVE", "NAMES", "NATIONAL", 
  "NATURAL", "NCHAR", "NEW", "NEXT", "NO", "NOCREATEDB", "NOCREATEUSER", 
  "NONE", "NOT", "NOTHING", "NOTIFY", "NOTNULL", "NULL_P", "NULLIF", 
  "NUMERIC", "OF", "OFF", "OFFSET", "OIDS", "OLD", "ON", "ONLY", 
  "OPERATOR", "OPTION", "OR", "ORDER", "OUT_P", "OUTER_P", "OVERLAPS", 
  "OVERLAY", "OWNER", "PARTIAL", "PASSWORD", "PATH_P", "PENDANT", 
  "PLACING", "POSITION", "PRECISION", "PRESERVE", "PREPARE", "PRIMARY", 
  "PRIOR", "PRIVILEGES", "PROCEDURAL", "PROCEDURE", "READ", "REAL", 
  "RECHECK", "REFERENCES", "REINDEX", "RELATIVE_P", "RENAME", "REPLACE", 
  "RESET", "RESTART", "RESTRICT", "RETURNS", "REVOKE", "RIGHT", 
  "ROLLBACK", "ROW", "ROWS", "RULE", "SCHEMA", "SCROLL", "SECOND_P", 
  "SECURITY", "SELECT", "SEQUENCE", "SERIALIZABLE", "SESSION", 
  "SESSION_USER", "SET", "SETOF", "SHARE", "SHOW", "SIMILAR", "SIMPLE", 
  "SMALLINT", "SOME", "STABLE", "START", "STATEMENT", "STATISTICS", 
  "STDIN", "STDOUT", "STORAGE", "STRICT_P", "SUBSTRING", "SYSID", "TABLE", 
  "TEMP", "TEMPLATE", "TEMPORARY", "THEN", "TIME", "TIMESTAMP", "TO", 
  "TOAST", "TRAILING", "TRANSACTION", "TREAT", "TRIGGER", "TRIM", 
  "TRUE_P", "TRUNCATE", "TRUSTED", "TYPE_P", "UNENCRYPTED", "UNION", 
  "UNIQUE", "UNKNOWN", "UNLISTEN", "UNTIL", "UPDATE", "USAGE", "USER", 
  "USING", "VACUUM", "VALID", "VALUES", "VARCHAR", "VARYING", "VERBOSE", 
  "VERSION", "VIEW", "VOLATILE", "WHEN", "WHERE", "WITH", "WITHOUT", 
  "WORK", "WRITE", "YEAR_P", "ZONE", "UNIONJOIN", "IDENT", "SCONST", "Op", 
  "CSTRING", "CVARIABLE", "CPP_LINE", "IP", "BCONST", "XCONST", "ICONST", 
  "PARAM", "FCONST", "'='", "'<'", "'>'", "POSTFIXOP", "'+'", "'-'", 
  "'*'", "'/'", "'%'", "'^'", "UMINUS", "'['", "']'", "'('", "')'", "'.'", 
  "';'", "'{'", "'}'", "','", "\"=\"", "':'", "$accept", "prog", 
  "statements", "statement", "opt_at", "stmt", "CreateUserStmt", 
  "opt_with", "AlterUserStmt", "AlterUserSetStmt", "DropUserStmt", 
  "OptUserList", "OptUserElem", "user_list", "CreateGroupStmt", 
  "OptGroupList", "OptGroupElem", "AlterGroupStmt", "DropGroupStmt", 
  "CreateSchemaStmt", "OptSchemaName", "OptSchemaEltList", "schema_stmt", 
  "VariableSetStmt", "set_rest", "var_list_or_default", "var_list", 
  "iso_level", "var_value", "opt_boolean", "zone_value", "opt_encoding", 
  "ColId_or_Sconst", "VariableShowStmt", "VariableResetStmt", 
  "ConstraintsSetStmt", "constraints_set_list", "constraints_set_mode", 
  "CheckPointStmt", "AlterTableStmt", "alter_column_default", 
  "opt_drop_behavior", "ClosePortalStmt", "CopyStmt", "copy_from", 
  "copy_file_name", "copy_opt_list", "copy_opt_item", "opt_binary", 
  "opt_oids", "copy_delimiter", "opt_using", "CreateStmt", "OptTemp", 
  "OptTableElementList", "TableElementList", "TableElement", "columnDef", 
  "ColQualList", "ColConstraint", "ColConstraintElem", "ConstraintAttr", 
  "TableLikeClause", "like_including_defaults", "TableConstraint", 
  "ConstraintElem", "opt_column_list", "columnList", "columnElem", 
  "key_match", "key_actions", "key_delete", "key_update", "key_action", 
  "OptInherit", "OptWithOids", "OnCommitOption", "CreateAsStmt", "@1", 
  "OptCreateAs", "CreateAsList", "CreateAsElement", "CreateSeqStmt", 
  "AlterSeqStmt", "OptSeqList", "OptSeqElem", "opt_by", "CreatePLangStmt", 
  "opt_Trusted", "handler_name", "opt_lancompiler", "DropPLangStmt", 
  "opt_procedural", "CreateTrigStmt", "TriggerActionTime", 
  "TriggerEvents", "TriggerOneEvent", "TriggerForSpec", "TriggerForOpt", 
  "TriggerForType", "TriggerFuncArgs", "TriggerFuncArg", 
  "OptConstrFromTable", "ConstraintAttributeSpec", 
  "ConstraintDeferrabilitySpec", "ConstraintTimeSpec", "DropTrigStmt", 
  "CreateAssertStmt", "DropAssertStmt", "DefineStmt", "rowdefinition", 
  "definition", "def_list", "def_elem", "def_arg", "CreateOpClassStmt", 
  "opclass_item_list", "opclass_item", "opt_default", "opt_recheck", 
  "DropOpClassStmt", "DropStmt", "drop_type", "any_name_list", "any_name", 
  "TruncateStmt", "FetchStmt", "fetch_direction", "fetch_count", 
  "from_in", "CommentStmt", "comment_type", "comment_text", "GrantStmt", 
  "RevokeStmt", "privileges", "privilege_list", "privilege", 
  "privilege_target", "grantee_list", "grantee", "opt_grant_grant_option", 
  "opt_revoke_grant_option", "function_with_argtypes_list", 
  "function_with_argtypes", "IndexStmt", "index_opt_unique", 
  "access_method_clause", "index_params", "index_elem", "opt_class", 
  "CreateFunctionStmt", "opt_or_replace", "func_args", "func_args_list", 
  "func_arg", "opt_arg", "func_as", "func_return", "func_type", 
  "createfunc_opt_list", "createfunc_opt_item", "opt_definition", 
  "RemoveFuncStmt", "RemoveAggrStmt", "aggr_argtype", "RemoveOperStmt", 
  "oper_argtypes", "any_operator", "CreateCastStmt", "cast_context", 
  "DropCastStmt", "ReindexStmt", "reindex_type", "opt_force", 
  "RenameStmt", "opt_name", "opt_column", "RuleStmt", "@2", 
  "RuleActionList", "RuleActionMulti", "RuleActionStmt", 
  "RuleActionStmtOrEmpty", "event", "opt_instead", "DropRuleStmt", 
  "NotifyStmt", "ListenStmt", "UnlistenStmt", "TransactionStmt", 
  "opt_transaction", "transaction_mode_list", 
  "transaction_mode_list_or_empty", "transaction_access_mode", "ViewStmt", 
  "LoadStmt", "CreatedbStmt", "createdb_opt_list", "createdb_opt_item", 
  "opt_equal", "AlterDatabaseSetStmt", "DropdbStmt", "CreateDomainStmt", 
  "AlterDomainStmt", "opt_as", "CreateConversionStmt", "ClusterStmt", 
  "VacuumStmt", "AnalyzeStmt", "analyze_keyword", "opt_verbose", 
  "opt_full", "opt_freeze", "opt_name_list", "ExplainStmt", 
  "ExplainableStmt", "opt_analyze", "InsertStmt", "insert_rest", 
  "insert_column_list", "insert_column_item", "DeleteStmt", "LockStmt", 
  "opt_lock", "lock_type", "UpdateStmt", "DeclareCursorStmt", 
  "cursor_options", "opt_hold", "SelectStmt", "select_with_parens", 
  "select_no_parens", "select_clause", "simple_select", "into_clause", 
  "OptTempTableName", "opt_table", "opt_all", "opt_distinct", 
  "opt_sort_clause", "sort_clause", "sortby_list", "sortby", 
  "select_limit", "opt_select_limit", "select_limit_value", 
  "select_offset_value", "group_clause", "having_clause", 
  "for_update_clause", "opt_for_update_clause", "update_list", 
  "from_clause", "from_list", "table_ref", "joined_table", "alias_clause", 
  "join_type", "join_outer", "join_qual", "relation_expr", "func_table", 
  "where_clause", "TableFuncElementList", "TableFuncElement", "Typename", 
  "opt_array_bounds", "Iresult", "SimpleTypename", "ConstTypename", 
  "GenericType", "Numeric", "opt_float", "opt_numeric", "opt_decimal", 
  "Bit", "ConstBit", "BitWithLength", "BitWithoutLength", "Character", 
  "ConstCharacter", "CharacterWithLength", "CharacterWithoutLength", 
  "character", "opt_varying", "opt_charset", "ConstDatetime", 
  "ConstInterval", "opt_timezone", "opt_interval", "r_expr", "row", 
  "row_descriptor", "sub_type", "all_Op", "MathOp", "qual_Op", 
  "qual_all_Op", "a_expr", "b_expr", "c_expr", "opt_indirection", 
  "expr_list", "extract_list", "type_list", "array_expr_list", 
  "array_expr", "extract_arg", "overlay_list", "overlay_placing", 
  "position_list", "substr_list", "substr_from", "substr_for", 
  "trim_list", "in_expr", "case_expr", "when_clause_list", "when_clause", 
  "case_default", "case_arg", "columnref", "dotted_name", "attrs", 
  "opt_empty_parentheses", "target_list", "target_el", 
  "update_target_list", "inf_col_list", "inf_val_list", 
  "update_target_el", "insert_target_list", "insert_target_el", 
  "relation_name", "qualified_name_list", "qualified_name", "name_list", 
  "name", "database_name", "access_method", "attr_name", "index_name", 
  "file_name", "func_name", "AexprConst", "Iconst", "Fconst", "Bconst", 
  "Xconst", "Sconst", "PosIntConst", "IntConst", "StringConst", 
  "PosIntStringConst", "NumConst", "AllConst", "PosAllConst", "UserId", 
  "SpecialRuleRelation", "ECPGConnect", "connection_target", "db_prefix", 
  "server", "opt_server", "server_name", "opt_port", 
  "opt_connection_name", "opt_user", "ora_user", "user_name", 
  "char_variable", "opt_options", "ECPGCursorStmt", "ECPGDeallocate", 
  "ECPGVarDeclaration", "single_vt_declaration", "single_var_declaration", 
  "@3", "@4", "precision", "opt_scale", "ecpg_interval", "single_vt_type", 
  "ECPGDeclaration", "@5", "sql_startdeclare", "sql_enddeclare", 
  "var_type_declarations", "vt_declarations", "variable_declarations", 
  "type_declaration", "@6", "var_declaration", "@7", "@8", 
  "storage_declaration", "storage_clause", "storage_modifier", 
  "common_type", "var_type", "enum_type", "enum_definition", 
  "struct_union_type_with_symbol", "@9", "struct_union_type", "@10", 
  "s_struct_union_symbol", "s_struct_union", "simple_type", 
  "unsigned_type", "signed_type", "opt_signed", "variable_list", 
  "variable", "opt_initializer", "opt_pointer", "ECPGDeclare", 
  "ECPGDisconnect", "dis_name", "connection_object", "ECPGExecute", "@11", 
  "execute_rest", "execstring", "prepared_name", "ECPGFree", "ECPGOpen", 
  "opt_ecpg_using", "ecpg_using", "using_descriptor", "into_descriptor", 
  "opt_sql", "ecpg_into_using", "ecpg_into", "using_list", "UsingConst", 
  "ECPGPrepare", "ECPGDescribe", "opt_output", "ECPGDeallocateDescr", 
  "ECPGAllocateDescr", "ECPGGetDescHeaderItem", "desc_header_item", 
  "ECPGGetDescItem", "descriptor_item", "ECPGGetDescHeaderItems", 
  "ECPGGetDescItems", "ECPGGetDescriptorHeader", "ECPGGetDescriptor", 
  "ECPGRelease", "ECPGSetAutocommit", "on_off", "ECPGSetConnection", 
  "ECPGTypedef", "@12", "opt_reference", "ECPGVar", "@13", "ECPGWhenever", 
  "action", "ECPGKeywords", "ECPGKeywords_vanames", "ECPGKeywords_rest", 
  "ECPGTypeName", "symbol", "ColId", "type_name", "function_name", 
  "ColLabel", "ECPGColLabelCommon", "ECPGColLabel", "ECPGCKeywords", 
  "unreserved_keyword", "col_name_keyword", "func_name_keyword", 
  "reserved_keyword", "into_list", "ecpgstart", "c_args", 
  "coutputvariable", "civarind", "civar", "indicator", "cvariable", 
  "ident", "quoted_ident_stringvar", "c_stuff_item", "c_stuff", "c_list", 
  "c_term", "c_thing", "c_anything", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,    61,    60,    62,   650,    43,
      45,    42,    47,    37,    94,   651,    91,    93,    40,    41,
      46,    59,   123,   125,    44,   652,    58
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned short yyr1[] =
{
       0,   417,   418,   419,   419,   420,   420,   420,   420,   420,
     420,   420,   420,   421,   422,   422,   422,   422,   422,   422,
     422,   422,   422,   422,   422,   422,   422,   422,   422,   422,
     422,   422,   422,   422,   422,   422,   422,   422,   422,   422,
     422,   422,   422,   422,   422,   422,   422,   422,   422,   422,
     422,   422,   422,   422,   422,   422,   422,   422,   422,   422,
     422,   422,   422,   422,   422,   422,   422,   422,   422,   422,
     422,   422,   422,   422,   422,   422,   422,   422,   422,   422,
     422,   422,   422,   422,   422,   422,   422,   422,   422,   422,
     422,   422,   422,   422,   422,   422,   422,   422,   422,   422,
     422,   422,   423,   424,   424,   425,   425,   426,   426,   427,
     428,   428,   429,   429,   429,   429,   429,   429,   429,   429,
     430,   430,   431,   431,   432,   432,   433,   433,   434,   434,
     435,   436,   436,   437,   437,   438,   438,   439,   439,   439,
     440,   440,   440,   441,   441,   441,   441,   441,   441,   441,
     441,   442,   442,   443,   443,   444,   444,   445,   445,   445,
     446,   446,   446,   446,   447,   447,   447,   447,   447,   447,
     448,   448,   448,   449,   449,   450,   450,   450,   450,   450,
     451,   451,   451,   451,   451,   452,   453,   453,   454,   454,
     455,   456,   456,   456,   456,   456,   456,   456,   456,   456,
     456,   456,   456,   456,   457,   457,   458,   458,   458,   459,
     460,   461,   461,   462,   462,   462,   463,   463,   464,   464,
     464,   464,   465,   465,   466,   466,   467,   467,   468,   468,
     469,   469,   470,   470,   470,   470,   470,   470,   470,   471,
     471,   472,   472,   473,   473,   473,   474,   475,   475,   476,
     476,   476,   477,   477,   477,   477,   477,   477,   477,   478,
     478,   478,   478,   479,   480,   480,   480,   481,   481,   482,
     482,   482,   482,   483,   483,   484,   484,   485,   486,   486,
     486,   487,   487,   487,   487,   487,   488,   489,   490,   490,
     490,   490,   490,   491,   491,   492,   492,   492,   493,   493,
     493,   493,   495,   494,   496,   496,   497,   497,   498,   499,
     500,   501,   501,   502,   502,   502,   502,   502,   502,   502,
     502,   502,   502,   503,   503,   504,   505,   505,   506,   506,
     507,   507,   508,   509,   509,   510,   510,   511,   511,   512,
     512,   512,   513,   513,   513,   514,   514,   515,   515,   516,
     516,   517,   517,   517,   518,   518,   519,   519,   520,   520,
     520,   520,   521,   521,   522,   522,   523,   524,   525,   526,
     526,   526,   526,   527,   528,   529,   529,   530,   530,   531,
     531,   531,   532,   533,   533,   534,   534,   534,   534,   535,
     535,   536,   536,   537,   538,   539,   539,   539,   539,   539,
     539,   539,   539,   540,   540,   541,   541,   542,   543,   543,
     543,   543,   543,   543,   543,   543,   543,   543,   544,   544,
     544,   544,   544,   544,   544,   544,   544,   544,   544,   544,
     544,   544,   545,   546,   546,   547,   547,   547,   547,   547,
     547,   547,   548,   548,   548,   548,   548,   548,   548,   548,
     548,   549,   549,   550,   551,   552,   552,   552,   553,   553,
     554,   554,   554,   554,   554,   554,   554,   554,   554,   554,
     554,   554,   555,   555,   555,   555,   555,   555,   556,   556,
     557,   557,   558,   558,   559,   559,   560,   560,   561,   562,
     563,   563,   564,   564,   565,   565,   566,   566,   566,   567,
     567,   567,   568,   569,   569,   570,   570,   571,   571,   572,
     572,   573,   573,   573,   574,   574,   575,   576,   576,   577,
     577,   578,   578,   578,   578,   578,   578,   578,   578,   578,
     578,   578,   578,   579,   579,   580,   581,   582,   582,   583,
     584,   584,   584,   584,   585,   585,   586,   586,   587,   587,
     588,   589,   589,   590,   590,   591,   591,   592,   592,   592,
     592,   592,   592,   592,   592,   592,   592,   592,   593,   593,
     594,   594,   596,   595,   597,   597,   597,   598,   598,   599,
     599,   599,   599,   599,   600,   600,   601,   601,   601,   601,
     602,   602,   603,   604,   605,   606,   606,   607,   607,   607,
     607,   607,   607,   608,   608,   608,   609,   609,   609,   609,
     610,   610,   611,   611,   612,   613,   614,   614,   615,   615,
     616,   616,   616,   616,   616,   616,   616,   616,   617,   617,
     618,   618,   619,   620,   621,   621,   621,   621,   621,   621,
     622,   622,   623,   624,   624,   624,   625,   625,   625,   626,
     626,   627,   627,   628,   628,   629,   629,   630,   630,   631,
     631,   632,   633,   633,   633,   633,   633,   634,   634,   635,
     636,   636,   636,   636,   636,   637,   637,   638,   639,   640,
     641,   641,   642,   642,   642,   642,   642,   642,   642,   642,
     643,   644,   645,   645,   645,   645,   645,   646,   646,   646,
     647,   647,   648,   648,   649,   649,   649,   649,   650,   650,
     651,   651,   651,   651,   652,   652,   652,   653,   653,   653,
     653,   653,   653,   653,   653,   654,   654,   655,   655,   656,
     656,   656,   656,   657,   657,   658,   659,   659,   660,   660,
     660,   660,   661,   661,   661,   661,   661,   662,   662,   663,
     663,   664,   665,   665,   666,   666,   667,   667,   668,   668,
     669,   669,   670,   670,   671,   671,   672,   672,   672,   672,
     672,   672,   672,   672,   672,   672,   672,   673,   673,   673,
     673,   673,   673,   673,   674,   674,   674,   674,   675,   675,
     675,   675,   676,   676,   677,   677,   678,   678,   678,   678,
     679,   679,   680,   680,   681,   681,   682,   683,   683,   683,
     683,   684,   684,   684,   685,   685,   685,   685,   685,   685,
     685,   685,   685,   686,   686,   686,   686,   686,   686,   686,
     686,   687,   687,   687,   687,   687,   688,   689,   689,   689,
     689,   689,   689,   689,   689,   689,   689,   689,   690,   690,
     691,   691,   691,   692,   692,   692,   693,   693,   694,   694,
     695,   696,   697,   697,   698,   698,   699,   700,   701,   701,
     701,   701,   701,   701,   702,   702,   703,   703,   704,   704,
     704,   704,   705,   706,   706,   706,   707,   707,   707,   707,
     707,   707,   707,   707,   707,   707,   707,   707,   707,   707,
     708,   708,   708,   708,   708,   708,   708,   708,   708,   709,
     709,   709,   709,   710,   711,   711,   711,   712,   712,   713,
     713,   713,   713,   713,   713,   713,   713,   713,   714,   714,
     715,   715,   716,   716,   716,   716,   716,   716,   716,   716,
     716,   716,   716,   716,   716,   716,   716,   716,   716,   716,
     716,   716,   716,   716,   716,   716,   716,   716,   716,   716,
     716,   716,   716,   716,   716,   716,   716,   716,   716,   716,
     716,   716,   716,   716,   716,   716,   716,   716,   716,   716,
     716,   716,   716,   716,   716,   716,   716,   716,   716,   717,
     717,   717,   717,   717,   717,   717,   717,   717,   717,   717,
     717,   717,   717,   717,   717,   717,   717,   717,   717,   717,
     717,   718,   718,   718,   718,   718,   718,   718,   718,   718,
     718,   718,   718,   718,   718,   718,   718,   718,   718,   718,
     718,   718,   718,   718,   718,   718,   718,   718,   718,   718,
     718,   718,   718,   718,   718,   718,   719,   719,   719,   720,
     720,   721,   721,   722,   722,   723,   723,   724,   724,   725,
     725,   725,   725,   725,   725,   725,   725,   726,   726,   727,
     728,   728,   729,   729,   729,   729,   729,   729,   730,   731,
     732,   732,   732,   733,   733,   734,   734,   734,   735,   735,
     736,   737,   737,   738,   738,   739,   739,   740,   741,   741,
     741,   742,   742,   743,   743,   744,   744,   744,   745,   745,
     745,   746,   746,   747,   747,   748,   748,   749,   749,   750,
     750,   751,   751,   752,   752,   753,   753,   754,   754,   755,
     756,   757,   758,   759,   760,   761,   761,   762,   762,   762,
     762,   762,   762,   762,   762,   762,   763,   764,   765,   766,
     767,   768,   768,   769,   769,   770,   770,   771,   771,   771,
     772,   772,   772,   772,   772,   773,   773,   774,   774,   774,
     774,   774,   774,   775,   776,   776,   777,   777,   777,   777,
     778,   778,   778,   779,   780,   781,   781,   782,   782,   782,
     783,   783,   784,   784,   785,   785,   786,   786,   786,   786,
     787,   787,   788,   789,   789,   790,   791,   791,   792,   793,
     793,   795,   794,   796,   794,   794,   797,   798,   798,   799,
     799,   799,   799,   799,   800,   800,   800,   800,   802,   801,
     803,   804,   805,   805,   806,   806,   806,   806,   807,   807,
     809,   808,   811,   810,   812,   810,   810,   813,   813,   813,
     814,   814,   814,   814,   815,   815,   816,   816,   816,   816,
     817,   817,   817,   818,   818,   818,   819,   821,   820,   822,
     823,   822,   824,   824,   825,   825,   826,   826,   827,   827,
     827,   827,   827,   827,   827,   827,   827,   828,   828,   828,
     828,   828,   828,   828,   828,   828,   829,   829,   830,   830,
     831,   832,   832,   833,   833,   833,   834,   835,   836,   836,
     836,   836,   837,   837,   838,   839,   838,   840,   840,   840,
     840,   840,   841,   841,   842,   842,   843,   844,   845,   845,
     846,   847,   848,   849,   849,   850,   850,   851,   851,   852,
     852,   853,   853,   854,   855,   855,   855,   856,   856,   857,
     858,   859,   860,   861,   862,   862,   862,   862,   862,   862,
     862,   862,   862,   862,   862,   862,   862,   862,   862,   863,
     863,   864,   864,   865,   866,   866,   867,   868,   868,   869,
     869,   870,   870,   870,   872,   871,   873,   873,   875,   874,
     876,   876,   876,   877,   877,   877,   877,   877,   877,   877,
     877,   877,   878,   878,   879,   879,   879,   879,   879,   879,
     879,   879,   879,   879,   879,   879,   879,   879,   879,   879,
     879,   879,   879,   879,   879,   879,   879,   879,   879,   879,
     879,   879,   880,   880,   880,   880,   880,   880,   881,   881,
     881,   881,   881,   881,   881,   882,   883,   883,   883,   883,
     883,   883,   884,   884,   884,   884,   884,   885,   885,   885,
     885,   885,   886,   886,   886,   886,   886,   886,   886,   887,
     887,   887,   887,   888,   888,   888,   888,   889,   889,   889,
     889,   889,   889,   889,   890,   890,   890,   890,   890,   890,
     890,   890,   890,   890,   890,   890,   890,   890,   890,   890,
     890,   890,   890,   890,   890,   890,   890,   890,   890,   890,
     890,   890,   890,   890,   890,   890,   890,   890,   890,   890,
     890,   890,   890,   890,   890,   890,   890,   890,   890,   890,
     890,   890,   890,   890,   890,   890,   890,   890,   890,   890,
     890,   890,   890,   890,   890,   890,   890,   890,   890,   890,
     890,   890,   890,   890,   890,   890,   890,   890,   890,   890,
     890,   890,   890,   890,   890,   890,   890,   890,   890,   890,
     890,   890,   890,   890,   890,   890,   890,   890,   890,   890,
     890,   890,   890,   890,   890,   890,   890,   890,   890,   890,
     890,   890,   890,   890,   890,   890,   890,   890,   890,   890,
     890,   890,   890,   890,   890,   890,   890,   890,   890,   890,
     890,   890,   890,   890,   890,   890,   890,   890,   890,   890,
     890,   890,   890,   890,   890,   890,   890,   890,   890,   890,
     890,   890,   890,   890,   890,   890,   890,   890,   890,   890,
     890,   890,   890,   890,   890,   890,   890,   890,   890,   890,
     890,   890,   890,   890,   890,   890,   890,   890,   890,   890,
     891,   891,   891,   891,   891,   891,   891,   891,   891,   891,
     891,   891,   891,   891,   891,   891,   891,   891,   891,   891,
     891,   891,   891,   891,   891,   891,   891,   892,   892,   892,
     892,   892,   892,   892,   892,   892,   892,   892,   892,   892,
     892,   892,   892,   892,   892,   892,   892,   892,   893,   893,
     893,   893,   893,   893,   893,   893,   893,   893,   893,   893,
     893,   893,   893,   893,   893,   893,   893,   893,   893,   893,
     893,   893,   893,   893,   893,   893,   893,   893,   893,   893,
     893,   893,   893,   893,   893,   893,   893,   893,   893,   893,
     893,   893,   893,   893,   893,   893,   893,   893,   893,   893,
     893,   893,   893,   893,   893,   893,   893,   893,   893,   893,
     893,   893,   893,   894,   894,   895,   896,   896,   897,   897,
     898,   899,   900,   900,   900,   901,   902,   902,   903,   903,
     904,   904,   904,   905,   905,   906,   906,   907,   907,   908,
     908,   908,   908,   908,   909,   909,   909,   909,   909,   909,
     909,   909,   909,   909,   909,   909,   909,   909,   909,   909,
     909,   909,   909,   909,   909,   909,   909,   909,   909,   909,
     909,   909,   909,   909,   909,   909,   909,   909,   909,   909,
     909,   909,   909,   909,   909,   909,   909,   909,   909,   909,
     909,   909,   909,   909,   909,   909,   909,   909,   909,   909
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     0,     2,     4,     3,     2,     1,     1,
       1,     1,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     5,     1,     0,     4,     5,     5,     4,     3,
       2,     0,     2,     2,     1,     1,     1,     1,     3,     3,
       3,     1,     4,     5,     2,     0,     2,     2,     6,     6,
       3,     7,     4,     1,     0,     2,     0,     1,     1,     1,
       2,     3,     3,     3,     3,     3,     2,     5,     2,     3,
       3,     1,     1,     1,     3,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     3,     6,     1,     1,
       1,     1,     0,     1,     1,     2,     3,     4,     3,     2,
       2,     3,     4,     3,     2,     4,     1,     1,     1,     1,
       1,     6,     7,     9,     9,     9,     9,     7,     5,     7,
       6,     6,     6,     6,     3,     2,     1,     1,     0,     2,
       9,     1,     1,     1,     1,     1,     2,     0,     1,     1,
       3,     3,     1,     0,     2,     0,     3,     0,     1,     0,
      10,    11,     1,     1,     2,     2,     2,     2,     0,     1,
       0,     1,     3,     1,     1,     1,     3,     2,     0,     3,
       1,     1,     2,     1,     1,     2,     4,     2,     5,     1,
       2,     2,     2,     3,     2,     2,     0,     3,     1,     4,
       4,     5,    11,     3,     0,     3,     1,     1,     2,     2,
       0,     1,     1,     2,     2,     0,     3,     3,     2,     1,
       1,     2,     2,     4,     0,     2,     2,     0,     3,     4,
       4,     0,     0,     8,     3,     0,     3,     1,     1,     5,
       4,     2,     0,     2,     1,     2,     3,     2,     2,     2,
       2,     3,     3,     1,     0,     8,     1,     0,     1,     1,
       2,     0,     5,     1,     0,    14,    19,     1,     1,     1,
       3,     5,     1,     1,     1,     3,     0,     1,     0,     1,
       1,     1,     3,     0,     1,     1,     0,     2,     1,     2,
       1,     2,     2,     1,     2,     2,     6,     8,     3,     4,
       4,     4,     5,     3,     3,     1,     3,     3,     1,     1,
       1,     1,    12,     1,     3,     4,     7,     4,     2,     1,
       0,     1,     0,     7,     4,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     3,     1,     1,     3,     5,     4,
       4,     3,     4,     3,     3,     2,     4,     2,     1,     1,
       1,     1,     2,     2,     1,     1,     1,     2,     2,     1,
       2,     2,     1,     1,     1,     6,     9,     7,     9,     8,
       8,     6,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     7,     8,     2,     1,     1,     1,     3,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     2,     2,     2,     2,     2,     1,     3,
       1,     2,     3,     0,     3,     0,     1,     3,     2,    11,
       1,     0,     2,     0,     1,     3,     2,     5,     4,     1,
       2,     0,     9,     2,     0,     3,     2,     1,     3,     2,
       1,     1,     1,     1,     1,     3,     1,     1,     4,     1,
       2,     2,     2,     1,     1,     1,     4,     5,     1,     3,
       3,     2,     2,     2,     0,     5,     7,     1,     1,     7,
       1,     3,     3,     3,     1,     3,    11,    10,     2,     0,
       8,     4,     4,     1,     1,     1,     0,     9,     6,     6,
       7,     6,     6,     9,     6,     8,     8,     6,     1,     0,
       1,     0,     0,    14,     1,     1,     3,     3,     1,     1,
       1,     1,     1,     1,     1,     0,     1,     1,     1,     1,
       1,     0,     6,     2,     2,     2,     2,     2,     2,     3,
       2,     2,     2,     1,     1,     0,     3,     1,     4,     4,
       1,     0,     2,     2,     7,     2,     5,     3,     1,     2,
       3,     3,     3,     3,     3,     3,     3,     3,     1,     0,
       5,     4,     3,     6,     4,     6,     6,     5,     7,     6,
       1,     0,    10,     4,     2,     1,     4,     5,     5,     2,
       4,     1,     1,     1,     0,     1,     0,     1,     0,     3,
       0,     4,     1,     1,     1,     1,     1,     1,     0,     4,
       4,     2,     1,     7,     4,     3,     1,     2,     4,     4,
       3,     0,     2,     2,     2,     3,     1,     3,     1,     2,
       6,     7,     0,     2,     2,     2,     3,     0,     2,     2,
       1,     1,     3,     3,     1,     2,     4,     4,     1,     1,
       8,     4,     4,     4,     2,     1,     0,     3,     3,     4,
       4,     4,     4,     2,     1,     1,     0,     1,     0,     1,
       5,     1,     0,     1,     0,     3,     1,     3,     3,     2,
       2,     1,     4,     4,     2,     2,     4,     1,     0,     1,
       1,     1,     3,     0,     2,     0,     3,     3,     1,     0,
       2,     0,     2,     0,     3,     1,     1,     2,     1,     2,
       5,     6,     5,     1,     2,     1,     4,     3,     4,     3,
       5,     4,     5,     4,     5,     2,     4,     1,     2,     2,
       2,     1,     1,     0,     4,     2,     1,     2,     2,     4,
       3,     4,     2,     0,     1,     3,     2,     2,     3,     5,
       6,     3,     4,     0,     1,     3,     3,     3,     3,     3,
       3,     1,     1,     1,     1,     1,     1,     1,     2,     5,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     2,     2,     2,     2,     1,     3,     0,
       5,     3,     0,     5,     3,     0,     1,     1,     1,     1,
       5,     2,     1,     1,     1,     1,     5,     2,     2,     2,
       1,     3,     3,     2,     1,     0,     3,     0,     5,     2,
       5,     2,     1,     3,     3,     0,     1,     1,     1,     1,
       1,     1,     3,     3,     3,     3,     3,     3,     3,     0,
       3,     4,     4,     3,     3,     3,     4,     3,     5,     4,
       4,     3,     3,     3,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     4,
       1,     4,     1,     3,     5,     2,     2,     2,     2,     2,
       2,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     2,     2,     3,     3,     2,     3,     5,     4,     6,
       3,     5,     4,     6,     4,     6,     5,     7,     2,     3,
       2,     4,     3,     4,     3,     4,     3,     4,     5,     6,
       7,     5,     6,     3,     4,     4,     6,     2,     1,     1,
       3,     2,     2,     2,     2,     2,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     2,     2,     5,     6,
       7,     1,     1,     3,     5,     4,     1,     3,     4,     5,
       5,     4,     1,     2,     4,     2,     4,     2,     2,     2,
       6,     4,     4,     4,     4,     6,     5,     5,     5,     4,
       6,     4,     1,     2,     2,     2,     4,     6,     0,     1,
       3,     3,     0,     3,     1,     1,     3,     3,     3,     1,
       1,     1,     1,     1,     1,     1,     1,     4,     3,     2,
       3,     0,     3,     3,     2,     2,     1,     0,     2,     2,
       3,     2,     1,     1,     3,     5,     6,     4,     2,     1,
       4,     2,     0,     1,     0,     2,     2,     2,     2,     2,
       3,     2,     0,     3,     1,     3,     1,     1,     3,     7,
       1,     2,     4,     1,     3,     4,     4,     3,     1,     1,
       1,     1,     1,     1,     3,     1,     1,     1,     3,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     3,
       6,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     1,     1,     1,     1,     1,
       1,     1,     2,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     5,     3,     2,     2,
       3,     7,     1,     2,     2,     1,     0,     1,     3,     1,
       2,     0,     2,     0,     2,     0,     1,     3,     4,     3,
       1,     1,     1,     2,     0,     7,     3,     2,     1,     1,
       1,     0,     5,     0,     4,     2,     1,     2,     0,     1,
       3,     3,     3,     3,     1,     1,     2,     1,     0,     4,
       5,     5,     0,     1,     1,     1,     2,     2,     1,     2,
       0,     7,     0,     5,     0,     4,     2,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     5,
       1,     2,     1,     3,     2,     2,     3,     0,     5,     1,
       0,     5,     2,     2,     1,     1,     1,     2,     2,     3,
       1,     2,     2,     3,     3,     4,     2,     1,     2,     1,
       1,     2,     2,     3,     1,     1,     1,     0,     1,     3,
       4,     0,     2,     0,     1,     2,     3,     2,     1,     1,
       1,     0,     1,     1,     3,     0,     4,     2,     2,     1,
       1,     0,     1,     1,     1,     1,     2,     3,     0,     1,
       2,     4,     4,     0,     1,     1,     1,     2,     1,     1,
       3,     1,     1,     4,     4,     4,     4,     1,     0,     3,
       3,     3,     1,     3,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       3,     1,     3,     4,     6,     6,     2,     4,     4,     1,
       1,     4,     4,     3,     0,     7,     1,     0,     0,     7,
       3,     4,     3,     1,     1,     1,     2,     3,     5,     2,
       5,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     3,     1,     0,     1,     2,     1,
       2,     1,     1,     2,     2,     1,     1,     1,     1,     1,
       1,     2,     3,     1,     2,     1,     3,     1,     3,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned short yydefact[] =
{
       3,     0,     2,     1,  1839,  1840,  1843,  1847,  1848,  1775,
    1849,  1850,  1815,  1816,  1817,  1818,  1819,  1820,  1821,  1822,
    1823,  1824,  1825,  1826,  1828,  1827,  1829,  1830,  1831,  1832,
    1833,  1834,  1835,  1836,  1838,  1837,  1852,  1853,  1841,  1842,
    1844,  1845,  1814,  1846,  1854,  1855,  1856,  1851,  1804,  1150,
    1805,    10,  1146,  1147,  1859,  1810,  1811,  1809,  1812,  1813,
    1857,  1858,  1800,  1801,  1803,    11,    12,  1802,     4,  1806,
    1807,  1808,     8,  1228,  1297,     9,  1799,  1297,     0,  1404,
    1405,  1406,     0,  1407,  1408,  1409,  1410,  1411,  1348,  1311,
       0,  1412,     0,  1413,  1414,  1415,  1416,  1417,  1418,  1419,
    1420,  1421,     0,  1422,  1423,  1424,  1425,  1426,  1296,  1427,
    1428,  1429,  1430,  1274,  1280,  1431,  1388,     0,  1253,  1254,
    1250,  1252,  1251,  1255,  1240,   605,     0,   652,   651,     0,
    1687,   605,  1688,  1660,  1689,  1661,  1662,   190,     0,   645,
    1663,     0,   605,  1664,   223,   504,  1690,     0,     0,  1665,
    1666,     0,     0,  1225,   334,   605,     0,  1667,   668,  1668,
       0,  1669,  1691,  1692,     0,     0,  1693,  1694,  1695,     0,
    1670,  1671,  1696,  1697,  1698,  1699,  1700,     0,     0,   726,
       0,  1701,  1672,  1673,     0,  1702,  1674,  1675,  1703,  1704,
    1676,     0,  1677,     0,     0,   485,  1705,   605,  1678,   732,
       0,  1679,     0,  1706,  1680,     0,  1681,  1682,  1683,  1684,
    1685,   726,  1384,  1275,     0,     0,   656,  1686,  1707,  1786,
    1787,     0,     0,     0,    41,    20,    19,    54,    34,    16,
      48,    37,    78,    79,    80,    26,    22,    18,    23,    27,
      39,    28,    38,    17,    35,    50,    40,    53,    29,    46,
      44,    36,    49,    52,    74,    57,    25,    58,    70,    59,
      33,    68,    66,    67,    30,    47,    65,    69,    71,    51,
      64,    61,    75,    73,    81,    62,    42,    14,    55,    32,
      15,    31,    24,    77,    21,   654,    56,    60,    45,    63,
      76,    43,    72,   709,   700,   734,   708,    83,    84,    85,
       7,  1208,  1210,  1213,  1209,  1297,  1248,  1249,  1224,  1258,
    1269,  1257,  1227,  1270,  1256,  1276,     0,    87,    89,    90,
      91,    94,    95,    88,    86,    82,    93,    92,    96,    97,
      98,    99,   100,   101,  1472,   899,  1470,  1471,  1469,  1432,
    1433,  1434,  1435,  1436,  1437,  1484,  1485,  1486,  1487,  1488,
    1489,  1490,  1708,  1491,  1709,  1710,  1711,  1712,  1713,  1714,
    1715,  1492,  1493,  1494,  1495,  1496,  1497,  1716,  1498,  1499,
    1500,  1717,  1718,  1501,  1502,  1719,  1503,  1504,  1505,  1506,
    1720,  1721,  1507,  1508,  1509,  1722,  1510,  1511,  1512,  1723,
    1513,  1514,  1724,  1725,  1726,  1727,  1515,  1516,  1517,  1518,
    1519,  1520,  1728,  1521,  1729,  1522,  1523,  1524,  1525,  1730,
    1731,  1732,  1526,  1527,  1528,  1529,  1733,  1530,  1531,  1734,
    1532,  1735,  1534,  1533,  1535,  1536,  1736,  1537,  1538,  1737,
    1539,  1738,  1540,  1739,  1541,  1542,  1740,  1741,  1543,  1742,
    1544,  1545,  1546,  1547,  1548,  1549,  1550,  1551,  1552,  1743,
    1553,  1554,  1555,  1556,  1744,  1745,  1557,  1558,  1559,  1560,
    1561,  1746,  1562,  1747,  1563,  1564,  1565,  1566,  1567,  1568,
    1569,  1570,  1571,  1572,  1573,  1574,  1575,  1576,  1748,  1577,
    1578,  1579,  1580,  1749,  1581,  1582,  1750,  1583,  1751,  1752,
    1584,  1753,  1754,  1755,  1585,  1586,  1756,  1757,  1587,  1588,
    1589,  1590,  1591,  1592,  1593,  1595,  1594,  1758,  1596,  1597,
    1598,  1599,  1600,  1601,  1759,  1602,  1603,  1604,  1605,  1606,
    1607,  1608,  1609,  1610,  1611,  1612,  1613,  1614,  1615,  1616,
    1760,  1617,  1618,  1619,  1761,  1620,  1621,  1622,  1623,  1762,
    1624,  1625,  1626,  1627,  1628,  1629,  1630,  1631,  1632,  1763,
    1633,  1634,  1635,  1764,  1765,  1636,  1766,  1637,  1638,  1767,
    1639,  1640,  1641,  1642,  1768,  1643,  1644,  1645,  1646,  1647,
    1769,  1770,  1648,  1649,  1650,  1651,  1652,  1653,  1771,  1772,
    1654,  1655,  1656,  1657,  1658,  1659,     0,  1297,  1235,  1234,
    1297,  1260,  1244,  1269,  1262,  1476,  1473,   899,  1474,  1475,
       0,  1477,  1478,  1479,  1480,  1481,  1483,  1482,  1451,     0,
    1785,  1155,  1201,  1200,  1178,  1196,  1449,  1402,  1403,  1173,
    1450,  1447,  1448,  1156,  1781,  1446,  1347,     0,     0,  1309,
    1310,  1313,  1186,  1182,  1312,     0,  1307,  1308,  1130,  1446,
    1438,  1439,  1440,  1441,  1443,  1442,  1444,  1464,  1465,  1466,
    1467,     0,  1264,  1463,  1265,  1445,  1473,  1462,  1468,  1326,
    1129,  1328,  1272,  1282,  1278,  1286,  1281,     0,     0,     0,
       0,  1297,   604,   603,   597,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    13,     0,
     598,   209,  1175,  1174,  1126,  1125,   644,     0,  1121,  1122,
       0,   600,   222,     0,     0,     0,     0,     0,     0,   389,
       0,     0,     0,     0,     0,     0,     0,   233,   232,     0,
     326,     0,   490,     0,     0,   334,     0,     0,     0,  1179,
       0,  1594,  1324,  1325,  1207,  1202,  1626,   692,     0,     0,
       0,     0,   401,     0,   400,     0,     0,   398,     0,   333,
       0,   402,   396,   395,     0,   399,     0,   397,     0,     0,
     601,  1546,  1315,   667,   654,  1485,   425,   429,   420,   426,
     434,   433,   421,   418,   419,  1603,     0,     0,   424,     0,
     415,  1151,  1153,   432,  1152,     0,   456,   469,   463,   467,
     461,   465,   464,   460,   471,   470,   466,   462,   468,     0,
     457,   458,     0,   594,  1122,   615,  1134,   725,     0,     0,
     417,   593,     0,     0,   553,   554,     0,   184,  1619,  1682,
    1637,   180,     0,     0,   602,   731,   729,     0,     0,     0,
    1510,  1565,  1575,  1619,  1682,  1637,   140,     0,   179,  1619,
    1682,  1637,   175,   611,     0,     0,  1273,   596,   595,     0,
       0,   796,   655,   658,   709,     0,   605,     0,     6,  1376,
     653,   649,   728,   728,     0,   728,     0,   705,  1303,  1211,
    1269,  1247,  1215,     0,     0,  1294,  1290,  1287,  1295,  1289,
    1277,   888,   889,   890,   887,   891,   886,     0,  1219,  1226,
    1229,     0,  1237,  1236,  1242,  1303,  1246,  1261,  1788,  1789,
    1350,  1177,  1193,     0,     0,     0,     0,     0,     0,  1185,
    1191,     0,  1183,     0,     0,  1793,  1797,     0,  1795,  1790,
    1263,     0,  1327,  1329,  1284,  1283,  1279,     0,     0,  1393,
       0,     0,  1394,  1395,     0,  1390,  1392,     0,  1303,  1136,
       0,     0,  1449,  1135,  1450,  1447,  1459,  1446,     0,   406,
     405,     0,     0,     0,     0,     0,     0,     0,   312,     0,
     796,     0,   111,     0,     0,  1097,     0,     0,   442,   443,
     448,     0,   445,     0,     0,   444,   446,   447,     0,   449,
     450,     0,   225,     0,     0,     0,     0,   617,   641,   237,
     236,   125,   235,   234,     0,   917,   927,   925,   926,   919,
     920,   921,   924,   922,   923,     0,   918,   503,   134,  1173,
       0,     0,   104,     0,     0,     0,     0,     0,     0,     0,
       0,  1349,  1206,  1306,     0,   803,     0,   368,     0,   632,
       0,   130,     0,     0,     0,     0,   109,   121,     0,   208,
     403,  1323,  1322,  1314,  1321,     0,   422,   431,   430,   428,
     427,   423,  1154,     0,   413,   414,  1333,  1333,  1336,  1338,
     411,  1335,     0,   455,     0,     0,     0,   681,  1123,     0,
       0,   556,   556,   183,   181,     0,     0,     0,     0,     0,
    1660,  1661,   847,  1094,     0,  1451,  1662,  1663,  1664,  1022,
    1102,  1102,  1102,  1665,  1666,  1527,  1667,  1668,  1143,  1669,
     837,  1670,  1671,  1576,  1672,     0,  1144,  1674,  1675,  1585,
       0,  1676,  1677,  1678,  1102,  1680,  1681,  1682,  1683,  1684,
    1685,  1142,     0,  1102,  1686,   928,  1148,  1149,  1048,     0,
       0,  1107,     0,     0,     0,  1042,     0,   831,   833,   834,
     858,   859,   835,   864,   865,   877,   832,     0,   988,     0,
       0,  1106,   932,  1016,  1011,  1048,   716,  1104,  1048,     0,
    1012,  1169,  1168,  1170,  1171,  1167,  1137,  1449,  1455,   836,
    1450,  1447,  1145,  1172,  1781,  1446,     0,     0,     0,     0,
    1383,   186,     0,   187,  1127,  1619,   141,   171,   148,   170,
       0,  1502,   142,     0,     0,     0,   146,   607,     0,     0,
     178,   176,     0,   610,   599,   407,     0,     0,   798,     0,
     797,   657,   654,   703,   702,     5,   660,   727,     0,     0,
       0,     0,     0,     0,     0,   759,   748,  1304,     0,  1298,
       0,  1303,  1297,  1297,  1292,  1291,  1288,     0,     0,     0,
       0,     0,     0,  1161,  1160,  1216,  1218,  1164,     0,  1303,
       0,     0,  1195,     0,  1199,  1197,  1344,  1333,  1345,  1346,
    1189,  1184,  1187,     0,  1180,  1191,  1791,     0,     0,  1794,
    1266,     0,  1165,  1166,  1341,  1330,  1339,  1342,  1285,  1297,
    1401,     0,  1396,  1399,     0,  1391,     0,     0,     0,     0,
       0,   631,     0,     0,     0,     0,   634,     0,     0,     0,
       0,     0,     0,     0,     0,   310,   571,   571,   571,   571,
       0,     0,     0,     0,     0,     0,     0,   111,   105,   108,
    1230,  1099,  1098,  1132,   643,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   369,     0,   840,   875,   875,   875,
     855,   855,   849,   838,   882,   875,   852,   841,     0,   839,
     885,   885,   870,     0,   813,   823,   825,   826,   856,   857,
     827,   862,   863,   824,   899,  1454,   836,  1456,  1453,  1452,
       0,     0,   640,     0,   125,   122,   390,   370,     0,   133,
     132,   338,   337,     0,     0,   371,   103,   111,   312,   305,
       0,     0,     0,  1133,     0,     0,   274,   693,   697,   694,
       0,   695,     0,   678,     0,     0,   208,     0,     0,     0,
       0,     0,   208,   206,   207,     0,   394,  1316,  1319,  1320,
       0,   661,   663,   665,   664,   666,   662,   412,   409,   410,
    1334,     0,  1337,  1773,  1779,     0,     0,  1369,  1373,     0,
    1517,  1541,  1560,  1614,     0,     0,   472,   459,     0,     0,
       0,   669,   672,     0,     0,   679,   416,  1343,   555,   552,
     551,   182,   484,     0,     0,     0,  1044,  1045,   874,   861,
    1093,     0,     0,   869,   868,     0,     0,     0,  1023,     0,
    1025,     0,  1027,     0,   845,   844,   843,  1043,  1052,     0,
     842,   875,   875,   873,   955,     0,     0,   846,     0,     0,
    1071,     0,  1028,  1077,     0,     0,     0,   881,     0,   879,
       0,     0,   987,  1029,     0,  1141,  1048,   935,   936,   937,
     938,  1042,     0,  1049,     0,  1138,     0,     0,   867,     0,
     899,     0,     0,     0,     0,     0,   930,     0,   951,     0,
       0,     0,     0,     0,     0,     0,     0,   968,     0,     0,
     970,     0,     0,     0,   928,   927,   925,   926,   919,   920,
     921,   924,   939,   940,   952,     0,  1096,  1333,     0,   763,
     715,  1095,     0,     0,  1780,  1782,  1380,  1379,  1378,  1377,
    1381,  1382,   188,   189,   185,     0,     0,   150,   149,   174,
     173,     0,   168,   169,   145,     0,   164,   165,     0,   612,
     613,     0,   152,   161,   163,   162,   160,   143,   151,   153,
     157,   158,   159,   144,   177,  1297,     0,     0,   763,  1110,
    1048,   646,     0,   650,   709,   713,   708,   712,   735,   736,
     741,   711,     0,   761,   750,   744,   749,   745,   751,   758,
     707,   747,   706,  1305,  1214,  1303,   813,     0,  1297,  1238,
    1297,  1293,  1222,   893,   894,   895,   896,   898,   897,  1223,
    1220,   892,  1221,  1163,  1162,     0,     0,     0,     0,  1245,
    1192,     0,  1176,  1198,     0,  1190,     0,  1792,  1798,  1796,
       0,   813,  1776,  1397,  1776,   813,   538,     0,   537,     0,
       0,   630,     0,     0,     0,     0,     0,   637,   268,     0,
     205,     0,     0,     0,     0,   511,   513,   512,   506,     0,
     507,     0,   510,   517,   836,     0,     0,     0,     0,     0,
       0,     0,     0,   314,   324,     0,     0,     0,   104,   104,
     311,   570,   198,     0,     0,     0,     0,   569,     0,     0,
       0,     0,     0,     0,   107,   106,   114,   116,     0,   115,
     117,     0,     0,     0,   110,  1100,     0,     0,     0,     0,
       0,     0,     0,   224,   212,   211,     0,     0,   375,   378,
       0,   813,     0,     0,     0,   807,   888,   887,   886,     0,
     828,   830,     0,   629,   629,   629,   629,   616,   618,   248,
     123,     0,     0,   124,     0,     0,   238,   135,   137,   138,
     139,   343,   342,   344,     0,   339,     0,   372,   102,   309,
       0,   240,     0,     0,     0,     0,     0,   572,     0,     0,
       0,     0,     0,   696,   802,     0,     0,   535,     0,     0,
       0,   540,   208,   208,   120,   332,   404,  1317,  1318,   692,
     408,     0,     0,  1778,     0,     0,     0,     0,     0,   475,
     474,   486,     0,   476,   477,   473,     0,   671,     0,     0,
     676,  1048,     0,   688,     0,   686,     0,  1124,     0,  1049,
       0,     0,     0,  1055,     0,     0,  1092,  1089,     0,     0,
    1049,     0,  1101,     0,     0,     0,  1062,  1063,  1064,  1061,
    1065,  1060,     0,     0,  1066,  1059,     0,   872,   871,     0,
       0,     0,   544,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   989,     0,   911,     0,  1049,  1049,  1076,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1049,
    1082,     0,     0,  1013,   912,  1048,     0,     0,     0,     0,
    1139,   900,     0,     0,   905,     0,     0,     0,     0,   907,
     916,   914,   915,     0,   903,   904,     0,   933,   953,  1105,
       0,     0,   960,     0,  1083,   983,     0,   974,     0,   969,
       0,   972,   976,   956,     0,     0,     0,     0,     0,     0,
     954,     0,   949,   947,   948,   941,   942,   943,   944,   945,
     946,   950,     0,  1542,  1565,     0,   726,   726,   714,   724,
    1103,     0,   803,     0,     0,     0,  1017,     0,  1784,  1783,
    1128,     0,     0,   899,     0,   156,   606,     0,     0,   813,
     799,     0,  1048,     0,   803,     0,   648,   647,     0,     0,
     739,   740,     0,   757,     0,   756,     0,     0,     0,  1299,
    1301,  1212,  1268,  1239,  1271,  1217,  1259,     0,  1243,  1194,
    1188,     0,  1340,  1387,     0,  1777,     0,     0,     0,   558,
     559,     0,     0,     0,     0,     0,   208,   635,   639,   204,
     636,   505,     0,   509,   830,     0,   128,   129,   561,   562,
       0,  1131,   564,   313,   323,     0,   317,   318,   315,   319,
     320,     0,     0,   191,     0,     0,   208,   208,     0,   568,
     200,   203,   201,   202,     0,   567,     0,   112,   113,     0,
       0,     0,     0,   452,   441,   451,     0,     0,   435,   214,
     215,   227,   213,   374,     0,     0,     0,     0,   808,     0,
       0,   813,     0,     0,   821,   814,   822,     0,     0,     0,
       0,   628,     0,     0,     0,     0,   619,   633,   127,   126,
       0,   136,     0,     0,     0,     0,     0,   804,     0,     0,
       0,     0,   239,   241,   243,   244,   245,     0,   307,   308,
     302,     0,     0,   493,     0,     0,     0,   276,   277,     0,
     698,   699,     0,   208,     0,   208,     0,   208,     0,   592,
     366,     0,  1332,  1774,  1331,  1371,  1375,     0,  1374,  1370,
    1352,  1351,     0,   488,     0,   483,   478,   480,  1120,  1119,
       0,  1118,     0,     0,   677,   689,   682,   684,   683,     0,
       0,   680,     0,   730,     0,  1057,  1058,     0,     0,     0,
       0,  1088,     0,     0,  1087,     0,  1041,  1024,  1026,   854,
       0,  1031,     0,   848,     0,   851,     0,   929,     0,     0,
       0,  1032,   991,   992,   993,     0,  1006,     0,     0,     0,
       0,   928,     0,     0,     0,     0,     0,     0,     0,   994,
     995,  1007,  1033,   909,   910,     0,     0,  1074,  1075,  1034,
     883,   884,   885,   885,     0,     0,  1081,     0,     0,     0,
    1039,  1048,     0,  1015,  1048,   913,   876,   877,     0,     0,
     906,   901,     0,   902,     0,     0,     0,     0,     0,   975,
     971,     0,   973,   977,     0,     0,     0,   962,   984,   958,
       0,     0,   964,     0,   985,   726,   726,   726,   726,   723,
       0,     0,     0,   773,   762,   765,   775,   766,   768,  1126,
       0,   753,     0,     0,  1021,  1018,   147,     0,   166,   155,
     608,   609,   154,  1387,     0,  1111,  1108,   690,     0,   659,
     737,   738,   760,   742,   746,   743,     0,  1300,  1231,  1204,
    1386,  1389,  1400,  1398,  1241,     0,     0,   267,     0,     0,
       0,   638,   508,     0,   560,     0,   316,   322,   321,   248,
       0,     0,   192,   199,   197,     0,     0,   118,   119,     0,
     437,     0,     0,     0,   228,   104,     0,   376,  1585,   920,
     377,   379,   516,   380,   381,     0,     0,     0,     0,   811,
       0,     0,     0,     0,     0,     0,   813,   899,     0,   625,
    1157,  1158,   624,  1159,   621,   620,   627,   626,   623,   622,
       0,     0,     0,   259,     0,     0,   253,     0,     0,   254,
     247,   250,   251,     0,   131,     0,   346,   340,   373,     0,
     806,   240,   266,   294,     0,   304,     0,     0,   331,   329,
     328,  1129,     0,     0,     0,     0,     0,   273,     0,   614,
     691,  1205,   536,   208,   393,   542,   539,   543,   541,   697,
       0,     0,   487,   481,     0,     0,   453,   670,     0,     0,
     674,   675,   687,   685,   208,  1050,  1056,   860,     0,  1091,
    1085,     0,     0,     0,  1051,     0,     0,   545,  1069,  1068,
     990,  1070,     0,     0,     0,  1005,  1004,  1002,  1003,   996,
     997,   998,   999,  1000,  1001,  1079,  1078,  1072,  1073,   880,
     878,     0,  1036,  1037,  1038,  1080,  1046,     0,  1014,   866,
     899,   908,   931,   934,   981,   961,  1084,   978,     0,  1054,
       0,   957,     0,     0,     0,   966,   929,     0,     0,     0,
       0,     0,     0,   718,   717,   773,     0,   775,     0,   774,
     787,     0,     0,   793,   791,     0,   793,     0,   793,     0,
       0,   767,     0,   769,   787,     0,     0,   755,  1019,  1020,
       0,  1385,     0,     0,  1116,  1115,  1302,     0,  1181,     0,
     269,     0,     0,   270,   518,     0,   246,     0,     0,     0,
       0,   565,   566,     0,     0,   440,   439,   217,     0,   363,
       0,     0,   367,   358,   360,     0,     0,     0,   809,   815,
     816,   817,   818,   819,   820,   812,   829,   356,     0,     0,
     257,   261,   262,   260,   252,   255,   274,     0,     0,   348,
       0,     0,   805,     0,     0,     0,   263,     0,   297,   242,
     306,   308,   303,     0,   325,     0,   492,     0,     0,     0,
       0,   523,     0,     0,     0,   524,   528,   525,   534,   519,
     588,   589,   586,   587,     0,   275,   550,     0,  1372,  1354,
    1355,  1356,  1357,  1358,  1359,  1360,  1361,  1362,  1363,  1365,
    1366,  1367,  1364,  1368,  1353,     0,   479,  1117,     0,   454,
    1090,  1030,  1040,   853,  1086,   850,  1067,     0,     0,     0,
    1035,  1048,  1140,     0,   979,     0,   982,   963,   959,     0,
     965,   986,   722,   721,   720,   719,   777,   785,     0,   764,
       0,   792,   788,     0,   789,     0,     0,   790,   779,     0,
       0,   785,     0,   800,     0,     0,     0,   710,   899,     0,
    1112,  1203,   557,     0,   271,   563,   193,   194,   195,   196,
     436,   438,   210,   226,   365,   364,   362,   359,   361,   810,
       0,   549,     0,     0,     0,     0,   249,   280,     0,   240,
     347,     0,     0,   341,   297,   265,   264,     0,     0,     0,
     301,   330,     0,     0,     0,   494,   501,     0,  1132,   521,
     514,     0,     0,   522,     0,   531,   532,     0,   520,   502,
       0,     0,   482,     0,  1008,     0,     0,  1047,   980,  1053,
     967,   776,     0,     0,   778,     0,     0,   781,   783,     0,
       0,     0,     0,     0,  1129,   801,   752,   754,   167,  1113,
       0,     0,   218,   641,   641,   219,   216,   549,     0,   547,
     357,     0,   256,     0,   285,     0,   349,   350,   345,     0,
     301,     0,   295,   296,     0,   230,   642,     0,   803,     0,
       0,   499,   496,     0,     0,     0,   529,   530,     0,   533,
     803,   673,     0,  1009,     0,   786,   795,     0,   782,   780,
     770,     0,   772,     0,  1109,   274,     0,     0,   546,   548,
       0,   278,   279,     0,   258,   281,   282,     0,     0,   231,
     293,     0,   501,   489,   495,   500,     0,   515,   526,     0,
       0,  1010,   784,     0,   771,  1114,   280,   220,   221,     0,
       0,     0,     0,   283,     0,   284,     0,     0,     0,   382,
     383,   353,     0,   298,     0,   498,   501,   527,   591,   794,
     285,     0,   290,     0,   289,     0,   286,   287,     0,     0,
     388,     0,     0,   351,   354,   355,   299,   300,   497,   590,
       0,     0,     0,   288,   291,   292,     0,   392,   384,   335,
       0,   574,   585,   573,   575,   583,   580,   582,   581,   579,
     272,     0,   387,   391,     0,   385,   352,     0,   584,   578,
     709,   700,     0,     0,   576,   585,   353,   392,   577,     0,
     386,   336
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short yydefgoto[] =
{
      -1,     1,     2,    68,   222,   223,   224,  1387,   225,   226,
     227,  1318,  1754,  1036,   228,  1375,  1793,   229,   230,   231,
    1378,  1380,  1797,   232,   836,  1607,  1608,  2016,  1609,  1610,
    1594,  1188,  1588,   233,   234,   235,  1182,  1584,   236,   237,
    1296,  1416,   238,   239,  1766,  2121,  2782,  2866,   703,  1332,
    2405,  2406,   240,   724,  2161,  2162,  2163,  2164,  2147,  2450,
    2451,  2452,  2165,  2666,  2166,  1698,  1819,  2176,  2177,  2874,
    2924,  2925,  2926,  2976,  2668,  2810,  2885,   241,  2467,  1812,
    2167,  2168,   242,   243,  1305,  1730,  2085,   244,   725,  2468,
    2674,   245,   758,   246,  1383,  1804,  1805,  2660,  2801,  2878,
    2982,  2983,  2793,  2632,  2633,  2634,   247,   248,   249,   250,
    1807,  1334,  1767,  1768,  2410,   251,  2959,  2960,   726,  3015,
     252,   253,   759,  1039,  2891,   254,   255,   777,   778,   779,
     256,   981,  2114,   257,   258,   799,   800,   801,  1445,  2205,
    2206,  2496,   823,  1850,  1851,   259,   727,  2474,  2814,  2815,
    2892,   260,   728,  1298,  1709,  1710,  1711,  2819,  2411,  1712,
    2688,  2689,  2829,   261,   262,  1687,   263,  1830,  1901,   264,
    2869,   265,   266,   816,  1459,   267,  2098,  1733,   268,  2175,
    3003,  3017,  3018,  3019,  2694,  2990,   269,  3005,   271,   272,
     273,   690,  1196,  1204,  1197,   274,   275,   276,  1787,  1788,
    2142,   277,   278,   279,   280,  1373,   281,   282,   283,   284,
     285,   861,   853,  1212,  1623,   286,  1421,   764,  3006,  1451,
    1859,  1860,  3007,   289,  1455,  1866,  3008,   291,  1024,  1822,
    3009,  1135,   294,   295,   296,  1569,  1998,   808,  1218,   827,
     866,   867,  1628,  1629,  1225,  1642,  1635,  1637,  2597,  2767,
    1226,  1640,  2035,  2002,  2334,  2335,  2336,  2579,  2590,  2752,
    2847,  2337,  2338,  1403,  2156,  2157,  1713,  1775,  2133,  1354,
    1136,  1137,  1138,  1490,  1497,  1484,  1357,  1139,  1140,  1141,
    1360,  1142,  1143,  1144,  1145,  1469,  1528,  1146,  1147,  1507,
     888,  1148,  1149,  1522,  1956,  1536,  1006,  1150,  1565,  1869,
    1911,  1152,  1515,  1524,  1892,  2560,  1872,  1467,  1893,  1905,
    2250,  1913,  1919,  2277,  2278,  1931,  1965,  1153,  1876,  1877,
    2232,  1471,  1154,  1155,   965,  1478,  1156,  2209,  1618,  2021,
    2860,  1619,  2210,  2211,  1158,  1446,   851,  2843,  1184,   632,
    2080,  2816,   697,   805,  1159,  1160,  1161,  1162,  1163,  1164,
    1165,  2135,   783,   633,  2432,  1273,  1611,  1166,   613,   698,
     297,   634,   635,   909,   910,  1261,  1264,  1252,  1672,   614,
     615,   733,  2608,   298,   299,   300,   301,   302,  1231,   868,
    1246,  1666,   889,   303,    72,    77,    73,   890,   586,   587,
    1648,   304,   671,  1649,  1249,   895,   590,   306,   307,   591,
     592,   309,   652,   593,   873,   311,   874,   594,   313,   314,
     315,   880,   316,  1228,  1229,  2367,  1230,   317,   318,   636,
     637,   319,  1044,  1417,  1043,   734,   320,   321,   922,   923,
    1058,  1059,  1431,  1060,  1061,  1275,  1276,   322,   323,   628,
     324,   325,  1437,  2201,  2195,  2714,  1438,  2196,   326,   327,
     328,   329,  1578,   330,   331,   845,  2371,   332,   667,   333,
     935,   616,   617,   618,  1168,   654,   804,  1169,   943,   655,
     596,   597,   620,   621,   622,   946,   599,  1432,    74,  2054,
    1433,  1172,  1173,  1574,  1174,   625,   900,   915,   916,  2055,
     918,    75,   919
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -2713
static const int yypact[] =
{
   -2713,   285,  9983, -2713, -2713, -2713, -2713, -2713, -2713, -2713,
   -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713,
   -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713,
   -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713,
   -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713,
   -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713,
   -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713,
   -2713, -2713, -2713, -2713, 14591, -2713, -2713, 39644,   276, -2713,
   -2713, -2713, 34678, -2713, -2713, -2713, -2713, -2713,   151, 33914,
   13440, -2713, 47645, -2713, -2713, -2713, -2713, -2713, -2713, -2713,
   -2713, -2713, 47645, -2713, -2713, -2713, -2713, -2713, -2713, -2713,
   -2713, -2713, -2713, 33533,   585, -2713, -2713,   140, -2713, -2713,
   -2713, -2713, -2713, -2713, -2713,   -80,  1968, -2713, -2713, 36206,
   -2713,   178, -2713, -2713, -2713, -2713, -2713, -2713, 47645, 43454,
   -2713,   101,   -80, -2713,   433,  7483, -2713, 36206, 36588, -2713,
   -2713, 48026,   387, -2713,  2635,   -80, 36970, -2713,   188, -2713,
   31232, -2713, -2713, -2713,   582,  2261, -2713, -2713, -2713,   392,
   -2713, -2713, -2713, -2713, -2713, -2713, -2713, 43454,   746,   317,
   31614, -2713, -2713, -2713, 43454, -2713, -2713, -2713, -2713, -2713,
   -2713, 37352, -2713,   384, 44216,   503, -2713,   -80, -2713,   146,
   33151, -2713, 44597, -2713, -2713,   361, -2713, -2713, -2713, -2713,
   -2713,   317, -2713, 33533, 29690, 42311,   682, -2713, -2713, -2713,
   -2713,   -89,  6860,   534, -2713, -2713, -2713, -2713, -2713, -2713,
   -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713,
   -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713,
   -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713,
   -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713,
   -2713, -2713, -2713,   807, -2713, -2713, -2713, -2713, -2713, -2713,
   -2713, -2713, -2713, -2713, -2713,   610, -2713, -2713, -2713, -2713,
   -2713, -2713, -2713,    11, -2713,   719,    99, -2713, -2713, -2713,
   -2713, -2713, -2713, -2713, -2713, 49169,   975, -2713, -2713, -2713,
     581, -2713,   642, -2713, -2713, -2713,   795, -2713, -2713, -2713,
   -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713,
   -2713, -2713, -2713, -2713, -2713,  1094, -2713, -2713, -2713, -2713,
   -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713,
   -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713,
   -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713,
   -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713,
   -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713,
   -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713,
   -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713,
   -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713,
   -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713,
   -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713,
   -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713,
   -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713,
   -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713,
   -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713,
   -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713,
   -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713,
   -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713,
   -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713,
   -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713,
   -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713,
   -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713,
   -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713,
   -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713,
   -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713,
   -2713, -2713, -2713, -2713, -2713, -2713,  1027, 40025, -2713, -2713,
   40787, -2713, -2713,   683,   642, -2713,   701,   687, -2713, -2713,
   37352, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, 35060,
   -2713, -2713, -2713, -2713, -2713,    62, -2713, -2713, -2713, -2713,
   -2713, -2713, -2713, -2713, -2713, -2713, -2713, 47645, 47645, -2713,
   -2713, -2713,   739, -2713, -2713,   782, -2713, -2713, -2713,   819,
   -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713,
   -2713, 12589, -2713, -2713,   802, -2713, -2713, -2713, -2713, -2713,
   -2713,   858, -2713,   318,  1034, -2713, -2713, 33533,  1422,  1422,
    1220, 40787, -2713, -2713, -2713, 41168, 43454, 47645, 43454, 41168,
   47645, 47645,  1177, 47645, 43454, 42311, 47645, 47645, -2713,  1277,
   -2713, -2713, -2713, -2713, -2713,   913, -2713,  1065, -2713,  1113,
    1697, -2713, -2713, 43454, 41168, 47645,   994,  1043, 47645, -2713,
   43454,   920, 47645,   942,   282,  1115, 47645, -2713, -2713, 47645,
   -2713, 43454, -2713, 47645,   520,  1118,  1316,  1234,   414, -2713,
   37352, 37352, -2713, -2713, -2713, -2713,   827, -2713, 42311, 41168,
   47645,  1035, -2713, 47645, -2713, 41168, 47645, -2713,   501, -2713,
   47645, -2713, -2713, -2713, 47645, -2713, 47645, -2713,  1237, 43454,
   -2713,   567, -2713, -2713,   610,   892, -2713,    61,   345,   704,
   -2713, -2713,   349,   351,   434,   892,   613, 43835, -2713, 47645,
      18, -2713, -2713, -2713, -2713, 37352,  1184, -2713, -2713, -2713,
   -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713,  1225,
    1070, -2713, 43454, -2713, -2713, -2713, -2713, -2713, 43454,   676,
   -2713, -2713,  1356, 47645, -2713, -2713, 43454, -2713,  1401,  1122,
    1330, -2713,  1293,  2261, -2713, -2713,  1350, 17845,   -79, 31996,
   44978, 48407,    16, 45359,  1257,    31, -2713,  -104, -2713,  1542,
    1266,  1431, -2713,    31, 43454, 33533, -2713, -2713, -2713, 26580,
    1341,  1273, -2713,  1486,  1285,  1292,   -80,  1275, -2713, -2713,
   -2713, 43454,  1619,  1619,  1617,  1619,    60,   754,  1347, -2713,
   -2713, -2713, -2713,  1340,  1358, -2713,   536,  1517, -2713, -2713,
   -2713,  1415,  1429,  1439,  1447, -2713,  1450,  1044, -2713, -2713,
   -2713,  1575, -2713, -2713, -2713,  1347, -2713, -2713, -2713, -2713,
   -2713, -2713,  1703,  1700, 36206, 36206,  1448,   340, 32767, -2713,
    1398,   739, -2713, 16557, 12589, -2713, 24228,   647, -2713, -2713,
   -2713,  1252, -2713, -2713,  1609, -2713, -2713,  1605, 47645, -2713,
    1495, 47645, -2713, -2713, 48788, -2713, -2713,  1422,  1347, -2713,
     913,  1434,  1440, -2713,  1441,  1443, -2713,  1444,  1549, -2713,
    1445,   905,   100,  1452,   485,  1567, 43454,  1568, -2713,   197,
      96,  1601,   679,  1458, 30071, -2713, 43454, 41168, -2713, -2713,
   -2713, 41168, -2713,  1892, 47645, -2713, -2713, -2713, 47645, -2713,
   -2713, 47645,  1497,  1463,  1757, 38881, 47645,  1501,  1785, -2713,
   -2713,  1504, -2713, -2713, 43454, -2713, -2713, -2713, -2713, -2713,
   -2713, -2713, -2713, -2713, -2713,  1463, -2713, -2713, 47645,    29,
     190,    28,  1505, 43454, 43454,  1657, 43454, 47645, 41168, 47645,
   43454, -2713, -2713, -2713,   848,  1510,  1480, -2713, 38881, -2713,
    1452, -2713, 43454,  1482,  1625,  1626,  1481, -2713,   746,    23,
   -2713, -2713, -2713, -2713,   383,   594, -2713, -2713, -2713, -2713,
   -2713, -2713, -2713, 47645,    18,    18,    88,  1853, -2713, -2713,
   -2713, -2713,    75, -2713, 42692,  2019,    65,    -8, -2713, 47645,
     567,  1715,  1715, -2713, -2713,  1670,  1719,  1638,  1502,   595,
     839,   784, -2713, 20269,  1506,    25,    25,  1507,  1508, -2713,
    1509,  1511,  1512,   689,   689,  1628,  1518,  1521, -2713,   794,
   -2713,   912,   952,  1061,    25, 20269, -2713,  1525,   969,  1526,
    1530,  1537,   940,  1545,  1512,   968,  1548,   803,  1064,  1550,
    1552, -2713,  1518,  1512,    34, -2713, -2713, -2713,   467, 20269,
   20269, -2713, 20269, 20269, 18249, -2713,   746, -2713, -2713, -2713,
   -2713, -2713, -2713, -2713, -2713,    38, -2713,  1011, -2713,  2407,
   20269,  7409, -2713, -2713, -2713,   864,   174, -2713,   467,  1553,
   -2713, -2713, -2713, -2713, -2713, -2713, -2713,  1020, -2713, -2713,
    1102,  1161, -2713, -2713,    76,  1171,   859,   859, 35442, 35442,
   -2713, -2713,   451,  1499, -2713,   172, -2713, -2713, -2713, -2713,
   35824,  1855, -2713,  1128,  1722,   378, -2713,  1735, 30452, 30452,
   -2713, -2713,  1732, -2713, -2713, -2713,  1743, 43454, -2713, 27738,
   -2713, -2713,   610, -2713, -2713, -2713,  1556, -2713,   -89,   -89,
   20269,   -89,   -57, 18653, 20269,  1783,   539,  1566,  1197, -2713,
   49535,  1347, 40406, 40406,  1754, -2713, -2713,    55,     3,  1659,
    1726,   744,   980, -2713, -2713, -2713,  1559, -2713,  1825,  1347,
    1243, 36206,  1612, 36206, -2713, -2713, -2713,  1853, -2713, -2713,
   -2713, -2713,  1569,   613, -2713,  1398, -2713, 16632,   816, -2713,
   -2713, 12589, -2713, -2713, -2713, -2713,  1562, -2713, -2713, 40787,
    1570, 47645, -2713,  1574,  1576, -2713, 49535, 29309,  1639,  1641,
   48407, -2713,   272,   696,  1643,    42, -2713, 16192,  1690,  1630,
    1637,  1645,  1664,  1647,  1665,  1658,   574,  1876,  1037,  1876,
    1636,  1736,  1669,  1673, 42311,  1674, 48407, -2713,  1477, -2713,
   -2713, -2713,   913, -2713, -2713,  1611,  1452,  1613,    41,  1753,
    1802,  1758,    14, 33533, -2713,  1616, -2713,  1660,  1660,  1660,
    1618,  1618,  1620, -2713, -2713,  1660,  1623, -2713, 39263, -2713,
     612,   630, -2713,  1934,    48, -2713, -2713, -2713, -2713, -2713,
   -2713, -2713, -2713, -2713,  1212, -2713,   913, -2713, -2713, -2713,
    1948,   499, -2713, 38881, -2713,   571,  1886, -2713,  1939, -2713,
     395, -2713, -2713,    32,  1631, -2713, -2713, -2713, -2713,   385,
   36206,  1856,  1773, -2713,  1452,  1949,  1633, -2713,   989, -2713,
    1733, -2713, 20269, -2713, 29309,  1952,   139,  1683, 37735, 43454,
   43454, 47645,   139, -2713, -2713, 43454, -2713, -2713,  1831,   858,
   47645, -2713, -2713, -2713, -2713, -2713, -2713,    18, -2713, -2713,
   -2713,  2032,  1644, -2713,    76,  2034,   613, -2713,  1646,  1662,
   47645, 41168, 47645, 47645, 43454,  1711,  1648, -2713,  1694,  1655,
   27352, -2713, -2713,   128, 43454, -2713, -2713, -2713, -2713, -2713,
   -2713, -2713, -2713, 42692, 20269, 19057, -2713, -2713, -2713,  1656,
    9339,  1692, 20269, -2713, -2713, 20269, 20269,   648, -2713,   648,
   -2713,  1661, -2713,   613, -2713, -2713, -2713, -2713,  1544,   613,
   -2713,  1660,  1660, -2713,  1595, 20269,   613, -2713, 28909, 20269,
   20673, 15382, -2713, 20269,  1725,  1729,   613, -2713,   613, -2713,
   20269, 17037, -2713, -2713, 20269, -2713,  1666,  1995,  1995,    54,
     918,   800,  1672,  3221,  1671, -2713,  1755,   613, -2713,   613,
    1173,  1518,   713,  1873,  1676,   -49, -2713,    78,   150, 38881,
   20269, 33533,  1737, 20673, 20269,  1678,  1271, -2713, 20269,   685,
   -2713,  1679, 20269,  1734,    84, 20269, 20269, 20269, 20269, 20269,
   20269, 20269, 22275, 22679, 21077,    90, -2713, 34296, 17845,  1904,
   -2713, -2713, 14977, 37352, -2713, -2713, -2713, -2713, -2713, -2713,
   -2713, -2713, -2713, -2713, -2713, 47645,  1855, -2713, -2713, -2713,
   -2713,  1745, -2713, -2713, -2713,  1178, -2713, -2713,   377, -2713,
   -2713,  1863, -2713, -2713, -2713, -2713, -2713, -2713,  1680, -2713,
   -2713, -2713, -2713, -2713, -2713, 40787,  1688, 47645,   -25, -2713,
    1666, 41930, 47645, -2713, -2713,  1882, -2713, -2713,  1687, -2713,
    3191,  1882,  1835,  1842, -2713,   -45,  9339,  1874,  9339, -2713,
   -2713, -2713, -2713, -2713, -2713,  1347,  1702,  1276, 13823, -2713,
   14207, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713,
   -2713, -2713, -2713, -2713, -2713,  1044,  1705,  2075,  1355, -2713,
   -2713, 36206, -2713, -2713, 32767, -2713,  1720, -2713, -2713, -2713,
    1252,  1702, 12589, -2713, 12589,  1702, -2713,  1718, -2713, 47645,
   47645, -2713,  1716, 47645,  1912,  1913,  1730, -2713, -2713, 47645,
   -2713,  1883, 47645, 20269,  1899, -2713,    97,   218, -2713,   693,
   -2713, 38881, -2713, -2713,   913,  1816, 47645, 47645, 47645, 47645,
   47645, 47645,  1044, -2713,  2054,  1044,  1044,   728,  1505,  1505,
   -2713, -2713, -2713, 47645, 47645, 47645, 47645, 47645,  1898, 47645,
    1827, 47645,  1867, 47645, -2713,  1477, -2713, -2713,  1973, -2713,
   -2713,  1784,   613,  1809, -2713, -2713, 29309,  1950, 37735,   -30,
   43454, 43454,   -30, -2713, -2713, -2713,   786,   694, -2713,  1776,
   20269,    85, 38881,  1766, 25789, -2713,  1833, -2713,  1837,   613,
   -2713, -2713,    32,  1787,  1787,  1787,  1787,   499, -2713, -2713,
     571,   613, 47645, -2713,  1997, 47645,  1024, -2713, -2713, -2713,
   -2713, -2713, -2713, -2713,  1916,  1914, 47645, -2713,  1477,  1658,
   43454, 41549,  2093,  1994,   746, 43454,  1887, -2713, 47645,  2100,
    1999,  2000,  2015, -2713,  9339,  1791, 38881, -2713, 47645,  1788,
    1792,  1789,   139,   139, -2713, -2713, -2713, -2713, -2713, -2713,
   -2713, 37352,   819, -2713, 37352,   819,   819,   819,  2192,  1499,
    1793, -2713,  1452,  1499,  1499,  1648, 45740, -2713, 17441,   727,
   -2713,  1666,    67, -2713,   370,   -43,  1963, -2713,  2023,  9339,
     749,  -132,   298, -2713,   613, 20269,     2, -2713,  7689,   774,
    7844,   828, -2713,  1797,  1803,   880, -2713, -2713, -2713, -2713,
   -2713, -2713,  1804,  2029, -2713, -2713,  1812, -2713, -2713,   176,
     891,  1814, -2713,  1815,  7980,  1817, 20673, 20673, 20673, 18249,
   20673,   850, -2713,  1819, -2713,  1820,  3597,  3783,  1818,  1826,
    1858,  1860,  1834,  1839,  8196, 19461, 20269, 19461, 19461,  8243,
    1818,  1840,  2471, -2713, -2713,   467, 20269, 47645,  1843,  1847,
   -2713, -2713,  2047,  1977, -2713,  1518, 28909,  1545, 20269, -2713,
   -2713, -2713, -2713, 18249, -2713, -2713,  1518, -2713,  1595, -2713,
    1865,    81,  2249, 18249, -2713, -2713,  2072, -2713,   861, -2713,
    1854, -2713, -2713,  2845, 20673, 20269,  1678, 20269,  1917, 28909,
    5257, 20269,  3069,  6397,  6397,   142,   142,    54,    54,    54,
     918,   150,  1857,  1080,  1097, 43454,  4719,  4768, -2713, -2713,
   -2713, 25017,  1510, 20269, 20269,  1851, -2713,   932, -2713, -2713,
   -2713,    31,   613,  1173,  2136, -2713,  1978,   377, 30842,  1702,
   -2713,  1871,  1666, 47645,  1510,  1889, -2713, -2713,   933, 20269,
   -2713, -2713,  1872, -2713, 47645, -2713, 20269, 20269, 18653, -2713,
    1891, -2713, -2713, -2713, -2713, -2713, -2713,  1879, -2713, -2713,
   -2713, 47645, -2713,  2246,  1893,  1890,  1894,  1895,  2002, -2713,
   -2713, 20269,   333,  1900,  1902, 47645,   139, -2713, -2713,  9339,
   -2713, -2713, 38117, -2713,  1908, 47645,  1481,  1481, -2713, -2713,
    2009, -2713, -2713, -2713, -2713,  1044, -2713, -2713, -2713, -2713,
   -2713,  1044,  1044, -2713, 38881,    64,   139,   139,  1969, -2713,
   -2713, -2713, -2713, -2713,  1974, -2713, 47645, -2713, -2713,  1784,
    1910,   -30,  1911, -2713, -2713, -2713,  2101,  2102, -2713, -2713,
   -2713,   115, -2713, -2713, 33533, 28510,  4141,  1920, -2713,  1921,
     613,  1702, 26192,  1188, -2713, -2713, -2713,     5,  2080,  1923,
    2062, -2713,   143,    30, 46121, 46502, -2713,  1852, -2713,  1481,
    1980, -2713,  2001,  1964, 43454,    32,   964, -2713, 38881,  1929,
   43454,  1930,  1926, -2713, -2713, -2713, -2713,   985, -2713, 38881,
   -2713, 43454,  1998,  1979, 38881,  2074,   991, -2713, -2713,   -89,
   -2713, -2713, 26966,   139,  1936,   139, 38881,   139, 38499, -2713,
   -2713,   921, -2713, -2713, -2713, -2713,  1938,  1953,  1938, -2713,
   -2713, -2713, 41168, -2713, 47645,  -105, -2713, -2713, -2713, -2713,
    1055, -2713,   450, 47645, -2713, -2713, -2713, -2713, -2713,  2179,
    2182, -2713, 45740, -2713, 20269, -2713, -2713,  1954,  1945,  9023,
   20269, -2713,  2187, 38881, -2713, 43454, -2713, -2713, -2713, -2713,
     613, -2713, 20269, -2713, 20269, -2713,   613, -2713, 28909, 20269,
    2169, -2713,  2280,    46,  2280,  3221,   984, 38881, 20673,   389,
    1526, 21871, 20673, 20673, 20673, 20673, 20673, 20673, 20673, 23069,
   23473, -2713, -2713, -2713, -2713, 20269, 20269,  2180,  2169, -2713,
   -2713, -2713,  1342,  1342, 38881,  1956,  1818,  1957,  1958, 20269,
   -2713,  1666, 20269, -2713,  1666,  1540, -2713,  2245,   746,   -49,
   -2713, -2713,  1960, -2713, 21481, 20673, 20269,  1074, 20269, -2713,
   -2713,  1955, -2713, -2713, 38881, 20269,  1311,  2952, -2713,  2996,
   20269,  1961,  5345, 18249, -2713,   317,   317,   317,   317, -2713,
   43454, 43454, 24631, 46883,  1965,  1203, -2713, 46883, 47264,  1966,
    1967,  2178,  1087,  1091, -2713, -2713, -2713,  1975, -2713, -2713,
   -2713, -2713, -2713,  2246,  1983,  1971, -2713, -2713, 19865, -2713,
   -2713, -2713,  1499, -2713, -2713, -2713, 12589, -2713, -2713,  2003,
   -2713, -2713, -2713, -2713, -2713,  2038,  4358, -2713, 47645, 47645,
    1107, -2713, -2713,  2033, -2713,  2039, -2713, -2713, -2713, -2713,
      66,   386, -2713, -2713, -2713, 47645, 47645,  1481, -2713,  2166,
   -2713,  2170,   -30,   -30, -2713,  1505,  2232, -2713,  1676,   980,
   -2713, -2713, -2713, -2713, -2713,   511,   613,  1399,  1984, -2713,
    1418, 26192, 26192, 26192, 26192, 26192,  1702,  1173, 43454, -2713,
   -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713,
    1985, 47645, 20673, -2713,   508,    79, -2713,  2168, 43454, -2713,
   -2713, -2713, -2713, 38881,   395, 43454,  2215,  2129, -2713, 47645,
   -2713, 41549,   486,  2195, 41549, -2713, 47645,   -89,  2183, -2713,
   -2713,  1445,   746, 47645,  1996,  1451,   447, -2713, 47645, -2713,
   -2713, -2713, -2713,   139, -2713, -2713, -2713, -2713, -2713,   989,
     819,   314, -2713, -2713,  2211, 45740, -2713, -2713, 17441,  2004,
   -2713, -2713, -2713, -2713,    24,  9339, -2713, -2713, 20269,  9339,
   -2713,  2006,  2008,  2016,  9339,  5933,  2017, -2713,  9339,  2180,
   -2713,   646,  2222,  2148,  2005,   984,   646,  1057,  1057,   120,
     120,    46,    46,    46,  2280,  9339,  9339, -2713, -2713, -2713,
   -2713,  2018, -2713, -2713, -2713,  1818, -2713,  2496, -2713, -2713,
    1173, -2713, -2713, -2713,   411,  3770, -2713,   235, 38881, -2713,
    1109,  3770, 20673, 20269, 20269,  6733,   102, 20269,  6129, 43454,
   43454, 43454, 43454, -2713, -2713, 23863,  1203,  2020, 47645, -2713,
    2025, 25017,  2188,  2154, -2713, 25017,  2154,   966,  2154, 25017,
    2212, -2713, 28124, -2713,  2028, 15787,  2330,  2244, -2713, -2713,
     746, -2713,  2035, 47645, -2713,  9339, -2713, 47645, -2713, 47645,
   -2713,  1120,  1137, -2713, -2713, 47645,  1852,  2181,  2186,   613,
   47645, -2713, -2713,   -30,   -30, -2713, -2713, -2713,   746, -2713,
     663,  2289, -2713,  2241,   110,  2045,  2264,  2266, -2713, -2713,
    1427,  1427, -2713, -2713, -2713, -2713, -2713,  2269, 20269,   654,
     646, -2713, -2713, -2713, -2713, -2713,  1633,  2094,   394,  2293,
    2286,    32, -2713,  2051,  2312,  2313, -2713,  2057,  1404, -2713,
   -2713, -2713, -2713,   746, -2713,  2279, -2713, 25403,   746,  2200,
    2155, -2713, 36206,  2213,   675, -2713, -2713, -2713,  1017, -2713,
   -2713, -2713, -2713, -2713,  2127, -2713, -2713,  2296, -2713, -2713,
   -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713,
   -2713, -2713, -2713, -2713, -2713,  2205, -2713, -2713, 17441, -2713,
    9339, -2713, -2713, -2713, -2713, -2713, -2713, 20673,  2071, 20673,
   -2713,  1666, -2713,  1150, -2713, 38881,   411,  3770,  3770, 20269,
    3770, -2713, -2713, -2713, -2713, -2713, 46883,  2073, 47645,  1203,
   25017, -2713, -2713,  1539, -2713, 25017,  2259, -2713, -2713, 25017,
   47645,  2078, 47645, -2713,  1157, 20269, 20269, -2713,  1173, 20269,
   -2713, -2713, -2713,  2193, -2713, -2713, -2713, -2713, -2713, -2713,
   -2713, -2713,   664, -2713, -2713, -2713, -2713, -2713, -2713, -2713,
   41168,  2390, 43454,   511,  6361,  2230, -2713,  2252, 47645, 41549,
   -2713,   737,  2201, -2713,  1404, -2713, -2713, 43454,  2226,  2228,
    2227, -2713, 43454, 20269,  1163, -2713, 43073,  2089,  1445, -2713,
    2084,  2240,   680, -2713,  2234, -2713, -2713,  1463, -2713, -2713,
   43454,   -89, -2713,  1189,  1138, 20673,   337, -2713, -2713, -2713,
    3770, -2713, 47645,  1190, -2713, 20269,  2095, -2713, -2713, 25017,
    1539,  1200, 47645,  1217, 38881, -2713,  1818,  9339, -2713,  2837,
    2096, 43454, -2713,  1785,  1785, -2713, -2713,  2390,  2406, -2713,
   -2713,  2324, -2713,   513,  2242,  2420, -2713, -2713, -2713, 47645,
    2227,  1247, -2713, -2713,  2387, -2713, -2713,  7158,  1510, 25403,
   43454, -2713, -2713, 20269,   746,  2305, -2713, -2713,  2258, -2713,
    1510, -2713,   562, -2713,  1295, -2713,  9339, 47645, -2713, -2713,
   -2713,  1308, -2713, 20269, -2713,  1633,   746,   746, -2713, -2713,
    2355, -2713, -2713,    50, -2713,  2256,  2257,   599,  2117, -2713,
   -2713,    51, 43073, -2713, -2713, -2713,  1312, -2713, -2713,  2317,
    2374, -2713, -2713,  1319, -2713, -2713,  2252, -2713, -2713,  2229,
     111,   111,  2177, -2713,  2385, -2713,   613,   613, 38881,  2130,
   -2713, 32378,  2233, -2713,  2235, -2713, 43073, -2713,  2334, -2713,
    2242,  2375, -2713,  2469, -2713,   521, -2713, -2713, 41168, 28909,
   -2713,   599,  1323, -2713, -2713, -2713, -2713, -2713, -2713, -2713,
     565,   511,  2262, -2713, -2713, -2713,  1452,   -53, -2713, -2713,
   32378, -2713,   431, -2713, -2713, -2713, -2713, -2713, -2713, -2713,
   -2713, 41168, -2713, -2713, 37735, -2713, -2713,  1071, -2713, -2713,
    1214,  1292,  2144,  2145, -2713,   431, 32378,  2263, -2713,  1331,
   -2713, -2713
};

/* YYPGOTO[NTERM-NUM].  */
static const short yypgoto[] =
{
   -2713, -2713, -2713, -2713, -2713,  2333, -2713, -1652, -2713, -2713,
   -2713,  -645, -2713, -1619, -2713,  1185, -2713, -2713, -2713, -2713,
   -2713,   407, -2713, -2713,  -750,  1361, -2713,   545,   546, -2713,
   -2713, -2713, -1366, -2713,  -298, -2713, -2713, -2713, -2713, -2713,
     468, -1318, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713,
   -2713, -2713, -1341,   770,   104, -2713,   103,   836,   182, -2713,
     -73, -2713, -2713, -2713,  -368,   515, -2517, -1935,   105,  -367,
    -392,  -345,  -343,  -364, -2713,  -220,  -292, -2713, -2713, -2713,
   -2713,   123, -2713, -2713,  1204, -2713, -2713, -2713, -2713, -2713,
   -2713, -2713,  1869, -2713, -2713,   814, -2080, -2713, -2713, -2713,
    -429,  -398, -2713, -2625,   -31,   -28, -2713, -2713, -2713, -2713,
   -2713,  -992, -2713,   482, -2713, -2713, -2713,  -374,  1232,  -416,
   -2713, -2713, -2713, -2713,  -660, -2713, -2713,  2432,   900,   169,
   -2713, -2713, -1706, -1340, -2713,  1790, -2713,  1551,  1151,   393,
     124, -2713, -2713, -2713, -2135, -2713, -2713, -2713, -2713,  -271,
   -2148, -2713,   829, -1019, -2713,   552, -2713, -2713,   452, -1627,
   -2713,   -60, -2713, -2713, -2713, -1297, -2713, -1731, -1884, -2713,
    -238, -2713, -2713, -2713,  1558, -2713, -2713,   524, -2713, -2713,
   -2713, -2713,  -359,  -393, -2713, -2713, -2713,   121, -2713, -2713,
   -2713,   751,  -812, -2713,   619, -1333, -2713, -2713, -2713,   849,
      52, -2713, -2713, -2713, -2713, -1290, -2713, -2713, -2713,  1016,
    2480,  -686, -2713, -2713, -2713, -2713, -2713, -2713,   -26, -2713,
   -2713,   426,   -15, -2713, -2713, -2713,   -11,  1596,   801,   153,
     -62,   -69,  -214,   206,   586, -2713, -2713,  -194,   769, -2713,
   -2713, -2713, -2713,   614,  1419, -2713,   606,  -237, -2713, -2713,
    1430, -2713, -2713,  1036, -2713, -2250,   324, -2245,    70,  -922,
    -191,  -183, -2713, -1944, -1919,   201,  -679, -1567, -1829,  1313,
   -2713,  1557,  2674, -2713, -2713,  -950, -2713, -2713,  3305,  3306,
   -2713, -2713,  3312,  3569, -2713,  -958,   366,  3994,  -423, -1082,
   -1356, -2713, -1471,  1164,  1099,  -713, -2713, 10556, -1111,  8676,
   -1180, -1414, -1130, -1252, -2713,   112, -2713, -1408, -2713, -2713,
   -2713, -2713, -2713, -1469, -2120,  -170,   692, -2713, -2713,   796,
   -2713, -2713, -2713,  8303, -1054,   -97, -2713,  -767, -2713,    68,
    -239,   652,   -40,   181,  8901,  -802,   290,  -827,  2830,  -654,
   -1775,  1721,  1663, -2713,  -634, -2713,    -2,   224, -2713, -2713,
     108,  -158, -2713,   -78, -2713,  -783,  -891, -2712,  -574, -2713,
   -2713,   -96, -2713,  1772, -2713,  1010,  1423, -2713, -2713,  1018,
    -782,  -551, -2713, -2713, -2713, -2713, -2713, -2713, -2713, -2713,
   -2713, -2713,  2090,  2388, -2713, -2713, -2713, -2713, -2713, -2713,
    1462,    -4, -2713,   -67, -2713, -2713,  2622, -2713,  2391,   207,
    -535, -2713,  2046,   -59, -2713, -2713, -2713,   213, -2713, -2713,
   -2713, -2713, -2713,  -792,  1054, -2713,  1763, -2713, -2713, -2713,
    -710, -2713, -2713, -2713,  1634,  -147, -2713, -2713, -2713,  -954,
     939,  1796,  1649,  -939,  -948,  1025, -2713, -2713, -2713, -2713,
   -2713, -2713,   860, -2713,   219, -2713, -2713,   865, -2713, -2713,
   -2713, -2713,  1533, -2713, -2713, -2713,   359, -2713, -2713, -2713,
    -514,  9993,   -48,    35,   -76,   457,  1468,  4659, -2713,  -646,
     -22,   -70,  6631,  5139,    -5,    43, -2713, -2713,  2128,  1029,
     873,  -850,  7539,  1288,  2348,  3647,  -684,  -807,  1810,  -490,
   -1237, -2713,  2722
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1636
static const short yytable[] =
{
      69,  1005,   782,  1183,   612,   293,  1067,   855,  1780,   762,
     589,  1406,   292,  1377,   653,   310,   948,   844,   952,  1385,
     657,   927,   782,   951,  1813,  1566,   334,  2112,  1571,   334,
    1274,  1203,   850,   688,  1679,  1033,  1509,   653,  1537,  1798,
    1799,   941,   334,   657,   812,   953,  1021,  1800,   287,   899,
     988,   729,   335,  2185,   987,   894,  2118,  1873,  2341,   288,
    1157,  1011,  2302,   290,  1949,   334,  1955,  2492,   656,   336,
     983,  1277,   336,   588,  1516,  2457,  2091,  2092,  1045,  2040,
    2357,  1186,  2576,  1192,  2073,   336,  1912,   903,  1827,  1029,
    1418,   656,  2591,  2593,  1835,  2321,  1419,  2076,  2077,  1040,
     806,  1062,  1573,  1250,  1245,  1026,   954,  1825,   336,  1269,
      71,  1030,   595,   962,  2053,  1428,  1429,   337,  2057,  1180,
     337,  1384,  1254,  1255,  2257,   595,  1436,  1473,  1474,  1912,
    2380,  1430,  1539,   337,  1413,  1413,   938,   653,   991,  2797,
    1773,  -875,  1008,   657,  1485,  -701,  1493,  1047,   595,  1012,
    -870,  1542,   854,   293,  1526,   936,   337,  2537,   781,  2257,
     292,   917,  2001,  -136,  1950,   334,  1187,  2230,  2871,  1951,
    -917,  2305,  1031,  2149,  1940,  -917,  1950,  2127,   781,   899,
    2434,  1951,  1037,  1292,   668,   626,   669,  1801,  -931, -1553,
     611,   656,  1703,  -931,  1453,   270,   287,   611,  2257,  1206,
    1652,  1764,  1653,  -701,  2128,  2950,  2962,   288,   336,  1862,
    1042,   290,  1870,  1871,  2963,  1448,  1700,  1570,  1311,  2036,
    1539,  -136,  2972,  1879,  1881,   199,    70,  2390,  1539,  2113,
    1312,  2653,   825,  -704,   899,  1632,  1056,   611,  2215,  1542,
    1198,  3013,  1222,  1656,  1802,  1654,   870,  1542,   595,  2984,
    1413,  1918,  1653,  1194,  1539,   611,   337,   334,  1947,  1930,
    1327,  1759,  2629,  1293,  2219,  1176,  1540,   672,  1755,  1509,
    1190,  2494,  -229,  1542,  1381,  2225,   127,   128,  1543, -1495,
    1306,   308,  2224,   335,  1307,     3,   611,   312,  2984,  1586,
    1382,  -704,  1223,  2429,   600,  1654,  1303,  1704,   673,  1863,
     336,  2259,  1596,  2420,  1633,   826,  1353,  1757,  1760,  2495,
   -1587,  1199,  1781,  1539,  2984,  1657,  1177,  1655,  2220,   221,
    2007,  2617,  2699,  1195,  1224,  1414,  1414,   689,  2700,  2701,
    2702,  2749,  1542,  1325,  1376,  2753,  2964,  1326,  2654,  2758,
    2703,  2704,  2705,   270,  2706,  2707,  2708,   924,   337,  1405,
    2260,  2709,  2710,  2711,    49,  3014,  1391,   610,  1765,  1948,
    1308,   627,  2973,  1961,  2517,  2631,  3010,  1655,   700,  2037,
    1546,  1547,  1407,  1313,  1544,  1816,  1875,  1294,  1545,   199,
    1473,  1474,  1057,  2391,  1394,  1947,  1933,  1493,  2216,  2023,
    1692,  1485,  1567,  1803,  1468,   670,  1546,  1547,  2946,  2726,
      49,  1693,   994,   610,  1952,  2400,  1454,  1548,  1550,  -875,
    -917,  2951,  -875,  2974,    49,  2257,  1952,   610,  -870,  1295,
    -701,  -870,  -701,  1285,  1268, -1495,   904,  -172,  -931,   696,
    2975,  1549,  1449,  -875,  1550,  1864,  1333,  1415,  2495,  1647,
    -136,  1414,  -870,  2611,  2612,  1551,  1527,  1552,   610,  1865,
    2270,  1692,  2353,    52,  1774, -1636,  1694,  1668,  1563,  2110,
    1269,   776,   610,   610,   905,  1838,  2261,   803,  1580,  1581,
    1837,  1673, -1495,  1450,   811,   610,  2262,  2263,  2264,  2404,
    2265,  2266,  2267,  2268,  2269,  2270,  1953,  2397,  1840,  2257,
    2025,  1774,  1912,  1912,  1912,  1309,  1912,  1210,  2412,  1553,
    2844,  2841,   959, -1553,   848,  2848, -1553, -1553,  -704,  2850,
    -704, -1553,   308,   902,  2189,  2190,  1310,  1694,   312,  1042,
     893,  2267,  2268,  2269,  2270,   672,  1621,    49,   813,  1796,
     610,   870,   925,  1897,  1898,    52,  1703,   702,  1057,   334,
    1691,  2217,   334,  1560,  1561,  1562,  1563,  2412,  2522,  1558,
    1559,  1560,  1561,  1562,  1563,  1025,   673,  2259,  1257,  1695,
    1912,  1554,  1364, -1538,  2419,  1234,  1744, -1561,  1299, -1577,
     662,  1555,  1556,  1557,   738,  1558,  1559,  1560,  1561,  1562,
    1563,  2803,   336,   892,  1022,   336,   152,   165,  1568,   814,
    2244,   653,  2640,  2641,  2642,  2643,  2644,   657,  2712,  2908,
     785,  1056,  2690,  1018,  1582,  1364,  2260,   782,  1688,   782,
     802,   782,   870,  1849,   663,  1853,  1854,   782,  1052,   334,
    1695,  1032,   595,   334, -1587,   595,   664, -1587, -1587,  1696,
     337,  2259, -1587,   337,  1558,  1559,  1560,  1561,  1562,  1563,
    2257,  2618,  1855,   169,  2523,   656,  1599,  1810,  1300,    69,
    1583,  2524, -1596,  1291,   807,  2867,  1810,  2348,  2664,  2691,
    2074,  2651,   336,  2629,  1319,  1783,   336,   995,  2713,  2014,
     846,  2994,  1745,  1930,  2286,  1930,  1930,   996,   997,   998,
    2260,   999,  1000,  1001,  1002,  1003,  1004,  1769,   184,  2665,
    1696,  2218,  1692,  2015,  1789,   822,  2625,  2626,  2676,  1731,
     665,  2921,   595,  1693,  1057,  2226,   595,  2652,   843, -1538,
     337,  2307,  2227, -1561,   337, -1577,  2619,   611,  2630,  2620,
     152,   815,  2261,  1019,  2257,  1688,  2252,  2253,  2254,  1831,
    2256,  2214,  2262,  2263,  2264,  1784,  2265,  2266,  2267,  2268,
    2269,  2270,  1808,  1420,  1681,   199,  2903,   921,  2381,   152,
    1235,  2342,  2343,  2627,  1189,  1836, -1538,  1600,  1694,    71,
   -1561,  2692, -1577,   781,   199,   781,  2631,   781,  2862,   653,
    1595,  1223,  2440,   781,   781,   657,  1785,   169,  2393,  2394,
    2995,  2519,  2259,  1301,  2965,  1902,  1020,  1974,  2956,  1274,
    1049,  2922,   215,  1811,  2316,  2028,  2261,   334, -1596,   666,
     875,  2000,  2799,  1224,  2442,  2293,   169,  1852,  2693,  2538,
    2265,  2266,  2267,  2268,  2269,  2270,  2784,  2499,  2988,  2506,
    2863,  3001,   184,   656,   876,  1699,   612,   612,  2551,  2825,
    1277,  2260,   881,  2203,  2896,  1013,   877,  1834,  1786,   221,
     336,  2851,   859,  2853,  1912, -1596,  1700,  1912,  1912,  1912,
    1912,  1912,  1912,  1912,  1912,  1912,  1912,  1014,   221,  2645,
    1957,  1695,  2785,   770,  1364,  2482,  2259,  2484,  2957,  2486,
     852,  2088,  1942,  1514,  1364,    70,   674,   964,   771,   199,
     595,  2294,  2045,  1975,   882,  1243,   995,  1976,   337,   862,
    2553,  1912,  2355,   701,  2826,  1959,   996,   997,   998,  2897,
     999,  1000,  1001,  1002,  1003,  1004,   760,  1791,   199,  2795,
     878,    69,    69,  2446,    69,  2260,  1977,  2780,  2781,  1243,
     855,  2361, -1540,  2864,  1697,  1364,   215,   883,  2257,  2865,
     884,  1696,  2958,  2911,  1792,   863,  -733,   611,  1732,  2083,
     611,  2447,  2086,  2087,  2933,   858,  1053,  2261,   824,  2448,
    1364,  1701,  1397,  1041,   610,   215,  2940,  2262,  2263,  2264,
    1412,  2265,  2266,  2267,  2268,  2269,  2270,  2089,  1943,  2090,
    -709,  2941,  1944,  3002,   958,   960,   293,  1315,  1069,   194,
     860,  1364,  -709,  1426,  1660,  1364,  -733,  1661,  1504,  1505,
    1398,   864,   872,   982,  1480,  1482,  1539,   293,  1316,   885,
     610,  1465,   221,   221,  1452,    52,  1504,  1505,  1978,   879,
    1466,  2449,   611,   611,  2413,  1542,  -709,  1502,  -733,  1422,
    1506,    71,    71,  2875,    71,  1397,  1513,  1487,  1912,  1272,
    1423,  2261,  -709,   119,  1424,   610,  2060,  2545,  1508,  2309,
      52,  2262,  2263,  2264,  2876,  2265,  2266,  2267,  2268,  2269,
    2270,   123,  2258,  1512, -1267,  1317,  1662,  1882,  1525,  1399,
    1270,  1271,  2257,  2489,  -709,  1521,  2877,   886, -1540,  1530,
    2259,  2646,  -709,  -855,     9,   865,  -855,  1688,  2521,  1831,
    2019,  2525,  2526,  2527,  2528,  2529,  2530,  2531,  2532,  2533,
    2534,   610,  1066,  2129,   896,  2997,    52,  1483,  1068,  1400,
    2116,  2117,  2071,  2123,   776,  1675,  1072,  2072,  2124,   887,
    2678,  1244,  1589,  1798,  1799, -1540,  1364,  2119,  2120,  2260,
    2310,  1800,  1576,  2311,   908,  2554,  1577,  2679,  2068,  2606,
      49,  1742,  1399,   610,  1205,  2257,  2212,    70,    70,  1208,
      70,  2213,  1037,  1037,  2078,  1244,   611,  2184,  1912,  1624,
    1624,  1216,  1624,  1468,  2583,  1670,  -709,  2192,  2223,  1401,
    2194,  2546,  1731,  2224,  2548,  2696,  1735,  2103,  -875,  2105,
      49,  -875,  1400,   610,  2584,   612,  1491,  1492,  -849,  1504,
    1505,  -849,   334,  2234,   334,   334,  2719,  -885,  2224,  2755,
    -885,  1243,  -875,  2680,  2732,  2586,  1243,  1243,   911,  2346,
    2539,  2540,  1489,  1289,  2259,   194,   610,  2362,  1646,  1213,
     219,  1506,  2312,   220,   651,   711,  2257,  2681,  1037,  2313,
     870,  2151,   921,  -840,  1290,   336,  -840,   336,   336,  1678,
    1271,   334,  1401,  1902,  2414,  2261,   855,  2236,   334,   881,
    1663,   937,  2224,  2682,   611,  2262,  2263,  2264,   926,  2265,
    2266,  2267,  2268,  2269,  2270,   611,  1324,   653,   989,   713,
     990,   781,  2650,   657,  1685,    69,  1902,   595,   595,    69,
    1514,  2588, -1136,   337,   336,   337,   337,  2259,  1592,   610,
     992,   336,   993,  3023,    52,   334,   611,   611,  1364,  2239,
     899,   882,   776,   899,  2240,   715,  -838,   956,   611,  -838,
    2245,  1272,  2386,  1388,  1389,  2246,  1272,  1272,  2387,  2388,
    1396,   656,  1589,  1912,   595,  1912,  2823,   963,  1776,  1883,
    2683,  1884,   337,   964,  -841,  1885,  2260,  -841,   336,   337,
    2684,  1896,   966,  1364,   883,  1364,  -882,   884,  1900,  -882,
    2582,  2345,  2359,  2764,  2685,  1344,  2224,  1585,  1922,  1364,
    1923,  2686,  -839,  -852,  1068,  -839,  -852,  1776, -1636,   611,
    -882,   611,   717,  1593,   718,  1820,  1821,  2340,   595,  1938,
     882,  1939,    52,  2458,    53,    71,   337,  1496,  2459,    71,
   -1133,   854,  2736,  2265,  2266,  2267,  2268,  2269,  2270,  2257,
    2687,  2583,   986,  2827,  2465,    49,  -504,  2369,   610,  2466,
    2477,  2562,   985,  1364, -1454,  2478,   885, -1454,   749,   882,
    1894,  2584,  2858,   883,  1007,  2389,  1777,  1244,  2325,  1529,
    2326,  1912,  1244,  1244,  1625,  1627,  2585,  1631, -1460,   928,
    1966,   610,  2586,   929,  1845,  2327,    52,  2328,    53,  1017,
    1504,  1505,  2261,  1028,  1242,   930,   931,  1016,  -885,  1967,
    2587,  -885,   883, -1636, -1636,  1777,  2265,  2266,  2267,  2268,
    2269,  2270,  1941,  1038,  2497,   653,  1664,   932,  1954,  2498,
     933,   657,  1508,  1063,   886,   781,  1964,   781,  1769,  2460,
    3024,   781,  3025,  2556,  1065,   885, -1456,   781,  2224, -1456,
    2389,    70,  1064,   334,   781,    70,  2598,  1616,   611,  1073,
    2599,  2224,   887,  1074,   781,  2224,   781,  2485,  2588,  2488,
   -1461,   219,    49,  2856,   220,   610,  2613,  2013,  2734,   656,
      52,  2478,    53,  2735,   885,   781,  1968,   781,  1242,  2773,
    1969,  2259,  1037,  1970,  2478,  1902,   336,  2265,  2266,  2267,
    2268,  2269,  2270,  1070,  2678, -1453,  2774,  2834, -1453,  2836,
     619,  2478,  1075,  1778,  2511, -1452,   870,   638, -1452,  2838,
     660,  2679,    49,  1076,  2735,   610,  2855,   334,  1852, -1458,
     660,  2224,  2888,  2916,  2917,  2512,   595,  2889,  2520, -1457,
    2260,  2043,   934,  2043,   337,  2589,  2012,  2421,  2422,  2423,
    2424,  2425,  1778,   612,  2108,  2426,   611,   638,  2901,  2905,
     334,  2837,   334,  2498,  1585,  2541,   660,   699,  1644,  2910,
     336,  1645,  1746,  1747,  2459,   638,   660,  1078,  1539,   660,
    1779,  2139,  1971,  1213,   660,  -701,  2912,  2680,   660,  1972,
    1540,  2459,  1219,  2148,  1221,  2559,    49,  1542,  1193,   610,
    1200,  2936,  1543,   336,    52,   336,    53,  1201,   660,  1364,
     595,  2681,  1242,  1202,  1669,  2902,  2930,  1645,   337,   660,
    1209,  1454,   821,  1243,  2754,  1046,  2757,  1048,   837,  1050,
     842,  1364,  1211,  1539,  1210,  1051,  2582,  2682,  1243,  1748,
      69,  2115,    69,   595,  2115,   595,  1215,  2041,  2122,  1886,
    1645,   337,  1542,   337,  1213,   855,  2261,  1543,  2340,  1832,
    1833,  1214,  1364,   611,  2942,  1217,  2262,  2263,  2264,  1585,
    2265,  2266,  2267,  2268,  2269,  2270,  2228,  2944,  1504,  1505,
    1243,  2966,  2459,  1243,  1243,  1220,  2224,  2583,  2969,  1749,
    1750,  1236,  2999,  1585,  1068,  1364,  2172,  3000,  1544,   855,
    3031,  1887,  1545,  1248,  1867,  3000,  1364,  2584,  1227,   855,
     781,  1364,  1232,  1068,  2683,  2285,  1751,  2287,  2288,  1237,
    1546,  1547,  2585,  1364,  2684,  1364,  2048,  1722,  2586,  1645,
    1233,  1548,   781,  1238,  2657,  2636,  2637,   781,  2685,   611,
    2808,  2809,   967,  1239,  1888,  2686,  2587,  1889,  1272,   781,
      71,  1240,    71,  1544,  1241,  1549,  1251,  1545,  1550,  2363,
    2364,  1723,  2330,  2331,  1626,  1626,  2845,  1626,  1253,  1551,
    1364,  1552,  1057,  1752,  1263,  1546,  1547,  2421,  2422,  2423,
    2424,  2425,   968,  1278,  2687,  1279,  1548,  2639,  2423,  2424,
    2425,  1734,  1736,  1737,  1364,  2899,  2143,  2144,  2145,  1281,
    1521,   969,  1287,  1753,  2588,  1256,  1258,  1288, -1460, -1461,
    1549, -1458, -1457,  1550,  2347, -1122,  1890,  1999,   970,  2107,
    1297,  1364,  1724,  1553,  1551,  1302,  1304,   611,  1314,  1320,
     611,  1333,   781,  1331,   611,  1335,  2301,  1371,  1372,  2559,
    1374,  1386,  2134,  1390,  1521,  1402,   971,  2303,  1404,  1244,
    1408,  1364,  1409,  1410,  1521,  1411,  1430,  1725,  1458,  1726,
    1461,  1462,   972,  2846,  1244,  1463,    70,  1964,    70,  1727,
    1464,  2027,  1486,  1585,  1472,  1475,  1476,  1477,  1553,  1479,
    1481,  2589,   611,  2324,  1891,  1554,   221,   219,    49,  1488,
     220,   610,  2333,  1495,  1498,  1555,  1556,  1557,  1499,  1558,
    1559,  1560,  1561,  1562,  1563,  1500,  1244,  2340,  1591,  1244,
    1244,  2340,  1598,  1501, -1050,  2340,  1503,  1601,  1510,  1728,
    1511,  1572,  1614,  1615,  1622,  1222,   973,  1643,  1651,  1659,
    2440,  1658,  2418,  1665,  1667,  1671,  1680,  3012,  1682,  1674,
    1554,  2441, -1404,  1689,  1684,  1690,  1729,  1702,  1715,  1718,
    1555,  1556,  1557,  1716,  1558,  1559,  1560,  1561,  1562,  1563,
    1717,  1731,  2442,  1739,  2443,  2881,   974,   975,  1719,  1721,
     781,  1720,   976,  1738,  1740,  2904,  1243,  1741,  1743,  1756,
    1761,  1758,  1762,  1763,  1770,  2904,  1483,  1772,  1489,  1468,
    1364,  1496,  1782,  2115,   977,  2481,   709,  1795,  1814,  1806,
    1815,  1818,  1817,  2817,  1823,  1826,   978,  1828,   653,  1056,
    1841,   979,  1844,   675,   657,  1856,  2839,  1848,  1842,  2444,
    1847,  1857,  1454,  1858,  1874,  2435,  1875,  1920,   660,   980,
    1882,  1921,  1514,  1539,  1937,  1945,   334,   638,  1981,  1960,
    2943,  1934,  2513,  1243,  1946,  1936,  1963,  1979,  2516,  1243,
    1243,  2001,  2011,  2017,  2018,   660,   660,  2020,   863,   676,
    2159,  2029,   656,  2033,  2034,  2173,  2038,  2445,  1774,   855,
     293,  2446,   677,   293,  2046,  2047,  2340,  2479,   855,   336,
    2480,  2340,  2051,  1243,  2061,  2340,  1272,  2058,   781,   678,
     781,  2569,  2570,  2571,  2572,  1364,  2063,  2064,  2065,  2447,
    2430,  1534,  2067,   293,   950,   638,   950,  2448,   619,   660,
    2500,   660,  2886,   787,   660,   619,  1852,   679,  2070,   595,
    2075,   680,  2084,  2100,  2102,  2104,  2106,   337,    49,  2109,
    2111,  2125,  2130,   660,   788,  2460,   638,  2137,   950,  2150,
     619,  2138,  2141,  2154,  1009,  2155,  2170,   660,  2171,   950,
    2174,   619,   789,  2179,   681,  2180,  2181,  2182,   660,   660,
    2183,  2187,  2186,  2188,  2200,  2221,  2237,  2202,   660,  2449,
    2222,   638,  2238,  2241,   619,  2340,  2242,  2398,   660,   611,
    2550,  2243,   660,  2247,   619,  2248,  2251,   950,  2272,  2273,
    2935,   790,  2224,  1272,  2299,  2279,  2300,   682,   781,  2280,
    2134,  2281,  1244,  2282,   781,   660,  2304,   660,  2283,  2290,
    2431,   611,  2297,   660,  1521,  2817,  2298,   995,  2635,  2308,
    2344,  2320,  2314,  2575,  2349,  2323,  1902,   996,   997,   998,
    1195,   999,  1000,  1001,  1002,  1003,  1004,   995,   683,  2980,
    2354,   660,  2370,   684,  2358,  2329,  2366,   996,   997,   998,
    2368,   999,  1000,  1001,  1002,  1003,  1004,   638,   660,   837,
    2375,   837,  2372,  2373,  1271,   685,  2374,  2385,  2378,  1244,
    2379,  2383,  1364,  2395,   791,  1244,  1244,   686,  2396,  2399,
    2401,  2402,  2403,  1661,  2115,  2115,  2416,  1539,   792,  2428,
    2417,   687,  2427,   793,  2453,  1831,  1020,  2461,  2455,  2463,
    2464,  2476,  2472,  2473,  2996,  2483,  1542,   786,  2491,  1244,
    2502,  1543,  2490,  2503,  2507,  2510,  2276,   794,  2257,   795,
    1465,  1526,  2275,  2558,    69,  2542,  2543,  2544,   796,  2552,
    2566,  2596,   619,   619, -1136,  2595,  1262,  3022,  2602,  2581,
     797,   798,  2609,  2615,  2600,  2603,  2623,  2614,  2607,  2628,
    2624,  2638,  2655,  2648,  2675,   787,   660,  2659,   293,   660,
    2661,  2667,   660,  2715,  2677,  2672,   611,  1663,  2673,  2727,
    2728,  2750,  2718,  2729,   781,  2721,   788,  2722,  2306,   781,
     781,   781,   781,   781,   950,  2723,  2725,  2730,  2751,  2746,
     624,  1364,  1323,  2748,   789,  2759,  2762,   624,  2765,  2766,
    2776,  2786,   660,  2769,  2456,  2777,   660, -1636,  2630,   660,
    2462,  1545,  2789,  2790,   660,  2791,  2792,  2800,  2798,  2802,
    2804,  2778,   950,  2805,  2806,  2807,  2812,  2821,  2822,  1546,
    1547,  2830,  2824,   790,    71,  2832,  1379,   624,  2831,  2835,
   -1636,  2842,  2849,  2868,   950,  1393,  2852,   660,  2861,  2654,
    2873,  2882,  2879,  2883,  2884,   624,   735,  2893,  2894,  2895,
     950,  2898,  2919,  2907,   735,  2914,  2920,  1550,   624,  2923,
     611,   611,  2333,  2927,  2931,  2938,  2333,  2939,  1551,  2949,
    2333,   660,  2768,  2952,  2954,  2961,   624,  2967,   624,  2134,
    2134,  2134,  2134,  2134,  2968,  1364,  2971,   660,  2951,   735,
    2950,  2986,  1355,  2987,  2981,  2115,  2115,  2989,  2992,  1539,
    2783,  2993,  3026,  3011,  3027,   857,   791,  3013,  2454,  1790,
    1613,  1540,  2351,  2392,  2352,  2663,  2152,  2669,  1542,  2093,
     792,  2616, -1636,  1543,  1539,   793,  2796,  2377,  2991,  2970,
     611,  2955,  2953,  2695,  2880,  1355,  1540,  2977,  2929,  2670,
      70,  1364,  1809,  1542,  1015,  2811,  2140,  3029,  1543,   794,
    2820,   795,  3016,  2788,  1589,  2787,  2407,  2998,  1794,  1531,
     796,  3030,   809,  1077,  1868,  2504,  1447,   781,  2934,  2716,
    2573,  2574,   797,   798,  2382,  2153,  2475,  1532,  2828,  2918,
    1460,  3004,  3028,  1664,  1554,  2350,  2146,  2026,   763,  2501,
    2191,  1425,  2697,  2360,  2365,  1641,   638,   638,  1558,  1559,
    1560,  1561,  1562,  1563,  2024,  1639,  2577,  2756,  1590,  2909,
    2662,  1771,  1533,  2549,  1992,  1915,  1612,  1612,  2318,  1544,
    2733,  2770,  2231,  1545,  2945,  2356,  1534,  1620,  2833,  2717,
    1392,  2333,  1535,  1265,  2050,  1322,  2333,   897,  1676,  2049,
    2333,  1546,  1547,   869,  1544,  1650,   305,   871,  1545,  2039,
     920,  1286,  1548,  1259,  1457,  2052,  1435,  2199,   611,  2698,
    1579,  2198,  2601,  2056,   891,  2193,  1546,  1547,  2647,   638,
     739,   619,  1843,  1267,    76,     0,  1549,  1548,     0,  1550,
     740,   611,   611,     0,     0,     0,   611,     0,  2656,     0,
    1551,     0,  1552,     0,     0,  2658,     0,     0,   741,   660,
       0,  1549,     0,     0,  1550,     0,     0,     0,   837,     0,
       0,     0,   293,     0,     0,  1551,   742,  1552,     0,  2480,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   743,
    2333,   611,     0,     0,   837,     0,   611,     0,  3021,     0,
     611,     0,   995,     0,  1553,     0,   744,     0,  2978,  2979,
       0,     0,   996,   997,   998,     0,   999,  1000,  1001,  1002,
    1003,  1004,     0,     0,     0,     0,  2937,     0,     0,  1553,
       0,     0,     0,     0,   745,     0,     0,     0,   746,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2947,  2948,
     747,     0,     0,     0,  1355,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1355,     0,  1554,     0,  1590,  2742,
    2743,  2744,  2745,     0,     0,     0,  1555,  1556,  1557,     0,
    1558,  1559,  1560,  1561,  1562,  1563,     0,     0,  2291,   619,
       0,  1554,     0,   950,     0,     0,     0,  2292,   660,     0,
       0,  1555,  1556,  1557,     0,  1558,  1559,  1560,  1561,  1562,
    1563,     0,     0,  2731,   748,  1355,     0,     0,   660,     0,
     660,   660,     0,     0,     0,  1539,     0,     0,  1861,     0,
       0,   293,   659,  1539,     0,   749,     0,  1540,     0,     0,
    1355,     0,   661,  3020,  1542,     0,     0,     0,     0,  1543,
       0,     0,  1542,     0,   750,   751,     0,  1543,   735,     0,
     752,     0,     0,     0,   781,   781,   293,   624,     0,     0,
       0,  1355,     0,     0,     0,  1355,  1903,     0,   691,     0,
       0,     0,   753,     0,     0,     0,     0,     0,   732,     0,
       0,   737,     0,     0,   754,     0,   732,   912,     0,   755,
     780,     0,     0,     0,     0,     0,     0,     0,   756,     0,
       0,     0,   611,     0,     0,     0,     0,   757,     0,     0,
     810,     0,     0,     0,  2315,     0,     0,     0,     0,     0,
       0,   732,     0,     0,   611,   611,     0,     0,     0,     0,
    1539,     0,     0,     0,     0,  1544,     0,     0,     0,  1545,
       0,   660,     0, -1636,     0,     0,     0,  1545,     0,  1542,
       0,     0,     0,   660,  1543,     0,     0,  1546,  1547,     0,
       0,     0,     0,     0,     0,  1546,  1547,     0,  1548,     0,
       0,     0,     0,     0,  1539,     0, -1636,     0,   735,   735,
       0,     0,  2870,     0,     0,  2022,     0,     0,     0,     0,
     660,     0,  1549,  1542,     0,  1550,  1355,  1068,  1543,     0,
       0,     0,     0,  1550,     0,     0,  1551,     0,  1552,   735,
       0,     0,     0,   624,  1551,   624,     0,   624,     0,     0,
    2900,  2563,     0,   624,   624,     0,     0,     0,     0,     0,
       0,     0,     0,   735,     0,     0,     0,     0,     0,   619,
       0,     0,  1262,     0,     0,     0,     0,  1539,     0,     0,
   -1636,  2915,     0,     0,  1545,     0,     0,   660,   638,     0,
    1553,   660,     0,     0,     0,  2564,  1542,   660, -1636,     0,
     619,  1543,  1546,  1547,     0,     0,     0,   624,     0,     0,
     624,     0,     0, -1636,   619,   619,   619,   660,  2081,   660,
       0,     0,     0,     0, -1636,     0,     0,     0,  1545,     0,
       0,  2094,  2095,   660,  2097,   660,     0,   660,     0,   619,
    1550,   619,     0,     0,     0,     0,  1546,  1547,     0,     0,
       0,  1551,  1554,     0,     0,     0,     0, -1636,   950,   950,
    1554,     0,  1555,  1556,  1557,   624,  1558,  1559,  1560,  1561,
    1562,  1563,  2136,     0,  1558,  1559,  1560,  1561,  1562,  1563,
       0,  2913,   624,   624,  1550,     0,     0,     0,     0,     0,
     619,     0,     0,   619,     0,  1551,     0,  1544,  1355,  1539,
       0,  1545,     0,     0,  2158, -1636,     0,     0,     0,  2169,
       0,  1540,     0,     0,     0,  2030,  2178,     0,  1542,  1546,
    1547,     0,     0,  1543,     0,     0,  2081,     0,     0,  1539,
    1548,     0,     0,     0,     0,     0,     0,     0,     0,   660,
       0,  1540,   660,  1355,     0,  1355,     0,     0,  1542, -1636,
       0,     0,     0,  1543,  2207,     0,     0,  1550,     0,  1355,
       0,     0,     0,     0,     0,     0,     0,  1554,  1551,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2031,
       0,  1558,  1559,  1560,  1561,  1562,  1563,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1554,     0,  1355,     0,     0,   624,     0,     0,  1544,
       0,     0,  1553,  1545,     0,  1558,  1559,  1560,  1561,  1562,
    1563,     0,     0,     0,  1434,  2296,     0,     0,     0,     0,
    1439,  1546,  1547,     0,  1903,     0,     0,     0,   735,  1544,
       0,     0,  1548,  1545,     0,     0,     0,     0,     0,     0,
     898,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1546,  1547,     0,     0,     0,  1549,  1903,     0,  1550,
       0,     0,  1548,     0,  1554,     0,     0,   906,   907,     0,
    1551,     0,  1552,     0,  1555,  1556,  1557,     0,  1558,  1559,
    1560,  1561,  1562,  1563,     0,     0,  1549,     0,     0,  1550,
       0,     0,     0,     0,   624,     0,  1612,     0,     0,     0,
    1551,  1620,  1552,     0,     0,   624,     0,     0,     0,     0,
       0,     0,   660,     0,     0,     0,     0,     0,     0,     0,
       0,   955,     0,   957,  1553,     0,   961,     0,     0,   638,
       0,     0,  1575,     0,     0,     0,   624,   624,     0,     0,
       0,     0,     0,  2178,     0,   984,     0,     0,   624,     0,
       0,   624,     0,   660,  1553,     0,   624,   624,     0,  1010,
       0,     0,     0,     0,     0,  2032,     0,     0,     0,     0,
     898,   732,     0,     0,     0,     0,     0,     0,     0,     0,
    1027,     0,     0,     0,   619,     0,  1554,     0,     0,     0,
    1034,     0,     0,     0,  1035,     0,  1555,  1556,  1557,     0,
    1558,  1559,  1560,  1561,  1562,  1563,     0,     0,     0,   624,
    2136,   624,     0,     0,     0,     0,  1554,  1054,     0,  1055,
       0,   624,   660,   660,     0,   898,  1555,  1556,  1557,     0,
    1558,  1559,  1560,  1561,  1562,  1563,     0,     0,     0,  1355,
    1935,     0,     0,     0,     0,     0,     0,     0,     0,  2471,
       0,     0,     0,  1071,     0,     0,     0,     0,     0,     0,
     660,  1355,     0,     0,     0,     0,     0,     0,     0,  1356,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2493,     0,     0,  1539,     0,     0,     0,     0,
       0,  1861,  1355,     0,     0,     0,     0,  1540,     0,     0,
    2207,     0,     0,     0,  1542,     0,     0,     0,     0,  1543,
       0,     0,  1356,   950,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1355,  1903,     0,     0,     0,
       0,   338,     0,     0,   338,     0,  1355,     0,     0,     0,
       0,  1355,     0,     0,     0,     0,   639,   338,   624,     0,
       0,     0,     0,  1355,     0,  1355,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1280,     0,
     338,  1282,     0,     0,  1284,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   639,     0,     0,     0,
       0,     0,  1575,     0,  1846,     0,     0,     0,     0,     0,
    1355,     0,     0,     0,   639,  1544,     0,     0,     0,  1545,
       0,  2580,     0,     0,  1328,  2580,  2594,     0,  1329,     0,
       0,  1330,     0,     0,  1355,     0,  1370,  1546,  1547,     0,
       0,     0,     0,     0,     0,   624,     0,   624,  1548,     0,
       0,   624,     0,     0,     0,     0,   624,   624,     0,     0,
       0,  1355,     0,     0,   624,     0,  2178,  2178,  1539,  1395,
       0,     0,  1549,     0,   624,  1550,   624,     0,     0,     0,
     338,  1539,     0,   660,   660,     0,  1551,  1542,  1552,     0,
       0,  1355,  1543,  1540,     0,   624,     0,   624,     0,     0,
    1542,     0,     0,  1427,     0,  1543,     0,     0,     0,  2136,
    2136,  2136,  2136,  2136,     0,     0,     0,     0,     0,  1456,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   660,
       0,     0,     0,     0,     0,  1434,     0,     0,     0,     0,
    1553,  2009,     0,     0,     0,     0,     0,  2158,     0,  2094,
       0,     0,  2094,     0,  2671,     0,     0,     0,     0,     0,
       0,  2081,     0,   624,     0,     0,  2178,     0,     0,     0,
       0,     0,   338,     0,     0,     0,     0,     0,     0,     0,
       0,  1356,     0,  2207,     0,  2275,     0,     0,     0,     0,
    2276,  1356,  1545,     0,     0,     0,     0,     0,     0,     0,
       0,  1544,  1554,     0,     0,  1545,     0,     0,     0,     0,
    1546,  1547,  1555,  1556,  1557,     0,  1558,  1559,  1560,  1561,
    1562,  1563,     0,  1546,  1547,     0,  2274,     0,     0,     0,
    1355,     0,     0,   624,  1548,     0,     0,     0,     0,   624,
       0,     0,  1356,     0,     0,     0,     0,     0,  1550,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1549,  1551,
       0,  1550,     0,  2580,     0,     0,  2747,  1356,     0,     0,
       0,     0,  1551,     0,  1552,     0,     0,     0,     0,     0,
    2761,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     624,  2022,     0,   624,   624,  2771,     0,   660,  1356,     0,
       0,     0,  1356,   660,     0,     0,     0,     0,  2779,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     624,     0,     0,     0,     0,     0,  1553,   624,     0,     0,
     624,  1683,     0,     0,   624,  1355,     0,     0,     0,     0,
       0,     0,   624,     0,     0,     0,     0,   624,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   624,
       0,     0,     0,     0,     0,  2818,     0,     0,     0,     0,
    1590,     0,     0,     0,     0,  1554,     0,     0,     0,     0,
       0,     0,   624,     0,     0,     0,     0,     0,  1554,  1558,
    1559,  1560,  1561,  1562,  1563,     0,     0,     0,  1555,  1556,
    1557,     0,  1558,  1559,  1560,  1561,  1562,  1563,     0,   735,
    1434,     0,   735,  2197,  2197,  1439,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1356,  2580,     0,   660,     0,     0,  1539,
       0,     0,   624,     0,     0,     0,     0,     0,  2158,     0,
    2854,  1540,     0,     0,   338,     0,     0,   338,  1542,     0,
       0,     0,     0,  1543,     0,     0,     0,     0,     0,     0,
    1839,     0,     0,     0,     0,     0,   639,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2081,  2094,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     950,     0,     0,     0,   950,     0,     0,     0,     0,     0,
    1358,  1359,  1355,     0,     0,     0,     0,  1361,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     660,     0,     0,     0,   338,     0,     0,     0,   338,     0,
    2854,     0,   947,     0,     0,     0,   947,     0,     0,     0,
       0,     0,     0,  1358,  1359,     0,     0,     0,     0,  1544,
    1361,     0,     0,  1545,     0,     0,     0,   660,     0,     0,
       0,   947,     0,     0,     0,     0,     0,  2818,   950,     0,
     624,  1546,  1547,     0,     0,     0,   624,     0,     0,     0,
       0,     0,  1548,     0,     0,   660,     0,     0,     0,     0,
       0,     0,     0,  1023,     0,  1356,   947,     0,     0,     0,
       0,     0,   947,     0,     0,     0,  1549,     0,     0,  1550,
     950,     0,     0,  2008,     0,     0,     0,     0,     0,     0,
    1551,  1355,  1552,     0,     0,  2010,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2985,
    1356,     0,  1356,   624,   950,     0,  1539,     0,     0,   624,
     624,     0,     0,     0,     0,     0,  1356,  1903,  1540,     0,
       0,     0,     0,     0,     0,  1542,     0,     0,     0,   624,
    1543,     0,     0,     0,  1553,     0,     0,     0,  2985,     0,
       0,     0,     0,   624,  1175,     0,   639,     0,   624,     0,
     624,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     624,   624,   338,     0,  2985,     0,     0,     0,     0,     0,
    1356,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1355,     0,     0,     0,  2059,
       0,     0,     0,  2062,     0,     0,  1554,     0,     0,  2066,
     735,     0,     0,     0,     0,     0,  1555,  1556,  1557,     0,
    1558,  1559,  1560,  1561,  1562,  1563,     0,     0,     0,  2079,
    2415,  2082,     0,     0,  1362,     0,  1544,     0,     0,     0,
    1545,     0,     0,     0,     0,  2096,     0,  2099,     0,  2101,
       0,  1355,     0,     0,     0,     0,     0,     0,  1546,  1547,
       0,     0,     0,     0,     0,     0,     0,     0,   624,  1548,
       0,     0,  1358,  1359,   624,     0,     0,  1362,     0,  1361,
       0,     0,  1358,  1359,     0,     0,     0,     0,     0,  1361,
       0,     0,     0,  1549,   947,     0,  1550,     0,   947,     0,
       0,     0,     0,     0,     0,     0,     0,  1551,     0,  1552,
       0,     0,  1369,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   624,     0,     0,     0,
       0,     0,     0,  1358,  1359,     0,     0,     0,     0,     0,
    1361,     0,     0,     0,     0,   947,     0,     0,     0,     0,
       0,   898,     0,     0,   898,  1369,     0,     0,  1358,  1359,
       0,  1553,     0,     0,     0,  1361,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1358,
    1359,     0,     0,  1358,  1359,     0,  1361,     0,     0,     0,
    1361,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1175,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1554,     0,     0,  1356,     0,     0,     0,
     624,   624,  1175,  1555,  1556,  1557,     0,  1558,  1559,  1560,
    1561,  1562,  1563,     0,   624,     0,     0,  2610,  1356,   624,
     624,   624,   624,   624,     0,     0,  1175,  1175,     0,  1175,
    1175,  1175,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1175,     0,  1356,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     624,     0,     0,     0,     0,   639,   639,     0,     0,     0,
       0,     0,  1356,     0,     0,     0,     0,     0,  2197,     0,
    1597,     0,     0,  1356,  1358,  1359,     0,     0,  1356,     0,
       0,  1361,     0, -1633,     0,     0,  1362,     0,     0,     0,
    1356,     0,  1356,     0,     0,     0,  1362,  1175,     0,     0,
    1175,  1175,     0,     0,     0,     0,     0,   338,     0,   338,
     338,     0,     0,     0,     0,     0,     0,     0,     0, -1633,
       0,     0,     0,     0,     0,     0,     0,     0,   639,     0,
       0, -1633, -1635,     0,     0,  2384, -1633,  1356,     0,     0,
       0, -1633, -1633,     0, -1633,     0,     0,  1362,     0,     0,
       0,     0,     0,     0,     0,     0,   338,     0,     0,     0,
       0,  1356,     0,   338,  1369, -1633,     0,     0, -1635,     0,
       0,     0,  1362,     0,  1369,     0,     0,     0,   624,     0,
   -1635, -1633,     0,     0,     0, -1635,     0,     0,  1356,     0,
   -1635, -1635,     0, -1635,     0,     0,     0,   624,     0,     0,
       0,   624,   624,  1362,  2437,  2439,   624,  1362,     0,  1363,
     338,     0,     0, -1633, -1635,     0,     0,     0,  1356,     0,
       0, -1633,     0,     0,     0,  1369,     0,     0,     0,     0,
   -1635,  2470,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   732,     0,     0,     0,  1358,  1359,     0,     0,
    1369,   624,  1363,  1361,     0,     0,   624,     0,     0,     0,
     624,     0, -1635,     0,     0,     0,     0,     0,     0,     0,
   -1635,     0,     0,     0,     0,     0,     0,     0,     0,  1175,
       0,  1369,     0,     0,     0,  1369,   807,     0,     0,     0,
       0,  1358,  1359,  1358,  1359,     0,     0,     0,  1361,     0,
    1361,     0,     0,     0,     0, -1633,     0,  1358,  1359,     0,
       0,     0,     0,     0,  1361,     0,     0,     0,   947,     0,
       0,     0,     0,     0, -1633,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   807,     0,     0,  1362,     0,
       0,  1175,  1175,     0,     0,     0,     0,     0,     0,  1175,
       0,     0,  1175,  1175, -1635,     0,     0,  1356, -1633, -1633,
   -1633,  1358,  1359,     0,     0,  1895,     0,     0,  1361,     0,
       0,     0,  1175, -1635,     0,     0,  1175,  1175,  1175,     0,
    1175,     0,     0,     0,     0,     0,     0,  1175,  1175,     0,
       0,  1175,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -1635, -1635, -1635,
       0,     0,     0,     0,     0,     0,  1369,  1175,   338,     0,
    1175,  1175,     0,     0,     0,  1175,     0,     0,     0,  1175,
       0,     0,  1175,  1175,  1175,  1175,  1175,  1175,  1175,  1175,
    1175,  1175,     0,     0,     0,  1175,   598,     0,     0,  1175,
       0,     0,     0,     0,     0,  2621,  2622,     0,     0,   598,
       0,     0,  1356,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   624,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   598,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   338,     0,   624,   624,     0,     0,     0,     0,
       0,  2649,     0,     0,     0,     0,     0,     0,     0,     0,
    1362,  1363,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1363,     0,     0,     0,   338,     0,   338,     0,     0,
       0,     0,     0,     0,   624,   624,     0,     0,     0,   624,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1362,     0,  1362,     0,     0,
       0,     0,     0,     0,     0,  1539,     0,     0,     0,     0,
       0,  1362,  1363,     0,     0,     0,     0,  1540,   624,     0,
    1175,     0,   598,     0,  1542,     0,     0,     0,  1369,  1543,
       0,     0,     0,     0,     0,     0,     0,  1363,     0,     0,
       0,     0,     0,     0,   624,     0,     0,  1358,  1359,     0,
       0,     0,     0,     0,  1361,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1362,     0,     0,  1363,  1358,
    1359,     0,  1363,  1369,     0,  1369,  1361,     0,     0,  1356,
       0,     0,     0,     0,     0,     0,     0,  1175,     0,  1369,
       0,     0,     0,  1539,     0,     0,     0,     0,     0,     0,
    1358,  1359,     0,     0,     0,     0,     0,  1361,     0,  2772,
       0,     0,  1542,     0,     0,  2775,     0,  1543,     0,     0,
       0,     0,     0,     0,     0,  1544,     0,     0,     0,  1545,
       0,     0,     0,  1358,  1359,     0,     0,     0,     0,     0,
    1361,     0,     0,  1369,  1358,  1359,     0,  1546,  1547,  1358,
    1359,  1361,     0,     0,     0,     0,  1361,     0,  1548,     0,
       0,  1358,  1359,  1358,  1359,     0,     0,     0,  1361,     0,
    1361,     0,     0,     0,     0,  1175,     0,     0,     0,     0,
       0,     0,  1549,     0,  2567,  1550,     0,     0,     0,     0,
       0,     0,  1175,     0,     0,     0,  1551,     0,  1356,     0,
       0,     0,     0,  1363,     0,     0,     0,     0,  1358,  1359,
       0,     0,     0, -1636,     0,  1361,     0,  1545,     0,     0,
       0,     0,     0,  1175,  1175,  1175,  1175,  1175,     0,     0,
       0,     0,  1358,  1359,     0,  1546,  1547,     0,     0,  1361,
       0,     0,  1175,  1175,  1175,  1175, -1636,     0,     0,     0,
    1553,     0,     0,  1175,     0,     0,     0,     0,     0,  1358,
    1359,     0,     0,     0,     0,  1175,  1361,     0,     0,     0,
    1175,     0,     0,  1550,     0,     0,     0,     0,     0,     0,
    1175,     0,     0,     0,  1551,     0,     0,     0,     0,  1358,
    1359,  1175,  1175,     0,  1175,     0,  1361,     0,  1175,     0,
       0,     0,  1356,     0,     0,     0,     0,     0,     0,     0,
       0,  1362,  1554,     0,  1366,     0,     0,     0,   947,     0,
    1175,  1175,  1555,  1556,  1557,     0,  1558,  1559,  1560,  1561,
    1562,  1563,     0,  1362,     0,     0,     0,     0, -1636,     0,
       0,     0,     0,     0,     0,     0,  1175,     0,     0,     0,
       0,     0,     0,  1175,  1175,  1175,     0,  1366,  1356,     0,
       0,     0,     0,     0,  1362,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1363,     0,     0,  1175,  2928,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1369,
       0,     0,     0,     0,     0,     0,   598,  1362,     0,   598,
    1554,     0,     0,     0,     0,     0,     0,     0,  1362,     0,
       0,  1369,     0,  1362,  1558,  1559,  1560,  1561,  1562,  1563,
    1363,     0,  1363,     0,     0,  1362,     0,  1362,  1358,  1359,
       0,     0,     0,     0,     0,  1361,  1363,     0,     0,     0,
       0,   338,  1369,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1362,     0,     0,  1369,   598,     0,     0,     0,
     598,     0,     0,     0,   945,     0,  1369,     0,   945,     0,
    1363,  1369,     0,     0,     0,     0,  1362,     0,     0,     0,
       0,     0,     0,  1369,     0,  1369,     0,     0,     0,     0,
       0,     0,     0,   945,     0,     0,     0,     0,     0,   947,
       0,     0,     0,  1362,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1358,  1359,     0,     0,     0,     0,     0,
    1361,  1175,     0,     0,     0,     0,     0,  1175,   945,     0,
    1369,     0,     0,  1362,   945,     0,     0,     0,     0,  1175,
       0,  1175,     0,     0,     0,     0,  1175,     0,     0,     0,
       0,     0,     0,     0,  1369,  1175,     0,     0,  1175,  1175,
    1175,  1175,  1175,  1175,  1175,  1175,  1175,  1175,     0,     0,
       0,     0,  1175,  1175,     0,     0,     0,     0,     0,     0,
       0,  1369,     0,     0,     0,     0,  1175,     0,     0,  1175,
       0,     0,     0,     0,     0,     0,  1366,     0,     0,     0,
       0,  1175,  1175,  1175,     0,  1175,  1714,     0,     0,     0,
       0,  1369,  1175,     0,     0,     0,  1171,  1175,     0,     0,
    1175,     0,     0,     0,     0,     0,     0,     0,     0,   947,
       0,     0,     0,     0,   598,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1175,     0,  1366,     0,     0,
       0,  1539,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1362,  1540,     0,     0,     0,     0,     0,     0,
    1542,     0,  1366,     0,     0,  1543,     0,     0,     0,     0,
    1358,  1359,     0,     0,     0,     0,     0,  1361,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1366,     0,     0,  1363,  1366,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1363,  1175,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1369,     0,     0,     0,     0,     0,   945,     0,     0,     0,
     945,     0,     0,     0,     0,     0,     0,     0,     0,  1363,
       0,     0,     0,     0,  1368,     0,     0,  1362,     0,     0,
       0,  1544,     0,     0,     0,  1545,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1175,     0,     0,     0,     0,
       0,     0,  1363,  1546,  1547,  1175,     0,   945,     0,  1358,
    1359,     0,     0,  1363,  1548,     0,  1361,  1368,  1363,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1363,     0,  1363,     0,     0,     0,     0,     0,  1549,     0,
       0,  1550,     0,     0,     0,     0,     0,     0,  1366,     0,
       0,     0,  1551,     0,  1552,  1369,     0,  1539,     0,  1175,
    1175,  1175,     0,     0,  1175,     0,     0,     0,     0,  1540,
       0,     0,  1171,     0,     0,     0,  1542,  1363,   947,     0,
       0,  1543,   947,     0,     0,     0,   947,     0,     0,     0,
       0,     0,  1175,     0,  1171,     0,     0,     0,     0,     0,
       0,  1363,     0,     0,     0,     0,  1553,     0,     0,     0,
       0,     0,     0,  1358,  1359,     0,     0,     0,  1171,  1171,
    1361,  1171,  1171,  1171,     0,     0,     0,     0,  1363,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1171,
       0,     0,     0,     0,     0,  1175,     0,     0,     0,     0,
       0,     0,     0,     0,  1362,     0,     0,     0,  1363,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1554,  1358,
    1359,     0,     0,     0,   947,     0,  1361,  1544,  1555,  1556,
    1557,  1545,  1558,  1559,  1560,  1561,  1562,  1563,     0,     0,
       0,     0,  2724,     0,     0,     0,     0,     0,     0,  1546,
    1547,     0,     0,     0,     0,     0,     0,     0,     0,  1171,
    1548,     0,  1171,  1171,     0,  1175,     0,     0,     0,     0,
    1714,   598,   598,     0,  1175,     0,  1175,     0,     0,     0,
       0,     0,  1369,     0,  1549,     0,  1175,  1550,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   947,  1551,     0,
    1552,     0,   947,     0,     0,     0,   947,     0,     0,     0,
       0,     0,  1175,  1175,     0,  1366,  1175,  1366,   598,     0,
       0,     0,     0,  1362,     0,     0,  1368,     0,     0,     0,
       0,  1366,     0,     0,     0,     0,  1368,   947,     0,  1539,
       0,     0,     0,     0,     0,     0,     0,  1363,     0,     0,
       0,  1540,  1553,     0,     0,     0,     0,     0,  1542,     0,
    1175,     0,     0,  1543,     0,     0,     0,     0,     0,     0,
       0,     0,   598,     0,     0,  1539,     0,     0,     0,     0,
       0,     0,  1175,     0,     0,  1366,     0,  1368,     0,     0,
       0,     0,  1175,     0,  1542,     0,   947,     0,     0,  1543,
       0,  1369,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1368,     0,  1554,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1555,  1556,  1557,  1362,  1558,  1559,
    1560,  1561,  1562,  1563,     0,     0,   947,     0,  2741,     0,
    1175,  1171,     0,  1368,     0,     0,     0,  1368,     0,     0,
       0,     0,  1363,     0,     0,     0,     0,     0,     0,  1544,
    1175,     0,     0,  1545,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     945,  1546,  1547,  1362,     0,     0,     0,     0,     0,     0,
       0,     0,  1548,     0,     0,  1544,     0,     0,     0,  1545,
       0,     0,     0,  1171,  1171,  1369,     0,     0,     0,     0,
       0,  1171,     0,     0,  1171,  1171,  1549,  1546,  1547,  1550,
       0,     0,     0,     0,     0,   947,     0,     0,  1548,     0,
    1551,     0,  1552,     0,  1171,     0,     0,     0,  1171,  1171,
    1171,     0,  1171,     0,     0,     0,     0,     0,     0,  1171,
    1171,     0,     0,  1171,     0,  1550,     0,     0,   947,     0,
       0,  1369,     0,     0,     0,     0,  1551,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1368,  1171,
     598,     0,  1171,  1171,  1553,     0,     0,  1171,     0,     0,
       0,  1171,     0,     0,  1171,  1171,  1171,  1171,  1171,  1171,
    1171,  1171,  1171,  1171,     0,     0,     0,  1171,     0,     0,
       0,  1171,     0,     0,     0,     0,     0,     0,     0,     0,
    1553,   658,     0,     0,     0,     0,     0,     0,     0,  1363,
       0,  1714,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   658,     0,  1554,     0,     0,     0,
       0,     0,     0,  1366,   598,     0,  1555,  1556,  1557,     0,
    1558,  1559,  1560,  1561,  1562,  1563,     0,     0,     0,     0,
    2872,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1554,     0,  1714,     0,     0,   598,     0,   598,
       0,     0,     0, -1636, -1636,     0,  1558,  1559,  1560,  1561,
    1562,  1563,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1539,     0,     0,     0,     0,     0,  1366,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1366,     0,
    1542,     0,     0,  1714,     0,  1543,     0,     0,     0,     0,
       0,     0,  1171,     0,   658,  1366,     0,  1366,  1363,     0,
    1368,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    78,     0,     0,     0,     0,     0,    82,
       0,     0,     0,     0,     0,     0,     0,    88,     0,    89,
       0,     0,    92,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1366,   102,     0,  1368,     0,  1368,     0,     0,
       0,     0,  2739,     0,     0,     0,     0,     0,     0,  1171,
       0,  1368,   116,   117,     0,     0,  1366,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -1636,     0,     0,     0,  1545,     0,     0,     0,   125,
       0,     0,     0,  1366,     0,     0,     0,   126,   127,   128,
       0,     0,  1363,  1546,  1547,     0,     0,     0,     0,     0,
       0,   856,     0,     0, -1636,  1368,     0,     0,     0,     0,
       0,     0,     0,  1366,     0,     0,     0,     0,     0,   137,
       0,   138,   139,     0,     0,     0,   141,   142,     0,     0,
       0,  1550,     0,   144,   145,     0,     0,  1171,     0,     0,
       0,     0,  1551,     0,   147,     0,   148,     0,  1363,   151,
       0,     0,     0,     0,  1171,   152,     0,     0,     0,     0,
       0,     0,     0,   154,     0,     0,     0,     0,   155,     0,
       0,     0,     0,   156,     0,   158,     0,     0,     0,   160,
       0,     0,     0,     0,     0,  1171,  1171,  1171,  1171,  1171,
     164,     0,   165,     0,     0,     0, -1636,     0,     0,     0,
       0,     0,     0,     0,  1171,  1171,  1171,  1171,     0,     0,
       0,     0,   169,     0,     0,  1171,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1171,     0,     0,
       0,     0,  1171,   177,   178,     0,     0,   179,     0,     0,
       0,     0,  1171,     0,   180,     0,     0,     0,     0,     0,
       0,     0,  1366,  1171,  1171,     0,  1171,   184,  1554,     0,
    1171,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1558,  1559,  1560,  1561,  1562,  1563,     0,     0,
     945,     0,  1171,  1171,     0,     0,   191,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   193,     0,     0,     0,
     194,     0,     0,     0,   195,     0,   197,     0,  1171,     0,
       0,     0,     0,     0,   199,  1171,  1171,  1171,     0,   200,
       0,     0,   202,     0,     0,     0,     0,     0,   205,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1171,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1368,   211,     0,   212,     0,     0,  1366,     0,   214,
       0,   215,     0,     0,     0,   216,     0,     0,     0,     0,
       0,     0,     0,  1368,     0,     0,  1539,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1540,     0,
       0,     0,     0,     0,     0,  1542,     0,     0,     0,     0,
    1543,     0,     0,   598,  1368,     0,     0,     0,   221,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1368,   658,     0,
       0,     0,     0,     0,     0,     0,   944,     0,  1368,     0,
     944,     0,     0,  1368,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1368,     0,  1368,     0,     0,
       0,     0,     0,     0,     0,   944,     0,     0,     0,     0,
       0,   945,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1544,     0,     0,     0,
    1545,     0,     0,  1171,     0,     0,     0,     0,     0,  1171,
     944,     0,  1368,     0,     0,     0,   944,     0,  1546,  1547,
       0,  1171,     0,  1171,     0,     0,     0,     0,  1171,  1548,
       0,     0,     0,     0,  1366,     0,  1368,  1171,     0,     0,
    1171,  1171,  1171,  1171,  1171,  1171,  1171,  1171,  1171,  1171,
       0,     0,     0,  1549,  1171,  1171,  1550,     0,     0,     0,
       0,     0,     0,  1368,     0,     0,     0,  1551,  1171,  1552,
       0,  1171,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1171,  1171,  1171,     0,  1171,     0,     0,
       0,     0,     0,  1368,  1171,     0,     0,     0,  1170,  1171,
       0,     0,  1171,     0,     0,     0,     0,     0,     0,     0,
       0,   945,     0,     0,     0,     0,   658,     0,     0,     0,
       0,  1553,     0,     0,     0,     0,     0,  1539,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1171,     0,  1540,
       0,     0,  1541,     0,     0,     0,  1542,     0,     0,     0,
       0,  1543,     0,  1366,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1554,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1555,  1556,  1557,     0,  1558,  1559,  1560,
    1561,  1562,  1563,     0,     0,     0,     0,  2932,   704,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   705,     0,
       0,  1171,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1368,     0,     0,     0,   706,     0,   944,     0,
       0,     0,   944,     0,     0,     0,     0,  1544,     0,     0,
       0,  1545,   707,     0,  -390,     0,  1367,  1366,     0,     0,
       0,   623,     0,     0,     0,     0,     0,   708,   623,  1546,
    1547,     0,     0,   709,     0,     0,     0,  1171,     0,     0,
    1548,     0,     0,     0,   710,     0,     0,  1171,     0,   944,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1367,
       0,     0,     0,     0,  1549,     0,     0,  1550,   623,     0,
       0,     0,     0,  1366,   711,     0,   712,     0,  1551,     0,
    1552,     0,     0,     0,     0,     0,   623,     0,  -491,     0,
       0,     0,     0,     0,     0,     0,     0,  1368,     0,   784,
       0,  1171,  1171,  1171,     0,     0,  1171,     0,     0,  -327,
       0,     0,     0,     0,  1170,     0,     0,   623,   713,   784,
     945,     0,     0,     0,   945,     0,     0,     0,   945,     0,
       0,     0,  1553,     0,  1171,     0,  1170,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   714,     0,   715,     0,     0,     0,     0,     0,
    1170,  1170,     0,  1170,  1170,  1170,     0,  1539,     0,     0,
       0,     0,     0,  -327,     0,     0,     0,     0,     0,  1540,
       0,  1170,  2233,     0,     0,     0,  1542,  1171,     0,     0,
       0,  1543,     0,   716,  1554,     0,     0,     0,  -238,     0,
       0,     0,     0,     0,  1555,  1556,  1557,     0,  1558,  1559,
    1560,  1561,  1562,  1563,     0,     0,   945,     0,     0,     0,
    -238,   717,     0,   718,     0,     0,     0,     0,     0,     0,
       0,     0,   719,     0,     0,     0,   720,   721,     0,     0,
     722,     0,     0,     0,     0,     0,   723,     0,     0,     0,
       0,  1170,     0,     0,  1170,  1170,     0,  1171,     0,     0,
       0,     0,     0,     0,     0,     0,  1171,     0,  1171,     0,
       0,     0,     0,     0,  1368,     0,     0,     0,  1171,     0,
       0,     0,     0,     0,     0,     0,     0,  1544,     0,   945,
       0,  1545,     0,     0,   945,     0,     0,     0,   945,     0,
       0,     0,     0,     0,  1171,  1171,     0,     0,  1171,  1546,
    1547,     0,     0,     0,     0,     0,     0,     0,  1367,     0,
    1548,     0,  1539,     0,     0,     0,     0,     0,  1367,   945,
       0,     0,     0,     0,  1540,     0,     0,     0,     0,     0,
       0,  1542,     0,     0,  1549,     0,  1543,  1550,     0,     0,
       0,     0,  1171,     0,     0,     0,     0,     0,  1551,     0,
    1552,     0,     0,     0,   658,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1171,     0,     0,     0,     0,  1367,
       0,     0,     0,     0,  1171,     0,     0,     0,   945,     0,
       0,     0,     0,  1368,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1367,     0,     0,     0,     0,     0,
       0,     0,  1553,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   945,     0,
       0,     0,  1171,  1170,     0,  1367,     0,     0,     0,  1367,
       0,     0,  1544,     0,     0,     0,  1545,     0,     0,     0,
       0,     0,  1171,     0,     0,     0,     0,     0,  1539,     0,
       0,     0,     0,     0,  1546,  1547,     0,     0,     0,     0,
    1540,     0,   944,     0,  1554,  1548,     0,  1542,     0,     0,
       0,     0,  1543,     0,  1555,  1556,  1557,     0,  1558,  1559,
    1560,  1561,  1562,  1563,     0,  1170,  1170,  1368,     0,  1549,
       0,     0,  1550,  1170,     0,     0,  1170,  1170,     0,     0,
       0,     0,     0,  1551,     0,  1552,     0,   945,     0,     0,
       0,     0,     0,     0,     0,     0,  1170,     0,     0,     0,
    1170,  1170,  1170,     0,  1170,     0,     0,     0,     0,     0,
       0,  1170,  1170,     0,     0,  1170,     0,     0,   623,     0,
     945,     0,     0,  1368,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1553,     0,     0,
    1367,  1170,   658,     0,  1170,  1170,     0,     0,  1544,  1170,
       0,     0,  1545,  1170,     0,     0,  1170,  1170,  1170,  1170,
    1170,  1170,  1170,  1170,  1170,  1170,     0,     0,     0,  1170,
    1546,  1547,     0,  1170,     0,     0,     0,     0,  2235,     0,
       0,  1548,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1554,
       0,     0,     0,     0,     0,  1549,     0,     0,  1550,  1555,
    1556,  1557,     0,  1558,  1559,  1560,  1561,  1562,  1563,  1551,
       0,  1552,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2249,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1539,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1540,     0,     0,  2284,
       0,     0,     0,  1542,     0,     0,     0,     0,  1543,     0,
       0,     0,     0,  1553,   784,     0,   784,     0,   784,     0,
       0,     0,     0,     0,   784,   784,     0,     0,     0,     0,
       0,  1539,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1540,  1170,     0,     0,     0,     0,     0,
    1542,     0,  1367,     0,     0,  1543,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1554,     0,     0,   623,     0,
       0,   623,     0,     0,     0,  1555,  1556,  1557,     0,  1558,
    1559,  1560,  1561,  1562,  1563,     0,     0,  1367,     0,  1367,
       0,     0,     0,     0,  1544,     0,     0,     0,  1545,     0,
       0,  1170,     0,  1367,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1546,  1547,     0,     0,
       0,     0,     0,     0,     0,     0,  1247,  1548,     0,     0,
    2289,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1544,   694,   623,   623,  1545,     0,     0,     0,     0,
       0,  1549,     0,     0,  1550,     0,     0,  1367,     0,     0,
    1247,     0,     0,  1546,  1547,  1551,     0,  1552,     0,     0,
       0,     0,     0,     0,  1548,     0,     0,     0,     0,     0,
     694,     0,     0,     0,     0,     0,     0,   694,     0,  1170,
       0,     0,     0,     0,     0,     0,     0,     0,  1549,     0,
       0,  1550,     0,     0,     0,     0,  1170,     0,     0,     0,
       0,     0,  1551,     0,  1552,     0,     0,   694,   694,  1553,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1170,  1170,  1170,
    1170,  1170,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1170,  1170,  1170,  1170,
       0,     0,     0,     0,     0,     0,  1553,  1170,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   623,     0,  1170,
       0,  1554,     0,     0,  1170,     0,     0,     0,     0,     0,
       0,  1555,  1556,  1557,  1170,  1558,  1559,  1560,  1561,  1562,
    1563,     0,     0,     0,     0,  1170,  1170,     0,  1170,     0,
       0,     0,  1170,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1554,     0,
       0,     0,   944,     0,  1170,  1170,     0,     0,  1555,  1556,
    1557,     0,  1558,  1559,  1560,  1561,  1562,  1563,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1170,     0,     0,     0,     0,     0,     0,  1170,  1170,  1170,
       0,     0,     0,     0,     0,   623,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   623,     0,     0,     0,
       0,     0,  1170,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1367,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   623,   623,     0,
       0,     0,     0,     0,     0,  1367,     0,     0,     0,   623,
       0,     0,  1247,     0,     0,     0,     0,  1247,  1247,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   658,  1367,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1367,
     623,     0,   623,     0,     0,     0,     0,     0,     0,     0,
    1367,     0,   784,     0,     0,  1367,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1367,     0,  1367,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   944,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1170,     0,     0,     0,     0,
       0,  1170,     0,     0,  1367,     0,     0,     0,     0,     0,
       0,     0,     0,  1170,     0,  1170,     0,     0,     0,     0,
    1170,     0,     0,     0,     0,     0,     0,     0,  1367,  1170,
       0,     0,  1170,  1170,  1170,  1170,  1170,  1170,  1170,  1170,
    1170,  1170,     0,     0,     0,     0,  1170,  1170,     0,     0,
       0,     0,     0,     0,     0,  1367,     0,     0,     0,     0,
    1170,     0,     0,  1170,     0,     0,     0,     0,     0,   623,
       0,     0,     0,     0,     0,  1170,  1170,  1170,     0,  1170,
       0,     0,     0,     0,     0,  1367,  1170,     0,     0,     0,
       0,  1170,     0,     0,  1170,     0,     0,     0,     0,     0,
       0,     0,     0,   944,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   939,   949,
       0,   949,   939,     0,     0,     0,     0,   694,   694,  1170,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   694,   939,     0,     0,
       0,     0,     0,   949,     0,     0,   784,     0,   784,     0,
       0,     0,   784,     0,   949,     0,     0,   623,   784,     0,
       0,     0,     0,     0,     0,   784,     0,     0,     0,     0,
     695,   694,   939,     0,     0,   784,     0,   784,   939,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   949,     0,     0,     0,   784,     0,   784,     0,
       0,     0,     0,  1170,     0,     0,     0,     0,   695,     0,
       0,     0,     0,     0,  1367,   695,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1539,     0,     0,     0,   694,     0,     0,     0,     0,
       0,   694,     0,  1540,     0,   695,   695,     0,     0,   694,
    1542,     0,     0,     0,     0,  1543,     0,     0,     0,  1170,
       0,     0,     0,     0,   623,     0,     0,     0,     0,  1170,
       0,     0,     0,     0,     0,     0,     0,   694,     0,     0,
       0,     0,   694,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   694,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1367,
       0,     0,     0,  1170,  1170,  1170,     0,     0,  1170,     0,
       0,     0,     0,     0,  1247,     0,     0,     0,     0,     0,
     623,     0,   944,     0,     0,     0,   944,     0,     0,  1247,
     944,  1544,     0,     0,     0,  1545,  1170,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1546,  1547,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1548,     0,     0,     0,     0,   949,
       0,  1247,     0,     0,  1247,  1247,     0,     0,     0,   694,
     939,     0,     0,     0,   939,     0,     0,     0,  1549,  1170,
       0,  1550,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   784,  1551,     0,  1552,     0,     0,   949,   623,     0,
       0,   623,     0,     0,     0,   623,     0,     0,   944,     0,
       0,     0,     0,   784,     0,     0,   694,   694,   784,   949,
       0,   939,     0,   694,     0,     0,     0,     0,     0,     0,
     784,     0,     0,     0,     0,   949,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1553,     0,     0,  1170,
       0,     0,     0,   623,     0,     0,     0,     0,  1170,     0,
    1170,     0,     0,     0,  2508,     0,  1367,   694,     0,     0,
    1170,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   944,     0,     0,     0,     0,   944,     0,     0,     0,
     944,     0,     0,     0,     0,     0,  1170,  1170,     0,     0,
    1170,     0,     0,     0,     0,     0,     0,     0,  1554,     0,
       0,     0,     0,   784,     0,     0,     0,  1539,  1555,  1556,
    1557,   944,  1558,  1559,  1560,  1561,  1562,  1563,     0,  1540,
       0,     0,     0,     0,     0,     0,  1542,     0,     0,     0,
       0,  1543,     0,     0,  1170,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1170,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1170,     0,     0,     0,
     944,     0,     0,     0,     0,  1367,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1151,     0,     0,     0,     0,     0,     0,
     694,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     944,     0,     0,     0,  1170,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1544,     0,     0,
       0,  1545,     0,     0,  1170,     0,     0,     0,     0,     0,
       0,   784,     0,     0,     0,     0,     0,  1247,     0,  1546,
    1547,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1548,     0,     0,     0,     0,     0,   940,   940,     0,   940,
     940,     0,     0,     0,     0,   695,   695,     0,     0,  1367,
       0,     0,     0,     0,  1549,     0,     0,  1550,     0,     0,
       0,     0,     0,     0,   695,   940,     0,     0,  1551,   944,
    1552,   940,     0,     0,     0,     0,     0,   694,     0,     0,
       0,     0,   940,     0,  1247,     0,     0,     0,     0,     0,
    1247,  1247,     0,     0,     0,     0,     0,     0,     0,   695,
     940,     0,   944,     0,     0,  1367,   940,     0,     0,     0,
     623,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     940,     0,  1553,     0,  1247,     0,     0,     0,     0,   784,
       0,   784,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2433,   623,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   695,     0,     0,     0,     0,     0,   695,
       0,     0,   694,   694,     0,     0,     0,   695,   949,     0,
       0,     0,     0,     0,  1554,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1555,  1556,  1557,     0,  1558,  1559,
    1560,  1561,  1562,  1563,   939,   695,     0,   694,     0,     0,
     695,     0,     0,     0,     0,     0,     0,   694,     0,  1470,
       0,     0,   695,     0,     0,     0,   694,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   784,
       0,  1494,     0,     0,     0,   784,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1517,  1518,     0,  1519,  1520,
    1523,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1538,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   623,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   940,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   695,   940,     0,
     694,     0,   940,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   940,  1630,     0,     0,  1636,
    1638,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   695,   695,     0,   940,     0,   940,
       0,   695,     0,     0,   694,     0,     0,     0,     0,     0,
       0,     0,     0,   940,     0,     0,     0,     0,     0,     0,
       0,   623,   623,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   784,     0,     0,     0,     0,
     784,   784,   784,   784,   784,   695,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     4,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     5,     0,     0,     0,     0,     0,     0,
       0,   623,     6,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     7,     8,     0,     0,     0,     0,
       9,     0,    10,    11,     0,     0,     0,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,     0,     0,   949,   949,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1824,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    36,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   695,     0,
       0,     0,     0,   694,     0,     0,     0,     0,   694,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   623,
       0,     0,     0,     0,     0,     0,     0,     0,  1878,     0,
       0,     0,  1880,     0,     0,     0,     0,     0,   784,     0,
       0,     0,   623,   623,    37,     0,     0,   623,     0,     0,
       0,  1899,     0,     0,     0,  1904,     0,  1916,     0,  1917,
      38,     0,     0,     0,     0,     0,  1924,  1929,     0,     0,
    1932,     0,     0,     0,     0,     0,     0,    39,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   623,     0,     0,   695,  1958,   623,     0,     0,
    1962,   623,     0,    40,  1973,     0,    41,     0,  1980,     0,
       0,  1982,  1983,  1984,  1985,  1986,  1987,  1988,  1989,  1990,
    1991,     0,    42,     0,  1151,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    43,     0,     0,   694,     0,
       0,     0,     0,     0,  2339,     0,     0,     0,     0,     0,
     695,   695,     0,     0,     0,     0,   940,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    44,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    45,
       0,     0,   940,     0,     0,   695,     0,     0,     0,     0,
       0,    46,     0,     0,     0,   695,     0,     0,     0,     0,
       0,     0,     0,    47,   695,     0,    48,    49,     0,    50,
       0,    51,     0,     0,     0,    52,     0,    53,    54,  2069,
       0,     0,    55,    56,    57,    58,    59,     0,     0,    60,
      61,    62,    63,     0,    64,    65,    66,    67,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   623,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2126,     0,     0,     0,
       0,     0,     0,     0,     0,   623,   623,   694,     0,     0,
       0,     0,     0,   694,     0,     0,     0,     0,   695,     0,
       0,     0,     0,     0,  2469,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   784,   784,     0,     0,     0,
       0,     0,     0,     0,     0,   939,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   695,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1151,     0,     0,     0,   949,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2229,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2255,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1929,     0,  1929,  1929,     0,     0,     0,     0,     0,
       0,     0,  2295,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   694,   694,  2339,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2317,     0,  2319,     0,     0,     0,  2322,     0,     0,
       0,   940,   940,     0,     0,     0,     0,     0,   942,     0,
       0,     0,   942,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   942,     0,     0,
       0,     0,     0,     0,     0,  1630,     0,     0,     0,     0,
       0,   695,  1638,  1638,  1636,     0,   695,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   694,   942,     0,     0,     0,     0,  2376,   942,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   694,     0,     0,     0,     0,     0,     0,   694,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1167,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   694,   694,   694,   694,     0,     0,     0,     0,
       0,     0,     0,     0,  2339,     0,     0,     0,  2339,     0,
       0,     0,  2339,     0,     0,     0,   695,     0,     0,     0,
    2505,     0,   695,     0,     0,     0,  2509,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2514,     0,
    2515,     0,     0,     0,     0,  2518,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2535,  2536,     0,     0,     0,     0,     0,     0,     0,
     942,     0,     0,     0,   942,     0,     0,     0,  2547,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1365,     0,
     939,     0,  2555,     0,  2557,     0,     0,     0,     0,     0,
       0,  2561,     0,     0,     0,     0,  2565,     0,     0,  2568,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   942,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1365,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2605,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2339,     0,   695,     0,     0,  2339,     0,
       0,   695,  2339,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   940,     0,     0,     0,  1167,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   939,     0,   694,     0,     0,  1167,     0,
       0,     0,     0,   940,     0,     0,     0,     0,     0,     0,
     694,     0,     0,     0,     0,   949,     0,     0,     0,   949,
       0,     0,  1167,  1167,     0,  1167,  1167,  1167,     0,     0,
       0,     0,     0,   694,     0,     0,   940,     0,     0,     0,
       0,     0,     0,  1167,     0,     0,     0,     0,     0,     0,
       0,     0,  2339,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   694,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1151,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2720,     0,     0,     0,     0,     0,
       0,     0,   939,   949,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1167,     0,     0,  1167,  1167,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   695,   695,   695,     0,   949,     0,     0,     0,  2737,
    2738,     0,     0,  2740,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   949,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1365,   939,     0,     0,     0,     0,     0,     0,     0,     0,
    1365,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   939,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2794,     0,     0,     0,     0,   695,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1365,     0,     0,     0,     0,     0,     0,     0,   695,
       0,     0,     0,     0,     0,     0,   695,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1365,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1151,  1167,     0,  1365,     0,     0,
       0,  1365,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2840,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   942,     0,     0,     0,     0,     0,
       0,     0,  2857,     0,     0,  2859,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1167,  1167,     0,
       0,     0,     0,     0,     0,  1167,     0,     0,  1167,  1167,
     695,   695,   695,   695,     0,     0,     0,     0,     0,     0,
       0,     0,   695,     0,     0,     0,   695,     0,  1167,  2887,
     695,     0,  1167,  1167,  1167,     0,  1167,     0,     0,     0,
       0,     0,     0,  1167,  1167,     0,     0,  1167,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2906,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1365,  1167,     0,     0,  1167,  1167,     0,     0,
       0,  1167,     0,     0,     0,  1167,     0,     0,  1167,  1167,
    1167,  1167,  1167,  1167,  1167,  1167,  1167,  1167,     0,     0,
       0,  1167,     0,     0,     0,  1167,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   940,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2859,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   695,     0,     0,     0,     0,   695,     0,     0,     0,
     695,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   940,     0,   695,     0,     0,  1167,     0,     0,     0,
       0,     0,     0,     0,  1365,     0,     0,  1564,   695,     0,
       0,     0,     0,   940,     0,     0,     0,   940,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   695,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1365,
     695,  1365,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   695,  1167,     0,  1365,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     940,   940,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1365,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   940,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1167,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   940,  1167,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   940,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1167,
    1167,  1167,  1167,  1167,     0,     0,     0,     0,     0,     0,
       0,     0,   940,     0,     0,     0,     0,     0,  1167,  1167,
    1167,  1167,     0,     0,     0,     0,     0,     0,     0,  1167,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1167,     0,     0,     0,     0,  1167,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1167,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1167,  1167,     0,
    1167,     0,     0,     0,  1167,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   942,     0,  1167,  1167,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1167,     0,     0,     0,  1564,     0,     0,  1167,
    1167,  1167,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1564,     0,     0,     0,  1167,     0,  1910,     0,     0,     0,
       0,     0,     0,     0,     0,  1365,     0,     0,     0,     0,
       0,     0,     0,  1564,  1564,  1564,  1564,     0,     0,  1564,
       0,     0,     0,     0,     0,     0,     0,  1365,     0,     0,
       0,     0,     0,     0,  1564,     0,     0,     0,     0,  1910,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1365,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1365,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1365,     0,     0,     0,     0,  1365,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1365,
       0,  1365,     0,     0,     0,     0,  1564,     0,     0,     0,
       0,     0,  1564,     0,  1564,   942,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1167,     0,     0,
       0,     0,     0,  1167,     0,     0,  1365,     0,     0,     0,
       0,     0,     0,     0,     0,  1167,     0,  1167,     0,     0,
       0,     0,  1167,     0,     0,     0,     0,     0,     0,     0,
    1365,  1167,     0,     0,  1167,  1167,  1167,  1167,  1167,  1167,
    1167,  1167,  1167,  1167,     0,     0,     0,     0,  1167,  1167,
       0,     0,     0,     0,     0,     0,     0,  1365,     0,     0,
       0,     0,  1167,     0,     0,  1167,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1167,  1167,  1167,
       0,  1167,     0,     0,     0,     0,     0,  1365,  1167,     0,
       0,     0,     0,  1167,     0,     0,  1167,     0,     0,     0,
       0,     0,     0,     0,     0,   942,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1167,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1564,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1564,     0,     0,     0,     0,
       0,     0,     0,     0,  1564,  1167,  1564,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1365,     0,     0,     0,
       0,     0,     0,     0,     0,  1564,     0,     0,     0,     0,
    1564,     0,  1910,  1910,  1910,     0,  1910,  2271,     0,     0,
       0,     0,  1564,  1564,     0,     0,     0,     0,     0,     0,
    1564,     0,     0,     0,     0,  1564,     0,     0,  1564,     0,
       0,  1167,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1167,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1564,     0,     0,  2271,  1564,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1564,
    1910,     0,     0,     0,     0,     0,  1564,     0,  1564,  1564,
    1564,  1564,  1564,  1564,  1564,  1564,  1564,  1564,     0,     0,
       0,  1365,     0,     0,     0,  1167,  1167,  1167,     0,     0,
    1167,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   942,     0,     0,     0,   942,     0,
       0,     0,   942,     0,     0,     0,     0,     0,  1167,     0,
       0,     0,     0,     0,     4,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     5,
       0,     0,     0,     0,     0,     0,     0,     0,     6,     0,
       0,     0,     0,     0,     0,  1564,     0,     0,     0,     0,
       7,     8,     0,     0,     0,     0,     0,     0,    10,    11,
       0,  1167,     0,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    35,     0,     0,     0,
     942,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1564,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    36,     0,     0,     0,     0,     0,
       0,  1167,     0,     0,     0,     0,     0,     0,     0,     0,
    1167,     0,  1167,     0,     0,     0,     0,     0,  1365,     0,
       0,     0,  1167,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   942,     0,     0,     0,     0,   942,     0,
       0,     0,   942,     0,     0,     0,     0,     0,  1167,  1167,
       0,     0,  1167,     0,     0,     0,     0,     0,     0,     0,
      37,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   942,     0,  1564,    38,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    39,     0,     0,  1167,     0,  2271,  2271,
    2271,  1564,  2271,     0,  1910,     0,     0,  1910,  1910,  1910,
    1910,  1910,  1910,  1910,  1910,  1910,  1910,     0,  1167,    40,
       0,     0,    41,     0,     0,     0,     0,     0,  1167,     0,
       0,     0,   942,     0,     0,     0,     0,  1365,    42,     0,
       0,  1564,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1910,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2271,  1564,     0,  1564,     0,     0,  1564,     0,
       0,     0,   942,     0,     0,     0,  1167,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    43,     0,     0,     0,     0,  1167,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1564,    44,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    45,     0,     0,     0,     0,
       0,  1365,     0,     0,     0,     0,     0,    46,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    47,
       0,   942,    48,    49,     0,    50,     0,     0,     0,     0,
       0,    52,     0,    53,    54,     0,     0,     0,    55,    56,
      57,    58,    59,     0,     0,    60,    61,   913,  1910,     0,
       0,   914,     0,     0,   942,     0,     0,  1365,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1564,     0,     0,     0,  1564,     0,     0,     0,     0,
    1564,  1564,     0,     0,  1564,     0,     0,  2271,     0,     0,
       0,  2271,  2271,  2271,  2271,  2271,  2271,  2271,  2271,  2271,
    2271,  1564,  1564,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1564,     0,     0,     0,     0,     0,     0,
    2271,  1564,     0,  1564,     0,     0,     0,  1564,  1910,     0,
       0,  1564,     0,     0,  1564,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1564,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2271,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1564,     0,     0,     0,
       0,     0,     0,  1910,     0,  1910,     0,     0,     0,     0,
       0,     0,  2271,  1564,  1564,     0,  1564,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1564,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2271,  1910,  2271,     0,     0,     0,  1564,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1564,     0,  1564,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1564,     0,   640,    79,    80,    81,   339,
       0,    83,    84,     0,    85,    86,    87,   340,  2271,   341,
       0,    91,  1564,    93,    94,    95,    96,    97,    98,   641,
      99,   100,   101,   342,   642,   103,     0,   104,   105,   106,
     107,   643,   644,     0,   109,   110,   111,     0,   112,   645,
     646,   115,   343,   344,     0,     0,     0,   601,   602,     0,
       0,     0,     0,   603,     0,     0,     0,     0,     0,     0,
       0,     0,   604,     0,   605,     0,   606,   607,     0,   345,
     346,   347,   348,   349,   350,   351,   352,   353,   354,   355,
     356,   357,   358,   359,   360,   361,   362,   363,   130,   364,
     365,   366,   132,   133,   134,   135,     0,   367,   368,   369,
       0,   370,   371,   372,   373,   647,   136,   374,   375,   376,
     377,   378,   379,   140,   380,   381,   382,   383,   384,   385,
     386,   387,   143,   388,   389,   390,   391,   146,   392,   393,
     394,   395,   396,   397,   398,   399,   400,   149,   150,   401,
     402,   403,   404,   405,     0,   406,   407,   408,   409,   410,
     411,   412,   413,   414,   415,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   157,   425,     0,   159,   426,   427,
     428,   161,   429,   430,   431,   432,   162,   433,   163,   434,
       0,   435,   436,   437,   438,   439,   440,   441,   166,   442,
     443,   444,   167,   445,   446,   447,   448,   449,   168,   450,
     648,   451,   452,   453,   649,   170,   454,   171,   455,     0,
     172,   173,   456,   174,   457,   458,   459,   460,   461,   175,
     462,   176,   463,   464,   465,   466,   467,   468,   469,   470,
     471,   472,   473,   474,   475,   476,   477,   181,   182,   478,
     479,   480,   481,   482,   183,   483,   484,   485,   185,   486,
     186,   187,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   188,   189,     0,   499,   500,   501,
     502,   503,     0,   190,   504,   505,   506,   507,   508,   509,
     510,   511,   512,   192,   513,   514,   515,   516,   517,   518,
     519,   520,   521,   522,   523,   196,   524,   198,   525,   526,
     527,   528,   529,     0,   530,   531,   532,   533,   534,   535,
     201,   536,   537,   203,   538,   204,   539,   540,   541,   542,
     543,   544,   545,   546,   547,   206,   548,   549,   550,   551,
     552,   553,   207,   208,   554,   555,   556,   557,   209,   558,
     210,   559,   560,   561,   562,   563,   650,   564,   565,   566,
     567,   568,   569,   570,   571,   572,   573,   574,   217,   575,
     218,   576,   577,     0,   578,   579,   580,   581,   582,   583,
     584,   585,     0,   219,     0,     0,   220,     0,     0,    79,
      80,    81,   339,     0,    83,    84,     0,    85,    86,    87,
     340,     0,   341,    90,    91,     0,    93,    94,    95,    96,
      97,    98,   651,    99,   100,   101,   342,     0,   103,     0,
     104,   105,   106,   107,     0,   108,     0,   109,   110,   111,
       0,   112,   113,   114,   115,   343,   344,     0,     0,     0,
     118,   119,     0,     0,     0,     0,   120,     0,     0,     0,
       0,     0,     0,     0,     0,   121,     0,   122,     0,   123,
       0,     0,   345,   346,   347,   348,   349,   350,   351,   352,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
     363,   130,   364,   365,   366,   132,   133,   134,   135,     0,
     367,   368,   369,     0,   370,   371,   372,   373,     0,   136,
     374,   375,   376,   377,   378,   379,   140,   380,   381,   382,
     383,   384,   385,   386,   387,   143,   388,   389,   390,   391,
     146,   392,   393,   394,   395,   396,   397,   398,   399,   400,
     149,   150,   401,   402,   403,   404,   405,     0,   406,   407,
     408,   409,   410,   411,   412,   413,   414,   415,   416,   417,
     418,   419,   420,   421,   422,   423,   424,   157,   425,     0,
     159,   426,   427,   428,   161,   429,   430,   431,   432,   162,
     433,   163,   434,     0,   435,   436,   437,   438,   439,   440,
     441,   166,   442,   443,   444,   167,   445,   446,   447,   448,
     449,   168,   450,     0,   451,   452,   453,     0,   170,   454,
     171,   455,     0,   172,   173,   456,   174,   457,   458,   459,
     460,   461,   175,   462,   176,   463,   464,   465,   466,   467,
     468,   469,   470,   471,   472,   473,   474,   475,   476,   477,
     181,   182,   478,   479,   480,   481,   482,   183,   483,   484,
     485,   185,   486,   186,   187,   487,   488,   489,   490,   491,
     492,   493,   494,   495,   496,   497,   498,   188,   189,     0,
     499,   500,   501,   502,   503,     0,   190,   504,   505,   506,
     507,   508,   509,   510,   511,   512,   192,   513,   514,   515,
     516,   517,   518,   519,   520,   521,   522,   523,   196,   524,
     198,   525,   526,   527,   528,   529,     0,   530,   531,   532,
     533,   534,   535,   201,   536,   537,   203,   538,   204,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   206,   548,
     549,   550,   551,   552,   553,   207,   208,   554,   555,   556,
     557,   209,   558,   210,   559,   560,   561,   562,   563,   213,
     564,   565,   566,   567,   568,   569,   570,   571,   572,   573,
     574,   217,   575,   218,   576,   577,     0,   578,   579,   580,
     581,   582,   583,   584,   585,     0,   219,     0,     0,   220,
       0,     0,     0,    79,    80,    81,   339,     0,    83,    84,
       0,    85,    86,    87,   340,     0,   341,    90,    91,     0,
      93,    94,    95,    96,    97,    98,  2042,    99,   100,   101,
     342,     0,   103,     0,   104,   105,   106,   107,     0,   108,
       0,   109,   110,   111,     0,   112,   113,   114,   115,   343,
     344,     0,     0,     0,   118,   119,     0,     0,     0,     0,
     120,     0,     0,     0,     0,     0,     0,     0,     0,   121,
       0,   122,     0,   123,     0,     0,   345,   346,   347,   348,
     349,   350,   351,   352,   353,   354,   355,   356,   357,   358,
     359,   360,   361,   362,   363,   130,   364,   365,   366,   132,
     133,   134,   135,     0,   367,   368,   369,     0,   370,   371,
     372,   373,     0,   136,   374,   375,   376,   377,   378,   379,
     140,   380,   381,   382,   383,   384,   385,   386,   387,   143,
     388,   389,   390,   391,   146,   392,   393,   394,   395,   396,
     397,   398,   399,   400,   149,   150,   401,   402,   403,   404,
     405,     0,   406,   407,   408,   409,   410,   411,   412,   413,
     414,   415,   416,   417,   418,   419,   420,   421,   422,   423,
     424,   157,   425,     0,   159,   426,   427,   428,   161,   429,
     430,   431,   432,   162,   433,   163,   434,     0,   435,   436,
     437,   438,   439,   440,   441,   166,   442,   443,   444,   167,
     445,   446,   447,   448,   449,   168,   450,     0,   451,   452,
     453,     0,   170,   454,   171,   455,     0,   172,   173,   456,
     174,   457,   458,   459,   460,   461,   175,   462,   176,   463,
     464,   465,   466,   467,   468,   469,   470,   471,   472,   473,
     474,   475,   476,   477,   181,   182,   478,   479,   480,   481,
     482,   183,   483,   484,   485,   185,   486,   186,   187,   487,
     488,   489,   490,   491,   492,   493,   494,   495,   496,   497,
     498,   188,   189,     0,   499,   500,   501,   502,   503,     0,
     190,   504,   505,   506,   507,   508,   509,   510,   511,   512,
     192,   513,   514,   515,   516,   517,   518,   519,   520,   521,
     522,   523,   196,   524,   198,   525,   526,   527,   528,   529,
       0,   530,   531,   532,   533,   534,   535,   201,   536,   537,
     203,   538,   204,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   206,   548,   549,   550,   551,   552,   553,   207,
     208,   554,   555,   556,   557,   209,   558,   210,   559,   560,
     561,   562,   563,   213,   564,   565,   566,   567,   568,   569,
     570,   571,   572,   573,   574,   217,   575,   218,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   585,     0,
     219,     0,     0,   220,    78,     0,     0,    79,    80,    81,
      82,     0,    83,    84,     0,    85,    86,    87,    88,     0,
      89,    90,    91,    92,    93,    94,    95,    96,    97,    98,
    2044,    99,   100,   101,   102,     0,   103,     0,   104,   105,
     106,   107,     0,   108,     0,   109,   110,   111,     0,   112,
     113,   114,   115,   116,   117,     0,     0,     0,   118,   119,
       0,     0,     0,     0,   120,     0,     0,     0,     0,     0,
       0,     0,     0,   121,     0,   122,     0,   123,   124,     0,
     125,     0,     0,     0,     0,     0,     0,     0,   126,   127,
     128,     0,     0,     0,     0,     0,     0,     0,   129,   130,
       0,     0,   131,   132,   133,   134,   135,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   136,     0,     0,
     137,     0,   138,   139,   140,     0,     0,   141,   142,     0,
       0,     0,     0,   143,   144,   145,     0,     0,   146,     0,
       0,     0,     0,     0,     0,   147,     0,   148,   149,   150,
     151,     0,     0,     0,     0,     0,   152,     0,     0,     0,
       0,     0,     0,   153,   154,     0,     0,     0,     0,   155,
       0,     0,     0,     0,   156,   157,   158,     0,   159,     0,
     160,     0,   161,     0,     0,     0,     0,   162,     0,   163,
       0,   164,     0,   165,     0,     0,     0,     0,     0,   166,
       0,     0,     0,   167,     0,     0,     0,     0,     0,   168,
       0,     0,     0,   169,     0,     0,   170,     0,   171,     0,
       0,   172,   173,     0,   174,     0,     0,     0,     0,     0,
     175,     0,   176,     0,   177,   178,     0,     0,   179,     0,
       0,     0,     0,     0,     0,   180,     0,     0,   181,   182,
       0,     0,     0,     0,     0,   183,     0,     0,   184,   185,
       0,   186,   187,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   188,   189,     0,     0,     0,
       0,     0,     0,     0,   190,     0,     0,   191,     0,     0,
       0,     0,     0,     0,   192,     0,     0,   193,     0,     0,
       0,   194,     0,     0,     0,   195,   196,   197,   198,     0,
       0,     0,     0,     0,     0,   199,     0,     0,     0,     0,
     200,   201,     0,   202,   203,     0,   204,     0,     0,   205,
       0,     0,     0,     0,     0,     0,   206,     0,     0,     0,
       0,     0,     0,   207,   208,     0,     0,     0,     0,   209,
       0,   210,     0,   211,     0,   212,     0,   213,     0,     0,
     214,     0,   215,     0,     0,     0,   216,     0,     0,   217,
       0,   218,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   219,     0,     0,   220,     0,     0,
       0,     0,   640,    79,    80,    81,   339,     0,    83,    84,
       0,    85,    86,    87,   340,     0,   341,     0,    91,   221,
      93,    94,    95,    96,    97,    98,   641,    99,   100,   101,
     342,   642,   103,     0,   104,   105,   106,   107,   643,   644,
       0,   109,   110,   111,     0,   112,   645,   646,   115,   343,
     344,     0,     0,     0,   601,   602,     0,     0,     0,     0,
     603,     0,     0,     0,     0,     0,     0,     0,     0,   604,
       0,   605,     0,   606,   607,     0,   345,   346,   347,   348,
     349,   350,   351,  2003,   353,     0,     0,     0,     0,  1079,
       0,     0,   361,   362,   363,   130,   364,   365,   366,   132,
    1080,   134,  1081,  1082,     0,   368,   369,     0,   370,  1083,
    1084,   373,  1085,  1086,   374,     0,   376,   377,   378,   379,
    1087,     0,     0,   382,   383,   384,     0,   386,   387,  1088,
     388,     0,   390,   391,   146,  1089,  1090,  1091,  1092,   396,
     397,   398,   399,   400,  1093,  1094,   401,     0,   403,     0,
     405,     0,   406,   407,   408,     0,  2004,     0,   412,  1095,
     414,   415,     0,   417,   418,     0,   420,     0,   422,   423,
     424,  1096,   425,     0,  1097,  1098,   427,   428,  1099,     0,
     430,     0,   432,   162,     0,   163,   434,     0,   435,     0,
       0,   438,     0,   440,   441,   166,   442,   443,   444,   167,
     445,   446,   447,   448,     0,   168,   450,     0,   451,   452,
     453,  1100,  1101,     0,  1102,     0,     0,   172,   173,   456,
     174,   457,   458,   459,   460,     0,   175,   462,   176,     0,
     464,   465,   466,   467,   468,   469,   470,   471,   472,   473,
     474,   475,   476,  1103,   181,  1104,   692,   479,   480,   481,
     482,   183,  1105,   484,   485,   185,  1106,  1107,  1108,   487,
       0,     0,   490,   693,     0,     0,  1109,   495,     0,     0,
     498,   188,   189,  1110,   499,   500,   501,   502,   503,     0,
    1111,   504,   505,   506,     0,   508,   509,   510,   511,   512,
    1112,   513,     0,   515,   516,   517,   518,   519,   520,   521,
     522,   523,   196,   524,  1113,   525,   526,   527,   528,   529,
       0,     0,   531,   532,   533,  1114,   535,   201,   536,   537,
     203,   538,  1115,     0,   540,   541,   542,   543,   544,   545,
     546,   547,  1116,   548,     0,   550,   551,   552,     0,  1117,
    1118,     0,   555,     0,   557,  1119,   558,  1120,  1121,   560,
     561,   562,   563,     0,  1122,   565,   566,   567,   568,   569,
    1123,     0,   572,   573,   574,  1124,   575,   218,   576,   577,
       0,     0,     0,   580,   581,   582,   583,   584,   585,     0,
     219,    49,  1125,   220,   610,     0,     0,  1126,  1127,    52,
    1128,    53,     0,     0,     0,     0,  1129,  1130,  2005,     0,
    1132,  1133,     0,     0,     0,  1134,  2006,   640,    79,    80,
      81,   339,     0,    83,    84,     0,    85,    86,    87,   340,
       0,   341,     0,    91,     0,    93,    94,    95,    96,    97,
      98,   641,    99,   100,   101,   342,   642,   103,     0,   104,
     105,   106,   107,   643,   644,     0,   109,   110,   111,     0,
     112,   645,   646,   115,   343,   344,     0,     0,     0,   601,
     602,     0,     0,     0,     0,   603,     0,     0,     0,     0,
       0,     0,     0,     0,   604,     0,   605,     0,   606,   607,
       0,   345,   346,   347,   348,   349,   350,   351,     0,   353,
       0,     0,     0,     0,  1079,     0,     0,   361,   362,   363,
     130,   364,   365,   366,   132,  1080,   134,  1081,  1082,     0,
     368,   369,     0,   370,  1083,  1084,   373,  1085,  1086,   374,
       0,   376,   377,   378,   379,  1087,     0,     0,   382,   383,
     384,     0,   386,   387,  1088,   388,     0,   390,   391,   146,
    1089,  1090,  1091,  1092,   396,   397,   398,   399,   400,  1093,
    1094,   401,     0,   403,     0,   405,     0,   406,   407,   408,
       0,     0,     0,   412,  1095,   414,   415,     0,   417,   418,
       0,   420,     0,   422,   423,   424,  1096,   425,     0,  1097,
    1098,   427,   428,  1099,     0,   430,     0,   432,   162,     0,
     163,   434,     0,   435,     0,     0,   438,     0,   440,   441,
     166,   442,   443,   444,   167,   445,   446,   447,   448,     0,
     168,   450,     0,   451,   452,   453,  1100,  1101,     0,  1102,
       0,     0,   172,   173,   456,   174,   457,   458,   459,   460,
       0,   175,   462,   176,     0,   464,   465,   466,   467,   468,
     469,   470,   471,   472,   473,   474,   475,   476,  1103,   181,
    1104,   692,   479,   480,   481,   482,   183,  1105,   484,   485,
     185,  1106,  1107,  1108,   487,     0,     0,   490,   693,     0,
       0,  1109,   495,     0,     0,   498,   188,   189,  1110,   499,
     500,   501,   502,   503,     0,  1111,   504,   505,   506,     0,
     508,   509,   510,   511,   512,  1112,   513,     0,   515,   516,
     517,   518,   519,   520,   521,   522,   523,   196,   524,  1113,
     525,   526,   527,   528,   529,     0,     0,   531,   532,   533,
    1114,   535,   201,   536,   537,   203,   538,  1115,     0,   540,
     541,   542,   543,   544,   545,   546,   547,  1116,   548,     0,
     550,   551,   552,     0,  1117,  1118,     0,   555,     0,   557,
    1119,   558,  1120,  1121,   560,   561,   562,   563,     0,  1122,
     565,   566,   567,   568,   569,  1123,     0,   572,   573,   574,
    1124,   575,   218,   576,   577,     0,     0,     0,   580,   581,
     582,   583,   584,   585,     0,   219,    49,  1125,   220,   610,
       0,     0,  1126,  1127,    52,  1128,    53,     0,     0,     0,
       0,  1129,  1130,     0,     0,  1132,  1133,     0,     0,     0,
    1134,  1914,   640,    79,    80,    81,   339,     0,    83,    84,
       0,    85,    86,    87,   340,     0,   341,     0,    91,     0,
      93,    94,    95,    96,    97,    98,   641,    99,   100,   101,
     342,   642,   103,     0,   104,   105,   106,   107,   643,   644,
       0,   109,   110,   111,     0,   112,   645,   646,   115,   343,
     344,     0,     0,     0,   601,   602,     0,     0,     0,     0,
     603,     0,     0,     0,     0,     0,     0,     0,     0,   604,
       0,   605,     0,   606,   607,     0,   345,   346,   347,   348,
     349,   350,   351,     0,   353,     0,     0,     0,     0,  1079,
       0,     0,   361,   362,   363,   130,   364,   365,   366,   132,
    1080,   134,  1081,  1082,     0,   368,   369,     0,   370,  1083,
    1084,   373,  1085,  1086,   374,     0,   376,   377,   378,   379,
    1087,     0,     0,   382,   383,   384,     0,   386,   387,  1088,
     388,     0,   390,   391,   146,  1089,  1090,  1091,  1092,   396,
     397,   398,   399,   400,  1093,  1094,   401,     0,   403,     0,
     405,     0,   406,   407,   408,     0,     0,     0,   412,  1095,
     414,   415,     0,   417,   418,     0,   420,     0,   422,   423,
     424,  1096,   425,     0,  1097,  1098,   427,   428,  1099,     0,
     430,     0,   432,   162,     0,   163,   434,     0,   435,     0,
       0,   438,     0,   440,   441,   166,   442,   443,   444,   167,
     445,   446,   447,   448,     0,   168,   450,     0,   451,   452,
     453,  1100,  1101,     0,  1102,     0,     0,   172,   173,   456,
     174,   457,   458,   459,   460,     0,   175,   462,   176,     0,
     464,   465,   466,   467,   468,   469,   470,   471,   472,   473,
     474,   475,   476,  1103,   181,  1104,   692,   479,   480,   481,
     482,   183,  1105,   484,   485,   185,  1106,  1107,  1108,   487,
       0,     0,   490,   693,     0,     0,  1109,   495,     0,     0,
     498,   188,   189,  1110,   499,   500,   501,   502,   503,     0,
    1111,   504,   505,   506,     0,   508,   509,   510,   511,   512,
    1112,   513,     0,   515,   516,   517,   518,   519,   520,   521,
     522,   523,   196,   524,  1113,   525,   526,   527,   528,   529,
       0,     0,   531,   532,   533,  1114,   535,   201,   536,   537,
     203,   538,  1115,     0,   540,   541,   542,   543,   544,   545,
     546,   547,  1116,   548,     0,   550,   551,   552,     0,  1117,
    1118,     0,   555,     0,   557,  1119,   558,  1120,  1121,   560,
     561,   562,   563,     0,  1122,   565,   566,   567,   568,   569,
    1123,     0,   572,   573,   574,  1124,   575,   218,   576,   577,
       0,     0,     0,   580,   581,   582,   583,   584,   585,     0,
     219,    49,  1125,   220,   610,     0,     0,  1126,  1127,    52,
    1128,    53,     0,     0,     0,     0,  1129,  1130,     0,     0,
    1132,  1133,     0,     0,     0,  1134,  2763,   640,    79,    80,
      81,   339,     0,    83,    84,     0,    85,    86,    87,   340,
       0,   341,     0,    91,     0,    93,    94,    95,    96,    97,
      98,   641,    99,   100,   101,   342,   642,   103,     0,   104,
     105,   106,   107,   643,   644,     0,   109,   110,   111,     0,
     112,   645,   646,   115,   343,   344,     0,     0,     0,   601,
     602,     0,     0,     0,     0,   603,     0,     0,     0,     0,
       0,     0,     0,     0,   604,     0,   605,     0,   606,   607,
       0,   345,   346,   347,   348,   349,   350,   351,     0,   353,
       0,     0,     0,     0,     0,     0,     0,   361,   362,   363,
       0,   364,   365,   366,     0,  1336,     0,  1337,  1082,     0,
     368,   369,     0,   370,     0,     0,   373,  1338,  1339,   374,
       0,   376,   377,   378,   379,     0,     0,     0,   382,   383,
     384,     0,   386,   387,     0,   388,     0,   390,   391,     0,
       0,     0,     0,     0,   396,   397,   398,   399,   400,  1340,
    1341,   401,     0,   403,     0,   405,     0,   406,   407,   408,
       0,     0,     0,   412,  1095,   414,   415,     0,   417,   418,
       0,   420,     0,   422,   423,   424,     0,   425,     0,     0,
       0,   427,   428,  1342,     0,   430,     0,   432,     0,     0,
       0,   434,     0,   435,     0,     0,   438,     0,   440,   441,
       0,   442,   443,   444,  1705,   445,   446,   447,   448,     0,
       0,  1706,     0,   451,   452,   453,  1100,  1343,     0,  1344,
       0,     0,     0,     0,   456,     0,   457,   458,   459,   460,
       0,     0,   462,     0,     0,   464,   465,   466,   467,   468,
     469,   470,   471,   472,   473,   474,   475,   476,  1103,     0,
    1345,     0,   479,   480,   481,   482,     0,     0,   484,   485,
       0,     0,     0,  1346,   487,     0,     0,   490,     0,     0,
       0,   494,   495,     0,     0,  1707,     0,     0,     0,   499,
     500,   501,   502,   503,     0,     0,   504,   505,   506,     0,
     508,   509,   510,   511,   512,  1347,   513,     0,   515,   516,
     517,   518,   519,   520,   521,   522,   523,     0,   524,     0,
     525,   526,   527,   528,   529,     0,     0,   531,   532,   533,
       0,   535,  1348,   536,   537,     0,   538,  1349,     0,   540,
     541,   542,   543,   544,   545,   546,   547,     0,   548,     0,
     550,   551,   552,     0,  1350,  1351,     0,   555,     0,   557,
       0,   558,     0,     0,   560,   561,   562,   563,     0,     0,
     565,   566,   567,   568,   569,     0,     0,   572,   573,   574,
    1352,   575,     4,   576,   577,     0,     0,     0,   580,   581,
     582,   583,   584,   585,     0,   219,     0,     5,   220,     0,
       0,     0,     0,     0,     0,     0,     6,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     7,     8,
       0,  1708,     0,     0,     0,     0,    10,    11,     0,     0,
       0,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,     0,     0,     4,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     5,     0,     0,     0,     0,     0,     0,     0,
       0,     6,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    36,     7,     8,     0,     0,     0,     0,     0,
       0,    10,    11,     0,     0,     0,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    37,     0,
       0,     0,     0,     0,     0,     0,     0,    36,     0,     0,
       0,     0,     0,     0,    38,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    39,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    40,     0,     0,
      41,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    37,     0,     0,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    38,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    39,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    43,
       0,     0,    40,     0,     0,    41,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    44,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    45,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    46,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    47,     0,     0,
      48,    49,     0,    50,    43,     0,     0,     0,     0,    52,
       0,    53,    54,     0,     0,     0,    55,    56,    57,    58,
      59,     0,     0,    60,    61,   913,  1266,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    44,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    45,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      46,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    47,     0,     0,    48,    49,     0,    50,     0,
       0,     0,     0,     0,    52,     0,    53,    54,     0,     0,
       0,    55,    56,    57,    58,    59,     0,     0,    60,    61,
     913,  1677,   640,    79,    80,    81,   339,     0,    83,    84,
       0,    85,    86,    87,   340,     0,   341,     0,    91,     0,
      93,    94,    95,    96,    97,    98,   641,    99,   100,   101,
     342,   642,   103,     0,   104,   105,   106,   107,   643,   644,
       0,   109,   110,   111,     0,   112,   645,   646,   115,   343,
     344,     0,     0,     0,   601,   602,     0,     0,     0,     0,
     603,     0,     0,     0,     0,     0,     0,     0,     0,   604,
       0,   605,     0,   606,   607,     0,   345,   346,   347,   348,
     349,   350,   351,     0,   353,     0,     0,     0,     0,  1079,
       0,     0,   361,   362,   363,   130,   364,   365,   366,   132,
    1080,   134,  1081,  1082,  1925,   368,   369,     0,   370,  1083,
    1084,   373,  1085,  1086,   374,     0,   376,   377,   378,   379,
    1087,     0,     0,   382,   383,   384,     0,   386,   387,  1088,
     388,     0,   390,   391,   146,  1089,  1090,  1091,  1092,   396,
     397,   398,   399,   400,  1093,  1094,   401,     0,   403,     0,
     405,     0,   406,   407,   408,     0,     0,     0,   412,  1095,
     414,   415,     0,   417,   418,     0,   420,     0,   422,   423,
     424,  1096,   425,     0,  1097,  1098,   427,   428,  1099,     0,
     430,     0,   432,   162,  1926,   163,   434,     0,   435,     0,
       0,   438,     0,   440,   441,   166,   442,   443,   444,   167,
     445,   446,   447,   448,     0,   168,   450,     0,   451,   452,
     453,  1100,  1101,     0,  1102,     0,     0,   172,   173,   456,
     174,   457,   458,   459,   460,  1927,   175,   462,   176,     0,
     464,   465,   466,   467,   468,   469,   470,   471,   472,   473,
     474,   475,   476,  1103,   181,  1104,   692,   479,   480,   481,
     482,   183,  1105,   484,   485,   185,  1106,  1107,  1108,   487,
       0,     0,   490,   693,     0,     0,  1109,   495,     0,     0,
     498,   188,   189,  1110,   499,   500,   501,   502,   503,     0,
    1111,   504,   505,   506,     0,   508,   509,   510,   511,   512,
    1112,   513,     0,   515,   516,   517,   518,   519,   520,   521,
     522,   523,   196,   524,  1113,   525,   526,   527,   528,   529,
       0,     0,   531,   532,   533,  1114,   535,   201,   536,   537,
     203,   538,  1115,     0,   540,   541,   542,   543,   544,   545,
     546,   547,  1116,   548,     0,   550,   551,   552,     0,  1117,
    1118,     0,   555,  1928,   557,  1119,   558,  1120,  1121,   560,
     561,   562,   563,     0,  1122,   565,   566,   567,   568,   569,
    1123,     0,   572,   573,   574,  1124,   575,   218,   576,   577,
       0,     0,     0,   580,   581,   582,   583,   584,   585,     0,
     219,    49,  1125,   220,   610,     0,     0,  1126,  1127,    52,
    1128,    53,     0,     0,     0,     0,  1129,  1130,     0,     0,
    1132,  1133,     0,     0,     0,  1134,   640,    79,    80,    81,
     339,     0,    83,    84,     0,    85,    86,    87,   340,     0,
     341,     0,    91,     0,    93,    94,    95,    96,    97,    98,
     641,    99,   100,   101,   342,   642,   103,     0,   104,   105,
     106,   107,   643,   644,     0,   109,   110,   111,     0,   112,
     645,   646,   115,   343,   344,     0,     0,     0,   601,   602,
       0,     0,     0,     0,   603,     0,     0,     0,     0,     0,
       0,     0,     0,   604,     0,   605,     0,   606,   607,     0,
     345,   346,   347,   348,   349,   350,   351,     0,   353,     0,
       0,     0,     0,  1079,     0,     0,   361,   362,   363,   130,
     364,   365,   366,   132,  1080,   134,  1081,  1082,     0,   368,
     369,     0,   370,  1083,  1084,   373,  1085,  1086,   374,     0,
     376,   377,   378,   379,  1087,     0,     0,   382,   383,   384,
       0,   386,   387,  1088,   388,     0,   390,   391,   146,  1089,
    1090,  1091,  1092,   396,   397,   398,   399,   400,  1093,  1094,
     401,  2208,   403,     0,   405,     0,   406,   407,   408,     0,
       0,     0,   412,  1095,   414,   415,     0,   417,   418,     0,
     420,     0,   422,   423,   424,  1096,   425,     0,  1097,  1098,
     427,   428,  1099,     0,   430,     0,   432,   162,     0,   163,
     434,     0,   435,     0,     0,   438,     0,   440,   441,   166,
     442,   443,   444,   167,   445,   446,   447,   448,     0,   168,
     450,     0,   451,   452,   453,  1100,  1101,     0,  1102,     0,
       0,   172,   173,   456,   174,   457,   458,   459,   460,     0,
     175,   462,   176,     0,   464,   465,   466,   467,   468,   469,
     470,   471,   472,   473,   474,   475,   476,  1103,   181,  1104,
     692,   479,   480,   481,   482,   183,  1105,   484,   485,   185,
    1106,  1107,  1108,   487,     0,     0,   490,   693,     0,     0,
    1109,   495,     0,     0,   498,   188,   189,  1110,   499,   500,
     501,   502,   503,     0,  1111,   504,   505,   506,     0,   508,
     509,   510,   511,   512,  1112,   513,     0,   515,   516,   517,
     518,   519,   520,   521,   522,   523,   196,   524,  1113,   525,
     526,   527,   528,   529,     0,     0,   531,   532,   533,  1114,
     535,   201,   536,   537,   203,   538,  1115,     0,   540,   541,
     542,   543,   544,   545,   546,   547,  1116,   548,     0,   550,
     551,   552,     0,  1117,  1118,     0,   555,     0,   557,  1119,
     558,  1120,  1121,   560,   561,   562,   563,     0,  1122,   565,
     566,   567,   568,   569,  1123,     0,   572,   573,   574,  1124,
     575,   218,   576,   577,     0,     0,     0,   580,   581,   582,
     583,   584,   585,     0,   219,    49,  1125,   220,   610,     0,
       0,  1126,  1127,    52,  1128,    53,     0,     0,     0,     0,
    1129,  1130,  1131,     0,  1132,  1133,     0,     0,     0,  1134,
     640,    79,    80,    81,   339,     0,    83,    84,     0,    85,
      86,    87,   340,     0,   341,     0,    91,     0,    93,    94,
      95,    96,    97,    98,   641,    99,   100,   101,   342,   642,
     103,     0,   104,   105,   106,   107,   643,   644,     0,   109,
     110,   111,     0,   112,   645,   646,   115,   343,   344,     0,
       0,     0,   601,   602,     0,     0,     0,     0,   603,     0,
       0,     0,     0,     0,     0,     0,     0,   604,     0,   605,
       0,   606,   607,     0,   345,   346,   347,   348,   349,   350,
     351,     0,   353,     0,     0,     0,     0,  1079,     0,     0,
     361,   362,   363,   130,   364,   365,   366,   132,  1080,   134,
    1081,  1082,     0,   368,   369,     0,   370,  1083,  1084,   373,
    1085,  1086,   374,     0,   376,   377,   378,   379,  1087,     0,
       0,   382,   383,   384,     0,   386,   387,  1088,   388,     0,
     390,   391,   146,  1089,  1090,  1091,  1092,   396,   397,   398,
     399,   400,  1093,  1094,   401,     0,   403,     0,   405,     0,
     406,   407,   408,     0,     0,     0,   412,  1095,   414,   415,
       0,   417,   418,     0,   420,     0,   422,   423,   424,  1096,
     425,     0,  1097,  1098,   427,   428,  1099,     0,   430,     0,
     432,   162,     0,   163,   434,     0,   435,     0,     0,   438,
       0,   440,   441,   166,   442,   443,   444,   167,   445,   446,
     447,   448,     0,   168,   450,     0,   451,   452,   453,  1100,
    1101,     0,  1102,     0,     0,   172,   173,   456,   174,   457,
     458,   459,   460,     0,   175,   462,   176,     0,   464,   465,
     466,   467,   468,   469,   470,   471,   472,   473,   474,   475,
     476,  1103,   181,  1104,   692,   479,   480,   481,   482,   183,
    1105,   484,   485,   185,  1106,  1107,  1108,   487,     0,     0,
     490,   693,     0,     0,  1109,   495,     0,     0,   498,   188,
     189,  1110,   499,   500,   501,   502,   503,     0,  1111,   504,
     505,   506,     0,   508,   509,   510,   511,   512,  1112,   513,
       0,   515,   516,   517,   518,   519,   520,   521,   522,   523,
     196,   524,  1113,   525,   526,   527,   528,   529,     0,     0,
     531,   532,   533,  1114,   535,   201,   536,   537,   203,   538,
    1115,     0,   540,   541,   542,   543,   544,   545,   546,   547,
    1116,   548,     0,   550,   551,   552,     0,  1117,  1118,     0,
     555,     0,   557,  1119,   558,  1120,  1121,   560,   561,   562,
     563,     0,  1122,   565,   566,   567,   568,   569,  1123,     0,
     572,   573,   574,  1124,   575,   218,   576,   577,     0,     0,
       0,   580,   581,   582,   583,   584,   585,     0,   219,    49,
    1125,   220,   610,     0,     0,  1126,  1127,    52,  1128,    53,
       0,     0,     0,     0,  1129,  1130,  1131,     0,  1132,  1133,
       0,     0,     0,  1134,   640,    79,    80,    81,   339,     0,
      83,    84,     0,    85,    86,    87,   340,     0,   341,     0,
      91,     0,    93,    94,    95,    96,    97,    98,   641,    99,
     100,   101,   342,   642,   103,     0,   104,   105,   106,   107,
     643,   644,     0,   109,   110,   111,     0,   112,   645,   646,
     115,   343,   344,     0,     0,     0,   601,   602,     0,     0,
       0,     0,   603,     0,     0,     0,     0,     0,     0,     0,
       0,   604,     0,   605,     0,   606,   607,     0,   345,   346,
     347,   348,   349,   350,   351,     0,   353,     0,     0,     0,
       0,  1079,     0,     0,   361,   362,   363,   130,   364,   365,
     366,   132,  1080,   134,  1081,  1082,     0,   368,   369,     0,
     370,  1083,  1084,   373,  1085,  1086,   374,     0,   376,   377,
     378,   379,  1087,     0,     0,   382,   383,   384,     0,   386,
     387,  1088,   388,     0,   390,   391,   146,  1089,  1090,  1091,
    1092,   396,   397,   398,   399,   400,  1093,  1094,   401,     0,
     403,     0,   405,     0,   406,   407,   408,     0,     0,     0,
     412,  1095,   414,   415,     0,   417,   418,     0,   420,     0,
     422,   423,   424,  1096,   425,     0,  1097,  1098,   427,   428,
    1099,     0,   430,     0,   432,   162,     0,   163,   434,     0,
     435,     0,     0,   438,     0,   440,   441,   166,   442,   443,
     444,   167,   445,   446,   447,   448,     0,   168,   450,     0,
     451,   452,   453,  1100,  1101,     0,  1102,     0,     0,   172,
     173,   456,   174,   457,   458,   459,   460,     0,   175,   462,
     176,     0,   464,   465,   466,   467,   468,   469,   470,   471,
     472,   473,   474,   475,   476,  1103,   181,  1104,   692,   479,
     480,   481,   482,   183,  1105,   484,   485,   185,  1106,  1107,
    1108,   487,     0,     0,   490,   693,     0,     0,  1109,   495,
       0,     0,   498,   188,   189,  1110,   499,   500,   501,   502,
     503,     0,  1111,   504,   505,   506,     0,   508,   509,   510,
     511,   512,  1112,   513,     0,   515,   516,   517,   518,   519,
     520,   521,   522,   523,   196,   524,  1113,   525,   526,   527,
     528,   529,     0,   199,   531,   532,   533,  1114,   535,   201,
     536,   537,   203,   538,  1115,     0,   540,   541,   542,   543,
     544,   545,   546,   547,  1116,   548,     0,   550,   551,   552,
       0,  1117,  1118,     0,   555,     0,   557,  1119,   558,  1120,
    1121,   560,   561,   562,   563,     0,  1122,   565,   566,   567,
     568,   569,  1123,     0,   572,   573,   574,  1124,   575,   218,
     576,   577,     0,     0,     0,   580,   581,   582,   583,   584,
     585,     0,   219,    49,  1125,   220,   610,     0,     0,  1126,
    1127,    52,  1128,    53,     0,     0,     0,     0,  1129,  1130,
       0,     0,  1132,  1133,     0,     0,     0,  1134,   640,    79,
      80,    81,   339,     0,    83,    84,     0,    85,    86,    87,
     340,     0,   341,     0,    91,     0,    93,    94,    95,    96,
      97,    98,   641,    99,   100,   101,   342,   642,   103,     0,
     104,   105,   106,   107,   643,   644,     0,   109,   110,   111,
       0,   112,   645,   646,   115,   343,   344,     0,     0,     0,
     601,   602,     0,     0,     0,     0,   603,     0,     0,     0,
       0,     0,     0,     0,     0,   604,     0,   605,     0,   606,
     607,     0,   345,   346,   347,   348,   349,   350,   351,  1634,
     353,     0,     0,     0,     0,  1079,     0,     0,   361,   362,
     363,   130,   364,   365,   366,   132,  1080,   134,  1081,  1082,
       0,   368,   369,     0,   370,  1083,  1084,   373,  1085,  1086,
     374,     0,   376,   377,   378,   379,  1087,     0,     0,   382,
     383,   384,     0,   386,   387,  1088,   388,     0,   390,   391,
     146,  1089,  1090,  1091,  1092,   396,   397,   398,   399,   400,
    1093,  1094,   401,     0,   403,     0,   405,     0,   406,   407,
     408,     0,     0,     0,   412,  1095,   414,   415,     0,   417,
     418,     0,   420,     0,   422,   423,   424,  1096,   425,     0,
    1097,  1098,   427,   428,  1099,     0,   430,     0,   432,   162,
       0,   163,   434,     0,   435,     0,     0,   438,     0,   440,
     441,   166,   442,   443,   444,   167,   445,   446,   447,   448,
       0,   168,   450,     0,   451,   452,   453,  1100,  1101,     0,
    1102,     0,     0,   172,   173,   456,   174,   457,   458,   459,
     460,     0,   175,   462,   176,     0,   464,   465,   466,   467,
     468,   469,   470,   471,   472,   473,   474,   475,   476,  1103,
     181,  1104,   692,   479,   480,   481,   482,   183,  1105,   484,
     485,   185,  1106,  1107,  1108,   487,     0,     0,   490,   693,
       0,     0,  1109,   495,     0,     0,   498,   188,   189,  1110,
     499,   500,   501,   502,   503,     0,  1111,   504,   505,   506,
       0,   508,   509,   510,   511,   512,  1112,   513,     0,   515,
     516,   517,   518,   519,   520,   521,   522,   523,   196,   524,
    1113,   525,   526,   527,   528,   529,     0,     0,   531,   532,
     533,  1114,   535,   201,   536,   537,   203,   538,  1115,     0,
     540,   541,   542,   543,   544,   545,   546,   547,  1116,   548,
       0,   550,   551,   552,     0,  1117,  1118,     0,   555,     0,
     557,  1119,   558,  1120,  1121,   560,   561,   562,   563,     0,
    1122,   565,   566,   567,   568,   569,  1123,     0,   572,   573,
     574,  1124,   575,   218,   576,   577,     0,     0,     0,   580,
     581,   582,   583,   584,   585,     0,   219,    49,  1125,   220,
     610,     0,     0,  1126,  1127,    52,  1128,    53,     0,     0,
       0,     0,  1129,  1130,     0,     0,  1132,  1133,     0,     0,
       0,  1134,   640,    79,    80,    81,   339,     0,    83,    84,
       0,    85,    86,    87,   340,     0,   341,     0,    91,     0,
      93,    94,    95,    96,    97,    98,   641,    99,   100,   101,
     342,   642,   103,     0,   104,   105,   106,   107,   643,   644,
       0,   109,   110,   111,     0,   112,   645,   646,   115,   343,
     344,     0,     0,     0,   601,   602,     0,     0,     0,     0,
     603,     0,     0,     0,     0,     0,     0,     0,     0,   604,
       0,   605,     0,   606,   607,     0,   345,   346,   347,   348,
     349,   350,   351,     0,   353,     0,     0,     0,     0,  1079,
       0,     0,   361,   362,   363,   130,   364,   365,   366,   132,
    1080,   134,  1081,  1082,     0,   368,   369,     0,   370,  1083,
    1084,   373,  1085,  1086,   374,     0,   376,   377,   378,   379,
    1087,     0,     0,   382,   383,   384,     0,   386,   387,  1088,
     388,     0,   390,   391,   146,  1089,  1090,  1091,  1092,   396,
     397,   398,   399,   400,  1093,  1094,   401,     0,   403,     0,
     405,     0,   406,   407,   408,     0,     0,     0,   412,  1095,
     414,   415,     0,   417,   418,     0,   420,     0,   422,   423,
     424,  1096,   425,     0,  1097,  1098,   427,   428,  1099,     0,
     430,     0,   432,   162,     0,   163,   434,     0,   435,     0,
       0,   438,     0,   440,   441,   166,   442,   443,   444,   167,
     445,   446,   447,   448,     0,   168,   450,     0,   451,   452,
     453,  1100,  1101,     0,  1102,     0,     0,   172,   173,   456,
     174,   457,   458,   459,   460,     0,   175,   462,   176,     0,
     464,   465,   466,   467,   468,   469,   470,   471,   472,   473,
     474,   475,   476,  1103,   181,  1104,   692,   479,   480,   481,
     482,   183,  1105,   484,   485,   185,  1106,  1107,  1108,   487,
       0,     0,   490,   693,     0,     0,  1109,   495,     0,     0,
     498,   188,   189,  1110,   499,   500,   501,   502,   503,     0,
    1111,   504,   505,   506,     0,   508,   509,   510,   511,   512,
    1112,   513,     0,   515,   516,   517,   518,   519,   520,   521,
     522,   523,   196,   524,  1113,   525,   526,   527,   528,   529,
       0,     0,   531,   532,   533,  1114,   535,   201,   536,   537,
     203,   538,  1115,     0,   540,   541,   542,   543,   544,   545,
     546,   547,  1116,   548,     0,   550,   551,   552,     0,  1117,
    1118,     0,   555,     0,   557,  1119,   558,  1120,  1121,   560,
     561,   562,   563,     0,  1122,   565,   566,   567,   568,   569,
    1123,     0,   572,   573,   574,  1124,   575,   218,   576,   577,
       0,     0,     0,   580,   581,   582,   583,   584,   585,     0,
     219,    49,  1125,   220,   610,     0,     0,  1126,  1127,    52,
    1128,    53,     0,     0,     0,     0,  1129,  1130,     0,     0,
    1132,  1133,     0,  1465,     0,  1134,   640,    79,    80,    81,
     339,     0,    83,    84,     0,    85,    86,    87,   340,     0,
     341,     0,    91,     0,    93,    94,    95,    96,    97,    98,
     641,    99,   100,   101,   342,   642,   103,     0,   104,   105,
     106,   107,   643,   644,     0,   109,   110,   111,     0,   112,
     645,   646,   115,   343,   344,     0,     0,     0,   601,   602,
       0,     0,     0,     0,   603,     0,     0,     0,     0,     0,
       0,     0,     0,   604,     0,   605,     0,   606,   607,     0,
     345,   346,   347,   348,   349,   350,   351,     0,   353,     0,
       0,     0,     0,  1079,     0,     0,   361,   362,   363,   130,
     364,   365,   366,   132,  1080,   134,  1081,  1082,     0,   368,
     369,     0,   370,  1083,  1084,   373,  1085,  1086,   374,     0,
     376,   377,   378,   379,  1087,     0,     0,   382,   383,   384,
       0,   386,   387,  1088,   388,     0,   390,   391,   146,  1089,
    1090,  1091,  1092,   396,   397,   398,   399,   400,  1093,  1094,
     401,     0,   403,     0,   405,     0,   406,   407,   408,     0,
       0,     0,   412,  1095,   414,   415,     0,   417,   418,     0,
     420,     0,   422,   423,   424,  1096,   425,     0,  1097,  1098,
     427,   428,  1099,     0,   430,     0,   432,   162,  1926,   163,
     434,     0,   435,     0,     0,   438,     0,   440,   441,   166,
     442,   443,   444,   167,   445,   446,   447,   448,     0,   168,
     450,     0,   451,   452,   453,  1100,  1101,     0,  1102,     0,
       0,   172,   173,   456,   174,   457,   458,   459,   460,     0,
     175,   462,   176,     0,   464,   465,   466,   467,   468,   469,
     470,   471,   472,   473,   474,   475,   476,  1103,   181,  1104,
     692,   479,   480,   481,   482,   183,  1105,   484,   485,   185,
    1106,  1107,  1108,   487,     0,     0,   490,   693,     0,     0,
    1109,   495,     0,     0,   498,   188,   189,  1110,   499,   500,
     501,   502,   503,     0,  1111,   504,   505,   506,     0,   508,
     509,   510,   511,   512,  1112,   513,     0,   515,   516,   517,
     518,   519,   520,   521,   522,   523,   196,   524,  1113,   525,
     526,   527,   528,   529,     0,     0,   531,   532,   533,  1114,
     535,   201,   536,   537,   203,   538,  1115,     0,   540,   541,
     542,   543,   544,   545,   546,   547,  1116,   548,     0,   550,
     551,   552,     0,  1117,  1118,     0,   555,     0,   557,  1119,
     558,  1120,  1121,   560,   561,   562,   563,     0,  1122,   565,
     566,   567,   568,   569,  1123,     0,   572,   573,   574,  1124,
     575,   218,   576,   577,     0,     0,     0,   580,   581,   582,
     583,   584,   585,     0,   219,    49,  1125,   220,   610,     0,
       0,  1126,  1127,    52,  1128,    53,     0,     0,     0,     0,
    1129,  1130,     0,     0,  1132,  1133,     0,     0,     0,  1134,
     640,    79,    80,    81,   339,     0,    83,    84,     0,    85,
      86,    87,   340,     0,   341,     0,    91,     0,    93,    94,
      95,    96,    97,    98,   641,    99,   100,   101,   342,   642,
     103,     0,   104,   105,   106,   107,   643,   644,     0,   109,
     110,   111,     0,   112,   645,   646,   115,   343,   344,     0,
       0,     0,   601,   602,     0,     0,     0,     0,   603,     0,
       0,     0,     0,     0,     0,     0,     0,   604,     0,   605,
       0,   606,   607,     0,   345,   346,   347,   348,   349,   350,
     351,     0,   353,     0,     0,     0,     0,  1079,     0,     0,
     361,   362,   363,   130,   364,   365,   366,   132,  1080,   134,
    1081,  1082,     0,   368,   369,     0,   370,  1083,  1084,   373,
    1085,  1086,   374,     0,   376,   377,   378,   379,  1087,     0,
       0,   382,   383,   384,     0,   386,   387,  1088,   388,     0,
     390,   391,   146,  1089,  1090,  1091,  1092,   396,   397,   398,
     399,   400,  1093,  1094,   401,  2604,   403,     0,   405,     0,
     406,   407,   408,     0,     0,     0,   412,  1095,   414,   415,
       0,   417,   418,     0,   420,     0,   422,   423,   424,  1096,
     425,     0,  1097,  1098,   427,   428,  1099,     0,   430,     0,
     432,   162,     0,   163,   434,     0,   435,     0,     0,   438,
       0,   440,   441,   166,   442,   443,   444,   167,   445,   446,
     447,   448,     0,   168,   450,     0,   451,   452,   453,  1100,
    1101,     0,  1102,     0,     0,   172,   173,   456,   174,   457,
     458,   459,   460,     0,   175,   462,   176,     0,   464,   465,
     466,   467,   468,   469,   470,   471,   472,   473,   474,   475,
     476,  1103,   181,  1104,   692,   479,   480,   481,   482,   183,
    1105,   484,   485,   185,  1106,  1107,  1108,   487,     0,     0,
     490,   693,     0,     0,  1109,   495,     0,     0,   498,   188,
     189,  1110,   499,   500,   501,   502,   503,     0,  1111,   504,
     505,   506,     0,   508,   509,   510,   511,   512,  1112,   513,
       0,   515,   516,   517,   518,   519,   520,   521,   522,   523,
     196,   524,  1113,   525,   526,   527,   528,   529,     0,     0,
     531,   532,   533,  1114,   535,   201,   536,   537,   203,   538,
    1115,     0,   540,   541,   542,   543,   544,   545,   546,   547,
    1116,   548,     0,   550,   551,   552,     0,  1117,  1118,     0,
     555,     0,   557,  1119,   558,  1120,  1121,   560,   561,   562,
     563,     0,  1122,   565,   566,   567,   568,   569,  1123,     0,
     572,   573,   574,  1124,   575,   218,   576,   577,     0,     0,
       0,   580,   581,   582,   583,   584,   585,     0,   219,    49,
    1125,   220,   610,     0,     0,  1126,  1127,    52,  1128,    53,
       0,     0,     0,     0,  1129,  1130,     0,     0,  1132,  1133,
       0,     0,     0,  1134,   640,    79,    80,    81,   339,     0,
      83,    84,     0,    85,    86,    87,   340,     0,   341,     0,
      91,     0,    93,    94,    95,    96,    97,    98,   641,    99,
     100,   101,   342,   642,   103,     0,   104,   105,   106,   107,
     643,   644,     0,   109,   110,   111,     0,   112,   645,   646,
     115,   343,   344,     0,     0,     0,   601,   602,     0,     0,
       0,     0,   603,     0,     0,     0,     0,     0,     0,     0,
       0,   604,     0,   605,     0,   606,   607,     0,   345,   346,
     347,   348,   349,   350,   351,     0,   353,     0,     0,     0,
       0,  1079,     0,     0,   361,   362,   363,   130,   364,   365,
     366,   132,  1080,   134,  1081,  1082,     0,   368,   369,     0,
     370,  1083,  1084,   373,  1085,  1086,   374,     0,   376,   377,
     378,   379,  1087,     0,     0,   382,   383,   384,     0,   386,
     387,  1088,   388,     0,   390,   391,   146,  1089,  1090,  1091,
    1092,   396,   397,   398,   399,   400,  1093,  1094,   401,     0,
     403,     0,   405,     0,   406,   407,   408,     0,     0,     0,
     412,  1095,   414,   415,     0,   417,   418,     0,   420,     0,
     422,   423,   424,  1096,   425,     0,  1097,  1098,   427,   428,
    1099,     0,   430,     0,   432,   162,     0,   163,   434,     0,
     435,     0,     0,   438,     0,   440,   441,   166,   442,   443,
     444,   167,   445,   446,   447,   448,     0,   168,   450,     0,
     451,   452,   453,  1100,  1101,     0,  1102,     0,     0,   172,
     173,   456,   174,   457,   458,   459,   460,     0,   175,   462,
     176,     0,   464,   465,   466,   467,   468,   469,   470,   471,
     472,   473,   474,   475,   476,  1103,   181,  1104,   692,   479,
     480,   481,   482,   183,  1105,   484,   485,   185,  1106,  1107,
    1108,   487,     0,     0,   490,   693,     0,     0,  1109,   495,
       0,     0,   498,   188,   189,  1110,   499,   500,   501,   502,
     503,     0,  1111,   504,   505,   506,     0,   508,   509,   510,
     511,   512,  1112,   513,     0,   515,   516,   517,   518,   519,
     520,   521,   522,   523,   196,   524,  1113,   525,   526,   527,
     528,   529,     0,     0,   531,   532,   533,  1114,   535,   201,
     536,   537,   203,   538,  1115,     0,   540,   541,   542,   543,
     544,   545,   546,   547,  1116,   548,     0,   550,   551,   552,
       0,  1117,  1118,     0,   555,     0,   557,  1119,   558,  1120,
    1121,   560,   561,   562,   563,     0,  1122,   565,   566,   567,
     568,   569,  1123,     0,   572,   573,   574,  1124,   575,   218,
     576,   577,     0,     0,     0,   580,   581,   582,   583,   584,
     585,     0,   219,    49,  1125,   220,   610,     0,     0,  1126,
    1127,    52,  1128,    53,     0,     0,     0,     0,  1129,  1130,
       0,     0,  1132,  1133,     0,     0,     0,  1134,   640,    79,
      80,    81,   339,     0,    83,    84,     0,    85,    86,    87,
     340,     0,   341,     0,    91,     0,    93,    94,    95,    96,
      97,    98,   641,    99,   100,   101,   342,   642,   103,     0,
     104,   105,   106,   107,   643,   644,     0,   109,   110,   111,
       0,   112,   645,   646,   115,   343,   344,     0,     0,     0,
     601,   602,     0,     0,     0,     0,   603,     0,     0,     0,
       0,     0,     0,     0,     0,   604,     0,   605,     0,   606,
     607,     0,   345,   346,   347,   348,   349,   350,   351,     0,
     353,     0,     0,     0,     0,  1079,     0,     0,   361,   362,
     363,   130,   364,   365,   366,   132,  1080,   134,  1081,  1082,
       0,   368,   369,     0,   370,  1083,  1084,   373,  1085,  1086,
     374,     0,   376,   377,   378,   379,  1087,     0,     0,   382,
     383,   384,     0,   386,   387,  1088,   388,     0,   390,   391,
     146,  1089,  1090,  1091,  1092,   396,   397,   398,   399,   400,
    1093,  1094,   401,     0,   403,     0,   405,     0,   406,   407,
     408,     0,     0,     0,   412,  1095,   414,   415,     0,   417,
     418,     0,   420,     0,   422,   423,   424,  1096,   425,     0,
    1097,  1098,   427,   428,  1099,     0,   430,     0,   432,   162,
       0,   163,   434,     0,   435,     0,     0,   438,     0,   440,
     441,   166,   442,   443,   444,   167,   445,   446,   447,   448,
       0,   168,   450,     0,   451,   452,   453,  1100,  1101,     0,
    1102,     0,     0,   172,   173,   456,   174,   457,   458,   459,
     460,     0,   175,   462,   176,     0,   464,   465,   466,   467,
     468,   469,   470,   471,   472,   473,   474,   475,   476,  1103,
     181,  1104,   692,   479,   480,   481,   482,   183,     0,   484,
     485,   185,  1106,  1107,  1108,   487,     0,     0,   490,   693,
       0,     0,  1109,   495,     0,     0,   498,   188,   189,  1110,
     499,   500,   501,   502,   503,     0,  1111,   504,   505,   506,
       0,   508,   509,   510,   511,   512,  1112,   513,     0,   515,
     516,   517,   518,   519,   520,   521,   522,   523,   196,   524,
     198,   525,   526,   527,   528,   529,     0,     0,   531,   532,
     533,  1114,   535,   201,   536,   537,   203,   538,  1115,     0,
     540,   541,   542,   543,   544,   545,   546,   547,  1116,   548,
       0,   550,   551,   552,     0,  1117,  1118,     0,   555,     0,
     557,  1119,   558,  1120,  1121,   560,   561,   562,   563,     0,
       0,   565,   566,   567,   568,   569,  1123,     0,   572,   573,
     574,  1124,   575,   218,   576,   577,     0,     0,     0,   580,
     581,   582,   583,   584,   585,     0,   219,    49,  1125,   220,
     610,     0,     0,  1126,  1127,    52,  1128,    53,     0,     0,
       0,     0,     0,  1906,     0,     0,  1907,  1908,     0,     0,
       0,  1909,   640,    79,    80,    81,   339,     0,    83,    84,
       0,    85,    86,    87,   340,     0,   341,     0,    91,     0,
      93,    94,    95,    96,    97,    98,   641,    99,   100,   101,
     342,   642,   103,     0,   104,   105,   106,   107,   643,   644,
       0,   109,   110,   111,     0,   112,   645,   646,   115,   343,
     344,     0,     0,     0,   601,   602,     0,     0,     0,     0,
     603,     0,     0,     0,     0,     0,     0,     0,     0,   604,
       0,   605,     0,   606,   607,     0,   345,   346,   347,   348,
     349,   350,   351,     0,   353,     0,     0,     0,     0,  1079,
       0,     0,   361,   362,   363,   130,   364,   365,   366,     0,
    1080,   134,  1081,  1082,     0,   368,   369,     0,   370,  1083,
    1084,   373,  1085,  1086,   374,     0,   376,   377,   378,   379,
    1087,     0,     0,   382,   383,   384,     0,   386,   387,  1088,
     388,     0,   390,   391,   146,  1089,  1090,  1091,  1092,   396,
     397,   398,   399,   400,  1093,  1094,   401,     0,   403,     0,
     405,     0,   406,   407,   408,     0,     0,     0,   412,  1095,
     414,   415,     0,   417,   418,     0,     0,     0,   422,   423,
     424,  1096,   425,     0,  1097,  1098,   427,   428,  1099,     0,
     430,     0,   432,   162,     0,   163,   434,     0,   435,     0,
       0,   438,     0,   440,   441,     0,   442,   443,   444,     0,
     445,   446,   447,   448,     0,   168,   450,     0,   451,   452,
     453,  1100,  1101,     0,  1102,     0,     0,   172,   173,   456,
     174,   457,   458,   459,   460,     0,   175,   462,     0,     0,
     464,   465,   466,   467,   468,   469,   470,   471,   472,   473,
     474,   475,   476,  1103,   181,  1104,   692,   479,   480,   481,
     482,   183,     0,   484,   485,   185,  1106,  1107,  1108,   487,
       0,     0,   490,   693,     0,     0,  1109,   495,     0,     0,
     498,   188,   189,  1110,   499,   500,   501,   502,   503,     0,
    1111,   504,   505,   506,     0,   508,   509,   510,   511,   512,
    1112,   513,     0,   515,   516,   517,   518,   519,   520,   521,
     522,   523,   196,   524,  1113,   525,   526,   527,   528,   529,
       0,     0,   531,   532,   533,  1114,   535,   201,   536,   537,
       0,   538,  1115,     0,   540,   541,   542,   543,   544,   545,
     546,   547,  1116,   548,     0,   550,   551,   552,     0,  1117,
    1118,     0,   555,     0,   557,  1119,   558,  1120,  1121,   560,
     561,   562,   563,     0,  1122,   565,   566,   567,   568,   569,
    1123,     0,   572,   573,   574,  1124,   575,   218,   576,   577,
       0,     0,     0,   580,   581,   582,   583,   584,   585,     0,
     219,    49,  1125,   220,   610,     0,     0,  1126,  1127,    52,
    1128,    53,     0,     0,     0,     0,  1129,  1130,     0,     0,
    1132,  1133,     0,     0,     0,  1134,   640,    79,    80,    81,
     339,     0,    83,    84,     0,    85,    86,    87,   340,     0,
     341,     0,    91,     0,    93,    94,    95,    96,    97,    98,
     641,    99,   100,   101,   342,   642,   103,     0,   104,   105,
     106,   107,   643,   644,     0,   109,   110,   111,     0,   112,
     645,   646,   115,   343,   344,     0,     0,     0,   601,   602,
       0,     0,     0,     0,   603,     0,     0,     0,     0,     0,
       0,     0,     0,   604,     0,   605,     0,   606,   607,     0,
     345,   346,   347,   348,   349,   350,   351,     0,   353,     0,
       0,     0,     0,  1079,     0,     0,   361,   362,   363,   130,
     364,   365,   366,   132,  1080,   134,  1081,  1082,     0,   368,
     369,     0,   370,  1083,  1084,   373,  1085,  1086,   374,     0,
     376,   377,   378,   379,  1087,     0,     0,   382,   383,   384,
       0,   386,   387,  1088,   388,     0,   390,   391,   146,  1089,
    1090,  1091,  1092,   396,   397,   398,   399,   400,  1093,  1094,
     401,     0,   403,     0,   405,     0,   406,   407,   408,     0,
       0,     0,   412,  1095,   414,   415,     0,   417,   418,     0,
     420,     0,   422,   423,   424,  1096,   425,     0,  1097,  1098,
     427,   428,  1099,     0,   430,     0,   432,   162,     0,   163,
     434,     0,   435,     0,     0,   438,     0,   440,   441,   166,
     442,   443,   444,   167,   445,   446,   447,   448,     0,   168,
     450,     0,   451,   452,   453,  1100,  1101,     0,  1102,     0,
       0,   172,   173,   456,   174,   457,   458,   459,   460,     0,
     175,   462,   176,     0,   464,   465,   466,   467,   468,   469,
     470,   471,   472,   473,   474,   475,   476,  1103,   181,  1104,
     692,   479,   480,   481,   482,   183,     0,   484,   485,   185,
    1106,  1107,  1108,   487,     0,     0,   490,   693,     0,     0,
     494,   495,     0,     0,   498,   188,   189,  1110,   499,   500,
     501,   502,   503,     0,  1111,   504,   505,   506,     0,   508,
     509,   510,   511,   512,  1112,   513,     0,   515,   516,   517,
     518,   519,   520,   521,   522,   523,   196,   524,   198,   525,
     526,   527,   528,   529,     0,     0,   531,   532,   533,  1114,
     535,   201,   536,   537,   203,   538,  1115,     0,   540,   541,
     542,   543,   544,   545,   546,   547,  1116,   548,     0,   550,
     551,   552,     0,  1117,  1118,     0,   555,     0,   557,  1119,
     558,  1120,  1121,   560,   561,   562,   563,     0,     0,   565,
     566,   567,   568,   569,  1123,     0,   572,   573,   574,  1124,
     575,   218,   576,   577,     0,     0,     0,   580,   581,   582,
     583,   584,   585,     0,   219,    49,     0,   220,   610,     0,
       0,  1126,  1127,    52,  1128,    53,   640,    79,    80,    81,
     339,     0,    83,    84,     0,    85,    86,    87,   340,  1909,
     341,     0,    91,     0,    93,    94,    95,    96,    97,    98,
     641,    99,   100,   101,   342,   642,   103,     0,   104,   105,
     106,   107,   643,   644,     0,   109,   110,   111,     0,   112,
     645,   646,   115,   343,   344,     0,     0,     0,   601,   602,
       0,     0,     0,     0,   603,     0,     0,     0,     0,     0,
       0,     0,     0,   604,     0,   605,     0,   606,   607,     0,
     345,   346,   347,   348,   349,   350,   351,     0,   353,     0,
       0,     0,     0,  1079,     0,     0,   361,   362,   363,   130,
     364,   365,   366,     0,  1080,   134,  1081,  1082,     0,   368,
     369,     0,   370,  1083,  1084,   373,  1085,  1086,   374,     0,
     376,   377,   378,   379,  1087,     0,     0,   382,   383,   384,
       0,   386,   387,  1088,   388,     0,   390,   391,   146,  1089,
    1090,  1091,  1092,   396,   397,   398,   399,   400,  1093,  1094,
     401,     0,   403,     0,   405,     0,   406,   407,   408,     0,
       0,     0,   412,  1095,   414,   415,     0,   417,   418,     0,
       0,     0,   422,   423,   424,  1096,   425,     0,  1097,  1098,
     427,   428,  1099,     0,   430,     0,   432,   162,     0,   163,
     434,     0,   435,     0,     0,   438,     0,   440,   441,     0,
     442,   443,   444,     0,   445,   446,   447,   448,     0,   168,
     450,     0,   451,   452,   453,  1100,  1101,     0,  1102,     0,
       0,   172,   173,   456,   174,   457,   458,   459,   460,     0,
     175,   462,     0,     0,   464,   465,   466,   467,   468,   469,
     470,   471,   472,   473,   474,   475,   476,  1103,   181,  1104,
     692,   479,   480,   481,   482,   183,     0,   484,   485,   185,
    1106,  1107,  1108,   487,     0,     0,   490,   693,     0,     0,
       0,   495,     0,     0,   498,   188,   189,  1110,   499,   500,
     501,   502,   503,     0,  1111,   504,   505,   506,     0,   508,
     509,   510,   511,   512,  1112,   513,     0,   515,   516,   517,
     518,   519,   520,   521,   522,   523,   196,   524,   198,   525,
     526,   527,   528,   529,     0,     0,   531,   532,   533,  1114,
     535,   201,   536,   537,     0,   538,  1115,     0,   540,   541,
     542,   543,   544,   545,   546,   547,  1116,   548,     0,   550,
     551,   552,     0,  1117,  1118,     0,   555,     0,   557,  1119,
     558,  1120,  1121,   560,   561,   562,   563,     0,     0,   565,
     566,   567,   568,   569,  1123,     0,   572,   573,   574,  1124,
     575,   218,   576,   577,     0,     0,     0,   580,   581,   582,
     583,   584,   585,     0,   219,    49,     0,   220,   610,     0,
       0,  1126,  1127,    52,  1128,    53,     0,     0,     0,     0,
       0,  1906,     0,     0,  1907,  1908,     0,     0,     0,  1909,
     640,    79,    80,    81,   339,     0,    83,    84,     0,    85,
      86,    87,   340,     0,   341,     0,    91,     0,    93,    94,
      95,    96,    97,    98,   641,    99,   100,   101,   342,   642,
     103,     0,   104,   105,   106,   107,   643,   644,     0,   109,
     110,   111,     0,   112,   645,   646,   115,   343,   344,     0,
       0,     0,   601,   602,     0,     0,     0,     0,   603,     0,
       0,     0,     0,     0,     0,     0,     0,   604,     0,   605,
       0,   606,   607,     0,   345,   346,   347,   348,   349,   350,
     351,  -922,   353,     0,     0,     0,  -922,  1079,     0,     0,
     361,   362,   363,   130,   364,   365,   366,     0,  1080,   134,
    1081,  1082,     0,   368,   369,     0,   370,  1083,  1084,   373,
    1085,  1086,   374,     0,   376,   377,   378,   379,  1087,     0,
       0,   382,   383,   384,     0,   386,   387,  1088,   388,     0,
     390,   391,   146,  1089,  1090,  1091,  1092,   396,   397,   398,
     399,   400,  1093,  1094,   401,     0,   403,     0,   405,     0,
     406,   407,   408,     0,     0,     0,   412,  1095,   414,   415,
       0,   417,   418,     0,     0,     0,   422,   423,   424,  1096,
     425,     0,  1097,  1098,   427,   428,  1099,     0,   430,     0,
     432,   162,     0,   163,   434,     0,   435,     0,     0,   438,
       0,   440,   441,     0,   442,   443,   444,     0,   445,   446,
     447,   448,     0,   168,   450,     0,   451,   452,   453,  1100,
    1101,     0,  1102,     0,     0,     0,     0,   456,   174,   457,
     458,   459,   460,     0,   175,   462,     0,     0,   464,   465,
     466,   467,   468,   469,   470,   471,   472,   473,   474,   475,
     476,  1103,   181,  1104,   692,   479,   480,   481,   482,   183,
       0,   484,   485,     0,  1106,  1107,  1108,   487,     0,     0,
     490,   693,     0,     0,     0,   495,     0,     0,   498,   188,
     189,  1110,   499,   500,   501,   502,   503,     0,  1111,   504,
     505,   506,     0,   508,   509,   510,   511,   512,  1112,   513,
       0,   515,   516,   517,   518,   519,   520,   521,   522,   523,
     196,   524,  1113,   525,   526,   527,   528,   529,     0,     0,
     531,   532,   533,  1114,   535,   201,   536,   537,     0,   538,
    1115,  -922,   540,   541,   542,   543,   544,   545,   546,   547,
    1116,   548,     0,   550,   551,   552,     0,  1117,  1118,     0,
     555,     0,   557,  1119,   558,  1120,  1121,   560,   561,   562,
     563,     0,  1122,   565,   566,   567,   568,   569,  1123,     0,
     572,   573,   574,  1124,   575,   218,   576,   577,     0,     0,
       0,   580,   581,   582,   583,   584,   585,     0,   219,    49,
       0,   220,   610,     0,     0,  1126,  1127,    52,  1128,    53,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1133,
       0,     0,     0,  1134,   640,    79,    80,    81,   339,     0,
      83,    84,     0,    85,    86,    87,   340,     0,   341,     0,
      91,     0,    93,    94,    95,    96,    97,    98,   641,    99,
     100,   101,   342,   642,   103,     0,   104,   105,   106,   107,
     643,   644,     0,   109,   110,   111,     0,   112,   645,   646,
     115,   343,   344,     0,     0,     0,   601,   602,     0,     0,
       0,     0,   603,     0,     0,     0,     0,     0,     0,     0,
       0,   604,     0,   605,     0,   606,   607,     0,   345,   346,
     347,   348,   349,   350,   351,  -923,   353,     0,     0,     0,
    -923,  1079,     0,     0,   361,   362,   363,   130,   364,   365,
     366,     0,  1080,   134,  1081,  1082,     0,   368,   369,     0,
     370,  1083,  1084,   373,  1085,  1086,   374,     0,   376,   377,
     378,   379,  1087,     0,     0,   382,   383,   384,     0,   386,
     387,  1088,   388,     0,   390,   391,   146,  1089,  1090,  1091,
    1092,   396,   397,   398,   399,   400,  1093,  1094,   401,     0,
     403,     0,   405,     0,   406,   407,   408,     0,     0,     0,
     412,  1095,   414,   415,     0,   417,   418,     0,     0,     0,
     422,   423,   424,  1096,   425,     0,  1097,  1098,   427,   428,
    1099,     0,   430,     0,   432,   162,     0,   163,   434,     0,
     435,     0,     0,   438,     0,   440,   441,     0,   442,   443,
     444,     0,   445,   446,   447,   448,     0,   168,   450,     0,
     451,   452,   453,  1100,  1101,     0,  1102,     0,     0,     0,
       0,   456,   174,   457,   458,   459,   460,     0,   175,   462,
       0,     0,   464,   465,   466,   467,   468,   469,   470,   471,
     472,   473,   474,   475,   476,  1103,   181,  1104,   692,   479,
     480,   481,   482,   183,     0,   484,   485,     0,  1106,  1107,
    1108,   487,     0,     0,   490,   693,     0,     0,     0,   495,
       0,     0,   498,   188,   189,  1110,   499,   500,   501,   502,
     503,     0,  1111,   504,   505,   506,     0,   508,   509,   510,
     511,   512,  1112,   513,     0,   515,   516,   517,   518,   519,
     520,   521,   522,   523,   196,   524,  1113,   525,   526,   527,
     528,   529,     0,     0,   531,   532,   533,  1114,   535,   201,
     536,   537,     0,   538,  1115,  -923,   540,   541,   542,   543,
     544,   545,   546,   547,  1116,   548,     0,   550,   551,   552,
       0,  1117,  1118,     0,   555,     0,   557,  1119,   558,  1120,
    1121,   560,   561,   562,   563,     0,  1122,   565,   566,   567,
     568,   569,  1123,     0,   572,   573,   574,  1124,   575,   218,
     576,   577,     0,     0,     0,   580,   581,   582,   583,   584,
     585,     0,   219,    49,     0,   220,   610,     0,     0,  1126,
    1127,    52,  1128,    53,   640,    79,    80,    81,   339,     0,
      83,    84,     0,    85,    86,    87,   340,  1134,   341,     0,
      91,     0,    93,    94,    95,    96,    97,    98,   641,    99,
     100,   101,   342,   642,   103,     0,   104,   105,   106,   107,
     643,   644,     0,   109,   110,   111,     0,   112,   645,   646,
     115,   343,   344,     0,     0,     0,   601,   602,     0,     0,
       0,     0,   603,     0,     0,     0,     0,     0,     0,     0,
       0,   604,     0,   605,     0,   606,   607,     0,   345,   346,
     347,   348,   349,   350,   351,     0,   353,     0,     0,     0,
       0,  1079,     0,     0,   361,   362,   363,   130,   364,   365,
     366,     0,  1080,   134,  1081,  1082,     0,   368,   369,     0,
     370,  1083,  1084,   373,  1085,  1086,   374,     0,   376,   377,
     378,   379,  1087,     0,     0,   382,   383,   384,     0,   386,
     387,  1088,   388,     0,   390,   391,   146,  1089,  1090,  1091,
    1092,   396,   397,   398,   399,   400,  1093,  1094,   401,     0,
     403,     0,   405,     0,   406,   407,   408,     0,     0,     0,
     412,  1095,   414,   415,     0,   417,   418,     0,     0,     0,
     422,   423,   424,  1096,   425,     0,  1097,  1098,   427,   428,
    1099,     0,   430,     0,   432,   162,     0,   163,   434,     0,
     435,     0,     0,   438,     0,   440,   441,     0,   442,   443,
     444,     0,   445,   446,   447,   448,     0,   168,   450,     0,
     451,   452,   453,  1100,  1101,     0,  1102,     0,     0,     0,
       0,   456,   174,   457,   458,   459,   460,     0,   175,   462,
       0,     0,   464,   465,   466,   467,   468,   469,   470,   471,
     472,   473,   474,   475,   476,  1103,   181,  1104,   692,   479,
     480,   481,   482,   183,     0,   484,   485,     0,     0,  1107,
    1108,   487,     0,     0,   490,   693,     0,     0,     0,   495,
       0,     0,   498,   188,   189,  1110,   499,   500,   501,   502,
     503,     0,  1111,   504,   505,   506,     0,   508,   509,   510,
     511,   512,  1112,   513,     0,   515,   516,   517,   518,   519,
     520,   521,   522,   523,   196,   524,   198,   525,   526,   527,
     528,   529,     0,     0,   531,   532,   533,  1114,   535,   201,
     536,   537,     0,   538,  1115,     0,   540,   541,   542,   543,
     544,   545,   546,   547,  1116,   548,     0,   550,   551,   552,
       0,  1117,  1118,     0,   555,     0,   557,  1119,   558,  1120,
    1121,   560,   561,   562,   563,     0,     0,   565,   566,   567,
     568,   569,  1123,     0,   572,   573,   574,  1124,   575,   218,
     576,   577,     0,     0,     0,   580,   581,   582,   583,   584,
     585,     0,   219,    49,     0,   220,   610,     0,     0,  1126,
    1127,    52,  1128,    53,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1908,     0,     0,     0,  1909,   640,    79,
      80,    81,   339,     0,    83,    84,     0,    85,    86,    87,
     340,     0,   341,     0,    91,     0,    93,    94,    95,    96,
      97,    98,   641,    99,   100,   101,   342,   642,   103,     0,
     104,   105,   106,   107,   643,   644,     0,   109,   110,   111,
       0,   112,   645,   646,   115,   343,   344,     0,     0,     0,
     601,   602,     0,     0,     0,     0,   603,     0,     0,     0,
       0,     0,     0,     0,     0,   604,     0,   605,     0,   606,
     607,     0,   345,   346,   347,   348,   349,   350,   351,     0,
     353,     0,     0,     0,     0,  1079,     0,     0,   361,   362,
     363,   130,   364,   365,   366,     0,  1080,   134,  1081,  1082,
       0,   368,   369,     0,   370,  1083,  1084,   373,  1085,  1086,
     374,     0,   376,   377,   378,   379,  1087,     0,     0,   382,
     383,   384,     0,   386,   387,  1088,   388,     0,   390,   391,
     146,  1089,  1090,  1091,  1092,   396,   397,   398,   399,   400,
    1093,  1094,   401,     0,   403,     0,   405,     0,   406,   407,
     408,     0,     0,     0,   412,  1095,   414,   415,     0,   417,
     418,     0,     0,     0,   422,   423,   424,  1096,   425,     0,
    1097,  1098,   427,   428,  1099,     0,   430,     0,   432,   162,
       0,   163,   434,     0,   435,     0,     0,   438,     0,   440,
     441,     0,   442,   443,   444,     0,   445,   446,   447,   448,
       0,   168,   450,     0,   451,   452,   453,  1100,  1101,     0,
    1102,     0,     0,     0,     0,   456,   174,   457,   458,   459,
     460,     0,   175,   462,     0,     0,   464,   465,   466,   467,
     468,   469,   470,   471,   472,   473,   474,   475,   476,  1103,
     181,  1104,   692,   479,   480,   481,   482,   183,     0,   484,
     485,     0,     0,  1107,  1108,   487,     0,     0,   490,   693,
       0,     0,     0,   495,     0,     0,   498,   188,   189,  1110,
     499,   500,   501,   502,   503,     0,  1111,   504,   505,   506,
       0,   508,   509,   510,   511,   512,  1112,   513,     0,   515,
     516,   517,   518,   519,   520,   521,   522,   523,   196,   524,
     198,   525,   526,   527,   528,   529,     0,     0,   531,   532,
     533,  1114,   535,   201,   536,   537,     0,   538,  1115,     0,
     540,   541,   542,   543,   544,   545,   546,   547,  1116,   548,
       0,   550,   551,   552,     0,  1117,  1118,     0,   555,     0,
     557,  1119,   558,  1120,  1121,   560,   561,   562,   563,     0,
       0,   565,   566,   567,   568,   569,  1123,     0,   572,   573,
     574,  1124,   575,   218,   576,   577,     0,     0,     0,   580,
     581,   582,   583,   584,   585,     0,   219,    49,     0,   220,
     610,     0,     0,  1126,  1127,    52,  1128,    53,     0,    79,
      80,    81,   339,     0,    83,    84,     0,    85,    86,    87,
     340,  1909,   341,     0,    91,     0,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   342,     0,   103,     0,
     104,   105,   106,   107,     0,     0,     0,   109,   110,   111,
       0,   112,     0,     0,   115,   343,   344,     0,     0,     0,
     601,   602,     0,     0,     0,     0,   603,     0,     0,     0,
       0,     0,     0,     0,     0,   604,     0,   605,     0,   606,
     607,     0,   345,   346,   347,   348,   349,   350,   351,     0,
     353,     0,     0,     0,     0,     0,  2578,     0,   361,   362,
     363,     0,   364,   365,   366,     0,   133,     0,   135,     0,
       0,   368,   369,     0,   370,     0,     0,   373,   608,   136,
     374,     0,   376,   377,   378,   379,   140,     0,     0,   382,
     383,   384,     0,   386,   387,   143,   388,     0,   390,   391,
       0,     0,     0,     0,     0,   396,   397,   398,   399,   400,
     149,   150,   401,     0,   403,     0,   405,     0,   406,   407,
     408,     0,     0,     0,   412,   413,   414,   415,     0,   417,
     418,     0,   420,  -709,   422,   423,   424,   157,   425,     0,
     159,     0,   427,   428,   161,  -709,   430,     0,   432,     0,
       0,     0,   434,     0,   435,     0,     0,   438,     0,   440,
     441,     0,   442,   443,   444,     0,   445,   446,   447,   448,
       0,     0,   450,     0,   451,   452,   453,     0,   170,  -709,
     171,     0,     0,     0,     0,   456,     0,   457,   458,   459,
     460,     0,     0,   462,     0,  -709,   464,   465,   466,   467,
     468,   469,   470,   471,   472,   473,   474,   475,   476,   477,
       0,   182,     0,   479,   480,   481,   482,   183,     0,   484,
     485,     0,     0,   186,   187,   487,     0,  -709,   490,     0,
       0,     0,   494,   495,     0,  -709,   498,     0,     0,     0,
     499,   500,   501,   502,   503,     0,   190,   504,   505,   506,
       0,   508,   509,   510,   511,   512,   192,   513,     0,   515,
     516,   517,   518,   519,   520,   521,   522,   523,     0,   524,
     198,   525,   526,   527,   528,   529,     0,     0,   531,   532,
     533,     0,   535,   201,   536,   537,     0,   538,   204,     0,
     540,   541,   542,   543,   544,   545,   546,   547,   206,   548,
       0,   550,   551,   552,     0,   207,   208,     0,   555,     0,
     557,   209,   558,   210,     0,   560,   561,   562,   563,  -709,
       0,   565,   566,   567,   568,   569,     0,     0,   572,   573,
     574,   217,   575,     4,   576,   577,     0,     0,     0,   580,
     581,   582,   583,   584,   585,     0,   219,     0,     5,   220,
       0,     0,     0,     0,     0,     0,     0,     6,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     7,
       8,     0,  1213,     0,     0,     0,     0,    10,    11,     0,
       0,     0,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,    35,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    36,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    37,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    38,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    39,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    40,     0,
       0,    41,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      43,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    44,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    45,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    46,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    47,     0,
       0,    48,    49,     0,    50,     0,     0,     0,     0,     0,
      52,     0,    53,    54,     0,     0,     0,    55,    56,    57,
      58,    59,     0,     0,    60,    61,   913,    79,    80,    81,
     339,     0,    83,    84,     0,    85,    86,    87,   340,     0,
     341,     0,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,   342,     0,   103,     0,   104,   105,
     106,   107,     0,     0,     0,   109,   110,   111,     0,   112,
       0,     0,   115,   343,   344,     0,     0,     0,   601,   602,
       0,     0,     0,     0,   603,     0,     0,     0,     0,     0,
       0,     0,     0,   604,     0,   605,     0,   606,   607,     0,
     345,   346,   347,   348,   349,   350,   351,     0,   353,     0,
       0,     0,     0,     0,     0,     0,   361,   362,   363,   130,
     364,   365,   366,   132,   133,   134,   135,     0,     0,   368,
     369,     0,   370,     0,     0,   373,   608,   136,   374,     0,
     376,   377,   378,   379,   140,     0,     0,   382,   383,   384,
       0,   386,   387,   143,   388,     0,   390,   391,   146,     0,
       0,     0,     0,   396,   397,   398,   399,   400,   149,   150,
     401,     0,   403,     0,   405,     0,   406,   407,   408,     0,
       0,     0,   412,   413,   414,   415,     0,   417,   418,     0,
     420,     0,   422,   423,   424,   157,   425,     0,   159,     0,
     427,   428,   161,     0,   430,     0,   432,   162,     0,   163,
     434,     0,   435,     0,     0,   438,     0,   440,   441,   166,
     442,   443,   444,   167,   445,   446,   447,   448,     0,   168,
     450,     0,   451,   452,   453,     0,   170,     0,   171,     0,
       0,   172,   173,   456,   174,   457,   458,   459,   460,     0,
     175,   462,   176,     0,   464,   465,   466,   467,   468,   469,
     470,   471,   472,   473,   474,   475,   476,   477,   181,   182,
     692,   479,   480,   481,   482,   183,     0,   484,   485,   185,
       0,   186,   187,   487,     0,     0,   490,   693,     0,   849,
     494,   495,     0,     0,   498,   188,   189,     0,   499,   500,
     501,   502,   503,     0,   190,   504,   505,   506,     0,   508,
     509,   510,   511,   512,   192,   513,     0,   515,   516,   517,
     518,   519,   520,   521,   522,   523,   196,   524,   198,   525,
     526,   527,   528,   529,     0,   199,   531,   532,   533,     0,
     535,   201,   536,   537,   203,   538,   204,     0,   540,   541,
     542,   543,   544,   545,   546,   547,   206,   548,     0,   550,
     551,   552,     0,   207,   208,     0,   555,     0,   557,   209,
     558,   210,     0,   560,   561,   562,   563,     0,     0,   565,
     566,   567,   568,   569,     0,     0,   572,   573,   574,   217,
     575,   218,   576,   577,     0,     0,     0,   580,   581,   582,
     583,   584,   585,     0,   219,     0,     0,   220,     0,     0,
       0,     0,     0,    79,    80,    81,   339,     0,    83,    84,
       0,    85,    86,    87,   340,     0,   341,     0,    91,  2332,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     342,     0,   103,     0,   104,   105,   106,   107,     0,     0,
       0,   109,   110,   111,     0,   112,     0,     0,   115,   343,
     344,     0,     0,     0,   601,   602,     0,     0,     0,     0,
     603,     0,     0,     0,     0,     0,     0,     0,     0,   604,
       0,   605,     0,   606,   607,     0,   345,   346,   347,   348,
     349,   350,   351,     0,   353,     0,     0,     0,     0,     0,
       0,     0,   361,   362,   363,   130,   364,   365,   366,   132,
     133,   134,   135,     0,     0,   368,   369,     0,   370,     0,
       0,   373,   608,   136,   374,     0,   376,   377,   378,   379,
     140,     0,     0,   382,   383,   384,     0,   386,   387,   143,
     388,     0,   390,   391,   146,     0,     0,     0,     0,   396,
     397,   398,   399,   400,   149,   150,   401,     0,   403,     0,
     405,     0,   406,   407,   408,     0,     0,     0,   412,   413,
     414,   415,     0,   417,   418,     0,   420,     0,   422,   423,
     424,   157,   425,     0,   159,     0,   427,   428,   161,     0,
     430,     0,   432,   162,     0,   163,   434,     0,   435,     0,
       0,   438,     0,   440,   441,   166,   442,   443,   444,   167,
     445,   446,   447,   448,     0,   168,   450,     0,   451,   452,
     453,     0,   170,     0,   171,     0,     0,   172,   173,   456,
     174,   457,   458,   459,   460,     0,   175,   462,   176,     0,
     464,   465,   466,   467,   468,   469,   470,   471,   472,   473,
     474,   475,   476,   477,   181,   182,   692,   479,   480,   481,
     482,   183,     0,   484,   485,   185,     0,   186,   187,   487,
       0,     0,   490,   693,     0,   849,   494,   495,     0,     0,
     498,   188,   189,     0,   499,   500,   501,   502,   503,     0,
     190,   504,   505,   506,     0,   508,   509,   510,   511,   512,
     192,   513,     0,   515,   516,   517,   518,   519,   520,   521,
     522,   523,   196,   524,   198,   525,   526,   527,   528,   529,
       0,     0,   531,   532,   533,     0,   535,   201,   536,   537,
     203,   538,   204,     0,   540,   541,   542,   543,   544,   545,
     546,   547,   206,   548,     0,   550,   551,   552,     0,   207,
     208,     0,   555,     0,   557,   209,   558,   210,     0,   560,
     561,   562,   563,     0,     0,   565,   566,   567,   568,   569,
       0,     0,   572,   573,   574,   217,   575,   218,   576,   577,
       0,     0,     0,   580,   581,   582,   583,   584,   585,     0,
     219,     0,     0,   220,     0,     0,     0,     0,     0,    79,
      80,    81,   339,     0,    83,    84,     0,    85,    86,    87,
     340,     0,   341,     0,    91,  2332,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   342,     0,   103,     0,
     104,   105,   106,   107,     0,     0,     0,   109,   110,   111,
       0,   112,     0,     0,   115,   343,   344,     0,     0,     0,
     601,   602,     0,     0,     0,     0,   603,     0,     0,     0,
       0,     0,     0,     0,     0,   604,     0,   605,     0,   606,
     607,     0,   345,   346,   347,   348,   349,   350,   351,     0,
     353,     0,     0,     0,     0,     0,     0,     0,   361,   362,
     363,   130,   364,   365,   366,   132,   133,   134,   135,     0,
       0,   368,   369,     0,   370,     0,     0,   373,   608,   136,
     374,     0,   376,   377,   378,   379,   140,     0,     0,   382,
     383,   384,     0,   386,   387,   143,   388,     0,   390,   391,
     146,     0,     0,     0,     0,   396,   397,   398,   399,   400,
     149,   150,   401,     0,   403,     0,   405,     0,   406,   407,
     408,     0,     0,     0,   412,   413,   414,   415,     0,   417,
     418,     0,   420,     0,   422,   423,   424,   157,   425,     0,
     159,     0,   427,   428,   161,     0,   430,     0,   432,   162,
       0,   163,   434,     0,   435,     0,     0,   438,     0,   440,
     441,   166,   442,   443,   444,   167,   445,   446,   447,   448,
       0,   168,   450,     0,   451,   452,   453,     0,   170,     0,
     171,     0,     0,   172,   173,   456,   174,   457,   458,   459,
     460,     0,   175,   462,   176,     0,   464,   465,   466,   467,
     468,   469,   470,   471,   472,   473,   474,   475,   476,   477,
     181,   182,   692,   479,   480,   481,   482,   183,     0,   484,
     485,   185,     0,   186,   187,   487,     0,     0,   490,   693,
       0,     0,   494,   495,     0,     0,   498,   188,   189,     0,
     499,   500,   501,   502,   503,     0,   190,   504,   505,   506,
       0,   508,   509,   510,   511,   512,   192,   513,     0,   515,
     516,   517,   518,   519,   520,   521,   522,   523,   196,   524,
     198,   525,   526,   527,   528,   529,     0,     0,   531,   532,
     533,     0,   535,   201,   536,   537,   203,   538,   204,     0,
     540,   541,   542,   543,   544,   545,   546,   547,   206,   548,
       0,   550,   551,   552,     0,   207,   208,     0,   555,     0,
     557,   209,   558,   210,     0,   560,   561,   562,   563,     0,
       0,   565,   566,   567,   568,   569,     0,     0,   572,   573,
     574,   217,   575,   218,   576,   577,     0,     0,     0,   580,
     581,   582,   583,   584,   585,     0,   219,     0,     0,   220,
       0,     0,     0,     0,     0,    79,    80,    81,   339,     0,
      83,    84,     0,    85,    86,    87,   340,     0,   341,     0,
      91,  2813,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   342,     0,   103,     0,   104,   105,   106,   107,
       0,     0,     0,   109,   110,   111,     0,   112,     0,     0,
     115,   343,   344,     0,     0,     0,   601,   602,     0,     0,
       0,     0,   603,     0,     0,     0,     0,     0,     0,     0,
       0,   604,     0,   605,     0,   606,   607,     0,   345,   346,
     347,   348,   349,   350,   351,     0,   353,     0,     0,     0,
       0,     0,     0,     0,   361,   362,   363,     0,   364,   365,
     366,     0,   133,     0,   135,     0,     0,   368,   369,     0,
     370,     0,     0,   373,   608,   136,   374,     0,   376,   377,
     378,   379,   140,     0,     0,   382,   383,   384,     0,   386,
     387,   143,   388,     0,   390,   391,     0,     0,     0,     0,
       0,   396,   397,   398,   399,   400,   149,   150,   401,     0,
     403,     0,   405,     0,   406,   407,   408,     0,     0,     0,
     412,   413,   414,   415,     0,   417,   418,     0,   420,     0,
     422,   423,   424,   157,   425,     0,   159,     0,   427,   428,
     161,     0,   430,     0,   432,     0,     0,     0,   434,     0,
     435,     0,     0,   438,     0,   440,   441,     0,   442,   443,
     444,     0,   445,   446,   447,   448,     0,     0,   450,     0,
     451,   452,   453,     0,   170,     0,   171,     0,     0,     0,
       0,   456,     0,   457,   458,   459,   460,     0,     0,   462,
       0,     0,   464,   465,   466,   467,   468,   469,   470,   471,
     472,   473,   474,   475,   476,   477,     0,   182,     0,   479,
     480,   481,   482,   183,     0,   484,   485,     0,     0,   186,
     187,   487,     0,     0,   490,     0,     0,     0,   494,   495,
       0,     0,   498,     0,     0,     0,   499,   500,   501,   502,
     503,     0,   190,   504,   505,   506,     0,   508,   509,   510,
     511,   512,   192,   513,     0,   515,   516,   517,   518,   519,
     520,   521,   522,   523,     0,   524,   198,   525,   526,   527,
     528,   529,     0,     0,   531,   532,   533,     0,   535,   201,
     536,   537,     0,   538,   204,     0,   540,   541,   542,   543,
     544,   545,   546,   547,   206,   548,     0,   550,   551,   552,
       0,   207,   208,     0,   555,     0,   557,   209,   558,   210,
       0,   560,   561,   562,   563,     0,     0,   565,   566,   567,
     568,   569,     0,     0,   572,   573,   574,   217,   575,     0,
     576,   577,     0,     0,     0,   580,   581,   582,   583,   584,
     585,     0,   219,    49,     0,   220,   610,     0,     0,     0,
       0,    52,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2131,  2132,    79,    80,
      81,   339,     0,    83,    84,     0,    85,    86,    87,   340,
       0,   341,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   342,     0,   103,     0,   104,
     105,   106,   107,     0,     0,     0,   109,   110,   111,     0,
     112,     0,     0,   115,   343,   344,     0,     0,     0,   601,
     602,     0,     0,     0,     0,   603,     0,     0,     0,     0,
       0,     0,     0,     0,   604,     0,   605,     0,   606,   607,
       0,   345,   346,   347,   348,   349,   350,   351,     0,   353,
       0,     0,     0,     0,     0,     0,     0,   361,   362,   363,
       0,   364,   365,   366,     0,   133,     0,   135,     0,     0,
     368,   369,     0,   370,     0,     0,   373,   608,   136,   374,
       0,   376,   377,   378,   379,   140,     0,     0,   382,   383,
     384,     0,   386,   387,   143,   388,     0,   390,   391,     0,
       0,     0,     0,     0,   396,   397,   398,   399,   400,   149,
     150,   401,     0,   403,     0,   405,     0,   406,   407,   408,
       0,     0,     0,   412,   413,   414,   415,     0,   417,   418,
       0,   420,     0,   422,   423,   424,   157,   425,     0,   159,
       0,   427,   428,   161,     0,   430,     0,   432,     0,     0,
       0,   434,     0,   435,     0,     0,   438,     0,   440,   441,
       0,   442,   443,   444,     0,   445,   446,   447,   448,     0,
       0,   450,     0,   451,   452,   453,     0,   170,     0,   171,
       0,     0,     0,     0,   456,     0,   457,   458,   459,   460,
       0,     0,   462,     0,     0,   464,   465,   466,   467,   468,
     469,   470,   471,   472,   473,   474,   475,   476,   477,     0,
     182,     0,   479,   480,   481,   482,   183,     0,   484,   485,
       0,     0,   186,   187,   487,     0,     0,   490,     0,     0,
       0,   494,   495,     0,     0,   498,     0,     0,     0,   499,
     500,   501,   502,   503,     0,   190,   504,   505,   506,     0,
     508,   509,   510,   511,   512,   192,   513,     0,   515,   516,
     517,   518,   519,   520,   521,   522,   523,     0,   524,   198,
     525,   526,   527,   528,   529,     0,     0,   531,   532,   533,
       0,   535,   201,   536,   537,     0,   538,   204,     0,   540,
     541,   542,   543,   544,   545,   546,   547,   206,   548,     0,
     550,   551,   552,     0,   207,   208,     0,   555,     0,   557,
     209,   558,   210,     0,   560,   561,   562,   563,     0,     0,
     565,   566,   567,   568,   569,     0,     0,   572,   573,   574,
     217,   575,     0,   576,   577,     0,     0,     0,   580,   581,
     582,   583,   584,   585,     0,   219,    49,     0,   220,   610,
       0,     0,     0,     0,    52,     0,    79,    80,    81,   339,
       0,    83,    84,     0,    85,    86,    87,   340,     0,   341,
    2132,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   342,     0,   103,     0,   104,   105,   106,
     107,     0,     0,     0,   109,   110,   111,     0,   112,     0,
       0,   115,   343,   344,     0,     0,     0,   601,   602,     0,
       0,     0,     0,   603,     0,     0,     0,     0,     0,     0,
       0,     0,   604,     0,   605,     0,   606,   607,     0,   345,
     346,   347,   348,   349,   350,   351,     0,   353,     0,     0,
       0,     0,     0,     0,     0,   361,   362,   363,     0,   364,
     365,   366,     0,   133,     0,   135,     0,     0,   368,   369,
       0,   370,     0,     0,   373,   608,   136,   374,     0,   376,
     377,   378,   379,   140,     0,     0,   382,   383,   384,     0,
     386,   387,   143,   388,     0,   390,   391,     0,     0,     0,
       0,     0,   396,   397,   398,   399,   400,   149,   150,   401,
       0,   403,     0,   405,     0,   406,   407,   408,     0,     0,
       0,   412,   413,   414,   415,     0,   417,   418,     0,   420,
       0,   422,   423,   424,   157,   425,     0,   159,     0,   427,
     428,   161,     0,   430,     0,   432,     0,     0,     0,   434,
       0,   435,     0,     0,   438,     0,   440,   441,     0,   442,
     443,   444,     0,   445,   446,   447,   448,     0,     0,   450,
       0,   451,   452,   453,     0,   170,     0,   171,     0,     0,
       0,     0,   456,     0,   457,   458,   459,   460,     0,     0,
     462,     0,     0,   464,   465,   466,   467,   468,   469,   470,
     471,   472,   473,   474,   475,   476,   477,     0,   182,   692,
     479,   480,   481,   482,   183,     0,   484,   485,     0,     0,
     186,   187,   487,     0,     0,   490,   693,     0,     0,   494,
     495,     0,     0,   498,     0,     0,     0,   499,   500,   501,
     502,   503,     0,   190,   504,   505,   506,     0,   508,   509,
     510,   511,   512,   192,   513,     0,   515,   516,   517,   518,
     519,   520,   521,   522,   523,     0,   524,   198,   525,   526,
     527,   528,   529,     0,     0,   531,   532,   533,     0,   535,
     201,   536,   537,     0,   538,   204,     0,   540,   541,   542,
     543,   544,   545,   546,   547,   206,   548,     0,   550,   551,
     552,     0,   207,   208,     0,   555,     0,   557,   209,   558,
     210,     0,   560,   561,   562,   563,     0,     0,   565,   566,
     567,   568,   569,     0,     0,   572,   573,   574,   217,   575,
       0,   576,   577,     0,     0,     0,   580,   581,   582,   583,
     584,   585,     0,   219,     0,     0,   220,     0,     0,     0,
       0,     0,    79,    80,    81,   339,     0,    83,    84,     0,
      85,    86,    87,   340,     0,   341,     0,    91,  1207,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   342,
       0,   103,     0,   104,   105,   106,   107,     0,     0,     0,
     109,   110,   111,     0,   112,     0,     0,   115,   343,   344,
       0,     0,     0,   601,   602,     0,     0,     0,     0,   603,
       0,     0,     0,     0,     0,     0,     0,     0,   604,     0,
     605,     0,   606,   607,     0,   345,   346,   347,   348,   349,
     350,   351,     0,   353,     0,     0,     0,     0,     0,     0,
       0,   361,   362,   363,     0,   364,   365,   366,     0,   133,
       0,   135,     0,     0,   368,   369,     0,   370,     0,     0,
     373,   608,   136,   374,     0,   376,   377,   378,   379,   140,
       0,     0,   382,   383,   384,     0,   386,   387,   143,   388,
       0,   390,   391,     0,     0,     0,     0,     0,   396,   397,
     398,   399,   400,   149,   150,   401,     0,   403,     0,   405,
       0,   406,   407,   408,     0,     0,     0,   412,   413,   414,
     415,     0,   417,   418,     0,   420,     0,   422,   423,   424,
     157,   425,     0,   159,     0,   427,   428,   161,     0,   430,
       0,   432,     0,     0,     0,   434,     0,   435,     0,     0,
     438,     0,   440,   441,     0,   442,   443,   444,     0,   445,
     446,   447,   448,     0,     0,   450,     0,   451,   452,   453,
       0,   170,     0,   171,     0,     0,     0,     0,   456,     0,
     457,   458,   459,   460,     0,     0,   462,     0,     0,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,     0,   182,     0,   479,   480,   481,   482,
     183,     0,   484,   485,     0,     0,   186,   187,   487,     0,
       0,   490,     0,     0,     0,   494,   495,     0,     0,   498,
       0,     0,     0,   499,   500,   501,   502,   503,     0,   190,
     504,   505,   506,     0,   508,   509,   510,   511,   512,   192,
     513,     0,   515,   516,   517,   518,   519,   520,   521,   522,
     523,     0,   524,   198,   525,   526,   527,   528,   529,     0,
     199,   531,   532,   533,     0,   535,   201,   536,   537,     0,
     538,   204,     0,   540,   541,   542,   543,   544,   545,   546,
     547,   206,   548,     0,   550,   551,   552,     0,   207,   208,
       0,   555,     0,   557,   209,   558,   210,     0,   560,   561,
     562,   563,     0,     0,   565,   566,   567,   568,   569,     0,
       0,   572,   573,   574,   217,   575,     0,   576,   577,     0,
       0,     0,   580,   581,   582,   583,   584,   585,     0,   219,
       0,     0,   220,   610,     0,     0,     0,     0,    79,    80,
      81,   339,     0,    83,    84,     0,    85,    86,    87,   340,
       0,   341,     0,    91,   221,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   342,     0,   103,     0,   104,
     105,   106,   107,     0,     0,     0,   109,   110,   111,     0,
     112,     0,     0,   115,   343,   344,     0,     0,     0,   601,
     602,     0,     0,     0,     0,   603,     0,     0,     0,     0,
       0,     0,     0,     0,   604,     0,   605,     0,   606,   607,
       0,   345,   346,   347,   348,   349,   350,   351,     0,   353,
       0,     0,     0,     0,     0,     0,     0,   361,   362,   363,
       0,   364,   365,   366,     0,   133,     0,   135,     0,     0,
     368,   369,     0,   370,     0,     0,   373,   608,   136,   374,
       0,   376,   377,   378,   379,   140,     0,     0,   382,   383,
     384,     0,   386,   387,   143,   388,     0,   390,   391,     0,
       0,     0,     0,     0,   396,   397,   398,   399,   400,   149,
     150,   401,     0,   403,     0,   405,     0,   406,   407,   408,
       0,     0,     0,   412,   413,   414,   415,     0,   417,   418,
       0,   420,     0,   422,   423,   424,   157,   425,     0,   159,
       0,   427,   428,   161,     0,   430,     0,   432,     0,     0,
       0,   434,     0,   435,     0,     0,   438,     0,   440,   441,
       0,   442,   443,   444,     0,   445,   446,   447,   448,     0,
       0,   450,     0,   451,   452,   453,     0,   170,     0,   171,
       0,     0,     0,     0,   456,     0,   457,   458,   459,   460,
       0,     0,   462,     0,     0,   464,   465,   466,   467,   468,
     469,   470,   471,   472,   473,   474,   475,   476,   477,     0,
     182,     0,   479,   480,   481,   482,   183,     0,   484,   485,
       0,     0,   186,   187,   487,     0,     0,   490,     0,     0,
       0,   494,   495,     0,     0,   498,     0,     0,     0,   499,
     500,   501,   502,   503,     0,   190,   504,   505,   506,     0,
     508,   509,   510,   511,   512,   192,   513,     0,   515,   516,
     517,   518,   519,   520,   521,   522,   523,     0,   524,   198,
     525,   526,   527,   528,   529,     0,   199,   531,   532,   533,
       0,   535,   201,   536,   537,     0,   538,   204,     0,   540,
     541,   542,   543,   544,   545,   546,   547,   206,   548,     0,
     550,   551,   552,     0,   207,   208,     0,   555,     0,   557,
     209,   558,   210,     0,   560,   561,   562,   563,     0,     0,
     565,   566,   567,   568,   569,     0,     0,   572,   573,   574,
     217,   575,     0,   576,   577,     0,     0,     0,   580,   581,
     582,   583,   584,   585,     0,   219,     0,     0,   220,     0,
       0,     0,     0,     0,    79,    80,    81,   339,     0,    83,
      84,     0,    85,    86,    87,   340,     0,   341,     0,    91,
     221,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   342,     0,   103,     0,   104,   105,   106,   107,     0,
       0,     0,   109,   110,   111,     0,   112,     0,     0,   115,
     343,   344,     0,     0,     0,   601,   602,     0,     0,     0,
       0,   603,     0,     0,     0,     0,     0,     0,     0,     0,
     604,     0,   605,     0,   606,   607,     0,   345,   346,   347,
     348,   349,   350,   351,     0,   353,     0,     0,     0,     0,
       0,     0,     0,   361,   362,   363,     0,   364,   365,   366,
       0,   133,     0,   135,     0,     0,   368,   369,     0,   370,
       0,     0,   373,   608,   136,   374,     0,   376,   377,   378,
     379,   140,     0,     0,   382,   383,   384,     0,   386,   387,
     143,   388,     0,   390,   391,     0,     0,     0,     0,     0,
     396,   397,   398,   399,   400,   149,   150,   401,     0,   403,
       0,   405,     0,   406,   407,   408,     0,     0,     0,   412,
     413,   414,   415,     0,   417,   418,     0,   420,     0,   422,
     423,   424,   157,   425,     0,   159,     0,   427,   428,   161,
       0,   430,     0,   432,     0,     0,     0,   434,     0,   435,
       0,     0,   438,     0,   440,   441,     0,   442,   443,   444,
       0,   445,   446,   447,   448,     0,     0,   450,     0,   451,
     452,   453,     0,   170,     0,   171,     0,     0,     0,     0,
     456,     0,   457,   458,   459,   460,     0,     0,   462,     0,
       0,   464,   465,   466,   467,   468,   469,   470,   471,   472,
     473,   474,   475,   476,   477,     0,   182,     0,   479,   480,
     481,   482,   183,     0,   484,   485,     0,     0,   186,   187,
     487,     0,     0,   490,     0,     0,     0,   494,   495,     0,
       0,   498,     0,     0,     0,   499,   500,   501,   502,   503,
       0,   190,   504,   505,   506,     0,   508,   509,   510,   511,
     512,   192,   513,     0,   515,   516,   517,   518,   519,   520,
     521,   522,   523,     0,   524,   198,   525,   526,   527,   528,
     529,     0,     0,   531,   532,   533,     0,   535,   201,   536,
     537,     0,   538,   204,     0,   540,   541,   542,   543,   544,
     545,   546,   547,   206,   548,     0,   550,   551,   552,     0,
     207,   208,     0,   555,     0,   557,   209,   558,   210,     0,
     560,   561,   562,   563,     0,     0,   565,   566,   567,   568,
     569,     0,     0,   572,   573,   574,   217,   575,     0,   576,
     577,     0,     0,     0,   580,   581,   582,   583,   584,   585,
       0,   219,     0,     0,   220,     0,     0,     0,     0,     0,
      79,    80,    81,   339,     0,    83,    84,     0,    85,    86,
      87,   340,     0,   341,     0,    91,  1617,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   342,     0,   103,
       0,   104,   105,   106,   107,     0,     0,     0,   109,   110,
     111,     0,   112,     0,     0,   115,   343,   344,     0,     0,
       0,   601,   602,     0,     0,     0,     0,   603,     0,     0,
       0,     0,     0,     0,     0,     0,   604,     0,   605,     0,
     606,   607,     0,   345,   346,   347,   348,   349,   350,   351,
       0,   353,     0,     0,     0,     0,     0,     0,     0,   361,
     362,   363,     0,   364,   365,   366,     0,   133,     0,   135,
       0,     0,   368,   369,     0,   370,     0,     0,   373,   608,
     136,   374,     0,   376,   377,   378,   379,   140,     0,     0,
     382,   383,   384,     0,   386,   387,   143,   388,     0,   390,
     391,     0,     0,     0,     0,     0,   396,   397,   398,   399,
     400,   149,   150,   401,     0,   403,     0,   405,     0,   406,
     407,   408,     0,     0,     0,   412,   413,   414,   415,     0,
     417,   418,     0,   420,     0,   422,   423,   424,   157,   425,
       0,   159,     0,   427,   428,   161,     0,   430,     0,   432,
       0,     0,     0,   434,     0,   435,     0,     0,   438,     0,
     440,   441,     0,   442,   443,   444,     0,   445,   446,   447,
     448,     0,     0,   450,     0,   451,   452,   453,     0,   170,
       0,   171,     0,     0,     0,     0,   456,     0,   457,   458,
     459,   460,     0,     0,   462,     0,     0,   464,   465,   466,
     467,   468,   469,   470,   471,   472,   473,   474,   475,   476,
     477,     0,   182,     0,   479,   480,   481,   482,   183,     0,
     484,   485,     0,     0,   186,   187,   487,     0,     0,   490,
       0,     0,     0,   494,   495,     0,     0,   498,     0,     0,
       0,   499,   500,   501,   502,   503,     0,   190,   504,   505,
     506,     0,   508,   509,   510,   511,   512,   192,   513,     0,
     515,   516,   517,   518,   519,   520,   521,   522,   523,     0,
     524,   198,   525,   526,   527,   528,   529,     0,     0,   531,
     532,   533,     0,   535,   201,   536,   537,     0,   538,   204,
       0,   540,   541,   542,   543,   544,   545,   546,   547,   206,
     548,     0,   550,   551,   552,     0,   207,   208,     0,   555,
       0,   557,   209,   558,   210,     0,   560,   561,   562,   563,
       0,     0,   565,   566,   567,   568,   569,     0,     0,   572,
     573,   574,   217,   575,     0,   576,   577,     0,     0,     0,
     580,   581,   582,   583,   584,   585,     0,   219,     0,     0,
     220,     0,     0,     0,     0,   640,    79,    80,    81,   339,
       0,    83,    84,     0,    85,    86,    87,   340,     0,   341,
       0,    91,  2760,    93,    94,    95,    96,    97,    98,   641,
      99,   100,   101,   342,   642,   103,     0,   104,   105,   106,
     107,   643,   644,     0,   109,   110,   111,     0,   112,   645,
     646,   115,   343,   344,     0,     0,     0,   601,   602,     0,
       0,     0,     0,   603,     0,     0,     0,     0,     0,     0,
       0,     0,   604,     0,   605,     0,   606,   607,     0,   345,
     346,   347,   348,   349,   350,   351,     0,   353,     0,     0,
       0,     0,     0,     0,     0,   361,   362,   363,     0,   364,
     365,   366,     0,  1336,     0,  1337,  1082,     0,   368,   369,
       0,   370,     0,     0,   373,  1338,  1339,   374,     0,   376,
     377,   378,   379,     0,     0,     0,   382,   383,   384,     0,
     386,   387,     0,   388,     0,   390,   391,     0,     0,     0,
       0,     0,   396,   397,   398,   399,   400,  1340,  1341,   401,
       0,   403,     0,   405,     0,   406,   407,   408,     0,     0,
       0,   412,  1095,   414,   415,     0,   417,   418,     0,   420,
       0,   422,   423,   424,     0,   425,     0,     0,     0,   427,
     428,  1342,     0,   430,     0,   432,     0,     0,     0,   434,
       0,   435,     0,     0,   438,     0,   440,   441,     0,   442,
     443,   444,     0,   445,   446,   447,   448,     0,     0,   450,
       0,   451,   452,   453,  1100,  1343,     0,  1344,     0,     0,
       0,     0,   456,     0,   457,   458,   459,   460,     0,     0,
     462,     0,     0,   464,   465,   466,   467,   468,   469,   470,
     471,   472,   473,   474,   475,   476,  1103,     0,  1345,     0,
     479,   480,   481,   482,     0,     0,   484,   485,     0,     0,
       0,  1346,   487,     0,     0,   490,     0,     0,     0,  2408,
     495,     0,     0,   498,     0,     0,     0,   499,   500,   501,
     502,   503,     0,     0,   504,   505,   506,     0,   508,   509,
     510,   511,   512,  1347,   513,     0,   515,   516,   517,   518,
     519,   520,   521,   522,   523,     0,   524,     0,   525,   526,
     527,   528,   529,     0,     0,   531,   532,   533,     0,   535,
    1348,   536,   537,     0,   538,  1349,     0,   540,   541,   542,
     543,   544,   545,   546,   547,     0,   548,     0,   550,   551,
     552,     0,  1350,  1351,     0,   555,     0,   557,     0,   558,
       0,     0,   560,   561,   562,   563,     0,     0,   565,   566,
     567,   568,   569,     0,     0,   572,   573,   574,  1352,   575,
       0,   576,   577,     0,     0,     0,   580,   581,   582,   583,
     584,   585,     0,   219,    49,   995,   220,   610,     0,     0,
       0,     0,    52,     0,    53,   996,   997,   998,     0,   999,
    2409,  1001,  1002,  1003,  1004,    79,    80,    81,   339,     0,
      83,    84,     0,    85,    86,    87,   340,     0,   341,     0,
      91,     0,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   342,     0,   103,     0,   104,   105,   106,   107,
       0,     0,     0,   109,   110,   111,     0,   112,     0,     0,
     115,   343,   344,     0,     0,     0,   601,   602,     0,     0,
       0,     0,   603,     0,     0,     0,     0,     0,     0,     0,
       0,   604,     0,   605,     0,   606,   607,     0,   345,   346,
     347,   348,   349,   350,   351,     0,   353,     0,     0,     0,
       0,     0,     0,     0,   361,   362,   363,     0,   364,   365,
     366,     0,   133,     0,   135,     0,     0,   368,   369,     0,
     370,     0,     0,   373,   608,   136,   374,     0,   376,   377,
     378,   379,   140,     0,     0,   382,   383,   384,     0,   386,
     387,   143,   388,     0,   390,   391,     0,     0,     0,     0,
       0,   396,   397,   398,   399,   400,   149,   150,   401,     0,
     403,     0,   405,     0,   406,   407,   408,     0,     0,     0,
     412,   413,   414,   415,     0,   417,   418,     0,   420,     0,
     422,   423,   424,   157,   425,     0,   159,     0,   427,   428,
     161,     0,   430,     0,   432,     0,     0,     0,   434,     0,
     435,     0,     0,   438,     0,   440,   441,     0,   442,   443,
     444,     0,   445,   446,   447,   448,     0,     0,   450,     0,
     451,   452,   453,     0,   170,     0,   171,     0,     0,     0,
       0,   456,     0,   457,   458,   459,   460,     0,     0,   462,
       0,     0,   464,   465,   466,   467,   468,   469,   470,   471,
     472,   473,   474,   475,   476,   477,     0,   182,     0,   479,
     480,   481,   482,   183,     0,   484,   485,     0,     0,   186,
     187,   487,     0,     0,   490,     0,     0,     0,   494,   495,
       0,     0,   498,     0,     0,     0,   499,   500,   501,   502,
     503,     0,   190,   504,   505,   506,     0,   508,   509,   510,
     511,   512,   192,   513,     0,   515,   516,   517,   518,   519,
     520,   521,   522,   523,     0,   524,   198,   525,   526,   527,
     528,   529,     0,     0,   531,   532,   533,     0,   535,   201,
     536,   537,     0,   538,   204,     0,   540,   541,   542,   543,
     544,   545,   546,   547,   206,   548,     0,   550,   551,   552,
       0,   207,   208,     0,   555,     0,   557,   209,   558,   210,
       0,   560,   561,   562,   563,     0,     0,   565,   566,   567,
     568,   569,     0,     0,   572,   573,   574,   217,   575,     0,
     576,   577,     0,     0,     0,   580,   581,   582,   583,   584,
     585,     0,   219,     0,   995,   220,     0,     0,     0,     0,
       0,     0,     0,     0,   996,   997,   998,     0,   999,  1000,
    1001,  1002,  1003,  1004,   640,    79,    80,    81,   339,     0,
      83,    84,     0,    85,    86,    87,   340,     0,   341,     0,
      91,     0,    93,    94,    95,    96,    97,    98,   641,    99,
     100,   101,   342,   642,   103,     0,   104,   105,   106,   107,
     643,   644,     0,   109,   110,   111,     0,   112,   645,   646,
     115,   343,   344,     0,     0,     0,   601,   602,     0,     0,
       0,     0,   603,     0,     0,     0,     0,     0,     0,     0,
       0,   604,     0,   605,     0,   606,   607,     0,   345,   346,
     347,   348,   349,   350,   351,     0,   353,     0,     0,     0,
       0,     0,     0,     0,   361,   362,   363,     0,   364,   365,
     366,     0,  1336,     0,  1337,  1082,     0,   368,   369,     0,
     370,     0,     0,   373,  1338,  1339,   374,     0,   376,   377,
     378,   379,     0,     0,     0,   382,   383,   384,     0,   386,
     387,     0,   388,     0,   390,   391,     0,     0,     0,     0,
       0,   396,   397,   398,   399,   400,  1340,  1341,   401,     0,
     403,     0,   405,     0,   406,   407,   408,     0,     0,     0,
     412,  1095,   414,   415,     0,   417,   418,     0,   420,     0,
     422,   423,   424,     0,   425,     0,     0,     0,   427,   428,
    1342,     0,   430,     0,   432,     0,     0,     0,   434,     0,
     435,     0,     0,   438,     0,   440,   441,     0,   442,   443,
     444,     0,   445,   446,   447,   448,     0,     0,   450,     0,
     451,   452,   453,  1100,  1343,     0,  1344,     0,     0,     0,
       0,   456,     0,   457,   458,   459,   460,     0,     0,   462,
       0,     0,   464,   465,   466,   467,   468,   469,   470,   471,
     472,   473,   474,   475,   476,  1103,     0,  1345,     0,   479,
     480,   481,   482,     0,     0,   484,   485,     0,     0,     0,
    1346,   487,     0,     0,   490,     0,     0,     0,   494,   495,
       0,     0,   498,     0,     0,     0,   499,   500,   501,   502,
     503,     0,     0,   504,   505,   506,     0,   508,   509,   510,
     511,   512,  1347,   513,     0,   515,   516,   517,   518,   519,
     520,   521,   522,   523,     0,   524,     0,   525,   526,   527,
     528,   529,     0,     0,   531,   532,   533,     0,   535,  1348,
     536,   537,     0,   538,  1349,     0,   540,   541,   542,   543,
     544,   545,   546,   547,     0,   548,     0,   550,   551,   552,
       0,  1350,  1351,     0,   555,     0,   557,     0,   558,     0,
       0,   560,   561,   562,   563,     0,     0,   565,   566,   567,
     568,   569,     0,     0,   572,   573,   574,  1352,   575,     0,
     576,   577,     0,     0,     0,   580,   581,   582,   583,   584,
     585,     0,   219,     0,     0,   220,    79,    80,    81,   339,
       0,    83,    84,     0,    85,    86,    87,   340,     0,   341,
    1686,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   342,     0,   103,     0,   104,   105,   106,
     107,     0,     0,     0,   109,   110,   111,     0,   112,     0,
       0,   115,   343,   344,     0,     0,     0,   601,   602,     0,
       0,     0,     0,   603,     0,     0,     0,     0,     0,     0,
       0,     0,   604,     0,   605,     0,   606,   607,     0,   345,
     346,   347,   348,   349,   350,   351,     0,   353,     0,     0,
       0,     0,     0,     0,     0,   361,   362,   363,     0,   364,
     365,   366,     0,   133,     0,   135,     0,     0,   368,   369,
       0,   370,     0,     0,   373,   608,   136,   374,     0,   376,
     377,   378,   379,   140,     0,     0,   382,   383,   384,     0,
     386,   387,   143,   388,     0,   390,   391,     0,     0,     0,
       0,     0,   396,   397,   398,   399,   400,   149,   150,   401,
       0,   403,     0,   405,     0,   406,   407,   408,     0,     0,
       0,   412,   413,   414,   415,     0,   417,   418,     0,   420,
       0,   422,   423,   424,   157,   425,     0,   159,     0,   427,
     428,   161,     0,   430,     0,   432,     0,     0,     0,   434,
       0,   435,     0,     0,   438,     0,   440,   441,     0,   442,
     443,   444,     0,   445,   446,   447,   448,     0,     0,   450,
       0,   451,   452,   453,     0,   170,     0,   171,     0,     0,
       0,     0,   456,     0,   457,   458,   459,   460,     0,     0,
     462,     0,     0,   464,   465,   466,   467,   468,   469,   470,
     471,   472,   473,   474,   475,   476,   477,     0,   182,   692,
     479,   480,   481,   482,   183,     0,   484,   485,     0,     0,
     186,   187,   487,     0,     0,   490,   693,     0,     0,   494,
     495,     0,     0,   498,     0,     0,     0,   499,   500,   501,
     502,   503,     0,   190,   504,   505,   506,     0,   508,   509,
     510,   511,   512,   192,   513,     0,   515,   516,   517,   518,
     519,   520,   521,   522,   523,     0,   524,   198,   525,   526,
     527,   528,   529,     0,     0,   531,   532,   533,     0,   535,
     201,   536,   537,     0,   538,   204,     0,   540,   541,   542,
     543,   544,   545,   546,   547,   206,   548,     0,   550,   551,
     552,     0,   207,   208,     0,   555,     0,   557,   209,   558,
     210,     0,   560,   561,   562,   563,     0,     0,   565,   566,
     567,   568,   569,     0,     0,   572,   573,   574,   217,   575,
       0,   576,   577,     0,     0,     0,   580,   581,   582,   583,
     584,   585,     0,   219,     0,     0,   220,    79,    80,    81,
     339,     0,    83,    84,     0,    85,    86,    87,   340,     0,
     341,   847,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,   342,     0,   103,     0,   104,   105,
     106,   107,     0,     0,     0,   109,   110,   111,     0,   112,
       0,     0,   115,   343,   344,     0,     0,     0,   601,   602,
       0,     0,     0,     0,   603,     0,     0,     0,     0,     0,
       0,     0,     0,   604,     0,   605,     0,   606,   607,     0,
     345,   346,   347,   348,   349,   350,   351,     0,   353,     0,
       0,     0,     0,     0,     0,     0,   361,   362,   363,     0,
     364,   365,   366,     0,   133,     0,   135,     0,     0,   368,
     369,     0,   370,     0,     0,   373,   608,   136,   374,     0,
     376,   377,   378,   379,   140,     0,     0,   382,   383,   384,
       0,   386,   387,   143,   388,     0,   390,   391,     0,     0,
       0,     0,     0,   396,   397,   398,   399,   400,   149,   150,
     401,     0,   403,     0,   405,     0,   406,   407,   408,     0,
       0,     0,   412,   413,   414,   415,     0,   417,   418,     0,
     420,     0,   422,   423,   424,   157,   425,     0,   159,     0,
     427,   428,   161,     0,   430,     0,   432,     0,     0,     0,
     434,     0,   435,     0,     0,   438,     0,   440,   441,     0,
     442,   443,   444,     0,   445,   446,   447,   448,     0,     0,
     450,     0,   451,   452,   453,     0,   170,     0,   171,     0,
       0,     0,     0,   456,     0,   457,   458,   459,   460,     0,
       0,   462,     0,     0,   464,   465,   466,   467,   468,   469,
     470,   471,   472,   473,   474,   475,   476,   477,     0,   182,
       0,   479,   480,   481,   482,   183,     0,   484,   485,     0,
       0,   186,   187,   487,     0,     0,   490,     0,     0,     0,
     494,   495,     0,     0,   498,     0,     0,     0,   499,   500,
     501,   502,   503,     0,   190,   504,   505,   506,     0,   508,
     509,   510,   511,   512,   192,   513,     0,   515,   516,   517,
     518,   519,   520,   521,   522,   523,     0,   524,   198,   525,
     526,   527,   528,   529,     0,     0,   531,   532,   533,     0,
     535,   201,   536,   537,     0,   538,   204,     0,   540,   541,
     542,   543,   544,   545,   546,   547,   206,   548,     0,   550,
     551,   552,     0,   207,   208,     0,   555,     0,   557,   209,
     558,   210,     0,   560,   561,   562,   563,     0,     0,   565,
     566,   567,   568,   569,     0,     0,   572,   573,   574,   217,
     575,     0,   576,   577,     0,     0,     0,   580,   581,   582,
     583,   584,   585,     0,   219,     0,     0,   220,    79,    80,
      81,   339,     0,    83,    84,     0,    85,    86,    87,   340,
       0,   341,  1321,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   342,     0,   103,     0,   104,
     105,   106,   107,     0,     0,     0,   109,   110,   111,     0,
     112,     0,     0,   115,   343,   344,     0,     0,     0,   601,
     602,     0,     0,     0,     0,   603,     0,     0,     0,     0,
       0,     0,     0,     0,   604,     0,   605,     0,   606,   607,
       0,   345,   346,   347,   348,   349,   350,   351,     0,   353,
       0,     0,     0,     0,     0,     0,     0,   361,   362,   363,
       0,   364,   365,   366,     0,   133,     0,   135,     0,     0,
     368,   369,     0,   370,     0,     0,   373,   608,   136,   374,
       0,   376,   377,   378,   379,   140,     0,     0,   382,   383,
     384,     0,   386,   387,   143,   388,     0,   390,   391,     0,
       0,     0,     0,     0,   396,   397,   398,   399,   400,   149,
     150,   401,  1602,   403,     0,   405,     0,   406,   407,   408,
       0,     0,     0,   412,   413,   414,   415,     0,   417,   418,
       0,   420,     0,   422,   423,   424,   157,   425,     0,   159,
    1603,   427,   428,   161,     0,   430,     0,   432,     0,     0,
       0,   434,     0,   435,     0,     0,   438,     0,   440,   441,
       0,   442,   443,   444,     0,   445,   446,   447,   448,     0,
       0,   450,     0,   451,   452,   453,     0,   170,     0,   171,
       0,     0,     0,     0,   456,     0,   457,   458,   459,   460,
       0,     0,   462,     0,     0,   464,   465,   466,   467,   468,
     469,   470,   471,   472,   473,   474,   475,   476,   477,     0,
     182,     0,   479,   480,   481,   482,   183,     0,   484,   485,
       0,     0,   186,   187,   487,  1604,     0,   490,     0,  1605,
       0,   494,   495,     0,     0,   498,     0,     0,     0,   499,
     500,   501,   502,   503,     0,   190,   504,   505,   506,     0,
     508,   509,   510,   511,   512,   192,   513,     0,   515,   516,
     517,   518,   519,   520,   521,   522,   523,     0,   524,   198,
     525,   526,   527,   528,   529,     0,     0,   531,   532,   533,
       0,   535,   201,   536,   537,     0,   538,   204,     0,   540,
     541,   542,   543,   544,   545,   546,   547,   206,   548,     0,
     550,   551,   552,     0,   207,   208,     0,   555,     0,   557,
     209,   558,   210,  1606,   560,   561,   562,   563,     0,     0,
     565,   566,   567,   568,   569,     0,     0,   572,   573,   574,
     217,   575,     0,   576,   577,     0,     0,     0,   580,   581,
     582,   583,   584,   585,     0,   219,    49,     0,   220,   610,
       0,     0,     0,     0,    52,     0,    53,     0,    79,    80,
      81,   339,  1242,    83,    84,     0,    85,    86,    87,   340,
       0,   341,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   342,     0,   103,     0,   104,
     105,   106,   107,     0,     0,     0,   109,   110,   111,     0,
     112,     0,     0,   115,   343,   344,     0,     0,     0,   601,
     602,     0,     0,     0,     0,   603,     0,     0,     0,     0,
       0,     0,     0,     0,   604,     0,   605,     0,   606,   607,
       0,   345,   346,   347,   348,   349,   350,   351,     0,   353,
       0,     0,     0,     0,     0,     0,     0,   361,   362,   363,
       0,   364,   365,   366,     0,   133,     0,   135,     0,     0,
     368,   369,     0,   370,     0,     0,   373,   608,   136,   374,
       0,   376,   377,   378,   379,   140,     0,     0,   382,   383,
     384,     0,   386,   387,   143,   388,     0,   390,   391,     0,
       0,     0,     0,     0,   396,   397,   398,   399,   400,   149,
     150,   401,     0,   403,     0,   405,     0,   406,   407,   408,
       0,     0,     0,   412,   413,   414,   415,     0,   417,   418,
       0,   420,     0,   422,   423,   424,   157,   425,     0,   159,
    1603,   427,   428,   161,     0,   430,     0,   432,     0,     0,
       0,   434,     0,   435,     0,     0,   438,     0,   440,   441,
       0,   442,   443,   444,     0,   445,   446,   447,   448,     0,
       0,   450,     0,   451,   452,   453,     0,   170,     0,   171,
       0,     0,     0,     0,   456,     0,   457,   458,   459,   460,
       0,     0,   462,     0,     0,   464,   465,   466,   467,   468,
     469,   470,   471,   472,   473,   474,   475,   476,   477,     0,
     182,     0,   479,   480,   481,   482,   183,     0,   484,   485,
       0,     0,   186,   187,   487,  1604,     0,   490,     0,  1605,
       0,   494,   495,     0,     0,   498,     0,     0,     0,   499,
     500,   501,   502,   503,     0,   190,   504,   505,   506,     0,
     508,   509,   510,   511,   512,   192,   513,     0,   515,   516,
     517,   518,   519,   520,   521,   522,   523,     0,   524,   198,
     525,   526,   527,   528,   529,     0,     0,   531,   532,   533,
       0,   535,   201,   536,   537,     0,   538,   204,     0,   540,
     541,   542,   543,   544,   545,   546,   547,   206,   548,     0,
     550,   551,   552,     0,   207,   208,     0,   555,     0,   557,
     209,   558,   210,  1606,   560,   561,   562,   563,     0,     0,
     565,   566,   567,   568,   569,     0,     0,   572,   573,   574,
     217,   575,     0,   576,   577,     0,     0,     0,   580,   581,
     582,   583,   584,   585,     0,   219,    49,     0,   220,   610,
       0,     0,     0,     0,    52,     0,    53,     0,    79,    80,
      81,   339,  1242,    83,    84,     0,    85,    86,    87,   340,
       0,   341,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   342,     0,   103,     0,   104,
     105,   106,   107,     0,     0,     0,   109,   110,   111,     0,
     112,     0,     0,   115,   343,   344,     0,     0,     0,   601,
     602,     0,     0,     0,     0,   603,     0,     0,     0,     0,
       0,     0,     0,     0,   604,     0,   605,     0,   606,   607,
       0,   345,   765,   347,   348,   349,   350,   351,   766,   353,
       0,     0,     0,     0,     0,     0,     0,   361,   362,   363,
       0,   767,   365,   366,     0,   133,     0,   135,     0,     0,
     368,   369,     0,   370,     0,     0,   373,   608,   136,   374,
       0,   376,   377,   378,   379,   140,     0,     0,   382,   383,
     384,     0,   386,   387,   143,   388,     0,   390,   391,     0,
       0,     0,     0,     0,   396,   397,   398,   399,   400,   149,
     150,   401,     0,   403,     0,   405,     0,   406,   407,   408,
       0,     0,     0,   412,   413,   414,   415,     0,   417,   418,
       0,   420,     0,   422,   423,   424,   157,   425,     0,   159,
       0,   427,   768,   161,     0,   430,     0,   769,     0,   770,
       0,   434,     0,   435,     0,     0,   438,     0,   440,   441,
       0,   442,   443,   444,   771,   445,   446,   447,   448,     0,
       0,   450,     0,   451,   452,   453,     0,   170,     0,   171,
       0,     0,     0,     0,   456,     0,   457,   458,   459,   772,
       0,     0,   462,     0,     0,   464,   465,   466,   467,   468,
     469,   470,   471,   472,   473,   474,   475,   476,   477,     0,
     182,     0,   773,   480,   481,   482,   183,     0,   484,   485,
       0,     0,   186,   187,   487,     0,     0,   490,     0,     0,
       0,   494,   495,     0,     0,   498,     0,     0,     0,   499,
     500,   501,   502,   503,     0,   190,   504,   505,   506,     0,
     774,   509,   510,   511,   512,   192,   513,     0,   515,   775,
     517,   518,   519,   520,   521,   522,   523,     0,   524,   198,
     525,   526,   527,   528,   529,     0,     0,   531,   532,   533,
       0,   535,   201,   536,   537,     0,   538,   204,     0,   540,
     541,   542,   543,   544,   545,   546,   547,   206,   548,     0,
     550,   551,   552,     0,   207,   208,     0,   555,     0,   557,
     209,   558,   210,     0,   560,   561,   562,   563,     0,     0,
     565,   566,   567,   568,   569,     0,     0,   572,   573,   574,
     217,   575,     0,   576,   577,     0,     0,     0,   580,   581,
     582,   583,   584,   585,     0,   219,     0,     0,   220,   610,
      79,    80,    81,   339,    52,    83,    84,     0,    85,    86,
      87,   340,   776,   341,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   342,     0,   103,
       0,   104,   105,   106,   107,     0,     0,     0,   109,   110,
     111,     0,   112,     0,     0,   115,   343,   344,     0,     0,
       0,   601,   602,     0,     0,     0,     0,   603,     0,     0,
       0,     0,     0,     0,     0,     0,   604,     0,   605,     0,
     606,   607,     0,   345,   765,   347,   348,   349,   350,   351,
     766,   353,     0,     0,     0,     0,     0,     0,     0,   361,
     362,   363,     0,   767,   365,   366,     0,   133,     0,   135,
       0,     0,   368,   369,     0,   370,     0,     0,   373,   608,
     136,   374,     0,   376,   377,   378,   379,   140,     0,     0,
     382,   383,   384,     0,   386,   387,   143,   388,     0,   390,
     391,     0,     0,     0,     0,     0,   396,   397,   398,   399,
     400,   149,   150,   401,     0,   403,     0,   405,     0,   406,
     407,   408,     0,     0,     0,   412,   413,   414,   415,     0,
     417,   418,     0,   420,     0,   422,   423,   424,   157,   425,
       0,   159,     0,   427,   768,   161,     0,   430,     0,   769,
       0,     0,     0,   434,     0,   435,     0,     0,   438,     0,
     440,   441,     0,   442,   443,   444,     0,   445,   446,   447,
     448,     0,     0,   450,     0,   451,   452,   453,     0,   170,
       0,   171,     0,     0,     0,     0,   456,     0,   457,   458,
     459,   772,     0,     0,   462,     0,     0,   464,   465,   466,
     467,   468,   469,   470,   471,   472,   473,   474,   475,   476,
     477,     0,   182,     0,   773,   480,   481,   482,   183,     0,
     484,   485,     0,     0,   186,   187,   487,     0,     0,   490,
       0,     0,     0,   494,   495,     0,     0,   498,     0,     0,
       0,   499,   500,   501,   502,   503,     0,   190,   504,   505,
     506,     0,   774,   509,   510,   511,   512,   192,   513,     0,
     515,   775,   517,   518,   519,   520,   521,   522,   523,     0,
     524,   198,   525,   526,   527,   528,   529,     0,     0,   531,
     532,   533,     0,   535,   201,   536,   537,     0,   538,   204,
       0,   540,   541,   542,   543,   544,   545,   546,   547,   206,
     548,     0,   550,   551,   552,     0,   207,   208,     0,   555,
       0,   557,   209,   558,   210,     0,   560,   561,   562,   563,
       0,     0,   565,   566,   567,   568,   569,     0,     0,   572,
     573,   574,   217,   575,     0,   576,   577,     0,     0,     0,
     580,   581,   582,   583,   584,   585,     0,   219,     0,     0,
     220,   610,    79,    80,    81,   339,    52,    83,    84,     0,
      85,    86,    87,   340,   776,   341,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   342,
       0,   103,     0,   104,   105,   106,   107,     0,     0,     0,
     109,   110,   111,     0,   112,     0,     0,   115,   343,   344,
       0,     0,     0,   601,   602,     0,     0,     0,     0,   603,
       0,     0,     0,     0,     0,     0,     0,     0,   604,     0,
     605,     0,   606,   607,     0,   345,   346,   347,   348,   349,
     350,   351,     0,   353,     0,     0,     0,     0,     0,     0,
       0,   361,   362,   363,     0,   364,   365,   366,     0,   133,
       0,   135,     0,     0,   368,   369,     0,   370,     0,     0,
     373,   608,   136,   374,     0,   376,   377,   378,   379,   140,
       0,     0,   382,   383,   384,     0,   386,   387,   143,   388,
       0,   390,   391,     0,     0,     0,     0,     0,   396,   397,
     398,   399,   400,   149,   150,   401,   631,   403,     0,   405,
       0,   406,   407,   408,     0,     0,     0,   412,   413,   414,
     415,     0,   417,   418,     0,   420,     0,   422,   423,   424,
     157,   425,     0,   159,     0,   427,   428,   161,     0,   430,
       0,   432,     0,     0,     0,   434,     0,   435,     0,     0,
     438,     0,   440,   441,     0,   442,   443,   444,     0,   445,
     446,   447,   448,     0,     0,   450,     0,   451,   452,   453,
       0,   170,     0,   171,     0,     0,     0,     0,   456,     0,
     457,   458,   459,   460,     0,     0,   462,     0,     0,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,     0,   182,     0,   479,   480,   481,   482,
     183,     0,   484,   485,     0,     0,   186,   187,   487,     0,
       0,   490,     0,     0,     0,   494,   495,     0,     0,   498,
       0,     0,     0,   499,   500,   501,   502,   503,     0,   190,
     504,   505,   506,     0,   508,   509,   510,   511,   512,   192,
     513,     0,   515,   516,   517,   518,   519,   520,   521,   522,
     523,     0,   524,   198,   525,   526,   527,   528,   529,     0,
       0,   531,   532,   533,     0,   535,   201,   536,   537,     0,
     538,   204,     0,   540,   541,   542,   543,   544,   545,   546,
     547,   206,   548,     0,   550,   551,   552,     0,   207,   208,
    1178,   555,     0,   557,   209,   558,   210,     0,   560,   561,
     562,   563,     0,     0,   565,   566,   567,   568,   569,     0,
       0,   572,   573,   574,   217,   575,     0,   576,   577,     0,
       0,     0,   580,   581,   582,   583,   584,   585,     0,   219,
      49,     0,   220,   610,    79,    80,    81,   339,     0,    83,
      84,  1179,    85,    86,    87,   340,     0,   341,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   342,     0,   103,     0,   104,   105,   106,   107,     0,
       0,     0,   109,   110,   111,     0,   112,     0,     0,   115,
     343,   344,     0,     0,     0,   601,   602,     0,     0,     0,
       0,   603,     0,     0,     0,     0,     0,     0,     0,     0,
     604,     0,   605,     0,   606,   607,     0,   345,   346,   347,
     348,   349,   350,   351,     0,   353,     0,     0,     0,     0,
       0,     0,     0,   361,   362,   363,     0,   364,   365,   366,
       0,   133,     0,   135,     0,     0,   368,   369,     0,   370,
       0,     0,   373,   608,   136,   374,     0,   376,   377,   378,
     379,   140,     0,     0,   382,   383,   384,     0,   386,   387,
     143,   388,     0,   390,   391,     0,     0,     0,     0,     0,
     396,   397,   398,   399,   400,   149,   150,   401,     0,   403,
       0,   405,     0,   406,   407,   408,     0,     0,     0,   412,
     413,   414,   415,     0,   417,   418,     0,   420,     0,   422,
     423,   424,   157,   425,     0,   159,     0,   427,   428,   161,
       0,   430,     0,   432,     0,     0,     0,   434,     0,   435,
       0,     0,   438,     0,   440,   441,     0,   442,   443,   444,
       0,   445,   446,   447,   448,     0,     0,   450,     0,   451,
     452,   453,     0,   170,     0,   171,     0,     0,     0,     0,
     456,     0,   457,   458,   459,   460,     0,     0,   462,     0,
       0,   464,   465,   466,   467,   468,   469,   470,   471,   472,
     473,   474,   475,   476,   477,     0,   182,     0,   479,   480,
     481,   482,   183,     0,   484,   485,     0,     0,   186,   187,
     487,     0,     0,   490,     0,     0,     0,   494,   495,     0,
       0,   498,     0,     0,     0,   499,   500,   501,   502,   503,
       0,   190,   504,   505,   506,     0,   508,   509,   510,   511,
     512,   192,   513,     0,   515,   516,   517,   518,   519,   520,
     521,   522,   523,     0,   524,   198,   525,   526,   527,   528,
     529,     0,     0,   531,   532,   533,     0,   535,   201,   536,
     537,     0,   538,   204,     0,   540,   541,   542,   543,   544,
     545,   546,   547,   206,   548,     0,   550,   551,   552,     0,
     207,   208,     0,   555,     0,   557,   209,   558,   210,     0,
     560,   561,   562,   563,     0,     0,   565,   566,   567,   568,
     569,     0,     0,   572,   573,   574,   217,   575,     0,   576,
     577,     0,     0,     0,   580,   581,   582,   583,   584,   585,
       0,   219,    49,     0,   220,   610,     0,     0,  1126,  1127,
      52,     0,    53,    79,    80,    81,   339,     0,    83,    84,
       0,    85,    86,    87,   340,     0,   341,     0,    91,     0,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     342,     0,   103,     0,   104,   105,   106,   107,     0,     0,
       0,   109,   110,   111,     0,   112,     0,     0,   115,   343,
     344,     0,     0,     0,   601,   602,     0,     0,     0,     0,
     603,     0,     0,     0,     0,     0,     0,     0,     0,   604,
       0,   605,     0,   606,   607,     0,   345,   346,   347,   348,
     349,   350,   351,     0,   353,     0,     0,     0,     0,     0,
       0,     0,   361,   362,   363,     0,   364,   365,   366,     0,
     133,     0,   135,     0,     0,   368,   369,     0,   370,     0,
       0,   373,   608,   136,   374,     0,   376,   377,   378,   379,
     140,     0,     0,   382,   383,   384,     0,   386,   387,   143,
     388,     0,   390,   391,     0,     0,     0,     0,     0,   396,
     397,   398,   399,   400,   149,   150,   401,     0,   403,     0,
     405,     0,   406,   407,   408,     0,     0,     0,   412,   413,
     414,   415,     0,   417,   418,     0,   420,     0,   422,   423,
     424,   157,   425,     0,   159,     0,   427,   428,   161,     0,
     430,     0,   432,     0,     0,     0,   434,     0,   435,     0,
       0,   438,     0,   440,   441,     0,   442,   443,   444,     0,
     445,   446,   447,   448,     0,     0,   450,     0,   451,   452,
     453,     0,   170,     0,   171,     0,     0,     0,     0,   456,
       0,   457,   458,   459,   460,     0,     0,   462,     0,     0,
     464,   465,   466,   467,   468,   469,   470,   471,   472,   473,
     474,   475,   476,   477,     0,   182,     0,   479,   480,   481,
     482,   183,     0,   484,   485,     0,     0,   186,   187,   487,
       0,     0,   490,     0,     0,     0,   494,   495,     0,     0,
     498,     0,     0,     0,   499,   500,   501,   502,   503,     0,
     190,   504,   505,   506,     0,   508,   509,   510,   511,   512,
     192,   513,     0,   515,   516,   517,   518,   519,   520,   521,
     522,   523,     0,   524,   198,   525,   526,   527,   528,   529,
       0,     0,   531,   532,   533,     0,   535,   201,   536,   537,
       0,   538,   204,     0,   540,   541,   542,   543,   544,   545,
     546,   547,   206,   548,     0,   550,   551,   552,     0,   207,
     208,     0,   555,     0,   557,   209,   558,   210,     0,   560,
     561,   562,   563,     0,     0,   565,   566,   567,   568,   569,
       0,     0,   572,   573,   574,   217,   575,     0,   576,   577,
       0,     0,     0,   580,   581,   582,   583,   584,   585,     0,
     219,     0,     0,   220,     0,   828,  1260,    79,    80,    81,
     339,   829,    83,    84,     0,    85,    86,    87,   340,     0,
     341,     0,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,   342,     0,   103,     0,   104,   105,
     106,   107,     0,     0,     0,   109,   110,   111,     0,   112,
       0,     0,   115,   343,   344,     0,     0,     0,   601,   602,
       0,     0,     0,     0,   603,     0,     0,     0,     0,     0,
       0,     0,     0,   604,     0,   605,     0,   606,   607,     0,
     345,   346,   347,   348,   349,   350,   351,     0,   353,     0,
       0,     0,     0,     0,     0,     0,   361,   362,   363,     0,
     364,   365,   366,     0,   133,     0,   135,     0,     0,   368,
     369,     0,   370,     0,     0,   373,   608,   136,   374,     0,
     376,   377,   378,   379,   140,     0,     0,   382,   383,   384,
       0,   830,   387,   143,   388,     0,   390,   391,     0,     0,
       0,     0,     0,   396,   397,   398,   399,   400,   149,   150,
     401,     0,   403,     0,   405,     0,   406,   407,   408,     0,
       0,     0,   412,   413,   414,   415,     0,   417,   418,     0,
     420,     0,   422,   423,   424,   157,   425,     0,   159,     0,
     427,   428,   161,     0,   430,     0,   432,     0,     0,     0,
     434,     0,   435,     0,     0,   438,     0,   440,   441,     0,
     442,   443,   444,     0,   445,   446,   447,   448,     0,     0,
     450,     0,   451,   452,   453,     0,   170,     0,   171,     0,
       0,     0,     0,   456,     0,   457,   458,   459,   460,     0,
       0,   462,     0,     0,   464,   465,   831,   467,   468,   469,
     470,   471,   472,   473,   474,   475,   832,   477,     0,   182,
       0,   479,   480,   481,   482,   183,     0,   484,   485,     0,
       0,   186,   187,   487,     0,     0,   490,     0,     0,     0,
     494,   495,     0,     0,   498,     0,     0,     0,   499,   500,
     501,   502,   503,     0,   190,   504,   505,   506,     0,   508,
     509,   510,   511,   512,   192,   513,     0,   515,   516,   517,
     518,   519,   520,   521,   522,   523,     0,   524,   198,   525,
     526,   527,   528,   529,     0,     0,   531,   532,   833,     0,
     535,   201,   536,   537,     0,   538,   204,     0,   540,   541,
     542,   543,   544,   545,   546,   547,   206,   548,     0,   550,
     551,   552,     0,   834,   208,     0,   555,     0,   835,   209,
     558,   210,     0,   560,   561,   562,   563,     0,     0,   565,
     566,   567,   568,   569,     0,     0,   572,   573,   574,   217,
     575,     0,   576,   577,     0,     0,     0,   580,   581,   582,
     583,   584,   585,     0,   219,     0,     0,   220,   640,    79,
      80,    81,   339,     0,    83,    84,     0,    85,    86,    87,
     340,     0,   341,     0,    91,     0,    93,    94,    95,    96,
      97,    98,   641,    99,   100,   101,   342,   642,   103,     0,
     104,   105,   106,   107,   643,   644,     0,   109,   110,   111,
       0,   112,   645,   646,   115,   343,   344,     0,     0,     0,
     601,   602,     0,     0,     0,     0,   603,     0,     0,     0,
       0,     0,     0,     0,     0,   604,     0,   605,     0,   606,
     607,     0,   345,   346,   347,   348,   349,   350,   351,   352,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
     363,   130,   364,   365,   366,   132,   133,   134,   135,     0,
     367,   368,   369,     0,   370,   371,   372,   373,   647,   136,
     374,   375,   376,   377,   378,   379,   140,   380,   381,   382,
     383,   384,   385,   386,   387,   143,   388,   389,   390,   391,
     146,   392,   393,   394,   395,   396,   397,   398,   399,   400,
     149,   150,   401,   402,   403,   404,   405,     0,   406,   407,
     408,   409,   410,   411,   412,   413,   414,   415,   416,   417,
     418,   419,   420,   421,   422,   423,   424,   157,   425,     0,
     159,   426,   427,   428,   161,   429,   430,   431,   432,   162,
     433,   163,   434,     0,   435,   436,   437,   438,   439,   440,
     441,   166,   442,   443,   444,   167,   445,   446,   447,   448,
     449,   168,   450,   648,   451,   452,   453,   649,   170,   454,
     171,   455,     0,   172,   173,   456,   174,   457,   458,   459,
     460,   461,   175,   462,   176,   463,   464,   465,   466,   467,
     468,   469,   470,   471,   472,   473,   474,   475,   476,   477,
     181,   182,   478,   479,   480,   481,   482,   183,   483,   484,
     485,   185,   486,   186,   187,   487,   488,   489,   490,   491,
     492,   493,   494,   495,   496,   497,   498,   188,   189,     0,
     499,   500,   501,   502,   503,     0,   190,   504,   505,   506,
     507,   508,   509,   510,   511,   512,   192,   513,   514,   515,
     516,   517,   518,   519,   520,   521,   522,   523,   196,   524,
     198,   525,   526,   527,   528,   529,     0,   530,   531,   532,
     533,   534,   535,   201,   536,   537,   203,   538,   204,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   206,   548,
     549,   550,   551,   552,   553,   207,   208,   554,   555,   556,
     557,   209,   558,   210,   559,   560,   561,   562,   563,   650,
     564,   565,   566,   567,   568,   569,   570,   571,   572,   573,
     574,   217,   575,   218,   576,   577,     0,   578,   579,   580,
     581,   582,   583,   584,   585,     0,   219,     0,     0,   220,
      79,    80,    81,   339,     0,    83,    84,   629,    85,    86,
      87,   340,     0,   341,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   342,     0,   103,
       0,   104,   105,   106,   107,     0,     0,     0,   109,   110,
     111,     0,   112,     0,     0,   115,   343,   344,     0,     0,
       0,   601,   602,     0,     0,     0,     0,   603,     0,     0,
       0,     0,     0,     0,     0,     0,   604,     0,   605,     0,
     606,   607,     0,   345,   346,   347,   348,   349,   350,   351,
     630,   353,     0,     0,     0,     0,     0,     0,     0,   361,
     362,   363,     0,   364,   365,   366,     0,   133,     0,   135,
       0,     0,   368,   369,     0,   370,     0,     0,   373,   608,
     136,   374,     0,   376,   377,   378,   379,   140,     0,     0,
     382,   383,   384,     0,   386,   387,   143,   388,     0,   390,
     391,     0,     0,     0,     0,     0,   396,   397,   398,   399,
     400,   149,   150,   401,   631,   403,     0,   405,     0,   406,
     407,   408,     0,     0,     0,   412,   413,   414,   415,     0,
     417,   418,     0,   420,     0,   422,   423,   424,   157,   425,
       0,   159,     0,   427,   428,   161,     0,   430,     0,   432,
       0,     0,     0,   434,     0,   435,     0,     0,   438,     0,
     440,   441,     0,   442,   443,   444,     0,   445,   446,   447,
     448,     0,     0,   450,     0,   451,   452,   453,     0,   170,
       0,   171,     0,     0,     0,     0,   456,     0,   457,   458,
     459,   460,     0,     0,   462,     0,     0,   464,   465,   466,
     467,   468,   469,   470,   471,   472,   473,   474,   475,   476,
     477,     0,   182,     0,   479,   480,   481,   482,   183,     0,
     484,   485,     0,     0,   186,   187,   487,     0,     0,   490,
       0,     0,     0,   494,   495,     0,     0,   498,     0,     0,
       0,   499,   500,   501,   502,   503,     0,   190,   504,   505,
     506,     0,   508,   509,   510,   511,   512,   192,   513,     0,
     515,   516,   517,   518,   519,   520,   521,   522,   523,     0,
     524,   198,   525,   526,   527,   528,   529,     0,     0,   531,
     532,   533,     0,   535,   201,   536,   537,     0,   538,   204,
       0,   540,   541,   542,   543,   544,   545,   546,   547,   206,
     548,     0,   550,   551,   552,     0,   207,   208,     0,   555,
       0,   557,   209,   558,   210,     0,   560,   561,   562,   563,
       0,     0,   565,   566,   567,   568,   569,     0,     0,   572,
     573,   574,   217,   575,     0,   576,   577,     0,     0,     0,
     580,   581,   582,   583,   584,   585,     0,   219,    49,     0,
     220,   610,    79,    80,    81,   339,     0,    83,    84,     0,
      85,    86,    87,   340,     0,   341,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   342,
       0,   103,     0,   104,   105,   106,   107,     0,     0,  1430,
     109,   110,   111,     0,   112,     0,     0,   115,   343,   344,
       0,     0,     0,   601,   602,     0,     0,     0,     0,   603,
       0,     0,     0,     0,     0,     0,     0,     0,   604,     0,
     605,     0,   606,   607,     0,   345,   346,   347,   348,   349,
     350,   351,     0,   353,     0,     0,     0,     0,     0,     0,
       0,   361,   362,   363,     0,   364,   365,   366,     0,   133,
       0,   135,     0,     0,   368,   369,     0,   370,     0,     0,
     373,   608,   136,   374,     0,   376,   377,   378,   379,   140,
       0,     0,   382,   383,   384,     0,   386,   387,   143,   388,
       0,   390,   391,     0,     0,     0,     0,     0,   396,   397,
     398,   399,   400,   149,   150,   401,     0,   403,     0,   405,
       0,   406,   407,   408,     0,     0,     0,   412,   413,   414,
     415,     0,   417,   418,     0,   420,     0,   422,   423,   424,
     157,   425,     0,   159,     0,   427,   428,   161,     0,   430,
       0,   432,     0,     0,     0,   434,     0,  1993,     0,     0,
     438,     0,   440,   441,     0,   442,   443,   444,     0,   445,
     446,   447,   448,     0,     0,   450,     0,   451,   452,   453,
       0,   170,     0,   171,     0,     0,     0,     0,   456,     0,
     457,   458,   459,   460,     0,     0,   462,     0,     0,   464,
     465,  1994,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,     0,   182,   692,   479,   480,   481,   482,
     183,     0,   484,   485,     0,     0,   186,   187,   487,     0,
       0,   490,   693,     0,     0,   494,   495,     0,     0,   498,
       0,     0,     0,   499,   500,   501,   502,   503,     0,   190,
     504,   505,   506,     0,   508,   509,   510,   511,   512,   192,
     513,     0,   515,   516,   517,   518,   519,   520,   521,   522,
     523,     0,   524,   198,   525,   526,   527,   528,   529,     0,
       0,   531,   532,   533,     0,   535,   201,   536,   537,     0,
     538,   204,     0,   540,   541,   542,   543,   544,   545,   546,
     547,   206,   548,  1995,  1996,   551,  1997,     0,   207,   208,
       0,   555,     0,   557,   209,   558,   210,     0,   560,   561,
     562,   563,     0,     0,   565,   566,   567,   568,   569,     0,
       0,   572,   573,   574,   217,   575,     0,   576,   577,     0,
       0,     0,   580,   581,   582,   583,   584,   585,     0,   219,
       0,     0,   220,   610,    79,    80,    81,   339,     0,    83,
      84,     0,    85,    86,    87,   340,     0,   341,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   342,     0,   103,     0,   104,   105,   106,   107,     0,
       0,     0,   109,   110,   111,     0,   112,     0,     0,   115,
     343,   344,     0,     0,     0,   601,   602,     0,     0,     0,
       0,   603,     0,     0,     0,     0,     0,     0,     0,     0,
     604,     0,   605,     0,   606,   607,     0,   345,   346,   347,
     348,   349,   350,   351,     0,   353,     0,     0,     0,     0,
       0,     0,     0,   361,   362,   363,     0,   364,   365,   366,
       0,   133,     0,   135,     0,     0,   368,   369,     0,   370,
       0,     0,   373,   608,   136,   374,     0,   376,   377,   378,
     379,   140,     0,     0,   382,   383,   384,     0,   386,   387,
     143,   388,     0,   390,   391,     0,     0,     0,     0,     0,
     396,   397,   398,   399,   400,   149,   150,   401,     0,   403,
       0,   405,     0,   406,   407,   408,     0,     0,     0,   412,
     413,   414,   415,     0,   417,   418,     0,   420,     0,   422,
     423,   424,   157,   425,     0,   159,     0,   427,   428,   161,
       0,   430,     0,   432,     0,     0,     0,   434,     0,   435,
       0,     0,   438,     0,   440,   441,     0,   442,   443,   444,
       0,   445,   446,   447,   448,     0,     0,   450,     0,   451,
     452,   453,     0,   170,     0,   171,     0,     0,     0,     0,
     456,     0,   457,   458,   459,   460,     0,     0,   462,     0,
       0,   464,   465,   466,   467,   468,   469,   470,   471,   472,
     473,   474,   475,   476,   477,     0,   182,     0,   479,   480,
     481,   482,   183,     0,   484,   485,     0,     0,   186,   187,
     487,     0,     0,   490,     0,     0,     0,   494,   495,     0,
       0,   498,     0,     0,     0,   499,   500,   501,   502,   503,
       0,   190,   504,   505,   506,     0,   508,   509,   510,   511,
     512,   192,   513,     0,   515,   516,   517,   518,   519,   520,
     521,   522,   523,     0,   524,   198,   525,   526,   527,   528,
     529,     0,     0,   531,   532,   533,     0,   535,   201,   536,
     537,     0,   538,   204,     0,   540,   541,   542,   543,   544,
     545,   546,   547,   206,   548,     0,   550,   551,   552,     0,
     207,   208,   609,   555,     0,   557,   209,   558,   210,     0,
     560,   561,   562,   563,     0,     0,   565,   566,   567,   568,
     569,     0,     0,   572,   573,   574,   217,   575,     0,   576,
     577,     0,     0,     0,   580,   581,   582,   583,   584,   585,
       0,   219,    49,     0,   220,   610,    79,    80,    81,   339,
       0,    83,    84,     0,    85,    86,    87,   340,     0,   341,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   342,     0,   103,     0,   104,   105,   106,
     107,     0,     0,     0,   109,   110,   111,     0,   112,     0,
       0,   115,   343,   344,     0,     0,     0,   601,   602,     0,
       0,     0,     0,   603,     0,     0,     0,     0,     0,     0,
       0,     0,   604,     0,   605,     0,   606,   607,     0,   345,
     346,   347,   348,   349,   350,   351,     0,   353,     0,     0,
       0,     0,     0,     0,     0,   361,   362,   363,     0,   364,
     365,   366,     0,   133,     0,   135,     0,     0,   368,   369,
       0,   370,     0,     0,   373,   608,   136,   374,     0,   376,
     377,   378,   379,   140,     0,     0,   382,   383,   384,     0,
     386,   387,   143,   388,     0,   390,   391,     0,     0,     0,
       0,     0,   396,   397,   398,   399,   400,   149,   150,   401,
     901,   403,     0,   405,     0,   406,   407,   408,     0,     0,
       0,   412,   413,   414,   415,     0,   417,   418,     0,   420,
       0,   422,   423,   424,   157,   425,     0,   159,     0,   427,
     428,   161,     0,   430,     0,   432,     0,     0,     0,   434,
       0,   435,     0,     0,   438,     0,   440,   441,     0,   442,
     443,   444,     0,   445,   446,   447,   448,     0,     0,   450,
       0,   451,   452,   453,     0,   170,     0,   171,     0,     0,
       0,     0,   456,     0,   457,   458,   459,   460,     0,     0,
     462,     0,     0,   464,   465,   466,   467,   468,   469,   470,
     471,   472,   473,   474,   475,   476,   477,     0,   182,     0,
     479,   480,   481,   482,   183,     0,   484,   485,     0,     0,
     186,   187,   487,     0,     0,   490,     0,     0,     0,   494,
     495,     0,     0,   498,     0,     0,     0,   499,   500,   501,
     502,   503,     0,   190,   504,   505,   506,     0,   508,   509,
     510,   511,   512,   192,   513,     0,   515,   516,   517,   518,
     519,   520,   521,   522,   523,     0,   524,   198,   525,   526,
     527,   528,   529,     0,     0,   531,   532,   533,     0,   535,
     201,   536,   537,     0,   538,   204,     0,   540,   541,   542,
     543,   544,   545,   546,   547,   206,   548,     0,   550,   551,
     552,     0,   207,   208,     0,   555,     0,   557,   209,   558,
     210,     0,   560,   561,   562,   563,     0,     0,   565,   566,
     567,   568,   569,     0,     0,   572,   573,   574,   217,   575,
       0,   576,   577,     0,     0,     0,   580,   581,   582,   583,
     584,   585,     0,   219,    49,     0,   220,   610,    79,    80,
      81,   339,     0,    83,    84,     0,    85,    86,    87,   340,
       0,   341,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   342,     0,   103,     0,   104,
     105,   106,   107,     0,     0,     0,   109,   110,   111,     0,
     112,     0,     0,   115,   343,   344,     0,     0,     0,   601,
     602,     0,     0,     0,     0,   603,     0,     0,     0,     0,
       0,     0,     0,     0,   604,     0,   605,     0,   606,   607,
       0,   345,   346,   347,   348,   349,   350,   351,     0,   353,
       0,     0,     0,     0,     0,     0,     0,   361,   362,   363,
       0,   364,   365,   366,     0,   133,     0,   135,     0,     0,
     368,   369,     0,   370,     0,     0,   373,   608,   136,   374,
       0,   376,   377,   378,   379,   140,     0,     0,   382,   383,
     384,     0,   386,   387,   143,   388,     0,   390,   391,     0,
       0,     0,     0,     0,   396,   397,   398,   399,   400,   149,
     150,   401,   631,   403,     0,   405,     0,   406,   407,   408,
       0,     0,     0,   412,   413,   414,   415,     0,   417,   418,
       0,   420,     0,   422,   423,   424,   157,   425,     0,   159,
       0,   427,   428,   161,     0,   430,     0,   432,     0,     0,
       0,   434,     0,   435,     0,     0,   438,     0,   440,   441,
       0,   442,   443,   444,     0,   445,   446,   447,   448,     0,
       0,   450,     0,   451,   452,   453,     0,   170,     0,   171,
       0,     0,     0,     0,   456,     0,   457,   458,   459,   460,
       0,     0,   462,     0,     0,   464,   465,   466,   467,   468,
     469,   470,   471,   472,   473,   474,   475,   476,   477,     0,
     182,     0,   479,   480,   481,   482,   183,     0,   484,   485,
       0,     0,   186,   187,   487,     0,     0,   490,     0,     0,
       0,   494,   495,     0,     0,   498,     0,     0,     0,   499,
     500,   501,   502,   503,     0,   190,   504,   505,   506,     0,
     508,   509,   510,   511,   512,   192,   513,     0,   515,   516,
     517,   518,   519,   520,   521,   522,   523,     0,   524,   198,
     525,   526,   527,   528,   529,     0,     0,   531,   532,   533,
       0,   535,   201,   536,   537,     0,   538,   204,     0,   540,
     541,   542,   543,   544,   545,   546,   547,   206,   548,     0,
     550,   551,   552,     0,   207,   208,     0,   555,     0,   557,
     209,   558,   210,     0,   560,   561,   562,   563,     0,     0,
     565,   566,   567,   568,   569,     0,     0,   572,   573,   574,
     217,   575,     0,   576,   577,     0,     0,     0,   580,   581,
     582,   583,   584,   585,     0,   219,    49,     0,   220,   610,
      79,    80,    81,   339,     0,    83,    84,     0,    85,    86,
      87,   340,     0,   341,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   342,     0,   103,
       0,   104,   105,   106,   107,     0,     0,     0,   109,   110,
     111,     0,   112,     0,     0,   115,   343,   344,     0,     0,
       0,   601,   602,     0,     0,     0,     0,   603,     0,     0,
       0,     0,     0,     0,     0,     0,   604,     0,   605,     0,
     606,   607,     0,   345,   346,   347,   348,   349,   350,   351,
       0,   353,     0,     0,     0,     0,     0,     0,     0,   361,
     362,   363,     0,   364,   365,   366,     0,   133,     0,   135,
       0,     0,   368,   369,     0,   370,     0,     0,   373,   608,
     136,   374,     0,   376,   377,   378,   379,   140,     0,     0,
     382,   383,   384,     0,   386,   387,   143,   388,     0,   390,
     391,     0,     0,     0,     0,     0,   396,   397,   398,   399,
     400,   149,   150,   401,  1587,   403,     0,   405,     0,   406,
     407,   408,     0,     0,     0,   412,   413,   414,   415,     0,
     417,   418,     0,   420,     0,   422,   423,   424,   157,   425,
       0,   159,     0,   427,   428,   161,     0,   430,     0,   432,
       0,     0,     0,   434,     0,   435,     0,     0,   438,     0,
     440,   441,     0,   442,   443,   444,     0,   445,   446,   447,
     448,     0,     0,   450,     0,   451,   452,   453,     0,   170,
       0,   171,     0,     0,     0,     0,   456,     0,   457,   458,
     459,   460,     0,     0,   462,     0,     0,   464,   465,   466,
     467,   468,   469,   470,   471,   472,   473,   474,   475,   476,
     477,     0,   182,     0,   479,   480,   481,   482,   183,     0,
     484,   485,     0,     0,   186,   187,   487,     0,     0,   490,
       0,     0,     0,   494,   495,     0,     0,   498,     0,     0,
       0,   499,   500,   501,   502,   503,     0,   190,   504,   505,
     506,     0,   508,   509,   510,   511,   512,   192,   513,     0,
     515,   516,   517,   518,   519,   520,   521,   522,   523,     0,
     524,   198,   525,   526,   527,   528,   529,     0,     0,   531,
     532,   533,     0,   535,   201,   536,   537,     0,   538,   204,
       0,   540,   541,   542,   543,   544,   545,   546,   547,   206,
     548,     0,   550,   551,   552,     0,   207,   208,     0,   555,
       0,   557,   209,   558,   210,     0,   560,   561,   562,   563,
       0,     0,   565,   566,   567,   568,   569,     0,     0,   572,
     573,   574,   217,   575,     0,   576,   577,     0,     0,     0,
     580,   581,   582,   583,   584,   585,     0,   219,    49,     0,
     220,   610,    79,    80,    81,   339,     0,    83,    84,     0,
      85,    86,    87,   340,     0,   341,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   342,
       0,   103,     0,   104,   105,   106,   107,     0,     0,     0,
     109,   110,   111,     0,   112,     0,     0,   115,   343,   344,
       0,     0,     0,   601,   602,     0,     0,     0,     0,   603,
       0,     0,     0,     0,     0,     0,     0,     0,   604,     0,
     605,     0,   606,   607,     0,   345,   346,   347,   348,   349,
     350,   351,     0,   353,     0,     0,     0,     0,     0,     0,
       0,   361,   362,   363,     0,   364,   365,   366,     0,   133,
       0,   135,     0,     0,   368,   369,     0,   370,     0,     0,
     373,   608,   136,   374,     0,   376,   377,   378,   379,   140,
       0,     0,   382,   383,   384,     0,   386,   387,   143,   388,
       0,   390,   391,     0,     0,     0,     0,     0,   396,   397,
     398,   399,   400,   149,   150,   401,     0,   403,     0,   405,
       0,   406,   407,   408,     0,     0,     0,   412,   413,   414,
     415,     0,   417,   418,     0,   420,     0,   422,   423,   424,
     157,   425,     0,   159,     0,   427,   428,   161,     0,   430,
       0,   432,     0,     0,     0,   434,     0,   435,     0,     0,
     438,     0,   440,   441,     0,   442,   443,   444,     0,   445,
     446,   447,   448,     0,     0,   450,     0,   451,   452,   453,
       0,   170,     0,   171,     0,     0,     0,     0,   456,     0,
     457,   458,   459,   460,     0,     0,   462,     0,     0,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,     0,   182,     0,   479,   480,   481,   482,
     183,     0,   484,   485,     0,     0,   186,   187,   487,     0,
       0,   490,     0,     0,     0,   494,   495,     0,     0,   498,
       0,     0,     0,   499,   500,   501,   502,   503,     0,   190,
     504,   505,   506,     0,   508,   509,   510,   511,   512,   192,
     513,     0,   515,   516,   517,   518,   519,   520,   521,   522,
     523,     0,   524,   198,   525,   526,   527,   528,   529,     0,
       0,   531,   532,   533,     0,   535,   201,   536,   537,     0,
     538,   204,     0,   540,   541,   542,   543,   544,   545,   546,
     547,   206,   548,     0,   550,   551,   552,     0,   207,   208,
       0,   555,     0,   557,   209,   558,   210,     0,   560,   561,
     562,   563,     0,     0,   565,   566,   567,   568,   569,     0,
       0,   572,   573,   574,   217,   575,     0,   576,   577,     0,
       0,     0,   580,   581,   582,   583,   584,   585,     0,   219,
      49,     0,   220,   610,    79,    80,    81,   339,     0,    83,
      84,     0,    85,    86,    87,   340,   730,   341,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   342,     0,   103,     0,   104,   105,   106,   107,     0,
       0,     0,   109,   110,   111,     0,   112,     0,     0,   115,
     343,   344,     0,     0,     0,   601,   602,     0,     0,     0,
       0,   603,     0,     0,     0,     0,     0,     0,     0,     0,
     604,     0,   605,     0,   606,   607,     0,   345,   346,   347,
     348,   349,   350,   351,     0,   353,     0,     0,     0,     0,
       0,     0,     0,   361,   362,   363,     0,   364,   365,   366,
       0,   133,     0,   135,     0,     0,   368,   369,     0,   370,
       0,     0,   373,   608,   136,   374,     0,   376,   377,   378,
     379,   140,     0,     0,   382,   383,   384,     0,   386,   387,
     143,   388,     0,   390,   391,     0,     0,     0,     0,     0,
     396,   397,   398,   399,   400,   149,   150,   401,     0,   403,
       0,   405,     0,   406,   407,   408,     0,     0,     0,   412,
     413,   414,   415,     0,   417,   418,     0,   420,     0,   422,
     423,   424,   157,   425,     0,   159,     0,   427,   428,   161,
       0,   430,     0,   432,     0,     0,     0,   434,     0,   435,
       0,     0,   438,     0,   440,   441,     0,   442,   443,   444,
       0,   445,   446,   447,   448,     0,     0,   450,     0,   451,
     452,   453,     0,   170,     0,   171,     0,     0,     0,     0,
     456,     0,   457,   458,   459,   460,     0,     0,   462,     0,
       0,   464,   465,   466,   467,   468,   469,   470,   471,   472,
     473,   474,   475,   476,   477,     0,   182,     0,   479,   480,
     481,   482,   183,     0,   484,   485,     0,     0,   186,   187,
     487,     0,     0,   490,     0,     0,     0,   494,   495,     0,
       0,   498,     0,     0,     0,   499,   500,   501,   502,   503,
       0,   190,   504,   505,   731,     0,   508,   509,   510,   511,
     512,   192,   513,     0,   515,   516,   517,   518,   519,   520,
     521,   522,   523,     0,   524,   198,   525,   526,   527,   528,
     529,     0,     0,   531,   532,   533,     0,   535,   201,   536,
     537,     0,   538,   204,     0,   540,   541,   542,   543,   544,
     545,   546,   547,   206,   548,     0,   550,   551,   552,     0,
     207,   208,     0,   555,     0,   557,   209,   558,   210,     0,
     560,   561,   562,   563,     0,     0,   565,   566,   567,   568,
     569,     0,     0,   572,   573,   574,   217,   575,     0,   576,
     577,     0,     0,     0,   580,   581,   582,   583,   584,   585,
       0,   219,     0,     0,   220,   610,    79,    80,    81,   339,
       0,    83,    84,     0,    85,    86,    87,   340,     0,   341,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   342,     0,   103,     0,   104,   105,   106,
     107,     0,     0,     0,   109,   110,   111,     0,   112,     0,
       0,   115,   343,   344,     0,     0,     0,   601,   602,     0,
       0,     0,     0,   603,     0,     0,     0,     0,     0,     0,
       0,     0,   604,     0,   605,     0,   606,   607,     0,   345,
     346,   347,   348,   349,   350,   351,     0,   353,     0,     0,
       0,     0,     0,     0,     0,   361,   362,   363,     0,   364,
     365,   366,     0,   133,     0,   135,     0,     0,   368,   369,
       0,   370,     0,     0,   373,   608,   136,   374,     0,   376,
     377,   378,   379,   140,     0,     0,   382,   383,   384,     0,
     386,   387,   143,   388,     0,   390,   391,     0,     0,     0,
       0,     0,   396,   397,   398,   399,   400,   149,   150,   401,
       0,   403,     0,   405,     0,   406,   407,   408,     0,     0,
       0,   412,   413,   414,   415,     0,   417,   418,     0,   420,
       0,   422,   423,   424,   157,   425,     0,   159,     0,   427,
     428,   161,     0,   430,     0,   432,     0,     0,     0,   434,
       0,   435,     0,     0,   438,     0,   440,   441,     0,   761,
     443,   444,     0,   445,   446,   447,   448,     0,     0,   450,
       0,   451,   452,   453,     0,   170,     0,   171,     0,     0,
       0,     0,   456,     0,   457,   458,   459,   460,     0,     0,
     462,     0,     0,   464,   465,   466,   467,   468,   469,   470,
     471,   472,   473,   474,   475,   476,   477,     0,   182,     0,
     479,   480,   481,   482,   183,     0,   484,   485,     0,     0,
     186,   187,   487,     0,     0,   490,     0,     0,     0,   494,
     495,     0,     0,   498,     0,     0,     0,   499,   500,   501,
     502,   503,     0,   190,   504,   505,   506,     0,   508,   509,
     510,   511,   512,   192,   513,     0,   515,   516,   517,   518,
     519,   520,   521,   522,   523,     0,   524,   198,   525,   526,
     527,   528,   529,     0,     0,   531,   532,   533,     0,   535,
     201,   536,   537,     0,   538,   204,     0,   540,   541,   542,
     543,   544,   545,   546,   547,   206,   548,     0,   550,   551,
     552,     0,   207,   208,     0,   555,     0,   557,   209,   558,
     210,     0,   560,   561,   562,   563,     0,     0,   565,   566,
     567,   568,   569,     0,     0,   572,   573,   574,   217,   575,
       0,   576,   577,     0,     0,     0,   580,   581,   582,   583,
     584,   585,     0,   219,     0,     0,   220,   610,    79,    80,
      81,   339,     0,    83,    84,     0,    85,    86,    87,   340,
       0,   341,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   342,     0,   103,     0,   104,
     105,   106,   107,     0,     0,     0,   109,   110,   111,     0,
     112,     0,     0,   115,   343,   344,     0,     0,     0,   601,
     602,     0,     0,     0,     0,   603,     0,     0,     0,     0,
       0,     0,     0,     0,   604,     0,   605,     0,   606,   607,
       0,   345,   346,   347,   348,   349,   350,   351,     0,   353,
       0,     0,     0,     0,     0,     0,     0,   361,   362,   363,
       0,   364,   365,   366,     0,   133,     0,   135,     0,     0,
     368,   369,     0,   370,     0,     0,   373,   608,   136,   374,
       0,   376,   377,   378,   379,   140,     0,     0,   382,   383,
     384,     0,   386,   387,   143,   388,     0,   390,   391,     0,
       0,     0,     0,     0,   396,   397,   398,   399,   400,   149,
     150,   401,     0,   403,     0,   405,     0,   406,   407,   408,
       0,     0,     0,   412,   413,   414,   415,     0,   417,   418,
       0,   420,     0,   422,   423,   424,   157,   425,     0,   159,
       0,   427,   428,   161,     0,   430,     0,   432,     0,     0,
       0,   434,     0,   435,     0,     0,   438,     0,   440,   441,
       0,   442,   443,   444,     0,   445,   446,   447,   448,     0,
       0,   450,     0,   451,   452,   453,     0,   170,     0,   171,
       0,     0,     0,     0,   456,     0,   457,   458,   459,   460,
       0,     0,   462,     0,     0,   464,   465,   466,   467,   468,
     469,   470,   471,   472,   473,   474,   475,   476,   477,     0,
     182,     0,   479,   480,   481,   482,   183,     0,   484,   485,
       0,     0,   186,   187,   487,     0,     0,   490,     0,     0,
       0,   494,   495,     0,     0,   498,     0,     0,     0,   499,
     500,   501,   502,   503,     0,   190,   504,   505,   506,     0,
     508,   509,   510,   511,   512,   192,   513,     0,   515,   516,
     517,   518,   519,   520,   521,   522,   523,     0,   524,   198,
     525,   526,   527,   528,   529,     0,     0,   531,   532,   533,
       0,   535,   201,   536,   537,     0,   538,   204,     0,   540,
     541,   542,   543,   544,   545,   546,   547,   206,   548,     0,
     550,   551,   552,     0,   207,   208,     0,   555,     0,   557,
     209,   558,   210,     0,   560,   561,   562,   563,     0,     0,
     565,   566,   567,   568,   569,     0,     0,   572,   573,   574,
     217,   575,     0,   576,   577,     0,     0,     0,   580,   581,
     582,   583,   584,   585,     0,   219,     0,     0,   220,   610,
     640,    79,    80,    81,   339,     0,    83,    84,     0,    85,
      86,    87,   340,     0,   341,     0,    91,     0,    93,    94,
      95,    96,    97,    98,   641,    99,   100,   101,   342,   642,
     103,     0,   104,   105,   106,   107,   643,   644,     0,   109,
     110,   111,     0,   112,   645,   646,   115,   343,   344,     0,
       0,     0,   601,   602,     0,     0,     0,     0,   603,     0,
       0,     0,     0,     0,     0,     0,     0,   604,     0,   605,
       0,   606,   607,     0,   345,   346,   347,   348,   349,   350,
     351,     0,   353,     0,     0,     0,     0,     0,     0,     0,
     361,   362,   363,     0,   364,   365,   366,     0,  1336,     0,
    1337,  1082,     0,   368,   369,     0,   370,     0,     0,   373,
    1338,  1339,   374,     0,   376,   377,   378,   379,     0,     0,
       0,   382,   383,   384,     0,   386,   387,     0,   388,     0,
     390,   391,     0,     0,     0,     0,     0,   396,   397,   398,
     399,   400,  1340,  1341,   401,     0,   403,     0,   405,     0,
     406,   407,   408,     0,     0,     0,   412,  1095,   414,   415,
       0,   417,   418,     0,   420,     0,   422,   423,   424,     0,
     425,     0,     0,     0,   427,   428,  1342,     0,   430,     0,
     432,     0,     0,     0,   434,     0,   435,     0,     0,   438,
       0,   440,   441,     0,   442,   443,   444,     0,   445,   446,
     447,   448,     0,     0,   450,     0,   451,   452,   453,  1100,
    1343,     0,  1344,     0,     0,     0,     0,   456,     0,   457,
     458,   459,   460,     0,     0,   462,     0,     0,   464,   465,
     466,   467,   468,   469,   470,   471,   472,   473,   474,   475,
     476,  1103,     0,  1345,     0,   479,   480,   481,   482,  1829,
       0,   484,   485,     0,     0,     0,  1346,   487,     0,     0,
     490,     0,     0,     0,   494,   495,     0,     0,   498,     0,
       0,     0,   499,   500,   501,   502,   503,     0,     0,   504,
     505,   506,     0,   508,   509,   510,   511,   512,  1347,   513,
       0,   515,   516,   517,   518,   519,   520,   521,   522,   523,
       0,   524,     0,   525,   526,   527,   528,   529,     0,     0,
     531,   532,   533,     0,   535,  1348,   536,   537,     0,   538,
    1349,     0,   540,   541,   542,   543,   544,   545,   546,   547,
       0,   548,     0,   550,   551,   552,     0,  1350,  1351,     0,
     555,     0,   557,     0,   558,     0,     0,   560,   561,   562,
     563,     0,     0,   565,   566,   567,   568,   569,     0,     0,
     572,   573,   574,  1352,   575,     0,   576,   577,     0,     0,
       0,   580,   581,   582,   583,   584,   585,     0,   219,     0,
       0,   220,   640,    79,    80,    81,   339,     0,    83,    84,
       0,    85,    86,    87,   340,     0,   341,     0,    91,     0,
      93,    94,    95,    96,    97,    98,   641,    99,   100,   101,
     342,   642,   103,     0,   104,   105,   106,   107,   643,   644,
       0,   109,   110,   111,     0,   112,   645,   646,   115,   343,
     344,     0,     0,     0,   601,   602,     0,     0,     0,     0,
     603,     0,     0,     0,     0,     0,     0,     0,     0,   604,
       0,   605,     0,   606,   607,     0,   345,   346,   347,   348,
     349,   350,   351,     0,   353,     0,     0,     0,     0,     0,
       0,     0,   361,   362,   363,     0,   364,   365,   366,     0,
    1336,     0,  1337,  1082,     0,   368,   369,     0,   370,     0,
       0,   373,  1338,  1339,   374,     0,   376,   377,   378,   379,
       0,     0,     0,   382,   383,   384,     0,   386,   387,     0,
     388,     0,   390,   391,     0,     0,     0,     0,     0,   396,
     397,   398,   399,   400,  1340,  1341,   401,     0,   403,     0,
     405,     0,   406,   407,   408,     0,     0,     0,   412,  1095,
     414,   415,     0,   417,   418,     0,   420,     0,   422,   423,
     424,     0,   425,     0,     0,     0,   427,   428,  1342,     0,
     430,     0,   432,     0,     0,     0,   434,     0,   435,     0,
       0,   438,     0,   440,   441,     0,   442,   443,   444,  1705,
     445,   446,   447,   448,     0,     0,  1706,     0,   451,   452,
     453,  1100,  1343,     0,  1344,     0,     0,     0,     0,   456,
       0,   457,   458,   459,   460,     0,     0,   462,     0,     0,
     464,   465,   466,   467,   468,   469,   470,   471,   472,   473,
     474,   475,   476,  1103,     0,  1345,     0,   479,   480,   481,
     482,     0,     0,   484,   485,     0,     0,     0,  1346,   487,
       0,     0,   490,     0,     0,     0,   494,   495,     0,     0,
    1707,     0,     0,     0,   499,   500,   501,   502,   503,     0,
       0,   504,   505,   506,     0,   508,   509,   510,   511,   512,
    1347,   513,     0,   515,   516,   517,   518,   519,   520,   521,
     522,   523,     0,   524,     0,   525,   526,   527,   528,   529,
       0,     0,   531,   532,   533,     0,   535,  1348,   536,   537,
       0,   538,  1349,     0,   540,   541,   542,   543,   544,   545,
     546,   547,     0,   548,     0,   550,   551,   552,     0,  1350,
    1351,     0,   555,     0,   557,     0,   558,     0,     0,   560,
     561,   562,   563,     0,     0,   565,   566,   567,   568,   569,
       0,     0,   572,   573,   574,  1352,   575,     0,   576,   577,
       0,     0,     0,   580,   581,   582,   583,   584,   585,     0,
     219,     0,     0,   220,   640,    79,    80,    81,   339,     0,
      83,    84,     0,    85,    86,    87,   340,     0,   341,     0,
      91,     0,    93,    94,    95,    96,    97,    98,   641,    99,
     100,   101,   342,   642,   103,     0,   104,   105,   106,   107,
     643,   644,     0,   109,   110,   111,     0,   112,   645,   646,
     115,   343,   344,     0,     0,     0,   601,   602,     0,     0,
       0,     0,   603,     0,     0,     0,     0,     0,     0,     0,
       0,   604,     0,   605,     0,   606,   607,     0,   345,   346,
     347,   348,   349,   350,   351,     0,   353,     0,     0,     0,
       0,     0,     0,     0,   361,   362,   363,     0,   364,   365,
     366,     0,  1336,     0,  1337,  1082,     0,   368,   369,     0,
     370,     0,     0,   373,  1338,  1339,   374,     0,   376,   377,
     378,   379,     0,     0,     0,   382,   383,   384,     0,   386,
     387,     0,   388,     0,   390,   391,     0,     0,     0,     0,
       0,   396,   397,   398,   399,   400,  1340,  1341,   401,     0,
     403,     0,   405,     0,   406,   407,   408,     0,     0,     0,
     412,  1095,   414,   415,     0,   417,   418,     0,   420,     0,
     422,   423,   424,     0,   425,     0,     0,     0,   427,   428,
    1342,     0,   430,     0,   432,     0,     0,     0,   434,     0,
     435,     0,     0,   438,     0,   440,   441,     0,   442,   443,
     444,     0,   445,   446,   447,   448,     0,     0,   450,     0,
     451,   452,   453,  1100,  1343,     0,  1344,     0,     0,     0,
       0,   456,     0,   457,   458,   459,   460,     0,     0,   462,
       0,     0,   464,   465,   466,   467,   468,   469,   470,   471,
     472,   473,   474,   475,   476,  1103,     0,  1345,     0,   479,
     480,   481,   482,  2487,     0,   484,   485,     0,     0,     0,
    1346,   487,     0,     0,   490,     0,     0,     0,   494,   495,
       0,     0,   498,     0,     0,     0,   499,   500,   501,   502,
     503,     0,     0,   504,   505,   506,     0,   508,   509,   510,
     511,   512,  1347,   513,     0,   515,   516,   517,   518,   519,
     520,   521,   522,   523,     0,   524,     0,   525,   526,   527,
     528,   529,     0,     0,   531,   532,   533,     0,   535,  1348,
     536,   537,     0,   538,  1349,     0,   540,   541,   542,   543,
     544,   545,   546,   547,     0,   548,     0,   550,   551,   552,
       0,  1350,  1351,     0,   555,     0,   557,     0,   558,     0,
       0,   560,   561,   562,   563,     0,     0,   565,   566,   567,
     568,   569,     0,     0,   572,   573,   574,  1352,   575,     0,
     576,   577,     0,     0,     0,   580,   581,   582,   583,   584,
     585,     0,   219,     0,     0,   220,   640,    79,    80,    81,
     339,     0,    83,    84,     0,    85,    86,    87,   340,     0,
     341,     0,    91,     0,    93,    94,    95,    96,    97,    98,
     641,    99,   100,   101,   342,   642,   103,     0,   104,   105,
     106,   107,   643,   644,     0,   109,   110,   111,     0,   112,
     645,   646,   115,   343,   344,     0,     0,     0,   601,   602,
       0,     0,     0,     0,   603,     0,     0,     0,     0,     0,
       0,     0,     0,   604,     0,   605,     0,   606,   607,     0,
     345,   346,   347,   348,   349,   350,   351,     0,   353,     0,
       0,     0,     0,     0,     0,     0,   361,   362,   363,     0,
     364,   365,   366,     0,  1336,     0,  1337,  1082,     0,   368,
     369,     0,   370,     0,     0,   373,  1338,  1339,   374,     0,
     376,   377,   378,   379,     0,     0,     0,   382,   383,   384,
       0,   386,   387,     0,   388,     0,   390,   391,     0,     0,
       0,     0,     0,   396,   397,   398,   399,   400,  1340,  1341,
     401,     0,   403,     0,   405,     0,   406,   407,   408,     0,
       0,     0,   412,  1095,   414,   415,     0,   417,   418,     0,
     420,     0,   422,   423,   424,     0,   425,     0,     0,     0,
     427,   428,  1342,     0,   430,     0,   432,     0,     0,     0,
     434,     0,   435,     0,     0,   438,     0,   440,   441,     0,
     442,   443,   444,     0,   445,   446,   447,   448,     0,     0,
     450,     0,   451,   452,   453,  1100,  1343,     0,  1344,     0,
       0,     0,     0,   456,     0,   457,   458,   459,   460,     0,
       0,   462,     0,     0,   464,   465,   466,   467,   468,   469,
     470,   471,   472,   473,   474,   475,   476,  1103,     0,  1345,
       0,   479,   480,   481,   482,     0,     0,   484,   485,     0,
       0,     0,  1346,   487,     0,     0,   490,     0,     0,     0,
     494,   495,     0,     0,   498,     0,     0,     0,   499,   500,
     501,   502,   503,     0,     0,   504,   505,   506,     0,   508,
     509,   510,   511,   512,  1347,   513,     0,   515,   516,   517,
     518,   519,   520,   521,   522,   523,     0,   524,     0,   525,
     526,   527,   528,   529,     0,     0,   531,   532,   533,     0,
     535,  1348,   536,   537,     0,   538,  1349,     0,   540,   541,
     542,   543,   544,   545,   546,   547,     0,   548,     0,   550,
     551,   552,     0,  1350,  1351,     0,   555,     0,   557,     0,
     558,     0,     0,   560,   561,   562,   563,     0,     0,   565,
     566,   567,   568,   569,     0,     0,   572,   573,   574,  1352,
     575,     0,   576,   577,     0,     0,     0,   580,   581,   582,
     583,   584,   585,     0,   219,     0,     0,   220,   640,    79,
      80,    81,   339,     0,    83,    84,     0,    85,    86,    87,
     340,     0,   341,     0,    91,     0,    93,    94,    95,    96,
      97,    98,   641,    99,   100,   101,   342,   642,   103,     0,
     104,   105,   106,   107,   643,   644,     0,   109,   110,   111,
       0,   112,   645,   646,   115,   343,   344,     0,     0,     0,
     601,   602,     0,     0,     0,     0,   603,     0,     0,     0,
       0,     0,     0,     0,     0,   604,     0,   605,     0,   606,
     607,     0,   345,   346,   347,   348,   349,   350,   351,     0,
     353,     0,     0,     0,     0,     0,     0,     0,   361,   362,
     363,     0,   364,   365,   366,     0,  1336,     0,  1337,  1082,
       0,   368,   369,     0,   370,     0,     0,   373,  1338,  1339,
     374,     0,   376,   377,   378,   379,     0,     0,     0,   382,
     383,   384,     0,   386,   387,     0,   388,     0,   390,   391,
       0,     0,     0,     0,     0,   396,   397,   398,   399,   400,
    1340,  1341,   401,     0,   403,     0,   405,     0,   406,   407,
     408,     0,     0,     0,   412,  1095,   414,   415,     0,   417,
     418,     0,   420,     0,   422,   423,   424,     0,   425,     0,
       0,     0,   427,   428,  1342,     0,   430,     0,   432,     0,
       0,     0,   434,     0,   435,     0,     0,   438,     0,   440,
     441,     0,   442,   443,   444,     0,   445,   446,   447,   448,
       0,     0,   450,     0,   451,   452,   453,  1100,  1343,     0,
    1344,     0,     0,     0,     0,   456,     0,   457,   458,   459,
     460,     0,     0,   462,     0,     0,   464,   465,   466,   467,
     468,   469,   470,   471,   472,   473,   474,   475,   476,  1103,
       0,  1345,     0,   479,   480,   481,   482,     0,     0,   484,
     485,     0,     0,     0,  1346,   487,     0,     0,   490,     0,
       0,     0,   494,   495,     0,     0,   498,     0,     0,     0,
     499,   500,   501,   502,   503,     0,     0,   504,   505,   506,
       0,   508,   509,   510,   511,   512,  1347,   513,     0,   515,
     516,   517,   518,   519,   520,   521,   522,   523,     0,   524,
       0,   525,   526,   527,   528,   529,     0,     0,   531,   532,
     533,     0,   535,     0,   536,   537,     0,   538,  1349,     0,
     540,   541,   542,   543,   544,   545,   546,   547,     0,   548,
       0,   550,   551,   552,     0,  1350,  1351,     0,   555,     0,
     557,     0,   558,     0,     0,   560,   561,   562,   563,     0,
       0,   565,   566,   567,   568,   569,     0,     0,   572,   573,
     574,  1352,   575,     0,   576,   577,     0,     0,     0,   580,
     581,   582,   583,   584,   585,     0,   219,     0,     0,   220,
      79,    80,    81,   339,     0,    83,    84,     0,    85,    86,
      87,   340,     0,   341,    90,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   342,     0,   103,
       0,   104,   105,   106,   107,     0,   108,     0,   109,   110,
     111, -1232,   112,   113,   114,   115,   343,   344,     0,     0,
       0,   118,   119,     0,     0,     0,     0,   120,     0,     0,
       0,     0,     0,     0,     0,     0,   121,     0,   122,     0,
     123,   124,     0,   345,   346,   347,   348,   349,   350,   351,
     352,   353,   354,   355,   356,   357,   358,   359,   360,   361,
     362,   363,   130,   364,   365,   366,   132,   133,   134,   135,
       0,   367,   368,   369,     0,   370,   371,   372,   373,     0,
     136,   374,   375,   376,   377,   378,   379,   140,   380,   381,
     382,   383,   384,   385,   386,   387,   143,   388,   389,   390,
     391,   146,   392,   393,   394,   395,   396,   397,   398,   399,
     400,   149,   150,   401,   402,   403,   404,   405,     0,   406,
     407,   408,   409,   410,   411,   412,   413,   414,   415,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   157,   425,
       0,   159,   426,   427,   428,   161,   429,   430,   431,   432,
     162,   433,   163,   434,     0,   435,   436,   437,   438,   439,
     440,   441,   166,   442,   443,   444,   167,   445,   446,   447,
     448,   449,   168,   450,     0,   451,   452,   453,     0,   170,
     454,   171,   455,     0,   172,   173,   456,   174,   457,   458,
     459,   460,   461,   175,   462,   176,   463,   464,   465,   466,
     467,   468,   469,   470,   471,   472,   473,   474,   475,   476,
     477,   181,   182,   478,   479,   480,   481,   482,   183,   483,
     484,   485,   185,   486,   186,   187,   487,   488,   489,   490,
     491,   492,   493,   494,   495,   496,   497,   498,   188,   189,
       0,   499,   500,   501,   502,   503,     0,   190,   504,   505,
     506,   507,   508,   509,   510,   511,   512,   192,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   196,
     524,   198,   525,   526,   527,   528,   529,     0,   530,   531,
     532,   533,   534,   535,   201,   536,   537,   203,   538,   204,
     539,   540,   541,   542,   543,   544,   545,   546,   547,   206,
     548,   549,   550,   551,   552,   553,   207,   208,   554,   555,
     556,   557,   209,   558,   210,   559,   560,   561,   562,   563,
     213,   564,   565,   566,   567,   568,   569,   570,   571,   572,
     573,   574,   217,   575,   218,   576,   577,     0,   578,   579,
     580,   581,   582,   583,   584,   585,     0,   219,     0,     0,
     220,    79,    80,    81,   339,     0,    83,    84,     0,    85,
      86,    87,   340,     0,   341,    90,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   342,     0,
     103,     0,   104,   105,   106,   107,     0,   108,     0,   109,
     110,   111, -1233,   112,   113,   114,   115,   343,   344,     0,
       0,     0,   118,   119,     0,     0,     0,     0,   120,     0,
       0,     0,     0,     0,     0,     0,     0,   121,     0,   122,
       0,   123,   124,     0,   345,   346,   347,   348,   349,   350,
     351,   352,   353,   354,   355,   356,   357,   358,   359,   360,
     361,   362,   363,   130,   364,   365,   366,   132,   133,   134,
     135,     0,   367,   368,   369,     0,   370,   371,   372,   373,
       0,   136,   374,   375,   376,   377,   378,   379,   140,   380,
     381,   382,   383,   384,   385,   386,   387,   143,   388,   389,
     390,   391,   146,   392,   393,   394,   395,   396,   397,   398,
     399,   400,   149,   150,   401,   402,   403,   404,   405,     0,
     406,   407,   408,   409,   410,   411,   412,   413,   414,   415,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   157,
     425,     0,   159,   426,   427,   428,   161,   429,   430,   431,
     432,   162,   433,   163,   434,     0,   435,   436,   437,   438,
     439,   440,   441,   166,   442,   443,   444,   167,   445,   446,
     447,   448,   449,   168,   450,     0,   451,   452,   453,     0,
     170,   454,   171,   455,     0,   172,   173,   456,   174,   457,
     458,   459,   460,   461,   175,   462,   176,   463,   464,   465,
     466,   467,   468,   469,   470,   471,   472,   473,   474,   475,
     476,   477,   181,   182,   478,   479,   480,   481,   482,   183,
     483,   484,   485,   185,   486,   186,   187,   487,   488,   489,
     490,   491,   492,   493,   494,   495,   496,   497,   498,   188,
     189,     0,   499,   500,   501,   502,   503,     0,   190,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   192,   513,
     514,   515,   516,   517,   518,   519,   520,   521,   522,   523,
     196,   524,   198,   525,   526,   527,   528,   529,     0,   530,
     531,   532,   533,   534,   535,   201,   536,   537,   203,   538,
     204,   539,   540,   541,   542,   543,   544,   545,   546,   547,
     206,   548,   549,   550,   551,   552,   553,   207,   208,   554,
     555,   556,   557,   209,   558,   210,   559,   560,   561,   562,
     563,   213,   564,   565,   566,   567,   568,   569,   570,   571,
     572,   573,   574,   217,   575,   218,   576,   577,     0,   578,
     579,   580,   581,   582,   583,   584,   585,     0,   219,     0,
       0,   220,    79,    80,    81,   339,     0,    83,    84,     0,
      85,    86,    87,   340,     0,   341,    90,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   342,
       0,   103,     0,   104,   105,   106,   107,     0,   108,     0,
     109,   110,   111,     0,   112,   113,   114,   115,   343,   344,
       0,     0,     0,   118,   119,     0,     0,     0,     0,   120,
       0,     0,     0,     0,     0,     0,     0,     0,   121,     0,
     122,     0,   123,     0,     0,   345,   346,   347,   348,   349,
     350,   351,   352,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,   130,   364,   365,   366,   132,   133,
     134,   135,     0,   367,   368,   369,     0,   370,   371,   372,
     373,     0,   136,   374,   375,   376,   377,   378,   379,   140,
     380,   381,   382,   383,   384,   385,   386,   387,   143,   388,
     389,   390,   391,   146,   392,   393,   394,   395,   396,   397,
     398,   399,   400,   149,   150,   401,   402,   403,   404,   405,
       0,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     157,   425,     0,   159,   426,   427,   428,   161,   429,   430,
     431,   432,   162,   433,   163,   434,     0,   435,   436,   437,
     438,   439,   440,   441,   166,   442,   443,   444,   167,   445,
     446,   447,   448,   449,   168,   450,     0,   451,   452,   453,
       0,   170,   454,   171,   455,     0,   172,   173,   456,   174,
     457,   458,   459,   460,   461,   175,   462,   176,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   181,   182,   478,   479,   480,   481,   482,
     183,   483,   484,   485,   185,   486,   186,   187,   487,   488,
     489,   490,   491,   492,   493,   494,   495,   496,   497,   498,
     188,   189,     0,   499,   500,   501,   502,   503,     0,   190,
     504,   505,   506,   507,   508,   509,   510,   511,   512,   192,
     513,   514,   515,   516,   517,   518,   519,   520,   521,   522,
     523,   196,   524,   198,   525,   526,   527,   528,   529,     0,
     530,   531,   532,   533,   534,   535,   201,   536,   537,   203,
     538,   204,   539,   540,   541,   542,   543,   544,   545,   546,
     547,   206,   548,   549,   550,   551,   552,   553,   207,   208,
     554,   555,   556,   557,   209,   558,   210,   559,   560,   561,
     562,   563,   213,   564,   565,   566,   567,   568,   569,   570,
     571,   572,   573,   574,   217,   575,   218,   576,   577,     0,
     578,   579,   580,   581,   582,   583,   584,   585,     0,   219,
       0,     0,   220,    79,    80,    81,   339,     0,    83,    84,
       0,    85,    86,    87,   340,     0,   341,    90,    91,     0,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     342,     0,   103,     0,   104,   105,   106,   107,     0,   108,
       0,   109,   110,   111,     0,   112,   113,   114,   115,   343,
     344,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   345,   346,   347,   348,
     349,   350,   351,   352,   353,   354,   355,   356,   357,   358,
     359,   360,   361,   362,   363,   130,   364,   365,   366,   132,
     133,   134,   135,     0,   367,   368,   369,     0,   370,   371,
     372,   373,     0,   136,   374,   375,   376,   377,   378,   379,
     140,   380,   381,   382,   383,   384,   385,   386,   387,   143,
     388,   389,   390,   391,   146,   392,   393,   394,   395,   396,
     397,   398,   399,   400,   149,   150,   401,   402,   403,   404,
     405,     0,   406,   407,   408,   409,   410,   411,   412,   413,
     414,   415,   416,   417,   418,   419,   420,   421,   422,   423,
     424,   157,   425,     0,   159,   426,   427,   428,   161,   429,
     430,   431,   432,   162,   433,   163,   434,     0,   435,   436,
     437,   438,   439,   440,   441,   166,   442,   443,   444,   167,
     445,   446,   447,   448,   449,   168,   450,     0,   451,   452,
     453,     0,   170,   454,   171,   455,     0,   172,   173,   456,
     174,   457,   458,   459,   460,   461,   175,   462,   176,   463,
     464,   465,   466,   467,   468,   469,   470,   471,   472,   473,
     474,   475,   476,   477,   181,   182,   478,   479,   480,   481,
     482,   183,   483,   484,   485,   185,   486,   186,   187,   487,
     488,   489,   490,   491,   492,   493,   494,   495,   496,   497,
     498,   188,   189,     0,   499,   500,   501,   502,   503,     0,
     190,   504,   505,   506,   507,   508,   509,   510,   511,   512,
     192,   513,   514,   515,   516,   517,   518,   519,   520,   521,
     522,   523,   196,   524,   198,   525,   526,   527,   528,   529,
       0,   530,   531,   532,   533,   534,   535,   201,   536,   537,
     203,   538,   204,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   206,   548,   549,   550,   551,   552,   553,   207,
     208,   554,   555,   556,   557,   209,   558,   210,   559,   560,
     561,   562,   563,   213,   564,   565,   566,   567,   568,   569,
     570,   571,   572,   573,   574,   217,   575,   218,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   585,     0,
     219,     0,     0,   220,    79,    80,    81,   339,     0,    83,
      84,     0,    85,    86,    87,   340,     0,   341,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   342,     0,   103,     0,   104,   105,   106,   107,     0,
       0,     0,   109,   110,   111,     0,   112,     0,     0,   115,
     343,   344,     0,     0,     0,   601,   602,     0,     0,     0,
       0,   603,     0,     0,     0,     0,     0,     0,     0,     0,
     604,     0,   605,     0,   606,   607,     0,   345,   346,   347,
     348,   349,   350,   351,     0,   353,     0,     0,     0,     0,
       0,     0,     0,   361,   362,   363,   130,   364,   365,   366,
     132,   133,   134,   135,     0,     0,   368,   369,     0,   370,
       0,     0,   373,   608,   136,   374,     0,   376,   377,   378,
     379,   140,     0,     0,   382,   383,   384,     0,   386,   387,
     143,   388,     0,   390,   391,   146,     0,     0,     0,     0,
     396,   397,   398,   399,   400,   149,   150,   401,     0,   403,
       0,   405,     0,   406,   407,   408,     0,     0,     0,   412,
     413,   414,   415,     0,   417,   418,     0,   420,     0,   422,
     423,   424,   157,   425,     0,   159,     0,   427,   428,   161,
       0,   430,     0,   432,   162,     0,   163,   434,     0,   435,
       0,     0,   438,     0,   440,   441,   166,   442,   443,   444,
     167,   445,   446,   447,   448,     0,   168,   450,     0,   451,
     452,   453,     0,   170,     0,   171,     0,     0,   172,   173,
     456,   174,   457,   458,   459,   460,     0,   175,   462,   176,
       0,   464,   465,   466,   467,   468,   469,   470,   471,   472,
     473,   474,   475,   476,   477,   181,   182,   692,   479,   480,
     481,   482,   183,     0,   484,   485,   185,     0,   186,   187,
     487,     0,     0,   490,   693,     0,     0,   494,   495,     0,
       0,   498,   188,   189,     0,   499,   500,   501,   502,   503,
       0,   190,   504,   505,   506,     0,   508,   509,   510,   511,
     512,   192,   513,     0,   515,   516,   517,   518,   519,   520,
     521,   522,   523,   196,   524,   198,   525,   526,   527,   528,
     529,     0,     0,   531,   532,   533,     0,   535,   201,   536,
     537,   203,   538,   204,     0,   540,   541,   542,   543,   544,
     545,   546,   547,   206,   548,     0,   550,   551,   552,     0,
     207,   208,     0,   555,     0,   557,   209,   558,   210,     0,
     560,   561,   562,   563,     0,     0,   565,   566,   567,   568,
     569,     0,     0,   572,   573,   574,   217,   575,   218,   576,
     577,     0,     0,     0,   580,   581,   582,   583,   584,   585,
       0,   219,     0,     0,   220,    79,    80,    81,   339,     0,
      83,    84,     0,    85,    86,    87,   340,     0,   341,     0,
      91,     0,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   342,     0,   103,     0,   104,   105,   106,   107,
       0,     0,     0,   109,   110,   111,     0,   112,     0,     0,
     115,   343,   344,     0,     0,     0,   601,   602,     0,     0,
       0,     0,   603,     0,     0,     0,     0,     0,     0,     0,
       0,   604,     0,   605,     0,   606,   607,     0,   345,   346,
     347,   348,   349,   350,   351,     0,   353,     0,     0,     0,
       0,     0,     0,     0,   361,   362,   363,     0,   364,   365,
     366,     0,   133,     0,   135,     0,     0,   368,   369,     0,
     370,     0,     0,   373,   608,   136,   374,  1692,   376,   377,
     378,   379,   140,     0,     0,   382,   383,   384,  1693,   386,
     387,   143,   388,     0,   390,   391,     0,     0,     0,     0,
       0,   396,   397,   398,   399,   400,   149,   150,   401,     0,
     403,     0,   405,     0,   406,   407,   408,     0,     0,     0,
     412,   413,   414,   415,     0,   417,   418,     0,   420,     0,
     422,   423,   424,   157,   425,     0,   159,     0,   427,   428,
     161,     0,   430,  1694,   432,     0,     0,     0,   434,     0,
     435,     0,     0,   438,     0,   440,   441,     0,   442,   443,
     444,     0,   445,   446,   447,   448,     0,     0,   450,     0,
     451,   452,   453,     0,   170,     0,   171,     0,     0,     0,
       0,   456,     0,   457,   458,   459,   460,     0,     0,   462,
    2160,     0,   464,   465,   466,   467,   468,   469,   470,   471,
     472,   473,   474,   475,   476,   477,     0,   182,     0,   479,
     480,   481,   482,   183,     0,   484,   485,     0,     0,   186,
     187,   487,     0,     0,   490,     0,     0,     0,   494,   495,
       0,     0,   498,     0,     0,     0,   499,   500,   501,   502,
     503,     0,   190,   504,   505,   506,  1695,   508,   509,   510,
     511,   512,   192,   513,     0,   515,   516,   517,   518,   519,
     520,   521,   522,   523,     0,   524,   198,   525,   526,   527,
     528,   529,     0,     0,   531,   532,   533,     0,   535,   201,
     536,   537,     0,   538,   204,     0,   540,   541,   542,   543,
     544,   545,   546,   547,   206,   548,     0,   550,   551,   552,
       0,   207,   208,     0,   555,     0,   557,   209,   558,   210,
       0,   560,   561,   562,   563,     0,  1696,   565,   566,   567,
     568,   569,     0,     0,   572,   573,   574,   217,   575,     0,
     576,   577,     0,     0,     0,   580,   581,   582,   583,   584,
     585,     0,   219,     0,     0,   220,    79,    80,    81,   339,
       0,    83,    84,     0,    85,    86,    87,   340,     0,   341,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   342,     0,   103,     0,   104,   105,   106,
     107,     0,     0,     0,   109,   110,   111,     0,   112,     0,
       0,   115,   343,   344,     0,     0,     0,   601,   602,     0,
       0,     0,     0,   603,     0,     0,     0,     0,     0,     0,
       0,     0,   604,     0,   605,     0,   606,   607,     0,   345,
     346,   347,   348,   349,   350,   351,     0,   353,   127,   128,
       0,     0,     0,     0,     0,   361,   362,   363,     0,   364,
     365,   366,     0,   133,     0,   135,     0,     0,   368,   369,
       0,   370,     0,     0,   373,   608,   136,   374,     0,   376,
     377,   378,   379,   140,     0,     0,   382,   383,   384,     0,
     386,   387,   143,   388,     0,   390,   391,     0,     0,     0,
       0,     0,   396,   397,   398,   399,   400,   149,   150,   401,
       0,   403,     0,   405,     0,   406,   407,   408,     0,     0,
       0,   412,   413,   414,   415,     0,   417,   418,     0,   420,
       0,   422,   423,   424,   157,   425,     0,   159,     0,   427,
     428,   161,     0,   430,     0,   432,     0,     0,     0,   434,
       0,   435,     0,     0,   438,     0,   440,   441,     0,   442,
     443,   444,     0,   445,   446,   447,   448,     0,     0,   450,
       0,   451,   452,   453,     0,   170,     0,   171,     0,     0,
       0,     0,   456,     0,   457,   458,   459,   460,     0,     0,
     462,     0,     0,   464,   465,   466,   467,   468,   469,   470,
     471,   472,   473,   474,   475,   476,   477,     0,   182,   692,
     479,   480,   481,   482,   183,     0,   484,   485,     0,     0,
     186,   187,   487,     0,     0,   490,   693,     0,     0,   494,
     495,     0,     0,   498,     0,     0,     0,   499,   500,   501,
     502,   503,     0,   190,   504,   505,   506,     0,   508,   509,
     510,   511,   512,   192,   513,     0,   515,   516,   517,   518,
     519,   520,   521,   522,   523,     0,   524,   198,   525,   526,
     527,   528,   529,     0,     0,   531,   532,   533,     0,   535,
     201,   536,   537,     0,   538,   204,     0,   540,   541,   542,
     543,   544,   545,   546,   547,   206,   548,     0,   550,   551,
     552,     0,   207,   208,     0,   555,     0,   557,   209,   558,
     210,     0,   560,   561,   562,   563,     0,     0,   565,   566,
     567,   568,   569,     0,     0,   572,   573,   574,   217,   575,
       0,   576,   577,     0,     0,     0,   580,   581,   582,   583,
     584,   585,     0,   219,     0,     0,   220,    79,    80,    81,
     339,     0,    83,    84,     0,    85,    86,    87,   340,     0,
     341,     0,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,   342,     0,   103,     0,   104,   105,
     106,   107,     0,     0,     0,   109,   110,   111,     0,   112,
       0,     0,   115,   343,   344,     0,     0,     0,   601,   602,
       0,     0,     0,     0,   603,     0,     0,     0,     0,     0,
       0,     0,     0,   604,     0,   605,     0,   606,   607,     0,
     345,   346,   347,   348,   349,   350,   351,     0,   353,     0,
       0,     0,     0,     0,     0,     0,   361,   362,   363,     0,
     364,   365,   366,     0,   133,     0,   135,     0,     0,   368,
     369,     0,   370,     0,     0,   373,   608,   136,   374,     0,
     376,   377,   378,   379,   140,     0,     0,   382,   383,   384,
       0,   386,   387,   143,   388,     0,   390,   391,     0,     0,
       0,     0,     0,   396,   397,   398,   399,   400,   149,   150,
     401,     0,   403,     0,   405,     0,   406,   407,   408,     0,
       0,     0,   412,   413,   414,   415,     0,   417,   418,     0,
     420,     0,   422,   423,   424,   157,   425,     0,   159,     0,
     427,   428,   161,     0,   430,     0,   432,     0,     0,     0,
     434,     0,   435,     0,     0,   438,     0,   440,   441,     0,
     442,   443,   444,     0,   445,   446,   447,   448,     0,     0,
     450,     0,   451,   452,   453,     0,   170,     0,   171,     0,
       0,     0,     0,   456,     0,   457,   458,   459,   460,     0,
       0,   462,     0,     0,   464,   465,   466,   467,   468,   469,
     470,   471,   472,   473,   474,   475,   476,   477,     0,   182,
     692,   479,   480,   481,   482,   183,     0,   484,   485,     0,
       0,   186,   187,   487,     0,     0,   490,   693,     0,   849,
     494,   495,     0,     0,   498,     0,     0,     0,   499,   500,
     501,   502,   503,     0,   190,   504,   505,   506,     0,   508,
     509,   510,   511,   512,   192,   513,     0,   515,   516,   517,
     518,   519,   520,   521,   522,   523,     0,   524,   198,   525,
     526,   527,   528,   529,     0,     0,   531,   532,   533,     0,
     535,   201,   536,   537,     0,   538,   204,     0,   540,   541,
     542,   543,   544,   545,   546,   547,   206,   548,     0,   550,
     551,   552,     0,   207,   208,     0,   555,     0,   557,   209,
     558,   210,     0,   560,   561,   562,   563,     0,     0,   565,
     566,   567,   568,   569,     0,     0,   572,   573,   574,   217,
     575,     0,   576,   577,     0,     0,     0,   580,   581,   582,
     583,   584,   585,     0,   219,     0,     0,   220,    79,    80,
      81,   339,     0,    83,    84,     0,    85,    86,    87,   340,
       0,   341,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   342,     0,   103,     0,   104,
     105,   106,   107,     0,     0,     0,   109,   110,   111,     0,
     112,     0,     0,   115,   343,   344,     0,     0,     0,   601,
     602,     0,     0,     0,     0,   603,     0,     0,     0,     0,
       0,     0,     0,     0,   604,     0,   605,     0,   606,   607,
       0,   345,   346,   347,   348,   349,   350,   351,     0,   353,
       0,     0,     0,     0,     0,     0,     0,   361,   362,   363,
       0,   364,   365,   366,     0,   133,     0,   135,     0,     0,
     368,   369,     0,   370,     0,     0,   373,   608,   136,   374,
       0,   376,   377,   378,   379,   140,     0,     0,   382,   383,
     384,     0,   386,   387,   143,   388,     0,   390,   391,     0,
       0,     0,     0,     0,   396,   397,  1440,   399,   400,   149,
     150,   401,     0,   403,     0,   405,     0,   406,   407,   408,
       0,     0,     0,   412,   413,   414,   415,     0,   417,   418,
       0,   420,     0,   422,   423,   424,   157,   425,     0,   159,
       0,   427,   428,   161,     0,   430,     0,   432,     0,     0,
       0,  1441,     0,   435,     0,     0,   438,     0,   440,   441,
       0,   442,   443,   444,     0,   445,   446,   447,   448,     0,
       0,   450,     0,   451,   452,   453,     0,   170,     0,   171,
       0,     0,     0,     0,   456,     0,   457,   458,  1442,   460,
       0,     0,   462,     0,     0,   464,   465,   466,   467,   468,
     469,   470,   471,   472,   473,   474,   475,   476,   477,     0,
     182,   692,   479,   480,   481,   482,   183,     0,   484,   485,
       0,     0,   186,   187,   487,     0,     0,   490,   693,     0,
       0,   494,   495,     0,     0,   498,     0,     0,     0,   499,
     500,   501,   502,   503,     0,   190,   504,   505,   506,     0,
     508,   509,   510,   511,   512,   192,   513,     0,   515,   516,
     517,   518,   519,   520,   521,   522,   523,     0,   524,   198,
     525,   526,  1443,   528,   529,     0,     0,   531,   532,   533,
       0,   535,   201,   536,   537,     0,   538,   204,     0,   540,
     541,   542,   543,   544,   545,   546,   547,   206,   548,  1444,
     550,   551,   552,     0,   207,   208,     0,   555,     0,   557,
     209,   558,   210,     0,   560,   561,   562,   563,     0,     0,
     565,   566,   567,   568,   569,     0,     0,   572,   573,   574,
     217,   575,     0,   576,   577,     0,     0,     0,   580,   581,
     582,   583,   584,   585,     0,   219,     0,     0,   220,    79,
      80,    81,   339,     0,    83,    84,     0,    85,    86,    87,
     340,     0,   341,     0,    91,     0,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   342,     0,   103,     0,
     104,   105,   106,   107,     0,     0,     0,   109,   110,   111,
       0,   112,     0,     0,   115,   343,   344,     0,     0,     0,
     601,   602,     0,     0,     0,     0,   603,     0,     0,     0,
       0,     0,     0,     0,     0,   604,     0,   605,     0,   606,
     607,     0,   345,   346,   347,   348,   349,   350,   351,     0,
     353,     0,     0,     0,     0,     0,     0,     0,   361,   362,
     363,     0,   364,   365,   366,     0,   133,     0,   135,     0,
       0,   368,   369,     0,   370,     0,     0,   373,   608,   136,
     374,     0,   376,   377,   378,   379,   140,     0,     0,   382,
     383,   384,     0,   386,   387,   143,   388,     0,   390,   391,
       0,     0,     0,     0,     0,   396,   397,   398,   399,   400,
     149,   150,   401,     0,   403,     0,   405,     0,   406,   407,
     408,     0,     0,     0,   412,   413,   414,   415,     0,   417,
     418,     0,   420,     0,   422,   423,   424,   157,   425,     0,
     159,     0,   427,   428,   161,     0,   430,     0,   432,     0,
       0,     0,   434,     0,   435,     0,     0,   438,     0,   440,
     441,     0,   442,   443,   444,     0,   445,   446,   447,   448,
       0,     0,   450,     0,   451,   452,   453,     0,   170,     0,
     171,     0,     0,     0,     0,   456,     0,   457,   458,   459,
     460,     0,     0,   462,     0,     0,   464,   465,   466,   467,
     468,   469,   470,   471,   472,   473,   474,   475,   476,   477,
       0,   182,   692,   479,   480,   481,   482,   183,     0,   484,
     485,     0,     0,   186,   187,   487,     0,     0,   490,   693,
       0,     0,   494,   495,     0,     0,   498,     0,     0,     0,
     499,   500,   501,   502,   503,     0,   190,   504,   505,   506,
       0,   508,   509,   510,   511,   512,   192,   513,     0,   515,
     516,   517,   518,   519,   520,   521,   522,   523,     0,   524,
     198,   525,   526,   527,   528,   529,     0,     0,   531,   532,
     533,     0,   535,   201,   536,   537,     0,   538,   204,     0,
     540,   541,   542,   543,   544,   545,   546,   547,   206,   548,
       0,   550,   551,   552,     0,   207,   208,     0,   555,     0,
     557,   209,   558,   210,     0,   560,   561,   562,   563,     0,
       0,   565,   566,   567,   568,   569,     0,  2890,   572,   573,
     574,   217,   575,     0,   576,   577,     0,     0,     0,   580,
     581,   582,   583,   584,   585,     0,   219,     0,     0,   220,
      79,    80,    81,   339,     0,    83,    84,     0,    85,    86,
      87,   340,     0,   341,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   342,     0,   103,
       0,   104,   105,   106,   107,     0,     0,     0,   109,   110,
     111,     0,   112,     0,     0,   115,   343,   344,     0,     0,
       0,   601,   602,     0,     0,     0,     0,   603,     0,     0,
       0,     0,     0,     0,     0,     0,   604,     0,   605,     0,
     606,   607,     0,   345,   346,   347,   348,   349,   350,   351,
       0,   353,     0,     0,     0,     0,     0,     0,     0,   361,
     362,   363,     0,   364,   365,   366,     0,   133,     0,   135,
       0,     0,   368,   369,     0,   370,     0,     0,   373,   608,
     136,   374,     0,   376,   377,   378,   379,   140,     0,     0,
     382,   383,   384,     0,   386,   387,   143,   388,     0,   390,
     391,     0,     0,     0,     0,     0,   396,   397,   398,   399,
     400,   149,   150,   401,     0,   403,     0,   405,     0,   406,
     407,   408,     0,     0,     0,   412,   413,   414,   415,     0,
     417,   418,     0,   420,     0,   422,   423,   424,   157,   425,
       0,   159,     0,   427,   428,   161,     0,   430,     0,   432,
       0,     0,     0,   434,     0,   435,     0,     0,   438,     0,
     440,   441,     0,   442,   443,   444,     0,   445,   446,   447,
     448,     0,     0,   450,     0,   451,   452,   453,     0,   170,
       0,   171,     0,     0,     0,     0,   456,     0,   457,   458,
     459,   460,     0,     0,   462,     0,     0,   464,   465,   466,
     467,   468,   469,   470,   471,   472,   473,   474,   475,   476,
     477,     0,   182,   692,   479,   480,   481,   482,   183,     0,
     484,   485,     0,     0,   186,   187,   487,     0,     0,   490,
     693,     0,     0,   494,   495,     0,     0,   498,     0,     0,
       0,   499,   500,   501,   502,   503,     0,   190,   504,   505,
     506,     0,   508,   509,   510,   511,   512,   192,   513,     0,
     515,   516,   517,   518,   519,   520,   521,   522,   523,     0,
     524,   198,   525,   526,   527,   528,   529,     0,     0,   531,
     532,   533,     0,   535,   201,   536,   537,     0,   538,   204,
       0,   540,   541,   542,   543,   544,   545,   546,   547,   206,
     548,     0,   550,   551,   552,     0,   207,   208,     0,   555,
       0,   557,   209,   558,   210,     0,   560,   561,   562,   563,
       0,     0,   565,   566,   567,   568,   569,     0,     0,   572,
     573,   574,   217,   575,     0,   576,   577,     0,     0,     0,
     580,   581,   582,   583,   584,   585,     0,   219,     0,     0,
     220,    79,    80,    81,   339,     0,    83,    84,     0,    85,
      86,    87,   340,     0,   341,     0,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   342,     0,
     103,     0,   104,   105,   106,   107,     0,     0,     0,   109,
     110,   111,     0,   112,     0,     0,   115,   343,   344,     0,
       0,     0,   601,   602,     0,     0,     0,     0,   603,     0,
       0,     0,     0,     0,     0,     0,     0,   604,     0,   605,
       0,   606,   607,     0,   345,   346,   347,   348,   349,   350,
     351,     0,   353,     0,     0,     0,     0,     0,     0,     0,
     361,   362,   363,     0,   364,   365,   366,     0,   133,     0,
     135,     0,     0,   368,   369,     0,   370,     0,     0,   373,
     608,   136,   374,     0,   376,   377,   378,   379,   140,     0,
       0,   382,   383,   384,     0,   386,   387,   143,   388,     0,
     390,   391,     0,     0,     0,     0,     0,   396,   397,   398,
     399,   400,   149,   150,   401,     0,   403,     0,   405,     0,
     406,   407,   408,     0,     0,     0,   412,   413,   414,   415,
       0,   417,   418,     0,   420,     0,   422,   423,   424,   157,
     425,     0,   159,     0,   427,   428,   161,     0,   430,     0,
     432,     0,   770,     0,   434,     0,   435,     0,     0,   438,
       0,   440,   441,     0,   442,   443,   444,   771,   445,   446,
     447,   448,     0,     0,   450,     0,   451,   452,   453,     0,
     170,     0,   171,     0,     0,     0,     0,   456,     0,   457,
     458,   459,   460,     0,     0,   462,     0,     0,   464,   465,
     466,   467,   468,   469,   470,   471,   472,   473,   474,   475,
     476,   477,     0,   182,     0,   479,   480,   481,   482,   183,
       0,   484,   485,     0,     0,   186,   187,   487,     0,     0,
     490,     0,     0,     0,   494,   495,     0,     0,   498,     0,
       0,     0,   499,   500,   501,   502,   503,     0,   190,   504,
     505,   506,     0,   508,   509,   510,   511,   512,   192,   513,
       0,   515,   516,   517,   518,   519,   520,   521,   522,   523,
       0,   524,   198,   525,   526,   527,   528,   529,     0,     0,
     531,   532,   533,     0,   535,   201,   536,   537,     0,   538,
     204,     0,   540,   541,   542,   543,   544,   545,   546,   547,
     206,   548,     0,   550,   551,   552,     0,   207,   208,     0,
     555,     0,   557,   209,   558,   210,     0,   560,   561,   562,
     563,     0,     0,   565,   566,   567,   568,   569,     0,     0,
     572,   573,   574,   217,   575,     0,   576,   577,     0,     0,
       0,   580,   581,   582,   583,   584,   585,     0,   219,     0,
       0,   220,    79,    80,    81,   339,     0,    83,    84,     0,
      85,    86,    87,   340,     0,   341,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   342,
       0,   103,     0,   104,   105,   106,   107,     0,     0,     0,
     109,   110,   111,     0,   112,     0,     0,   115,   343,   344,
       0,     0,     0,   601,   602,     0,     0,     0,     0,   603,
       0,     0,     0,     0,     0,     0,     0,     0,   604,     0,
     605,     0,   606,   607,     0,   345,   346,   347,   348,   349,
     350,   351,   817,   353,     0,     0,     0,     0,     0,     0,
       0,   361,   362,   363,     0,   364,   365,   366,     0,   133,
       0,   135,     0,     0,   368,   369,     0,   370,     0,     0,
     373,   608,   136,   374,     0,   376,   377,   378,   379,   140,
       0,     0,   382,   383,   384,     0,   386,   387,   143,   388,
       0,   390,   391,     0,     0,     0,     0,     0,   396,   397,
     398,   399,   400,   149,   150,   401,     0,   403,     0,   405,
       0,   406,   407,   408,     0,     0,     0,   412,   413,   414,
     415,     0,   417,   418,     0,   420,     0,   422,   423,   424,
     157,   425,     0,   159,     0,   427,   428,   161,     0,   430,
       0,   432,     0,     0,     0,   434,     0,   435,     0,     0,
     438,     0,   440,   441,     0,   442,   443,   444,     0,   445,
     446,   447,   448,     0,     0,   450,     0,   451,   452,   453,
       0,   170,     0,   171,     0,     0,     0,     0,   456,     0,
     457,   458,   459,   460,     0,     0,   462,     0,     0,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,     0,   182,     0,   479,   480,   481,   482,
     183,     0,   484,   485,     0,     0,   186,   187,   487,     0,
       0,   490,     0,     0,     0,   494,   495,     0,     0,   498,
       0,     0,     0,   499,   500,   501,   502,   503,     0,   190,
     504,   505,   506,     0,   508,   509,   510,   511,   512,   192,
     513,     0,   515,   516,   517,   518,   519,   520,   521,   522,
     523,     0,   524,   198,   525,   526,   527,   528,   529,     0,
       0,   531,   532,   818,     0,   535,   201,   536,   537,     0,
     538,   204,     0,   540,   541,   542,   543,   544,   545,   546,
     547,   206,   548,     0,   550,   551,   552,     0,   819,   208,
       0,   555,     0,   820,   209,   558,   210,     0,   560,   561,
     562,   563,     0,     0,   565,   566,   567,   568,   569,     0,
       0,   572,   573,   574,   217,   575,     0,   576,   577,     0,
       0,     0,   580,   581,   582,   583,   584,   585,     0,   219,
       0,     0,   220,    79,    80,    81,   339,     0,    83,    84,
       0,    85,    86,    87,   340,     0,   341,     0,    91,     0,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     342,     0,   103,     0,   104,   105,   106,   107,     0,     0,
       0,   109,   110,   111,     0,   112,     0,     0,   115,   343,
     344,     0,     0,     0,   601,   602,     0,     0,     0,     0,
     603,     0,     0,     0,     0,     0,     0,     0,     0,   604,
       0,   605,     0,   606,   607,     0,   345,   346,   347,   348,
     349,   350,   351,   838,   353,     0,     0,     0,     0,     0,
       0,     0,   361,   362,   363,     0,   364,   365,   366,     0,
     133,     0,   135,     0,     0,   368,   369,     0,   370,     0,
       0,   373,   608,   136,   374,     0,   376,   377,   378,   379,
     140,     0,     0,   382,   383,   384,     0,   386,   387,   143,
     388,     0,   390,   391,     0,     0,     0,     0,     0,   396,
     397,   398,   399,   400,   149,   150,   401,     0,   403,     0,
     405,     0,   406,   407,   408,     0,     0,     0,   412,   413,
     414,   415,     0,   417,   418,     0,   420,     0,   422,   423,
     424,   157,   425,     0,   159,     0,   427,   428,   161,     0,
     430,     0,   432,     0,     0,     0,   434,     0,   435,     0,
       0,   438,     0,   440,   441,     0,   442,   443,   444,     0,
     445,   446,   447,   448,     0,     0,   450,     0,   451,   452,
     453,     0,   170,     0,   171,     0,     0,     0,     0,   456,
       0,   457,   458,   459,   460,     0,     0,   462,     0,     0,
     464,   465,   466,   467,   468,   469,   470,   471,   472,   473,
     474,   475,   476,   477,     0,   182,     0,   479,   480,   481,
     482,   183,     0,   484,   485,     0,     0,   186,   187,   487,
       0,     0,   490,     0,     0,     0,   494,   495,     0,     0,
     498,     0,     0,     0,   499,   500,   501,   502,   503,     0,
     190,   504,   505,   506,     0,   508,   509,   510,   511,   512,
     192,   513,     0,   515,   516,   517,   518,   519,   520,   521,
     522,   523,     0,   524,   198,   525,   526,   527,   528,   529,
       0,     0,   531,   532,   839,     0,   535,   201,   536,   537,
       0,   538,   204,     0,   540,   541,   542,   543,   544,   545,
     546,   547,   206,   548,     0,   550,   551,   552,     0,   840,
     208,     0,   555,     0,   841,   209,   558,   210,     0,   560,
     561,   562,   563,     0,     0,   565,   566,   567,   568,   569,
       0,     0,   572,   573,   574,   217,   575,     0,   576,   577,
       0,     0,     0,   580,   581,   582,   583,   584,   585,     0,
     219,     0,     0,   220,    79,    80,    81,   339,     0,    83,
      84,     0,    85,    86,    87,   340,     0,   341,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   342,     0,   103,     0,   104,   105,   106,   107,     0,
       0,     0,   109,   110,   111,     0,   112,     0,     0,   115,
     343,   344,     0,     0,     0,   601,   602,     0,     0,     0,
       0,   603,     0,     0,     0,     0,     0,     0,     0,     0,
     604,     0,   605,     0,   606,   607,     0,   345,   346,   347,
     348,   349,   350,   351,  1181,   353,     0,     0,     0,     0,
       0,     0,     0,   361,   362,   363,     0,   364,   365,   366,
       0,   133,     0,   135,     0,     0,   368,   369,     0,   370,
       0,     0,   373,   608,   136,   374,     0,   376,   377,   378,
     379,   140,     0,     0,   382,   383,   384,     0,   386,   387,
     143,   388,     0,   390,   391,     0,     0,     0,     0,     0,
     396,   397,   398,   399,   400,   149,   150,   401,     0,   403,
       0,   405,     0,   406,   407,   408,     0,     0,     0,   412,
     413,   414,   415,     0,   417,   418,     0,   420,     0,   422,
     423,   424,   157,   425,     0,   159,     0,   427,   428,   161,
       0,   430,     0,   432,     0,     0,     0,   434,     0,   435,
       0,     0,   438,     0,   440,   441,     0,   442,   443,   444,
       0,   445,   446,   447,   448,     0,     0,   450,     0,   451,
     452,   453,     0,   170,     0,   171,     0,     0,     0,     0,
     456,     0,   457,   458,   459,   460,     0,     0,   462,     0,
       0,   464,   465,   466,   467,   468,   469,   470,   471,   472,
     473,   474,   475,   476,   477,     0,   182,     0,   479,   480,
     481,   482,   183,     0,   484,   485,     0,     0,   186,   187,
     487,     0,     0,   490,     0,     0,     0,   494,   495,     0,
       0,   498,     0,     0,     0,   499,   500,   501,   502,   503,
       0,   190,   504,   505,   506,     0,   508,   509,   510,   511,
     512,   192,   513,     0,   515,   516,   517,   518,   519,   520,
     521,   522,   523,     0,   524,   198,   525,   526,   527,   528,
     529,     0,     0,   531,   532,   533,     0,   535,   201,   536,
     537,     0,   538,   204,     0,   540,   541,   542,   543,   544,
     545,   546,   547,   206,   548,     0,   550,   551,   552,     0,
     207,   208,     0,   555,     0,   557,   209,   558,   210,     0,
     560,   561,   562,   563,     0,     0,   565,   566,   567,   568,
     569,     0,     0,   572,   573,   574,   217,   575,     0,   576,
     577,     0,     0,     0,   580,   581,   582,   583,   584,   585,
       0,   219,     0,     0,   220,    79,    80,    81,   339,     0,
      83,    84,     0,    85,    86,    87,   340,     0,   341,     0,
      91,     0,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   342,     0,   103,     0,   104,   105,   106,   107,
       0,     0,     0,   109,   110,   111,     0,   112,     0,     0,
     115,   343,   344,     0,     0,     0,   601,   602,     0,     0,
       0,     0,   603,     0,     0,     0,     0,     0,     0,     0,
       0,   604,     0,   605,     0,   606,   607,     0,   345,   346,
     347,   348,   349,   350,   351,     0,   353,     0,     0,     0,
       0,     0,     0,     0,   361,   362,   363,  1190,   364,   365,
     366,     0,   133,     0,   135,     0,     0,   368,   369,     0,
     370,     0,     0,   373,   608,   136,  1191,     0,   376,   377,
     378,   379,   140,     0,     0,   382,   383,   384,     0,   386,
     387,   143,   388,     0,   390,   391,     0,     0,     0,     0,
       0,   396,   397,   398,   399,   400,   149,   150,   401,     0,
     403,     0,   405,     0,   406,   407,   408,     0,     0,     0,
     412,   413,   414,   415,     0,   417,   418,     0,   420,     0,
     422,   423,   424,   157,   425,     0,   159,     0,   427,   428,
     161,     0,   430,     0,   432,     0,     0,     0,   434,     0,
     435,     0,     0,   438,     0,   440,   441,     0,   442,   443,
     444,     0,   445,   446,   447,   448,     0,     0,   450,     0,
     451,   452,   453,     0,   170,     0,   171,     0,     0,     0,
       0,   456,     0,   457,   458,   459,   460,     0,     0,   462,
       0,     0,   464,   465,   466,   467,   468,   469,   470,   471,
     472,   473,   474,   475,   832,   477,     0,   182,     0,   479,
     480,   481,   482,   183,     0,   484,   485,     0,     0,   186,
     187,   487,     0,     0,   490,     0,     0,     0,   494,   495,
       0,     0,   498,     0,     0,     0,   499,   500,   501,   502,
     503,     0,   190,   504,   505,   506,     0,   508,   509,   510,
     511,   512,   192,   513,     0,   515,   516,   517,   518,   519,
     520,   521,   522,   523,     0,   524,   198,   525,   526,   527,
     528,   529,     0,     0,   531,   532,  1185,     0,   535,   201,
     536,   537,     0,   538,   204,     0,   540,   541,   542,   543,
     544,   545,   546,   547,   206,   548,     0,   550,   551,   552,
       0,   834,   208,     0,   555,     0,   835,   209,   558,   210,
       0,   560,   561,   562,   563,     0,     0,   565,   566,   567,
     568,   569,     0,     0,   572,   573,   574,   217,   575,     0,
     576,   577,     0,     0,     0,   580,   581,   582,   583,   584,
     585,     0,   219,     0,     0,   220,    79,    80,    81,   339,
       0,    83,    84,     0,    85,    86,    87,   340,     0,   341,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   342,     0,   103,     0,   104,   105,   106,
     107,     0,     0,     0,   109,   110,   111,     0,   112,     0,
       0,   115,   343,   344,     0,     0,     0,   601,   602,     0,
       0,     0,     0,   603,     0,     0,     0,     0,     0,     0,
       0,     0,   604,     0,   605,     0,   606,   607,     0,   345,
     346,   347,   348,   349,   350,   351,     0,   353,     0,     0,
       0,     0,     0,     0,     0,   361,   362,   363,     0,   364,
     365,   366,     0,   133,     0,   135,     0,     0,   368,   369,
       0,   370,     0,     0,   373,   608,   136,   374,     0,   376,
     377,   378,   379,   140,     0,     0,   382,   383,   384,     0,
     386,   387,   143,   388,     0,   390,   391,     0,     0,     0,
       0,     0,   396,   397,   398,   399,   400,   149,   150,   401,
       0,   403,     0,   405,     0,   406,   407,   408,     0,     0,
       0,   412,   413,   414,   415,     0,   417,   418,     0,   420,
       0,   422,   423,   424,   157,   425,     0,   159,     0,   427,
     428,   161,     0,   430,     0,   432,     0,     0,     0,   434,
       0,   435,     0,  2204,   438,     0,   440,   441,     0,   442,
     443,   444,     0,   445,   446,   447,   448,     0,     0,   450,
       0,   451,   452,   453,     0,   170,     0,   171,     0,     0,
       0,     0,   456,     0,   457,   458,   459,   460,     0,     0,
     462,     0,     0,   464,   465,   466,   467,   468,   469,   470,
     471,   472,   473,   474,   475,   476,   477,     0,   182,     0,
     479,   480,   481,   482,   183,     0,   484,   485,     0,     0,
     186,   187,   487,     0,     0,   490,     0,     0,     0,   494,
     495,     0,     0,   498,     0,     0,     0,   499,   500,   501,
     502,   503,     0,   190,   504,   505,   506,     0,   508,   509,
     510,   511,   512,   192,   513,     0,   515,   516,   517,   518,
     519,   520,   521,   522,   523,     0,   524,   198,   525,   526,
     527,   528,   529,     0,     0,   531,   532,   533,     0,   535,
     201,   536,   537,     0,   538,   204,     0,   540,   541,   542,
     543,   544,   545,   546,   547,   206,   548,     0,   550,   551,
     552,     0,   207,   208,     0,   555,     0,   557,   209,   558,
     210,     0,   560,   561,   562,   563,     0,     0,   565,   566,
     567,   568,   569,     0,     0,   572,   573,   574,   217,   575,
       0,   576,   577,     0,     0,     0,   580,   581,   582,   583,
     584,   585,     0,   219,     0,     0,   220,    79,    80,    81,
     339,     0,    83,    84,     0,    85,    86,    87,   340,     0,
     341,     0,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,   342,     0,   103,     0,   104,   105,
     106,   107,     0,     0,     0,   109,   110,   111,     0,   112,
       0,     0,   115,   343,   344,     0,     0,     0,   601,   602,
       0,     0,     0,     0,   603,     0,     0,     0,     0,     0,
       0,     0,     0,   604,     0,   605,     0,   606,   607,     0,
     345,   346,   347,   348,   349,   350,   351,     0,   353,     0,
       0,     0,     0,     0,     0,     0,   361,   362,   363,     0,
     364,   365,   366,     0,   133,     0,   135,     0,     0,   368,
     369,     0,   370,     0,     0,   373,   608,   136,   374,     0,
     376,   377,   378,   379,   140,     0,     0,   382,   383,   384,
       0,   386,   387,   143,   388,     0,   390,   391,     0,     0,
       0,     0,     0,   396,   397,   398,   399,   400,   149,   150,
     401,  2436,   403,     0,   405,     0,   406,   407,   408,     0,
       0,     0,   412,   413,   414,   415,     0,   417,   418,     0,
     420,     0,   422,   423,   424,   157,   425,     0,   159,     0,
     427,   428,   161,     0,   430,     0,   432,     0,     0,     0,
     434,     0,   435,     0,     0,   438,     0,   440,   441,     0,
     442,   443,   444,     0,   445,   446,   447,   448,     0,     0,
     450,     0,   451,   452,   453,     0,   170,     0,   171,     0,
       0,     0,     0,   456,     0,   457,   458,   459,   460,     0,
       0,   462,     0,     0,   464,   465,   466,   467,   468,   469,
     470,   471,   472,   473,   474,   475,   476,   477,     0,   182,
       0,   479,   480,   481,   482,   183,     0,   484,   485,     0,
       0,   186,   187,   487,     0,     0,   490,     0,     0,     0,
     494,   495,     0,     0,   498,     0,     0,     0,   499,   500,
     501,   502,   503,     0,   190,   504,   505,   506,     0,   508,
     509,   510,   511,   512,   192,   513,     0,   515,   516,   517,
     518,   519,   520,   521,   522,   523,     0,   524,   198,   525,
     526,   527,   528,   529,     0,     0,   531,   532,   533,     0,
     535,   201,   536,   537,     0,   538,   204,     0,   540,   541,
     542,   543,   544,   545,   546,   547,   206,   548,     0,   550,
     551,   552,     0,   207,   208,     0,   555,     0,   557,   209,
     558,   210,     0,   560,   561,   562,   563,     0,     0,   565,
     566,   567,   568,   569,     0,     0,   572,   573,   574,   217,
     575,     0,   576,   577,     0,     0,     0,   580,   581,   582,
     583,   584,   585,     0,   219,     0,     0,   220,    79,    80,
      81,   339,     0,    83,    84,     0,    85,    86,    87,   340,
       0,   341,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   342,     0,   103,     0,   104,
     105,   106,   107,     0,     0,     0,   109,   110,   111,     0,
     112,     0,     0,   115,   343,   344,     0,     0,     0,   601,
     602,     0,     0,     0,     0,   603,     0,     0,     0,     0,
       0,     0,     0,     0,   604,     0,   605,     0,   606,   607,
       0,   345,   346,   347,   348,   349,   350,   351,     0,   353,
       0,     0,     0,     0,     0,     0,     0,   361,   362,   363,
       0,   364,   365,   366,     0,   133,     0,   135,     0,     0,
     368,   369,     0,   370,     0,     0,   373,   608,   136,   374,
       0,   376,   377,   378,   379,   140,     0,     0,   382,   383,
     384,     0,   386,   387,   143,   388,     0,   390,   391,     0,
       0,     0,     0,     0,   396,   397,   398,   399,   400,   149,
     150,   401,  2438,   403,     0,   405,     0,   406,   407,   408,
       0,     0,     0,   412,   413,   414,   415,     0,   417,   418,
       0,   420,     0,   422,   423,   424,   157,   425,     0,   159,
       0,   427,   428,   161,     0,   430,     0,   432,     0,     0,
       0,   434,     0,   435,     0,     0,   438,     0,   440,   441,
       0,   442,   443,   444,     0,   445,   446,   447,   448,     0,
       0,   450,     0,   451,   452,   453,     0,   170,     0,   171,
       0,     0,     0,     0,   456,     0,   457,   458,   459,   460,
       0,     0,   462,     0,     0,   464,   465,   466,   467,   468,
     469,   470,   471,   472,   473,   474,   475,   476,   477,     0,
     182,     0,   479,   480,   481,   482,   183,     0,   484,   485,
       0,     0,   186,   187,   487,     0,     0,   490,     0,     0,
       0,   494,   495,     0,     0,   498,     0,     0,     0,   499,
     500,   501,   502,   503,     0,   190,   504,   505,   506,     0,
     508,   509,   510,   511,   512,   192,   513,     0,   515,   516,
     517,   518,   519,   520,   521,   522,   523,     0,   524,   198,
     525,   526,   527,   528,   529,     0,     0,   531,   532,   533,
       0,   535,   201,   536,   537,     0,   538,   204,     0,   540,
     541,   542,   543,   544,   545,   546,   547,   206,   548,     0,
     550,   551,   552,     0,   207,   208,     0,   555,     0,   557,
     209,   558,   210,     0,   560,   561,   562,   563,     0,     0,
     565,   566,   567,   568,   569,     0,     0,   572,   573,   574,
     217,   575,     0,   576,   577,     0,     0,     0,   580,   581,
     582,   583,   584,   585,     0,   219,     0,     0,   220,    79,
      80,    81,   339,     0,    83,    84,     0,    85,    86,    87,
     340,     0,   341,     0,    91,     0,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   342,     0,   103,     0,
     104,   105,   106,   107,     0,     0,     0,   109,   110,   111,
       0,   112,     0,     0,   115,   343,   344,     0,     0,     0,
     601,   602,     0,     0,     0,     0,   603,     0,     0,     0,
       0,     0,     0,     0,     0,   604,     0,   605,     0,   606,
     607,     0,   345,   346,   347,   348,   349,   350,   351,     0,
     353,     0,     0,     0,     0,     0,  2578,     0,   361,   362,
     363,     0,   364,   365,   366,     0,   133,     0,   135,     0,
       0,   368,   369,     0,   370,     0,     0,   373,   608,   136,
     374,     0,   376,   377,   378,   379,   140,     0,     0,   382,
     383,   384,     0,   386,   387,   143,   388,     0,   390,   391,
       0,     0,     0,     0,     0,   396,   397,   398,   399,   400,
     149,   150,   401,     0,   403,     0,   405,     0,   406,   407,
     408,     0,     0,     0,   412,   413,   414,   415,     0,   417,
     418,     0,   420,     0,   422,   423,   424,   157,   425,     0,
     159,     0,   427,   428,   161,     0,   430,     0,   432,     0,
       0,     0,   434,     0,   435,     0,     0,   438,     0,   440,
     441,     0,   442,   443,   444,     0,   445,   446,   447,   448,
       0,     0,   450,     0,   451,   452,   453,     0,   170,     0,
     171,     0,     0,     0,     0,   456,     0,   457,   458,   459,
     460,     0,     0,   462,     0,     0,   464,   465,   466,   467,
     468,   469,   470,   471,   472,   473,   474,   475,   476,   477,
       0,   182,     0,   479,   480,   481,   482,   183,     0,   484,
     485,     0,     0,   186,   187,   487,     0,     0,   490,     0,
       0,     0,   494,   495,     0,     0,   498,     0,     0,     0,
     499,   500,   501,   502,   503,     0,   190,   504,   505,   506,
       0,   508,   509,   510,   511,   512,   192,   513,     0,   515,
     516,   517,   518,   519,   520,   521,   522,   523,     0,   524,
     198,   525,   526,   527,   528,   529,     0,     0,   531,   532,
     533,     0,   535,   201,   536,   537,     0,   538,   204,     0,
     540,   541,   542,   543,   544,   545,   546,   547,   206,   548,
       0,   550,   551,   552,     0,   207,   208,     0,   555,     0,
     557,   209,   558,   210,     0,   560,   561,   562,   563,     0,
       0,   565,   566,   567,   568,   569,     0,     0,   572,   573,
     574,   217,   575,     0,   576,   577,     0,     0,     0,   580,
     581,   582,   583,   584,   585,     0,   219,     0,     0,   220,
      79,    80,    81,   339,     0,    83,    84,     0,    85,    86,
      87,   340,     0,   341,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   342,     0,   103,
       0,   104,   105,   106,   107,     0,     0,     0,   109,   110,
     111,     0,   112,     0,     0,   115,   343,   344,     0,     0,
       0,   601,   602,     0,     0,     0,     0,   603,     0,     0,
       0,     0,     0,     0,     0,     0,   604,     0,   605,     0,
     606,   607,     0,   345,   346,   347,   348,   349,   350,   351,
       0,   353,     0,     0,     0,     0,     0,  2592,     0,   361,
     362,   363,     0,   364,   365,   366,     0,   133,     0,   135,
       0,     0,   368,   369,     0,   370,     0,     0,   373,   608,
     136,   374,     0,   376,   377,   378,   379,   140,     0,     0,
     382,   383,   384,     0,   386,   387,   143,   388,     0,   390,
     391,     0,     0,     0,     0,     0,   396,   397,   398,   399,
     400,   149,   150,   401,     0,   403,     0,   405,     0,   406,
     407,   408,     0,     0,     0,   412,   413,   414,   415,     0,
     417,   418,     0,   420,     0,   422,   423,   424,   157,   425,
       0,   159,     0,   427,   428,   161,     0,   430,     0,   432,
       0,     0,     0,   434,     0,   435,     0,     0,   438,     0,
     440,   441,     0,   442,   443,   444,     0,   445,   446,   447,
     448,     0,     0,   450,     0,   451,   452,   453,     0,   170,
       0,   171,     0,     0,     0,     0,   456,     0,   457,   458,
     459,   460,     0,     0,   462,     0,     0,   464,   465,   466,
     467,   468,   469,   470,   471,   472,   473,   474,   475,   476,
     477,     0,   182,     0,   479,   480,   481,   482,   183,     0,
     484,   485,     0,     0,   186,   187,   487,     0,     0,   490,
       0,     0,     0,   494,   495,     0,     0,   498,     0,     0,
       0,   499,   500,   501,   502,   503,     0,   190,   504,   505,
     506,     0,   508,   509,   510,   511,   512,   192,   513,     0,
     515,   516,   517,   518,   519,   520,   521,   522,   523,     0,
     524,   198,   525,   526,   527,   528,   529,     0,     0,   531,
     532,   533,     0,   535,   201,   536,   537,     0,   538,   204,
       0,   540,   541,   542,   543,   544,   545,   546,   547,   206,
     548,     0,   550,   551,   552,     0,   207,   208,     0,   555,
       0,   557,   209,   558,   210,     0,   560,   561,   562,   563,
       0,     0,   565,   566,   567,   568,   569,     0,     0,   572,
     573,   574,   217,   575,     0,   576,   577,     0,     0,     0,
     580,   581,   582,   583,   584,   585,     0,   219,     0,     0,
     220,    79,    80,    81,   339,     0,    83,    84,     0,    85,
      86,    87,   340,     0,   341,     0,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   342,     0,
     103,     0,   104,   105,   106,   107,     0,     0,     0,   109,
     110,   111,     0,   112,     0,     0,   115,   343,   344,     0,
       0,     0,   601,   602,     0,     0,     0,     0,   603,     0,
       0,     0,     0,     0,     0,     0,     0,   604,     0,   605,
       0,   606,   607,     0,   345,   346,   347,   348,   349,   350,
     351,     0,   353,     0,     0,     0,     0,     0,     0,     0,
     361,   362,   363,     0,   364,   365,   366,     0,   133,     0,
     135,     0,     0,   368,   369,     0,   370,     0,     0,   373,
     608,   136,   374,     0,   376,   377,   378,   379,   140,     0,
       0,   382,   383,   384,     0,   386,   387,   143,   388,     0,
     390,   391,     0,     0,     0,     0,     0,   396,   397,   398,
     399,   400,   149,   150,   401,     0,   403,     0,   405,     0,
     406,   407,   408,     0,     0,     0,   412,   413,   414,   415,
       0,   417,   418,     0,   420,     0,   422,   423,   424,   157,
     425,     0,   159,     0,   427,   428,   161,     0,   430,     0,
     432,     0,     0,     0,   434,     0,   435,     0,     0,   438,
       0,   440,   441,     0,   442,   443,   444,     0,   445,   446,
     447,   448,     0,     0,   450,     0,   451,   452,   453,     0,
     170,     0,   171,     0,     0,     0,     0,   456,     0,   457,
     458,   459,   460,     0,     0,   462,     0,     0,   464,   465,
     466,   467,   468,   469,   470,   471,   472,   473,   474,   475,
     476,   477,     0,   182,     0,   479,   480,   481,   482,   183,
       0,   484,   485,     0,     0,   186,   187,   487,     0,     0,
     490,     0,     0,     0,   494,   495,     0,     0,   498,     0,
       0,     0,   499,   500,   501,   502,   503,     0,   190,   504,
     505,   506,     0,   508,   509,   510,   511,   512,   192,   513,
       0,   515,   516,   517,   518,   519,   520,   521,   522,   523,
       0,   524,   198,   525,   526,   527,   528,   529,     0,     0,
     531,   532,   533,     0,   535,   201,   536,   537,     0,   538,
     204,     0,   540,   541,   542,   543,   544,   545,   546,   547,
     206,   548,     0,   550,   551,   552,     0,   207,   208,     0,
     555,     0,   557,   209,   558,   210,     0,   560,   561,   562,
     563,     0,     0,   565,   566,   567,   568,   569,     0,     0,
     572,   573,   574,   217,   575,     0,   576,   577,     0,     0,
       0,   580,   581,   582,   583,   584,   585,     0,   219,     0,
       0,   220,    79,    80,    81,   339,     0,    83,    84,     0,
      85,    86,    87,   340,     0,   341,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   342,
       0,   103,     0,   104,   105,   106,   107,     0,     0,     0,
     109,   110,   111,     0,   112,     0,     0,   115,   343,   344,
       0,     0,     0,   601,   602,     0,     0,     0,     0,   603,
       0,     0,     0,     0,     0,     0,     0,     0,   604,     0,
     605,     0,   606,   607,     0,   345,   346,   347,   348,   349,
     350,   351,     0,   353,     0,     0,     0,     0,     0,     0,
       0,   361,   362,   363,     0,   364,   365,   366,     0,   133,
       0,   135,     0,     0,   368,   369,     0,   370,     0,     0,
     373,   608,   136,   374,     0,   376,   377,   378,   379,   140,
       0,     0,   382,   383,   384,     0,   386,   387,   143,   388,
       0,   390,   391,     0,     0,     0,     0,     0,   396,   397,
     398,   399,   400,   149,   150,   401,     0,   403,     0,   405,
       0,   406,   407,   408,     0,     0,     0,   412,   413,   414,
     415,     0,   417,   418,     0,   420,     0,   422,   423,   424,
     157,   425,     0,   159,     0,   427,   428,   161,     0,   430,
       0,   432,     0,     0,     0,   434,     0,   435,     0,     0,
     438,     0,   440,   441,     0,   442,   443,   444,     0,   445,
     446,   447,   448,     0,     0,   450,     0,   451,   452,   453,
       0,   170,     0,   171,     0,     0,     0,     0,   456,     0,
     457,   458,   459,   460,     0,     0,   462,     0,     0,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,     0,   182,     0,   479,   480,   481,   482,
     183,     0,   484,   485,     0,     0,   186,   187,   487,     0,
       0,   490,     0,     0,     0,   494,   495,     0,     0,   498,
       0,     0,     0,   499,   500,   501,   502,   503,     0,   190,
     504,   505,   506,     0,   508,   509,   510,   511,   512,   192,
     513,     0,   515,   516,   517,   518,   519,   520,   521,   522,
     523,     0,   524,   198,   525,   526,   527,   528,   529,     0,
       0,   531,   532,   533,     0,   535,   201,   536,   537,     0,
     538,   204,     0,   540,   541,   736,   543,   544,   545,   546,
     547,   206,   548,     0,   550,   551,   552,     0,   207,   208,
       0,   555,     0,   557,   209,   558,   210,     0,   560,   561,
     562,   563,     0,     0,   565,   566,   567,   568,   569,     0,
       0,   572,   573,   574,   217,   575,     0,   576,   577,     0,
       0,     0,   580,   581,   582,   583,   584,   585,     0,   219,
       0,     0,   220,    79,    80,    81,   339,     0,    83,    84,
       0,    85,    86,    87,   340,     0,   341,     0,    91,     0,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     342,     0,   103,     0,   104,   105,   106,   107,     0,     0,
       0,   109,   110,   111,     0,   112,     0,     0,   115,   343,
     344,     0,     0,     0,   601,   602,     0,     0,     0,     0,
     603,     0,     0,     0,     0,     0,     0,     0,     0,   604,
       0,   605,     0,   606,   607,     0,   345,   346,   347,   348,
     349,   350,   351,     0,   353,     0,     0,     0,     0,     0,
       0,     0,   361,   362,   363,     0,   364,   365,   366,     0,
     133,     0,   135,     0,     0,   368,   369,     0,   370,     0,
       0,   373,   608,   136,   374,     0,   376,   377,   378,   379,
     140,     0,     0,   382,   383,   384,     0,   386,   387,   143,
     388,     0,   390,   391,     0,     0,     0,     0,     0,   396,
     397,   398,   399,   400,   149,   150,   401,     0,   403,     0,
     405,     0,   406,   407,   408,     0,     0,     0,   412,   413,
     414,   415,     0,   417,   418,     0,   420,     0,   422,   423,
     424,   157,   425,     0,   159,     0,   427,   428,   161,     0,
     430,     0,   432,     0,     0,     0,   434,     0,   435,     0,
       0,   438,     0,   440,   441,     0,   442,   443,   444,     0,
     445,   446,   447,   448,     0,     0,   450,     0,   451,   452,
     453,     0,   170,     0,   171,     0,     0,     0,     0,   456,
       0,   457,   458,   459,   460,     0,     0,   462,     0,     0,
     464,   465,   466,   467,   468,   469,   470,   471,   472,   473,
     474,   475,   832,   477,     0,   182,     0,   479,   480,   481,
     482,   183,     0,   484,   485,     0,     0,   186,   187,   487,
       0,     0,   490,     0,     0,     0,   494,   495,     0,     0,
     498,     0,     0,     0,   499,   500,   501,   502,   503,     0,
     190,   504,   505,   506,     0,   508,   509,   510,   511,   512,
     192,   513,     0,   515,   516,   517,   518,   519,   520,   521,
     522,   523,     0,   524,   198,   525,   526,   527,   528,   529,
       0,     0,   531,   532,  1185,     0,   535,   201,   536,   537,
       0,   538,   204,     0,   540,   541,   542,   543,   544,   545,
     546,   547,   206,   548,     0,   550,   551,   552,     0,   834,
     208,     0,   555,     0,   835,   209,   558,   210,     0,   560,
     561,   562,   563,     0,     0,   565,   566,   567,   568,   569,
       0,     0,   572,   573,   574,   217,   575,     0,   576,   577,
       0,     0,     0,   580,   581,   582,   583,   584,   585,     0,
     219,     0,     0,   220,  1283,    80,    81,   339,     0,    83,
      84,     0,    85,    86,    87,   340,     0,   341,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   342,     0,   103,     0,   104,   105,   106,   107,     0,
       0,     0,   109,   110,   111,     0,   112,     0,     0,   115,
     343,   344,     0,     0,     0,   601,   602,     0,     0,     0,
       0,   603,     0,     0,     0,     0,     0,     0,     0,     0,
     604,     0,   605,     0,   606,   607,     0,   345,   346,   347,
     348,   349,   350,   351,     0,   353,     0,     0,     0,     0,
       0,     0,     0,   361,   362,   363,     0,   364,   365,   366,
       0,   133,     0,   135,     0,     0,   368,   369,     0,   370,
       0,     0,   373,   608,   136,   374,     0,   376,   377,   378,
     379,   140,     0,     0,   382,   383,   384,     0,   386,   387,
     143,   388,     0,   390,   391,     0,     0,     0,     0,     0,
     396,   397,   398,   399,   400,   149,   150,   401,     0,   403,
       0,   405,     0,   406,   407,   408,     0,     0,     0,   412,
     413,   414,   415,     0,   417,   418,     0,   420,     0,   422,
     423,   424,   157,   425,     0,   159,     0,   427,   428,   161,
       0,   430,     0,   432,     0,     0,     0,   434,     0,   435,
       0,     0,   438,     0,   440,   441,     0,   442,   443,   444,
       0,   445,   446,   447,   448,     0,     0,   450,     0,   451,
     452,   453,     0,   170,     0,   171,     0,     0,     0,     0,
     456,     0,   457,   458,   459,   460,     0,     0,   462,     0,
       0,   464,   465,   466,   467,   468,   469,   470,   471,   472,
     473,   474,   475,   476,   477,     0,   182,     0,   479,   480,
     481,   482,   183,     0,   484,   485,     0,     0,   186,   187,
     487,     0,     0,   490,     0,     0,     0,   494,   495,     0,
       0,   498,     0,     0,     0,   499,   500,   501,   502,   503,
       0,   190,   504,   505,   506,     0,   508,   509,   510,   511,
     512,   192,   513,     0,   515,   516,   517,   518,   519,   520,
     521,   522,   523,     0,   524,   198,   525,   526,   527,   528,
     529,     0,     0,   531,   532,   533,     0,   535,   201,   536,
     537,     0,   538,   204,     0,   540,   541,   542,   543,   544,
     545,   546,   547,   206,   548,     0,   550,   551,   552,     0,
     207,   208,     0,   555,     0,   557,   209,   558,   210,     0,
     560,   561,   562,   563,     0,     0,   565,   566,   567,   568,
     569,     0,     0,   572,   573,   574,   217,   575,     0,   576,
     577,     0,     0,     0,   580,   581,   582,   583,   584,   585,
       0,   219,     0,     0,   220,    79,    80,    81,     0,     0,
      83,    84,     0,    85,    86,    87,     0,     0,     0,    90,
      91,     0,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,     0,     0,   103,     0,   104,   105,   106,   107,
       0,   108,     0,   109,   110,   111,     0,   112,   113,   114,
     115,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   130,     0,     0,
       0,   132,   133,   134,   135,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   136,     0,     0,     0,     0,
       0,     0,   140,     0,     0,     0,     0,     0,     0,     0,
       0,   143,     0,     0,     0,     0,   146,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   149,   150,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   153,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   157,     0,     0,   159,     0,     0,     0,
     161,     0,     0,     0,     0,   162,     0,   163,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   166,     0,     0,
       0,   167,     0,     0,     0,     0,     0,   168,     0,     0,
       0,     0,     0,     0,   170,     0,   171,     0,     0,   172,
     173,     0,   174,     0,     0,     0,     0,     0,   175,     0,
     176,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   181,   182,     0,     0,
       0,     0,     0,   183,     0,     0,     0,   185,     0,   186,
     187,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   188,   189,     0,     0,     0,     0,     0,
       0,     0,   190,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   192,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   196,     0,   198,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   201,
       0,     0,   203,     0,   204,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   206,     0,     0,     0,     0,     0,
       0,   207,   208,     0,     0,     0,     0,   209,     0,   210,
       0,     0,     0,     0,     0,   213,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   217,     0,   218,
       0,    79,    80,    81,     0,     0,    83,    84,     0,    85,
      86,    87,   219,     0,     0,   220,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,     0,     0,
     103,     0,   104,   105,   106,   107,     0,     0,     0,   109,
     110,   111,     0,   112,     0,     0,   115,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   130,     0,     0,     0,   132,   133,   134,
     135,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   136,     0,     0,     0,     0,     0,     0,   140,     0,
       0,     0,     0,     0,     0,     0,     0,   143,     0,     0,
       0,     0,   146,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   149,   150,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   157,
       0,     0,   159,     0,     0,     0,   161,     0,     0,     0,
       0,   162,     0,   163,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   166,     0,     0,     0,   167,     0,     0,
       0,     0,     0,   168,     0,     0,     0,     0,     0,     0,
     170,     0,   171,     0,     0,   172,   173,     0,   174,     0,
       0,     0,     0,     0,   175,     0,   176,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   181,   182,     0,     0,     0,     0,     0,   183,
       0,     0,     0,   185,     0,   186,   187,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   188,
     189,     0,     0,     0,     0,     0,     0,     0,   190,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   192,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     196,     0,   198,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   201,     0,     0,   203,     0,
     204,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     206,     0,     0,     0,     0,     0,     0,   207,   208,     0,
       0,     0,     0,   209,     0,   210,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   217,     0,   218,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   219,     0,
       0,   220
};

static const short yycheck[] =
{
       2,   714,   160,   830,    82,    74,   808,   221,  1364,   156,
      77,  1030,    74,  1005,    90,    74,   676,   211,   678,  1011,
      90,   667,   180,   677,  1390,  1155,    74,  1758,  1158,    77,
     921,   843,   215,   129,  1271,   748,  1118,   113,  1149,  1380,
    1380,   675,    90,   113,   191,   679,   730,  1380,    74,   600,
     710,   147,    74,  1828,   708,   590,  1762,  1465,  2002,    74,
     827,   721,  1946,    74,  1535,   113,  1537,  2202,    90,    74,
     704,   921,    77,    77,  1128,  2155,  1728,  1729,   764,  1646,
    2024,   831,  2332,   833,  1711,    90,  1500,    25,  1406,   743,
    1044,   113,  2337,  2338,  1412,  1979,  1044,  1716,  1717,   759,
     178,   785,    26,   895,   887,   739,   680,  1404,   113,   916,
       2,   745,    77,   687,  1681,  1054,  1055,    74,  1685,   829,
      77,    93,   904,   905,    78,    90,    51,  1085,  1086,  1543,
    2065,    43,    78,    90,   111,   111,   671,   213,   712,  2656,
      92,   116,   716,   213,  1094,   134,  1104,    86,   113,   723,
     116,    97,   221,   222,   116,   669,   113,  2277,   160,    78,
     222,   651,   187,   134,    86,   213,   150,   165,  2793,    91,
      86,    90,   746,  1792,  1530,    91,    86,    92,   180,   730,
     150,    91,   756,    83,    44,    34,    46,   155,    86,    92,
      82,   213,   150,    91,   202,    74,   222,    89,    78,   845,
     145,   187,   197,   192,  1771,   155,   155,   222,   213,    81,
     761,   222,  1464,  1465,   163,   150,   150,  1156,   122,   264,
      78,   192,   111,  1475,  1476,   314,     2,   163,    78,   259,
     134,   152,    86,   134,   785,   292,   218,   129,   171,    97,
     344,   294,   182,   240,   212,   240,   305,    97,   213,  2961,
     111,  1503,   197,   222,    78,   147,   213,   305,   307,  1511,
     973,   220,   152,   163,   307,   344,    90,   347,  1322,  1351,
      98,   376,   157,    97,    84,   407,    88,    89,   102,   218,
      83,    74,   414,   305,    87,     0,   178,    74,  3000,   117,
     100,   192,   232,   150,    18,   240,   956,   255,   378,   171,
     305,   220,  1193,  2132,   361,   159,   985,  1326,   267,   414,
      92,   415,  1366,    78,  3026,   312,   395,   312,   361,   408,
    1572,   255,     8,   292,   264,   302,   302,   149,    14,    15,
      16,  2581,    97,   967,   994,  2585,   285,   971,   259,  2589,
      26,    27,    28,   222,    30,    31,    32,    29,   305,  1028,
     269,    37,    38,    39,   384,   408,  1016,   387,   344,   408,
     163,   210,   251,  1543,  2248,   255,  2991,   312,   267,   414,
     220,   221,  1032,   277,   198,  1394,   374,   277,   202,   314,
    1338,  1339,   364,   319,  1018,   307,  1516,  1345,   321,   414,
     118,  1341,   218,   361,   369,   255,   220,   221,  2915,  2519,
     384,   129,   120,   387,   326,  2111,   414,   231,   258,   384,
     326,   361,   387,   302,   384,    78,   326,   387,   384,   319,
     409,   387,   411,   937,   914,   364,   364,   411,   326,   139,
     319,   255,   367,   408,   258,   307,   408,   414,   414,  1231,
     411,   302,   408,  2378,  2379,   269,   408,   271,   387,   321,
     404,   118,  2019,   392,   406,   220,   184,  1249,   404,  1756,
    1267,   400,   387,   387,   402,  1419,   385,   177,  1178,  1179,
    1418,  1253,   411,   408,   184,   387,   395,   396,   397,   364,
     399,   400,   401,   402,   403,   404,   408,  2106,  1427,    78,
    1620,   406,  1906,  1907,  1908,   298,  1910,   401,  2125,   323,
    2750,  2746,   685,   406,   214,  2755,   409,   410,   409,  2759,
     411,   414,   305,   609,  1832,  1833,   319,   184,   305,  1070,
     587,   401,   402,   403,   404,   347,  1212,   384,   144,   134,
     387,   590,   214,  1491,  1492,   392,   150,   104,   364,   587,
    1290,   171,   590,   401,   402,   403,   404,  2174,   159,   399,
     400,   401,   402,   403,   404,   738,   378,   220,   218,   287,
    1974,   385,   985,   218,  2131,    29,  1316,   218,    83,   218,
     113,   395,   396,   397,   187,   399,   400,   401,   402,   403,
     404,  2661,   587,   587,   731,   590,   155,   192,   414,   205,
     414,   667,  2421,  2422,  2423,  2424,  2425,   667,   284,  2849,
      18,   218,   155,   189,   153,  1028,   269,   765,  1287,   767,
     218,   769,   671,  1440,    29,  1442,  1443,   775,   776,   667,
     287,   120,   587,   671,   406,   590,    41,   409,   410,   357,
     587,   220,   414,   590,   399,   400,   401,   402,   403,   404,
      78,   255,  1444,   212,   255,   667,   268,   262,   163,   651,
     199,   262,   218,   951,   337,  2790,   262,  2013,   172,   212,
    1714,   153,   667,   152,   962,   166,   671,   385,   354,   292,
     213,   150,  1317,  1925,  1926,  1927,  1928,   395,   396,   397,
     269,   399,   400,   401,   402,   403,   404,  1333,   257,   203,
     357,   321,   118,   316,  1373,   192,  2402,  2403,  2473,   125,
     115,   188,   667,   129,   364,   407,   671,   199,   347,   364,
     667,  1963,   414,   364,   671,   364,   330,   609,   207,   333,
     155,   337,   385,   309,    78,  1404,  1906,  1907,  1908,  1408,
    1910,  1861,   395,   396,   397,   236,   399,   400,   401,   402,
     403,   404,  1387,   149,  1279,   314,   409,   364,  2066,   155,
     214,  2003,  2004,  2405,   832,  1415,   411,   379,   184,   651,
     411,   314,   411,   765,   314,   767,   255,   769,   104,   845,
    1193,   232,   118,   775,   776,   845,   277,   212,  2096,  2097,
     259,  2250,   220,   298,  2932,  1498,   372,   102,   189,  1680,
      86,   278,   361,   408,  1974,  1622,   385,   845,   364,   214,
       5,  1568,   408,   264,   150,  1935,   212,  1441,   361,  2278,
     399,   400,   401,   402,   403,   404,   153,   367,  2966,  2227,
     156,   256,   257,   845,    29,   129,   904,   905,  2299,   154,
    1680,   269,   145,  1852,   154,   315,    41,  1411,   339,   408,
     845,  2760,    35,  2762,  2258,   411,   150,  2261,  2262,  2263,
    2264,  2265,  2266,  2267,  2268,  2269,  2270,   337,   408,  2426,
    1539,   287,   199,   187,  1287,  2183,   220,  2185,   269,  2187,
     188,   143,   159,   406,  1297,   651,   125,   410,   202,   314,
     845,  1935,  1665,   198,   197,   887,   385,   202,   845,   170,
    2304,  2305,  2022,   142,   219,  1541,   395,   396,   397,   219,
     399,   400,   401,   402,   403,   404,   155,   336,   314,   255,
     115,   913,   914,   259,   916,   269,   231,  2623,  2624,   921,
    1134,  2032,   218,   259,  1292,  1348,   361,   240,    78,   265,
     243,   357,   333,  2852,   363,   216,   182,   829,  1306,  1722,
     832,   287,  1725,  1726,  2888,   411,   777,   385,   197,   295,
    1373,   255,   104,   386,   387,   361,  2900,   395,   396,   397,
    1038,   399,   400,   401,   402,   403,   404,   239,   255,   241,
     170,   409,   259,   408,   684,   685,  1045,   298,   809,   300,
     370,  1404,   182,  1045,   240,  1408,   232,   243,   376,   377,
     142,   272,   411,   703,  1091,  1092,    78,  1066,   319,   312,
     387,   406,   408,   408,  1066,   392,   376,   377,   323,   214,
    1079,   357,   904,   905,  2125,    97,   216,  1114,   264,  1045,
     408,   913,   914,  2798,   916,   104,  1123,  1096,  2442,   921,
    1045,   385,   232,    58,  1045,   387,  1690,  2289,   408,   178,
     392,   395,   396,   397,   307,   399,   400,   401,   402,   403,
     404,    76,   202,  1122,   412,   376,   312,   409,  1136,   211,
     413,   414,    78,   142,   264,  1134,   329,   380,   364,  1147,
     220,  2427,   272,   384,    47,   356,   387,  1756,  2258,  1758,
    1615,  2261,  2262,  2263,  2264,  2265,  2266,  2267,  2268,  2269,
    2270,   387,   802,  1772,   411,  2979,   392,   408,   808,   251,
    1760,  1761,   409,   409,   400,  1263,   816,   414,   414,   408,
      93,   887,  1190,  2454,  2454,   411,  1539,   331,   332,   269,
     259,  2454,   263,   262,   385,  2305,   267,   110,  1702,  2366,
     384,  1314,   211,   387,   844,    78,   409,   913,   914,   849,
     916,   414,  1716,  1717,  1718,   921,  1038,  1826,  2562,  1218,
    1219,   861,  1221,   369,   188,  1251,   356,  1841,   409,   311,
    1844,  2291,   125,   414,  2294,  2483,   129,  1741,   384,  1743,
     384,   387,   251,   387,   208,  1253,   115,   116,   384,   376,
     377,   387,  1230,   409,  1232,  1233,  2504,   384,   414,   223,
     387,  1193,   408,   176,  2550,   229,  1198,  1199,   416,  2011,
    2282,  2283,   408,   298,   220,   300,   387,  2034,  1230,   409,
     383,   408,   351,   386,   412,   191,    78,   200,  1792,   358,
    1279,  1795,   364,   384,   319,  1230,   387,  1232,  1233,   413,
     414,  1279,   311,  1946,  2125,   385,  1450,   409,  1286,   145,
    1242,    21,   414,   226,  1136,   395,   396,   397,   214,   399,
     400,   401,   402,   403,   404,  1147,   966,  1333,   338,   235,
     340,  1263,  2442,  1333,  1286,  1267,  1979,  1232,  1233,  1271,
     406,   305,   408,  1230,  1279,  1232,  1233,   220,   150,   387,
     338,  1286,   340,  3014,   392,  1333,  1178,  1179,  1711,   409,
    1841,   197,   400,  1844,   414,   271,   384,   120,  1190,   387,
     409,  1193,  2085,  1013,  1014,   414,  1198,  1199,  2091,  2092,
    1020,  1333,  1390,  2727,  1279,  2729,  2682,    40,   145,  1477,
     303,  1479,  1279,   410,   384,  1483,   269,   387,  1333,  1286,
     313,  1489,   267,  1756,   240,  1758,   384,   243,  1496,   387,
     137,   409,   409,  2595,   327,   217,   414,   414,  1506,  1772,
    1508,   334,   384,   384,  1064,   387,   387,   145,   220,  1251,
     408,  1253,   338,   235,   340,   376,   377,  2001,  1333,  1527,
     197,  1529,   392,   409,   394,  1267,  1333,   408,   414,  1271,
     267,  1450,  2562,   399,   400,   401,   402,   403,   404,    78,
     373,   188,   349,   376,   409,   384,   372,  2051,   387,   414,
     409,    90,   408,  1826,   384,   414,   312,   387,   290,   197,
    1488,   208,  2768,   240,   299,  2094,   243,  1193,   338,   408,
     340,  2835,  1198,  1199,  1218,  1219,   223,  1221,   408,     7,
     159,   387,   229,    11,  1436,   338,   392,   340,   394,   205,
     376,   377,   385,   408,   400,    23,    24,   131,   384,   178,
     247,   387,   240,   396,   397,   243,   399,   400,   401,   402,
     403,   404,  1531,   226,   409,  1541,  1242,    45,  1537,   414,
      48,  1541,   408,   289,   380,  1477,  1545,  1479,  2124,  2158,
     409,  1483,   411,   409,   414,   312,   384,  1489,   414,   387,
    2169,  1267,   267,  1541,  1496,  1271,   409,  1207,  1390,    98,
     409,   414,   408,   381,  1506,   414,  1508,  2186,   305,  2188,
     408,   383,   384,  2765,   386,   387,   409,  1595,   409,  1541,
     392,   414,   394,   414,   312,  1527,   255,  1529,   400,   409,
     259,   220,  2106,   262,   414,  2248,  1541,   399,   400,   401,
     402,   403,   404,   187,    93,   384,   409,  2727,   387,  2729,
      82,   414,   222,   380,  2233,   384,  1615,    89,   387,   409,
      92,   110,   384,   270,   414,   387,   409,  1615,  2202,   408,
     102,   414,   409,  2863,  2864,  2235,  1541,   414,  2257,   408,
     269,  1648,   160,  1650,  1541,   382,   408,   399,   400,   401,
     402,   403,   380,  1671,  1752,   407,  1488,   129,   409,   409,
    1648,  2731,  1650,   414,   414,  2284,   138,   139,   411,   409,
    1615,   414,   135,   136,   414,   147,   148,   267,    78,   151,
     408,  1779,   351,   409,   156,   411,   409,   176,   160,   358,
      90,   414,   863,  1791,   865,  2314,   384,    97,   381,   387,
      98,  2893,   102,  1648,   392,  1650,   394,   381,   180,  2072,
    1615,   200,   400,   222,   411,  2835,   409,   414,  1615,   191,
     319,   414,   194,  1665,  2586,   765,  2588,   767,   200,   769,
     202,  2094,   186,    78,   401,   775,   137,   226,  1680,   202,
    1682,  1759,  1684,  1648,  1762,  1650,   411,   411,  1766,   145,
     414,  1648,    97,  1650,   409,  1909,   385,   102,  2332,  1409,
    1410,   409,  2125,  1595,   409,    86,   395,   396,   397,   414,
     399,   400,   401,   402,   403,   404,  1874,   409,   376,   377,
    1722,   409,   414,  1725,  1726,   108,   414,   188,   409,   252,
     253,   214,   409,   414,  1444,  2158,  1814,   414,   198,  1953,
     409,   197,   202,   168,  1454,   414,  2169,   208,   401,  1963,
    1752,  2174,   412,  1463,   303,  1925,   279,  1927,  1928,   344,
     220,   221,   223,  2186,   313,  2188,   411,   109,   229,   414,
     412,   231,  1774,   344,  2453,   376,   377,  1779,   327,  1671,
     376,   377,    85,   344,   240,   334,   247,   243,  1680,  1791,
    1682,   344,  1684,   198,   344,   255,    93,   202,   258,  2036,
    2037,   143,  1996,  1997,  1218,  1219,   267,  1221,   108,   269,
    2233,   271,   364,   336,   416,   220,   221,   399,   400,   401,
     402,   403,   125,   214,   373,   220,   231,   409,   401,   402,
     403,  1307,  1308,  1309,  2257,  2827,  1784,  1785,  1786,   344,
    1909,   144,   408,   366,   305,   906,   907,   298,   408,   408,
     255,   408,   408,   258,  2012,   410,   312,  1567,   161,  1751,
     408,  2284,   204,   323,   269,   298,   298,  1759,   267,   411,
    1762,   408,  1874,   376,  1766,   118,  1945,   376,    93,  2558,
     376,   376,  1774,   226,  1953,   375,   189,  1956,   408,  1665,
     408,  2314,   267,   267,  1963,   414,    43,   239,   183,   241,
     230,   182,   205,   364,  1680,   267,  1682,  1976,  1684,   251,
     408,  1621,   284,   414,   408,   408,   408,   408,   323,   408,
     408,   382,  1814,  1992,   380,   385,   408,   383,   384,   408,
     386,   387,  2001,   408,   408,   395,   396,   397,   408,   399,
     400,   401,   402,   403,   404,   408,  1722,  2581,    93,  1725,
    1726,  2585,   230,   408,   414,  2589,   408,   222,   408,   301,
     408,   408,   230,   220,   408,   182,   269,   401,   214,   243,
     118,   312,  2130,   414,   149,   363,   414,  2996,   408,   410,
     385,   129,   408,   344,   408,   344,   328,   344,   298,   344,
     395,   396,   397,   363,   399,   400,   401,   402,   403,   404,
     363,   125,   150,   267,   152,  2807,   309,   310,   344,   344,
    2012,   364,   315,   377,   345,  2842,  2018,   344,   344,   408,
     267,   408,   220,   265,   408,  2852,   408,    93,   408,   369,
    2453,   408,    84,  2111,   337,  2182,   150,    98,   182,   408,
     267,   408,    93,  2677,   311,    93,   349,   364,  2124,   218,
      18,   354,    18,    85,  2124,   344,  2735,   395,   414,   207,
     414,   367,   414,   408,   408,  2143,   374,   342,   600,   372,
     409,   342,   406,    78,   319,   202,  2124,   609,   344,   342,
    2907,   409,  2240,  2085,   408,   414,   408,   408,  2246,  2091,
    2092,   187,   347,   230,   414,   627,   628,   409,   216,   131,
    1810,   414,  2124,   268,   262,  1815,   232,   255,   406,  2323,
    2179,   259,   144,  2182,   409,    40,  2750,  2179,  2332,  2124,
    2182,  2755,   402,  2125,   408,  2759,  2018,   409,  2130,   161,
    2132,  2325,  2326,  2327,  2328,  2558,   224,   224,   408,   287,
    2142,   269,   259,  2212,   676,   677,   678,   295,   680,   681,
    2212,   683,  2812,   134,   686,   687,  2790,   189,   259,  2124,
     344,   193,   108,   265,   337,   298,   193,  2124,   384,   360,
     220,   395,   406,   705,   155,  2854,   708,   344,   710,   182,
     712,   344,   395,   267,   716,   271,    93,   719,   194,   721,
     303,   723,   173,    93,   226,   196,   196,   182,   730,   731,
     409,   409,   414,   414,    12,   242,   409,   414,   740,   357,
     187,   743,   409,   409,   746,  2849,   187,  2109,   750,  2111,
    2298,   409,   754,   409,   756,   410,   409,   759,   409,   409,
    2890,   212,   414,  2125,   187,   409,   259,   269,  2240,   381,
    2132,   381,  2018,   409,  2246,   777,   381,   779,   409,   409,
    2142,  2143,   409,   785,  2323,  2889,   409,   385,  2416,   187,
     409,   344,   408,  2332,   128,   408,  2979,   395,   396,   397,
     292,   399,   400,   401,   402,   403,   404,   385,   310,  2958,
     409,   813,    36,   315,   395,  1995,   395,   395,   396,   397,
     411,   399,   400,   401,   402,   403,   404,   829,   830,   831,
     298,   833,   409,   409,   414,   337,   411,   298,   408,  2085,
     408,   403,  2735,   344,   295,  2091,  2092,   349,   344,   409,
     409,   220,   220,   243,  2402,  2403,   406,    78,   309,   267,
     409,   363,   409,   314,   354,  3014,   372,   408,   337,   409,
     414,   267,   344,   364,  2978,   409,    97,    86,   395,  2125,
     171,   102,   414,   171,   409,   168,   187,   338,    78,   340,
     406,   116,   182,   408,  2366,   409,   409,   409,   349,   409,
     409,   193,   904,   905,   408,   408,   908,  3011,   395,   414,
     361,   362,   344,   344,   409,   414,   220,   354,   385,   157,
     220,   407,   224,   408,  2472,   134,   928,   182,  2467,   931,
     271,   206,   934,   192,   408,  2467,  2298,  2409,   225,   187,
     262,   223,   408,   408,  2416,   409,   155,   409,   169,  2421,
    2422,  2423,  2424,  2425,   956,   409,   409,   409,   274,   409,
      82,  2854,   964,   408,   173,   223,   408,    89,   108,   195,
     259,   152,   974,   408,  2154,   259,   978,   198,   207,   981,
    2160,   202,   407,   189,   986,   189,   187,   164,   364,   173,
     409,  2619,   994,   151,   151,   408,   187,   267,   313,   220,
     221,   344,   259,   212,  2366,   270,  1008,   129,   182,   408,
     231,   408,   223,    93,  1016,  1017,   408,  1019,   295,   259,
     238,   265,   291,   265,   267,   147,   148,   408,   414,   259,
    1032,   267,    96,   408,   156,   409,   182,   258,   160,   267,
    2402,  2403,  2581,    93,   127,   210,  2585,   259,   269,   164,
    2589,  1053,  2600,   267,   267,   408,   178,   210,   180,  2421,
    2422,  2423,  2424,  2425,   160,  2958,   307,  1069,   361,   191,
     155,   308,   985,   308,   414,  2623,  2624,   213,   173,    78,
    2628,    82,   408,   291,   409,   222,   295,   294,  2151,  1374,
    1199,    90,  2017,  2095,  2018,  2461,  1796,  2464,    97,  1733,
     309,  2389,   323,   102,    78,   314,  2649,  2062,  2970,  2946,
    2472,  2926,  2925,  2478,  2804,  1028,    90,  2951,  2880,  2466,
    2366,  3014,  1388,    97,   725,  2673,  1782,  3026,   102,   338,
    2678,   340,  3000,  2634,  2682,  2633,  2124,  2981,  1376,   202,
     349,  3027,   180,   823,  1463,  2222,  1065,  2619,  2889,  2495,
    2330,  2331,   361,   362,  2072,  1796,  2174,   220,  2688,  2867,
    1072,  2990,  3025,  2409,   385,  2016,  1787,  1621,   158,  2213,
    1839,  1045,  2489,  2029,  2038,  1226,  1178,  1179,   399,   400,
     401,   402,   403,   404,  1618,  1225,  2332,  2587,  1190,  2850,
    2459,  1348,   255,  2297,  1565,  1501,  1198,  1199,  1976,   198,
    2558,  2603,  1876,   202,  2913,  2023,   269,  1209,  2718,  2498,
    1017,  2750,   275,   911,  1674,   964,  2755,   597,  1265,  1671,
    2759,   220,   221,   305,   198,  1233,    74,   306,   202,  1645,
     654,   938,   231,   907,  1070,  1680,  1057,  1847,  2600,  2490,
    1177,  1846,  2353,  1684,   586,  1842,   220,   221,  2428,  1251,
      85,  1253,  1434,   913,     2,    -1,   255,   231,    -1,   258,
      95,  2623,  2624,    -1,    -1,    -1,  2628,    -1,  2448,    -1,
     269,    -1,   271,    -1,    -1,  2455,    -1,    -1,   113,  1281,
      -1,   255,    -1,    -1,   258,    -1,    -1,    -1,  1290,    -1,
      -1,    -1,  2831,    -1,    -1,   269,   131,   271,    -1,  2831,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   144,
    2849,  2673,    -1,    -1,  1316,    -1,  2678,    -1,  3002,    -1,
    2682,    -1,   385,    -1,   323,    -1,   161,    -1,  2956,  2957,
      -1,    -1,   395,   396,   397,    -1,   399,   400,   401,   402,
     403,   404,    -1,    -1,    -1,    -1,  2894,    -1,    -1,   323,
      -1,    -1,    -1,    -1,   189,    -1,    -1,    -1,   193,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2916,  2917,
     205,    -1,    -1,    -1,  1287,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1297,    -1,   385,    -1,  1390,  2569,
    2570,  2571,  2572,    -1,    -1,    -1,   395,   396,   397,    -1,
     399,   400,   401,   402,   403,   404,    -1,    -1,   407,  1411,
      -1,   385,    -1,  1415,    -1,    -1,    -1,   416,  1420,    -1,
      -1,   395,   396,   397,    -1,   399,   400,   401,   402,   403,
     404,    -1,    -1,   407,   269,  1348,    -1,    -1,  1440,    -1,
    1442,  1443,    -1,    -1,    -1,    78,    -1,    -1,  1450,    -1,
      -1,  2990,    92,    78,    -1,   290,    -1,    90,    -1,    -1,
    1373,    -1,   102,  3002,    97,    -1,    -1,    -1,    -1,   102,
      -1,    -1,    97,    -1,   309,   310,    -1,   102,   600,    -1,
     315,    -1,    -1,    -1,  2956,  2957,  3025,   609,    -1,    -1,
      -1,  1404,    -1,    -1,    -1,  1408,  1498,    -1,   138,    -1,
      -1,    -1,   337,    -1,    -1,    -1,    -1,    -1,   148,    -1,
      -1,   151,    -1,    -1,   349,    -1,   156,   639,    -1,   354,
     160,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   363,    -1,
      -1,    -1,  2894,    -1,    -1,    -1,    -1,   372,    -1,    -1,
     180,    -1,    -1,    -1,   169,    -1,    -1,    -1,    -1,    -1,
      -1,   191,    -1,    -1,  2916,  2917,    -1,    -1,    -1,    -1,
      78,    -1,    -1,    -1,    -1,   198,    -1,    -1,    -1,   202,
      -1,  1573,    -1,   198,    -1,    -1,    -1,   202,    -1,    97,
      -1,    -1,    -1,  1585,   102,    -1,    -1,   220,   221,    -1,
      -1,    -1,    -1,    -1,    -1,   220,   221,    -1,   231,    -1,
      -1,    -1,    -1,    -1,    78,    -1,   231,    -1,   730,   731,
      -1,    -1,  2792,    -1,    -1,  1617,    -1,    -1,    -1,    -1,
    1622,    -1,   255,    97,    -1,   258,  1539,  2807,   102,    -1,
      -1,    -1,    -1,   258,    -1,    -1,   269,    -1,   271,   761,
      -1,    -1,    -1,   765,   269,   767,    -1,   769,    -1,    -1,
    2830,   169,    -1,   775,   776,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   785,    -1,    -1,    -1,    -1,    -1,  1671,
      -1,    -1,  1674,    -1,    -1,    -1,    -1,    78,    -1,    -1,
     198,  2861,    -1,    -1,   202,    -1,    -1,  1689,  1690,    -1,
     323,  1693,    -1,    -1,    -1,   169,    97,  1699,   323,    -1,
    1702,   102,   220,   221,    -1,    -1,    -1,   829,    -1,    -1,
     832,    -1,    -1,   231,  1716,  1717,  1718,  1719,  1720,  1721,
      -1,    -1,    -1,    -1,   198,    -1,    -1,    -1,   202,    -1,
      -1,  1733,  1734,  1735,  1736,  1737,    -1,  1739,    -1,  1741,
     258,  1743,    -1,    -1,    -1,    -1,   220,   221,    -1,    -1,
      -1,   269,   385,    -1,    -1,    -1,    -1,   231,  1760,  1761,
     385,    -1,   395,   396,   397,   887,   399,   400,   401,   402,
     403,   404,  1774,    -1,   399,   400,   401,   402,   403,   404,
      -1,   414,   904,   905,   258,    -1,    -1,    -1,    -1,    -1,
    1792,    -1,    -1,  1795,    -1,   269,    -1,   198,  1711,    78,
      -1,   202,    -1,    -1,  1806,   323,    -1,    -1,    -1,  1811,
      -1,    90,    -1,    -1,    -1,    94,  1818,    -1,    97,   220,
     221,    -1,    -1,   102,    -1,    -1,  1828,    -1,    -1,    78,
     231,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1841,
      -1,    90,  1844,  1756,    -1,  1758,    -1,    -1,    97,   323,
      -1,    -1,    -1,   102,  1856,    -1,    -1,   258,    -1,  1772,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   385,   269,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   158,
      -1,   399,   400,   401,   402,   403,   404,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   385,    -1,  1826,    -1,    -1,  1038,    -1,    -1,   198,
      -1,    -1,   323,   202,    -1,   399,   400,   401,   402,   403,
     404,    -1,    -1,    -1,  1056,  1937,    -1,    -1,    -1,    -1,
    1062,   220,   221,    -1,  1946,    -1,    -1,    -1,  1070,   198,
      -1,    -1,   231,   202,    -1,    -1,    -1,    -1,    -1,    -1,
     600,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   220,   221,    -1,    -1,    -1,   255,  1979,    -1,   258,
      -1,    -1,   231,    -1,   385,    -1,    -1,   627,   628,    -1,
     269,    -1,   271,    -1,   395,   396,   397,    -1,   399,   400,
     401,   402,   403,   404,    -1,    -1,   255,    -1,    -1,   258,
      -1,    -1,    -1,    -1,  1136,    -1,  2018,    -1,    -1,    -1,
     269,  2023,   271,    -1,    -1,  1147,    -1,    -1,    -1,    -1,
      -1,    -1,  2034,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   681,    -1,   683,   323,    -1,   686,    -1,    -1,  2051,
      -1,    -1,  1174,    -1,    -1,    -1,  1178,  1179,    -1,    -1,
      -1,    -1,    -1,  2065,    -1,   705,    -1,    -1,  1190,    -1,
      -1,  1193,    -1,  2075,   323,    -1,  1198,  1199,    -1,   719,
      -1,    -1,    -1,    -1,    -1,   364,    -1,    -1,    -1,    -1,
     730,   731,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     740,    -1,    -1,    -1,  2106,    -1,   385,    -1,    -1,    -1,
     750,    -1,    -1,    -1,   754,    -1,   395,   396,   397,    -1,
     399,   400,   401,   402,   403,   404,    -1,    -1,    -1,  1251,
    2132,  1253,    -1,    -1,    -1,    -1,   385,   777,    -1,   779,
      -1,  1263,  2144,  2145,    -1,   785,   395,   396,   397,    -1,
     399,   400,   401,   402,   403,   404,    -1,    -1,    -1,  2072,
     409,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2171,
      -1,    -1,    -1,   813,    -1,    -1,    -1,    -1,    -1,    -1,
    2182,  2094,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   985,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2204,    -1,    -1,    78,    -1,    -1,    -1,    -1,
      -1,  2213,  2125,    -1,    -1,    -1,    -1,    90,    -1,    -1,
    2222,    -1,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,
      -1,    -1,  1028,  2235,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2158,  2248,    -1,    -1,    -1,
      -1,    74,    -1,    -1,    77,    -1,  2169,    -1,    -1,    -1,
      -1,  2174,    -1,    -1,    -1,    -1,    89,    90,  1390,    -1,
      -1,    -1,    -1,  2186,    -1,  2188,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   928,    -1,
     113,   931,    -1,    -1,   934,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   129,    -1,    -1,    -1,
      -1,    -1,  1434,    -1,  1436,    -1,    -1,    -1,    -1,    -1,
    2233,    -1,    -1,    -1,   147,   198,    -1,    -1,    -1,   202,
      -1,  2333,    -1,    -1,   974,  2337,  2338,    -1,   978,    -1,
      -1,   981,    -1,    -1,  2257,    -1,   986,   220,   221,    -1,
      -1,    -1,    -1,    -1,    -1,  1477,    -1,  1479,   231,    -1,
      -1,  1483,    -1,    -1,    -1,    -1,  1488,  1489,    -1,    -1,
      -1,  2284,    -1,    -1,  1496,    -1,  2378,  2379,    78,  1019,
      -1,    -1,   255,    -1,  1506,   258,  1508,    -1,    -1,    -1,
     213,    78,    -1,  2395,  2396,    -1,   269,    97,   271,    -1,
      -1,  2314,   102,    90,    -1,  1527,    -1,  1529,    -1,    -1,
      97,    -1,    -1,  1053,    -1,   102,    -1,    -1,    -1,  2421,
    2422,  2423,  2424,  2425,    -1,    -1,    -1,    -1,    -1,  1069,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2441,
      -1,    -1,    -1,    -1,    -1,  1567,    -1,    -1,    -1,    -1,
     323,  1573,    -1,    -1,    -1,    -1,    -1,  2459,    -1,  2461,
      -1,    -1,  2464,    -1,  2466,    -1,    -1,    -1,    -1,    -1,
      -1,  2473,    -1,  1595,    -1,    -1,  2478,    -1,    -1,    -1,
      -1,    -1,   305,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1287,    -1,  2495,    -1,   182,    -1,    -1,    -1,    -1,
     187,  1297,   202,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   198,   385,    -1,    -1,   202,    -1,    -1,    -1,    -1,
     220,   221,   395,   396,   397,    -1,   399,   400,   401,   402,
     403,   404,    -1,   220,   221,    -1,   409,    -1,    -1,    -1,
    2453,    -1,    -1,  1665,   231,    -1,    -1,    -1,    -1,  1671,
      -1,    -1,  1348,    -1,    -1,    -1,    -1,    -1,   258,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   255,   269,
      -1,   258,    -1,  2575,    -1,    -1,  2578,  1373,    -1,    -1,
      -1,    -1,   269,    -1,   271,    -1,    -1,    -1,    -1,    -1,
    2592,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1722,  2603,    -1,  1725,  1726,  2607,    -1,  2609,  1404,    -1,
      -1,    -1,  1408,  2615,    -1,    -1,    -1,    -1,  2620,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1752,    -1,    -1,    -1,    -1,    -1,   323,  1759,    -1,    -1,
    1762,  1281,    -1,    -1,  1766,  2558,    -1,    -1,    -1,    -1,
      -1,    -1,  1774,    -1,    -1,    -1,    -1,  1779,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1791,
      -1,    -1,    -1,    -1,    -1,  2677,    -1,    -1,    -1,    -1,
    2682,    -1,    -1,    -1,    -1,   385,    -1,    -1,    -1,    -1,
      -1,    -1,  1814,    -1,    -1,    -1,    -1,    -1,   385,   399,
     400,   401,   402,   403,   404,    -1,    -1,    -1,   395,   396,
     397,    -1,   399,   400,   401,   402,   403,   404,    -1,  1841,
    1842,    -1,  1844,  1845,  1846,  1847,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1539,  2746,    -1,  2748,    -1,    -1,    78,
      -1,    -1,  1874,    -1,    -1,    -1,    -1,    -1,  2760,    -1,
    2762,    90,    -1,    -1,   587,    -1,    -1,   590,    97,    -1,
      -1,    -1,    -1,   102,    -1,    -1,    -1,    -1,    -1,    -1,
    1420,    -1,    -1,    -1,    -1,    -1,   609,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2798,  2799,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2812,    -1,    -1,    -1,  2816,    -1,    -1,    -1,    -1,    -1,
     985,   985,  2735,    -1,    -1,    -1,    -1,   985,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2842,    -1,    -1,    -1,   667,    -1,    -1,    -1,   671,    -1,
    2852,    -1,   675,    -1,    -1,    -1,   679,    -1,    -1,    -1,
      -1,    -1,    -1,  1028,  1028,    -1,    -1,    -1,    -1,   198,
    1028,    -1,    -1,   202,    -1,    -1,    -1,  2879,    -1,    -1,
      -1,   704,    -1,    -1,    -1,    -1,    -1,  2889,  2890,    -1,
    2012,   220,   221,    -1,    -1,    -1,  2018,    -1,    -1,    -1,
      -1,    -1,   231,    -1,    -1,  2907,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   736,    -1,  1711,   739,    -1,    -1,    -1,
      -1,    -1,   745,    -1,    -1,    -1,   255,    -1,    -1,   258,
    2932,    -1,    -1,  1573,    -1,    -1,    -1,    -1,    -1,    -1,
     269,  2854,   271,    -1,    -1,  1585,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2961,
    1756,    -1,  1758,  2085,  2966,    -1,    78,    -1,    -1,  2091,
    2092,    -1,    -1,    -1,    -1,    -1,  1772,  2979,    90,    -1,
      -1,    -1,    -1,    -1,    -1,    97,    -1,    -1,    -1,  2111,
     102,    -1,    -1,    -1,   323,    -1,    -1,    -1,  3000,    -1,
      -1,    -1,    -1,  2125,   827,    -1,   829,    -1,  2130,    -1,
    2132,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2142,  2143,   845,    -1,  3026,    -1,    -1,    -1,    -1,    -1,
    1826,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2958,    -1,    -1,    -1,  1689,
      -1,    -1,    -1,  1693,    -1,    -1,   385,    -1,    -1,  1699,
    2182,    -1,    -1,    -1,    -1,    -1,   395,   396,   397,    -1,
     399,   400,   401,   402,   403,   404,    -1,    -1,    -1,  1719,
     409,  1721,    -1,    -1,   985,    -1,   198,    -1,    -1,    -1,
     202,    -1,    -1,    -1,    -1,  1735,    -1,  1737,    -1,  1739,
      -1,  3014,    -1,    -1,    -1,    -1,    -1,    -1,   220,   221,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2240,   231,
      -1,    -1,  1287,  1287,  2246,    -1,    -1,  1028,    -1,  1287,
      -1,    -1,  1297,  1297,    -1,    -1,    -1,    -1,    -1,  1297,
      -1,    -1,    -1,   255,   967,    -1,   258,    -1,   971,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   269,    -1,   271,
      -1,    -1,   985,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2298,    -1,    -1,    -1,
      -1,    -1,    -1,  1348,  1348,    -1,    -1,    -1,    -1,    -1,
    1348,    -1,    -1,    -1,    -1,  1018,    -1,    -1,    -1,    -1,
      -1,  1841,    -1,    -1,  1844,  1028,    -1,    -1,  1373,  1373,
      -1,   323,    -1,    -1,    -1,  1373,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1404,
    1404,    -1,    -1,  1408,  1408,    -1,  1404,    -1,    -1,    -1,
    1408,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1083,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   385,    -1,    -1,  2072,    -1,    -1,    -1,
    2402,  2403,  1105,   395,   396,   397,    -1,   399,   400,   401,
     402,   403,   404,    -1,  2416,    -1,    -1,   409,  2094,  2421,
    2422,  2423,  2424,  2425,    -1,    -1,  1129,  1130,    -1,  1132,
    1133,  1134,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1150,    -1,  2125,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2472,    -1,    -1,    -1,    -1,  1178,  1179,    -1,    -1,    -1,
      -1,    -1,  2158,    -1,    -1,    -1,    -1,    -1,  2490,    -1,
    1193,    -1,    -1,  2169,  1539,  1539,    -1,    -1,  2174,    -1,
      -1,  1539,    -1,   134,    -1,    -1,  1287,    -1,    -1,    -1,
    2186,    -1,  2188,    -1,    -1,    -1,  1297,  1220,    -1,    -1,
    1223,  1224,    -1,    -1,    -1,    -1,    -1,  1230,    -1,  1232,
    1233,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   170,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1251,    -1,
      -1,   182,   134,    -1,    -1,  2075,   187,  2233,    -1,    -1,
      -1,   192,   193,    -1,   195,    -1,    -1,  1348,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1279,    -1,    -1,    -1,
      -1,  2257,    -1,  1286,  1287,   216,    -1,    -1,   170,    -1,
      -1,    -1,  1373,    -1,  1297,    -1,    -1,    -1,  2600,    -1,
     182,   232,    -1,    -1,    -1,   187,    -1,    -1,  2284,    -1,
     192,   193,    -1,   195,    -1,    -1,    -1,  2619,    -1,    -1,
      -1,  2623,  2624,  1404,  2144,  2145,  2628,  1408,    -1,   985,
    1333,    -1,    -1,   264,   216,    -1,    -1,    -1,  2314,    -1,
      -1,   272,    -1,    -1,    -1,  1348,    -1,    -1,    -1,    -1,
     232,  2171,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2182,    -1,    -1,    -1,  1711,  1711,    -1,    -1,
    1373,  2673,  1028,  1711,    -1,    -1,  2678,    -1,    -1,    -1,
    2682,    -1,   264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     272,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1402,
      -1,  1404,    -1,    -1,    -1,  1408,   337,    -1,    -1,    -1,
      -1,  1756,  1756,  1758,  1758,    -1,    -1,    -1,  1756,    -1,
    1758,    -1,    -1,    -1,    -1,   356,    -1,  1772,  1772,    -1,
      -1,    -1,    -1,    -1,  1772,    -1,    -1,    -1,  1441,    -1,
      -1,    -1,    -1,    -1,   375,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   337,    -1,    -1,  1539,    -1,
      -1,  1464,  1465,    -1,    -1,    -1,    -1,    -1,    -1,  1472,
      -1,    -1,  1475,  1476,   356,    -1,    -1,  2453,   409,   410,
     411,  1826,  1826,    -1,    -1,  1488,    -1,    -1,  1826,    -1,
      -1,    -1,  1495,   375,    -1,    -1,  1499,  1500,  1501,    -1,
    1503,    -1,    -1,    -1,    -1,    -1,    -1,  1510,  1511,    -1,
      -1,  1514,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   409,   410,   411,
      -1,    -1,    -1,    -1,    -1,    -1,  1539,  1540,  1541,    -1,
    1543,  1544,    -1,    -1,    -1,  1548,    -1,    -1,    -1,  1552,
      -1,    -1,  1555,  1556,  1557,  1558,  1559,  1560,  1561,  1562,
    1563,  1564,    -1,    -1,    -1,  1568,    77,    -1,    -1,  1572,
      -1,    -1,    -1,    -1,    -1,  2395,  2396,    -1,    -1,    90,
      -1,    -1,  2558,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2894,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   113,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1615,    -1,  2916,  2917,    -1,    -1,    -1,    -1,
      -1,  2441,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1711,  1287,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1297,    -1,    -1,    -1,  1648,    -1,  1650,    -1,    -1,
      -1,    -1,    -1,    -1,  2956,  2957,    -1,    -1,    -1,  2961,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1756,    -1,  1758,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    78,    -1,    -1,    -1,    -1,
      -1,  1772,  1348,    -1,    -1,    -1,    -1,    90,  3000,    -1,
    1703,    -1,   213,    -1,    97,    -1,    -1,    -1,  1711,   102,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1373,    -1,    -1,
      -1,    -1,    -1,    -1,  3026,    -1,    -1,  2072,  2072,    -1,
      -1,    -1,    -1,    -1,  2072,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1826,    -1,    -1,  1404,  2094,
    2094,    -1,  1408,  1756,    -1,  1758,  2094,    -1,    -1,  2735,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1770,    -1,  1772,
      -1,    -1,    -1,    78,    -1,    -1,    -1,    -1,    -1,    -1,
    2125,  2125,    -1,    -1,    -1,    -1,    -1,  2125,    -1,  2609,
      -1,    -1,    97,    -1,    -1,  2615,    -1,   102,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   198,    -1,    -1,    -1,   202,
      -1,    -1,    -1,  2158,  2158,    -1,    -1,    -1,    -1,    -1,
    2158,    -1,    -1,  1826,  2169,  2169,    -1,   220,   221,  2174,
    2174,  2169,    -1,    -1,    -1,    -1,  2174,    -1,   231,    -1,
      -1,  2186,  2186,  2188,  2188,    -1,    -1,    -1,  2186,    -1,
    2188,    -1,    -1,    -1,    -1,  1858,    -1,    -1,    -1,    -1,
      -1,    -1,   255,    -1,   169,   258,    -1,    -1,    -1,    -1,
      -1,    -1,  1875,    -1,    -1,    -1,   269,    -1,  2854,    -1,
      -1,    -1,    -1,  1539,    -1,    -1,    -1,    -1,  2233,  2233,
      -1,    -1,    -1,   198,    -1,  2233,    -1,   202,    -1,    -1,
      -1,    -1,    -1,  1906,  1907,  1908,  1909,  1910,    -1,    -1,
      -1,    -1,  2257,  2257,    -1,   220,   221,    -1,    -1,  2257,
      -1,    -1,  1925,  1926,  1927,  1928,   231,    -1,    -1,    -1,
     323,    -1,    -1,  1936,    -1,    -1,    -1,    -1,    -1,  2284,
    2284,    -1,    -1,    -1,    -1,  1948,  2284,    -1,    -1,    -1,
    1953,    -1,    -1,   258,    -1,    -1,    -1,    -1,    -1,    -1,
    1963,    -1,    -1,    -1,   269,    -1,    -1,    -1,    -1,  2314,
    2314,  1974,  1975,    -1,  1977,    -1,  2314,    -1,  1981,    -1,
      -1,    -1,  2958,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2072,   385,    -1,   985,    -1,    -1,    -1,  2001,    -1,
    2003,  2004,   395,   396,   397,    -1,   399,   400,   401,   402,
     403,   404,    -1,  2094,    -1,    -1,    -1,    -1,   323,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2029,    -1,    -1,    -1,
      -1,    -1,    -1,  2036,  2037,  2038,    -1,  1028,  3014,    -1,
      -1,    -1,    -1,    -1,  2125,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1711,    -1,    -1,  2061,  2879,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2072,
      -1,    -1,    -1,    -1,    -1,    -1,   587,  2158,    -1,   590,
     385,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2169,    -1,
      -1,  2094,    -1,  2174,   399,   400,   401,   402,   403,   404,
    1756,    -1,  1758,    -1,    -1,  2186,    -1,  2188,  2453,  2453,
      -1,    -1,    -1,    -1,    -1,  2453,  1772,    -1,    -1,    -1,
      -1,  2124,  2125,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2233,    -1,    -1,  2158,   667,    -1,    -1,    -1,
     671,    -1,    -1,    -1,   675,    -1,  2169,    -1,   679,    -1,
    1826,  2174,    -1,    -1,    -1,    -1,  2257,    -1,    -1,    -1,
      -1,    -1,    -1,  2186,    -1,  2188,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   704,    -1,    -1,    -1,    -1,    -1,  2202,
      -1,    -1,    -1,  2284,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2558,  2558,    -1,    -1,    -1,    -1,    -1,
    2558,  2224,    -1,    -1,    -1,    -1,    -1,  2230,   739,    -1,
    2233,    -1,    -1,  2314,   745,    -1,    -1,    -1,    -1,  2242,
      -1,  2244,    -1,    -1,    -1,    -1,  2249,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2257,  2258,    -1,    -1,  2261,  2262,
    2263,  2264,  2265,  2266,  2267,  2268,  2269,  2270,    -1,    -1,
      -1,    -1,  2275,  2276,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2284,    -1,    -1,    -1,    -1,  2289,    -1,    -1,  2292,
      -1,    -1,    -1,    -1,    -1,    -1,  1287,    -1,    -1,    -1,
      -1,  2304,  2305,  2306,    -1,  2308,  1297,    -1,    -1,    -1,
      -1,  2314,  2315,    -1,    -1,    -1,   827,  2320,    -1,    -1,
    2323,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2332,
      -1,    -1,    -1,    -1,   845,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2358,    -1,  1348,    -1,    -1,
      -1,    78,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2453,    90,    -1,    -1,    -1,    -1,    -1,    -1,
      97,    -1,  1373,    -1,    -1,   102,    -1,    -1,    -1,    -1,
    2735,  2735,    -1,    -1,    -1,    -1,    -1,  2735,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1404,    -1,    -1,  2072,  1408,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2094,  2442,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2453,    -1,    -1,    -1,    -1,    -1,   967,    -1,    -1,    -1,
     971,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2125,
      -1,    -1,    -1,    -1,   985,    -1,    -1,  2558,    -1,    -1,
      -1,   198,    -1,    -1,    -1,   202,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2498,    -1,    -1,    -1,    -1,
      -1,    -1,  2158,   220,   221,  2508,    -1,  1018,    -1,  2854,
    2854,    -1,    -1,  2169,   231,    -1,  2854,  1028,  2174,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2186,    -1,  2188,    -1,    -1,    -1,    -1,    -1,   255,    -1,
      -1,   258,    -1,    -1,    -1,    -1,    -1,    -1,  1539,    -1,
      -1,    -1,   269,    -1,   271,  2558,    -1,    78,    -1,  2562,
    2563,  2564,    -1,    -1,  2567,    -1,    -1,    -1,    -1,    90,
      -1,    -1,  1083,    -1,    -1,    -1,    97,  2233,  2581,    -1,
      -1,   102,  2585,    -1,    -1,    -1,  2589,    -1,    -1,    -1,
      -1,    -1,  2595,    -1,  1105,    -1,    -1,    -1,    -1,    -1,
      -1,  2257,    -1,    -1,    -1,    -1,   323,    -1,    -1,    -1,
      -1,    -1,    -1,  2958,  2958,    -1,    -1,    -1,  1129,  1130,
    2958,  1132,  1133,  1134,    -1,    -1,    -1,    -1,  2284,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1150,
      -1,    -1,    -1,    -1,    -1,  2648,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2735,    -1,    -1,    -1,  2314,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   385,  3014,
    3014,    -1,    -1,    -1,  2677,    -1,  3014,   198,   395,   396,
     397,   202,   399,   400,   401,   402,   403,   404,    -1,    -1,
      -1,    -1,   409,    -1,    -1,    -1,    -1,    -1,    -1,   220,
     221,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1220,
     231,    -1,  1223,  1224,    -1,  2718,    -1,    -1,    -1,    -1,
    1711,  1232,  1233,    -1,  2727,    -1,  2729,    -1,    -1,    -1,
      -1,    -1,  2735,    -1,   255,    -1,  2739,   258,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2750,   269,    -1,
     271,    -1,  2755,    -1,    -1,    -1,  2759,    -1,    -1,    -1,
      -1,    -1,  2765,  2766,    -1,  1756,  2769,  1758,  1279,    -1,
      -1,    -1,    -1,  2854,    -1,    -1,  1287,    -1,    -1,    -1,
      -1,  1772,    -1,    -1,    -1,    -1,  1297,  2790,    -1,    78,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2453,    -1,    -1,
      -1,    90,   323,    -1,    -1,    -1,    -1,    -1,    97,    -1,
    2813,    -1,    -1,   102,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1333,    -1,    -1,    78,    -1,    -1,    -1,    -1,
      -1,    -1,  2835,    -1,    -1,  1826,    -1,  1348,    -1,    -1,
      -1,    -1,  2845,    -1,    97,    -1,  2849,    -1,    -1,   102,
      -1,  2854,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1373,    -1,   385,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   395,   396,   397,  2958,   399,   400,
     401,   402,   403,   404,    -1,    -1,  2889,    -1,   409,    -1,
    2893,  1402,    -1,  1404,    -1,    -1,    -1,  1408,    -1,    -1,
      -1,    -1,  2558,    -1,    -1,    -1,    -1,    -1,    -1,   198,
    2913,    -1,    -1,   202,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1441,   220,   221,  3014,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   231,    -1,    -1,   198,    -1,    -1,    -1,   202,
      -1,    -1,    -1,  1464,  1465,  2958,    -1,    -1,    -1,    -1,
      -1,  1472,    -1,    -1,  1475,  1476,   255,   220,   221,   258,
      -1,    -1,    -1,    -1,    -1,  2978,    -1,    -1,   231,    -1,
     269,    -1,   271,    -1,  1495,    -1,    -1,    -1,  1499,  1500,
    1501,    -1,  1503,    -1,    -1,    -1,    -1,    -1,    -1,  1510,
    1511,    -1,    -1,  1514,    -1,   258,    -1,    -1,  3011,    -1,
      -1,  3014,    -1,    -1,    -1,    -1,   269,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1539,  1540,
    1541,    -1,  1543,  1544,   323,    -1,    -1,  1548,    -1,    -1,
      -1,  1552,    -1,    -1,  1555,  1556,  1557,  1558,  1559,  1560,
    1561,  1562,  1563,  1564,    -1,    -1,    -1,  1568,    -1,    -1,
      -1,  1572,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     323,    90,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2735,
      -1,  2072,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   113,    -1,   385,    -1,    -1,    -1,
      -1,    -1,    -1,  2094,  1615,    -1,   395,   396,   397,    -1,
     399,   400,   401,   402,   403,   404,    -1,    -1,    -1,    -1,
     409,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   385,    -1,  2125,    -1,    -1,  1648,    -1,  1650,
      -1,    -1,    -1,   396,   397,    -1,   399,   400,   401,   402,
     403,   404,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    78,    -1,    -1,    -1,    -1,    -1,  2158,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2169,    -1,
      97,    -1,    -1,  2174,    -1,   102,    -1,    -1,    -1,    -1,
      -1,    -1,  1703,    -1,   213,  2186,    -1,  2188,  2854,    -1,
    1711,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,     3,    -1,    -1,    -1,    -1,    -1,     9,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    17,    -1,    19,
      -1,    -1,    22,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2233,    33,    -1,  1756,    -1,  1758,    -1,    -1,
      -1,    -1,   169,    -1,    -1,    -1,    -1,    -1,    -1,  1770,
      -1,  1772,    52,    53,    -1,    -1,  2257,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   198,    -1,    -1,    -1,   202,    -1,    -1,    -1,    79,
      -1,    -1,    -1,  2284,    -1,    -1,    -1,    87,    88,    89,
      -1,    -1,  2958,   220,   221,    -1,    -1,    -1,    -1,    -1,
      -1,   101,    -1,    -1,   231,  1826,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2314,    -1,    -1,    -1,    -1,    -1,   119,
      -1,   121,   122,    -1,    -1,    -1,   126,   127,    -1,    -1,
      -1,   258,    -1,   133,   134,    -1,    -1,  1858,    -1,    -1,
      -1,    -1,   269,    -1,   144,    -1,   146,    -1,  3014,   149,
      -1,    -1,    -1,    -1,  1875,   155,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   163,    -1,    -1,    -1,    -1,   168,    -1,
      -1,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,   179,
      -1,    -1,    -1,    -1,    -1,  1906,  1907,  1908,  1909,  1910,
     190,    -1,   192,    -1,    -1,    -1,   323,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1925,  1926,  1927,  1928,    -1,    -1,
      -1,    -1,   212,    -1,    -1,  1936,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1948,    -1,    -1,
      -1,    -1,  1953,   233,   234,    -1,    -1,   237,    -1,    -1,
      -1,    -1,  1963,    -1,   244,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2453,  1974,  1975,    -1,  1977,   257,   385,    -1,
    1981,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   399,   400,   401,   402,   403,   404,    -1,    -1,
    2001,    -1,  2003,  2004,    -1,    -1,   286,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   296,    -1,    -1,    -1,
     300,    -1,    -1,    -1,   304,    -1,   306,    -1,  2029,    -1,
      -1,    -1,    -1,    -1,   314,  2036,  2037,  2038,    -1,   319,
      -1,    -1,   322,    -1,    -1,    -1,    -1,    -1,   328,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2061,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2072,   352,    -1,   354,    -1,    -1,  2558,    -1,   359,
      -1,   361,    -1,    -1,    -1,   365,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2094,    -1,    -1,    78,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,    -1,
      -1,    -1,    -1,    -1,    -1,    97,    -1,    -1,    -1,    -1,
     102,    -1,    -1,  2124,  2125,    -1,    -1,    -1,   408,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2158,   667,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   675,    -1,  2169,    -1,
     679,    -1,    -1,  2174,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2186,    -1,  2188,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   704,    -1,    -1,    -1,    -1,
      -1,  2202,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   198,    -1,    -1,    -1,
     202,    -1,    -1,  2224,    -1,    -1,    -1,    -1,    -1,  2230,
     739,    -1,  2233,    -1,    -1,    -1,   745,    -1,   220,   221,
      -1,  2242,    -1,  2244,    -1,    -1,    -1,    -1,  2249,   231,
      -1,    -1,    -1,    -1,  2735,    -1,  2257,  2258,    -1,    -1,
    2261,  2262,  2263,  2264,  2265,  2266,  2267,  2268,  2269,  2270,
      -1,    -1,    -1,   255,  2275,  2276,   258,    -1,    -1,    -1,
      -1,    -1,    -1,  2284,    -1,    -1,    -1,   269,  2289,   271,
      -1,  2292,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2304,  2305,  2306,    -1,  2308,    -1,    -1,
      -1,    -1,    -1,  2314,  2315,    -1,    -1,    -1,   827,  2320,
      -1,    -1,  2323,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2332,    -1,    -1,    -1,    -1,   845,    -1,    -1,    -1,
      -1,   323,    -1,    -1,    -1,    -1,    -1,    78,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2358,    -1,    90,
      -1,    -1,    93,    -1,    -1,    -1,    97,    -1,    -1,    -1,
      -1,   102,    -1,  2854,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   385,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   395,   396,   397,    -1,   399,   400,   401,
     402,   403,   404,    -1,    -1,    -1,    -1,   409,    85,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    -1,
      -1,  2442,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2453,    -1,    -1,    -1,   113,    -1,   967,    -1,
      -1,    -1,   971,    -1,    -1,    -1,    -1,   198,    -1,    -1,
      -1,   202,   129,    -1,   131,    -1,   985,  2958,    -1,    -1,
      -1,    82,    -1,    -1,    -1,    -1,    -1,   144,    89,   220,
     221,    -1,    -1,   150,    -1,    -1,    -1,  2498,    -1,    -1,
     231,    -1,    -1,    -1,   161,    -1,    -1,  2508,    -1,  1018,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1028,
      -1,    -1,    -1,    -1,   255,    -1,    -1,   258,   129,    -1,
      -1,    -1,    -1,  3014,   191,    -1,   193,    -1,   269,    -1,
     271,    -1,    -1,    -1,    -1,    -1,   147,    -1,   205,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2558,    -1,   160,
      -1,  2562,  2563,  2564,    -1,    -1,  2567,    -1,    -1,   226,
      -1,    -1,    -1,    -1,  1083,    -1,    -1,   178,   235,   180,
    2581,    -1,    -1,    -1,  2585,    -1,    -1,    -1,  2589,    -1,
      -1,    -1,   323,    -1,  2595,    -1,  1105,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   269,    -1,   271,    -1,    -1,    -1,    -1,    -1,
    1129,  1130,    -1,  1132,  1133,  1134,    -1,    78,    -1,    -1,
      -1,    -1,    -1,   290,    -1,    -1,    -1,    -1,    -1,    90,
      -1,  1150,    93,    -1,    -1,    -1,    97,  2648,    -1,    -1,
      -1,   102,    -1,   310,   385,    -1,    -1,    -1,   315,    -1,
      -1,    -1,    -1,    -1,   395,   396,   397,    -1,   399,   400,
     401,   402,   403,   404,    -1,    -1,  2677,    -1,    -1,    -1,
     337,   338,    -1,   340,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   349,    -1,    -1,    -1,   353,   354,    -1,    -1,
     357,    -1,    -1,    -1,    -1,    -1,   363,    -1,    -1,    -1,
      -1,  1220,    -1,    -1,  1223,  1224,    -1,  2718,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2727,    -1,  2729,    -1,
      -1,    -1,    -1,    -1,  2735,    -1,    -1,    -1,  2739,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   198,    -1,  2750,
      -1,   202,    -1,    -1,  2755,    -1,    -1,    -1,  2759,    -1,
      -1,    -1,    -1,    -1,  2765,  2766,    -1,    -1,  2769,   220,
     221,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1287,    -1,
     231,    -1,    78,    -1,    -1,    -1,    -1,    -1,  1297,  2790,
      -1,    -1,    -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,
      -1,    97,    -1,    -1,   255,    -1,   102,   258,    -1,    -1,
      -1,    -1,  2813,    -1,    -1,    -1,    -1,    -1,   269,    -1,
     271,    -1,    -1,    -1,  1333,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2835,    -1,    -1,    -1,    -1,  1348,
      -1,    -1,    -1,    -1,  2845,    -1,    -1,    -1,  2849,    -1,
      -1,    -1,    -1,  2854,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1373,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   323,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2889,    -1,
      -1,    -1,  2893,  1402,    -1,  1404,    -1,    -1,    -1,  1408,
      -1,    -1,   198,    -1,    -1,    -1,   202,    -1,    -1,    -1,
      -1,    -1,  2913,    -1,    -1,    -1,    -1,    -1,    78,    -1,
      -1,    -1,    -1,    -1,   220,   221,    -1,    -1,    -1,    -1,
      90,    -1,  1441,    -1,   385,   231,    -1,    97,    -1,    -1,
      -1,    -1,   102,    -1,   395,   396,   397,    -1,   399,   400,
     401,   402,   403,   404,    -1,  1464,  1465,  2958,    -1,   255,
      -1,    -1,   258,  1472,    -1,    -1,  1475,  1476,    -1,    -1,
      -1,    -1,    -1,   269,    -1,   271,    -1,  2978,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1495,    -1,    -1,    -1,
    1499,  1500,  1501,    -1,  1503,    -1,    -1,    -1,    -1,    -1,
      -1,  1510,  1511,    -1,    -1,  1514,    -1,    -1,   609,    -1,
    3011,    -1,    -1,  3014,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   323,    -1,    -1,
    1539,  1540,  1541,    -1,  1543,  1544,    -1,    -1,   198,  1548,
      -1,    -1,   202,  1552,    -1,    -1,  1555,  1556,  1557,  1558,
    1559,  1560,  1561,  1562,  1563,  1564,    -1,    -1,    -1,  1568,
     220,   221,    -1,  1572,    -1,    -1,    -1,    -1,   364,    -1,
      -1,   231,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   385,
      -1,    -1,    -1,    -1,    -1,   255,    -1,    -1,   258,   395,
     396,   397,    -1,   399,   400,   401,   402,   403,   404,   269,
      -1,   271,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   282,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    78,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    90,    -1,    -1,    93,
      -1,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,    -1,
      -1,    -1,    -1,   323,   765,    -1,   767,    -1,   769,    -1,
      -1,    -1,    -1,    -1,   775,   776,    -1,    -1,    -1,    -1,
      -1,    78,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    90,  1703,    -1,    -1,    -1,    -1,    -1,
      97,    -1,  1711,    -1,    -1,   102,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   385,    -1,    -1,   829,    -1,
      -1,   832,    -1,    -1,    -1,   395,   396,   397,    -1,   399,
     400,   401,   402,   403,   404,    -1,    -1,  1756,    -1,  1758,
      -1,    -1,    -1,    -1,   198,    -1,    -1,    -1,   202,    -1,
      -1,  1770,    -1,  1772,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   220,   221,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   887,   231,    -1,    -1,
     187,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   198,   139,   904,   905,   202,    -1,    -1,    -1,    -1,
      -1,   255,    -1,    -1,   258,    -1,    -1,  1826,    -1,    -1,
     921,    -1,    -1,   220,   221,   269,    -1,   271,    -1,    -1,
      -1,    -1,    -1,    -1,   231,    -1,    -1,    -1,    -1,    -1,
     177,    -1,    -1,    -1,    -1,    -1,    -1,   184,    -1,  1858,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   255,    -1,
      -1,   258,    -1,    -1,    -1,    -1,  1875,    -1,    -1,    -1,
      -1,    -1,   269,    -1,   271,    -1,    -1,   214,   215,   323,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1906,  1907,  1908,
    1909,  1910,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1925,  1926,  1927,  1928,
      -1,    -1,    -1,    -1,    -1,    -1,   323,  1936,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1038,    -1,  1948,
      -1,   385,    -1,    -1,  1953,    -1,    -1,    -1,    -1,    -1,
      -1,   395,   396,   397,  1963,   399,   400,   401,   402,   403,
     404,    -1,    -1,    -1,    -1,  1974,  1975,    -1,  1977,    -1,
      -1,    -1,  1981,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   385,    -1,
      -1,    -1,  2001,    -1,  2003,  2004,    -1,    -1,   395,   396,
     397,    -1,   399,   400,   401,   402,   403,   404,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2029,    -1,    -1,    -1,    -1,    -1,    -1,  2036,  2037,  2038,
      -1,    -1,    -1,    -1,    -1,  1136,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1147,    -1,    -1,    -1,
      -1,    -1,  2061,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2072,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1178,  1179,    -1,
      -1,    -1,    -1,    -1,    -1,  2094,    -1,    -1,    -1,  1190,
      -1,    -1,  1193,    -1,    -1,    -1,    -1,  1198,  1199,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2124,  2125,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2158,
    1251,    -1,  1253,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2169,    -1,  1263,    -1,    -1,  2174,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2186,    -1,  2188,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2202,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2224,    -1,    -1,    -1,    -1,
      -1,  2230,    -1,    -1,  2233,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2242,    -1,  2244,    -1,    -1,    -1,    -1,
    2249,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2257,  2258,
      -1,    -1,  2261,  2262,  2263,  2264,  2265,  2266,  2267,  2268,
    2269,  2270,    -1,    -1,    -1,    -1,  2275,  2276,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2284,    -1,    -1,    -1,    -1,
    2289,    -1,    -1,  2292,    -1,    -1,    -1,    -1,    -1,  1390,
      -1,    -1,    -1,    -1,    -1,  2304,  2305,  2306,    -1,  2308,
      -1,    -1,    -1,    -1,    -1,  2314,  2315,    -1,    -1,    -1,
      -1,  2320,    -1,    -1,  2323,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2332,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   675,   676,
      -1,   678,   679,    -1,    -1,    -1,    -1,   684,   685,  2358,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   703,   704,    -1,    -1,
      -1,    -1,    -1,   710,    -1,    -1,  1477,    -1,  1479,    -1,
      -1,    -1,  1483,    -1,   721,    -1,    -1,  1488,  1489,    -1,
      -1,    -1,    -1,    -1,    -1,  1496,    -1,    -1,    -1,    -1,
     139,   738,   739,    -1,    -1,  1506,    -1,  1508,   745,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   759,    -1,    -1,    -1,  1527,    -1,  1529,    -1,
      -1,    -1,    -1,  2442,    -1,    -1,    -1,    -1,   177,    -1,
      -1,    -1,    -1,    -1,  2453,   184,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    78,    -1,    -1,    -1,   802,    -1,    -1,    -1,    -1,
      -1,   808,    -1,    90,    -1,   214,   215,    -1,    -1,   816,
      97,    -1,    -1,    -1,    -1,   102,    -1,    -1,    -1,  2498,
      -1,    -1,    -1,    -1,  1595,    -1,    -1,    -1,    -1,  2508,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   844,    -1,    -1,
      -1,    -1,   849,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   861,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2558,
      -1,    -1,    -1,  2562,  2563,  2564,    -1,    -1,  2567,    -1,
      -1,    -1,    -1,    -1,  1665,    -1,    -1,    -1,    -1,    -1,
    1671,    -1,  2581,    -1,    -1,    -1,  2585,    -1,    -1,  1680,
    2589,   198,    -1,    -1,    -1,   202,  2595,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   220,   221,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   231,    -1,    -1,    -1,    -1,   956,
      -1,  1722,    -1,    -1,  1725,  1726,    -1,    -1,    -1,   966,
     967,    -1,    -1,    -1,   971,    -1,    -1,    -1,   255,  2648,
      -1,   258,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1752,   269,    -1,   271,    -1,    -1,   994,  1759,    -1,
      -1,  1762,    -1,    -1,    -1,  1766,    -1,    -1,  2677,    -1,
      -1,    -1,    -1,  1774,    -1,    -1,  1013,  1014,  1779,  1016,
      -1,  1018,    -1,  1020,    -1,    -1,    -1,    -1,    -1,    -1,
    1791,    -1,    -1,    -1,    -1,  1032,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   323,    -1,    -1,  2718,
      -1,    -1,    -1,  1814,    -1,    -1,    -1,    -1,  2727,    -1,
    2729,    -1,    -1,    -1,   341,    -1,  2735,  1064,    -1,    -1,
    2739,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2750,    -1,    -1,    -1,    -1,  2755,    -1,    -1,    -1,
    2759,    -1,    -1,    -1,    -1,    -1,  2765,  2766,    -1,    -1,
    2769,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   385,    -1,
      -1,    -1,    -1,  1874,    -1,    -1,    -1,    78,   395,   396,
     397,  2790,   399,   400,   401,   402,   403,   404,    -1,    90,
      -1,    -1,    -1,    -1,    -1,    -1,    97,    -1,    -1,    -1,
      -1,   102,    -1,    -1,  2813,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2835,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2845,    -1,    -1,    -1,
    2849,    -1,    -1,    -1,    -1,  2854,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   827,    -1,    -1,    -1,    -1,    -1,    -1,
    1207,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2889,    -1,    -1,    -1,  2893,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   198,    -1,    -1,
      -1,   202,    -1,    -1,  2913,    -1,    -1,    -1,    -1,    -1,
      -1,  2012,    -1,    -1,    -1,    -1,    -1,  2018,    -1,   220,
     221,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     231,    -1,    -1,    -1,    -1,    -1,   675,   676,    -1,   678,
     679,    -1,    -1,    -1,    -1,   684,   685,    -1,    -1,  2958,
      -1,    -1,    -1,    -1,   255,    -1,    -1,   258,    -1,    -1,
      -1,    -1,    -1,    -1,   703,   704,    -1,    -1,   269,  2978,
     271,   710,    -1,    -1,    -1,    -1,    -1,  1314,    -1,    -1,
      -1,    -1,   721,    -1,  2085,    -1,    -1,    -1,    -1,    -1,
    2091,  2092,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   738,
     739,    -1,  3011,    -1,    -1,  3014,   745,    -1,    -1,    -1,
    2111,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     759,    -1,   323,    -1,  2125,    -1,    -1,    -1,    -1,  2130,
      -1,  2132,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2142,  2143,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   802,    -1,    -1,    -1,    -1,    -1,   808,
      -1,    -1,  1409,  1410,    -1,    -1,    -1,   816,  1415,    -1,
      -1,    -1,    -1,    -1,   385,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   395,   396,   397,    -1,   399,   400,
     401,   402,   403,   404,  1441,   844,    -1,  1444,    -1,    -1,
     849,    -1,    -1,    -1,    -1,    -1,    -1,  1454,    -1,  1083,
      -1,    -1,   861,    -1,    -1,    -1,  1463,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2240,
      -1,  1105,    -1,    -1,    -1,  2246,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1129,  1130,    -1,  1132,  1133,
    1134,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1150,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2298,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   956,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   966,   967,    -1,
    1567,    -1,   971,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   994,  1220,    -1,    -1,  1223,
    1224,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1013,  1014,    -1,  1016,    -1,  1018,
      -1,  1020,    -1,    -1,  1621,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1032,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2402,  2403,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2416,    -1,    -1,    -1,    -1,
    2421,  2422,  2423,  2424,  2425,  1064,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     5,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    20,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2472,    29,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    41,    42,    -1,    -1,    -1,    -1,
      47,    -1,    49,    50,    -1,    -1,    -1,    54,    55,    56,
      57,    58,    59,    60,    61,    62,    63,    64,    65,    66,
      67,    68,    69,    70,    71,    72,    73,    74,    75,    76,
      77,    -1,    -1,  1760,  1761,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1402,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   115,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1207,    -1,
      -1,    -1,    -1,  1810,    -1,    -1,    -1,    -1,  1815,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2600,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1472,    -1,
      -1,    -1,  1476,    -1,    -1,    -1,    -1,    -1,  2619,    -1,
      -1,    -1,  2623,  2624,   181,    -1,    -1,  2628,    -1,    -1,
      -1,  1495,    -1,    -1,    -1,  1499,    -1,  1501,    -1,  1503,
     197,    -1,    -1,    -1,    -1,    -1,  1510,  1511,    -1,    -1,
    1514,    -1,    -1,    -1,    -1,    -1,    -1,   214,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2673,    -1,    -1,  1314,  1540,  2678,    -1,    -1,
    1544,  2682,    -1,   240,  1548,    -1,   243,    -1,  1552,    -1,
      -1,  1555,  1556,  1557,  1558,  1559,  1560,  1561,  1562,  1563,
    1564,    -1,   259,    -1,  1568,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   312,    -1,    -1,  1995,    -1,
      -1,    -1,    -1,    -1,  2001,    -1,    -1,    -1,    -1,    -1,
    1409,  1410,    -1,    -1,    -1,    -1,  1415,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   344,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   356,
      -1,    -1,  1441,    -1,    -1,  1444,    -1,    -1,    -1,    -1,
      -1,   368,    -1,    -1,    -1,  1454,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   380,  1463,    -1,   383,   384,    -1,   386,
      -1,   388,    -1,    -1,    -1,   392,    -1,   394,   395,  1703,
      -1,    -1,   399,   400,   401,   402,   403,    -1,    -1,   406,
     407,   408,   409,    -1,   411,   412,   413,   414,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2894,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1770,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2916,  2917,  2154,    -1,    -1,
      -1,    -1,    -1,  2160,    -1,    -1,    -1,    -1,  1567,    -1,
      -1,    -1,    -1,    -1,  2171,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2956,  2957,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2202,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1621,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1858,    -1,    -1,    -1,  2235,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1875,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1909,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1925,    -1,  1927,  1928,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1936,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2330,  2331,  2332,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1975,    -1,  1977,    -1,    -1,    -1,  1981,    -1,    -1,
      -1,  1760,  1761,    -1,    -1,    -1,    -1,    -1,   675,    -1,
      -1,    -1,   679,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   704,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2029,    -1,    -1,    -1,    -1,
      -1,  1810,  2036,  2037,  2038,    -1,  1815,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2428,   739,    -1,    -1,    -1,    -1,  2061,   745,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2448,    -1,    -1,    -1,    -1,    -1,    -1,  2455,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     827,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2569,  2570,  2571,  2572,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2581,    -1,    -1,    -1,  2585,    -1,
      -1,    -1,  2589,    -1,    -1,    -1,  1995,    -1,    -1,    -1,
    2224,    -1,  2001,    -1,    -1,    -1,  2230,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2242,    -1,
    2244,    -1,    -1,    -1,    -1,  2249,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2275,  2276,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     967,    -1,    -1,    -1,   971,    -1,    -1,    -1,  2292,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   985,    -1,
    2677,    -1,  2306,    -1,  2308,    -1,    -1,    -1,    -1,    -1,
      -1,  2315,    -1,    -1,    -1,    -1,  2320,    -1,    -1,  2323,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1018,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1028,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2358,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2750,    -1,  2154,    -1,    -1,  2755,    -1,
      -1,  2160,  2759,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2171,    -1,    -1,    -1,  1083,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2790,    -1,  2792,    -1,    -1,  1105,    -1,
      -1,    -1,    -1,  2202,    -1,    -1,    -1,    -1,    -1,    -1,
    2807,    -1,    -1,    -1,    -1,  2812,    -1,    -1,    -1,  2816,
      -1,    -1,  1129,  1130,    -1,  1132,  1133,  1134,    -1,    -1,
      -1,    -1,    -1,  2830,    -1,    -1,  2235,    -1,    -1,    -1,
      -1,    -1,    -1,  1150,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2849,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2861,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2498,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2508,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2889,  2890,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1220,    -1,    -1,  1223,  1224,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2330,  2331,  2332,    -1,  2932,    -1,    -1,    -1,  2563,
    2564,    -1,    -1,  2567,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2966,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1287,  2978,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1297,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3011,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2648,    -1,    -1,    -1,    -1,  2428,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1348,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2448,
      -1,    -1,    -1,    -1,    -1,    -1,  2455,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1373,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2718,  1402,    -1,  1404,    -1,    -1,
      -1,  1408,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2739,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1441,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2766,    -1,    -1,  2769,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1464,  1465,    -1,
      -1,    -1,    -1,    -1,    -1,  1472,    -1,    -1,  1475,  1476,
    2569,  2570,  2571,  2572,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2581,    -1,    -1,    -1,  2585,    -1,  1495,  2813,
    2589,    -1,  1499,  1500,  1501,    -1,  1503,    -1,    -1,    -1,
      -1,    -1,    -1,  1510,  1511,    -1,    -1,  1514,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2845,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1539,  1540,    -1,    -1,  1543,  1544,    -1,    -1,
      -1,  1548,    -1,    -1,    -1,  1552,    -1,    -1,  1555,  1556,
    1557,  1558,  1559,  1560,  1561,  1562,  1563,  1564,    -1,    -1,
      -1,  1568,    -1,    -1,    -1,  1572,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2677,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2913,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2750,    -1,    -1,    -1,    -1,  2755,    -1,    -1,    -1,
    2759,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2790,    -1,  2792,    -1,    -1,  1703,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1711,    -1,    -1,  1151,  2807,    -1,
      -1,    -1,    -1,  2812,    -1,    -1,    -1,  2816,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2830,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1756,
    2849,  1758,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2861,  1770,    -1,  1772,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2889,  2890,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1826,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2932,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1858,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2966,  1875,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2978,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1906,
    1907,  1908,  1909,  1910,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3011,    -1,    -1,    -1,    -1,    -1,  1925,  1926,
    1927,  1928,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1936,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1948,    -1,    -1,    -1,    -1,  1953,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1963,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1974,  1975,    -1,
    1977,    -1,    -1,    -1,  1981,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2001,    -1,  2003,  2004,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2029,    -1,    -1,    -1,  1470,    -1,    -1,  2036,
    2037,  2038,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1494,    -1,    -1,    -1,  2061,    -1,  1500,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2072,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1517,  1518,  1519,  1520,    -1,    -1,  1523,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2094,    -1,    -1,
      -1,    -1,    -1,    -1,  1538,    -1,    -1,    -1,    -1,  1543,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2125,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2158,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2169,    -1,    -1,    -1,    -1,  2174,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2186,
      -1,  2188,    -1,    -1,    -1,    -1,  1630,    -1,    -1,    -1,
      -1,    -1,  1636,    -1,  1638,  2202,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2224,    -1,    -1,
      -1,    -1,    -1,  2230,    -1,    -1,  2233,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2242,    -1,  2244,    -1,    -1,
      -1,    -1,  2249,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2257,  2258,    -1,    -1,  2261,  2262,  2263,  2264,  2265,  2266,
    2267,  2268,  2269,  2270,    -1,    -1,    -1,    -1,  2275,  2276,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2284,    -1,    -1,
      -1,    -1,  2289,    -1,    -1,  2292,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2304,  2305,  2306,
      -1,  2308,    -1,    -1,    -1,    -1,    -1,  2314,  2315,    -1,
      -1,    -1,    -1,  2320,    -1,    -1,  2323,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2332,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2358,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1824,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1869,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1878,  2442,  1880,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2453,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1899,    -1,    -1,    -1,    -1,
    1904,    -1,  1906,  1907,  1908,    -1,  1910,  1911,    -1,    -1,
      -1,    -1,  1916,  1917,    -1,    -1,    -1,    -1,    -1,    -1,
    1924,    -1,    -1,    -1,    -1,  1929,    -1,    -1,  1932,    -1,
      -1,  2498,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2508,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1958,    -1,    -1,  1961,  1962,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1973,
    1974,    -1,    -1,    -1,    -1,    -1,  1980,    -1,  1982,  1983,
    1984,  1985,  1986,  1987,  1988,  1989,  1990,  1991,    -1,    -1,
      -1,  2558,    -1,    -1,    -1,  2562,  2563,  2564,    -1,    -1,
    2567,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2581,    -1,    -1,    -1,  2585,    -1,
      -1,    -1,  2589,    -1,    -1,    -1,    -1,    -1,  2595,    -1,
      -1,    -1,    -1,    -1,     5,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    20,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    29,    -1,
      -1,    -1,    -1,    -1,    -1,  2069,    -1,    -1,    -1,    -1,
      41,    42,    -1,    -1,    -1,    -1,    -1,    -1,    49,    50,
      -1,  2648,    -1,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    -1,    -1,    -1,
    2677,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2126,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   115,    -1,    -1,    -1,    -1,    -1,
      -1,  2718,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2727,    -1,  2729,    -1,    -1,    -1,    -1,    -1,  2735,    -1,
      -1,    -1,  2739,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2750,    -1,    -1,    -1,    -1,  2755,    -1,
      -1,    -1,  2759,    -1,    -1,    -1,    -1,    -1,  2765,  2766,
      -1,    -1,  2769,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     181,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2790,    -1,  2229,   197,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   214,    -1,    -1,  2813,    -1,  2252,  2253,
    2254,  2255,  2256,    -1,  2258,    -1,    -1,  2261,  2262,  2263,
    2264,  2265,  2266,  2267,  2268,  2269,  2270,    -1,  2835,   240,
      -1,    -1,   243,    -1,    -1,    -1,    -1,    -1,  2845,    -1,
      -1,    -1,  2849,    -1,    -1,    -1,    -1,  2854,   259,    -1,
      -1,  2295,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2305,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2316,  2317,    -1,  2319,    -1,    -1,  2322,    -1,
      -1,    -1,  2889,    -1,    -1,    -1,  2893,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   312,    -1,    -1,    -1,    -1,  2913,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2376,   344,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   356,    -1,    -1,    -1,    -1,
      -1,  2958,    -1,    -1,    -1,    -1,    -1,   368,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   380,
      -1,  2978,   383,   384,    -1,   386,    -1,    -1,    -1,    -1,
      -1,   392,    -1,   394,   395,    -1,    -1,    -1,   399,   400,
     401,   402,   403,    -1,    -1,   406,   407,   408,  2442,    -1,
      -1,   412,    -1,    -1,  3011,    -1,    -1,  3014,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2505,    -1,    -1,    -1,  2509,    -1,    -1,    -1,    -1,
    2514,  2515,    -1,    -1,  2518,    -1,    -1,  2521,    -1,    -1,
      -1,  2525,  2526,  2527,  2528,  2529,  2530,  2531,  2532,  2533,
    2534,  2535,  2536,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2547,    -1,    -1,    -1,    -1,    -1,    -1,
    2554,  2555,    -1,  2557,    -1,    -1,    -1,  2561,  2562,    -1,
      -1,  2565,    -1,    -1,  2568,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2605,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2650,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2720,    -1,    -1,    -1,
      -1,    -1,    -1,  2727,    -1,  2729,    -1,    -1,    -1,    -1,
      -1,    -1,  2736,  2737,  2738,    -1,  2740,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2794,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2834,  2835,  2836,    -1,    -1,    -1,  2840,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2857,    -1,  2859,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2887,    -1,     5,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,  2902,    19,
      -1,    21,  2906,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,    35,    -1,    37,    38,    39,
      40,    41,    42,    -1,    44,    45,    46,    -1,    48,    49,
      50,    51,    52,    53,    -1,    -1,    -1,    57,    58,    -1,
      -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    72,    -1,    74,    -1,    76,    77,    -1,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    89,
      90,    91,    92,    93,    94,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,   105,    -1,   107,   108,   109,
      -1,   111,   112,   113,   114,   115,   116,   117,   118,   119,
     120,   121,   122,   123,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   138,   139,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,    -1,   155,   156,   157,   158,   159,
     160,   161,   162,   163,   164,   165,   166,   167,   168,   169,
     170,   171,   172,   173,   174,   175,    -1,   177,   178,   179,
     180,   181,   182,   183,   184,   185,   186,   187,   188,   189,
      -1,   191,   192,   193,   194,   195,   196,   197,   198,   199,
     200,   201,   202,   203,   204,   205,   206,   207,   208,   209,
     210,   211,   212,   213,   214,   215,   216,   217,   218,    -1,
     220,   221,   222,   223,   224,   225,   226,   227,   228,   229,
     230,   231,   232,   233,   234,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,   249,
     250,   251,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,    -1,   277,   278,   279,
     280,   281,    -1,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,    -1,   314,   315,   316,   317,   318,   319,
     320,   321,   322,   323,   324,   325,   326,   327,   328,   329,
     330,   331,   332,   333,   334,   335,   336,   337,   338,   339,
     340,   341,   342,   343,   344,   345,   346,   347,   348,   349,
     350,   351,   352,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,   364,   365,   366,   367,   368,   369,
     370,   371,   372,    -1,   374,   375,   376,   377,   378,   379,
     380,   381,    -1,   383,    -1,    -1,   386,    -1,    -1,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    20,    21,    -1,    23,    24,    25,    26,
      27,    28,   412,    30,    31,    32,    33,    -1,    35,    -1,
      37,    38,    39,    40,    -1,    42,    -1,    44,    45,    46,
      -1,    48,    49,    50,    51,    52,    53,    -1,    -1,    -1,
      57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,
      -1,    -1,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    89,    90,    91,    92,    93,    94,    95,    96,
      97,    98,    99,   100,   101,   102,   103,   104,   105,    -1,
     107,   108,   109,    -1,   111,   112,   113,   114,    -1,   116,
     117,   118,   119,   120,   121,   122,   123,   124,   125,   126,
     127,   128,   129,   130,   131,   132,   133,   134,   135,   136,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     147,   148,   149,   150,   151,   152,   153,    -1,   155,   156,
     157,   158,   159,   160,   161,   162,   163,   164,   165,   166,
     167,   168,   169,   170,   171,   172,   173,   174,   175,    -1,
     177,   178,   179,   180,   181,   182,   183,   184,   185,   186,
     187,   188,   189,    -1,   191,   192,   193,   194,   195,   196,
     197,   198,   199,   200,   201,   202,   203,   204,   205,   206,
     207,   208,   209,    -1,   211,   212,   213,    -1,   215,   216,
     217,   218,    -1,   220,   221,   222,   223,   224,   225,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,    -1,
     277,   278,   279,   280,   281,    -1,   283,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,    -1,   314,   315,   316,
     317,   318,   319,   320,   321,   322,   323,   324,   325,   326,
     327,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,   343,   344,   345,   346,
     347,   348,   349,   350,   351,   352,   353,   354,   355,   356,
     357,   358,   359,   360,   361,   362,   363,   364,   365,   366,
     367,   368,   369,   370,   371,   372,    -1,   374,   375,   376,
     377,   378,   379,   380,   381,    -1,   383,    -1,    -1,   386,
      -1,    -1,    -1,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    20,    21,    -1,
      23,    24,    25,    26,    27,    28,   413,    30,    31,    32,
      33,    -1,    35,    -1,    37,    38,    39,    40,    -1,    42,
      -1,    44,    45,    46,    -1,    48,    49,    50,    51,    52,
      53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,
      -1,    74,    -1,    76,    -1,    -1,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    89,    90,    91,    92,
      93,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,    -1,   107,   108,   109,    -1,   111,   112,
     113,   114,    -1,   116,   117,   118,   119,   120,   121,   122,
     123,   124,   125,   126,   127,   128,   129,   130,   131,   132,
     133,   134,   135,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,   151,   152,
     153,    -1,   155,   156,   157,   158,   159,   160,   161,   162,
     163,   164,   165,   166,   167,   168,   169,   170,   171,   172,
     173,   174,   175,    -1,   177,   178,   179,   180,   181,   182,
     183,   184,   185,   186,   187,   188,   189,    -1,   191,   192,
     193,   194,   195,   196,   197,   198,   199,   200,   201,   202,
     203,   204,   205,   206,   207,   208,   209,    -1,   211,   212,
     213,    -1,   215,   216,   217,   218,    -1,   220,   221,   222,
     223,   224,   225,   226,   227,   228,   229,   230,   231,   232,
     233,   234,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,   250,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,    -1,   277,   278,   279,   280,   281,    -1,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
      -1,   314,   315,   316,   317,   318,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,   347,   348,   349,   350,   351,   352,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
     363,   364,   365,   366,   367,   368,   369,   370,   371,   372,
      -1,   374,   375,   376,   377,   378,   379,   380,   381,    -1,
     383,    -1,    -1,   386,     3,    -1,    -1,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    20,    21,    22,    23,    24,    25,    26,    27,    28,
     413,    30,    31,    32,    33,    -1,    35,    -1,    37,    38,
      39,    40,    -1,    42,    -1,    44,    45,    46,    -1,    48,
      49,    50,    51,    52,    53,    -1,    -1,    -1,    57,    58,
      -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    72,    -1,    74,    -1,    76,    77,    -1,
      79,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    87,    88,
      89,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    97,    98,
      -1,    -1,   101,   102,   103,   104,   105,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   116,    -1,    -1,
     119,    -1,   121,   122,   123,    -1,    -1,   126,   127,    -1,
      -1,    -1,    -1,   132,   133,   134,    -1,    -1,   137,    -1,
      -1,    -1,    -1,    -1,    -1,   144,    -1,   146,   147,   148,
     149,    -1,    -1,    -1,    -1,    -1,   155,    -1,    -1,    -1,
      -1,    -1,    -1,   162,   163,    -1,    -1,    -1,    -1,   168,
      -1,    -1,    -1,    -1,   173,   174,   175,    -1,   177,    -1,
     179,    -1,   181,    -1,    -1,    -1,    -1,   186,    -1,   188,
      -1,   190,    -1,   192,    -1,    -1,    -1,    -1,    -1,   198,
      -1,    -1,    -1,   202,    -1,    -1,    -1,    -1,    -1,   208,
      -1,    -1,    -1,   212,    -1,    -1,   215,    -1,   217,    -1,
      -1,   220,   221,    -1,   223,    -1,    -1,    -1,    -1,    -1,
     229,    -1,   231,    -1,   233,   234,    -1,    -1,   237,    -1,
      -1,    -1,    -1,    -1,    -1,   244,    -1,    -1,   247,   248,
      -1,    -1,    -1,    -1,    -1,   254,    -1,    -1,   257,   258,
      -1,   260,   261,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   274,   275,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   283,    -1,    -1,   286,    -1,    -1,
      -1,    -1,    -1,    -1,   293,    -1,    -1,   296,    -1,    -1,
      -1,   300,    -1,    -1,    -1,   304,   305,   306,   307,    -1,
      -1,    -1,    -1,    -1,    -1,   314,    -1,    -1,    -1,    -1,
     319,   320,    -1,   322,   323,    -1,   325,    -1,    -1,   328,
      -1,    -1,    -1,    -1,    -1,    -1,   335,    -1,    -1,    -1,
      -1,    -1,    -1,   342,   343,    -1,    -1,    -1,    -1,   348,
      -1,   350,    -1,   352,    -1,   354,    -1,   356,    -1,    -1,
     359,    -1,   361,    -1,    -1,    -1,   365,    -1,    -1,   368,
      -1,   370,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   383,    -1,    -1,   386,    -1,    -1,
      -1,    -1,     5,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,   408,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    -1,    37,    38,    39,    40,    41,    42,
      -1,    44,    45,    46,    -1,    48,    49,    50,    51,    52,
      53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,
      -1,    74,    -1,    76,    77,    -1,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    -1,    -1,    -1,    -1,    92,
      -1,    -1,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,    -1,   108,   109,    -1,   111,   112,
     113,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
     123,    -1,    -1,   126,   127,   128,    -1,   130,   131,   132,
     133,    -1,   135,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,    -1,   151,    -1,
     153,    -1,   155,   156,   157,    -1,   159,    -1,   161,   162,
     163,   164,    -1,   166,   167,    -1,   169,    -1,   171,   172,
     173,   174,   175,    -1,   177,   178,   179,   180,   181,    -1,
     183,    -1,   185,   186,    -1,   188,   189,    -1,   191,    -1,
      -1,   194,    -1,   196,   197,   198,   199,   200,   201,   202,
     203,   204,   205,   206,    -1,   208,   209,    -1,   211,   212,
     213,   214,   215,    -1,   217,    -1,    -1,   220,   221,   222,
     223,   224,   225,   226,   227,    -1,   229,   230,   231,    -1,
     233,   234,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,   250,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
      -1,    -1,   265,   266,    -1,    -1,   269,   270,    -1,    -1,
     273,   274,   275,   276,   277,   278,   279,   280,   281,    -1,
     283,   284,   285,   286,    -1,   288,   289,   290,   291,   292,
     293,   294,    -1,   296,   297,   298,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
      -1,    -1,   315,   316,   317,   318,   319,   320,   321,   322,
     323,   324,   325,    -1,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,    -1,   338,   339,   340,    -1,   342,
     343,    -1,   345,    -1,   347,   348,   349,   350,   351,   352,
     353,   354,   355,    -1,   357,   358,   359,   360,   361,   362,
     363,    -1,   365,   366,   367,   368,   369,   370,   371,   372,
      -1,    -1,    -1,   376,   377,   378,   379,   380,   381,    -1,
     383,   384,   385,   386,   387,    -1,    -1,   390,   391,   392,
     393,   394,    -1,    -1,    -1,    -1,   399,   400,   401,    -1,
     403,   404,    -1,    -1,    -1,   408,   409,     5,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    35,    -1,    37,
      38,    39,    40,    41,    42,    -1,    44,    45,    46,    -1,
      48,    49,    50,    51,    52,    53,    -1,    -1,    -1,    57,
      58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,    77,
      -1,    79,    80,    81,    82,    83,    84,    85,    -1,    87,
      -1,    -1,    -1,    -1,    92,    -1,    -1,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,   105,   106,    -1,
     108,   109,    -1,   111,   112,   113,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,   123,    -1,    -1,   126,   127,
     128,    -1,   130,   131,   132,   133,    -1,   135,   136,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,    -1,   151,    -1,   153,    -1,   155,   156,   157,
      -1,    -1,    -1,   161,   162,   163,   164,    -1,   166,   167,
      -1,   169,    -1,   171,   172,   173,   174,   175,    -1,   177,
     178,   179,   180,   181,    -1,   183,    -1,   185,   186,    -1,
     188,   189,    -1,   191,    -1,    -1,   194,    -1,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,   206,    -1,
     208,   209,    -1,   211,   212,   213,   214,   215,    -1,   217,
      -1,    -1,   220,   221,   222,   223,   224,   225,   226,   227,
      -1,   229,   230,   231,    -1,   233,   234,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,   249,   250,   251,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,    -1,    -1,   265,   266,    -1,
      -1,   269,   270,    -1,    -1,   273,   274,   275,   276,   277,
     278,   279,   280,   281,    -1,   283,   284,   285,   286,    -1,
     288,   289,   290,   291,   292,   293,   294,    -1,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,    -1,    -1,   315,   316,   317,
     318,   319,   320,   321,   322,   323,   324,   325,    -1,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,    -1,
     338,   339,   340,    -1,   342,   343,    -1,   345,    -1,   347,
     348,   349,   350,   351,   352,   353,   354,   355,    -1,   357,
     358,   359,   360,   361,   362,   363,    -1,   365,   366,   367,
     368,   369,   370,   371,   372,    -1,    -1,    -1,   376,   377,
     378,   379,   380,   381,    -1,   383,   384,   385,   386,   387,
      -1,    -1,   390,   391,   392,   393,   394,    -1,    -1,    -1,
      -1,   399,   400,    -1,    -1,   403,   404,    -1,    -1,    -1,
     408,   409,     5,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    -1,    37,    38,    39,    40,    41,    42,
      -1,    44,    45,    46,    -1,    48,    49,    50,    51,    52,
      53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,
      -1,    74,    -1,    76,    77,    -1,    79,    80,    81,    82,
      83,    84,    85,    -1,    87,    -1,    -1,    -1,    -1,    92,
      -1,    -1,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,    -1,   108,   109,    -1,   111,   112,
     113,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
     123,    -1,    -1,   126,   127,   128,    -1,   130,   131,   132,
     133,    -1,   135,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,    -1,   151,    -1,
     153,    -1,   155,   156,   157,    -1,    -1,    -1,   161,   162,
     163,   164,    -1,   166,   167,    -1,   169,    -1,   171,   172,
     173,   174,   175,    -1,   177,   178,   179,   180,   181,    -1,
     183,    -1,   185,   186,    -1,   188,   189,    -1,   191,    -1,
      -1,   194,    -1,   196,   197,   198,   199,   200,   201,   202,
     203,   204,   205,   206,    -1,   208,   209,    -1,   211,   212,
     213,   214,   215,    -1,   217,    -1,    -1,   220,   221,   222,
     223,   224,   225,   226,   227,    -1,   229,   230,   231,    -1,
     233,   234,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,   250,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
      -1,    -1,   265,   266,    -1,    -1,   269,   270,    -1,    -1,
     273,   274,   275,   276,   277,   278,   279,   280,   281,    -1,
     283,   284,   285,   286,    -1,   288,   289,   290,   291,   292,
     293,   294,    -1,   296,   297,   298,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
      -1,    -1,   315,   316,   317,   318,   319,   320,   321,   322,
     323,   324,   325,    -1,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,    -1,   338,   339,   340,    -1,   342,
     343,    -1,   345,    -1,   347,   348,   349,   350,   351,   352,
     353,   354,   355,    -1,   357,   358,   359,   360,   361,   362,
     363,    -1,   365,   366,   367,   368,   369,   370,   371,   372,
      -1,    -1,    -1,   376,   377,   378,   379,   380,   381,    -1,
     383,   384,   385,   386,   387,    -1,    -1,   390,   391,   392,
     393,   394,    -1,    -1,    -1,    -1,   399,   400,    -1,    -1,
     403,   404,    -1,    -1,    -1,   408,   409,     5,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    35,    -1,    37,
      38,    39,    40,    41,    42,    -1,    44,    45,    46,    -1,
      48,    49,    50,    51,    52,    53,    -1,    -1,    -1,    57,
      58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,    77,
      -1,    79,    80,    81,    82,    83,    84,    85,    -1,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,
      -1,    99,   100,   101,    -1,   103,    -1,   105,   106,    -1,
     108,   109,    -1,   111,    -1,    -1,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,    -1,    -1,    -1,   126,   127,
     128,    -1,   130,   131,    -1,   133,    -1,   135,   136,    -1,
      -1,    -1,    -1,    -1,   142,   143,   144,   145,   146,   147,
     148,   149,    -1,   151,    -1,   153,    -1,   155,   156,   157,
      -1,    -1,    -1,   161,   162,   163,   164,    -1,   166,   167,
      -1,   169,    -1,   171,   172,   173,    -1,   175,    -1,    -1,
      -1,   179,   180,   181,    -1,   183,    -1,   185,    -1,    -1,
      -1,   189,    -1,   191,    -1,    -1,   194,    -1,   196,   197,
      -1,   199,   200,   201,   202,   203,   204,   205,   206,    -1,
      -1,   209,    -1,   211,   212,   213,   214,   215,    -1,   217,
      -1,    -1,    -1,    -1,   222,    -1,   224,   225,   226,   227,
      -1,    -1,   230,    -1,    -1,   233,   234,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,    -1,
     248,    -1,   250,   251,   252,   253,    -1,    -1,   256,   257,
      -1,    -1,    -1,   261,   262,    -1,    -1,   265,    -1,    -1,
      -1,   269,   270,    -1,    -1,   273,    -1,    -1,    -1,   277,
     278,   279,   280,   281,    -1,    -1,   284,   285,   286,    -1,
     288,   289,   290,   291,   292,   293,   294,    -1,   296,   297,
     298,   299,   300,   301,   302,   303,   304,    -1,   306,    -1,
     308,   309,   310,   311,   312,    -1,    -1,   315,   316,   317,
      -1,   319,   320,   321,   322,    -1,   324,   325,    -1,   327,
     328,   329,   330,   331,   332,   333,   334,    -1,   336,    -1,
     338,   339,   340,    -1,   342,   343,    -1,   345,    -1,   347,
      -1,   349,    -1,    -1,   352,   353,   354,   355,    -1,    -1,
     358,   359,   360,   361,   362,    -1,    -1,   365,   366,   367,
     368,   369,     5,   371,   372,    -1,    -1,    -1,   376,   377,
     378,   379,   380,   381,    -1,   383,    -1,    20,   386,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    29,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    41,    42,
      -1,   409,    -1,    -1,    -1,    -1,    49,    50,    -1,    -1,
      -1,    54,    55,    56,    57,    58,    59,    60,    61,    62,
      63,    64,    65,    66,    67,    68,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    -1,    -1,     5,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    20,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    29,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   115,    41,    42,    -1,    -1,    -1,    -1,    -1,
      -1,    49,    50,    -1,    -1,    -1,    54,    55,    56,    57,
      58,    59,    60,    61,    62,    63,    64,    65,    66,    67,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   181,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   115,    -1,    -1,
      -1,    -1,    -1,    -1,   197,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   214,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   240,    -1,    -1,
     243,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   181,    -1,    -1,   259,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   197,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   214,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   312,
      -1,    -1,   240,    -1,    -1,   243,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   259,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   344,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   356,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   368,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   380,    -1,    -1,
     383,   384,    -1,   386,   312,    -1,    -1,    -1,    -1,   392,
      -1,   394,   395,    -1,    -1,    -1,   399,   400,   401,   402,
     403,    -1,    -1,   406,   407,   408,   409,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   344,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   356,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     368,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   380,    -1,    -1,   383,   384,    -1,   386,    -1,
      -1,    -1,    -1,    -1,   392,    -1,   394,   395,    -1,    -1,
      -1,   399,   400,   401,   402,   403,    -1,    -1,   406,   407,
     408,   409,     5,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    -1,    37,    38,    39,    40,    41,    42,
      -1,    44,    45,    46,    -1,    48,    49,    50,    51,    52,
      53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,
      -1,    74,    -1,    76,    77,    -1,    79,    80,    81,    82,
      83,    84,    85,    -1,    87,    -1,    -1,    -1,    -1,    92,
      -1,    -1,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,   108,   109,    -1,   111,   112,
     113,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
     123,    -1,    -1,   126,   127,   128,    -1,   130,   131,   132,
     133,    -1,   135,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,    -1,   151,    -1,
     153,    -1,   155,   156,   157,    -1,    -1,    -1,   161,   162,
     163,   164,    -1,   166,   167,    -1,   169,    -1,   171,   172,
     173,   174,   175,    -1,   177,   178,   179,   180,   181,    -1,
     183,    -1,   185,   186,   187,   188,   189,    -1,   191,    -1,
      -1,   194,    -1,   196,   197,   198,   199,   200,   201,   202,
     203,   204,   205,   206,    -1,   208,   209,    -1,   211,   212,
     213,   214,   215,    -1,   217,    -1,    -1,   220,   221,   222,
     223,   224,   225,   226,   227,   228,   229,   230,   231,    -1,
     233,   234,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,   250,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
      -1,    -1,   265,   266,    -1,    -1,   269,   270,    -1,    -1,
     273,   274,   275,   276,   277,   278,   279,   280,   281,    -1,
     283,   284,   285,   286,    -1,   288,   289,   290,   291,   292,
     293,   294,    -1,   296,   297,   298,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
      -1,    -1,   315,   316,   317,   318,   319,   320,   321,   322,
     323,   324,   325,    -1,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,    -1,   338,   339,   340,    -1,   342,
     343,    -1,   345,   346,   347,   348,   349,   350,   351,   352,
     353,   354,   355,    -1,   357,   358,   359,   360,   361,   362,
     363,    -1,   365,   366,   367,   368,   369,   370,   371,   372,
      -1,    -1,    -1,   376,   377,   378,   379,   380,   381,    -1,
     383,   384,   385,   386,   387,    -1,    -1,   390,   391,   392,
     393,   394,    -1,    -1,    -1,    -1,   399,   400,    -1,    -1,
     403,   404,    -1,    -1,    -1,   408,     5,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    35,    -1,    37,    38,
      39,    40,    41,    42,    -1,    44,    45,    46,    -1,    48,
      49,    50,    51,    52,    53,    -1,    -1,    -1,    57,    58,
      -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    72,    -1,    74,    -1,    76,    77,    -1,
      79,    80,    81,    82,    83,    84,    85,    -1,    87,    -1,
      -1,    -1,    -1,    92,    -1,    -1,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,   106,    -1,   108,
     109,    -1,   111,   112,   113,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,   123,    -1,    -1,   126,   127,   128,
      -1,   130,   131,   132,   133,    -1,   135,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,   150,   151,    -1,   153,    -1,   155,   156,   157,    -1,
      -1,    -1,   161,   162,   163,   164,    -1,   166,   167,    -1,
     169,    -1,   171,   172,   173,   174,   175,    -1,   177,   178,
     179,   180,   181,    -1,   183,    -1,   185,   186,    -1,   188,
     189,    -1,   191,    -1,    -1,   194,    -1,   196,   197,   198,
     199,   200,   201,   202,   203,   204,   205,   206,    -1,   208,
     209,    -1,   211,   212,   213,   214,   215,    -1,   217,    -1,
      -1,   220,   221,   222,   223,   224,   225,   226,   227,    -1,
     229,   230,   231,    -1,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
     249,   250,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,    -1,    -1,   265,   266,    -1,    -1,
     269,   270,    -1,    -1,   273,   274,   275,   276,   277,   278,
     279,   280,   281,    -1,   283,   284,   285,   286,    -1,   288,
     289,   290,   291,   292,   293,   294,    -1,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,    -1,    -1,   315,   316,   317,   318,
     319,   320,   321,   322,   323,   324,   325,    -1,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,    -1,   338,
     339,   340,    -1,   342,   343,    -1,   345,    -1,   347,   348,
     349,   350,   351,   352,   353,   354,   355,    -1,   357,   358,
     359,   360,   361,   362,   363,    -1,   365,   366,   367,   368,
     369,   370,   371,   372,    -1,    -1,    -1,   376,   377,   378,
     379,   380,   381,    -1,   383,   384,   385,   386,   387,    -1,
      -1,   390,   391,   392,   393,   394,    -1,    -1,    -1,    -1,
     399,   400,   401,    -1,   403,   404,    -1,    -1,    -1,   408,
       5,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    -1,    37,    38,    39,    40,    41,    42,    -1,    44,
      45,    46,    -1,    48,    49,    50,    51,    52,    53,    -1,
      -1,    -1,    57,    58,    -1,    -1,    -1,    -1,    63,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    74,
      -1,    76,    77,    -1,    79,    80,    81,    82,    83,    84,
      85,    -1,    87,    -1,    -1,    -1,    -1,    92,    -1,    -1,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,    -1,   108,   109,    -1,   111,   112,   113,   114,
     115,   116,   117,    -1,   119,   120,   121,   122,   123,    -1,
      -1,   126,   127,   128,    -1,   130,   131,   132,   133,    -1,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,    -1,   151,    -1,   153,    -1,
     155,   156,   157,    -1,    -1,    -1,   161,   162,   163,   164,
      -1,   166,   167,    -1,   169,    -1,   171,   172,   173,   174,
     175,    -1,   177,   178,   179,   180,   181,    -1,   183,    -1,
     185,   186,    -1,   188,   189,    -1,   191,    -1,    -1,   194,
      -1,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,    -1,   208,   209,    -1,   211,   212,   213,   214,
     215,    -1,   217,    -1,    -1,   220,   221,   222,   223,   224,
     225,   226,   227,    -1,   229,   230,   231,    -1,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,    -1,    -1,
     265,   266,    -1,    -1,   269,   270,    -1,    -1,   273,   274,
     275,   276,   277,   278,   279,   280,   281,    -1,   283,   284,
     285,   286,    -1,   288,   289,   290,   291,   292,   293,   294,
      -1,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,    -1,    -1,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,    -1,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,    -1,   338,   339,   340,    -1,   342,   343,    -1,
     345,    -1,   347,   348,   349,   350,   351,   352,   353,   354,
     355,    -1,   357,   358,   359,   360,   361,   362,   363,    -1,
     365,   366,   367,   368,   369,   370,   371,   372,    -1,    -1,
      -1,   376,   377,   378,   379,   380,   381,    -1,   383,   384,
     385,   386,   387,    -1,    -1,   390,   391,   392,   393,   394,
      -1,    -1,    -1,    -1,   399,   400,   401,    -1,   403,   404,
      -1,    -1,    -1,   408,     5,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,    -1,    37,    38,    39,    40,
      41,    42,    -1,    44,    45,    46,    -1,    48,    49,    50,
      51,    52,    53,    -1,    -1,    -1,    57,    58,    -1,    -1,
      -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    72,    -1,    74,    -1,    76,    77,    -1,    79,    80,
      81,    82,    83,    84,    85,    -1,    87,    -1,    -1,    -1,
      -1,    92,    -1,    -1,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,   105,   106,    -1,   108,   109,    -1,
     111,   112,   113,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,   123,    -1,    -1,   126,   127,   128,    -1,   130,
     131,   132,   133,    -1,   135,   136,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,   149,    -1,
     151,    -1,   153,    -1,   155,   156,   157,    -1,    -1,    -1,
     161,   162,   163,   164,    -1,   166,   167,    -1,   169,    -1,
     171,   172,   173,   174,   175,    -1,   177,   178,   179,   180,
     181,    -1,   183,    -1,   185,   186,    -1,   188,   189,    -1,
     191,    -1,    -1,   194,    -1,   196,   197,   198,   199,   200,
     201,   202,   203,   204,   205,   206,    -1,   208,   209,    -1,
     211,   212,   213,   214,   215,    -1,   217,    -1,    -1,   220,
     221,   222,   223,   224,   225,   226,   227,    -1,   229,   230,
     231,    -1,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,   249,   250,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,    -1,    -1,   265,   266,    -1,    -1,   269,   270,
      -1,    -1,   273,   274,   275,   276,   277,   278,   279,   280,
     281,    -1,   283,   284,   285,   286,    -1,   288,   289,   290,
     291,   292,   293,   294,    -1,   296,   297,   298,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,    -1,   314,   315,   316,   317,   318,   319,   320,
     321,   322,   323,   324,   325,    -1,   327,   328,   329,   330,
     331,   332,   333,   334,   335,   336,    -1,   338,   339,   340,
      -1,   342,   343,    -1,   345,    -1,   347,   348,   349,   350,
     351,   352,   353,   354,   355,    -1,   357,   358,   359,   360,
     361,   362,   363,    -1,   365,   366,   367,   368,   369,   370,
     371,   372,    -1,    -1,    -1,   376,   377,   378,   379,   380,
     381,    -1,   383,   384,   385,   386,   387,    -1,    -1,   390,
     391,   392,   393,   394,    -1,    -1,    -1,    -1,   399,   400,
      -1,    -1,   403,   404,    -1,    -1,    -1,   408,     5,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    35,    -1,
      37,    38,    39,    40,    41,    42,    -1,    44,    45,    46,
      -1,    48,    49,    50,    51,    52,    53,    -1,    -1,    -1,
      57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,
      77,    -1,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    -1,    -1,    -1,    -1,    92,    -1,    -1,    95,    96,
      97,    98,    99,   100,   101,   102,   103,   104,   105,   106,
      -1,   108,   109,    -1,   111,   112,   113,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     147,   148,   149,    -1,   151,    -1,   153,    -1,   155,   156,
     157,    -1,    -1,    -1,   161,   162,   163,   164,    -1,   166,
     167,    -1,   169,    -1,   171,   172,   173,   174,   175,    -1,
     177,   178,   179,   180,   181,    -1,   183,    -1,   185,   186,
      -1,   188,   189,    -1,   191,    -1,    -1,   194,    -1,   196,
     197,   198,   199,   200,   201,   202,   203,   204,   205,   206,
      -1,   208,   209,    -1,   211,   212,   213,   214,   215,    -1,
     217,    -1,    -1,   220,   221,   222,   223,   224,   225,   226,
     227,    -1,   229,   230,   231,    -1,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,    -1,    -1,   265,   266,
      -1,    -1,   269,   270,    -1,    -1,   273,   274,   275,   276,
     277,   278,   279,   280,   281,    -1,   283,   284,   285,   286,
      -1,   288,   289,   290,   291,   292,   293,   294,    -1,   296,
     297,   298,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,    -1,    -1,   315,   316,
     317,   318,   319,   320,   321,   322,   323,   324,   325,    -1,
     327,   328,   329,   330,   331,   332,   333,   334,   335,   336,
      -1,   338,   339,   340,    -1,   342,   343,    -1,   345,    -1,
     347,   348,   349,   350,   351,   352,   353,   354,   355,    -1,
     357,   358,   359,   360,   361,   362,   363,    -1,   365,   366,
     367,   368,   369,   370,   371,   372,    -1,    -1,    -1,   376,
     377,   378,   379,   380,   381,    -1,   383,   384,   385,   386,
     387,    -1,    -1,   390,   391,   392,   393,   394,    -1,    -1,
      -1,    -1,   399,   400,    -1,    -1,   403,   404,    -1,    -1,
      -1,   408,     5,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    -1,    37,    38,    39,    40,    41,    42,
      -1,    44,    45,    46,    -1,    48,    49,    50,    51,    52,
      53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,
      -1,    74,    -1,    76,    77,    -1,    79,    80,    81,    82,
      83,    84,    85,    -1,    87,    -1,    -1,    -1,    -1,    92,
      -1,    -1,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,    -1,   108,   109,    -1,   111,   112,
     113,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
     123,    -1,    -1,   126,   127,   128,    -1,   130,   131,   132,
     133,    -1,   135,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,    -1,   151,    -1,
     153,    -1,   155,   156,   157,    -1,    -1,    -1,   161,   162,
     163,   164,    -1,   166,   167,    -1,   169,    -1,   171,   172,
     173,   174,   175,    -1,   177,   178,   179,   180,   181,    -1,
     183,    -1,   185,   186,    -1,   188,   189,    -1,   191,    -1,
      -1,   194,    -1,   196,   197,   198,   199,   200,   201,   202,
     203,   204,   205,   206,    -1,   208,   209,    -1,   211,   212,
     213,   214,   215,    -1,   217,    -1,    -1,   220,   221,   222,
     223,   224,   225,   226,   227,    -1,   229,   230,   231,    -1,
     233,   234,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,   250,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
      -1,    -1,   265,   266,    -1,    -1,   269,   270,    -1,    -1,
     273,   274,   275,   276,   277,   278,   279,   280,   281,    -1,
     283,   284,   285,   286,    -1,   288,   289,   290,   291,   292,
     293,   294,    -1,   296,   297,   298,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
      -1,    -1,   315,   316,   317,   318,   319,   320,   321,   322,
     323,   324,   325,    -1,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,    -1,   338,   339,   340,    -1,   342,
     343,    -1,   345,    -1,   347,   348,   349,   350,   351,   352,
     353,   354,   355,    -1,   357,   358,   359,   360,   361,   362,
     363,    -1,   365,   366,   367,   368,   369,   370,   371,   372,
      -1,    -1,    -1,   376,   377,   378,   379,   380,   381,    -1,
     383,   384,   385,   386,   387,    -1,    -1,   390,   391,   392,
     393,   394,    -1,    -1,    -1,    -1,   399,   400,    -1,    -1,
     403,   404,    -1,   406,    -1,   408,     5,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    35,    -1,    37,    38,
      39,    40,    41,    42,    -1,    44,    45,    46,    -1,    48,
      49,    50,    51,    52,    53,    -1,    -1,    -1,    57,    58,
      -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    72,    -1,    74,    -1,    76,    77,    -1,
      79,    80,    81,    82,    83,    84,    85,    -1,    87,    -1,
      -1,    -1,    -1,    92,    -1,    -1,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,   106,    -1,   108,
     109,    -1,   111,   112,   113,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,   123,    -1,    -1,   126,   127,   128,
      -1,   130,   131,   132,   133,    -1,   135,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,    -1,   151,    -1,   153,    -1,   155,   156,   157,    -1,
      -1,    -1,   161,   162,   163,   164,    -1,   166,   167,    -1,
     169,    -1,   171,   172,   173,   174,   175,    -1,   177,   178,
     179,   180,   181,    -1,   183,    -1,   185,   186,   187,   188,
     189,    -1,   191,    -1,    -1,   194,    -1,   196,   197,   198,
     199,   200,   201,   202,   203,   204,   205,   206,    -1,   208,
     209,    -1,   211,   212,   213,   214,   215,    -1,   217,    -1,
      -1,   220,   221,   222,   223,   224,   225,   226,   227,    -1,
     229,   230,   231,    -1,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
     249,   250,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,    -1,    -1,   265,   266,    -1,    -1,
     269,   270,    -1,    -1,   273,   274,   275,   276,   277,   278,
     279,   280,   281,    -1,   283,   284,   285,   286,    -1,   288,
     289,   290,   291,   292,   293,   294,    -1,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,    -1,    -1,   315,   316,   317,   318,
     319,   320,   321,   322,   323,   324,   325,    -1,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,    -1,   338,
     339,   340,    -1,   342,   343,    -1,   345,    -1,   347,   348,
     349,   350,   351,   352,   353,   354,   355,    -1,   357,   358,
     359,   360,   361,   362,   363,    -1,   365,   366,   367,   368,
     369,   370,   371,   372,    -1,    -1,    -1,   376,   377,   378,
     379,   380,   381,    -1,   383,   384,   385,   386,   387,    -1,
      -1,   390,   391,   392,   393,   394,    -1,    -1,    -1,    -1,
     399,   400,    -1,    -1,   403,   404,    -1,    -1,    -1,   408,
       5,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    -1,    37,    38,    39,    40,    41,    42,    -1,    44,
      45,    46,    -1,    48,    49,    50,    51,    52,    53,    -1,
      -1,    -1,    57,    58,    -1,    -1,    -1,    -1,    63,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    74,
      -1,    76,    77,    -1,    79,    80,    81,    82,    83,    84,
      85,    -1,    87,    -1,    -1,    -1,    -1,    92,    -1,    -1,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,    -1,   108,   109,    -1,   111,   112,   113,   114,
     115,   116,   117,    -1,   119,   120,   121,   122,   123,    -1,
      -1,   126,   127,   128,    -1,   130,   131,   132,   133,    -1,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,    -1,   153,    -1,
     155,   156,   157,    -1,    -1,    -1,   161,   162,   163,   164,
      -1,   166,   167,    -1,   169,    -1,   171,   172,   173,   174,
     175,    -1,   177,   178,   179,   180,   181,    -1,   183,    -1,
     185,   186,    -1,   188,   189,    -1,   191,    -1,    -1,   194,
      -1,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,    -1,   208,   209,    -1,   211,   212,   213,   214,
     215,    -1,   217,    -1,    -1,   220,   221,   222,   223,   224,
     225,   226,   227,    -1,   229,   230,   231,    -1,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,    -1,    -1,
     265,   266,    -1,    -1,   269,   270,    -1,    -1,   273,   274,
     275,   276,   277,   278,   279,   280,   281,    -1,   283,   284,
     285,   286,    -1,   288,   289,   290,   291,   292,   293,   294,
      -1,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,    -1,    -1,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,    -1,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,    -1,   338,   339,   340,    -1,   342,   343,    -1,
     345,    -1,   347,   348,   349,   350,   351,   352,   353,   354,
     355,    -1,   357,   358,   359,   360,   361,   362,   363,    -1,
     365,   366,   367,   368,   369,   370,   371,   372,    -1,    -1,
      -1,   376,   377,   378,   379,   380,   381,    -1,   383,   384,
     385,   386,   387,    -1,    -1,   390,   391,   392,   393,   394,
      -1,    -1,    -1,    -1,   399,   400,    -1,    -1,   403,   404,
      -1,    -1,    -1,   408,     5,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,    -1,    37,    38,    39,    40,
      41,    42,    -1,    44,    45,    46,    -1,    48,    49,    50,
      51,    52,    53,    -1,    -1,    -1,    57,    58,    -1,    -1,
      -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    72,    -1,    74,    -1,    76,    77,    -1,    79,    80,
      81,    82,    83,    84,    85,    -1,    87,    -1,    -1,    -1,
      -1,    92,    -1,    -1,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,   105,   106,    -1,   108,   109,    -1,
     111,   112,   113,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,   123,    -1,    -1,   126,   127,   128,    -1,   130,
     131,   132,   133,    -1,   135,   136,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,   149,    -1,
     151,    -1,   153,    -1,   155,   156,   157,    -1,    -1,    -1,
     161,   162,   163,   164,    -1,   166,   167,    -1,   169,    -1,
     171,   172,   173,   174,   175,    -1,   177,   178,   179,   180,
     181,    -1,   183,    -1,   185,   186,    -1,   188,   189,    -1,
     191,    -1,    -1,   194,    -1,   196,   197,   198,   199,   200,
     201,   202,   203,   204,   205,   206,    -1,   208,   209,    -1,
     211,   212,   213,   214,   215,    -1,   217,    -1,    -1,   220,
     221,   222,   223,   224,   225,   226,   227,    -1,   229,   230,
     231,    -1,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,   249,   250,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,    -1,    -1,   265,   266,    -1,    -1,   269,   270,
      -1,    -1,   273,   274,   275,   276,   277,   278,   279,   280,
     281,    -1,   283,   284,   285,   286,    -1,   288,   289,   290,
     291,   292,   293,   294,    -1,   296,   297,   298,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,    -1,    -1,   315,   316,   317,   318,   319,   320,
     321,   322,   323,   324,   325,    -1,   327,   328,   329,   330,
     331,   332,   333,   334,   335,   336,    -1,   338,   339,   340,
      -1,   342,   343,    -1,   345,    -1,   347,   348,   349,   350,
     351,   352,   353,   354,   355,    -1,   357,   358,   359,   360,
     361,   362,   363,    -1,   365,   366,   367,   368,   369,   370,
     371,   372,    -1,    -1,    -1,   376,   377,   378,   379,   380,
     381,    -1,   383,   384,   385,   386,   387,    -1,    -1,   390,
     391,   392,   393,   394,    -1,    -1,    -1,    -1,   399,   400,
      -1,    -1,   403,   404,    -1,    -1,    -1,   408,     5,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    35,    -1,
      37,    38,    39,    40,    41,    42,    -1,    44,    45,    46,
      -1,    48,    49,    50,    51,    52,    53,    -1,    -1,    -1,
      57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,
      77,    -1,    79,    80,    81,    82,    83,    84,    85,    -1,
      87,    -1,    -1,    -1,    -1,    92,    -1,    -1,    95,    96,
      97,    98,    99,   100,   101,   102,   103,   104,   105,   106,
      -1,   108,   109,    -1,   111,   112,   113,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     147,   148,   149,    -1,   151,    -1,   153,    -1,   155,   156,
     157,    -1,    -1,    -1,   161,   162,   163,   164,    -1,   166,
     167,    -1,   169,    -1,   171,   172,   173,   174,   175,    -1,
     177,   178,   179,   180,   181,    -1,   183,    -1,   185,   186,
      -1,   188,   189,    -1,   191,    -1,    -1,   194,    -1,   196,
     197,   198,   199,   200,   201,   202,   203,   204,   205,   206,
      -1,   208,   209,    -1,   211,   212,   213,   214,   215,    -1,
     217,    -1,    -1,   220,   221,   222,   223,   224,   225,   226,
     227,    -1,   229,   230,   231,    -1,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,    -1,   256,
     257,   258,   259,   260,   261,   262,    -1,    -1,   265,   266,
      -1,    -1,   269,   270,    -1,    -1,   273,   274,   275,   276,
     277,   278,   279,   280,   281,    -1,   283,   284,   285,   286,
      -1,   288,   289,   290,   291,   292,   293,   294,    -1,   296,
     297,   298,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,    -1,    -1,   315,   316,
     317,   318,   319,   320,   321,   322,   323,   324,   325,    -1,
     327,   328,   329,   330,   331,   332,   333,   334,   335,   336,
      -1,   338,   339,   340,    -1,   342,   343,    -1,   345,    -1,
     347,   348,   349,   350,   351,   352,   353,   354,   355,    -1,
      -1,   358,   359,   360,   361,   362,   363,    -1,   365,   366,
     367,   368,   369,   370,   371,   372,    -1,    -1,    -1,   376,
     377,   378,   379,   380,   381,    -1,   383,   384,   385,   386,
     387,    -1,    -1,   390,   391,   392,   393,   394,    -1,    -1,
      -1,    -1,    -1,   400,    -1,    -1,   403,   404,    -1,    -1,
      -1,   408,     5,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    -1,    37,    38,    39,    40,    41,    42,
      -1,    44,    45,    46,    -1,    48,    49,    50,    51,    52,
      53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,
      -1,    74,    -1,    76,    77,    -1,    79,    80,    81,    82,
      83,    84,    85,    -1,    87,    -1,    -1,    -1,    -1,    92,
      -1,    -1,    95,    96,    97,    98,    99,   100,   101,    -1,
     103,   104,   105,   106,    -1,   108,   109,    -1,   111,   112,
     113,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
     123,    -1,    -1,   126,   127,   128,    -1,   130,   131,   132,
     133,    -1,   135,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,    -1,   151,    -1,
     153,    -1,   155,   156,   157,    -1,    -1,    -1,   161,   162,
     163,   164,    -1,   166,   167,    -1,    -1,    -1,   171,   172,
     173,   174,   175,    -1,   177,   178,   179,   180,   181,    -1,
     183,    -1,   185,   186,    -1,   188,   189,    -1,   191,    -1,
      -1,   194,    -1,   196,   197,    -1,   199,   200,   201,    -1,
     203,   204,   205,   206,    -1,   208,   209,    -1,   211,   212,
     213,   214,   215,    -1,   217,    -1,    -1,   220,   221,   222,
     223,   224,   225,   226,   227,    -1,   229,   230,    -1,    -1,
     233,   234,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,   250,   251,   252,
     253,   254,    -1,   256,   257,   258,   259,   260,   261,   262,
      -1,    -1,   265,   266,    -1,    -1,   269,   270,    -1,    -1,
     273,   274,   275,   276,   277,   278,   279,   280,   281,    -1,
     283,   284,   285,   286,    -1,   288,   289,   290,   291,   292,
     293,   294,    -1,   296,   297,   298,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
      -1,    -1,   315,   316,   317,   318,   319,   320,   321,   322,
      -1,   324,   325,    -1,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,    -1,   338,   339,   340,    -1,   342,
     343,    -1,   345,    -1,   347,   348,   349,   350,   351,   352,
     353,   354,   355,    -1,   357,   358,   359,   360,   361,   362,
     363,    -1,   365,   366,   367,   368,   369,   370,   371,   372,
      -1,    -1,    -1,   376,   377,   378,   379,   380,   381,    -1,
     383,   384,   385,   386,   387,    -1,    -1,   390,   391,   392,
     393,   394,    -1,    -1,    -1,    -1,   399,   400,    -1,    -1,
     403,   404,    -1,    -1,    -1,   408,     5,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    35,    -1,    37,    38,
      39,    40,    41,    42,    -1,    44,    45,    46,    -1,    48,
      49,    50,    51,    52,    53,    -1,    -1,    -1,    57,    58,
      -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    72,    -1,    74,    -1,    76,    77,    -1,
      79,    80,    81,    82,    83,    84,    85,    -1,    87,    -1,
      -1,    -1,    -1,    92,    -1,    -1,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,   106,    -1,   108,
     109,    -1,   111,   112,   113,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,   123,    -1,    -1,   126,   127,   128,
      -1,   130,   131,   132,   133,    -1,   135,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,    -1,   151,    -1,   153,    -1,   155,   156,   157,    -1,
      -1,    -1,   161,   162,   163,   164,    -1,   166,   167,    -1,
     169,    -1,   171,   172,   173,   174,   175,    -1,   177,   178,
     179,   180,   181,    -1,   183,    -1,   185,   186,    -1,   188,
     189,    -1,   191,    -1,    -1,   194,    -1,   196,   197,   198,
     199,   200,   201,   202,   203,   204,   205,   206,    -1,   208,
     209,    -1,   211,   212,   213,   214,   215,    -1,   217,    -1,
      -1,   220,   221,   222,   223,   224,   225,   226,   227,    -1,
     229,   230,   231,    -1,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
     249,   250,   251,   252,   253,   254,    -1,   256,   257,   258,
     259,   260,   261,   262,    -1,    -1,   265,   266,    -1,    -1,
     269,   270,    -1,    -1,   273,   274,   275,   276,   277,   278,
     279,   280,   281,    -1,   283,   284,   285,   286,    -1,   288,
     289,   290,   291,   292,   293,   294,    -1,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,    -1,    -1,   315,   316,   317,   318,
     319,   320,   321,   322,   323,   324,   325,    -1,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,    -1,   338,
     339,   340,    -1,   342,   343,    -1,   345,    -1,   347,   348,
     349,   350,   351,   352,   353,   354,   355,    -1,    -1,   358,
     359,   360,   361,   362,   363,    -1,   365,   366,   367,   368,
     369,   370,   371,   372,    -1,    -1,    -1,   376,   377,   378,
     379,   380,   381,    -1,   383,   384,    -1,   386,   387,    -1,
      -1,   390,   391,   392,   393,   394,     5,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,   408,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    35,    -1,    37,    38,
      39,    40,    41,    42,    -1,    44,    45,    46,    -1,    48,
      49,    50,    51,    52,    53,    -1,    -1,    -1,    57,    58,
      -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    72,    -1,    74,    -1,    76,    77,    -1,
      79,    80,    81,    82,    83,    84,    85,    -1,    87,    -1,
      -1,    -1,    -1,    92,    -1,    -1,    95,    96,    97,    98,
      99,   100,   101,    -1,   103,   104,   105,   106,    -1,   108,
     109,    -1,   111,   112,   113,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,   123,    -1,    -1,   126,   127,   128,
      -1,   130,   131,   132,   133,    -1,   135,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,    -1,   151,    -1,   153,    -1,   155,   156,   157,    -1,
      -1,    -1,   161,   162,   163,   164,    -1,   166,   167,    -1,
      -1,    -1,   171,   172,   173,   174,   175,    -1,   177,   178,
     179,   180,   181,    -1,   183,    -1,   185,   186,    -1,   188,
     189,    -1,   191,    -1,    -1,   194,    -1,   196,   197,    -1,
     199,   200,   201,    -1,   203,   204,   205,   206,    -1,   208,
     209,    -1,   211,   212,   213,   214,   215,    -1,   217,    -1,
      -1,   220,   221,   222,   223,   224,   225,   226,   227,    -1,
     229,   230,    -1,    -1,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
     249,   250,   251,   252,   253,   254,    -1,   256,   257,   258,
     259,   260,   261,   262,    -1,    -1,   265,   266,    -1,    -1,
      -1,   270,    -1,    -1,   273,   274,   275,   276,   277,   278,
     279,   280,   281,    -1,   283,   284,   285,   286,    -1,   288,
     289,   290,   291,   292,   293,   294,    -1,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,    -1,    -1,   315,   316,   317,   318,
     319,   320,   321,   322,    -1,   324,   325,    -1,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,    -1,   338,
     339,   340,    -1,   342,   343,    -1,   345,    -1,   347,   348,
     349,   350,   351,   352,   353,   354,   355,    -1,    -1,   358,
     359,   360,   361,   362,   363,    -1,   365,   366,   367,   368,
     369,   370,   371,   372,    -1,    -1,    -1,   376,   377,   378,
     379,   380,   381,    -1,   383,   384,    -1,   386,   387,    -1,
      -1,   390,   391,   392,   393,   394,    -1,    -1,    -1,    -1,
      -1,   400,    -1,    -1,   403,   404,    -1,    -1,    -1,   408,
       5,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    -1,    37,    38,    39,    40,    41,    42,    -1,    44,
      45,    46,    -1,    48,    49,    50,    51,    52,    53,    -1,
      -1,    -1,    57,    58,    -1,    -1,    -1,    -1,    63,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    74,
      -1,    76,    77,    -1,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    -1,    -1,    -1,    91,    92,    -1,    -1,
      95,    96,    97,    98,    99,   100,   101,    -1,   103,   104,
     105,   106,    -1,   108,   109,    -1,   111,   112,   113,   114,
     115,   116,   117,    -1,   119,   120,   121,   122,   123,    -1,
      -1,   126,   127,   128,    -1,   130,   131,   132,   133,    -1,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,    -1,   151,    -1,   153,    -1,
     155,   156,   157,    -1,    -1,    -1,   161,   162,   163,   164,
      -1,   166,   167,    -1,    -1,    -1,   171,   172,   173,   174,
     175,    -1,   177,   178,   179,   180,   181,    -1,   183,    -1,
     185,   186,    -1,   188,   189,    -1,   191,    -1,    -1,   194,
      -1,   196,   197,    -1,   199,   200,   201,    -1,   203,   204,
     205,   206,    -1,   208,   209,    -1,   211,   212,   213,   214,
     215,    -1,   217,    -1,    -1,    -1,    -1,   222,   223,   224,
     225,   226,   227,    -1,   229,   230,    -1,    -1,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
      -1,   256,   257,    -1,   259,   260,   261,   262,    -1,    -1,
     265,   266,    -1,    -1,    -1,   270,    -1,    -1,   273,   274,
     275,   276,   277,   278,   279,   280,   281,    -1,   283,   284,
     285,   286,    -1,   288,   289,   290,   291,   292,   293,   294,
      -1,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,    -1,    -1,
     315,   316,   317,   318,   319,   320,   321,   322,    -1,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,    -1,   338,   339,   340,    -1,   342,   343,    -1,
     345,    -1,   347,   348,   349,   350,   351,   352,   353,   354,
     355,    -1,   357,   358,   359,   360,   361,   362,   363,    -1,
     365,   366,   367,   368,   369,   370,   371,   372,    -1,    -1,
      -1,   376,   377,   378,   379,   380,   381,    -1,   383,   384,
      -1,   386,   387,    -1,    -1,   390,   391,   392,   393,   394,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   404,
      -1,    -1,    -1,   408,     5,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,    -1,    37,    38,    39,    40,
      41,    42,    -1,    44,    45,    46,    -1,    48,    49,    50,
      51,    52,    53,    -1,    -1,    -1,    57,    58,    -1,    -1,
      -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    72,    -1,    74,    -1,    76,    77,    -1,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    -1,    -1,    -1,
      91,    92,    -1,    -1,    95,    96,    97,    98,    99,   100,
     101,    -1,   103,   104,   105,   106,    -1,   108,   109,    -1,
     111,   112,   113,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,   123,    -1,    -1,   126,   127,   128,    -1,   130,
     131,   132,   133,    -1,   135,   136,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,   149,    -1,
     151,    -1,   153,    -1,   155,   156,   157,    -1,    -1,    -1,
     161,   162,   163,   164,    -1,   166,   167,    -1,    -1,    -1,
     171,   172,   173,   174,   175,    -1,   177,   178,   179,   180,
     181,    -1,   183,    -1,   185,   186,    -1,   188,   189,    -1,
     191,    -1,    -1,   194,    -1,   196,   197,    -1,   199,   200,
     201,    -1,   203,   204,   205,   206,    -1,   208,   209,    -1,
     211,   212,   213,   214,   215,    -1,   217,    -1,    -1,    -1,
      -1,   222,   223,   224,   225,   226,   227,    -1,   229,   230,
      -1,    -1,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,   249,   250,
     251,   252,   253,   254,    -1,   256,   257,    -1,   259,   260,
     261,   262,    -1,    -1,   265,   266,    -1,    -1,    -1,   270,
      -1,    -1,   273,   274,   275,   276,   277,   278,   279,   280,
     281,    -1,   283,   284,   285,   286,    -1,   288,   289,   290,
     291,   292,   293,   294,    -1,   296,   297,   298,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,    -1,    -1,   315,   316,   317,   318,   319,   320,
     321,   322,    -1,   324,   325,   326,   327,   328,   329,   330,
     331,   332,   333,   334,   335,   336,    -1,   338,   339,   340,
      -1,   342,   343,    -1,   345,    -1,   347,   348,   349,   350,
     351,   352,   353,   354,   355,    -1,   357,   358,   359,   360,
     361,   362,   363,    -1,   365,   366,   367,   368,   369,   370,
     371,   372,    -1,    -1,    -1,   376,   377,   378,   379,   380,
     381,    -1,   383,   384,    -1,   386,   387,    -1,    -1,   390,
     391,   392,   393,   394,     5,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,   408,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,    -1,    37,    38,    39,    40,
      41,    42,    -1,    44,    45,    46,    -1,    48,    49,    50,
      51,    52,    53,    -1,    -1,    -1,    57,    58,    -1,    -1,
      -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    72,    -1,    74,    -1,    76,    77,    -1,    79,    80,
      81,    82,    83,    84,    85,    -1,    87,    -1,    -1,    -1,
      -1,    92,    -1,    -1,    95,    96,    97,    98,    99,   100,
     101,    -1,   103,   104,   105,   106,    -1,   108,   109,    -1,
     111,   112,   113,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,   123,    -1,    -1,   126,   127,   128,    -1,   130,
     131,   132,   133,    -1,   135,   136,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,   149,    -1,
     151,    -1,   153,    -1,   155,   156,   157,    -1,    -1,    -1,
     161,   162,   163,   164,    -1,   166,   167,    -1,    -1,    -1,
     171,   172,   173,   174,   175,    -1,   177,   178,   179,   180,
     181,    -1,   183,    -1,   185,   186,    -1,   188,   189,    -1,
     191,    -1,    -1,   194,    -1,   196,   197,    -1,   199,   200,
     201,    -1,   203,   204,   205,   206,    -1,   208,   209,    -1,
     211,   212,   213,   214,   215,    -1,   217,    -1,    -1,    -1,
      -1,   222,   223,   224,   225,   226,   227,    -1,   229,   230,
      -1,    -1,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,   249,   250,
     251,   252,   253,   254,    -1,   256,   257,    -1,    -1,   260,
     261,   262,    -1,    -1,   265,   266,    -1,    -1,    -1,   270,
      -1,    -1,   273,   274,   275,   276,   277,   278,   279,   280,
     281,    -1,   283,   284,   285,   286,    -1,   288,   289,   290,
     291,   292,   293,   294,    -1,   296,   297,   298,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,    -1,    -1,   315,   316,   317,   318,   319,   320,
     321,   322,    -1,   324,   325,    -1,   327,   328,   329,   330,
     331,   332,   333,   334,   335,   336,    -1,   338,   339,   340,
      -1,   342,   343,    -1,   345,    -1,   347,   348,   349,   350,
     351,   352,   353,   354,   355,    -1,    -1,   358,   359,   360,
     361,   362,   363,    -1,   365,   366,   367,   368,   369,   370,
     371,   372,    -1,    -1,    -1,   376,   377,   378,   379,   380,
     381,    -1,   383,   384,    -1,   386,   387,    -1,    -1,   390,
     391,   392,   393,   394,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   404,    -1,    -1,    -1,   408,     5,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    35,    -1,
      37,    38,    39,    40,    41,    42,    -1,    44,    45,    46,
      -1,    48,    49,    50,    51,    52,    53,    -1,    -1,    -1,
      57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,
      77,    -1,    79,    80,    81,    82,    83,    84,    85,    -1,
      87,    -1,    -1,    -1,    -1,    92,    -1,    -1,    95,    96,
      97,    98,    99,   100,   101,    -1,   103,   104,   105,   106,
      -1,   108,   109,    -1,   111,   112,   113,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     147,   148,   149,    -1,   151,    -1,   153,    -1,   155,   156,
     157,    -1,    -1,    -1,   161,   162,   163,   164,    -1,   166,
     167,    -1,    -1,    -1,   171,   172,   173,   174,   175,    -1,
     177,   178,   179,   180,   181,    -1,   183,    -1,   185,   186,
      -1,   188,   189,    -1,   191,    -1,    -1,   194,    -1,   196,
     197,    -1,   199,   200,   201,    -1,   203,   204,   205,   206,
      -1,   208,   209,    -1,   211,   212,   213,   214,   215,    -1,
     217,    -1,    -1,    -1,    -1,   222,   223,   224,   225,   226,
     227,    -1,   229,   230,    -1,    -1,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,    -1,   256,
     257,    -1,    -1,   260,   261,   262,    -1,    -1,   265,   266,
      -1,    -1,    -1,   270,    -1,    -1,   273,   274,   275,   276,
     277,   278,   279,   280,   281,    -1,   283,   284,   285,   286,
      -1,   288,   289,   290,   291,   292,   293,   294,    -1,   296,
     297,   298,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,    -1,    -1,   315,   316,
     317,   318,   319,   320,   321,   322,    -1,   324,   325,    -1,
     327,   328,   329,   330,   331,   332,   333,   334,   335,   336,
      -1,   338,   339,   340,    -1,   342,   343,    -1,   345,    -1,
     347,   348,   349,   350,   351,   352,   353,   354,   355,    -1,
      -1,   358,   359,   360,   361,   362,   363,    -1,   365,   366,
     367,   368,   369,   370,   371,   372,    -1,    -1,    -1,   376,
     377,   378,   379,   380,   381,    -1,   383,   384,    -1,   386,
     387,    -1,    -1,   390,   391,   392,   393,   394,    -1,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,   408,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    -1,    30,    31,    32,    33,    -1,    35,    -1,
      37,    38,    39,    40,    -1,    -1,    -1,    44,    45,    46,
      -1,    48,    -1,    -1,    51,    52,    53,    -1,    -1,    -1,
      57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,
      77,    -1,    79,    80,    81,    82,    83,    84,    85,    -1,
      87,    -1,    -1,    -1,    -1,    -1,    93,    -1,    95,    96,
      97,    -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,
      -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
      -1,    -1,    -1,    -1,    -1,   142,   143,   144,   145,   146,
     147,   148,   149,    -1,   151,    -1,   153,    -1,   155,   156,
     157,    -1,    -1,    -1,   161,   162,   163,   164,    -1,   166,
     167,    -1,   169,   170,   171,   172,   173,   174,   175,    -1,
     177,    -1,   179,   180,   181,   182,   183,    -1,   185,    -1,
      -1,    -1,   189,    -1,   191,    -1,    -1,   194,    -1,   196,
     197,    -1,   199,   200,   201,    -1,   203,   204,   205,   206,
      -1,    -1,   209,    -1,   211,   212,   213,    -1,   215,   216,
     217,    -1,    -1,    -1,    -1,   222,    -1,   224,   225,   226,
     227,    -1,    -1,   230,    -1,   232,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
      -1,   248,    -1,   250,   251,   252,   253,   254,    -1,   256,
     257,    -1,    -1,   260,   261,   262,    -1,   264,   265,    -1,
      -1,    -1,   269,   270,    -1,   272,   273,    -1,    -1,    -1,
     277,   278,   279,   280,   281,    -1,   283,   284,   285,   286,
      -1,   288,   289,   290,   291,   292,   293,   294,    -1,   296,
     297,   298,   299,   300,   301,   302,   303,   304,    -1,   306,
     307,   308,   309,   310,   311,   312,    -1,    -1,   315,   316,
     317,    -1,   319,   320,   321,   322,    -1,   324,   325,    -1,
     327,   328,   329,   330,   331,   332,   333,   334,   335,   336,
      -1,   338,   339,   340,    -1,   342,   343,    -1,   345,    -1,
     347,   348,   349,   350,    -1,   352,   353,   354,   355,   356,
      -1,   358,   359,   360,   361,   362,    -1,    -1,   365,   366,
     367,   368,   369,     5,   371,   372,    -1,    -1,    -1,   376,
     377,   378,   379,   380,   381,    -1,   383,    -1,    20,   386,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    29,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    41,
      42,    -1,   409,    -1,    -1,    -1,    -1,    49,    50,    -1,
      -1,    -1,    54,    55,    56,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    77,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   115,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   181,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   197,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   214,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   240,    -1,
      -1,   243,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   259,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     312,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   344,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   356,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   368,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   380,    -1,
      -1,   383,   384,    -1,   386,    -1,    -1,    -1,    -1,    -1,
     392,    -1,   394,   395,    -1,    -1,    -1,   399,   400,   401,
     402,   403,    -1,    -1,   406,   407,   408,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    31,    32,    33,    -1,    35,    -1,    37,    38,
      39,    40,    -1,    -1,    -1,    44,    45,    46,    -1,    48,
      -1,    -1,    51,    52,    53,    -1,    -1,    -1,    57,    58,
      -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    72,    -1,    74,    -1,    76,    77,    -1,
      79,    80,    81,    82,    83,    84,    85,    -1,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,    -1,    -1,   108,
     109,    -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,   123,    -1,    -1,   126,   127,   128,
      -1,   130,   131,   132,   133,    -1,   135,   136,   137,    -1,
      -1,    -1,    -1,   142,   143,   144,   145,   146,   147,   148,
     149,    -1,   151,    -1,   153,    -1,   155,   156,   157,    -1,
      -1,    -1,   161,   162,   163,   164,    -1,   166,   167,    -1,
     169,    -1,   171,   172,   173,   174,   175,    -1,   177,    -1,
     179,   180,   181,    -1,   183,    -1,   185,   186,    -1,   188,
     189,    -1,   191,    -1,    -1,   194,    -1,   196,   197,   198,
     199,   200,   201,   202,   203,   204,   205,   206,    -1,   208,
     209,    -1,   211,   212,   213,    -1,   215,    -1,   217,    -1,
      -1,   220,   221,   222,   223,   224,   225,   226,   227,    -1,
     229,   230,   231,    -1,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
     249,   250,   251,   252,   253,   254,    -1,   256,   257,   258,
      -1,   260,   261,   262,    -1,    -1,   265,   266,    -1,   268,
     269,   270,    -1,    -1,   273,   274,   275,    -1,   277,   278,
     279,   280,   281,    -1,   283,   284,   285,   286,    -1,   288,
     289,   290,   291,   292,   293,   294,    -1,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,    -1,   314,   315,   316,   317,    -1,
     319,   320,   321,   322,   323,   324,   325,    -1,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,    -1,   338,
     339,   340,    -1,   342,   343,    -1,   345,    -1,   347,   348,
     349,   350,    -1,   352,   353,   354,   355,    -1,    -1,   358,
     359,   360,   361,   362,    -1,    -1,   365,   366,   367,   368,
     369,   370,   371,   372,    -1,    -1,    -1,   376,   377,   378,
     379,   380,   381,    -1,   383,    -1,    -1,   386,    -1,    -1,
      -1,    -1,    -1,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,   408,
      23,    24,    25,    26,    27,    28,    -1,    30,    31,    32,
      33,    -1,    35,    -1,    37,    38,    39,    40,    -1,    -1,
      -1,    44,    45,    46,    -1,    48,    -1,    -1,    51,    52,
      53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,
      -1,    74,    -1,    76,    77,    -1,    79,    80,    81,    82,
      83,    84,    85,    -1,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,    -1,    -1,   108,   109,    -1,   111,    -1,
      -1,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
     123,    -1,    -1,   126,   127,   128,    -1,   130,   131,   132,
     133,    -1,   135,   136,   137,    -1,    -1,    -1,    -1,   142,
     143,   144,   145,   146,   147,   148,   149,    -1,   151,    -1,
     153,    -1,   155,   156,   157,    -1,    -1,    -1,   161,   162,
     163,   164,    -1,   166,   167,    -1,   169,    -1,   171,   172,
     173,   174,   175,    -1,   177,    -1,   179,   180,   181,    -1,
     183,    -1,   185,   186,    -1,   188,   189,    -1,   191,    -1,
      -1,   194,    -1,   196,   197,   198,   199,   200,   201,   202,
     203,   204,   205,   206,    -1,   208,   209,    -1,   211,   212,
     213,    -1,   215,    -1,   217,    -1,    -1,   220,   221,   222,
     223,   224,   225,   226,   227,    -1,   229,   230,   231,    -1,
     233,   234,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,   250,   251,   252,
     253,   254,    -1,   256,   257,   258,    -1,   260,   261,   262,
      -1,    -1,   265,   266,    -1,   268,   269,   270,    -1,    -1,
     273,   274,   275,    -1,   277,   278,   279,   280,   281,    -1,
     283,   284,   285,   286,    -1,   288,   289,   290,   291,   292,
     293,   294,    -1,   296,   297,   298,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
      -1,    -1,   315,   316,   317,    -1,   319,   320,   321,   322,
     323,   324,   325,    -1,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,    -1,   338,   339,   340,    -1,   342,
     343,    -1,   345,    -1,   347,   348,   349,   350,    -1,   352,
     353,   354,   355,    -1,    -1,   358,   359,   360,   361,   362,
      -1,    -1,   365,   366,   367,   368,   369,   370,   371,   372,
      -1,    -1,    -1,   376,   377,   378,   379,   380,   381,    -1,
     383,    -1,    -1,   386,    -1,    -1,    -1,    -1,    -1,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,   408,    23,    24,    25,    26,
      27,    28,    -1,    30,    31,    32,    33,    -1,    35,    -1,
      37,    38,    39,    40,    -1,    -1,    -1,    44,    45,    46,
      -1,    48,    -1,    -1,    51,    52,    53,    -1,    -1,    -1,
      57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,
      77,    -1,    79,    80,    81,    82,    83,    84,    85,    -1,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      97,    98,    99,   100,   101,   102,   103,   104,   105,    -1,
      -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
     137,    -1,    -1,    -1,    -1,   142,   143,   144,   145,   146,
     147,   148,   149,    -1,   151,    -1,   153,    -1,   155,   156,
     157,    -1,    -1,    -1,   161,   162,   163,   164,    -1,   166,
     167,    -1,   169,    -1,   171,   172,   173,   174,   175,    -1,
     177,    -1,   179,   180,   181,    -1,   183,    -1,   185,   186,
      -1,   188,   189,    -1,   191,    -1,    -1,   194,    -1,   196,
     197,   198,   199,   200,   201,   202,   203,   204,   205,   206,
      -1,   208,   209,    -1,   211,   212,   213,    -1,   215,    -1,
     217,    -1,    -1,   220,   221,   222,   223,   224,   225,   226,
     227,    -1,   229,   230,   231,    -1,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,    -1,   256,
     257,   258,    -1,   260,   261,   262,    -1,    -1,   265,   266,
      -1,    -1,   269,   270,    -1,    -1,   273,   274,   275,    -1,
     277,   278,   279,   280,   281,    -1,   283,   284,   285,   286,
      -1,   288,   289,   290,   291,   292,   293,   294,    -1,   296,
     297,   298,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,    -1,    -1,   315,   316,
     317,    -1,   319,   320,   321,   322,   323,   324,   325,    -1,
     327,   328,   329,   330,   331,   332,   333,   334,   335,   336,
      -1,   338,   339,   340,    -1,   342,   343,    -1,   345,    -1,
     347,   348,   349,   350,    -1,   352,   353,   354,   355,    -1,
      -1,   358,   359,   360,   361,   362,    -1,    -1,   365,   366,
     367,   368,   369,   370,   371,   372,    -1,    -1,    -1,   376,
     377,   378,   379,   380,   381,    -1,   383,    -1,    -1,   386,
      -1,    -1,    -1,    -1,    -1,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,   408,    23,    24,    25,    26,    27,    28,    -1,    30,
      31,    32,    33,    -1,    35,    -1,    37,    38,    39,    40,
      -1,    -1,    -1,    44,    45,    46,    -1,    48,    -1,    -1,
      51,    52,    53,    -1,    -1,    -1,    57,    58,    -1,    -1,
      -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    72,    -1,    74,    -1,    76,    77,    -1,    79,    80,
      81,    82,    83,    84,    85,    -1,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,
     101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,
     111,    -1,    -1,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,   123,    -1,    -1,   126,   127,   128,    -1,   130,
     131,   132,   133,    -1,   135,   136,    -1,    -1,    -1,    -1,
      -1,   142,   143,   144,   145,   146,   147,   148,   149,    -1,
     151,    -1,   153,    -1,   155,   156,   157,    -1,    -1,    -1,
     161,   162,   163,   164,    -1,   166,   167,    -1,   169,    -1,
     171,   172,   173,   174,   175,    -1,   177,    -1,   179,   180,
     181,    -1,   183,    -1,   185,    -1,    -1,    -1,   189,    -1,
     191,    -1,    -1,   194,    -1,   196,   197,    -1,   199,   200,
     201,    -1,   203,   204,   205,   206,    -1,    -1,   209,    -1,
     211,   212,   213,    -1,   215,    -1,   217,    -1,    -1,    -1,
      -1,   222,    -1,   224,   225,   226,   227,    -1,    -1,   230,
      -1,    -1,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,    -1,   248,    -1,   250,
     251,   252,   253,   254,    -1,   256,   257,    -1,    -1,   260,
     261,   262,    -1,    -1,   265,    -1,    -1,    -1,   269,   270,
      -1,    -1,   273,    -1,    -1,    -1,   277,   278,   279,   280,
     281,    -1,   283,   284,   285,   286,    -1,   288,   289,   290,
     291,   292,   293,   294,    -1,   296,   297,   298,   299,   300,
     301,   302,   303,   304,    -1,   306,   307,   308,   309,   310,
     311,   312,    -1,    -1,   315,   316,   317,    -1,   319,   320,
     321,   322,    -1,   324,   325,    -1,   327,   328,   329,   330,
     331,   332,   333,   334,   335,   336,    -1,   338,   339,   340,
      -1,   342,   343,    -1,   345,    -1,   347,   348,   349,   350,
      -1,   352,   353,   354,   355,    -1,    -1,   358,   359,   360,
     361,   362,    -1,    -1,   365,   366,   367,   368,   369,    -1,
     371,   372,    -1,    -1,    -1,   376,   377,   378,   379,   380,
     381,    -1,   383,   384,    -1,   386,   387,    -1,    -1,    -1,
      -1,   392,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   407,   408,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    33,    -1,    35,    -1,    37,
      38,    39,    40,    -1,    -1,    -1,    44,    45,    46,    -1,
      48,    -1,    -1,    51,    52,    53,    -1,    -1,    -1,    57,
      58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,    77,
      -1,    79,    80,    81,    82,    83,    84,    85,    -1,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,
      -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,
     108,   109,    -1,   111,    -1,    -1,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,   123,    -1,    -1,   126,   127,
     128,    -1,   130,   131,   132,   133,    -1,   135,   136,    -1,
      -1,    -1,    -1,    -1,   142,   143,   144,   145,   146,   147,
     148,   149,    -1,   151,    -1,   153,    -1,   155,   156,   157,
      -1,    -1,    -1,   161,   162,   163,   164,    -1,   166,   167,
      -1,   169,    -1,   171,   172,   173,   174,   175,    -1,   177,
      -1,   179,   180,   181,    -1,   183,    -1,   185,    -1,    -1,
      -1,   189,    -1,   191,    -1,    -1,   194,    -1,   196,   197,
      -1,   199,   200,   201,    -1,   203,   204,   205,   206,    -1,
      -1,   209,    -1,   211,   212,   213,    -1,   215,    -1,   217,
      -1,    -1,    -1,    -1,   222,    -1,   224,   225,   226,   227,
      -1,    -1,   230,    -1,    -1,   233,   234,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,    -1,
     248,    -1,   250,   251,   252,   253,   254,    -1,   256,   257,
      -1,    -1,   260,   261,   262,    -1,    -1,   265,    -1,    -1,
      -1,   269,   270,    -1,    -1,   273,    -1,    -1,    -1,   277,
     278,   279,   280,   281,    -1,   283,   284,   285,   286,    -1,
     288,   289,   290,   291,   292,   293,   294,    -1,   296,   297,
     298,   299,   300,   301,   302,   303,   304,    -1,   306,   307,
     308,   309,   310,   311,   312,    -1,    -1,   315,   316,   317,
      -1,   319,   320,   321,   322,    -1,   324,   325,    -1,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,    -1,
     338,   339,   340,    -1,   342,   343,    -1,   345,    -1,   347,
     348,   349,   350,    -1,   352,   353,   354,   355,    -1,    -1,
     358,   359,   360,   361,   362,    -1,    -1,   365,   366,   367,
     368,   369,    -1,   371,   372,    -1,    -1,    -1,   376,   377,
     378,   379,   380,   381,    -1,   383,   384,    -1,   386,   387,
      -1,    -1,    -1,    -1,   392,    -1,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
     408,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    35,    -1,    37,    38,    39,
      40,    -1,    -1,    -1,    44,    45,    46,    -1,    48,    -1,
      -1,    51,    52,    53,    -1,    -1,    -1,    57,    58,    -1,
      -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    72,    -1,    74,    -1,    76,    77,    -1,    79,
      80,    81,    82,    83,    84,    85,    -1,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,
     100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,
      -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,   123,    -1,    -1,   126,   127,   128,    -1,
     130,   131,   132,   133,    -1,   135,   136,    -1,    -1,    -1,
      -1,    -1,   142,   143,   144,   145,   146,   147,   148,   149,
      -1,   151,    -1,   153,    -1,   155,   156,   157,    -1,    -1,
      -1,   161,   162,   163,   164,    -1,   166,   167,    -1,   169,
      -1,   171,   172,   173,   174,   175,    -1,   177,    -1,   179,
     180,   181,    -1,   183,    -1,   185,    -1,    -1,    -1,   189,
      -1,   191,    -1,    -1,   194,    -1,   196,   197,    -1,   199,
     200,   201,    -1,   203,   204,   205,   206,    -1,    -1,   209,
      -1,   211,   212,   213,    -1,   215,    -1,   217,    -1,    -1,
      -1,    -1,   222,    -1,   224,   225,   226,   227,    -1,    -1,
     230,    -1,    -1,   233,   234,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,    -1,   248,   249,
     250,   251,   252,   253,   254,    -1,   256,   257,    -1,    -1,
     260,   261,   262,    -1,    -1,   265,   266,    -1,    -1,   269,
     270,    -1,    -1,   273,    -1,    -1,    -1,   277,   278,   279,
     280,   281,    -1,   283,   284,   285,   286,    -1,   288,   289,
     290,   291,   292,   293,   294,    -1,   296,   297,   298,   299,
     300,   301,   302,   303,   304,    -1,   306,   307,   308,   309,
     310,   311,   312,    -1,    -1,   315,   316,   317,    -1,   319,
     320,   321,   322,    -1,   324,   325,    -1,   327,   328,   329,
     330,   331,   332,   333,   334,   335,   336,    -1,   338,   339,
     340,    -1,   342,   343,    -1,   345,    -1,   347,   348,   349,
     350,    -1,   352,   353,   354,   355,    -1,    -1,   358,   359,
     360,   361,   362,    -1,    -1,   365,   366,   367,   368,   369,
      -1,   371,   372,    -1,    -1,    -1,   376,   377,   378,   379,
     380,   381,    -1,   383,    -1,    -1,   386,    -1,    -1,    -1,
      -1,    -1,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,   408,    23,
      24,    25,    26,    27,    28,    -1,    30,    31,    32,    33,
      -1,    35,    -1,    37,    38,    39,    40,    -1,    -1,    -1,
      44,    45,    46,    -1,    48,    -1,    -1,    51,    52,    53,
      -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,    63,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,
      74,    -1,    76,    77,    -1,    79,    80,    81,    82,    83,
      84,    85,    -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    97,    -1,    99,   100,   101,    -1,   103,
      -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,   123,
      -1,    -1,   126,   127,   128,    -1,   130,   131,   132,   133,
      -1,   135,   136,    -1,    -1,    -1,    -1,    -1,   142,   143,
     144,   145,   146,   147,   148,   149,    -1,   151,    -1,   153,
      -1,   155,   156,   157,    -1,    -1,    -1,   161,   162,   163,
     164,    -1,   166,   167,    -1,   169,    -1,   171,   172,   173,
     174,   175,    -1,   177,    -1,   179,   180,   181,    -1,   183,
      -1,   185,    -1,    -1,    -1,   189,    -1,   191,    -1,    -1,
     194,    -1,   196,   197,    -1,   199,   200,   201,    -1,   203,
     204,   205,   206,    -1,    -1,   209,    -1,   211,   212,   213,
      -1,   215,    -1,   217,    -1,    -1,    -1,    -1,   222,    -1,
     224,   225,   226,   227,    -1,    -1,   230,    -1,    -1,   233,
     234,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,    -1,   248,    -1,   250,   251,   252,   253,
     254,    -1,   256,   257,    -1,    -1,   260,   261,   262,    -1,
      -1,   265,    -1,    -1,    -1,   269,   270,    -1,    -1,   273,
      -1,    -1,    -1,   277,   278,   279,   280,   281,    -1,   283,
     284,   285,   286,    -1,   288,   289,   290,   291,   292,   293,
     294,    -1,   296,   297,   298,   299,   300,   301,   302,   303,
     304,    -1,   306,   307,   308,   309,   310,   311,   312,    -1,
     314,   315,   316,   317,    -1,   319,   320,   321,   322,    -1,
     324,   325,    -1,   327,   328,   329,   330,   331,   332,   333,
     334,   335,   336,    -1,   338,   339,   340,    -1,   342,   343,
      -1,   345,    -1,   347,   348,   349,   350,    -1,   352,   353,
     354,   355,    -1,    -1,   358,   359,   360,   361,   362,    -1,
      -1,   365,   366,   367,   368,   369,    -1,   371,   372,    -1,
      -1,    -1,   376,   377,   378,   379,   380,   381,    -1,   383,
      -1,    -1,   386,   387,    -1,    -1,    -1,    -1,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,   408,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    33,    -1,    35,    -1,    37,
      38,    39,    40,    -1,    -1,    -1,    44,    45,    46,    -1,
      48,    -1,    -1,    51,    52,    53,    -1,    -1,    -1,    57,
      58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,    77,
      -1,    79,    80,    81,    82,    83,    84,    85,    -1,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,
      -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,
     108,   109,    -1,   111,    -1,    -1,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,   123,    -1,    -1,   126,   127,
     128,    -1,   130,   131,   132,   133,    -1,   135,   136,    -1,
      -1,    -1,    -1,    -1,   142,   143,   144,   145,   146,   147,
     148,   149,    -1,   151,    -1,   153,    -1,   155,   156,   157,
      -1,    -1,    -1,   161,   162,   163,   164,    -1,   166,   167,
      -1,   169,    -1,   171,   172,   173,   174,   175,    -1,   177,
      -1,   179,   180,   181,    -1,   183,    -1,   185,    -1,    -1,
      -1,   189,    -1,   191,    -1,    -1,   194,    -1,   196,   197,
      -1,   199,   200,   201,    -1,   203,   204,   205,   206,    -1,
      -1,   209,    -1,   211,   212,   213,    -1,   215,    -1,   217,
      -1,    -1,    -1,    -1,   222,    -1,   224,   225,   226,   227,
      -1,    -1,   230,    -1,    -1,   233,   234,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,    -1,
     248,    -1,   250,   251,   252,   253,   254,    -1,   256,   257,
      -1,    -1,   260,   261,   262,    -1,    -1,   265,    -1,    -1,
      -1,   269,   270,    -1,    -1,   273,    -1,    -1,    -1,   277,
     278,   279,   280,   281,    -1,   283,   284,   285,   286,    -1,
     288,   289,   290,   291,   292,   293,   294,    -1,   296,   297,
     298,   299,   300,   301,   302,   303,   304,    -1,   306,   307,
     308,   309,   310,   311,   312,    -1,   314,   315,   316,   317,
      -1,   319,   320,   321,   322,    -1,   324,   325,    -1,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,    -1,
     338,   339,   340,    -1,   342,   343,    -1,   345,    -1,   347,
     348,   349,   350,    -1,   352,   353,   354,   355,    -1,    -1,
     358,   359,   360,   361,   362,    -1,    -1,   365,   366,   367,
     368,   369,    -1,   371,   372,    -1,    -1,    -1,   376,   377,
     378,   379,   380,   381,    -1,   383,    -1,    -1,   386,    -1,
      -1,    -1,    -1,    -1,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
     408,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    35,    -1,    37,    38,    39,    40,    -1,
      -1,    -1,    44,    45,    46,    -1,    48,    -1,    -1,    51,
      52,    53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,
      -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      72,    -1,    74,    -1,    76,    77,    -1,    79,    80,    81,
      82,    83,    84,    85,    -1,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,   101,
      -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,
      -1,    -1,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,   123,    -1,    -1,   126,   127,   128,    -1,   130,   131,
     132,   133,    -1,   135,   136,    -1,    -1,    -1,    -1,    -1,
     142,   143,   144,   145,   146,   147,   148,   149,    -1,   151,
      -1,   153,    -1,   155,   156,   157,    -1,    -1,    -1,   161,
     162,   163,   164,    -1,   166,   167,    -1,   169,    -1,   171,
     172,   173,   174,   175,    -1,   177,    -1,   179,   180,   181,
      -1,   183,    -1,   185,    -1,    -1,    -1,   189,    -1,   191,
      -1,    -1,   194,    -1,   196,   197,    -1,   199,   200,   201,
      -1,   203,   204,   205,   206,    -1,    -1,   209,    -1,   211,
     212,   213,    -1,   215,    -1,   217,    -1,    -1,    -1,    -1,
     222,    -1,   224,   225,   226,   227,    -1,    -1,   230,    -1,
      -1,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,    -1,   248,    -1,   250,   251,
     252,   253,   254,    -1,   256,   257,    -1,    -1,   260,   261,
     262,    -1,    -1,   265,    -1,    -1,    -1,   269,   270,    -1,
      -1,   273,    -1,    -1,    -1,   277,   278,   279,   280,   281,
      -1,   283,   284,   285,   286,    -1,   288,   289,   290,   291,
     292,   293,   294,    -1,   296,   297,   298,   299,   300,   301,
     302,   303,   304,    -1,   306,   307,   308,   309,   310,   311,
     312,    -1,    -1,   315,   316,   317,    -1,   319,   320,   321,
     322,    -1,   324,   325,    -1,   327,   328,   329,   330,   331,
     332,   333,   334,   335,   336,    -1,   338,   339,   340,    -1,
     342,   343,    -1,   345,    -1,   347,   348,   349,   350,    -1,
     352,   353,   354,   355,    -1,    -1,   358,   359,   360,   361,
     362,    -1,    -1,   365,   366,   367,   368,   369,    -1,   371,
     372,    -1,    -1,    -1,   376,   377,   378,   379,   380,   381,
      -1,   383,    -1,    -1,   386,    -1,    -1,    -1,    -1,    -1,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,   408,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    35,
      -1,    37,    38,    39,    40,    -1,    -1,    -1,    44,    45,
      46,    -1,    48,    -1,    -1,    51,    52,    53,    -1,    -1,
      -1,    57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,
      76,    77,    -1,    79,    80,    81,    82,    83,    84,    85,
      -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    97,    -1,    99,   100,   101,    -1,   103,    -1,   105,
      -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,
     116,   117,    -1,   119,   120,   121,   122,   123,    -1,    -1,
     126,   127,   128,    -1,   130,   131,   132,   133,    -1,   135,
     136,    -1,    -1,    -1,    -1,    -1,   142,   143,   144,   145,
     146,   147,   148,   149,    -1,   151,    -1,   153,    -1,   155,
     156,   157,    -1,    -1,    -1,   161,   162,   163,   164,    -1,
     166,   167,    -1,   169,    -1,   171,   172,   173,   174,   175,
      -1,   177,    -1,   179,   180,   181,    -1,   183,    -1,   185,
      -1,    -1,    -1,   189,    -1,   191,    -1,    -1,   194,    -1,
     196,   197,    -1,   199,   200,   201,    -1,   203,   204,   205,
     206,    -1,    -1,   209,    -1,   211,   212,   213,    -1,   215,
      -1,   217,    -1,    -1,    -1,    -1,   222,    -1,   224,   225,
     226,   227,    -1,    -1,   230,    -1,    -1,   233,   234,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,    -1,   248,    -1,   250,   251,   252,   253,   254,    -1,
     256,   257,    -1,    -1,   260,   261,   262,    -1,    -1,   265,
      -1,    -1,    -1,   269,   270,    -1,    -1,   273,    -1,    -1,
      -1,   277,   278,   279,   280,   281,    -1,   283,   284,   285,
     286,    -1,   288,   289,   290,   291,   292,   293,   294,    -1,
     296,   297,   298,   299,   300,   301,   302,   303,   304,    -1,
     306,   307,   308,   309,   310,   311,   312,    -1,    -1,   315,
     316,   317,    -1,   319,   320,   321,   322,    -1,   324,   325,
      -1,   327,   328,   329,   330,   331,   332,   333,   334,   335,
     336,    -1,   338,   339,   340,    -1,   342,   343,    -1,   345,
      -1,   347,   348,   349,   350,    -1,   352,   353,   354,   355,
      -1,    -1,   358,   359,   360,   361,   362,    -1,    -1,   365,
     366,   367,   368,   369,    -1,   371,   372,    -1,    -1,    -1,
     376,   377,   378,   379,   380,   381,    -1,   383,    -1,    -1,
     386,    -1,    -1,    -1,    -1,     5,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,   408,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,    35,    -1,    37,    38,    39,
      40,    41,    42,    -1,    44,    45,    46,    -1,    48,    49,
      50,    51,    52,    53,    -1,    -1,    -1,    57,    58,    -1,
      -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    72,    -1,    74,    -1,    76,    77,    -1,    79,
      80,    81,    82,    83,    84,    85,    -1,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,
     100,   101,    -1,   103,    -1,   105,   106,    -1,   108,   109,
      -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,    -1,    -1,    -1,   126,   127,   128,    -1,
     130,   131,    -1,   133,    -1,   135,   136,    -1,    -1,    -1,
      -1,    -1,   142,   143,   144,   145,   146,   147,   148,   149,
      -1,   151,    -1,   153,    -1,   155,   156,   157,    -1,    -1,
      -1,   161,   162,   163,   164,    -1,   166,   167,    -1,   169,
      -1,   171,   172,   173,    -1,   175,    -1,    -1,    -1,   179,
     180,   181,    -1,   183,    -1,   185,    -1,    -1,    -1,   189,
      -1,   191,    -1,    -1,   194,    -1,   196,   197,    -1,   199,
     200,   201,    -1,   203,   204,   205,   206,    -1,    -1,   209,
      -1,   211,   212,   213,   214,   215,    -1,   217,    -1,    -1,
      -1,    -1,   222,    -1,   224,   225,   226,   227,    -1,    -1,
     230,    -1,    -1,   233,   234,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,    -1,   248,    -1,
     250,   251,   252,   253,    -1,    -1,   256,   257,    -1,    -1,
      -1,   261,   262,    -1,    -1,   265,    -1,    -1,    -1,   269,
     270,    -1,    -1,   273,    -1,    -1,    -1,   277,   278,   279,
     280,   281,    -1,    -1,   284,   285,   286,    -1,   288,   289,
     290,   291,   292,   293,   294,    -1,   296,   297,   298,   299,
     300,   301,   302,   303,   304,    -1,   306,    -1,   308,   309,
     310,   311,   312,    -1,    -1,   315,   316,   317,    -1,   319,
     320,   321,   322,    -1,   324,   325,    -1,   327,   328,   329,
     330,   331,   332,   333,   334,    -1,   336,    -1,   338,   339,
     340,    -1,   342,   343,    -1,   345,    -1,   347,    -1,   349,
      -1,    -1,   352,   353,   354,   355,    -1,    -1,   358,   359,
     360,   361,   362,    -1,    -1,   365,   366,   367,   368,   369,
      -1,   371,   372,    -1,    -1,    -1,   376,   377,   378,   379,
     380,   381,    -1,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,    -1,   394,   395,   396,   397,    -1,   399,
     400,   401,   402,   403,   404,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      31,    32,    33,    -1,    35,    -1,    37,    38,    39,    40,
      -1,    -1,    -1,    44,    45,    46,    -1,    48,    -1,    -1,
      51,    52,    53,    -1,    -1,    -1,    57,    58,    -1,    -1,
      -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    72,    -1,    74,    -1,    76,    77,    -1,    79,    80,
      81,    82,    83,    84,    85,    -1,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,
     101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,
     111,    -1,    -1,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,   123,    -1,    -1,   126,   127,   128,    -1,   130,
     131,   132,   133,    -1,   135,   136,    -1,    -1,    -1,    -1,
      -1,   142,   143,   144,   145,   146,   147,   148,   149,    -1,
     151,    -1,   153,    -1,   155,   156,   157,    -1,    -1,    -1,
     161,   162,   163,   164,    -1,   166,   167,    -1,   169,    -1,
     171,   172,   173,   174,   175,    -1,   177,    -1,   179,   180,
     181,    -1,   183,    -1,   185,    -1,    -1,    -1,   189,    -1,
     191,    -1,    -1,   194,    -1,   196,   197,    -1,   199,   200,
     201,    -1,   203,   204,   205,   206,    -1,    -1,   209,    -1,
     211,   212,   213,    -1,   215,    -1,   217,    -1,    -1,    -1,
      -1,   222,    -1,   224,   225,   226,   227,    -1,    -1,   230,
      -1,    -1,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,    -1,   248,    -1,   250,
     251,   252,   253,   254,    -1,   256,   257,    -1,    -1,   260,
     261,   262,    -1,    -1,   265,    -1,    -1,    -1,   269,   270,
      -1,    -1,   273,    -1,    -1,    -1,   277,   278,   279,   280,
     281,    -1,   283,   284,   285,   286,    -1,   288,   289,   290,
     291,   292,   293,   294,    -1,   296,   297,   298,   299,   300,
     301,   302,   303,   304,    -1,   306,   307,   308,   309,   310,
     311,   312,    -1,    -1,   315,   316,   317,    -1,   319,   320,
     321,   322,    -1,   324,   325,    -1,   327,   328,   329,   330,
     331,   332,   333,   334,   335,   336,    -1,   338,   339,   340,
      -1,   342,   343,    -1,   345,    -1,   347,   348,   349,   350,
      -1,   352,   353,   354,   355,    -1,    -1,   358,   359,   360,
     361,   362,    -1,    -1,   365,   366,   367,   368,   369,    -1,
     371,   372,    -1,    -1,    -1,   376,   377,   378,   379,   380,
     381,    -1,   383,    -1,   385,   386,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   395,   396,   397,    -1,   399,   400,
     401,   402,   403,   404,     5,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,    -1,    37,    38,    39,    40,
      41,    42,    -1,    44,    45,    46,    -1,    48,    49,    50,
      51,    52,    53,    -1,    -1,    -1,    57,    58,    -1,    -1,
      -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    72,    -1,    74,    -1,    76,    77,    -1,    79,    80,
      81,    82,    83,    84,    85,    -1,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,
     101,    -1,   103,    -1,   105,   106,    -1,   108,   109,    -1,
     111,    -1,    -1,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,    -1,    -1,    -1,   126,   127,   128,    -1,   130,
     131,    -1,   133,    -1,   135,   136,    -1,    -1,    -1,    -1,
      -1,   142,   143,   144,   145,   146,   147,   148,   149,    -1,
     151,    -1,   153,    -1,   155,   156,   157,    -1,    -1,    -1,
     161,   162,   163,   164,    -1,   166,   167,    -1,   169,    -1,
     171,   172,   173,    -1,   175,    -1,    -1,    -1,   179,   180,
     181,    -1,   183,    -1,   185,    -1,    -1,    -1,   189,    -1,
     191,    -1,    -1,   194,    -1,   196,   197,    -1,   199,   200,
     201,    -1,   203,   204,   205,   206,    -1,    -1,   209,    -1,
     211,   212,   213,   214,   215,    -1,   217,    -1,    -1,    -1,
      -1,   222,    -1,   224,   225,   226,   227,    -1,    -1,   230,
      -1,    -1,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,    -1,   248,    -1,   250,
     251,   252,   253,    -1,    -1,   256,   257,    -1,    -1,    -1,
     261,   262,    -1,    -1,   265,    -1,    -1,    -1,   269,   270,
      -1,    -1,   273,    -1,    -1,    -1,   277,   278,   279,   280,
     281,    -1,    -1,   284,   285,   286,    -1,   288,   289,   290,
     291,   292,   293,   294,    -1,   296,   297,   298,   299,   300,
     301,   302,   303,   304,    -1,   306,    -1,   308,   309,   310,
     311,   312,    -1,    -1,   315,   316,   317,    -1,   319,   320,
     321,   322,    -1,   324,   325,    -1,   327,   328,   329,   330,
     331,   332,   333,   334,    -1,   336,    -1,   338,   339,   340,
      -1,   342,   343,    -1,   345,    -1,   347,    -1,   349,    -1,
      -1,   352,   353,   354,   355,    -1,    -1,   358,   359,   360,
     361,   362,    -1,    -1,   365,   366,   367,   368,   369,    -1,
     371,   372,    -1,    -1,    -1,   376,   377,   378,   379,   380,
     381,    -1,   383,    -1,    -1,   386,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
     401,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    35,    -1,    37,    38,    39,
      40,    -1,    -1,    -1,    44,    45,    46,    -1,    48,    -1,
      -1,    51,    52,    53,    -1,    -1,    -1,    57,    58,    -1,
      -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    72,    -1,    74,    -1,    76,    77,    -1,    79,
      80,    81,    82,    83,    84,    85,    -1,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,
     100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,
      -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,   123,    -1,    -1,   126,   127,   128,    -1,
     130,   131,   132,   133,    -1,   135,   136,    -1,    -1,    -1,
      -1,    -1,   142,   143,   144,   145,   146,   147,   148,   149,
      -1,   151,    -1,   153,    -1,   155,   156,   157,    -1,    -1,
      -1,   161,   162,   163,   164,    -1,   166,   167,    -1,   169,
      -1,   171,   172,   173,   174,   175,    -1,   177,    -1,   179,
     180,   181,    -1,   183,    -1,   185,    -1,    -1,    -1,   189,
      -1,   191,    -1,    -1,   194,    -1,   196,   197,    -1,   199,
     200,   201,    -1,   203,   204,   205,   206,    -1,    -1,   209,
      -1,   211,   212,   213,    -1,   215,    -1,   217,    -1,    -1,
      -1,    -1,   222,    -1,   224,   225,   226,   227,    -1,    -1,
     230,    -1,    -1,   233,   234,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,    -1,   248,   249,
     250,   251,   252,   253,   254,    -1,   256,   257,    -1,    -1,
     260,   261,   262,    -1,    -1,   265,   266,    -1,    -1,   269,
     270,    -1,    -1,   273,    -1,    -1,    -1,   277,   278,   279,
     280,   281,    -1,   283,   284,   285,   286,    -1,   288,   289,
     290,   291,   292,   293,   294,    -1,   296,   297,   298,   299,
     300,   301,   302,   303,   304,    -1,   306,   307,   308,   309,
     310,   311,   312,    -1,    -1,   315,   316,   317,    -1,   319,
     320,   321,   322,    -1,   324,   325,    -1,   327,   328,   329,
     330,   331,   332,   333,   334,   335,   336,    -1,   338,   339,
     340,    -1,   342,   343,    -1,   345,    -1,   347,   348,   349,
     350,    -1,   352,   353,   354,   355,    -1,    -1,   358,   359,
     360,   361,   362,    -1,    -1,   365,   366,   367,   368,   369,
      -1,   371,   372,    -1,    -1,    -1,   376,   377,   378,   379,
     380,   381,    -1,   383,    -1,    -1,   386,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,   401,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    31,    32,    33,    -1,    35,    -1,    37,    38,
      39,    40,    -1,    -1,    -1,    44,    45,    46,    -1,    48,
      -1,    -1,    51,    52,    53,    -1,    -1,    -1,    57,    58,
      -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    72,    -1,    74,    -1,    76,    77,    -1,
      79,    80,    81,    82,    83,    84,    85,    -1,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,
      99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,
     109,    -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,   123,    -1,    -1,   126,   127,   128,
      -1,   130,   131,   132,   133,    -1,   135,   136,    -1,    -1,
      -1,    -1,    -1,   142,   143,   144,   145,   146,   147,   148,
     149,    -1,   151,    -1,   153,    -1,   155,   156,   157,    -1,
      -1,    -1,   161,   162,   163,   164,    -1,   166,   167,    -1,
     169,    -1,   171,   172,   173,   174,   175,    -1,   177,    -1,
     179,   180,   181,    -1,   183,    -1,   185,    -1,    -1,    -1,
     189,    -1,   191,    -1,    -1,   194,    -1,   196,   197,    -1,
     199,   200,   201,    -1,   203,   204,   205,   206,    -1,    -1,
     209,    -1,   211,   212,   213,    -1,   215,    -1,   217,    -1,
      -1,    -1,    -1,   222,    -1,   224,   225,   226,   227,    -1,
      -1,   230,    -1,    -1,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,    -1,   248,
      -1,   250,   251,   252,   253,   254,    -1,   256,   257,    -1,
      -1,   260,   261,   262,    -1,    -1,   265,    -1,    -1,    -1,
     269,   270,    -1,    -1,   273,    -1,    -1,    -1,   277,   278,
     279,   280,   281,    -1,   283,   284,   285,   286,    -1,   288,
     289,   290,   291,   292,   293,   294,    -1,   296,   297,   298,
     299,   300,   301,   302,   303,   304,    -1,   306,   307,   308,
     309,   310,   311,   312,    -1,    -1,   315,   316,   317,    -1,
     319,   320,   321,   322,    -1,   324,   325,    -1,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,    -1,   338,
     339,   340,    -1,   342,   343,    -1,   345,    -1,   347,   348,
     349,   350,    -1,   352,   353,   354,   355,    -1,    -1,   358,
     359,   360,   361,   362,    -1,    -1,   365,   366,   367,   368,
     369,    -1,   371,   372,    -1,    -1,    -1,   376,   377,   378,
     379,   380,   381,    -1,   383,    -1,    -1,   386,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,   401,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    33,    -1,    35,    -1,    37,
      38,    39,    40,    -1,    -1,    -1,    44,    45,    46,    -1,
      48,    -1,    -1,    51,    52,    53,    -1,    -1,    -1,    57,
      58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,    77,
      -1,    79,    80,    81,    82,    83,    84,    85,    -1,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,
      -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,
     108,   109,    -1,   111,    -1,    -1,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,   123,    -1,    -1,   126,   127,
     128,    -1,   130,   131,   132,   133,    -1,   135,   136,    -1,
      -1,    -1,    -1,    -1,   142,   143,   144,   145,   146,   147,
     148,   149,   150,   151,    -1,   153,    -1,   155,   156,   157,
      -1,    -1,    -1,   161,   162,   163,   164,    -1,   166,   167,
      -1,   169,    -1,   171,   172,   173,   174,   175,    -1,   177,
     178,   179,   180,   181,    -1,   183,    -1,   185,    -1,    -1,
      -1,   189,    -1,   191,    -1,    -1,   194,    -1,   196,   197,
      -1,   199,   200,   201,    -1,   203,   204,   205,   206,    -1,
      -1,   209,    -1,   211,   212,   213,    -1,   215,    -1,   217,
      -1,    -1,    -1,    -1,   222,    -1,   224,   225,   226,   227,
      -1,    -1,   230,    -1,    -1,   233,   234,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,    -1,
     248,    -1,   250,   251,   252,   253,   254,    -1,   256,   257,
      -1,    -1,   260,   261,   262,   263,    -1,   265,    -1,   267,
      -1,   269,   270,    -1,    -1,   273,    -1,    -1,    -1,   277,
     278,   279,   280,   281,    -1,   283,   284,   285,   286,    -1,
     288,   289,   290,   291,   292,   293,   294,    -1,   296,   297,
     298,   299,   300,   301,   302,   303,   304,    -1,   306,   307,
     308,   309,   310,   311,   312,    -1,    -1,   315,   316,   317,
      -1,   319,   320,   321,   322,    -1,   324,   325,    -1,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,    -1,
     338,   339,   340,    -1,   342,   343,    -1,   345,    -1,   347,
     348,   349,   350,   351,   352,   353,   354,   355,    -1,    -1,
     358,   359,   360,   361,   362,    -1,    -1,   365,   366,   367,
     368,   369,    -1,   371,   372,    -1,    -1,    -1,   376,   377,
     378,   379,   380,   381,    -1,   383,   384,    -1,   386,   387,
      -1,    -1,    -1,    -1,   392,    -1,   394,    -1,     6,     7,
       8,     9,   400,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    33,    -1,    35,    -1,    37,
      38,    39,    40,    -1,    -1,    -1,    44,    45,    46,    -1,
      48,    -1,    -1,    51,    52,    53,    -1,    -1,    -1,    57,
      58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,    77,
      -1,    79,    80,    81,    82,    83,    84,    85,    -1,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,
      -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,
     108,   109,    -1,   111,    -1,    -1,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,   123,    -1,    -1,   126,   127,
     128,    -1,   130,   131,   132,   133,    -1,   135,   136,    -1,
      -1,    -1,    -1,    -1,   142,   143,   144,   145,   146,   147,
     148,   149,    -1,   151,    -1,   153,    -1,   155,   156,   157,
      -1,    -1,    -1,   161,   162,   163,   164,    -1,   166,   167,
      -1,   169,    -1,   171,   172,   173,   174,   175,    -1,   177,
     178,   179,   180,   181,    -1,   183,    -1,   185,    -1,    -1,
      -1,   189,    -1,   191,    -1,    -1,   194,    -1,   196,   197,
      -1,   199,   200,   201,    -1,   203,   204,   205,   206,    -1,
      -1,   209,    -1,   211,   212,   213,    -1,   215,    -1,   217,
      -1,    -1,    -1,    -1,   222,    -1,   224,   225,   226,   227,
      -1,    -1,   230,    -1,    -1,   233,   234,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,    -1,
     248,    -1,   250,   251,   252,   253,   254,    -1,   256,   257,
      -1,    -1,   260,   261,   262,   263,    -1,   265,    -1,   267,
      -1,   269,   270,    -1,    -1,   273,    -1,    -1,    -1,   277,
     278,   279,   280,   281,    -1,   283,   284,   285,   286,    -1,
     288,   289,   290,   291,   292,   293,   294,    -1,   296,   297,
     298,   299,   300,   301,   302,   303,   304,    -1,   306,   307,
     308,   309,   310,   311,   312,    -1,    -1,   315,   316,   317,
      -1,   319,   320,   321,   322,    -1,   324,   325,    -1,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,    -1,
     338,   339,   340,    -1,   342,   343,    -1,   345,    -1,   347,
     348,   349,   350,   351,   352,   353,   354,   355,    -1,    -1,
     358,   359,   360,   361,   362,    -1,    -1,   365,   366,   367,
     368,   369,    -1,   371,   372,    -1,    -1,    -1,   376,   377,
     378,   379,   380,   381,    -1,   383,   384,    -1,   386,   387,
      -1,    -1,    -1,    -1,   392,    -1,   394,    -1,     6,     7,
       8,     9,   400,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    33,    -1,    35,    -1,    37,
      38,    39,    40,    -1,    -1,    -1,    44,    45,    46,    -1,
      48,    -1,    -1,    51,    52,    53,    -1,    -1,    -1,    57,
      58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,    77,
      -1,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,
      -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,
     108,   109,    -1,   111,    -1,    -1,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,   123,    -1,    -1,   126,   127,
     128,    -1,   130,   131,   132,   133,    -1,   135,   136,    -1,
      -1,    -1,    -1,    -1,   142,   143,   144,   145,   146,   147,
     148,   149,    -1,   151,    -1,   153,    -1,   155,   156,   157,
      -1,    -1,    -1,   161,   162,   163,   164,    -1,   166,   167,
      -1,   169,    -1,   171,   172,   173,   174,   175,    -1,   177,
      -1,   179,   180,   181,    -1,   183,    -1,   185,    -1,   187,
      -1,   189,    -1,   191,    -1,    -1,   194,    -1,   196,   197,
      -1,   199,   200,   201,   202,   203,   204,   205,   206,    -1,
      -1,   209,    -1,   211,   212,   213,    -1,   215,    -1,   217,
      -1,    -1,    -1,    -1,   222,    -1,   224,   225,   226,   227,
      -1,    -1,   230,    -1,    -1,   233,   234,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,    -1,
     248,    -1,   250,   251,   252,   253,   254,    -1,   256,   257,
      -1,    -1,   260,   261,   262,    -1,    -1,   265,    -1,    -1,
      -1,   269,   270,    -1,    -1,   273,    -1,    -1,    -1,   277,
     278,   279,   280,   281,    -1,   283,   284,   285,   286,    -1,
     288,   289,   290,   291,   292,   293,   294,    -1,   296,   297,
     298,   299,   300,   301,   302,   303,   304,    -1,   306,   307,
     308,   309,   310,   311,   312,    -1,    -1,   315,   316,   317,
      -1,   319,   320,   321,   322,    -1,   324,   325,    -1,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,    -1,
     338,   339,   340,    -1,   342,   343,    -1,   345,    -1,   347,
     348,   349,   350,    -1,   352,   353,   354,   355,    -1,    -1,
     358,   359,   360,   361,   362,    -1,    -1,   365,   366,   367,
     368,   369,    -1,   371,   372,    -1,    -1,    -1,   376,   377,
     378,   379,   380,   381,    -1,   383,    -1,    -1,   386,   387,
       6,     7,     8,     9,   392,    11,    12,    -1,    14,    15,
      16,    17,   400,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    35,
      -1,    37,    38,    39,    40,    -1,    -1,    -1,    44,    45,
      46,    -1,    48,    -1,    -1,    51,    52,    53,    -1,    -1,
      -1,    57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,
      76,    77,    -1,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    97,    -1,    99,   100,   101,    -1,   103,    -1,   105,
      -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,
     116,   117,    -1,   119,   120,   121,   122,   123,    -1,    -1,
     126,   127,   128,    -1,   130,   131,   132,   133,    -1,   135,
     136,    -1,    -1,    -1,    -1,    -1,   142,   143,   144,   145,
     146,   147,   148,   149,    -1,   151,    -1,   153,    -1,   155,
     156,   157,    -1,    -1,    -1,   161,   162,   163,   164,    -1,
     166,   167,    -1,   169,    -1,   171,   172,   173,   174,   175,
      -1,   177,    -1,   179,   180,   181,    -1,   183,    -1,   185,
      -1,    -1,    -1,   189,    -1,   191,    -1,    -1,   194,    -1,
     196,   197,    -1,   199,   200,   201,    -1,   203,   204,   205,
     206,    -1,    -1,   209,    -1,   211,   212,   213,    -1,   215,
      -1,   217,    -1,    -1,    -1,    -1,   222,    -1,   224,   225,
     226,   227,    -1,    -1,   230,    -1,    -1,   233,   234,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,    -1,   248,    -1,   250,   251,   252,   253,   254,    -1,
     256,   257,    -1,    -1,   260,   261,   262,    -1,    -1,   265,
      -1,    -1,    -1,   269,   270,    -1,    -1,   273,    -1,    -1,
      -1,   277,   278,   279,   280,   281,    -1,   283,   284,   285,
     286,    -1,   288,   289,   290,   291,   292,   293,   294,    -1,
     296,   297,   298,   299,   300,   301,   302,   303,   304,    -1,
     306,   307,   308,   309,   310,   311,   312,    -1,    -1,   315,
     316,   317,    -1,   319,   320,   321,   322,    -1,   324,   325,
      -1,   327,   328,   329,   330,   331,   332,   333,   334,   335,
     336,    -1,   338,   339,   340,    -1,   342,   343,    -1,   345,
      -1,   347,   348,   349,   350,    -1,   352,   353,   354,   355,
      -1,    -1,   358,   359,   360,   361,   362,    -1,    -1,   365,
     366,   367,   368,   369,    -1,   371,   372,    -1,    -1,    -1,
     376,   377,   378,   379,   380,   381,    -1,   383,    -1,    -1,
     386,   387,     6,     7,     8,     9,   392,    11,    12,    -1,
      14,    15,    16,    17,   400,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    31,    32,    33,
      -1,    35,    -1,    37,    38,    39,    40,    -1,    -1,    -1,
      44,    45,    46,    -1,    48,    -1,    -1,    51,    52,    53,
      -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,    63,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,
      74,    -1,    76,    77,    -1,    79,    80,    81,    82,    83,
      84,    85,    -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    97,    -1,    99,   100,   101,    -1,   103,
      -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,   123,
      -1,    -1,   126,   127,   128,    -1,   130,   131,   132,   133,
      -1,   135,   136,    -1,    -1,    -1,    -1,    -1,   142,   143,
     144,   145,   146,   147,   148,   149,   150,   151,    -1,   153,
      -1,   155,   156,   157,    -1,    -1,    -1,   161,   162,   163,
     164,    -1,   166,   167,    -1,   169,    -1,   171,   172,   173,
     174,   175,    -1,   177,    -1,   179,   180,   181,    -1,   183,
      -1,   185,    -1,    -1,    -1,   189,    -1,   191,    -1,    -1,
     194,    -1,   196,   197,    -1,   199,   200,   201,    -1,   203,
     204,   205,   206,    -1,    -1,   209,    -1,   211,   212,   213,
      -1,   215,    -1,   217,    -1,    -1,    -1,    -1,   222,    -1,
     224,   225,   226,   227,    -1,    -1,   230,    -1,    -1,   233,
     234,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,    -1,   248,    -1,   250,   251,   252,   253,
     254,    -1,   256,   257,    -1,    -1,   260,   261,   262,    -1,
      -1,   265,    -1,    -1,    -1,   269,   270,    -1,    -1,   273,
      -1,    -1,    -1,   277,   278,   279,   280,   281,    -1,   283,
     284,   285,   286,    -1,   288,   289,   290,   291,   292,   293,
     294,    -1,   296,   297,   298,   299,   300,   301,   302,   303,
     304,    -1,   306,   307,   308,   309,   310,   311,   312,    -1,
      -1,   315,   316,   317,    -1,   319,   320,   321,   322,    -1,
     324,   325,    -1,   327,   328,   329,   330,   331,   332,   333,
     334,   335,   336,    -1,   338,   339,   340,    -1,   342,   343,
     344,   345,    -1,   347,   348,   349,   350,    -1,   352,   353,
     354,   355,    -1,    -1,   358,   359,   360,   361,   362,    -1,
      -1,   365,   366,   367,   368,   369,    -1,   371,   372,    -1,
      -1,    -1,   376,   377,   378,   379,   380,   381,    -1,   383,
     384,    -1,   386,   387,     6,     7,     8,     9,    -1,    11,
      12,   395,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    35,    -1,    37,    38,    39,    40,    -1,
      -1,    -1,    44,    45,    46,    -1,    48,    -1,    -1,    51,
      52,    53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,
      -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      72,    -1,    74,    -1,    76,    77,    -1,    79,    80,    81,
      82,    83,    84,    85,    -1,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,   101,
      -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,
      -1,    -1,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,   123,    -1,    -1,   126,   127,   128,    -1,   130,   131,
     132,   133,    -1,   135,   136,    -1,    -1,    -1,    -1,    -1,
     142,   143,   144,   145,   146,   147,   148,   149,    -1,   151,
      -1,   153,    -1,   155,   156,   157,    -1,    -1,    -1,   161,
     162,   163,   164,    -1,   166,   167,    -1,   169,    -1,   171,
     172,   173,   174,   175,    -1,   177,    -1,   179,   180,   181,
      -1,   183,    -1,   185,    -1,    -1,    -1,   189,    -1,   191,
      -1,    -1,   194,    -1,   196,   197,    -1,   199,   200,   201,
      -1,   203,   204,   205,   206,    -1,    -1,   209,    -1,   211,
     212,   213,    -1,   215,    -1,   217,    -1,    -1,    -1,    -1,
     222,    -1,   224,   225,   226,   227,    -1,    -1,   230,    -1,
      -1,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,    -1,   248,    -1,   250,   251,
     252,   253,   254,    -1,   256,   257,    -1,    -1,   260,   261,
     262,    -1,    -1,   265,    -1,    -1,    -1,   269,   270,    -1,
      -1,   273,    -1,    -1,    -1,   277,   278,   279,   280,   281,
      -1,   283,   284,   285,   286,    -1,   288,   289,   290,   291,
     292,   293,   294,    -1,   296,   297,   298,   299,   300,   301,
     302,   303,   304,    -1,   306,   307,   308,   309,   310,   311,
     312,    -1,    -1,   315,   316,   317,    -1,   319,   320,   321,
     322,    -1,   324,   325,    -1,   327,   328,   329,   330,   331,
     332,   333,   334,   335,   336,    -1,   338,   339,   340,    -1,
     342,   343,    -1,   345,    -1,   347,   348,   349,   350,    -1,
     352,   353,   354,   355,    -1,    -1,   358,   359,   360,   361,
     362,    -1,    -1,   365,   366,   367,   368,   369,    -1,   371,
     372,    -1,    -1,    -1,   376,   377,   378,   379,   380,   381,
      -1,   383,   384,    -1,   386,   387,    -1,    -1,   390,   391,
     392,    -1,   394,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    31,    32,
      33,    -1,    35,    -1,    37,    38,    39,    40,    -1,    -1,
      -1,    44,    45,    46,    -1,    48,    -1,    -1,    51,    52,
      53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,
      -1,    74,    -1,    76,    77,    -1,    79,    80,    81,    82,
      83,    84,    85,    -1,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    97,    -1,    99,   100,   101,    -1,
     103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,
      -1,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
     123,    -1,    -1,   126,   127,   128,    -1,   130,   131,   132,
     133,    -1,   135,   136,    -1,    -1,    -1,    -1,    -1,   142,
     143,   144,   145,   146,   147,   148,   149,    -1,   151,    -1,
     153,    -1,   155,   156,   157,    -1,    -1,    -1,   161,   162,
     163,   164,    -1,   166,   167,    -1,   169,    -1,   171,   172,
     173,   174,   175,    -1,   177,    -1,   179,   180,   181,    -1,
     183,    -1,   185,    -1,    -1,    -1,   189,    -1,   191,    -1,
      -1,   194,    -1,   196,   197,    -1,   199,   200,   201,    -1,
     203,   204,   205,   206,    -1,    -1,   209,    -1,   211,   212,
     213,    -1,   215,    -1,   217,    -1,    -1,    -1,    -1,   222,
      -1,   224,   225,   226,   227,    -1,    -1,   230,    -1,    -1,
     233,   234,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,    -1,   248,    -1,   250,   251,   252,
     253,   254,    -1,   256,   257,    -1,    -1,   260,   261,   262,
      -1,    -1,   265,    -1,    -1,    -1,   269,   270,    -1,    -1,
     273,    -1,    -1,    -1,   277,   278,   279,   280,   281,    -1,
     283,   284,   285,   286,    -1,   288,   289,   290,   291,   292,
     293,   294,    -1,   296,   297,   298,   299,   300,   301,   302,
     303,   304,    -1,   306,   307,   308,   309,   310,   311,   312,
      -1,    -1,   315,   316,   317,    -1,   319,   320,   321,   322,
      -1,   324,   325,    -1,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,    -1,   338,   339,   340,    -1,   342,
     343,    -1,   345,    -1,   347,   348,   349,   350,    -1,   352,
     353,   354,   355,    -1,    -1,   358,   359,   360,   361,   362,
      -1,    -1,   365,   366,   367,   368,   369,    -1,   371,   372,
      -1,    -1,    -1,   376,   377,   378,   379,   380,   381,    -1,
     383,    -1,    -1,   386,    -1,     4,   389,     6,     7,     8,
       9,    10,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    31,    32,    33,    -1,    35,    -1,    37,    38,
      39,    40,    -1,    -1,    -1,    44,    45,    46,    -1,    48,
      -1,    -1,    51,    52,    53,    -1,    -1,    -1,    57,    58,
      -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    72,    -1,    74,    -1,    76,    77,    -1,
      79,    80,    81,    82,    83,    84,    85,    -1,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,
      99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,
     109,    -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,   123,    -1,    -1,   126,   127,   128,
      -1,   130,   131,   132,   133,    -1,   135,   136,    -1,    -1,
      -1,    -1,    -1,   142,   143,   144,   145,   146,   147,   148,
     149,    -1,   151,    -1,   153,    -1,   155,   156,   157,    -1,
      -1,    -1,   161,   162,   163,   164,    -1,   166,   167,    -1,
     169,    -1,   171,   172,   173,   174,   175,    -1,   177,    -1,
     179,   180,   181,    -1,   183,    -1,   185,    -1,    -1,    -1,
     189,    -1,   191,    -1,    -1,   194,    -1,   196,   197,    -1,
     199,   200,   201,    -1,   203,   204,   205,   206,    -1,    -1,
     209,    -1,   211,   212,   213,    -1,   215,    -1,   217,    -1,
      -1,    -1,    -1,   222,    -1,   224,   225,   226,   227,    -1,
      -1,   230,    -1,    -1,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,    -1,   248,
      -1,   250,   251,   252,   253,   254,    -1,   256,   257,    -1,
      -1,   260,   261,   262,    -1,    -1,   265,    -1,    -1,    -1,
     269,   270,    -1,    -1,   273,    -1,    -1,    -1,   277,   278,
     279,   280,   281,    -1,   283,   284,   285,   286,    -1,   288,
     289,   290,   291,   292,   293,   294,    -1,   296,   297,   298,
     299,   300,   301,   302,   303,   304,    -1,   306,   307,   308,
     309,   310,   311,   312,    -1,    -1,   315,   316,   317,    -1,
     319,   320,   321,   322,    -1,   324,   325,    -1,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,    -1,   338,
     339,   340,    -1,   342,   343,    -1,   345,    -1,   347,   348,
     349,   350,    -1,   352,   353,   354,   355,    -1,    -1,   358,
     359,   360,   361,   362,    -1,    -1,   365,   366,   367,   368,
     369,    -1,   371,   372,    -1,    -1,    -1,   376,   377,   378,
     379,   380,   381,    -1,   383,    -1,    -1,   386,     5,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    35,    -1,
      37,    38,    39,    40,    41,    42,    -1,    44,    45,    46,
      -1,    48,    49,    50,    51,    52,    53,    -1,    -1,    -1,
      57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,
      77,    -1,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    89,    90,    91,    92,    93,    94,    95,    96,
      97,    98,    99,   100,   101,   102,   103,   104,   105,    -1,
     107,   108,   109,    -1,   111,   112,   113,   114,   115,   116,
     117,   118,   119,   120,   121,   122,   123,   124,   125,   126,
     127,   128,   129,   130,   131,   132,   133,   134,   135,   136,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     147,   148,   149,   150,   151,   152,   153,    -1,   155,   156,
     157,   158,   159,   160,   161,   162,   163,   164,   165,   166,
     167,   168,   169,   170,   171,   172,   173,   174,   175,    -1,
     177,   178,   179,   180,   181,   182,   183,   184,   185,   186,
     187,   188,   189,    -1,   191,   192,   193,   194,   195,   196,
     197,   198,   199,   200,   201,   202,   203,   204,   205,   206,
     207,   208,   209,   210,   211,   212,   213,   214,   215,   216,
     217,   218,    -1,   220,   221,   222,   223,   224,   225,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,    -1,
     277,   278,   279,   280,   281,    -1,   283,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,    -1,   314,   315,   316,
     317,   318,   319,   320,   321,   322,   323,   324,   325,   326,
     327,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,   343,   344,   345,   346,
     347,   348,   349,   350,   351,   352,   353,   354,   355,   356,
     357,   358,   359,   360,   361,   362,   363,   364,   365,   366,
     367,   368,   369,   370,   371,   372,    -1,   374,   375,   376,
     377,   378,   379,   380,   381,    -1,   383,    -1,    -1,   386,
       6,     7,     8,     9,    -1,    11,    12,    13,    14,    15,
      16,    17,    -1,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    35,
      -1,    37,    38,    39,    40,    -1,    -1,    -1,    44,    45,
      46,    -1,    48,    -1,    -1,    51,    52,    53,    -1,    -1,
      -1,    57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,
      76,    77,    -1,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    97,    -1,    99,   100,   101,    -1,   103,    -1,   105,
      -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,
     116,   117,    -1,   119,   120,   121,   122,   123,    -1,    -1,
     126,   127,   128,    -1,   130,   131,   132,   133,    -1,   135,
     136,    -1,    -1,    -1,    -1,    -1,   142,   143,   144,   145,
     146,   147,   148,   149,   150,   151,    -1,   153,    -1,   155,
     156,   157,    -1,    -1,    -1,   161,   162,   163,   164,    -1,
     166,   167,    -1,   169,    -1,   171,   172,   173,   174,   175,
      -1,   177,    -1,   179,   180,   181,    -1,   183,    -1,   185,
      -1,    -1,    -1,   189,    -1,   191,    -1,    -1,   194,    -1,
     196,   197,    -1,   199,   200,   201,    -1,   203,   204,   205,
     206,    -1,    -1,   209,    -1,   211,   212,   213,    -1,   215,
      -1,   217,    -1,    -1,    -1,    -1,   222,    -1,   224,   225,
     226,   227,    -1,    -1,   230,    -1,    -1,   233,   234,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,    -1,   248,    -1,   250,   251,   252,   253,   254,    -1,
     256,   257,    -1,    -1,   260,   261,   262,    -1,    -1,   265,
      -1,    -1,    -1,   269,   270,    -1,    -1,   273,    -1,    -1,
      -1,   277,   278,   279,   280,   281,    -1,   283,   284,   285,
     286,    -1,   288,   289,   290,   291,   292,   293,   294,    -1,
     296,   297,   298,   299,   300,   301,   302,   303,   304,    -1,
     306,   307,   308,   309,   310,   311,   312,    -1,    -1,   315,
     316,   317,    -1,   319,   320,   321,   322,    -1,   324,   325,
      -1,   327,   328,   329,   330,   331,   332,   333,   334,   335,
     336,    -1,   338,   339,   340,    -1,   342,   343,    -1,   345,
      -1,   347,   348,   349,   350,    -1,   352,   353,   354,   355,
      -1,    -1,   358,   359,   360,   361,   362,    -1,    -1,   365,
     366,   367,   368,   369,    -1,   371,   372,    -1,    -1,    -1,
     376,   377,   378,   379,   380,   381,    -1,   383,   384,    -1,
     386,   387,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    31,    32,    33,
      -1,    35,    -1,    37,    38,    39,    40,    -1,    -1,    43,
      44,    45,    46,    -1,    48,    -1,    -1,    51,    52,    53,
      -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,    63,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,
      74,    -1,    76,    77,    -1,    79,    80,    81,    82,    83,
      84,    85,    -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    97,    -1,    99,   100,   101,    -1,   103,
      -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,   123,
      -1,    -1,   126,   127,   128,    -1,   130,   131,   132,   133,
      -1,   135,   136,    -1,    -1,    -1,    -1,    -1,   142,   143,
     144,   145,   146,   147,   148,   149,    -1,   151,    -1,   153,
      -1,   155,   156,   157,    -1,    -1,    -1,   161,   162,   163,
     164,    -1,   166,   167,    -1,   169,    -1,   171,   172,   173,
     174,   175,    -1,   177,    -1,   179,   180,   181,    -1,   183,
      -1,   185,    -1,    -1,    -1,   189,    -1,   191,    -1,    -1,
     194,    -1,   196,   197,    -1,   199,   200,   201,    -1,   203,
     204,   205,   206,    -1,    -1,   209,    -1,   211,   212,   213,
      -1,   215,    -1,   217,    -1,    -1,    -1,    -1,   222,    -1,
     224,   225,   226,   227,    -1,    -1,   230,    -1,    -1,   233,
     234,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,    -1,   248,   249,   250,   251,   252,   253,
     254,    -1,   256,   257,    -1,    -1,   260,   261,   262,    -1,
      -1,   265,   266,    -1,    -1,   269,   270,    -1,    -1,   273,
      -1,    -1,    -1,   277,   278,   279,   280,   281,    -1,   283,
     284,   285,   286,    -1,   288,   289,   290,   291,   292,   293,
     294,    -1,   296,   297,   298,   299,   300,   301,   302,   303,
     304,    -1,   306,   307,   308,   309,   310,   311,   312,    -1,
      -1,   315,   316,   317,    -1,   319,   320,   321,   322,    -1,
     324,   325,    -1,   327,   328,   329,   330,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,    -1,   342,   343,
      -1,   345,    -1,   347,   348,   349,   350,    -1,   352,   353,
     354,   355,    -1,    -1,   358,   359,   360,   361,   362,    -1,
      -1,   365,   366,   367,   368,   369,    -1,   371,   372,    -1,
      -1,    -1,   376,   377,   378,   379,   380,   381,    -1,   383,
      -1,    -1,   386,   387,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    35,    -1,    37,    38,    39,    40,    -1,
      -1,    -1,    44,    45,    46,    -1,    48,    -1,    -1,    51,
      52,    53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,
      -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      72,    -1,    74,    -1,    76,    77,    -1,    79,    80,    81,
      82,    83,    84,    85,    -1,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,   101,
      -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,
      -1,    -1,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,   123,    -1,    -1,   126,   127,   128,    -1,   130,   131,
     132,   133,    -1,   135,   136,    -1,    -1,    -1,    -1,    -1,
     142,   143,   144,   145,   146,   147,   148,   149,    -1,   151,
      -1,   153,    -1,   155,   156,   157,    -1,    -1,    -1,   161,
     162,   163,   164,    -1,   166,   167,    -1,   169,    -1,   171,
     172,   173,   174,   175,    -1,   177,    -1,   179,   180,   181,
      -1,   183,    -1,   185,    -1,    -1,    -1,   189,    -1,   191,
      -1,    -1,   194,    -1,   196,   197,    -1,   199,   200,   201,
      -1,   203,   204,   205,   206,    -1,    -1,   209,    -1,   211,
     212,   213,    -1,   215,    -1,   217,    -1,    -1,    -1,    -1,
     222,    -1,   224,   225,   226,   227,    -1,    -1,   230,    -1,
      -1,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,    -1,   248,    -1,   250,   251,
     252,   253,   254,    -1,   256,   257,    -1,    -1,   260,   261,
     262,    -1,    -1,   265,    -1,    -1,    -1,   269,   270,    -1,
      -1,   273,    -1,    -1,    -1,   277,   278,   279,   280,   281,
      -1,   283,   284,   285,   286,    -1,   288,   289,   290,   291,
     292,   293,   294,    -1,   296,   297,   298,   299,   300,   301,
     302,   303,   304,    -1,   306,   307,   308,   309,   310,   311,
     312,    -1,    -1,   315,   316,   317,    -1,   319,   320,   321,
     322,    -1,   324,   325,    -1,   327,   328,   329,   330,   331,
     332,   333,   334,   335,   336,    -1,   338,   339,   340,    -1,
     342,   343,   344,   345,    -1,   347,   348,   349,   350,    -1,
     352,   353,   354,   355,    -1,    -1,   358,   359,   360,   361,
     362,    -1,    -1,   365,   366,   367,   368,   369,    -1,   371,
     372,    -1,    -1,    -1,   376,   377,   378,   379,   380,   381,
      -1,   383,   384,    -1,   386,   387,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    35,    -1,    37,    38,    39,
      40,    -1,    -1,    -1,    44,    45,    46,    -1,    48,    -1,
      -1,    51,    52,    53,    -1,    -1,    -1,    57,    58,    -1,
      -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    72,    -1,    74,    -1,    76,    77,    -1,    79,
      80,    81,    82,    83,    84,    85,    -1,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,
     100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,
      -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,   123,    -1,    -1,   126,   127,   128,    -1,
     130,   131,   132,   133,    -1,   135,   136,    -1,    -1,    -1,
      -1,    -1,   142,   143,   144,   145,   146,   147,   148,   149,
     150,   151,    -1,   153,    -1,   155,   156,   157,    -1,    -1,
      -1,   161,   162,   163,   164,    -1,   166,   167,    -1,   169,
      -1,   171,   172,   173,   174,   175,    -1,   177,    -1,   179,
     180,   181,    -1,   183,    -1,   185,    -1,    -1,    -1,   189,
      -1,   191,    -1,    -1,   194,    -1,   196,   197,    -1,   199,
     200,   201,    -1,   203,   204,   205,   206,    -1,    -1,   209,
      -1,   211,   212,   213,    -1,   215,    -1,   217,    -1,    -1,
      -1,    -1,   222,    -1,   224,   225,   226,   227,    -1,    -1,
     230,    -1,    -1,   233,   234,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,    -1,   248,    -1,
     250,   251,   252,   253,   254,    -1,   256,   257,    -1,    -1,
     260,   261,   262,    -1,    -1,   265,    -1,    -1,    -1,   269,
     270,    -1,    -1,   273,    -1,    -1,    -1,   277,   278,   279,
     280,   281,    -1,   283,   284,   285,   286,    -1,   288,   289,
     290,   291,   292,   293,   294,    -1,   296,   297,   298,   299,
     300,   301,   302,   303,   304,    -1,   306,   307,   308,   309,
     310,   311,   312,    -1,    -1,   315,   316,   317,    -1,   319,
     320,   321,   322,    -1,   324,   325,    -1,   327,   328,   329,
     330,   331,   332,   333,   334,   335,   336,    -1,   338,   339,
     340,    -1,   342,   343,    -1,   345,    -1,   347,   348,   349,
     350,    -1,   352,   353,   354,   355,    -1,    -1,   358,   359,
     360,   361,   362,    -1,    -1,   365,   366,   367,   368,   369,
      -1,   371,   372,    -1,    -1,    -1,   376,   377,   378,   379,
     380,   381,    -1,   383,   384,    -1,   386,   387,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    33,    -1,    35,    -1,    37,
      38,    39,    40,    -1,    -1,    -1,    44,    45,    46,    -1,
      48,    -1,    -1,    51,    52,    53,    -1,    -1,    -1,    57,
      58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,    77,
      -1,    79,    80,    81,    82,    83,    84,    85,    -1,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,
      -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,
     108,   109,    -1,   111,    -1,    -1,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,   123,    -1,    -1,   126,   127,
     128,    -1,   130,   131,   132,   133,    -1,   135,   136,    -1,
      -1,    -1,    -1,    -1,   142,   143,   144,   145,   146,   147,
     148,   149,   150,   151,    -1,   153,    -1,   155,   156,   157,
      -1,    -1,    -1,   161,   162,   163,   164,    -1,   166,   167,
      -1,   169,    -1,   171,   172,   173,   174,   175,    -1,   177,
      -1,   179,   180,   181,    -1,   183,    -1,   185,    -1,    -1,
      -1,   189,    -1,   191,    -1,    -1,   194,    -1,   196,   197,
      -1,   199,   200,   201,    -1,   203,   204,   205,   206,    -1,
      -1,   209,    -1,   211,   212,   213,    -1,   215,    -1,   217,
      -1,    -1,    -1,    -1,   222,    -1,   224,   225,   226,   227,
      -1,    -1,   230,    -1,    -1,   233,   234,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,    -1,
     248,    -1,   250,   251,   252,   253,   254,    -1,   256,   257,
      -1,    -1,   260,   261,   262,    -1,    -1,   265,    -1,    -1,
      -1,   269,   270,    -1,    -1,   273,    -1,    -1,    -1,   277,
     278,   279,   280,   281,    -1,   283,   284,   285,   286,    -1,
     288,   289,   290,   291,   292,   293,   294,    -1,   296,   297,
     298,   299,   300,   301,   302,   303,   304,    -1,   306,   307,
     308,   309,   310,   311,   312,    -1,    -1,   315,   316,   317,
      -1,   319,   320,   321,   322,    -1,   324,   325,    -1,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,    -1,
     338,   339,   340,    -1,   342,   343,    -1,   345,    -1,   347,
     348,   349,   350,    -1,   352,   353,   354,   355,    -1,    -1,
     358,   359,   360,   361,   362,    -1,    -1,   365,   366,   367,
     368,   369,    -1,   371,   372,    -1,    -1,    -1,   376,   377,
     378,   379,   380,   381,    -1,   383,   384,    -1,   386,   387,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    35,
      -1,    37,    38,    39,    40,    -1,    -1,    -1,    44,    45,
      46,    -1,    48,    -1,    -1,    51,    52,    53,    -1,    -1,
      -1,    57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,
      76,    77,    -1,    79,    80,    81,    82,    83,    84,    85,
      -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    97,    -1,    99,   100,   101,    -1,   103,    -1,   105,
      -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,
     116,   117,    -1,   119,   120,   121,   122,   123,    -1,    -1,
     126,   127,   128,    -1,   130,   131,   132,   133,    -1,   135,
     136,    -1,    -1,    -1,    -1,    -1,   142,   143,   144,   145,
     146,   147,   148,   149,   150,   151,    -1,   153,    -1,   155,
     156,   157,    -1,    -1,    -1,   161,   162,   163,   164,    -1,
     166,   167,    -1,   169,    -1,   171,   172,   173,   174,   175,
      -1,   177,    -1,   179,   180,   181,    -1,   183,    -1,   185,
      -1,    -1,    -1,   189,    -1,   191,    -1,    -1,   194,    -1,
     196,   197,    -1,   199,   200,   201,    -1,   203,   204,   205,
     206,    -1,    -1,   209,    -1,   211,   212,   213,    -1,   215,
      -1,   217,    -1,    -1,    -1,    -1,   222,    -1,   224,   225,
     226,   227,    -1,    -1,   230,    -1,    -1,   233,   234,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,    -1,   248,    -1,   250,   251,   252,   253,   254,    -1,
     256,   257,    -1,    -1,   260,   261,   262,    -1,    -1,   265,
      -1,    -1,    -1,   269,   270,    -1,    -1,   273,    -1,    -1,
      -1,   277,   278,   279,   280,   281,    -1,   283,   284,   285,
     286,    -1,   288,   289,   290,   291,   292,   293,   294,    -1,
     296,   297,   298,   299,   300,   301,   302,   303,   304,    -1,
     306,   307,   308,   309,   310,   311,   312,    -1,    -1,   315,
     316,   317,    -1,   319,   320,   321,   322,    -1,   324,   325,
      -1,   327,   328,   329,   330,   331,   332,   333,   334,   335,
     336,    -1,   338,   339,   340,    -1,   342,   343,    -1,   345,
      -1,   347,   348,   349,   350,    -1,   352,   353,   354,   355,
      -1,    -1,   358,   359,   360,   361,   362,    -1,    -1,   365,
     366,   367,   368,   369,    -1,   371,   372,    -1,    -1,    -1,
     376,   377,   378,   379,   380,   381,    -1,   383,   384,    -1,
     386,   387,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    31,    32,    33,
      -1,    35,    -1,    37,    38,    39,    40,    -1,    -1,    -1,
      44,    45,    46,    -1,    48,    -1,    -1,    51,    52,    53,
      -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,    63,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,
      74,    -1,    76,    77,    -1,    79,    80,    81,    82,    83,
      84,    85,    -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    97,    -1,    99,   100,   101,    -1,   103,
      -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,   123,
      -1,    -1,   126,   127,   128,    -1,   130,   131,   132,   133,
      -1,   135,   136,    -1,    -1,    -1,    -1,    -1,   142,   143,
     144,   145,   146,   147,   148,   149,    -1,   151,    -1,   153,
      -1,   155,   156,   157,    -1,    -1,    -1,   161,   162,   163,
     164,    -1,   166,   167,    -1,   169,    -1,   171,   172,   173,
     174,   175,    -1,   177,    -1,   179,   180,   181,    -1,   183,
      -1,   185,    -1,    -1,    -1,   189,    -1,   191,    -1,    -1,
     194,    -1,   196,   197,    -1,   199,   200,   201,    -1,   203,
     204,   205,   206,    -1,    -1,   209,    -1,   211,   212,   213,
      -1,   215,    -1,   217,    -1,    -1,    -1,    -1,   222,    -1,
     224,   225,   226,   227,    -1,    -1,   230,    -1,    -1,   233,
     234,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,    -1,   248,    -1,   250,   251,   252,   253,
     254,    -1,   256,   257,    -1,    -1,   260,   261,   262,    -1,
      -1,   265,    -1,    -1,    -1,   269,   270,    -1,    -1,   273,
      -1,    -1,    -1,   277,   278,   279,   280,   281,    -1,   283,
     284,   285,   286,    -1,   288,   289,   290,   291,   292,   293,
     294,    -1,   296,   297,   298,   299,   300,   301,   302,   303,
     304,    -1,   306,   307,   308,   309,   310,   311,   312,    -1,
      -1,   315,   316,   317,    -1,   319,   320,   321,   322,    -1,
     324,   325,    -1,   327,   328,   329,   330,   331,   332,   333,
     334,   335,   336,    -1,   338,   339,   340,    -1,   342,   343,
      -1,   345,    -1,   347,   348,   349,   350,    -1,   352,   353,
     354,   355,    -1,    -1,   358,   359,   360,   361,   362,    -1,
      -1,   365,   366,   367,   368,   369,    -1,   371,   372,    -1,
      -1,    -1,   376,   377,   378,   379,   380,   381,    -1,   383,
     384,    -1,   386,   387,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    18,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    35,    -1,    37,    38,    39,    40,    -1,
      -1,    -1,    44,    45,    46,    -1,    48,    -1,    -1,    51,
      52,    53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,
      -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      72,    -1,    74,    -1,    76,    77,    -1,    79,    80,    81,
      82,    83,    84,    85,    -1,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,   101,
      -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,
      -1,    -1,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,   123,    -1,    -1,   126,   127,   128,    -1,   130,   131,
     132,   133,    -1,   135,   136,    -1,    -1,    -1,    -1,    -1,
     142,   143,   144,   145,   146,   147,   148,   149,    -1,   151,
      -1,   153,    -1,   155,   156,   157,    -1,    -1,    -1,   161,
     162,   163,   164,    -1,   166,   167,    -1,   169,    -1,   171,
     172,   173,   174,   175,    -1,   177,    -1,   179,   180,   181,
      -1,   183,    -1,   185,    -1,    -1,    -1,   189,    -1,   191,
      -1,    -1,   194,    -1,   196,   197,    -1,   199,   200,   201,
      -1,   203,   204,   205,   206,    -1,    -1,   209,    -1,   211,
     212,   213,    -1,   215,    -1,   217,    -1,    -1,    -1,    -1,
     222,    -1,   224,   225,   226,   227,    -1,    -1,   230,    -1,
      -1,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,    -1,   248,    -1,   250,   251,
     252,   253,   254,    -1,   256,   257,    -1,    -1,   260,   261,
     262,    -1,    -1,   265,    -1,    -1,    -1,   269,   270,    -1,
      -1,   273,    -1,    -1,    -1,   277,   278,   279,   280,   281,
      -1,   283,   284,   285,   286,    -1,   288,   289,   290,   291,
     292,   293,   294,    -1,   296,   297,   298,   299,   300,   301,
     302,   303,   304,    -1,   306,   307,   308,   309,   310,   311,
     312,    -1,    -1,   315,   316,   317,    -1,   319,   320,   321,
     322,    -1,   324,   325,    -1,   327,   328,   329,   330,   331,
     332,   333,   334,   335,   336,    -1,   338,   339,   340,    -1,
     342,   343,    -1,   345,    -1,   347,   348,   349,   350,    -1,
     352,   353,   354,   355,    -1,    -1,   358,   359,   360,   361,
     362,    -1,    -1,   365,   366,   367,   368,   369,    -1,   371,
     372,    -1,    -1,    -1,   376,   377,   378,   379,   380,   381,
      -1,   383,    -1,    -1,   386,   387,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    35,    -1,    37,    38,    39,
      40,    -1,    -1,    -1,    44,    45,    46,    -1,    48,    -1,
      -1,    51,    52,    53,    -1,    -1,    -1,    57,    58,    -1,
      -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    72,    -1,    74,    -1,    76,    77,    -1,    79,
      80,    81,    82,    83,    84,    85,    -1,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,
     100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,
      -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,   123,    -1,    -1,   126,   127,   128,    -1,
     130,   131,   132,   133,    -1,   135,   136,    -1,    -1,    -1,
      -1,    -1,   142,   143,   144,   145,   146,   147,   148,   149,
      -1,   151,    -1,   153,    -1,   155,   156,   157,    -1,    -1,
      -1,   161,   162,   163,   164,    -1,   166,   167,    -1,   169,
      -1,   171,   172,   173,   174,   175,    -1,   177,    -1,   179,
     180,   181,    -1,   183,    -1,   185,    -1,    -1,    -1,   189,
      -1,   191,    -1,    -1,   194,    -1,   196,   197,    -1,   199,
     200,   201,    -1,   203,   204,   205,   206,    -1,    -1,   209,
      -1,   211,   212,   213,    -1,   215,    -1,   217,    -1,    -1,
      -1,    -1,   222,    -1,   224,   225,   226,   227,    -1,    -1,
     230,    -1,    -1,   233,   234,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,    -1,   248,    -1,
     250,   251,   252,   253,   254,    -1,   256,   257,    -1,    -1,
     260,   261,   262,    -1,    -1,   265,    -1,    -1,    -1,   269,
     270,    -1,    -1,   273,    -1,    -1,    -1,   277,   278,   279,
     280,   281,    -1,   283,   284,   285,   286,    -1,   288,   289,
     290,   291,   292,   293,   294,    -1,   296,   297,   298,   299,
     300,   301,   302,   303,   304,    -1,   306,   307,   308,   309,
     310,   311,   312,    -1,    -1,   315,   316,   317,    -1,   319,
     320,   321,   322,    -1,   324,   325,    -1,   327,   328,   329,
     330,   331,   332,   333,   334,   335,   336,    -1,   338,   339,
     340,    -1,   342,   343,    -1,   345,    -1,   347,   348,   349,
     350,    -1,   352,   353,   354,   355,    -1,    -1,   358,   359,
     360,   361,   362,    -1,    -1,   365,   366,   367,   368,   369,
      -1,   371,   372,    -1,    -1,    -1,   376,   377,   378,   379,
     380,   381,    -1,   383,    -1,    -1,   386,   387,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    33,    -1,    35,    -1,    37,
      38,    39,    40,    -1,    -1,    -1,    44,    45,    46,    -1,
      48,    -1,    -1,    51,    52,    53,    -1,    -1,    -1,    57,
      58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,    77,
      -1,    79,    80,    81,    82,    83,    84,    85,    -1,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,
      -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,
     108,   109,    -1,   111,    -1,    -1,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,   123,    -1,    -1,   126,   127,
     128,    -1,   130,   131,   132,   133,    -1,   135,   136,    -1,
      -1,    -1,    -1,    -1,   142,   143,   144,   145,   146,   147,
     148,   149,    -1,   151,    -1,   153,    -1,   155,   156,   157,
      -1,    -1,    -1,   161,   162,   163,   164,    -1,   166,   167,
      -1,   169,    -1,   171,   172,   173,   174,   175,    -1,   177,
      -1,   179,   180,   181,    -1,   183,    -1,   185,    -1,    -1,
      -1,   189,    -1,   191,    -1,    -1,   194,    -1,   196,   197,
      -1,   199,   200,   201,    -1,   203,   204,   205,   206,    -1,
      -1,   209,    -1,   211,   212,   213,    -1,   215,    -1,   217,
      -1,    -1,    -1,    -1,   222,    -1,   224,   225,   226,   227,
      -1,    -1,   230,    -1,    -1,   233,   234,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,    -1,
     248,    -1,   250,   251,   252,   253,   254,    -1,   256,   257,
      -1,    -1,   260,   261,   262,    -1,    -1,   265,    -1,    -1,
      -1,   269,   270,    -1,    -1,   273,    -1,    -1,    -1,   277,
     278,   279,   280,   281,    -1,   283,   284,   285,   286,    -1,
     288,   289,   290,   291,   292,   293,   294,    -1,   296,   297,
     298,   299,   300,   301,   302,   303,   304,    -1,   306,   307,
     308,   309,   310,   311,   312,    -1,    -1,   315,   316,   317,
      -1,   319,   320,   321,   322,    -1,   324,   325,    -1,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,    -1,
     338,   339,   340,    -1,   342,   343,    -1,   345,    -1,   347,
     348,   349,   350,    -1,   352,   353,   354,   355,    -1,    -1,
     358,   359,   360,   361,   362,    -1,    -1,   365,   366,   367,
     368,   369,    -1,   371,   372,    -1,    -1,    -1,   376,   377,
     378,   379,   380,   381,    -1,   383,    -1,    -1,   386,   387,
       5,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    -1,    37,    38,    39,    40,    41,    42,    -1,    44,
      45,    46,    -1,    48,    49,    50,    51,    52,    53,    -1,
      -1,    -1,    57,    58,    -1,    -1,    -1,    -1,    63,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    74,
      -1,    76,    77,    -1,    79,    80,    81,    82,    83,    84,
      85,    -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    97,    -1,    99,   100,   101,    -1,   103,    -1,
     105,   106,    -1,   108,   109,    -1,   111,    -1,    -1,   114,
     115,   116,   117,    -1,   119,   120,   121,   122,    -1,    -1,
      -1,   126,   127,   128,    -1,   130,   131,    -1,   133,    -1,
     135,   136,    -1,    -1,    -1,    -1,    -1,   142,   143,   144,
     145,   146,   147,   148,   149,    -1,   151,    -1,   153,    -1,
     155,   156,   157,    -1,    -1,    -1,   161,   162,   163,   164,
      -1,   166,   167,    -1,   169,    -1,   171,   172,   173,    -1,
     175,    -1,    -1,    -1,   179,   180,   181,    -1,   183,    -1,
     185,    -1,    -1,    -1,   189,    -1,   191,    -1,    -1,   194,
      -1,   196,   197,    -1,   199,   200,   201,    -1,   203,   204,
     205,   206,    -1,    -1,   209,    -1,   211,   212,   213,   214,
     215,    -1,   217,    -1,    -1,    -1,    -1,   222,    -1,   224,
     225,   226,   227,    -1,    -1,   230,    -1,    -1,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,    -1,   248,    -1,   250,   251,   252,   253,   254,
      -1,   256,   257,    -1,    -1,    -1,   261,   262,    -1,    -1,
     265,    -1,    -1,    -1,   269,   270,    -1,    -1,   273,    -1,
      -1,    -1,   277,   278,   279,   280,   281,    -1,    -1,   284,
     285,   286,    -1,   288,   289,   290,   291,   292,   293,   294,
      -1,   296,   297,   298,   299,   300,   301,   302,   303,   304,
      -1,   306,    -1,   308,   309,   310,   311,   312,    -1,    -1,
     315,   316,   317,    -1,   319,   320,   321,   322,    -1,   324,
     325,    -1,   327,   328,   329,   330,   331,   332,   333,   334,
      -1,   336,    -1,   338,   339,   340,    -1,   342,   343,    -1,
     345,    -1,   347,    -1,   349,    -1,    -1,   352,   353,   354,
     355,    -1,    -1,   358,   359,   360,   361,   362,    -1,    -1,
     365,   366,   367,   368,   369,    -1,   371,   372,    -1,    -1,
      -1,   376,   377,   378,   379,   380,   381,    -1,   383,    -1,
      -1,   386,     5,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    -1,    37,    38,    39,    40,    41,    42,
      -1,    44,    45,    46,    -1,    48,    49,    50,    51,    52,
      53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,
      -1,    74,    -1,    76,    77,    -1,    79,    80,    81,    82,
      83,    84,    85,    -1,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    97,    -1,    99,   100,   101,    -1,
     103,    -1,   105,   106,    -1,   108,   109,    -1,   111,    -1,
      -1,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
      -1,    -1,    -1,   126,   127,   128,    -1,   130,   131,    -1,
     133,    -1,   135,   136,    -1,    -1,    -1,    -1,    -1,   142,
     143,   144,   145,   146,   147,   148,   149,    -1,   151,    -1,
     153,    -1,   155,   156,   157,    -1,    -1,    -1,   161,   162,
     163,   164,    -1,   166,   167,    -1,   169,    -1,   171,   172,
     173,    -1,   175,    -1,    -1,    -1,   179,   180,   181,    -1,
     183,    -1,   185,    -1,    -1,    -1,   189,    -1,   191,    -1,
      -1,   194,    -1,   196,   197,    -1,   199,   200,   201,   202,
     203,   204,   205,   206,    -1,    -1,   209,    -1,   211,   212,
     213,   214,   215,    -1,   217,    -1,    -1,    -1,    -1,   222,
      -1,   224,   225,   226,   227,    -1,    -1,   230,    -1,    -1,
     233,   234,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,    -1,   248,    -1,   250,   251,   252,
     253,    -1,    -1,   256,   257,    -1,    -1,    -1,   261,   262,
      -1,    -1,   265,    -1,    -1,    -1,   269,   270,    -1,    -1,
     273,    -1,    -1,    -1,   277,   278,   279,   280,   281,    -1,
      -1,   284,   285,   286,    -1,   288,   289,   290,   291,   292,
     293,   294,    -1,   296,   297,   298,   299,   300,   301,   302,
     303,   304,    -1,   306,    -1,   308,   309,   310,   311,   312,
      -1,    -1,   315,   316,   317,    -1,   319,   320,   321,   322,
      -1,   324,   325,    -1,   327,   328,   329,   330,   331,   332,
     333,   334,    -1,   336,    -1,   338,   339,   340,    -1,   342,
     343,    -1,   345,    -1,   347,    -1,   349,    -1,    -1,   352,
     353,   354,   355,    -1,    -1,   358,   359,   360,   361,   362,
      -1,    -1,   365,   366,   367,   368,   369,    -1,   371,   372,
      -1,    -1,    -1,   376,   377,   378,   379,   380,   381,    -1,
     383,    -1,    -1,   386,     5,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,    -1,    37,    38,    39,    40,
      41,    42,    -1,    44,    45,    46,    -1,    48,    49,    50,
      51,    52,    53,    -1,    -1,    -1,    57,    58,    -1,    -1,
      -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    72,    -1,    74,    -1,    76,    77,    -1,    79,    80,
      81,    82,    83,    84,    85,    -1,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,
     101,    -1,   103,    -1,   105,   106,    -1,   108,   109,    -1,
     111,    -1,    -1,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,    -1,    -1,    -1,   126,   127,   128,    -1,   130,
     131,    -1,   133,    -1,   135,   136,    -1,    -1,    -1,    -1,
      -1,   142,   143,   144,   145,   146,   147,   148,   149,    -1,
     151,    -1,   153,    -1,   155,   156,   157,    -1,    -1,    -1,
     161,   162,   163,   164,    -1,   166,   167,    -1,   169,    -1,
     171,   172,   173,    -1,   175,    -1,    -1,    -1,   179,   180,
     181,    -1,   183,    -1,   185,    -1,    -1,    -1,   189,    -1,
     191,    -1,    -1,   194,    -1,   196,   197,    -1,   199,   200,
     201,    -1,   203,   204,   205,   206,    -1,    -1,   209,    -1,
     211,   212,   213,   214,   215,    -1,   217,    -1,    -1,    -1,
      -1,   222,    -1,   224,   225,   226,   227,    -1,    -1,   230,
      -1,    -1,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,    -1,   248,    -1,   250,
     251,   252,   253,   254,    -1,   256,   257,    -1,    -1,    -1,
     261,   262,    -1,    -1,   265,    -1,    -1,    -1,   269,   270,
      -1,    -1,   273,    -1,    -1,    -1,   277,   278,   279,   280,
     281,    -1,    -1,   284,   285,   286,    -1,   288,   289,   290,
     291,   292,   293,   294,    -1,   296,   297,   298,   299,   300,
     301,   302,   303,   304,    -1,   306,    -1,   308,   309,   310,
     311,   312,    -1,    -1,   315,   316,   317,    -1,   319,   320,
     321,   322,    -1,   324,   325,    -1,   327,   328,   329,   330,
     331,   332,   333,   334,    -1,   336,    -1,   338,   339,   340,
      -1,   342,   343,    -1,   345,    -1,   347,    -1,   349,    -1,
      -1,   352,   353,   354,   355,    -1,    -1,   358,   359,   360,
     361,   362,    -1,    -1,   365,   366,   367,   368,   369,    -1,
     371,   372,    -1,    -1,    -1,   376,   377,   378,   379,   380,
     381,    -1,   383,    -1,    -1,   386,     5,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    35,    -1,    37,    38,
      39,    40,    41,    42,    -1,    44,    45,    46,    -1,    48,
      49,    50,    51,    52,    53,    -1,    -1,    -1,    57,    58,
      -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    72,    -1,    74,    -1,    76,    77,    -1,
      79,    80,    81,    82,    83,    84,    85,    -1,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,
      99,   100,   101,    -1,   103,    -1,   105,   106,    -1,   108,
     109,    -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,    -1,    -1,    -1,   126,   127,   128,
      -1,   130,   131,    -1,   133,    -1,   135,   136,    -1,    -1,
      -1,    -1,    -1,   142,   143,   144,   145,   146,   147,   148,
     149,    -1,   151,    -1,   153,    -1,   155,   156,   157,    -1,
      -1,    -1,   161,   162,   163,   164,    -1,   166,   167,    -1,
     169,    -1,   171,   172,   173,    -1,   175,    -1,    -1,    -1,
     179,   180,   181,    -1,   183,    -1,   185,    -1,    -1,    -1,
     189,    -1,   191,    -1,    -1,   194,    -1,   196,   197,    -1,
     199,   200,   201,    -1,   203,   204,   205,   206,    -1,    -1,
     209,    -1,   211,   212,   213,   214,   215,    -1,   217,    -1,
      -1,    -1,    -1,   222,    -1,   224,   225,   226,   227,    -1,
      -1,   230,    -1,    -1,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,    -1,   248,
      -1,   250,   251,   252,   253,    -1,    -1,   256,   257,    -1,
      -1,    -1,   261,   262,    -1,    -1,   265,    -1,    -1,    -1,
     269,   270,    -1,    -1,   273,    -1,    -1,    -1,   277,   278,
     279,   280,   281,    -1,    -1,   284,   285,   286,    -1,   288,
     289,   290,   291,   292,   293,   294,    -1,   296,   297,   298,
     299,   300,   301,   302,   303,   304,    -1,   306,    -1,   308,
     309,   310,   311,   312,    -1,    -1,   315,   316,   317,    -1,
     319,   320,   321,   322,    -1,   324,   325,    -1,   327,   328,
     329,   330,   331,   332,   333,   334,    -1,   336,    -1,   338,
     339,   340,    -1,   342,   343,    -1,   345,    -1,   347,    -1,
     349,    -1,    -1,   352,   353,   354,   355,    -1,    -1,   358,
     359,   360,   361,   362,    -1,    -1,   365,   366,   367,   368,
     369,    -1,   371,   372,    -1,    -1,    -1,   376,   377,   378,
     379,   380,   381,    -1,   383,    -1,    -1,   386,     5,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    35,    -1,
      37,    38,    39,    40,    41,    42,    -1,    44,    45,    46,
      -1,    48,    49,    50,    51,    52,    53,    -1,    -1,    -1,
      57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,
      77,    -1,    79,    80,    81,    82,    83,    84,    85,    -1,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      97,    -1,    99,   100,   101,    -1,   103,    -1,   105,   106,
      -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,    -1,    -1,    -1,   126,
     127,   128,    -1,   130,   131,    -1,   133,    -1,   135,   136,
      -1,    -1,    -1,    -1,    -1,   142,   143,   144,   145,   146,
     147,   148,   149,    -1,   151,    -1,   153,    -1,   155,   156,
     157,    -1,    -1,    -1,   161,   162,   163,   164,    -1,   166,
     167,    -1,   169,    -1,   171,   172,   173,    -1,   175,    -1,
      -1,    -1,   179,   180,   181,    -1,   183,    -1,   185,    -1,
      -1,    -1,   189,    -1,   191,    -1,    -1,   194,    -1,   196,
     197,    -1,   199,   200,   201,    -1,   203,   204,   205,   206,
      -1,    -1,   209,    -1,   211,   212,   213,   214,   215,    -1,
     217,    -1,    -1,    -1,    -1,   222,    -1,   224,   225,   226,
     227,    -1,    -1,   230,    -1,    -1,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
      -1,   248,    -1,   250,   251,   252,   253,    -1,    -1,   256,
     257,    -1,    -1,    -1,   261,   262,    -1,    -1,   265,    -1,
      -1,    -1,   269,   270,    -1,    -1,   273,    -1,    -1,    -1,
     277,   278,   279,   280,   281,    -1,    -1,   284,   285,   286,
      -1,   288,   289,   290,   291,   292,   293,   294,    -1,   296,
     297,   298,   299,   300,   301,   302,   303,   304,    -1,   306,
      -1,   308,   309,   310,   311,   312,    -1,    -1,   315,   316,
     317,    -1,   319,    -1,   321,   322,    -1,   324,   325,    -1,
     327,   328,   329,   330,   331,   332,   333,   334,    -1,   336,
      -1,   338,   339,   340,    -1,   342,   343,    -1,   345,    -1,
     347,    -1,   349,    -1,    -1,   352,   353,   354,   355,    -1,
      -1,   358,   359,   360,   361,   362,    -1,    -1,   365,   366,
     367,   368,   369,    -1,   371,   372,    -1,    -1,    -1,   376,
     377,   378,   379,   380,   381,    -1,   383,    -1,    -1,   386,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    20,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    35,
      -1,    37,    38,    39,    40,    -1,    42,    -1,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    -1,    -1,
      -1,    57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,
      76,    77,    -1,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,    91,    92,    93,    94,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,   105,
      -1,   107,   108,   109,    -1,   111,   112,   113,   114,    -1,
     116,   117,   118,   119,   120,   121,   122,   123,   124,   125,
     126,   127,   128,   129,   130,   131,   132,   133,   134,   135,
     136,   137,   138,   139,   140,   141,   142,   143,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,    -1,   155,
     156,   157,   158,   159,   160,   161,   162,   163,   164,   165,
     166,   167,   168,   169,   170,   171,   172,   173,   174,   175,
      -1,   177,   178,   179,   180,   181,   182,   183,   184,   185,
     186,   187,   188,   189,    -1,   191,   192,   193,   194,   195,
     196,   197,   198,   199,   200,   201,   202,   203,   204,   205,
     206,   207,   208,   209,    -1,   211,   212,   213,    -1,   215,
     216,   217,   218,    -1,   220,   221,   222,   223,   224,   225,
     226,   227,   228,   229,   230,   231,   232,   233,   234,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,   249,   250,   251,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
      -1,   277,   278,   279,   280,   281,    -1,   283,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,    -1,   314,   315,
     316,   317,   318,   319,   320,   321,   322,   323,   324,   325,
     326,   327,   328,   329,   330,   331,   332,   333,   334,   335,
     336,   337,   338,   339,   340,   341,   342,   343,   344,   345,
     346,   347,   348,   349,   350,   351,   352,   353,   354,   355,
     356,   357,   358,   359,   360,   361,   362,   363,   364,   365,
     366,   367,   368,   369,   370,   371,   372,    -1,   374,   375,
     376,   377,   378,   379,   380,   381,    -1,   383,    -1,    -1,
     386,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    20,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    31,    32,    33,    -1,
      35,    -1,    37,    38,    39,    40,    -1,    42,    -1,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    -1,
      -1,    -1,    57,    58,    -1,    -1,    -1,    -1,    63,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    74,
      -1,    76,    77,    -1,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,    -1,   107,   108,   109,    -1,   111,   112,   113,   114,
      -1,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,    -1,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,    -1,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,    -1,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,    -1,   211,   212,   213,    -1,
     215,   216,   217,   218,    -1,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,    -1,   277,   278,   279,   280,   281,    -1,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,    -1,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,    -1,   374,
     375,   376,   377,   378,   379,   380,   381,    -1,   383,    -1,
      -1,   386,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    20,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    31,    32,    33,
      -1,    35,    -1,    37,    38,    39,    40,    -1,    42,    -1,
      44,    45,    46,    -1,    48,    49,    50,    51,    52,    53,
      -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,    63,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,
      74,    -1,    76,    -1,    -1,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    89,    90,    91,    92,    93,
      94,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,   105,    -1,   107,   108,   109,    -1,   111,   112,   113,
     114,    -1,   116,   117,   118,   119,   120,   121,   122,   123,
     124,   125,   126,   127,   128,   129,   130,   131,   132,   133,
     134,   135,   136,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,   147,   148,   149,   150,   151,   152,   153,
      -1,   155,   156,   157,   158,   159,   160,   161,   162,   163,
     164,   165,   166,   167,   168,   169,   170,   171,   172,   173,
     174,   175,    -1,   177,   178,   179,   180,   181,   182,   183,
     184,   185,   186,   187,   188,   189,    -1,   191,   192,   193,
     194,   195,   196,   197,   198,   199,   200,   201,   202,   203,
     204,   205,   206,   207,   208,   209,    -1,   211,   212,   213,
      -1,   215,   216,   217,   218,    -1,   220,   221,   222,   223,
     224,   225,   226,   227,   228,   229,   230,   231,   232,   233,
     234,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,   249,   250,   251,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,   263,
     264,   265,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,    -1,   277,   278,   279,   280,   281,    -1,   283,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,    -1,
     314,   315,   316,   317,   318,   319,   320,   321,   322,   323,
     324,   325,   326,   327,   328,   329,   330,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,   343,
     344,   345,   346,   347,   348,   349,   350,   351,   352,   353,
     354,   355,   356,   357,   358,   359,   360,   361,   362,   363,
     364,   365,   366,   367,   368,   369,   370,   371,   372,    -1,
     374,   375,   376,   377,   378,   379,   380,   381,    -1,   383,
      -1,    -1,   386,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    20,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    31,    32,
      33,    -1,    35,    -1,    37,    38,    39,    40,    -1,    42,
      -1,    44,    45,    46,    -1,    48,    49,    50,    51,    52,
      53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    89,    90,    91,    92,
      93,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,    -1,   107,   108,   109,    -1,   111,   112,
     113,   114,    -1,   116,   117,   118,   119,   120,   121,   122,
     123,   124,   125,   126,   127,   128,   129,   130,   131,   132,
     133,   134,   135,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,   151,   152,
     153,    -1,   155,   156,   157,   158,   159,   160,   161,   162,
     163,   164,   165,   166,   167,   168,   169,   170,   171,   172,
     173,   174,   175,    -1,   177,   178,   179,   180,   181,   182,
     183,   184,   185,   186,   187,   188,   189,    -1,   191,   192,
     193,   194,   195,   196,   197,   198,   199,   200,   201,   202,
     203,   204,   205,   206,   207,   208,   209,    -1,   211,   212,
     213,    -1,   215,   216,   217,   218,    -1,   220,   221,   222,
     223,   224,   225,   226,   227,   228,   229,   230,   231,   232,
     233,   234,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,   250,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,    -1,   277,   278,   279,   280,   281,    -1,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
      -1,   314,   315,   316,   317,   318,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,   347,   348,   349,   350,   351,   352,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
     363,   364,   365,   366,   367,   368,   369,   370,   371,   372,
      -1,   374,   375,   376,   377,   378,   379,   380,   381,    -1,
     383,    -1,    -1,   386,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    35,    -1,    37,    38,    39,    40,    -1,
      -1,    -1,    44,    45,    46,    -1,    48,    -1,    -1,    51,
      52,    53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,
      -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      72,    -1,    74,    -1,    76,    77,    -1,    79,    80,    81,
      82,    83,    84,    85,    -1,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    97,    98,    99,   100,   101,
     102,   103,   104,   105,    -1,    -1,   108,   109,    -1,   111,
      -1,    -1,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,   123,    -1,    -1,   126,   127,   128,    -1,   130,   131,
     132,   133,    -1,   135,   136,   137,    -1,    -1,    -1,    -1,
     142,   143,   144,   145,   146,   147,   148,   149,    -1,   151,
      -1,   153,    -1,   155,   156,   157,    -1,    -1,    -1,   161,
     162,   163,   164,    -1,   166,   167,    -1,   169,    -1,   171,
     172,   173,   174,   175,    -1,   177,    -1,   179,   180,   181,
      -1,   183,    -1,   185,   186,    -1,   188,   189,    -1,   191,
      -1,    -1,   194,    -1,   196,   197,   198,   199,   200,   201,
     202,   203,   204,   205,   206,    -1,   208,   209,    -1,   211,
     212,   213,    -1,   215,    -1,   217,    -1,    -1,   220,   221,
     222,   223,   224,   225,   226,   227,    -1,   229,   230,   231,
      -1,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,    -1,   256,   257,   258,    -1,   260,   261,
     262,    -1,    -1,   265,   266,    -1,    -1,   269,   270,    -1,
      -1,   273,   274,   275,    -1,   277,   278,   279,   280,   281,
      -1,   283,   284,   285,   286,    -1,   288,   289,   290,   291,
     292,   293,   294,    -1,   296,   297,   298,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,    -1,    -1,   315,   316,   317,    -1,   319,   320,   321,
     322,   323,   324,   325,    -1,   327,   328,   329,   330,   331,
     332,   333,   334,   335,   336,    -1,   338,   339,   340,    -1,
     342,   343,    -1,   345,    -1,   347,   348,   349,   350,    -1,
     352,   353,   354,   355,    -1,    -1,   358,   359,   360,   361,
     362,    -1,    -1,   365,   366,   367,   368,   369,   370,   371,
     372,    -1,    -1,    -1,   376,   377,   378,   379,   380,   381,
      -1,   383,    -1,    -1,   386,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      31,    32,    33,    -1,    35,    -1,    37,    38,    39,    40,
      -1,    -1,    -1,    44,    45,    46,    -1,    48,    -1,    -1,
      51,    52,    53,    -1,    -1,    -1,    57,    58,    -1,    -1,
      -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    72,    -1,    74,    -1,    76,    77,    -1,    79,    80,
      81,    82,    83,    84,    85,    -1,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,
     101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,
     111,    -1,    -1,   114,   115,   116,   117,   118,   119,   120,
     121,   122,   123,    -1,    -1,   126,   127,   128,   129,   130,
     131,   132,   133,    -1,   135,   136,    -1,    -1,    -1,    -1,
      -1,   142,   143,   144,   145,   146,   147,   148,   149,    -1,
     151,    -1,   153,    -1,   155,   156,   157,    -1,    -1,    -1,
     161,   162,   163,   164,    -1,   166,   167,    -1,   169,    -1,
     171,   172,   173,   174,   175,    -1,   177,    -1,   179,   180,
     181,    -1,   183,   184,   185,    -1,    -1,    -1,   189,    -1,
     191,    -1,    -1,   194,    -1,   196,   197,    -1,   199,   200,
     201,    -1,   203,   204,   205,   206,    -1,    -1,   209,    -1,
     211,   212,   213,    -1,   215,    -1,   217,    -1,    -1,    -1,
      -1,   222,    -1,   224,   225,   226,   227,    -1,    -1,   230,
     231,    -1,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,    -1,   248,    -1,   250,
     251,   252,   253,   254,    -1,   256,   257,    -1,    -1,   260,
     261,   262,    -1,    -1,   265,    -1,    -1,    -1,   269,   270,
      -1,    -1,   273,    -1,    -1,    -1,   277,   278,   279,   280,
     281,    -1,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,    -1,   296,   297,   298,   299,   300,
     301,   302,   303,   304,    -1,   306,   307,   308,   309,   310,
     311,   312,    -1,    -1,   315,   316,   317,    -1,   319,   320,
     321,   322,    -1,   324,   325,    -1,   327,   328,   329,   330,
     331,   332,   333,   334,   335,   336,    -1,   338,   339,   340,
      -1,   342,   343,    -1,   345,    -1,   347,   348,   349,   350,
      -1,   352,   353,   354,   355,    -1,   357,   358,   359,   360,
     361,   362,    -1,    -1,   365,   366,   367,   368,   369,    -1,
     371,   372,    -1,    -1,    -1,   376,   377,   378,   379,   380,
     381,    -1,   383,    -1,    -1,   386,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    35,    -1,    37,    38,    39,
      40,    -1,    -1,    -1,    44,    45,    46,    -1,    48,    -1,
      -1,    51,    52,    53,    -1,    -1,    -1,    57,    58,    -1,
      -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    72,    -1,    74,    -1,    76,    77,    -1,    79,
      80,    81,    82,    83,    84,    85,    -1,    87,    88,    89,
      -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,
     100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,
      -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,   123,    -1,    -1,   126,   127,   128,    -1,
     130,   131,   132,   133,    -1,   135,   136,    -1,    -1,    -1,
      -1,    -1,   142,   143,   144,   145,   146,   147,   148,   149,
      -1,   151,    -1,   153,    -1,   155,   156,   157,    -1,    -1,
      -1,   161,   162,   163,   164,    -1,   166,   167,    -1,   169,
      -1,   171,   172,   173,   174,   175,    -1,   177,    -1,   179,
     180,   181,    -1,   183,    -1,   185,    -1,    -1,    -1,   189,
      -1,   191,    -1,    -1,   194,    -1,   196,   197,    -1,   199,
     200,   201,    -1,   203,   204,   205,   206,    -1,    -1,   209,
      -1,   211,   212,   213,    -1,   215,    -1,   217,    -1,    -1,
      -1,    -1,   222,    -1,   224,   225,   226,   227,    -1,    -1,
     230,    -1,    -1,   233,   234,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,    -1,   248,   249,
     250,   251,   252,   253,   254,    -1,   256,   257,    -1,    -1,
     260,   261,   262,    -1,    -1,   265,   266,    -1,    -1,   269,
     270,    -1,    -1,   273,    -1,    -1,    -1,   277,   278,   279,
     280,   281,    -1,   283,   284,   285,   286,    -1,   288,   289,
     290,   291,   292,   293,   294,    -1,   296,   297,   298,   299,
     300,   301,   302,   303,   304,    -1,   306,   307,   308,   309,
     310,   311,   312,    -1,    -1,   315,   316,   317,    -1,   319,
     320,   321,   322,    -1,   324,   325,    -1,   327,   328,   329,
     330,   331,   332,   333,   334,   335,   336,    -1,   338,   339,
     340,    -1,   342,   343,    -1,   345,    -1,   347,   348,   349,
     350,    -1,   352,   353,   354,   355,    -1,    -1,   358,   359,
     360,   361,   362,    -1,    -1,   365,   366,   367,   368,   369,
      -1,   371,   372,    -1,    -1,    -1,   376,   377,   378,   379,
     380,   381,    -1,   383,    -1,    -1,   386,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    31,    32,    33,    -1,    35,    -1,    37,    38,
      39,    40,    -1,    -1,    -1,    44,    45,    46,    -1,    48,
      -1,    -1,    51,    52,    53,    -1,    -1,    -1,    57,    58,
      -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    72,    -1,    74,    -1,    76,    77,    -1,
      79,    80,    81,    82,    83,    84,    85,    -1,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,
      99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,
     109,    -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,   123,    -1,    -1,   126,   127,   128,
      -1,   130,   131,   132,   133,    -1,   135,   136,    -1,    -1,
      -1,    -1,    -1,   142,   143,   144,   145,   146,   147,   148,
     149,    -1,   151,    -1,   153,    -1,   155,   156,   157,    -1,
      -1,    -1,   161,   162,   163,   164,    -1,   166,   167,    -1,
     169,    -1,   171,   172,   173,   174,   175,    -1,   177,    -1,
     179,   180,   181,    -1,   183,    -1,   185,    -1,    -1,    -1,
     189,    -1,   191,    -1,    -1,   194,    -1,   196,   197,    -1,
     199,   200,   201,    -1,   203,   204,   205,   206,    -1,    -1,
     209,    -1,   211,   212,   213,    -1,   215,    -1,   217,    -1,
      -1,    -1,    -1,   222,    -1,   224,   225,   226,   227,    -1,
      -1,   230,    -1,    -1,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,    -1,   248,
     249,   250,   251,   252,   253,   254,    -1,   256,   257,    -1,
      -1,   260,   261,   262,    -1,    -1,   265,   266,    -1,   268,
     269,   270,    -1,    -1,   273,    -1,    -1,    -1,   277,   278,
     279,   280,   281,    -1,   283,   284,   285,   286,    -1,   288,
     289,   290,   291,   292,   293,   294,    -1,   296,   297,   298,
     299,   300,   301,   302,   303,   304,    -1,   306,   307,   308,
     309,   310,   311,   312,    -1,    -1,   315,   316,   317,    -1,
     319,   320,   321,   322,    -1,   324,   325,    -1,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,    -1,   338,
     339,   340,    -1,   342,   343,    -1,   345,    -1,   347,   348,
     349,   350,    -1,   352,   353,   354,   355,    -1,    -1,   358,
     359,   360,   361,   362,    -1,    -1,   365,   366,   367,   368,
     369,    -1,   371,   372,    -1,    -1,    -1,   376,   377,   378,
     379,   380,   381,    -1,   383,    -1,    -1,   386,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    33,    -1,    35,    -1,    37,
      38,    39,    40,    -1,    -1,    -1,    44,    45,    46,    -1,
      48,    -1,    -1,    51,    52,    53,    -1,    -1,    -1,    57,
      58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,    77,
      -1,    79,    80,    81,    82,    83,    84,    85,    -1,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,
      -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,
     108,   109,    -1,   111,    -1,    -1,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,   123,    -1,    -1,   126,   127,
     128,    -1,   130,   131,   132,   133,    -1,   135,   136,    -1,
      -1,    -1,    -1,    -1,   142,   143,   144,   145,   146,   147,
     148,   149,    -1,   151,    -1,   153,    -1,   155,   156,   157,
      -1,    -1,    -1,   161,   162,   163,   164,    -1,   166,   167,
      -1,   169,    -1,   171,   172,   173,   174,   175,    -1,   177,
      -1,   179,   180,   181,    -1,   183,    -1,   185,    -1,    -1,
      -1,   189,    -1,   191,    -1,    -1,   194,    -1,   196,   197,
      -1,   199,   200,   201,    -1,   203,   204,   205,   206,    -1,
      -1,   209,    -1,   211,   212,   213,    -1,   215,    -1,   217,
      -1,    -1,    -1,    -1,   222,    -1,   224,   225,   226,   227,
      -1,    -1,   230,    -1,    -1,   233,   234,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,    -1,
     248,   249,   250,   251,   252,   253,   254,    -1,   256,   257,
      -1,    -1,   260,   261,   262,    -1,    -1,   265,   266,    -1,
      -1,   269,   270,    -1,    -1,   273,    -1,    -1,    -1,   277,
     278,   279,   280,   281,    -1,   283,   284,   285,   286,    -1,
     288,   289,   290,   291,   292,   293,   294,    -1,   296,   297,
     298,   299,   300,   301,   302,   303,   304,    -1,   306,   307,
     308,   309,   310,   311,   312,    -1,    -1,   315,   316,   317,
      -1,   319,   320,   321,   322,    -1,   324,   325,    -1,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,    -1,   342,   343,    -1,   345,    -1,   347,
     348,   349,   350,    -1,   352,   353,   354,   355,    -1,    -1,
     358,   359,   360,   361,   362,    -1,    -1,   365,   366,   367,
     368,   369,    -1,   371,   372,    -1,    -1,    -1,   376,   377,
     378,   379,   380,   381,    -1,   383,    -1,    -1,   386,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    -1,    30,    31,    32,    33,    -1,    35,    -1,
      37,    38,    39,    40,    -1,    -1,    -1,    44,    45,    46,
      -1,    48,    -1,    -1,    51,    52,    53,    -1,    -1,    -1,
      57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,
      77,    -1,    79,    80,    81,    82,    83,    84,    85,    -1,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      97,    -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,
      -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
      -1,    -1,    -1,    -1,    -1,   142,   143,   144,   145,   146,
     147,   148,   149,    -1,   151,    -1,   153,    -1,   155,   156,
     157,    -1,    -1,    -1,   161,   162,   163,   164,    -1,   166,
     167,    -1,   169,    -1,   171,   172,   173,   174,   175,    -1,
     177,    -1,   179,   180,   181,    -1,   183,    -1,   185,    -1,
      -1,    -1,   189,    -1,   191,    -1,    -1,   194,    -1,   196,
     197,    -1,   199,   200,   201,    -1,   203,   204,   205,   206,
      -1,    -1,   209,    -1,   211,   212,   213,    -1,   215,    -1,
     217,    -1,    -1,    -1,    -1,   222,    -1,   224,   225,   226,
     227,    -1,    -1,   230,    -1,    -1,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
      -1,   248,   249,   250,   251,   252,   253,   254,    -1,   256,
     257,    -1,    -1,   260,   261,   262,    -1,    -1,   265,   266,
      -1,    -1,   269,   270,    -1,    -1,   273,    -1,    -1,    -1,
     277,   278,   279,   280,   281,    -1,   283,   284,   285,   286,
      -1,   288,   289,   290,   291,   292,   293,   294,    -1,   296,
     297,   298,   299,   300,   301,   302,   303,   304,    -1,   306,
     307,   308,   309,   310,   311,   312,    -1,    -1,   315,   316,
     317,    -1,   319,   320,   321,   322,    -1,   324,   325,    -1,
     327,   328,   329,   330,   331,   332,   333,   334,   335,   336,
      -1,   338,   339,   340,    -1,   342,   343,    -1,   345,    -1,
     347,   348,   349,   350,    -1,   352,   353,   354,   355,    -1,
      -1,   358,   359,   360,   361,   362,    -1,   364,   365,   366,
     367,   368,   369,    -1,   371,   372,    -1,    -1,    -1,   376,
     377,   378,   379,   380,   381,    -1,   383,    -1,    -1,   386,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    35,
      -1,    37,    38,    39,    40,    -1,    -1,    -1,    44,    45,
      46,    -1,    48,    -1,    -1,    51,    52,    53,    -1,    -1,
      -1,    57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,
      76,    77,    -1,    79,    80,    81,    82,    83,    84,    85,
      -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    97,    -1,    99,   100,   101,    -1,   103,    -1,   105,
      -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,
     116,   117,    -1,   119,   120,   121,   122,   123,    -1,    -1,
     126,   127,   128,    -1,   130,   131,   132,   133,    -1,   135,
     136,    -1,    -1,    -1,    -1,    -1,   142,   143,   144,   145,
     146,   147,   148,   149,    -1,   151,    -1,   153,    -1,   155,
     156,   157,    -1,    -1,    -1,   161,   162,   163,   164,    -1,
     166,   167,    -1,   169,    -1,   171,   172,   173,   174,   175,
      -1,   177,    -1,   179,   180,   181,    -1,   183,    -1,   185,
      -1,    -1,    -1,   189,    -1,   191,    -1,    -1,   194,    -1,
     196,   197,    -1,   199,   200,   201,    -1,   203,   204,   205,
     206,    -1,    -1,   209,    -1,   211,   212,   213,    -1,   215,
      -1,   217,    -1,    -1,    -1,    -1,   222,    -1,   224,   225,
     226,   227,    -1,    -1,   230,    -1,    -1,   233,   234,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,    -1,   248,   249,   250,   251,   252,   253,   254,    -1,
     256,   257,    -1,    -1,   260,   261,   262,    -1,    -1,   265,
     266,    -1,    -1,   269,   270,    -1,    -1,   273,    -1,    -1,
      -1,   277,   278,   279,   280,   281,    -1,   283,   284,   285,
     286,    -1,   288,   289,   290,   291,   292,   293,   294,    -1,
     296,   297,   298,   299,   300,   301,   302,   303,   304,    -1,
     306,   307,   308,   309,   310,   311,   312,    -1,    -1,   315,
     316,   317,    -1,   319,   320,   321,   322,    -1,   324,   325,
      -1,   327,   328,   329,   330,   331,   332,   333,   334,   335,
     336,    -1,   338,   339,   340,    -1,   342,   343,    -1,   345,
      -1,   347,   348,   349,   350,    -1,   352,   353,   354,   355,
      -1,    -1,   358,   359,   360,   361,   362,    -1,    -1,   365,
     366,   367,   368,   369,    -1,   371,   372,    -1,    -1,    -1,
     376,   377,   378,   379,   380,   381,    -1,   383,    -1,    -1,
     386,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    31,    32,    33,    -1,
      35,    -1,    37,    38,    39,    40,    -1,    -1,    -1,    44,
      45,    46,    -1,    48,    -1,    -1,    51,    52,    53,    -1,
      -1,    -1,    57,    58,    -1,    -1,    -1,    -1,    63,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    74,
      -1,    76,    77,    -1,    79,    80,    81,    82,    83,    84,
      85,    -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    97,    -1,    99,   100,   101,    -1,   103,    -1,
     105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,
     115,   116,   117,    -1,   119,   120,   121,   122,   123,    -1,
      -1,   126,   127,   128,    -1,   130,   131,   132,   133,    -1,
     135,   136,    -1,    -1,    -1,    -1,    -1,   142,   143,   144,
     145,   146,   147,   148,   149,    -1,   151,    -1,   153,    -1,
     155,   156,   157,    -1,    -1,    -1,   161,   162,   163,   164,
      -1,   166,   167,    -1,   169,    -1,   171,   172,   173,   174,
     175,    -1,   177,    -1,   179,   180,   181,    -1,   183,    -1,
     185,    -1,   187,    -1,   189,    -1,   191,    -1,    -1,   194,
      -1,   196,   197,    -1,   199,   200,   201,   202,   203,   204,
     205,   206,    -1,    -1,   209,    -1,   211,   212,   213,    -1,
     215,    -1,   217,    -1,    -1,    -1,    -1,   222,    -1,   224,
     225,   226,   227,    -1,    -1,   230,    -1,    -1,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,    -1,   248,    -1,   250,   251,   252,   253,   254,
      -1,   256,   257,    -1,    -1,   260,   261,   262,    -1,    -1,
     265,    -1,    -1,    -1,   269,   270,    -1,    -1,   273,    -1,
      -1,    -1,   277,   278,   279,   280,   281,    -1,   283,   284,
     285,   286,    -1,   288,   289,   290,   291,   292,   293,   294,
      -1,   296,   297,   298,   299,   300,   301,   302,   303,   304,
      -1,   306,   307,   308,   309,   310,   311,   312,    -1,    -1,
     315,   316,   317,    -1,   319,   320,   321,   322,    -1,   324,
     325,    -1,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,    -1,   338,   339,   340,    -1,   342,   343,    -1,
     345,    -1,   347,   348,   349,   350,    -1,   352,   353,   354,
     355,    -1,    -1,   358,   359,   360,   361,   362,    -1,    -1,
     365,   366,   367,   368,   369,    -1,   371,   372,    -1,    -1,
      -1,   376,   377,   378,   379,   380,   381,    -1,   383,    -1,
      -1,   386,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    31,    32,    33,
      -1,    35,    -1,    37,    38,    39,    40,    -1,    -1,    -1,
      44,    45,    46,    -1,    48,    -1,    -1,    51,    52,    53,
      -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,    63,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,
      74,    -1,    76,    77,    -1,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    97,    -1,    99,   100,   101,    -1,   103,
      -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,   123,
      -1,    -1,   126,   127,   128,    -1,   130,   131,   132,   133,
      -1,   135,   136,    -1,    -1,    -1,    -1,    -1,   142,   143,
     144,   145,   146,   147,   148,   149,    -1,   151,    -1,   153,
      -1,   155,   156,   157,    -1,    -1,    -1,   161,   162,   163,
     164,    -1,   166,   167,    -1,   169,    -1,   171,   172,   173,
     174,   175,    -1,   177,    -1,   179,   180,   181,    -1,   183,
      -1,   185,    -1,    -1,    -1,   189,    -1,   191,    -1,    -1,
     194,    -1,   196,   197,    -1,   199,   200,   201,    -1,   203,
     204,   205,   206,    -1,    -1,   209,    -1,   211,   212,   213,
      -1,   215,    -1,   217,    -1,    -1,    -1,    -1,   222,    -1,
     224,   225,   226,   227,    -1,    -1,   230,    -1,    -1,   233,
     234,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,    -1,   248,    -1,   250,   251,   252,   253,
     254,    -1,   256,   257,    -1,    -1,   260,   261,   262,    -1,
      -1,   265,    -1,    -1,    -1,   269,   270,    -1,    -1,   273,
      -1,    -1,    -1,   277,   278,   279,   280,   281,    -1,   283,
     284,   285,   286,    -1,   288,   289,   290,   291,   292,   293,
     294,    -1,   296,   297,   298,   299,   300,   301,   302,   303,
     304,    -1,   306,   307,   308,   309,   310,   311,   312,    -1,
      -1,   315,   316,   317,    -1,   319,   320,   321,   322,    -1,
     324,   325,    -1,   327,   328,   329,   330,   331,   332,   333,
     334,   335,   336,    -1,   338,   339,   340,    -1,   342,   343,
      -1,   345,    -1,   347,   348,   349,   350,    -1,   352,   353,
     354,   355,    -1,    -1,   358,   359,   360,   361,   362,    -1,
      -1,   365,   366,   367,   368,   369,    -1,   371,   372,    -1,
      -1,    -1,   376,   377,   378,   379,   380,   381,    -1,   383,
      -1,    -1,   386,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    31,    32,
      33,    -1,    35,    -1,    37,    38,    39,    40,    -1,    -1,
      -1,    44,    45,    46,    -1,    48,    -1,    -1,    51,    52,
      53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,
      -1,    74,    -1,    76,    77,    -1,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    97,    -1,    99,   100,   101,    -1,
     103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,
      -1,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
     123,    -1,    -1,   126,   127,   128,    -1,   130,   131,   132,
     133,    -1,   135,   136,    -1,    -1,    -1,    -1,    -1,   142,
     143,   144,   145,   146,   147,   148,   149,    -1,   151,    -1,
     153,    -1,   155,   156,   157,    -1,    -1,    -1,   161,   162,
     163,   164,    -1,   166,   167,    -1,   169,    -1,   171,   172,
     173,   174,   175,    -1,   177,    -1,   179,   180,   181,    -1,
     183,    -1,   185,    -1,    -1,    -1,   189,    -1,   191,    -1,
      -1,   194,    -1,   196,   197,    -1,   199,   200,   201,    -1,
     203,   204,   205,   206,    -1,    -1,   209,    -1,   211,   212,
     213,    -1,   215,    -1,   217,    -1,    -1,    -1,    -1,   222,
      -1,   224,   225,   226,   227,    -1,    -1,   230,    -1,    -1,
     233,   234,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,    -1,   248,    -1,   250,   251,   252,
     253,   254,    -1,   256,   257,    -1,    -1,   260,   261,   262,
      -1,    -1,   265,    -1,    -1,    -1,   269,   270,    -1,    -1,
     273,    -1,    -1,    -1,   277,   278,   279,   280,   281,    -1,
     283,   284,   285,   286,    -1,   288,   289,   290,   291,   292,
     293,   294,    -1,   296,   297,   298,   299,   300,   301,   302,
     303,   304,    -1,   306,   307,   308,   309,   310,   311,   312,
      -1,    -1,   315,   316,   317,    -1,   319,   320,   321,   322,
      -1,   324,   325,    -1,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,    -1,   338,   339,   340,    -1,   342,
     343,    -1,   345,    -1,   347,   348,   349,   350,    -1,   352,
     353,   354,   355,    -1,    -1,   358,   359,   360,   361,   362,
      -1,    -1,   365,   366,   367,   368,   369,    -1,   371,   372,
      -1,    -1,    -1,   376,   377,   378,   379,   380,   381,    -1,
     383,    -1,    -1,   386,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    35,    -1,    37,    38,    39,    40,    -1,
      -1,    -1,    44,    45,    46,    -1,    48,    -1,    -1,    51,
      52,    53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,
      -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      72,    -1,    74,    -1,    76,    77,    -1,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,   101,
      -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,
      -1,    -1,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,   123,    -1,    -1,   126,   127,   128,    -1,   130,   131,
     132,   133,    -1,   135,   136,    -1,    -1,    -1,    -1,    -1,
     142,   143,   144,   145,   146,   147,   148,   149,    -1,   151,
      -1,   153,    -1,   155,   156,   157,    -1,    -1,    -1,   161,
     162,   163,   164,    -1,   166,   167,    -1,   169,    -1,   171,
     172,   173,   174,   175,    -1,   177,    -1,   179,   180,   181,
      -1,   183,    -1,   185,    -1,    -1,    -1,   189,    -1,   191,
      -1,    -1,   194,    -1,   196,   197,    -1,   199,   200,   201,
      -1,   203,   204,   205,   206,    -1,    -1,   209,    -1,   211,
     212,   213,    -1,   215,    -1,   217,    -1,    -1,    -1,    -1,
     222,    -1,   224,   225,   226,   227,    -1,    -1,   230,    -1,
      -1,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,    -1,   248,    -1,   250,   251,
     252,   253,   254,    -1,   256,   257,    -1,    -1,   260,   261,
     262,    -1,    -1,   265,    -1,    -1,    -1,   269,   270,    -1,
      -1,   273,    -1,    -1,    -1,   277,   278,   279,   280,   281,
      -1,   283,   284,   285,   286,    -1,   288,   289,   290,   291,
     292,   293,   294,    -1,   296,   297,   298,   299,   300,   301,
     302,   303,   304,    -1,   306,   307,   308,   309,   310,   311,
     312,    -1,    -1,   315,   316,   317,    -1,   319,   320,   321,
     322,    -1,   324,   325,    -1,   327,   328,   329,   330,   331,
     332,   333,   334,   335,   336,    -1,   338,   339,   340,    -1,
     342,   343,    -1,   345,    -1,   347,   348,   349,   350,    -1,
     352,   353,   354,   355,    -1,    -1,   358,   359,   360,   361,
     362,    -1,    -1,   365,   366,   367,   368,   369,    -1,   371,
     372,    -1,    -1,    -1,   376,   377,   378,   379,   380,   381,
      -1,   383,    -1,    -1,   386,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      31,    32,    33,    -1,    35,    -1,    37,    38,    39,    40,
      -1,    -1,    -1,    44,    45,    46,    -1,    48,    -1,    -1,
      51,    52,    53,    -1,    -1,    -1,    57,    58,    -1,    -1,
      -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    72,    -1,    74,    -1,    76,    77,    -1,    79,    80,
      81,    82,    83,    84,    85,    -1,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    97,    98,    99,   100,
     101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,
     111,    -1,    -1,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,   123,    -1,    -1,   126,   127,   128,    -1,   130,
     131,   132,   133,    -1,   135,   136,    -1,    -1,    -1,    -1,
      -1,   142,   143,   144,   145,   146,   147,   148,   149,    -1,
     151,    -1,   153,    -1,   155,   156,   157,    -1,    -1,    -1,
     161,   162,   163,   164,    -1,   166,   167,    -1,   169,    -1,
     171,   172,   173,   174,   175,    -1,   177,    -1,   179,   180,
     181,    -1,   183,    -1,   185,    -1,    -1,    -1,   189,    -1,
     191,    -1,    -1,   194,    -1,   196,   197,    -1,   199,   200,
     201,    -1,   203,   204,   205,   206,    -1,    -1,   209,    -1,
     211,   212,   213,    -1,   215,    -1,   217,    -1,    -1,    -1,
      -1,   222,    -1,   224,   225,   226,   227,    -1,    -1,   230,
      -1,    -1,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,    -1,   248,    -1,   250,
     251,   252,   253,   254,    -1,   256,   257,    -1,    -1,   260,
     261,   262,    -1,    -1,   265,    -1,    -1,    -1,   269,   270,
      -1,    -1,   273,    -1,    -1,    -1,   277,   278,   279,   280,
     281,    -1,   283,   284,   285,   286,    -1,   288,   289,   290,
     291,   292,   293,   294,    -1,   296,   297,   298,   299,   300,
     301,   302,   303,   304,    -1,   306,   307,   308,   309,   310,
     311,   312,    -1,    -1,   315,   316,   317,    -1,   319,   320,
     321,   322,    -1,   324,   325,    -1,   327,   328,   329,   330,
     331,   332,   333,   334,   335,   336,    -1,   338,   339,   340,
      -1,   342,   343,    -1,   345,    -1,   347,   348,   349,   350,
      -1,   352,   353,   354,   355,    -1,    -1,   358,   359,   360,
     361,   362,    -1,    -1,   365,   366,   367,   368,   369,    -1,
     371,   372,    -1,    -1,    -1,   376,   377,   378,   379,   380,
     381,    -1,   383,    -1,    -1,   386,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    35,    -1,    37,    38,    39,
      40,    -1,    -1,    -1,    44,    45,    46,    -1,    48,    -1,
      -1,    51,    52,    53,    -1,    -1,    -1,    57,    58,    -1,
      -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    72,    -1,    74,    -1,    76,    77,    -1,    79,
      80,    81,    82,    83,    84,    85,    -1,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,
     100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,
      -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,   123,    -1,    -1,   126,   127,   128,    -1,
     130,   131,   132,   133,    -1,   135,   136,    -1,    -1,    -1,
      -1,    -1,   142,   143,   144,   145,   146,   147,   148,   149,
      -1,   151,    -1,   153,    -1,   155,   156,   157,    -1,    -1,
      -1,   161,   162,   163,   164,    -1,   166,   167,    -1,   169,
      -1,   171,   172,   173,   174,   175,    -1,   177,    -1,   179,
     180,   181,    -1,   183,    -1,   185,    -1,    -1,    -1,   189,
      -1,   191,    -1,   193,   194,    -1,   196,   197,    -1,   199,
     200,   201,    -1,   203,   204,   205,   206,    -1,    -1,   209,
      -1,   211,   212,   213,    -1,   215,    -1,   217,    -1,    -1,
      -1,    -1,   222,    -1,   224,   225,   226,   227,    -1,    -1,
     230,    -1,    -1,   233,   234,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,    -1,   248,    -1,
     250,   251,   252,   253,   254,    -1,   256,   257,    -1,    -1,
     260,   261,   262,    -1,    -1,   265,    -1,    -1,    -1,   269,
     270,    -1,    -1,   273,    -1,    -1,    -1,   277,   278,   279,
     280,   281,    -1,   283,   284,   285,   286,    -1,   288,   289,
     290,   291,   292,   293,   294,    -1,   296,   297,   298,   299,
     300,   301,   302,   303,   304,    -1,   306,   307,   308,   309,
     310,   311,   312,    -1,    -1,   315,   316,   317,    -1,   319,
     320,   321,   322,    -1,   324,   325,    -1,   327,   328,   329,
     330,   331,   332,   333,   334,   335,   336,    -1,   338,   339,
     340,    -1,   342,   343,    -1,   345,    -1,   347,   348,   349,
     350,    -1,   352,   353,   354,   355,    -1,    -1,   358,   359,
     360,   361,   362,    -1,    -1,   365,   366,   367,   368,   369,
      -1,   371,   372,    -1,    -1,    -1,   376,   377,   378,   379,
     380,   381,    -1,   383,    -1,    -1,   386,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    31,    32,    33,    -1,    35,    -1,    37,    38,
      39,    40,    -1,    -1,    -1,    44,    45,    46,    -1,    48,
      -1,    -1,    51,    52,    53,    -1,    -1,    -1,    57,    58,
      -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    72,    -1,    74,    -1,    76,    77,    -1,
      79,    80,    81,    82,    83,    84,    85,    -1,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,
      99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,
     109,    -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,   123,    -1,    -1,   126,   127,   128,
      -1,   130,   131,   132,   133,    -1,   135,   136,    -1,    -1,
      -1,    -1,    -1,   142,   143,   144,   145,   146,   147,   148,
     149,   150,   151,    -1,   153,    -1,   155,   156,   157,    -1,
      -1,    -1,   161,   162,   163,   164,    -1,   166,   167,    -1,
     169,    -1,   171,   172,   173,   174,   175,    -1,   177,    -1,
     179,   180,   181,    -1,   183,    -1,   185,    -1,    -1,    -1,
     189,    -1,   191,    -1,    -1,   194,    -1,   196,   197,    -1,
     199,   200,   201,    -1,   203,   204,   205,   206,    -1,    -1,
     209,    -1,   211,   212,   213,    -1,   215,    -1,   217,    -1,
      -1,    -1,    -1,   222,    -1,   224,   225,   226,   227,    -1,
      -1,   230,    -1,    -1,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,    -1,   248,
      -1,   250,   251,   252,   253,   254,    -1,   256,   257,    -1,
      -1,   260,   261,   262,    -1,    -1,   265,    -1,    -1,    -1,
     269,   270,    -1,    -1,   273,    -1,    -1,    -1,   277,   278,
     279,   280,   281,    -1,   283,   284,   285,   286,    -1,   288,
     289,   290,   291,   292,   293,   294,    -1,   296,   297,   298,
     299,   300,   301,   302,   303,   304,    -1,   306,   307,   308,
     309,   310,   311,   312,    -1,    -1,   315,   316,   317,    -1,
     319,   320,   321,   322,    -1,   324,   325,    -1,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,    -1,   338,
     339,   340,    -1,   342,   343,    -1,   345,    -1,   347,   348,
     349,   350,    -1,   352,   353,   354,   355,    -1,    -1,   358,
     359,   360,   361,   362,    -1,    -1,   365,   366,   367,   368,
     369,    -1,   371,   372,    -1,    -1,    -1,   376,   377,   378,
     379,   380,   381,    -1,   383,    -1,    -1,   386,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    33,    -1,    35,    -1,    37,
      38,    39,    40,    -1,    -1,    -1,    44,    45,    46,    -1,
      48,    -1,    -1,    51,    52,    53,    -1,    -1,    -1,    57,
      58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,    77,
      -1,    79,    80,    81,    82,    83,    84,    85,    -1,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,
      -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,
     108,   109,    -1,   111,    -1,    -1,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,   123,    -1,    -1,   126,   127,
     128,    -1,   130,   131,   132,   133,    -1,   135,   136,    -1,
      -1,    -1,    -1,    -1,   142,   143,   144,   145,   146,   147,
     148,   149,   150,   151,    -1,   153,    -1,   155,   156,   157,
      -1,    -1,    -1,   161,   162,   163,   164,    -1,   166,   167,
      -1,   169,    -1,   171,   172,   173,   174,   175,    -1,   177,
      -1,   179,   180,   181,    -1,   183,    -1,   185,    -1,    -1,
      -1,   189,    -1,   191,    -1,    -1,   194,    -1,   196,   197,
      -1,   199,   200,   201,    -1,   203,   204,   205,   206,    -1,
      -1,   209,    -1,   211,   212,   213,    -1,   215,    -1,   217,
      -1,    -1,    -1,    -1,   222,    -1,   224,   225,   226,   227,
      -1,    -1,   230,    -1,    -1,   233,   234,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,    -1,
     248,    -1,   250,   251,   252,   253,   254,    -1,   256,   257,
      -1,    -1,   260,   261,   262,    -1,    -1,   265,    -1,    -1,
      -1,   269,   270,    -1,    -1,   273,    -1,    -1,    -1,   277,
     278,   279,   280,   281,    -1,   283,   284,   285,   286,    -1,
     288,   289,   290,   291,   292,   293,   294,    -1,   296,   297,
     298,   299,   300,   301,   302,   303,   304,    -1,   306,   307,
     308,   309,   310,   311,   312,    -1,    -1,   315,   316,   317,
      -1,   319,   320,   321,   322,    -1,   324,   325,    -1,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,    -1,
     338,   339,   340,    -1,   342,   343,    -1,   345,    -1,   347,
     348,   349,   350,    -1,   352,   353,   354,   355,    -1,    -1,
     358,   359,   360,   361,   362,    -1,    -1,   365,   366,   367,
     368,   369,    -1,   371,   372,    -1,    -1,    -1,   376,   377,
     378,   379,   380,   381,    -1,   383,    -1,    -1,   386,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    -1,    30,    31,    32,    33,    -1,    35,    -1,
      37,    38,    39,    40,    -1,    -1,    -1,    44,    45,    46,
      -1,    48,    -1,    -1,    51,    52,    53,    -1,    -1,    -1,
      57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,
      77,    -1,    79,    80,    81,    82,    83,    84,    85,    -1,
      87,    -1,    -1,    -1,    -1,    -1,    93,    -1,    95,    96,
      97,    -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,
      -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
      -1,    -1,    -1,    -1,    -1,   142,   143,   144,   145,   146,
     147,   148,   149,    -1,   151,    -1,   153,    -1,   155,   156,
     157,    -1,    -1,    -1,   161,   162,   163,   164,    -1,   166,
     167,    -1,   169,    -1,   171,   172,   173,   174,   175,    -1,
     177,    -1,   179,   180,   181,    -1,   183,    -1,   185,    -1,
      -1,    -1,   189,    -1,   191,    -1,    -1,   194,    -1,   196,
     197,    -1,   199,   200,   201,    -1,   203,   204,   205,   206,
      -1,    -1,   209,    -1,   211,   212,   213,    -1,   215,    -1,
     217,    -1,    -1,    -1,    -1,   222,    -1,   224,   225,   226,
     227,    -1,    -1,   230,    -1,    -1,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
      -1,   248,    -1,   250,   251,   252,   253,   254,    -1,   256,
     257,    -1,    -1,   260,   261,   262,    -1,    -1,   265,    -1,
      -1,    -1,   269,   270,    -1,    -1,   273,    -1,    -1,    -1,
     277,   278,   279,   280,   281,    -1,   283,   284,   285,   286,
      -1,   288,   289,   290,   291,   292,   293,   294,    -1,   296,
     297,   298,   299,   300,   301,   302,   303,   304,    -1,   306,
     307,   308,   309,   310,   311,   312,    -1,    -1,   315,   316,
     317,    -1,   319,   320,   321,   322,    -1,   324,   325,    -1,
     327,   328,   329,   330,   331,   332,   333,   334,   335,   336,
      -1,   338,   339,   340,    -1,   342,   343,    -1,   345,    -1,
     347,   348,   349,   350,    -1,   352,   353,   354,   355,    -1,
      -1,   358,   359,   360,   361,   362,    -1,    -1,   365,   366,
     367,   368,   369,    -1,   371,   372,    -1,    -1,    -1,   376,
     377,   378,   379,   380,   381,    -1,   383,    -1,    -1,   386,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    35,
      -1,    37,    38,    39,    40,    -1,    -1,    -1,    44,    45,
      46,    -1,    48,    -1,    -1,    51,    52,    53,    -1,    -1,
      -1,    57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,
      76,    77,    -1,    79,    80,    81,    82,    83,    84,    85,
      -1,    87,    -1,    -1,    -1,    -1,    -1,    93,    -1,    95,
      96,    97,    -1,    99,   100,   101,    -1,   103,    -1,   105,
      -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,
     116,   117,    -1,   119,   120,   121,   122,   123,    -1,    -1,
     126,   127,   128,    -1,   130,   131,   132,   133,    -1,   135,
     136,    -1,    -1,    -1,    -1,    -1,   142,   143,   144,   145,
     146,   147,   148,   149,    -1,   151,    -1,   153,    -1,   155,
     156,   157,    -1,    -1,    -1,   161,   162,   163,   164,    -1,
     166,   167,    -1,   169,    -1,   171,   172,   173,   174,   175,
      -1,   177,    -1,   179,   180,   181,    -1,   183,    -1,   185,
      -1,    -1,    -1,   189,    -1,   191,    -1,    -1,   194,    -1,
     196,   197,    -1,   199,   200,   201,    -1,   203,   204,   205,
     206,    -1,    -1,   209,    -1,   211,   212,   213,    -1,   215,
      -1,   217,    -1,    -1,    -1,    -1,   222,    -1,   224,   225,
     226,   227,    -1,    -1,   230,    -1,    -1,   233,   234,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,    -1,   248,    -1,   250,   251,   252,   253,   254,    -1,
     256,   257,    -1,    -1,   260,   261,   262,    -1,    -1,   265,
      -1,    -1,    -1,   269,   270,    -1,    -1,   273,    -1,    -1,
      -1,   277,   278,   279,   280,   281,    -1,   283,   284,   285,
     286,    -1,   288,   289,   290,   291,   292,   293,   294,    -1,
     296,   297,   298,   299,   300,   301,   302,   303,   304,    -1,
     306,   307,   308,   309,   310,   311,   312,    -1,    -1,   315,
     316,   317,    -1,   319,   320,   321,   322,    -1,   324,   325,
      -1,   327,   328,   329,   330,   331,   332,   333,   334,   335,
     336,    -1,   338,   339,   340,    -1,   342,   343,    -1,   345,
      -1,   347,   348,   349,   350,    -1,   352,   353,   354,   355,
      -1,    -1,   358,   359,   360,   361,   362,    -1,    -1,   365,
     366,   367,   368,   369,    -1,   371,   372,    -1,    -1,    -1,
     376,   377,   378,   379,   380,   381,    -1,   383,    -1,    -1,
     386,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    31,    32,    33,    -1,
      35,    -1,    37,    38,    39,    40,    -1,    -1,    -1,    44,
      45,    46,    -1,    48,    -1,    -1,    51,    52,    53,    -1,
      -1,    -1,    57,    58,    -1,    -1,    -1,    -1,    63,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    74,
      -1,    76,    77,    -1,    79,    80,    81,    82,    83,    84,
      85,    -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    97,    -1,    99,   100,   101,    -1,   103,    -1,
     105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,
     115,   116,   117,    -1,   119,   120,   121,   122,   123,    -1,
      -1,   126,   127,   128,    -1,   130,   131,   132,   133,    -1,
     135,   136,    -1,    -1,    -1,    -1,    -1,   142,   143,   144,
     145,   146,   147,   148,   149,    -1,   151,    -1,   153,    -1,
     155,   156,   157,    -1,    -1,    -1,   161,   162,   163,   164,
      -1,   166,   167,    -1,   169,    -1,   171,   172,   173,   174,
     175,    -1,   177,    -1,   179,   180,   181,    -1,   183,    -1,
     185,    -1,    -1,    -1,   189,    -1,   191,    -1,    -1,   194,
      -1,   196,   197,    -1,   199,   200,   201,    -1,   203,   204,
     205,   206,    -1,    -1,   209,    -1,   211,   212,   213,    -1,
     215,    -1,   217,    -1,    -1,    -1,    -1,   222,    -1,   224,
     225,   226,   227,    -1,    -1,   230,    -1,    -1,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,    -1,   248,    -1,   250,   251,   252,   253,   254,
      -1,   256,   257,    -1,    -1,   260,   261,   262,    -1,    -1,
     265,    -1,    -1,    -1,   269,   270,    -1,    -1,   273,    -1,
      -1,    -1,   277,   278,   279,   280,   281,    -1,   283,   284,
     285,   286,    -1,   288,   289,   290,   291,   292,   293,   294,
      -1,   296,   297,   298,   299,   300,   301,   302,   303,   304,
      -1,   306,   307,   308,   309,   310,   311,   312,    -1,    -1,
     315,   316,   317,    -1,   319,   320,   321,   322,    -1,   324,
     325,    -1,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,    -1,   338,   339,   340,    -1,   342,   343,    -1,
     345,    -1,   347,   348,   349,   350,    -1,   352,   353,   354,
     355,    -1,    -1,   358,   359,   360,   361,   362,    -1,    -1,
     365,   366,   367,   368,   369,    -1,   371,   372,    -1,    -1,
      -1,   376,   377,   378,   379,   380,   381,    -1,   383,    -1,
      -1,   386,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    31,    32,    33,
      -1,    35,    -1,    37,    38,    39,    40,    -1,    -1,    -1,
      44,    45,    46,    -1,    48,    -1,    -1,    51,    52,    53,
      -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,    63,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,
      74,    -1,    76,    77,    -1,    79,    80,    81,    82,    83,
      84,    85,    -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    97,    -1,    99,   100,   101,    -1,   103,
      -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,   123,
      -1,    -1,   126,   127,   128,    -1,   130,   131,   132,   133,
      -1,   135,   136,    -1,    -1,    -1,    -1,    -1,   142,   143,
     144,   145,   146,   147,   148,   149,    -1,   151,    -1,   153,
      -1,   155,   156,   157,    -1,    -1,    -1,   161,   162,   163,
     164,    -1,   166,   167,    -1,   169,    -1,   171,   172,   173,
     174,   175,    -1,   177,    -1,   179,   180,   181,    -1,   183,
      -1,   185,    -1,    -1,    -1,   189,    -1,   191,    -1,    -1,
     194,    -1,   196,   197,    -1,   199,   200,   201,    -1,   203,
     204,   205,   206,    -1,    -1,   209,    -1,   211,   212,   213,
      -1,   215,    -1,   217,    -1,    -1,    -1,    -1,   222,    -1,
     224,   225,   226,   227,    -1,    -1,   230,    -1,    -1,   233,
     234,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,    -1,   248,    -1,   250,   251,   252,   253,
     254,    -1,   256,   257,    -1,    -1,   260,   261,   262,    -1,
      -1,   265,    -1,    -1,    -1,   269,   270,    -1,    -1,   273,
      -1,    -1,    -1,   277,   278,   279,   280,   281,    -1,   283,
     284,   285,   286,    -1,   288,   289,   290,   291,   292,   293,
     294,    -1,   296,   297,   298,   299,   300,   301,   302,   303,
     304,    -1,   306,   307,   308,   309,   310,   311,   312,    -1,
      -1,   315,   316,   317,    -1,   319,   320,   321,   322,    -1,
     324,   325,    -1,   327,   328,   329,   330,   331,   332,   333,
     334,   335,   336,    -1,   338,   339,   340,    -1,   342,   343,
      -1,   345,    -1,   347,   348,   349,   350,    -1,   352,   353,
     354,   355,    -1,    -1,   358,   359,   360,   361,   362,    -1,
      -1,   365,   366,   367,   368,   369,    -1,   371,   372,    -1,
      -1,    -1,   376,   377,   378,   379,   380,   381,    -1,   383,
      -1,    -1,   386,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    31,    32,
      33,    -1,    35,    -1,    37,    38,    39,    40,    -1,    -1,
      -1,    44,    45,    46,    -1,    48,    -1,    -1,    51,    52,
      53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,
      -1,    74,    -1,    76,    77,    -1,    79,    80,    81,    82,
      83,    84,    85,    -1,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    97,    -1,    99,   100,   101,    -1,
     103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,
      -1,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
     123,    -1,    -1,   126,   127,   128,    -1,   130,   131,   132,
     133,    -1,   135,   136,    -1,    -1,    -1,    -1,    -1,   142,
     143,   144,   145,   146,   147,   148,   149,    -1,   151,    -1,
     153,    -1,   155,   156,   157,    -1,    -1,    -1,   161,   162,
     163,   164,    -1,   166,   167,    -1,   169,    -1,   171,   172,
     173,   174,   175,    -1,   177,    -1,   179,   180,   181,    -1,
     183,    -1,   185,    -1,    -1,    -1,   189,    -1,   191,    -1,
      -1,   194,    -1,   196,   197,    -1,   199,   200,   201,    -1,
     203,   204,   205,   206,    -1,    -1,   209,    -1,   211,   212,
     213,    -1,   215,    -1,   217,    -1,    -1,    -1,    -1,   222,
      -1,   224,   225,   226,   227,    -1,    -1,   230,    -1,    -1,
     233,   234,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,    -1,   248,    -1,   250,   251,   252,
     253,   254,    -1,   256,   257,    -1,    -1,   260,   261,   262,
      -1,    -1,   265,    -1,    -1,    -1,   269,   270,    -1,    -1,
     273,    -1,    -1,    -1,   277,   278,   279,   280,   281,    -1,
     283,   284,   285,   286,    -1,   288,   289,   290,   291,   292,
     293,   294,    -1,   296,   297,   298,   299,   300,   301,   302,
     303,   304,    -1,   306,   307,   308,   309,   310,   311,   312,
      -1,    -1,   315,   316,   317,    -1,   319,   320,   321,   322,
      -1,   324,   325,    -1,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,    -1,   338,   339,   340,    -1,   342,
     343,    -1,   345,    -1,   347,   348,   349,   350,    -1,   352,
     353,   354,   355,    -1,    -1,   358,   359,   360,   361,   362,
      -1,    -1,   365,   366,   367,   368,   369,    -1,   371,   372,
      -1,    -1,    -1,   376,   377,   378,   379,   380,   381,    -1,
     383,    -1,    -1,   386,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    35,    -1,    37,    38,    39,    40,    -1,
      -1,    -1,    44,    45,    46,    -1,    48,    -1,    -1,    51,
      52,    53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,
      -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      72,    -1,    74,    -1,    76,    77,    -1,    79,    80,    81,
      82,    83,    84,    85,    -1,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,   101,
      -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,
      -1,    -1,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,   123,    -1,    -1,   126,   127,   128,    -1,   130,   131,
     132,   133,    -1,   135,   136,    -1,    -1,    -1,    -1,    -1,
     142,   143,   144,   145,   146,   147,   148,   149,    -1,   151,
      -1,   153,    -1,   155,   156,   157,    -1,    -1,    -1,   161,
     162,   163,   164,    -1,   166,   167,    -1,   169,    -1,   171,
     172,   173,   174,   175,    -1,   177,    -1,   179,   180,   181,
      -1,   183,    -1,   185,    -1,    -1,    -1,   189,    -1,   191,
      -1,    -1,   194,    -1,   196,   197,    -1,   199,   200,   201,
      -1,   203,   204,   205,   206,    -1,    -1,   209,    -1,   211,
     212,   213,    -1,   215,    -1,   217,    -1,    -1,    -1,    -1,
     222,    -1,   224,   225,   226,   227,    -1,    -1,   230,    -1,
      -1,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,    -1,   248,    -1,   250,   251,
     252,   253,   254,    -1,   256,   257,    -1,    -1,   260,   261,
     262,    -1,    -1,   265,    -1,    -1,    -1,   269,   270,    -1,
      -1,   273,    -1,    -1,    -1,   277,   278,   279,   280,   281,
      -1,   283,   284,   285,   286,    -1,   288,   289,   290,   291,
     292,   293,   294,    -1,   296,   297,   298,   299,   300,   301,
     302,   303,   304,    -1,   306,   307,   308,   309,   310,   311,
     312,    -1,    -1,   315,   316,   317,    -1,   319,   320,   321,
     322,    -1,   324,   325,    -1,   327,   328,   329,   330,   331,
     332,   333,   334,   335,   336,    -1,   338,   339,   340,    -1,
     342,   343,    -1,   345,    -1,   347,   348,   349,   350,    -1,
     352,   353,   354,   355,    -1,    -1,   358,   359,   360,   361,
     362,    -1,    -1,   365,   366,   367,   368,   369,    -1,   371,
     372,    -1,    -1,    -1,   376,   377,   378,   379,   380,   381,
      -1,   383,    -1,    -1,   386,     6,     7,     8,    -1,    -1,
      11,    12,    -1,    14,    15,    16,    -1,    -1,    -1,    20,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      31,    32,    -1,    -1,    35,    -1,    37,    38,    39,    40,
      -1,    42,    -1,    44,    45,    46,    -1,    48,    49,    50,
      51,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,
      -1,   102,   103,   104,   105,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   116,    -1,    -1,    -1,    -1,
      -1,    -1,   123,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   132,    -1,    -1,    -1,    -1,   137,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   147,   148,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   162,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   174,    -1,    -1,   177,    -1,    -1,    -1,
     181,    -1,    -1,    -1,    -1,   186,    -1,   188,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   198,    -1,    -1,
      -1,   202,    -1,    -1,    -1,    -1,    -1,   208,    -1,    -1,
      -1,    -1,    -1,    -1,   215,    -1,   217,    -1,    -1,   220,
     221,    -1,   223,    -1,    -1,    -1,    -1,    -1,   229,    -1,
     231,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   247,   248,    -1,    -1,
      -1,    -1,    -1,   254,    -1,    -1,    -1,   258,    -1,   260,
     261,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   274,   275,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   283,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   293,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   305,    -1,   307,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   320,
      -1,    -1,   323,    -1,   325,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,    -1,
      -1,   342,   343,    -1,    -1,    -1,    -1,   348,    -1,   350,
      -1,    -1,    -1,    -1,    -1,   356,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   368,    -1,   370,
      -1,     6,     7,     8,    -1,    -1,    11,    12,    -1,    14,
      15,    16,   383,    -1,    -1,   386,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    31,    32,    -1,    -1,
      35,    -1,    37,    38,    39,    40,    -1,    -1,    -1,    44,
      45,    46,    -1,    48,    -1,    -1,    51,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    98,    -1,    -1,    -1,   102,   103,   104,
     105,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   116,    -1,    -1,    -1,    -1,    -1,    -1,   123,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,    -1,    -1,
      -1,    -1,   137,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   147,   148,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   174,
      -1,    -1,   177,    -1,    -1,    -1,   181,    -1,    -1,    -1,
      -1,   186,    -1,   188,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   198,    -1,    -1,    -1,   202,    -1,    -1,
      -1,    -1,    -1,   208,    -1,    -1,    -1,    -1,    -1,    -1,
     215,    -1,   217,    -1,    -1,   220,   221,    -1,   223,    -1,
      -1,    -1,    -1,    -1,   229,    -1,   231,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   247,   248,    -1,    -1,    -1,    -1,    -1,   254,
      -1,    -1,    -1,   258,    -1,   260,   261,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   274,
     275,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   283,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   293,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     305,    -1,   307,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   320,    -1,    -1,   323,    -1,
     325,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     335,    -1,    -1,    -1,    -1,    -1,    -1,   342,   343,    -1,
      -1,    -1,    -1,   348,    -1,   350,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   368,    -1,   370,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   383,    -1,
      -1,   386
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned short yystos[] =
{
       0,   418,   419,     0,     5,    20,    29,    41,    42,    47,
      49,    50,    54,    55,    56,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    77,   115,   181,   197,   214,
     240,   243,   259,   312,   344,   356,   368,   380,   383,   384,
     386,   388,   392,   394,   395,   399,   400,   401,   402,   403,
     406,   407,   408,   409,   411,   412,   413,   414,   420,   763,
     764,   767,   801,   803,   895,   908,   909,   802,     3,     6,
       7,     8,     9,    11,    12,    14,    15,    16,    17,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    30,
      31,    32,    33,    35,    37,    38,    39,    40,    42,    44,
      45,    46,    48,    49,    50,    51,    52,    53,    57,    58,
      63,    72,    74,    76,    77,    79,    87,    88,    89,    97,
      98,   101,   102,   103,   104,   105,   116,   119,   121,   122,
     123,   126,   127,   132,   133,   134,   137,   144,   146,   147,
     148,   149,   155,   162,   163,   168,   173,   174,   175,   177,
     179,   181,   186,   188,   190,   192,   198,   202,   208,   212,
     215,   217,   220,   221,   223,   229,   231,   233,   234,   237,
     244,   247,   248,   254,   257,   258,   260,   261,   274,   275,
     283,   286,   293,   296,   300,   304,   305,   306,   307,   314,
     319,   320,   322,   323,   325,   328,   335,   342,   343,   348,
     350,   352,   354,   356,   359,   361,   365,   368,   370,   383,
     386,   408,   421,   422,   423,   425,   426,   427,   431,   434,
     435,   436,   440,   450,   451,   452,   455,   456,   459,   460,
     469,   494,   499,   500,   504,   508,   510,   523,   524,   525,
     526,   532,   537,   538,   542,   543,   547,   550,   551,   562,
     568,   580,   581,   583,   586,   588,   589,   592,   595,   603,
     604,   605,   606,   607,   612,   613,   614,   618,   619,   620,
     621,   623,   624,   625,   626,   627,   632,   635,   639,   640,
     643,   644,   647,   648,   649,   650,   651,   777,   790,   791,
     792,   793,   794,   800,   808,   813,   814,   815,   816,   818,
     820,   822,   824,   825,   826,   827,   829,   834,   835,   838,
     843,   844,   854,   855,   857,   858,   865,   866,   867,   868,
     870,   871,   874,   876,   879,   887,   891,   892,   902,     9,
      17,    19,    33,    52,    53,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    89,    90,    91,    92,    93,
      94,    95,    96,    97,    99,   100,   101,   107,   108,   109,
     111,   112,   113,   114,   117,   118,   119,   120,   121,   122,
     124,   125,   126,   127,   128,   129,   130,   131,   133,   134,
     135,   136,   138,   139,   140,   141,   142,   143,   144,   145,
     146,   149,   150,   151,   152,   153,   155,   156,   157,   158,
     159,   160,   161,   162,   163,   164,   165,   166,   167,   168,
     169,   170,   171,   172,   173,   175,   178,   179,   180,   182,
     183,   184,   185,   187,   189,   191,   192,   193,   194,   195,
     196,   197,   199,   200,   201,   203,   204,   205,   206,   207,
     209,   211,   212,   213,   216,   218,   222,   224,   225,   226,
     227,   228,   230,   232,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   249,   250,
     251,   252,   253,   255,   256,   257,   259,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   277,
     278,   279,   280,   281,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   294,   295,   296,   297,   298,   299,   300,
     301,   302,   303,   304,   306,   308,   309,   310,   311,   312,
     314,   315,   316,   317,   318,   319,   321,   322,   324,   326,
     327,   328,   329,   330,   331,   332,   333,   334,   336,   337,
     338,   339,   340,   341,   344,   345,   346,   347,   349,   351,
     352,   353,   354,   355,   357,   358,   359,   360,   361,   362,
     363,   364,   365,   366,   367,   369,   371,   372,   374,   375,
     376,   377,   378,   379,   380,   381,   805,   806,   808,   810,
     813,   816,   817,   820,   824,   880,   887,   888,   890,   893,
      18,    57,    58,    63,    72,    74,    76,    77,   115,   344,
     387,   767,   770,   775,   786,   787,   878,   879,   880,   883,
     889,   890,   891,   899,   901,   902,    34,   210,   856,    13,
      86,   150,   756,   770,   778,   779,   836,   837,   883,   902,
       5,    29,    34,    41,    42,    49,    50,   115,   210,   214,
     356,   412,   819,   881,   882,   886,   887,   888,   889,   755,
     883,   755,   882,    29,    41,   115,   214,   875,    44,    46,
     255,   809,   347,   378,   608,    85,   131,   144,   161,   189,
     193,   226,   269,   310,   315,   337,   349,   363,   778,   149,
     608,   755,   249,   266,   740,   751,   753,   759,   776,   883,
     267,   608,   104,   465,    85,    95,   113,   129,   144,   150,
     161,   191,   193,   235,   269,   271,   310,   338,   340,   349,
     353,   354,   357,   363,   470,   505,   535,   563,   569,   778,
      18,   286,   755,   788,   842,   901,   329,   755,   187,    85,
      95,   113,   131,   144,   161,   189,   193,   205,   269,   290,
     309,   310,   315,   337,   349,   354,   363,   372,   509,   539,
     608,   199,   842,   627,   634,    80,    86,    99,   180,   185,
     187,   202,   227,   250,   288,   297,   400,   544,   545,   546,
     755,   763,   768,   769,   899,    18,    86,   134,   155,   173,
     212,   295,   309,   314,   338,   340,   349,   361,   362,   552,
     553,   554,   218,   753,   883,   760,   770,   337,   654,   544,
     755,   753,   842,   144,   205,   337,   590,    86,   317,   342,
     347,   883,   192,   559,   608,    86,   159,   656,     4,    10,
     130,   235,   245,   317,   342,   347,   441,   883,    86,   317,
     342,   347,   883,   347,   654,   872,   882,   401,   753,   268,
     678,   753,   188,   629,   648,   649,   101,   422,   411,    35,
     370,   628,   170,   216,   272,   356,   657,   658,   796,   800,
     820,   815,   411,   821,   823,     5,    29,    41,   115,   214,
     828,   145,   197,   240,   243,   312,   380,   408,   707,   799,
     804,   895,   808,   810,   817,   812,   411,   799,   755,   788,
     903,   150,   778,    25,   364,   402,   755,   755,   385,   780,
     781,   416,   901,   408,   412,   904,   905,   906,   907,   909,
     819,   364,   845,   846,    29,   214,   214,   886,     7,    11,
      23,    24,    45,    48,   160,   877,   877,    21,   817,   740,
     751,   761,   878,   885,   889,   890,   892,   902,   541,   740,
     883,   756,   541,   761,   775,   755,   120,   755,   753,   678,
     753,   755,   775,    40,   410,   741,   267,    85,   125,   144,
     161,   189,   205,   269,   309,   310,   315,   337,   349,   354,
     372,   548,   753,   761,   755,   408,   349,   756,   541,   338,
     340,   775,   338,   340,   120,   385,   395,   396,   397,   399,
     400,   401,   402,   403,   404,   712,   713,   299,   775,   883,
     755,   541,   775,   315,   337,   509,   131,   205,   189,   309,
     372,   903,   842,   902,   645,   678,   761,   755,   408,   756,
     761,   775,   120,   712,   755,   755,   430,   775,   226,   540,
     541,   386,   788,   841,   839,   628,   545,    86,   545,    86,
     545,   545,   768,   546,   755,   755,   218,   364,   847,   848,
     850,   851,   903,   289,   267,   414,   753,   752,   753,   546,
     187,   755,   753,    98,   381,   222,   270,   552,   267,    92,
     103,   105,   106,   112,   113,   115,   116,   123,   132,   138,
     139,   140,   141,   147,   148,   162,   174,   177,   178,   181,
     214,   215,   217,   246,   248,   255,   259,   260,   261,   269,
     276,   283,   293,   307,   318,   325,   335,   342,   343,   348,
     350,   351,   357,   363,   368,   385,   390,   391,   393,   399,
     400,   401,   403,   404,   408,   648,   687,   688,   689,   694,
     695,   696,   698,   699,   700,   701,   704,   705,   708,   709,
     714,   716,   718,   734,   739,   740,   743,   744,   751,   761,
     762,   763,   764,   765,   766,   767,   774,   878,   881,   884,
     889,   890,   898,   899,   901,   902,   344,   395,   344,   395,
     837,    86,   453,   754,   755,   317,   441,   150,   448,   770,
      98,   117,   441,   381,   222,   292,   609,   611,   344,   415,
      98,   381,   222,   609,   610,   753,   886,   408,   753,   319,
     401,   186,   630,   409,   409,   411,   753,    86,   655,   655,
     108,   655,   182,   232,   264,   661,   667,   401,   830,   831,
     833,   795,   412,   412,    29,   214,   214,   344,   344,   344,
     344,   344,   400,   763,   764,   772,   797,   899,   168,   811,
     830,    93,   784,   108,   787,   787,   847,   218,   847,   848,
     389,   782,   883,   416,   783,   780,   409,   905,   906,   904,
     413,   414,   767,   772,   773,   852,   853,   898,   214,   220,
     755,   344,   755,     6,   755,   877,   833,   408,   298,   298,
     319,   451,    83,   163,   277,   319,   457,   408,   570,    83,
     163,   298,   298,   541,   298,   501,    83,    87,   163,   298,
     319,   122,   134,   277,   267,   298,   319,   376,   428,   451,
     411,   401,   758,   883,   753,   761,   761,   712,   755,   755,
     755,   376,   466,   408,   528,   118,   103,   105,   115,   116,
     147,   148,   181,   215,   217,   248,   261,   293,   320,   325,
     342,   343,   368,   683,   686,   688,   689,   693,   695,   696,
     697,   699,   700,   704,   705,   878,   884,   889,   890,   902,
     755,   376,    93,   622,   376,   432,   541,   528,   437,   883,
     438,    84,   100,   511,    93,   528,   376,   424,   753,   753,
     226,   541,   759,   883,   761,   755,   753,   104,   142,   211,
     251,   311,   375,   680,   408,   683,   570,   541,   408,   267,
     267,   414,   770,   111,   302,   414,   458,   840,   846,   851,
     149,   633,   635,   639,   643,   644,   647,   755,   850,   850,
      43,   849,   894,   897,   901,   849,    51,   859,   863,   901,
     144,   189,   226,   310,   337,   555,   752,   554,   150,   367,
     408,   636,   647,   202,   414,   641,   755,   841,   183,   591,
     591,   230,   182,   267,   408,   406,   648,   724,   369,   702,
     716,   738,   408,   702,   702,   408,   408,   408,   742,   408,
     742,   408,   742,   408,   692,   692,   284,   648,   408,   408,
     690,   115,   116,   702,   716,   408,   408,   691,   408,   408,
     408,   408,   742,   408,   376,   377,   408,   706,   408,   706,
     408,   408,   648,   742,   406,   719,   741,   716,   716,   716,
     716,   648,   710,   716,   720,   770,   116,   408,   703,   408,
     770,   202,   220,   255,   269,   275,   712,   715,   716,    78,
      90,    93,    97,   102,   198,   202,   220,   221,   231,   255,
     258,   269,   271,   323,   385,   395,   396,   397,   399,   400,
     401,   402,   403,   404,   714,   715,   719,   218,   414,   652,
     850,   719,   408,    26,   900,   901,   263,   267,   869,   869,
     837,   837,   153,   199,   454,   414,   117,   150,   449,   770,
     883,    93,   150,   235,   447,   705,   773,   902,   230,   268,
     379,   222,   150,   178,   263,   267,   351,   442,   443,   445,
     446,   773,   883,   442,   230,   220,   753,   408,   745,   748,
     883,   628,   408,   631,   648,   650,   651,   650,   659,   660,
     716,   650,   292,   361,    86,   663,   716,   664,   716,   667,
     668,   661,   662,   401,   411,   414,   887,   830,   807,   810,
     807,   214,   145,   197,   240,   312,   240,   312,   312,   243,
     240,   243,   312,   763,   764,   414,   798,   149,   830,   411,
     778,   363,   785,   787,   410,   768,   783,   409,   413,   907,
     414,   817,   408,   755,   408,   887,   401,   582,   683,   344,
     344,   441,   118,   129,   184,   287,   357,   481,   482,   129,
     150,   255,   344,   150,   255,   202,   209,   273,   409,   571,
     572,   573,   576,   683,   884,   298,   363,   363,   344,   344,
     364,   344,   109,   143,   204,   239,   241,   251,   301,   328,
     502,   125,   481,   594,   594,   129,   594,   594,   377,   267,
     345,   344,   678,   344,   441,   428,   135,   136,   202,   252,
     253,   279,   336,   366,   429,   741,   408,   570,   408,   220,
     267,   267,   220,   265,   187,   344,   461,   529,   530,   886,
     408,   686,    93,    92,   406,   684,   145,   243,   380,   408,
     707,   741,    84,   166,   236,   277,   339,   615,   616,   683,
     432,   336,   363,   433,   535,    98,   134,   439,   469,   550,
     612,   155,   212,   361,   512,   513,   408,   527,   428,   501,
     262,   408,   496,   449,   182,   267,   570,    93,   408,   483,
     376,   377,   646,   311,   716,   582,    93,   458,   364,   254,
     584,   683,   753,   753,   775,   458,   541,   851,   846,   755,
     850,    18,   414,   900,    18,   763,   901,   414,   395,   754,
     560,   561,   761,   754,   754,   752,   344,   367,   408,   637,
     638,   883,    81,   171,   307,   321,   642,   753,   555,   716,
     720,   720,   723,   724,   408,   374,   735,   736,   716,   720,
     716,   720,   409,   768,   768,   768,   145,   197,   240,   243,
     312,   380,   721,   725,   770,   902,   768,   702,   702,   716,
     768,   585,   712,   883,   716,   726,   400,   403,   404,   408,
     714,   717,   718,   728,   409,   710,   716,   716,   720,   729,
     342,   342,   768,   768,   716,   107,   187,   228,   346,   716,
     720,   732,   716,   719,   409,   409,   414,   319,   768,   768,
     707,   648,   159,   255,   259,   202,   408,   307,   408,   709,
      86,    91,   326,   408,   648,   709,   711,   683,   716,   886,
     342,   717,   716,   408,   648,   733,   159,   178,   255,   259,
     262,   351,   358,   716,   102,   198,   202,   231,   323,   408,
     716,   344,   716,   716,   716,   716,   716,   716,   716,   716,
     716,   716,   711,   191,   235,   337,   338,   340,   653,   753,
     744,   187,   670,    86,   159,   401,   409,   720,   755,   901,
     755,   347,   408,   770,   292,   316,   444,   230,   414,   817,
     409,   746,   883,   414,   670,   719,   626,   753,   754,   414,
      94,   158,   364,   268,   262,   669,   264,   414,   232,   831,
     684,   411,   413,   810,   413,   772,   409,    40,   411,   786,
     782,   402,   852,   684,   896,   906,   896,   684,   409,   755,
     756,   408,   755,   224,   224,   408,   755,   259,   775,   716,
     259,   409,   414,   576,   741,   344,   430,   430,   775,   755,
     757,   883,   755,   772,   108,   503,   772,   772,   143,   239,
     241,   424,   424,   474,   883,   883,   755,   883,   593,   755,
     265,   755,   337,   775,   298,   775,   193,   767,   768,   360,
     582,   220,   584,   259,   549,   770,   541,   541,   549,   331,
     332,   462,   770,   409,   414,   395,   716,    92,   684,   683,
     406,   407,   408,   685,   767,   768,   883,   344,   344,   768,
     512,   395,   617,   617,   617,   617,   616,   475,   768,   430,
     182,   775,   470,   569,   267,   271,   681,   682,   883,   753,
     231,   471,   472,   473,   474,   479,   481,   497,   498,   883,
      93,   194,   770,   753,   303,   596,   484,   485,   883,    93,
     196,   196,   182,   409,   683,   757,   414,   409,   414,   458,
     458,   645,   903,   897,   903,   861,   864,   901,   864,   859,
      12,   860,   414,   570,   193,   556,   557,   883,   150,   744,
     749,   750,   409,   414,   719,   171,   321,   171,   321,   307,
     361,   242,   187,   409,   414,   407,   407,   414,   768,   716,
     165,   736,   737,    93,   409,   364,   409,   409,   409,   409,
     414,   409,   187,   409,   414,   409,   414,   409,   410,   282,
     727,   409,   717,   717,   717,   716,   717,    78,   202,   220,
     269,   385,   395,   396,   397,   399,   400,   401,   402,   403,
     404,   714,   409,   409,   409,   182,   187,   730,   731,   409,
     381,   381,   409,   409,    93,   732,   720,   732,   732,   187,
     409,   407,   416,   719,   741,   716,   883,   409,   409,   187,
     259,   648,   585,   648,   381,    90,   169,   720,   187,   178,
     259,   262,   351,   358,   408,   169,   717,   716,   733,   716,
     344,   585,   716,   408,   648,   338,   340,   338,   340,   753,
     654,   654,   408,   648,   671,   672,   673,   678,   679,   740,
     761,   680,   720,   720,   409,   409,   609,   768,   707,   128,
     611,   444,   445,   684,   409,   719,   748,   680,   395,   409,
     660,   715,   754,   664,   664,   663,   395,   832,   411,   756,
      36,   873,   409,   409,   411,   298,   716,   482,   408,   408,
     484,   458,   572,   403,   755,   298,   772,   772,   772,   683,
     163,   319,   457,   458,   458,   344,   344,   430,   767,   409,
     549,   409,   220,   220,   364,   467,   468,   530,   269,   400,
     531,   575,   576,   715,   773,   409,   406,   409,   768,   684,
     685,   399,   400,   401,   402,   403,   407,   409,   267,   150,
     763,   767,   771,   899,   150,   770,   150,   755,   150,   755,
     118,   129,   150,   152,   207,   255,   259,   287,   295,   357,
     476,   477,   478,   354,   438,   337,   753,   513,   409,   414,
     683,   408,   753,   409,   414,   409,   414,   495,   506,   740,
     755,   883,   344,   364,   564,   575,   267,   409,   414,   647,
     647,   842,   458,   409,   458,   683,   458,   254,   683,   142,
     414,   395,   561,   883,   376,   414,   558,   409,   414,   367,
     647,   638,   171,   171,   556,   716,   724,   409,   341,   716,
     168,   683,   541,   768,   716,   716,   768,   585,   716,   730,
     683,   717,   159,   255,   262,   717,   717,   717,   717,   717,
     717,   717,   717,   717,   717,   716,   716,   731,   730,   706,
     706,   683,   409,   409,   409,   720,   719,   716,   719,   703,
     770,   709,   409,   718,   717,   716,   409,   716,   408,   683,
     722,   716,    90,   169,   169,   716,   409,   169,   716,   654,
     654,   654,   654,   753,   753,   648,   672,   673,    93,   674,
     883,   414,   137,   188,   208,   223,   229,   247,   305,   382,
     675,   674,    93,   674,   883,   408,   193,   665,   409,   409,
     409,   873,   395,   414,   150,   716,   907,   385,   789,   344,
     409,   484,   484,   409,   354,   344,   475,   255,   255,   330,
     333,   755,   755,   220,   220,   549,   549,   424,   157,   152,
     207,   255,   520,   521,   522,   768,   376,   377,   407,   409,
     685,   685,   685,   685,   685,   684,   707,   753,   408,   755,
     717,   153,   199,   152,   259,   224,   753,   683,   753,   182,
     514,   271,   682,   471,   172,   203,   480,   206,   491,   473,
     498,   883,   647,   225,   507,   770,   757,   408,    93,   110,
     176,   200,   226,   303,   313,   327,   334,   373,   577,   578,
     155,   212,   314,   361,   601,   485,   458,   646,   861,     8,
      14,    15,    16,    26,    27,    28,    30,    31,    32,    37,
      38,    39,   284,   354,   862,   192,   557,   750,   408,   458,
     716,   409,   409,   409,   409,   409,   731,   187,   262,   408,
     409,   407,   707,   722,   409,   414,   717,   716,   716,   169,
     716,   409,   753,   753,   753,   753,   409,   883,   408,   672,
     223,   274,   676,   672,   676,   223,   675,   676,   672,   223,
     408,   883,   408,   409,   720,   108,   195,   666,   770,   408,
     746,   883,   755,   409,   409,   755,   259,   259,   768,   883,
     549,   549,   463,   770,   153,   199,   152,   522,   521,   407,
     189,   189,   187,   519,   716,   255,   477,   483,   364,   408,
     164,   515,   173,   513,   409,   151,   151,   408,   376,   377,
     492,   770,   187,   408,   565,   566,   758,   761,   883,   574,
     770,   267,   313,   449,   259,   154,   219,   376,   578,   579,
     344,   182,   270,   749,   717,   408,   717,   719,   409,   683,
     716,   674,   408,   754,   672,   267,   364,   677,   672,   223,
     672,   681,   408,   681,   883,   409,   720,   716,   707,   716,
     747,   295,   104,   156,   259,   265,   464,   561,    93,   587,
     753,   520,   409,   238,   486,   757,   307,   329,   516,   291,
     492,   752,   265,   265,   267,   493,   541,   716,   409,   414,
     364,   541,   567,   408,   414,   259,   154,   219,   267,   528,
     753,   409,   717,   409,   754,   409,   716,   408,   672,   677,
     409,   681,   409,   414,   409,   753,   622,   622,   587,    96,
     182,   188,   278,   267,   487,   488,   489,    93,   755,   493,
     409,   127,   409,   680,   566,   541,   720,   770,   210,   259,
     680,   409,   409,   754,   409,   747,   483,   770,   770,   164,
     155,   361,   267,   489,   267,   488,   189,   269,   333,   533,
     534,   408,   155,   163,   285,   567,   409,   210,   160,   409,
     486,   307,   111,   251,   302,   319,   490,   490,   768,   768,
     683,   414,   517,   518,   774,   883,   308,   308,   567,   213,
     602,   487,   173,    82,   150,   259,   761,   585,   534,   409,
     414,   256,   408,   597,   599,   604,   635,   639,   643,   647,
     520,   291,   570,   294,   408,   536,   518,   598,   599,   600,
     648,   649,   761,   584,   409,   411,   408,   409,   600,   517,
     536,   409
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrlab1

/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)         \
  Current.first_line   = Rhs[1].first_line;      \
  Current.first_column = Rhs[1].first_column;    \
  Current.last_line    = Rhs[N].last_line;       \
  Current.last_column  = Rhs[N].last_column;
#endif

/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YYDSYMPRINT(Args)			\
do {						\
  if (yydebug)					\
    yysymprint Args;				\
} while (0)

# define YYDSYMPRINTF(Title, Token, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Token, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (cinluded).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short *bottom, short *top)
#else
static void
yy_stack_print (bottom, top)
    short *bottom;
    short *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylineno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylineno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YYDSYMPRINT(Args)
# define YYDSYMPRINTF(Title, Token, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    {
      YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
# ifdef YYPRINT
      YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
    }
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yytype, yyvaluep)
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  
  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short	yyssa[YYINITDEPTH];
  short *yyss = yyssa;
  register short *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YYDSYMPRINTF ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %s, ", yytname[yytoken]));

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 5:
#line 566 "preproc.y"
    { connection = NULL; }
    break;

  case 7:
#line 569 "preproc.y"
    {
			fprintf(yyout, "%s", yyvsp[0].str);
                        free(yyvsp[0].str);
			output_line_number();
		}
    break;

  case 9:
#line 575 "preproc.y"
    { fprintf(yyout, "%s", yyvsp[0].str); free(yyvsp[0].str); }
    break;

  case 10:
#line 576 "preproc.y"
    { fprintf(yyout, "%s", yyvsp[0].str); free(yyvsp[0].str); }
    break;

  case 11:
#line 577 "preproc.y"
    { braces_open++; fputs("{", yyout); }
    break;

  case 12:
#line 578 "preproc.y"
    { remove_typedefs(braces_open); remove_variables(braces_open--); fputs("}", yyout); }
    break;

  case 13:
#line 582 "preproc.y"
    {
			connection = yyvsp[0].str;
			/*
			 *	Do we have a variable as connection target?
			 *	Remove the variable from the variable
			 *	list or else it will be used twice
			 */
			if (argsinsert != NULL)
				argsinsert = NULL;
		}
    break;

  case 14:
#line 593 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 15:
#line 594 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 16:
#line 595 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 17:
#line 596 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 18:
#line 597 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 19:
#line 598 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 20:
#line 599 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 21:
#line 600 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 22:
#line 601 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 23:
#line 603 "preproc.y"
    {
			if (INFORMIX_MODE)
			{
				/* Informix also has a CLOSE DATABASE command that
				   essantially works like a DISCONNECT CURRENT 
				   as far as I know. */
				if (strcasecmp(yyvsp[0].str+strlen("close "), "database") == 0)
				{
					if (connection)
		                                mmerror(PARSE_ERROR, ET_ERROR, "no at option for close database statement.\n");
								
					fprintf(yyout, "{ ECPGdisconnect(__LINE__, \"CURRENT\");");
		                        whenever_action(2);
		                        free(yyvsp[0].str);
				}
				else
					output_statement(yyvsp[0].str, 0, connection);
			}
			else
				output_statement(yyvsp[0].str, 0, connection);
		}
    break;

  case 24:
#line 624 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 25:
#line 625 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 26:
#line 626 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 27:
#line 627 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 28:
#line 628 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 29:
#line 629 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 30:
#line 630 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 31:
#line 631 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 32:
#line 632 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 33:
#line 633 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 34:
#line 634 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 35:
#line 635 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 36:
#line 636 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 37:
#line 637 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 38:
#line 638 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 39:
#line 639 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 40:
#line 640 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 41:
#line 641 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 42:
#line 642 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 43:
#line 644 "preproc.y"
    { output_simple_statement(yyvsp[0].str); }
    break;

  case 44:
#line 645 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 45:
#line 646 "preproc.y"
    { output_statement(yyvsp[0].str, 1, connection); }
    break;

  case 46:
#line 647 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 47:
#line 648 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 48:
#line 649 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 49:
#line 650 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 50:
#line 651 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 51:
#line 652 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 52:
#line 653 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 53:
#line 654 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 54:
#line 655 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 55:
#line 656 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 56:
#line 657 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 57:
#line 659 "preproc.y"
    { output_statement(yyvsp[0].str, 1, connection); }
    break;

  case 58:
#line 660 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 59:
#line 661 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 60:
#line 662 "preproc.y"
    { output_statement(yyvsp[0].str, 1, connection); }
    break;

  case 61:
#line 663 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 62:
#line 664 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 63:
#line 665 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 64:
#line 666 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 65:
#line 668 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 66:
#line 669 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 67:
#line 670 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 68:
#line 671 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 69:
#line 672 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 70:
#line 673 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 71:
#line 674 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 72:
#line 675 "preproc.y"
    { output_statement(yyvsp[0].str, 1, connection); }
    break;

  case 73:
#line 677 "preproc.y"
    {
			fprintf(yyout, "{ ECPGtrans(__LINE__, %s, \"%s\");", connection ? connection : "NULL", yyvsp[0].str);
			whenever_action(2);
			free(yyvsp[0].str);
		}
    break;

  case 74:
#line 682 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 75:
#line 683 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 76:
#line 684 "preproc.y"
    { output_statement(yyvsp[0].str, 1, connection); }
    break;

  case 77:
#line 685 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 78:
#line 686 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 79:
#line 687 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 80:
#line 688 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 81:
#line 689 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 82:
#line 691 "preproc.y"
    {
			fprintf(yyout,"ECPGallocate_desc(__LINE__, %s);",yyvsp[0].str);
			whenever_action(0);
			free(yyvsp[0].str);
		}
    break;

  case 83:
#line 697 "preproc.y"
    {
			if (connection)
				mmerror(PARSE_ERROR, ET_ERROR, "no at option for connect statement.\n");

			fprintf(yyout, "{ ECPGconnect(__LINE__, %d, %s, %d); ", compat, yyvsp[0].str, autocommit);
			reset_variables();
			whenever_action(2);
			free(yyvsp[0].str);
		}
    break;

  case 84:
#line 707 "preproc.y"
    {
			output_simple_statement(yyvsp[0].str);
		}
    break;

  case 85:
#line 711 "preproc.y"
    {
			if (connection)
				mmerror(PARSE_ERROR, ET_ERROR, "no at option for deallocate statement.\n");
			fprintf(yyout, "{ ECPGdeallocate(__LINE__, %d, %s);", compat, yyvsp[0].str);
			whenever_action(2);
			free(yyvsp[0].str);
		}
    break;

  case 86:
#line 719 "preproc.y"
    {
			if (connection)
				mmerror(PARSE_ERROR, ET_ERROR, "no at option for deallocate statement.\n");
			fprintf(yyout,"ECPGdeallocate_desc(__LINE__, %s);",yyvsp[0].str);
			whenever_action(0);
			free(yyvsp[0].str);
		}
    break;

  case 87:
#line 727 "preproc.y"
    {
			output_simple_statement(yyvsp[0].str);
		}
    break;

  case 88:
#line 731 "preproc.y"
    {
			fprintf(yyout, "{ ECPGdescribe(__LINE__, %s,", yyvsp[0].str);
			dump_variables(argsresult, 1);
			fputs("ECPGt_EORT);", yyout);
			fprintf(yyout, "}");
			output_line_number();
				
			/* whenever_action(2); */
			free(yyvsp[0].str);
		}
    break;

  case 89:
#line 742 "preproc.y"
    {
			if (connection)
				mmerror(PARSE_ERROR, ET_ERROR, "no at option for disconnect statement.\n");

			fprintf(yyout, "{ ECPGdisconnect(__LINE__, %s);",
					yyvsp[0].str ? yyvsp[0].str : "\"CURRENT\"");
			whenever_action(2);
			free(yyvsp[0].str);
		}
    break;

  case 90:
#line 752 "preproc.y"
    {
			output_statement(yyvsp[0].str, 0, connection);
		}
    break;

  case 91:
#line 756 "preproc.y"
    {
			fprintf(yyout, "{ ECPGdeallocate(__LINE__, %d, \"%s\");", compat, yyvsp[0].str);

			whenever_action(2);
			free(yyvsp[0].str);
		}
    break;

  case 92:
#line 763 "preproc.y"
    {
			lookup_descriptor(yyvsp[0].descriptor.name, connection);
			output_get_descr(yyvsp[0].descriptor.name, yyvsp[0].descriptor.str);
			free(yyvsp[0].descriptor.name);
			free(yyvsp[0].descriptor.str);
		}
    break;

  case 93:
#line 770 "preproc.y"
    {
			lookup_descriptor(yyvsp[0].str, connection);
			output_get_descr_header(yyvsp[0].str);
			free(yyvsp[0].str);
		}
    break;

  case 94:
#line 776 "preproc.y"
    {
			struct cursor *ptr;

			if ((ptr = add_additional_variables(yyvsp[0].str, true)) != NULL)
				output_statement(mm_strdup(ptr->command), 0, ptr->connection ? mm_strdup(ptr->connection) : NULL);
		}
    break;

  case 95:
#line 783 "preproc.y"
    {
			if (connection)
				mmerror(PARSE_ERROR, ET_ERROR, "no at option for prepare statement.\n");

			fprintf(yyout, "{ ECPGprepare(__LINE__, %s);", yyvsp[0].str);
			whenever_action(2);
			free(yyvsp[0].str);
		}
    break;

  case 96:
#line 791 "preproc.y"
    { /* output already done */ }
    break;

  case 97:
#line 793 "preproc.y"
    {
			fprintf(yyout, "{ ECPGsetcommit(__LINE__, \"%s\", %s);", yyvsp[0].str, connection ? connection : "NULL");
			whenever_action(2);
			free(yyvsp[0].str);
		}
    break;

  case 98:
#line 799 "preproc.y"
    {
			if (connection)
				mmerror(PARSE_ERROR, ET_ERROR, "no at option for set connection statement.\n");

			fprintf(yyout, "{ ECPGsetconn(__LINE__, %s);", yyvsp[0].str);
			whenever_action(2);
			free(yyvsp[0].str);
		}
    break;

  case 99:
#line 808 "preproc.y"
    {
			if (connection)
				mmerror(PARSE_ERROR, ET_ERROR, "no at option for typedef statement.\n");

			fprintf(yyout, "%s", yyvsp[0].str);
			free(yyvsp[0].str);
			output_line_number();
		}
    break;

  case 100:
#line 817 "preproc.y"
    {
			if (connection)
				mmerror(PARSE_ERROR, ET_ERROR, "no at option for var statement.\n");

			output_simple_statement(yyvsp[0].str);
		}
    break;

  case 101:
#line 824 "preproc.y"
    {
			if (connection)
				mmerror(PARSE_ERROR, ET_ERROR, "no at option for whenever statement.\n");

			output_simple_statement(yyvsp[0].str);
		}
    break;

  case 102:
#line 845 "preproc.y"
    { yyval.str = cat_str(4, make_str("create user"), yyvsp[-2].str, make_str("with"), yyvsp[0].str); }
    break;

  case 103:
#line 848 "preproc.y"
    { yyval.str = make_str("with"); }
    break;

  case 104:
#line 849 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 105:
#line 861 "preproc.y"
    { yyval.str = cat_str(3, make_str("alter user"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 106:
#line 863 "preproc.y"
    { yyval.str = cat_str(4, make_str("alter user"), yyvsp[-2].str, make_str("with"), yyvsp[0].str); }
    break;

  case 107:
#line 867 "preproc.y"
    { yyval.str = cat_str(4, make_str("alter user"), yyvsp[-2].str, make_str("set"), yyvsp[0].str); }
    break;

  case 108:
#line 869 "preproc.y"
    { yyval.str = cat_str(3, make_str("alter user"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 109:
#line 879 "preproc.y"
    { yyval.str = cat2_str(make_str("drop user"), yyvsp[0].str);}
    break;

  case 110:
#line 885 "preproc.y"
    { yyval.str = cat2_str(yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 111:
#line 886 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 112:
#line 890 "preproc.y"
    { yyval.str = cat2_str(make_str("password"), yyvsp[0].str); }
    break;

  case 113:
#line 892 "preproc.y"
    { yyval.str = cat2_str(make_str("sysid"), yyvsp[0].str); }
    break;

  case 114:
#line 894 "preproc.y"
    { yyval.str = make_str("createdb"); }
    break;

  case 115:
#line 896 "preproc.y"
    { yyval.str = make_str("nocreatedb"); }
    break;

  case 116:
#line 898 "preproc.y"
    { yyval.str = make_str("createuser"); }
    break;

  case 117:
#line 900 "preproc.y"
    { yyval.str = make_str("nocreateuser"); }
    break;

  case 118:
#line 902 "preproc.y"
    { yyval.str = cat2_str(make_str("in group"), yyvsp[0].str); }
    break;

  case 119:
#line 904 "preproc.y"
    { yyval.str = cat2_str(make_str("valid until"), yyvsp[0].str); }
    break;

  case 120:
#line 908 "preproc.y"
    { yyval.str = cat_str(3, yyvsp[-2].str, make_str(","), yyvsp[0].str); }
    break;

  case 121:
#line 910 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 122:
#line 920 "preproc.y"
    { yyval.str = cat_str(3, make_str("create group"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 123:
#line 922 "preproc.y"
    { yyval.str = cat_str(4, make_str("create group"), yyvsp[-2].str, make_str("with"), yyvsp[0].str); }
    break;

  case 124:
#line 928 "preproc.y"
    { yyval.str = cat2_str(yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 125:
#line 929 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 126:
#line 933 "preproc.y"
    { yyval.str = cat2_str(make_str("user"), yyvsp[0].str); }
    break;

  case 127:
#line 935 "preproc.y"
    { yyval.str = cat2_str(make_str("sysid"), yyvsp[0].str); }
    break;

  case 128:
#line 946 "preproc.y"
    { yyval.str = cat_str(4, make_str("alter group"), yyvsp[-3].str, make_str("add user"), yyvsp[0].str); }
    break;

  case 129:
#line 948 "preproc.y"
    { yyval.str = cat_str(4, make_str("alter group"), yyvsp[-3].str, make_str("drop user"), yyvsp[0].str); }
    break;

  case 130:
#line 958 "preproc.y"
    { yyval.str = cat2_str(make_str("drop group"), yyvsp[0].str); }
    break;

  case 131:
#line 969 "preproc.y"
    { yyval.str = cat_str(6, make_str("create schema"), yyvsp[-4].str, yyvsp[-3].str, make_str("authorization"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 132:
#line 971 "preproc.y"
    { yyval.str = cat_str(3, make_str("create schema"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 133:
#line 974 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 134:
#line 975 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 135:
#line 978 "preproc.y"
    { yyval.str = cat2_str(yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 136:
#line 979 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 137:
#line 986 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 138:
#line 987 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 139:
#line 988 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 140:
#line 1002 "preproc.y"
    { yyval.str = cat2_str(make_str("set"), yyvsp[0].str ); }
    break;

  case 141:
#line 1004 "preproc.y"
    { yyval.str = cat2_str(make_str("set local"), yyvsp[0].str ); }
    break;

  case 142:
#line 1006 "preproc.y"
    { yyval.str = cat2_str(make_str("set session"), yyvsp[0].str ); }
    break;

  case 143:
#line 1010 "preproc.y"
    { yyval.str = cat_str(3, yyvsp[-2].str, make_str("to"), yyvsp[0].str); }
    break;

  case 144:
#line 1012 "preproc.y"
    { yyval.str = cat_str(3, yyvsp[-2].str, make_str("="), yyvsp[0].str); }
    break;

  case 145:
#line 1014 "preproc.y"
    { yyval.str = cat2_str(make_str("time zone"), yyvsp[0].str); }
    break;

  case 146:
#line 1016 "preproc.y"
    { yyval.str = cat2_str(make_str("transaction"), yyvsp[0].str); }
    break;

  case 147:
#line 1018 "preproc.y"
    { yyval.str = cat2_str(make_str("session characteristics as transaction"), yyvsp[0].str); }
    break;

  case 148:
#line 1020 "preproc.y"
    { yyval.str = cat2_str(make_str("names"), yyvsp[0].str); }
    break;

  case 149:
#line 1022 "preproc.y"
    { yyval.str = cat2_str(make_str("session authorization"), yyvsp[0].str); }
    break;

  case 150:
#line 1024 "preproc.y"
    { yyval.str = make_str("session authorization default"); }
    break;

  case 151:
#line 1028 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 152:
#line 1030 "preproc.y"
    { yyval.str = make_str("default"); }
    break;

  case 153:
#line 1034 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 154:
#line 1036 "preproc.y"
    { yyval.str = cat_str(3, yyvsp[-2].str, make_str(","), yyvsp[0].str); }
    break;

  case 155:
#line 1039 "preproc.y"
    { yyval.str = make_str("read committed"); }
    break;

  case 156:
#line 1040 "preproc.y"
    { yyval.str = make_str("serializable"); }
    break;

  case 157:
#line 1043 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 158:
#line 1044 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 159:
#line 1045 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 160:
#line 1048 "preproc.y"
    { yyval.str = make_str("true"); }
    break;

  case 161:
#line 1049 "preproc.y"
    { yyval.str = make_str("false"); }
    break;

  case 162:
#line 1050 "preproc.y"
    { yyval.str = make_str("on"); }
    break;

  case 163:
#line 1051 "preproc.y"
    { yyval.str = make_str("off"); }
    break;

  case 164:
#line 1061 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 165:
#line 1062 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 166:
#line 1064 "preproc.y"
    { yyval.str = cat_str(3, yyvsp[-2].str, yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 167:
#line 1066 "preproc.y"
    { yyval.str = cat_str(6, yyvsp[-5].str, make_str("("), yyvsp[-3].str, make_str(")"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 168:
#line 1068 "preproc.y"
    { yyval.str = make_str("default"); }
    break;

  case 169:
#line 1070 "preproc.y"
    { yyval.str = make_str("local"); }
    break;

  case 170:
#line 1073 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 171:
#line 1074 "preproc.y"
    { yyval.str = make_str("default"); }
    break;

  case 172:
#line 1075 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 173:
#line 1078 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 174:
#line 1079 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 175:
#line 1083 "preproc.y"
    { yyval.str = cat2_str(make_str("show"), yyvsp[0].str); }
    break;

  case 176:
#line 1085 "preproc.y"
    { yyval.str = make_str("show time zone"); }
    break;

  case 177:
#line 1087 "preproc.y"
    { yyval.str = make_str("show transaction isolation level"); }
    break;

  case 178:
#line 1089 "preproc.y"
    { yyval.str = make_str("show session authorization"); }
    break;

  case 179:
#line 1091 "preproc.y"
    { yyval.str = make_str("show all"); }
    break;

  case 180:
#line 1095 "preproc.y"
    { yyval.str = cat2_str(make_str("reset"), yyvsp[0].str); }
    break;

  case 181:
#line 1097 "preproc.y"
    { yyval.str = make_str("reset time zone"); }
    break;

  case 182:
#line 1099 "preproc.y"
    { yyval.str = make_str("reset transaction isolation level"); }
    break;

  case 183:
#line 1101 "preproc.y"
    { yyval.str = make_str("reset session authorization"); }
    break;

  case 184:
#line 1103 "preproc.y"
    { yyval.str = make_str("reset all"); }
    break;

  case 185:
#line 1107 "preproc.y"
    { yyval.str = cat_str(3, make_str("set constraints"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 186:
#line 1111 "preproc.y"
    { yyval.str = make_str("all"); }
    break;

  case 187:
#line 1113 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 188:
#line 1116 "preproc.y"
    { yyval.str = make_str("deferred"); }
    break;

  case 189:
#line 1117 "preproc.y"
    { yyval.str = make_str("immediate"); }
    break;

  case 190:
#line 1123 "preproc.y"
    { yyval.str= make_str("checkpoint"); }
    break;

  case 191:
#line 1136 "preproc.y"
    { yyval.str = cat_str(5, make_str("alter table"), yyvsp[-3].str, make_str("add"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 192:
#line 1139 "preproc.y"
    { yyval.str = cat_str(6, make_str("alter table"), yyvsp[-4].str, make_str("alter"), yyvsp[-2].str, yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 193:
#line 1142 "preproc.y"
    { yyval.str = cat_str(6, make_str("alter table"), yyvsp[-6].str, make_str("alter"), yyvsp[-4].str, yyvsp[-3].str, make_str("drop not null")); }
    break;

  case 194:
#line 1145 "preproc.y"
    { yyval.str = cat_str(6, make_str("alter table"), yyvsp[-6].str, make_str("alter"), yyvsp[-4].str, yyvsp[-3].str, make_str("set not null")); }
    break;

  case 195:
#line 1148 "preproc.y"
    { yyval.str = cat_str(7, make_str("alter table"), yyvsp[-6].str, make_str("alter"), yyvsp[-4].str, yyvsp[-3].str, make_str("set statistics"), yyvsp[0].str); }
    break;

  case 196:
#line 1151 "preproc.y"
    { yyval.str = cat_str(7, make_str("alter table"), yyvsp[-6].str, make_str("alter"), yyvsp[-4].str, yyvsp[-3].str, make_str("set storage"), yyvsp[0].str); }
    break;

  case 197:
#line 1154 "preproc.y"
    { yyval.str = cat_str(6, make_str("alter table"), yyvsp[-4].str, make_str("drop"), yyvsp[-2].str, yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 198:
#line 1157 "preproc.y"
    { yyval.str = cat_str(4, make_str("alter table"), yyvsp[-2].str, make_str("add"), yyvsp[0].str); }
    break;

  case 199:
#line 1160 "preproc.y"
    { yyval.str = cat_str(5, make_str("alter table"), yyvsp[-4].str, make_str("drop constraint"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 200:
#line 1163 "preproc.y"
    { yyval.str = cat_str(3, make_str("alter table"), yyvsp[-3].str, make_str("set without oids")); }
    break;

  case 201:
#line 1166 "preproc.y"
    { yyval.str = cat_str(3, make_str("alter table"), yyvsp[-3].str, make_str("create toast table")); }
    break;

  case 202:
#line 1169 "preproc.y"
    { yyval.str = cat_str(4, make_str("alter table"), yyvsp[-3].str, make_str("owner to"), yyvsp[0].str); }
    break;

  case 203:
#line 1172 "preproc.y"
    { yyval.str = cat_str(4, make_str("alter table"), yyvsp[-3].str, make_str("cluster on"), yyvsp[0].str); }
    break;

  case 204:
#line 1176 "preproc.y"
    { yyval.str = cat2_str(make_str("set default"), yyvsp[0].str); }
    break;

  case 205:
#line 1177 "preproc.y"
    { yyval.str = make_str("drop default"); }
    break;

  case 206:
#line 1180 "preproc.y"
    { yyval.str = make_str("cascade"); }
    break;

  case 207:
#line 1181 "preproc.y"
    { yyval.str = make_str("restrict"); }
    break;

  case 208:
#line 1182 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 209:
#line 1193 "preproc.y"
    {
			yyval.str = cat2_str(make_str("close"), yyvsp[0].str);
		}
    break;

  case 210:
#line 1208 "preproc.y"
    { yyval.str = cat_str(9, make_str("copy"), yyvsp[-7].str, yyvsp[-6].str, yyvsp[-5].str, yyvsp[-4].str, yyvsp[-3].str, yyvsp[-2].str, yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 211:
#line 1211 "preproc.y"
    { yyval.str = make_str("to"); }
    break;

  case 212:
#line 1212 "preproc.y"
    { yyval.str = make_str("from"); }
    break;

  case 213:
#line 1220 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 214:
#line 1221 "preproc.y"
    { yyval.str = make_str("stdin"); }
    break;

  case 215:
#line 1222 "preproc.y"
    { yyval.str = make_str("stdout"); }
    break;

  case 216:
#line 1225 "preproc.y"
    { yyval.str = cat2_str(yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 217:
#line 1226 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 218:
#line 1229 "preproc.y"
    { yyval.str = make_str("binary"); }
    break;

  case 219:
#line 1230 "preproc.y"
    { yyval.str = make_str("oids"); }
    break;

  case 220:
#line 1232 "preproc.y"
    { yyval.str = cat_str(3, make_str("delimiter"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 221:
#line 1234 "preproc.y"
    { yyval.str = cat_str(3, make_str("null"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 222:
#line 1237 "preproc.y"
    { yyval.str = make_str("binary"); }
    break;

  case 223:
#line 1238 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 224:
#line 1241 "preproc.y"
    { yyval.str = make_str("with oids"); }
    break;

  case 225:
#line 1242 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 226:
#line 1250 "preproc.y"
    { yyval.str = cat_str(3, yyvsp[-2].str, make_str("delimiters"), yyvsp[0].str); }
    break;

  case 227:
#line 1252 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 228:
#line 1255 "preproc.y"
    { yyval.str = make_str("using"); }
    break;

  case 229:
#line 1256 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 230:
#line 1268 "preproc.y"
    { yyval.str = cat_str(10, make_str("create"), yyvsp[-8].str, make_str("table"), yyvsp[-6].str, make_str("("), yyvsp[-4].str, make_str(")"), yyvsp[-2].str, yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 231:
#line 1271 "preproc.y"
    { yyval.str = cat_str(11, make_str("create"), yyvsp[-9].str, make_str("table"), yyvsp[-7].str, make_str("of"), yyvsp[-5].str, make_str("("), yyvsp[-3].str, make_str(")"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 232:
#line 1279 "preproc.y"
    { yyval.str = make_str("temporary"); }
    break;

  case 233:
#line 1280 "preproc.y"
    { yyval.str = make_str("temp"); }
    break;

  case 234:
#line 1281 "preproc.y"
    { yyval.str = make_str("local temporary"); }
    break;

  case 235:
#line 1282 "preproc.y"
    { yyval.str = make_str("local temp"); }
    break;

  case 236:
#line 1283 "preproc.y"
    { yyval.str = make_str("global temporary"); }
    break;

  case 237:
#line 1284 "preproc.y"
    { yyval.str = make_str("global temp"); }
    break;

  case 238:
#line 1285 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 239:
#line 1290 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 240:
#line 1292 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 241:
#line 1295 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 242:
#line 1297 "preproc.y"
    { yyval.str = cat_str(3, yyvsp[-2].str, make_str(","), yyvsp[0].str); }
    break;

  case 243:
#line 1300 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 244:
#line 1301 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 245:
#line 1302 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 246:
#line 1306 "preproc.y"
    {
			yyval.str = cat_str(3, yyvsp[-2].str, yyvsp[-1].str, yyvsp[0].str);
		}
    break;

  case 247:
#line 1311 "preproc.y"
    { yyval.str = cat2_str(yyvsp[-1].str,yyvsp[0].str); }
    break;

  case 248:
#line 1312 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 249:
#line 1316 "preproc.y"
    { yyval.str = cat_str(3, make_str("constraint"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 250:
#line 1317 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 251:
#line 1318 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 252:
#line 1333 "preproc.y"
    { yyval.str = make_str("not null"); }
    break;

  case 253:
#line 1335 "preproc.y"
    { yyval.str = make_str("null"); }
    break;

  case 254:
#line 1337 "preproc.y"
    { yyval.str = make_str("unique"); }
    break;

  case 255:
#line 1339 "preproc.y"
    { yyval.str = make_str("primary key"); }
    break;

  case 256:
#line 1341 "preproc.y"
    { yyval.str = cat_str(3, make_str("check ("), yyvsp[-1].str, make_str(")")); }
    break;

  case 257:
#line 1343 "preproc.y"
    { yyval.str = cat2_str(make_str("default"), yyvsp[0].str); }
    break;

  case 258:
#line 1345 "preproc.y"
    { yyval.str = cat_str(5, make_str("references"), yyvsp[-3].str, yyvsp[-2].str, yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 259:
#line 1359 "preproc.y"
    { yyval.str = make_str("deferrable"); }
    break;

  case 260:
#line 1360 "preproc.y"
    { yyval.str = make_str("not deferrable"); }
    break;

  case 261:
#line 1361 "preproc.y"
    { yyval.str = make_str("initially deferred"); }
    break;

  case 262:
#line 1362 "preproc.y"
    { yyval.str = make_str("initially immediate"); }
    break;

  case 263:
#line 1366 "preproc.y"
    {
			yyval.str = cat_str(3, make_str("like"), yyvsp[-1].str, yyvsp[0].str);
		}
    break;

  case 264:
#line 1372 "preproc.y"
    { yyval.str = make_str("including defaults"); }
    break;

  case 265:
#line 1373 "preproc.y"
    { yyval.str = make_str("excluding defaults"); }
    break;

  case 266:
#line 1374 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 267:
#line 1382 "preproc.y"
    { yyval.str = cat_str(3, make_str("constraint"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 268:
#line 1384 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 269:
#line 1388 "preproc.y"
    { yyval.str = cat_str(3, make_str("check("), yyvsp[-1].str, make_str(")")); }
    break;

  case 270:
#line 1390 "preproc.y"
    { yyval.str = cat_str(3, make_str("unique("), yyvsp[-1].str, make_str(")")); }
    break;

  case 271:
#line 1392 "preproc.y"
    { yyval.str = cat_str(3, make_str("primary key("), yyvsp[-1].str, make_str(")")); }
    break;

  case 272:
#line 1395 "preproc.y"
    { yyval.str = cat_str(8, make_str("foreign key("), yyvsp[-7].str, make_str(") references"), yyvsp[-4].str, yyvsp[-3].str, yyvsp[-2].str, yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 273:
#line 1398 "preproc.y"
    { yyval.str = cat_str(3, make_str("("), yyvsp[-1].str, make_str(")")); }
    break;

  case 274:
#line 1399 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 275:
#line 1403 "preproc.y"
    { yyval.str = cat_str(3, yyvsp[-2].str, make_str(","), yyvsp[0].str); }
    break;

  case 276:
#line 1405 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 277:
#line 1408 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 278:
#line 1412 "preproc.y"
    { yyval.str = make_str("match full"); }
    break;

  case 279:
#line 1414 "preproc.y"
    {
			mmerror(PARSE_ERROR, ET_WARNING, "Currently unsupported FOREIGN KEY/MATCH PARTIAL will be passed to backend");
			yyval.str = make_str("match partial");
		}
    break;

  case 280:
#line 1419 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 281:
#line 1422 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 282:
#line 1423 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 283:
#line 1424 "preproc.y"
    { yyval.str = cat2_str(yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 284:
#line 1425 "preproc.y"
    { yyval.str = cat2_str(yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 285:
#line 1426 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 286:
#line 1430 "preproc.y"
    { yyval.str = cat2_str(make_str("on delete"), yyvsp[0].str); }
    break;

  case 287:
#line 1434 "preproc.y"
    { yyval.str = cat2_str(make_str("on update"), yyvsp[0].str); }
    break;

  case 288:
#line 1437 "preproc.y"
    { yyval.str = make_str("no action"); }
    break;

  case 289:
#line 1438 "preproc.y"
    { yyval.str = make_str("restrict"); }
    break;

  case 290:
#line 1439 "preproc.y"
    { yyval.str = make_str("cascade"); }
    break;

  case 291:
#line 1440 "preproc.y"
    { yyval.str = make_str("set default"); }
    break;

  case 292:
#line 1441 "preproc.y"
    { yyval.str = make_str("set null"); }
    break;

  case 293:
#line 1445 "preproc.y"
    { yyval.str = cat_str(3, make_str("inherits ("), yyvsp[-1].str, make_str(")")); }
    break;

  case 294:
#line 1447 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 295:
#line 1450 "preproc.y"
    { yyval.str = make_str("with oids"); }
    break;

  case 296:
#line 1451 "preproc.y"
    { yyval.str = make_str("without oids"); }
    break;

  case 297:
#line 1452 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 298:
#line 1455 "preproc.y"
    { yyval.str = make_str("on commit drop"); }
    break;

  case 299:
#line 1456 "preproc.y"
    { yyval.str = make_str("on commit delete rows"); }
    break;

  case 300:
#line 1457 "preproc.y"
    { yyval.str = make_str("on commit preserve rows"); }
    break;

  case 301:
#line 1458 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 302:
#line 1468 "preproc.y"
    { FoundInto = 0; }
    break;

  case 303:
#line 1470 "preproc.y"
    {
			if (FoundInto == 1)
				mmerror(PARSE_ERROR, ET_ERROR, "CREATE TABLE / AS SELECT may not specify INTO");

			yyval.str = cat_str(7, make_str("create"), yyvsp[-6].str, make_str("table"), yyvsp[-4].str, yyvsp[-3].str, make_str("as"), yyvsp[0].str);
		}
    break;

  case 304:
#line 1479 "preproc.y"
    { yyval.str = cat_str(3, make_str("("), yyvsp[-1].str, make_str(")")); }
    break;

  case 305:
#line 1481 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 306:
#line 1485 "preproc.y"
    { yyval.str = cat_str(3, yyvsp[-2].str, make_str(","), yyvsp[0].str); }
    break;

  case 307:
#line 1487 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 308:
#line 1490 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 309:
#line 1502 "preproc.y"
    { yyval.str = cat_str(4, make_str("create"), yyvsp[-3].str, make_str("sequence"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 310:
#line 1506 "preproc.y"
    { yyval.str = cat_str(3,make_str("alter sequence"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 311:
#line 1509 "preproc.y"
    { yyval.str = cat2_str(yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 312:
#line 1510 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 313:
#line 1514 "preproc.y"
    { yyval.str = cat2_str(make_str("cache"), yyvsp[0].str); }
    break;

  case 314:
#line 1516 "preproc.y"
    { yyval.str = make_str("cycle"); }
    break;

  case 315:
#line 1518 "preproc.y"
    { yyval.str = make_str("no cycle"); }
    break;

  case 316:
#line 1520 "preproc.y"
    { yyval.str = cat_str(3, make_str("increment"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 317:
#line 1522 "preproc.y"
    { yyval.str = cat2_str(make_str("maxvalue"), yyvsp[0].str)