##
##  snmpdx -- SNMP Daemon Extension
##  Copyright (c) 2003 The OSSP Project <http://www.ossp.org/>
##  Copyright (c) 2003 Ralf S. Engelschall <rse@engelschall.com>
##  Copyright (c) 2003 Cable & Wireless <http://www.cw.com/>
##
##  Permission to use, copy, modify, and distribute this software for
##  any purpose with or without fee is hereby granted, provided that
##  the above copyright notice and this permission notice appear in all
##  copies.
##
##  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
##  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
##  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
##  IN NO EVENT SHALL THE AUTHORS AND COPYRIGHT HOLDERS AND THEIR
##  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
##  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
##  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
##  USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
##  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
##  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
##  OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
##  SUCH DAMAGE.
##
##  hwProd: Hardware, Product
##

package My::Probe::hwProd;
our @ISA = qw(My::Probe);

sub oids ($) {
    my ($self) = @_;
    return $self->{-ctx}->{-mib}->oids("*.snmpdx.host.hardware.hwProd.*");
}

sub probe ($$) {
    my ($self, $obj) = @_;

    #   query hardware architecture via uname(1)
    my $uname = "uname";
    if    ($self->{-ctx}->{-platform}->id() =~ m/FreeBSD/i)       { $uname = "/usr/bin/uname"; }
    elsif ($self->{-ctx}->{-platform}->id() =~ m/(Linux|SunOS)/i) { $uname = "/bin/uname";     }
    my $out = $self->{-ctx}->{-sys}->run("$uname -m 2>/dev/null || $uname -p 2>/dev/null", "1d");
    my $arch = $out->{-stdout};
    $arch =~ s|^\s*(.+?)\s*$|$1|s;

    #   provide results
    if ($obj->{-name} =~ m|\.hwProdArch$|) {
        $obj->{-value} = $arch;
    }
    elsif ($obj->{-name} =~ m|\.hwProdName$|) {
        my $name = "NoName";
        if ($self->{-ctx}->{-platform}->id() =~ m/SunOS/i) {
            my $out = $self->{-ctx}->{-sys}->run("/usr/platform/`uname -i`/sbin/prtdiag", "1d");
            if ($out->{-stdout} =~ m|System\s+Configuration:\s+(.*?)\n|si) {
                #  System Configuration:  Sun Microsystems  sun4u Sun (TM) Enterprise 250 (2 X UltraSPARC-II 400MHz)
                #  System Configuration:  Sun Microsystems  sun4u Netra t1 (UltraSPARC-IIi 440MHz)
                #  System Configuration:  Sun Microsystems  sun4u Sun Ultra 450 (2 X UltraSPARC-II 248MHz)
                #  System Configuration:  Sun Microsystems  sun4u Sun Enterprise 420R (2 X UltraSPARC-II 450MHz)
                $name = $1;
                $name =~ s|\s+$arch||s;
                $name =~ s|(Sun Microsystems)\s+Sun|$1|si;
                $name =~ s|\s+\(TM\)||si;
            }
        }
        elsif ($arch =~ m/^(i?[3-6x]86|.*(pentium|athlon).*)$/i) {
            $name .= "-PC";
            if ($self->{-ctx}->{-platform}->id() =~ m/FreeBSD/i) {
                my $out = $self->{-ctx}->{-sys}->run("/sbin/sysctl -n hw.model", "1d");
                my $model = $out->{-stdout};
                $model =~ s/^\s*(.+?)\s*$/$1/s;
                $name .= " ($model)";
            }
        }
        $obj->{-value} = $name;
    }
    return;
}

1;

