##
##  snmpdx -- SNMP Daemon Extension
##  Copyright (c) 2003 The OSSP Project <http://www.ossp.org/>
##  Copyright (c) 2003 Ralf S. Engelschall <rse@engelschall.com>
##  Copyright (c) 2003 Cable & Wireless <http://www.cw.com/>
##
##  Permission to use, copy, modify, and distribute this software for
##  any purpose with or without fee is hereby granted, provided that
##  the above copyright notice and this permission notice appear in all
##  copies.
##
##  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
##  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
##  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
##  IN NO EVENT SHALL THE AUTHORS AND COPYRIGHT HOLDERS AND THEIR
##  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
##  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
##  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
##  USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
##  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
##  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
##  OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
##  SUCH DAMAGE.
##
##  sysProc: System Process Information
##

package My::Probe::sysProc;
our @ISA = qw(My::Probe);

sub oids ($) {
    my ($self) = @_;
    return $self->{-ctx}->{-mib}->oids("*.snmpdx.host.system.sysProc.*");
}

sub probe ($$) {
    my ($self, $obj) = @_;
    
    if ($obj->{-name} =~ m|\.sysProcMax$|) {
        if ($self->{-ctx}->{-platform}->id() =~ m/FreeBSD/i) {
            #   query system via sysctl(8)
            my $out = $self->{-ctx}->{-sys}->run("/sbin/sysctl -n kern.maxproc", "1d");
            $obj->{-value} = $out->{-stdout};
            $obj->{-value} =~ s/^\s*(.+?)\s*$/$1/s;
        }
        elsif ($self->{-ctx}->{-platform}->id() =~ m/Linux/i) {
            #   query system via /proc or sysctl(8)
            my $out = $self->{-ctx}->{-sys}->run(
                "cat /proc/sys/kernel/threads-max 2>&1 || " .
                "/sbin/sysctl kernel/threads-max", "1d");
            $obj->{-value} = $out->{-stdout};
            $obj->{-value} =~ s/^[^\d]*(\d+).*$/$1/s;
        }
        elsif ($self->{-ctx}->{-platform}->id() =~ m/SunOS/i) {
            #   query system via sysdef(8)
            my $out = $self->{-ctx}->{-sys}->run("/usr/sbin/sysdef -i", "1d");
            if ($out->{-stdout} =~ m/\s*(\d+)\s+maximum number of processes/s) {
                $obj->{-value} = $1;
            }
        }
    }
    elsif ($obj->{-name} =~ m|\.sysProcActive$|) {
        #   query system via ps(1)
        my $ps = "ps";
        if    ($self->{-ctx}->{-platform}->id() =~ m/FreeBSD/i) { $ps = "/bin/ps -ax"; }
        elsif ($self->{-ctx}->{-platform}->id() =~ m/Linux/i)   { $ps = "/bin/ps ax";  }
        elsif ($self->{-ctx}->{-platform}->id() =~ m/SunOS/i)   { $ps = "/bin/ps -e";  }
        my $out = $self->{-ctx}->{-sys}->run($ps, "1m");
        my @lines = split(/\n/, $out->{-stdout});
        $obj->{-value} = ($#lines+1);
    }
    return;
}

1;

