##
##  snmpdx -- SNMP Daemon Extension
##  Copyright (c) 2003 The OSSP Project <http://www.ossp.org/>
##  Copyright (c) 2003 Ralf S. Engelschall <rse@engelschall.com>
##  Copyright (c) 2003 Cable & Wireless <http://www.cw.com/>
##
##  Permission to use, copy, modify, and distribute this software for
##  any purpose with or without fee is hereby granted, provided that
##  the above copyright notice and this permission notice appear in all
##  copies.
##
##  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
##  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
##  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
##  IN NO EVENT SHALL THE AUTHORS AND COPYRIGHT HOLDERS AND THEIR
##  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
##  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
##  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
##  USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
##  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
##  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
##  OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
##  SUCH DAMAGE.
##
##  swOs: Software, Operating System
##

package My::Probe::swOs;
our @ISA = qw(My::Probe);

sub oids ($) {
    my ($self) = @_;
    return $self->{-ctx}->{-mib}->oids("*.snmpdx.host.software.swOs.*");
}

sub probe ($$) {
    my ($self, $obj) = @_;

    #   query system via uname(1)
    my $uname = "uname";
    if    ($self->{-ctx}->{-platform}->id() =~ m/FreeBSD/i)       { $uname = "/usr/bin/uname"; }
    elsif ($self->{-ctx}->{-platform}->id() =~ m/(Linux|SunOS)/i) { $uname = "/bin/uname";     }
    my $out1 = $self->{-ctx}->{-sys}->run("$uname -s 2>/dev/null || echo 'Unix'", "1d");
    my $out2 = $self->{-ctx}->{-sys}->run("$uname -r 2>/dev/null || $uname -v 2>/dev/null", "1d");
    my $name = $out1->{-stdout}; $name =~ s|^\s*(.+?)\s*$|$1|s;
    my $vers = $out2->{-stdout}; $vers =~ s|^\s*(.+?)\s*$|$1|s;

    #   provide results
    if    ($obj->{-name} =~ m|\.swOsName$|)    { $obj->{-value} = $name; }
    elsif ($obj->{-name} =~ m|\.swOsVersion$|) { $obj->{-value} = $vers; }
    return;
}

1;

