##
##  snmpdx -- SNMP Daemon Extension
##  Copyright (c) 2003 The OSSP Project <http://www.ossp.org/>
##  Copyright (c) 2003 Ralf S. Engelschall <rse@engelschall.com>
##  Copyright (c) 2003 Cable & Wireless <http://www.cw.com/>
##
##  Permission to use, copy, modify, and distribute this software for
##  any purpose with or without fee is hereby granted, provided that
##  the above copyright notice and this permission notice appear in all
##  copies.
##
##  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
##  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
##  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
##  IN NO EVENT SHALL THE AUTHORS AND COPYRIGHT HOLDERS AND THEIR
##  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
##  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
##  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
##  USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
##  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
##  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
##  OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
##  SUCH DAMAGE.
##
##  hwRam: Hardware, RAM
##

package My::Probe::hwRam;
our @ISA = qw(My::Probe);

sub oids ($) {
    my ($self) = @_;
    return $self->{-ctx}->{-mib}->oids("*.snmpdx.host.hardware.hwRam.*");
}

sub probe ($$) {
    my ($self, $obj) = @_;
    my $arch = $self->{-ctx}->{-platform}->arch();

    if ($self->{-ctx}->{-platform}->id() =~ m/FreeBSD/i) {
        # hwRamMax    "/sbin/sysctl -n hw.physmem", convert bytes to MB
        # hwRamStatus N.A.
        #
        if ($obj->{-name} =~ m/\.hwRamMax$/) {
            my $hwRamMax    = undef;
            my $hwRamStatus = undef;

            #   local workspace
            my $out; my $raw;

            #   hwRamMax
            $out = $self->{-ctx}->{-sys}->run("/sbin/sysctl -n hw.physmem", "forever");
            $raw = $out->{-stdout};
            if ($raw =~ m/^(\d+)$/) {
                $hwRamMax = int($1 / 1024 / 1024);
            }
            $obj->{-value} = $hwRamMax;
        }
    }
    elsif ($self->{-ctx}->{-platform}->id() =~ m/Linux/i) {
        # hwRamMax    "/bin/dmesg", Memory, convert KB to MB
        # hwRamStatus N.A.
        #
        if ($obj->{-name} =~ m/\.hwRamMax$/) {
            my $hwRamMax    = undef;
            my $hwRamStatus = undef;

            #   local workspace
            my $out; my $raw;

            #   hwRamMax
            $out = $self->{-ctx}->{-sys}->run("/bin/dmesg", "forever");
            $raw = $out->{-stdout};
            if ($raw =~ m/\nMemory:\s+\d+k\/(\d+)k available/s) {
                $hwRamMax = int($1 / 1024);
            }
            $obj->{-value} = $hwRamMax;
        }
    }
    elsif ($self->{-ctx}->{-platform}->id() =~ m/SunOS/i) {
        # hwRamMax    "/usr/platform/$arch/sbin/prtdiag -v", Memory size
        # hwRamStatus N.A.
        #
        #FIXME set prtdiag cache expiry to "forever" when cache supports multiple caching times
        #
        if ($obj->{-name} =~ m/\.hwRam(Max|Status)$/) {
            my $hwRamMax    = undef;
            my $hwRamStatus = undef;

            #   local workspace
            my $out; my $raw; my $n2i; my @dat; my $arch;

            #   initialize arch
            $arch = $self->{-ctx}->{-platform}->arch();

            #   hwRamMax
            $out = $self->{-ctx}->{-sys}->run("/usr/platform/$arch/sbin/prtdiag -v", "1m");
            $raw = $out->{-stdout};
            if ($raw =~ m/\nMemory size: (\d+) Megabytes/s) {
                $hwRamMax = $1;
            }

            #   hwRamStatus
            $out = $self->{-ctx}->{-sys}->run("/usr/platform/$arch/sbin/prtdiag -v", "1m");
            $raw = $out->{-stdout};
            if ($raw =~ m/\n=+ Memory =+\n(.*?)\n=+/s) {
                $raw = $1;
                $hwRamStatus = 1;
                foreach $line (split "\n", $raw) {
                    my ($bank, $interleavegroup, $socketname, $size, $status) = split(" ", $line);
                    if ($bank =~ m/\d/) {
                        $hwRamStatus = 0 if ($status !~ /^OK$/);
                    }
                }
            }

            $obj->{-value} = $hwRamMax    if ($obj->{-name} =~ m/\.hwRamMax$/);
            $obj->{-value} = $hwRamStatus if ($obj->{-name} =~ m/\.hwRamStatus$/);
        }
    }
    return;
}

1;

