##
##  snmpdx -- SNMP Daemon Extension
##  Copyright (c) 2003 The OSSP Project <http://www.ossp.org/>
##  Copyright (c) 2003 Ralf S. Engelschall <rse@engelschall.com>
##  Copyright (c) 2003 Cable & Wireless <http://www.cw.com/>
##
##  Permission to use, copy, modify, and distribute this software for
##  any purpose with or without fee is hereby granted, provided that
##  the above copyright notice and this permission notice appear in all
##  copies.
##
##  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
##  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
##  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
##  IN NO EVENT SHALL THE AUTHORS AND COPYRIGHT HOLDERS AND THEIR
##  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
##  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
##  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
##  USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
##  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
##  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
##  OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
##  SUCH DAMAGE.
##
##  sysLoad: System Load Average
##

package My::Probe::sysLoad;
our @ISA = qw(My::Probe);

sub oids ($) {
    my ($self) = @_;
    return $self->{-ctx}->{-mib}->oids("*.snmpdx.host.system.sysLoad.*");
}

sub probe ($$) {
    my ($self, $obj) = @_;

    #   query system via uptime(1)
    my $uptime = "uptime";
    if ($self->{-ctx}->{-platform}->id() =~ m/(FreeBSD|Linux|SunOS)/i) {
        $uptime = "/usr/bin/uptime"
    }
    my $out = $self->{-ctx}->{-sys}->run($uptime, "1m");

    #   parse out details (example outputs follow)
    #   FreeBSD: "5:36PM  up 6 days, 54 mins, 9 users, load averages: 0.00, 0.02, 0.00"
    #   Linux:   "17:36:50 up 49 days,  8:16,  2 users,  load average: 0.00, 0.00, 0.00"
    #   SunOS:   "5:36pm  up 71 day(s),  3:29,  2 users,  load average: 0.16, 0.11, 0.13"
    my ($load5, $load10, $load15) = (0, 0, 0);
    if ($out->{-stdout} =~ m|load\s+averages?:\s+(\S+),\s+(\S+),\s+(\S+)|si) {
        ($load5, $load10, $load15) = ($1, $2, $3);
    }

    #   provide result
    if    ($obj->{-name} =~ m|\.sysLoad5$|)  { $obj->{-value} = sprintf("%d", $load5  * 100); }
    elsif ($obj->{-name} =~ m|\.sysLoad10$|) { $obj->{-value} = sprintf("%d", $load10 * 100); }
    elsif ($obj->{-name} =~ m|\.sysLoad15$|) { $obj->{-value} = sprintf("%d", $load15 * 100); }
    return;
}

1;

