##
##  snmpdx -- SNMP Daemon Extension
##  Copyright (c) 2003 The OSSP Project <http://www.ossp.org/>
##  Copyright (c) 2003 Ralf S. Engelschall <rse@engelschall.com>
##  Copyright (c) 2003 Cable & Wireless <http://www.cw.com/>
##
##  Permission to use, copy, modify, and distribute this software for
##  any purpose with or without fee is hereby granted, provided that
##  the above copyright notice and this permission notice appear in all
##  copies.
##
##  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
##  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
##  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
##  IN NO EVENT SHALL THE AUTHORS AND COPYRIGHT HOLDERS AND THEIR
##  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
##  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
##  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
##  USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
##  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
##  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
##  OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
##  SUCH DAMAGE.
##
##  swOp: Software, OpenPKG
##

package My::Probe::swOp;
our @ISA = qw(My::Probe);

sub oids ($) {
    my ($self) = @_;
    return $self->{-ctx}->{-mib}->oids("*.snmpdx.host.software.swOp.*");
}

sub probe ($$) {
    my ($self, $obj) = @_;

    #   query details via rpm(1)
    my $out = $self->{-ctx}->{-sys}->run(
        "rpm -qa --qf '[%{NAME} %{VERSION} %{RELEASE} %{BUILDTIME} %{INSTALLTIME}\\n]'", "10m");

    #   parse details into internal structure
    my $pkg = [];
    foreach my $entry (sort(split(/\n/, $out->{-stdout}))) {
        my ($p_n, $p_v, $p_r, $p_bt, $p_it) = split(/\s+/, $entry);
        next if ($p_n eq 'gpg-key');
        my $p = { -name => $p_n, -version => $p_v, -release => $p_r, -built => $p_bt, -installed => $p_it };
        push(@{$pkg}, $p);
    }

    #   provide result
    $self->{-ctx}->{-log}->printf(4, "name=%s", $obj->{-name});
    if ($obj->{-name} =~ m|\.swOpVersion$|) {
        #   OpenPKG instance *main* version
        my %release = ();
        foreach my $p (@{$pkg}) {
            my $r = $p->{-release};
            $r =~ s|^(\d+\.d+)\.\d+$|$1|s;
            $r =~ s|^\d{8}$|CURRENT|s;
            $release{$r}++;
        }
        my $release = (reverse sort { $release{$a} <=> $release{$b} } keys(%release))[0];
        $obj->{-value} = "OpenPKG-$release";
    }
    elsif ($obj->{-name} =~ m|\.swOpPkgENTRY\.([^.]+)\.(\d+)$|) {
        #   OpenPKG package list
        my $col = $1;
        my $row = ($2 > 0 ? $2 - 1 : 0);
        $self->{-ctx}->{-log}->printf(4, "col=%s row=%s", $col, $row);
        if (defined($pkg->[$row])) {
            if ($col eq 'swOpPkgIndex') {
                $obj->{-value} = $row;
            }
            elsif ($col eq 'swOpPkgName') {
                $obj->{-value} = $pkg->[$row]->{-name};
            }
            elsif ($col eq 'swOpPkgVersion') {
                $obj->{-value} = $pkg->[$row]->{-version};
            }
            elsif ($col eq 'swOpPkgRelease') {
                $obj->{-value} = $pkg->[$row]->{-release};
            }
            elsif ($col eq 'swOpPkgBuilt') {
                local ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) =
                    localtime($pkg->[$row]->{-built});
                $obj->{-value} = $self->{-ctx}->{-enc}->dat_encode(
                    sprintf("%04d-%02d-%02d %02d:%02d:%02d",
                        $year+1900, $mon+1, $mday, $hour, $min, $sec));
            }
            elsif ($col eq 'swOpPkgInstalled') {
                local ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) =
                    localtime($pkg->[$row]->{-installed});
                $obj->{-value} = $self->{-ctx}->{-enc}->dat_encode(
                    sprintf("%04d-%02d-%02d %02d:%02d:%02d",
                        $year+1900, $mon+1, $mday, $hour, $min, $sec));
            }
        }
    }
    return;
}

1;

